/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl.imexp;

import io.keikai.model.CellRegion;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SColumnArray;
import io.keikai.model.SComment;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SHyperlink;
import io.keikai.model.SName;
import io.keikai.model.SNamedStyle;
import io.keikai.model.SPictureData;
import io.keikai.model.SPrintSetup;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.STableStyle;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.ColumnArrayImpl;
import io.keikai.model.impl.TableNameImpl;
import io.keikai.model.util.Strings;
import io.keikai.range.impl.imexp.AbstractExporter;
import io.keikai.range.impl.imexp.BookHelper;
import io.keikai.range.impl.imexp.PoiEnumConversion;
import io.keikai.range.impl.imexp.UnitUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.zkoss.poi.ss.usermodel.Cell;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.ClientAnchor;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.Comment;
import org.zkoss.poi.ss.usermodel.CreationHelper;
import org.zkoss.poi.ss.usermodel.DataFormat;
import org.zkoss.poi.ss.usermodel.Drawing;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.Footer;
import org.zkoss.poi.ss.usermodel.Header;
import org.zkoss.poi.ss.usermodel.Hyperlink;
import org.zkoss.poi.ss.usermodel.Name;
import org.zkoss.poi.ss.usermodel.NamedStyle;
import org.zkoss.poi.ss.usermodel.PrintSetup;
import org.zkoss.poi.ss.usermodel.RichTextString;
import org.zkoss.poi.ss.usermodel.Row;
import org.zkoss.poi.ss.usermodel.Sheet;
import org.zkoss.poi.ss.usermodel.SheetProtection;
import org.zkoss.poi.ss.usermodel.TableStyle;
import org.zkoss.poi.ss.usermodel.Workbook;
import org.zkoss.poi.ss.util.CellRangeAddress;
import org.zkoss.util.logging.Log;

public abstract class AbstractExcelExporter
extends AbstractExporter {
    private static final long serialVersionUID = -453628222967064565L;
    protected static final int DEFAULT_ROW_HEIGHT = 20;
    protected Workbook workbook;
    protected Map<SCellStyle, CellStyle> styleTable = new HashMap<SCellStyle, CellStyle>();
    protected Map<SFont, Font> fontTable = new HashMap<SFont, Font>();
    protected Map<SColor, Color> colorTable = new HashMap<SColor, Color>();
    protected Map<Integer, Integer> exportedPicDataMap = new HashMap<Integer, Integer>();
    protected Map<STableStyle, TableStyle> tbStyleTable = new HashMap<STableStyle, TableStyle>();
    private static final Log _logger = Log.lookup((String)AbstractExcelExporter.class.getName());
    protected boolean _exportCache = false;

    protected abstract void exportColumnArray(SSheet var1, Sheet var2, SColumnArray var3);

    protected abstract Workbook createPoiBook();

    protected abstract void exportChart(SSheet var1, Sheet var2);

    protected abstract void exportPicture(SSheet var1, Sheet var2);

    protected abstract void exportValidation(SSheet var1, Sheet var2);

    protected abstract void exportAutoFilter(SSheet var1, Sheet var2);

    protected abstract void exportPassword(SSheet var1, Sheet var2);

    protected abstract int exportTables(SSheet var1, Sheet var2, int var3);

    protected abstract void exportConditionalFormatting(SSheet var1, Sheet var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void export(SBook book, OutputStream fos) throws IOException {
        ReadWriteLock lock = book.getBookSeries().getLock();
        lock.readLock().lock();
        try {
            void var5_16;
            Sheet poiSheet;
            SSheet sheet;
            void var5_14;
            this.styleTable.clear();
            this.fontTable.clear();
            this.colorTable.clear();
            this.tbStyleTable.clear();
            this.workbook = this.createPoiBook();
            this.workbook.clearDefaultCellStyles();
            for (SCellStyle sCellStyle : book.getDefaultCellStyles()) {
                CellStyle cellStyle = this.toPOIDefaultCellStyle(sCellStyle);
                this.workbook.addDefaultCellStyle(cellStyle);
                this.toPOICellStyle(sCellStyle);
            }
            this.workbook.clearNamedStyles();
            for (SNamedStyle sNamedStyle : book.getNamedStyles()) {
                NamedStyle poiStyle = this.toPOINamedStyle(sNamedStyle);
                this.workbook.addNamedStyle(poiStyle);
            }
            this.workbook.clearDxfCellStyles();
            for (SExtraStyle sExtraStyle : book.getExtraStyles()) {
                this.addPOIDxfCellStyle(sExtraStyle);
            }
            this.workbook.setDefaultPivotStyle(book.getDefaultPivotStyleName());
            this.workbook.setDefaultTableStyle(book.getDefaultTableStyleName());
            this.workbook.clearTableStyles();
            for (STableStyle sTableStyle : book.getTableStyles()) {
                this.addPOITableStyle(sTableStyle);
            }
            int tbId = 0;
            boolean bl = false;
            while (var5_14 < book.getSheets().size()) {
                sheet = book.getSheet((int)var5_14);
                this.exportSheet(sheet);
                poiSheet = this.workbook.getSheetAt((int)var5_14);
                tbId = this.exportTables(sheet, poiSheet, tbId);
                this.exportConditionalFormatting(sheet, poiSheet);
                ++var5_14;
            }
            this.exportNamedRange(book);
            this.exportPictureData(book);
            boolean bl2 = false;
            while (var5_16 < book.getSheets().size()) {
                sheet = book.getSheet((int)var5_16);
                poiSheet = this.workbook.getSheetAt((int)var5_16);
                this.exportRowColumn(sheet, poiSheet);
                this.exportMergedRegions(sheet, poiSheet);
                this.exportChart(sheet, poiSheet);
                this.exportPicture(sheet, poiSheet);
                this.exportValidation(sheet, poiSheet);
                this.exportAutoFilter(sheet, poiSheet);
                ++var5_16;
            }
            this.workbook.write(fos);
        }
        finally {
            lock.readLock().unlock();
        }
    }

    protected void exportPictureData(SBook book) {
        for (SPictureData picData : book.getPicturesDatas()) {
            int poiIndex = this.workbook.addPicture(picData.getData(), PoiEnumConversion.toPoiPictureFormat(picData.getFormat()));
            this.exportedPicDataMap.put(picData.getIndex(), poiIndex);
        }
    }

    protected void exportNamedRange(SBook book) {
        for (SName name : book.getNames()) {
            if (name instanceof TableNameImpl) continue;
            Name poiName = this.workbook.createName();
            try {
                String sheetName = name.getApplyToSheetName();
                if (sheetName != null) {
                    poiName.setSheetIndex(this.workbook.getSheetIndex(sheetName));
                }
                poiName.setNameName(name.getName());
                if (name.isFormulaParsingError()) continue;
                poiName.setRefersToFormula(name.getRefersToFormula());
            }
            catch (Exception e) {
                _logger.warning("Cannot export a name range: " + name.getName(), (Throwable)e);
                if (poiName.getNameName() == null) continue;
                this.workbook.removeName(poiName.getNameName());
            }
        }
    }

    protected void exportSheet(SSheet sheet) {
        CellRegion crgn;
        CellRegion rgn;
        int n;
        Sheet poiSheet = this.workbook.createSheet(sheet.getSheetName());
        int freezeRow = sheet.getViewInfo().getNumOfRowFreeze();
        int freezeCol = sheet.getViewInfo().getNumOfColumnFreeze();
        poiSheet.createFreezePane(freezeCol <= 0 ? 0 : freezeCol, freezeRow <= 0 ? 0 : freezeRow);
        poiSheet.setDisplayGridlines(sheet.getViewInfo().isDisplayGridlines());
        int[] nArray = sheet.getViewInfo().getRowBreaks();
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer rowIndex = nArray[n];
            poiSheet.setRowBreak(rowIndex.intValue());
        }
        nArray = sheet.getViewInfo().getColumnBreaks();
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer colIndex = nArray[n];
            poiSheet.setColumnBreak(colIndex.intValue());
        }
        this.exportSheetProtection(sheet, poiSheet);
        if (sheet.isProtected()) {
            poiSheet.protectSheet("");
            this.exportPassword(sheet, poiSheet);
        } else {
            poiSheet.protectSheet(null);
        }
        poiSheet.setDefaultRowHeight((short)UnitUtil.pxToTwip(sheet.getDefaultRowHeight()));
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        poiSheet.setDefaultColumnWidth(UnitUtil.pxToDefaultColumnWidth(sheet.getDefaultColumnWidth(), book.getCharWidth()));
        Header header = poiSheet.getHeader();
        header.setLeft(sheet.getViewInfo().getHeader().getLeftText());
        header.setCenter(sheet.getViewInfo().getHeader().getCenterText());
        header.setRight(sheet.getViewInfo().getHeader().getRightText());
        Footer footer = poiSheet.getFooter();
        footer.setLeft(sheet.getViewInfo().getFooter().getLeftText());
        footer.setCenter(sheet.getViewInfo().getFooter().getCenterText());
        footer.setRight(sheet.getViewInfo().getFooter().getRightText());
        SPrintSetup sps = sheet.getPrintSetup();
        poiSheet.setMargin((short)0, sps.getLeftMargin());
        poiSheet.setMargin((short)1, sps.getRightMargin());
        poiSheet.setMargin((short)2, sps.getTopMargin());
        poiSheet.setMargin((short)3, sps.getBottomMargin());
        poiSheet.setMargin((short)4, sps.getHeaderMargin());
        poiSheet.setMargin((short)5, sps.getFooterMargin());
        PrintSetup poips = poiSheet.getPrintSetup();
        if (sps.isDifferentOddEvenPage()) {
            SFooter evenFooter;
            SHeader evenHeader = sps.getEvenHeader();
            if (evenHeader != null) {
                Header poiEvenHeader = poiSheet.getEvenHeader();
                poiEvenHeader.setCenter(evenHeader.getCenterText());
                poiEvenHeader.setLeft(evenHeader.getLeftText());
                poiEvenHeader.setRight(evenHeader.getRightText());
            }
            if ((evenFooter = sps.getEvenFooter()) != null) {
                Footer poiEvenFooter = poiSheet.getEvenFooter();
                poiEvenFooter.setCenter(evenFooter.getCenterText());
                poiEvenFooter.setLeft(evenFooter.getLeftText());
                poiEvenFooter.setRight(evenFooter.getRightText());
            }
        }
        if (sps.isDifferentFirstPage()) {
            SFooter firstFooter;
            SHeader firstHeader = sps.getFirstHeader();
            if (firstHeader != null) {
                Header poiFirstHeader = poiSheet.getFirstHeader();
                poiFirstHeader.setCenter(firstHeader.getCenterText());
                poiFirstHeader.setLeft(firstHeader.getLeftText());
                poiFirstHeader.setRight(firstHeader.getRightText());
            }
            if ((firstFooter = sps.getFirstFooter()) != null) {
                Footer poiFirstFooter = poiSheet.getFirstFooter();
                poiFirstFooter.setCenter(firstFooter.getCenterText());
                poiFirstFooter.setLeft(firstFooter.getLeftText());
                poiFirstFooter.setRight(firstFooter.getRightText());
            }
        }
        poiSheet.setAlignMargins(sps.isAlignWithMargins());
        poips.setErrorsMode(sps.getErrorPrintMode());
        poips.setFitHeight((short)sps.getFitHeight());
        poips.setFitWidth((short)sps.getFitWidth());
        poiSheet.setHorizontallyCenter(sps.isHCenter());
        poiSheet.setVerticallyCenter(sps.isVCenter());
        poips.setLandscape(sps.isLandscape());
        poips.setLeftToRight(sps.isLeftToRight());
        int pageStart = sps.getPageStart();
        poips.setUsePage(pageStart > 0);
        poips.setPageStart((short)(pageStart > 0 ? pageStart : 0));
        poips.setPaperSize(PoiEnumConversion.toPoiPaperSize(sps.getPaperSize()));
        poips.setCommentsMode(sps.getCommentsMode());
        poiSheet.setPrintGridlines(sps.isPrintGridlines());
        poiSheet.setPrintHeadings(sps.isPrintHeadings());
        poips.setScale((short)sps.getScale());
        poiSheet.setScalWithDoc(sps.isScaleWithDoc());
        poiSheet.setDiffOddEven(sps.isDifferentOddEvenPage());
        poiSheet.setDiffFirst(sps.isDifferentFirstPage());
        int sheetIndex = this.workbook.getNumberOfSheets() - 1;
        String area = sps.getPrintArea();
        if (!Strings.isEmpty(area)) {
            this.workbook.setPrintArea(sheetIndex, area);
        }
        if ((rgn = sps.getRepeatingRowsTitle()) != null) {
            CellRangeAddress rowrng = new CellRangeAddress(rgn.getRow(), rgn.getLastRow(), -1, -1);
            poiSheet.setRepeatingRows(rowrng);
        }
        if ((crgn = sps.getRepeatingColumnsTitle()) != null) {
            CellRangeAddress colrng = new CellRangeAddress(-1, -1, crgn.getColumn(), crgn.getLastColumn());
            poiSheet.setRepeatingColumns(colrng);
        }
        int option = 0;
        switch (sheet.getSheetVisible()) {
            default: {
                option = 0;
                break;
            }
            case HIDDEN: {
                option = 1;
                break;
            }
            case VERY_HIDDEN: {
                option = 2;
            }
        }
        this.workbook.setSheetHidden(sheetIndex, option);
    }

    protected void exportMergedRegions(SSheet sheet, Sheet poiSheet) {
        for (int i = sheet.getNumOfMergedRegion() - 1; i >= 0; --i) {
            CellRegion region = sheet.getMergedRegion(i);
            poiSheet.addMergedRegion(new CellRangeAddress(region.row, region.lastRow, region.column, region.lastColumn));
        }
    }

    protected void exportRowColumn(SSheet sheet, Sheet poiSheet) {
        Iterator<SRow> rowIterator = sheet.getRowIterator();
        while (rowIterator.hasNext()) {
            SRow row = rowIterator.next();
            this.exportRow(sheet, poiSheet, row);
        }
        Iterator<SColumnArray> columnArrayIterator = sheet.getColumnArrayIterator();
        while (columnArrayIterator.hasNext()) {
            SColumnArray columnArr = columnArrayIterator.next();
            if (((ColumnArrayImpl)columnArr).shouldSkip()) continue;
            this.exportColumnArray(sheet, poiSheet, columnArr);
        }
    }

    protected void exportRow(SSheet sheet, Sheet poiSheet, SRow row) {
        Row poiRow = poiSheet.createRow(row.getIndex());
        if (row.isHidden()) {
            poiRow.setZeroHeight(true);
        } else if (row.isCustomHeight()) {
            poiRow.setCustomHeight(true);
            poiRow.setHeight((short)UnitUtil.pxToTwip(row.getHeight()));
        } else if (row.getHeight() != 20) {
            poiRow.setHeight((short)UnitUtil.pxToTwip(row.getHeight()));
        }
        SCellStyle rowStyle = row.getCellStyle();
        CellStyle poiRowStyle = this.toPOICellStyle(rowStyle);
        poiRow.setRowStyle(poiRowStyle);
        Iterator<SCell> cellIterator = sheet.getCellIterator(row.getIndex());
        while (cellIterator.hasNext()) {
            SCell cell = cellIterator.next();
            this.exportCell(poiRow, cell);
        }
    }

    protected void exportCell(Row poiRow, SCell cell) {
        SComment comment;
        Cell poiCell = poiRow.createCell(cell.getColumnIndex());
        SCellStyle cellStyle = cell.getCellStyle();
        poiCell.setCellStyle(this.toPOICellStyle(cellStyle));
        block1 : switch (cell.getType()) {
            case BLANK: {
                poiCell.setCellType(3);
                break;
            }
            case ERROR: {
                if (cell.getErrorValue().getCode() == 127) break;
                poiCell.setCellType(5);
                poiCell.setCellErrorValue(cell.getErrorValue().getCode());
                break;
            }
            case BOOLEAN: {
                poiCell.setCellType(4);
                poiCell.setCellValue(cell.getBooleanValue().booleanValue());
                break;
            }
            case FORMULA: {
                if (cell.getFormulaResultType() == SCell.CellType.ERROR && cell.getErrorValue().getCode() == 127) break;
                poiCell.setCellType(2);
                poiCell.setCellFormula(cell.getFormulaValue());
                if (!this.isExportCache()) break;
                switch (cell.getFormulaResultType()) {
                    default: {
                        break block1;
                    }
                    case BOOLEAN: {
                        poiCell.setCellValue(cell.getBooleanValue().booleanValue());
                        break block1;
                    }
                    case ERROR: {
                        poiCell.setCellErrorValue(cell.getErrorValue().getCode());
                        break block1;
                    }
                    case NUMBER: {
                        poiCell.setCellValue(cell.getNumberValue().doubleValue());
                        break block1;
                    }
                    case STRING: 
                }
                if (cell.isRichTextValue()) {
                    poiCell.setCellValue(this.toPOIRichText(cell.getRichTextValue()));
                    break;
                }
                poiCell.setCellValue(cell.getStringValue());
                break;
            }
            case NUMBER: {
                poiCell.setCellType(0);
                poiCell.setCellValue(cell.getNumberValue().doubleValue());
                break;
            }
            case STRING: {
                poiCell.setCellType(1);
                if (cell.isRichTextValue()) {
                    poiCell.setCellValue(this.toPOIRichText(cell.getRichTextValue()));
                    break;
                }
                poiCell.setCellValue(cell.getStringValue());
                break;
            }
        }
        SHyperlink hyperlink = cell.getHyperlink();
        if (hyperlink != null) {
            CreationHelper helper = this.workbook.getCreationHelper();
            try {
                Hyperlink poiHyperlink = helper.createHyperlink(PoiEnumConversion.toPoiHyperlinkType(hyperlink.getType()));
                poiHyperlink.setAddress(hyperlink.getAddress());
                poiHyperlink.setLabel(hyperlink.getLabel());
                poiCell.setHyperlink(poiHyperlink);
            }
            catch (Exception e) {
                _logger.warning("Cannot export a hyperlink: " + hyperlink.getAddress(), (Throwable)e);
            }
        }
        if ((comment = cell.getComment()) != null) {
            CreationHelper helper = this.workbook.getCreationHelper();
            Drawing drawing = poiCell.getSheet().createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(poiCell.getColumnIndex());
            anchor.setCol2(poiCell.getColumnIndex() + 1);
            anchor.setRow1(poiRow.getRowNum());
            anchor.setRow2(poiRow.getRowNum() + 3);
            Comment poiComment = drawing.createCellComment(anchor);
            SRichText richText = comment.getRichText();
            if (richText != null) {
                poiComment.setString(this.toPOIRichText(richText));
            } else {
                poiComment.setString(helper.createRichTextString(comment.getText()));
            }
            poiComment.setAuthor(comment.getAuthor());
            poiComment.setVisible(comment.isVisible());
            poiCell.setCellComment(poiComment);
        }
    }

    protected RichTextString toPOIRichText(SRichText richText) {
        CreationHelper helper = this.workbook.getCreationHelper();
        RichTextString poiRichTextString = helper.createRichTextString(richText.getText());
        int start = 0;
        int end = 0;
        for (SRichText.Segment sg : richText.getSegments()) {
            SFont font = sg.getFont();
            int len = sg.getText().length();
            poiRichTextString.applyFont(start, end += len, this.toPOIFont(font));
            start += len;
        }
        return poiRichTextString;
    }

    protected NamedStyle toPOINamedStyle(SNamedStyle cellStyle) {
        return this.workbook.createNamedStyle(cellStyle.getName(), cellStyle.isCustomBuiltin(), cellStyle.getBuiltinId(), cellStyle.getIndex());
    }

    protected CellStyle toPOIDefaultCellStyle(SCellStyle cellStyle) {
        return null;
    }

    protected CellStyle toPOICellStyle(SCellStyle cellStyle) {
        short index;
        CellStyle poiCellStyle = this.styleTable.get(cellStyle);
        if (poiCellStyle != null) {
            return poiCellStyle;
        }
        poiCellStyle = this.workbook.createCellStyle();
        short bottom = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderBottom());
        short left = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderLeft());
        short right = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderRight());
        short top = PoiEnumConversion.toPoiBorderType(cellStyle.getBorderTop());
        Color bottomColor = this.toPOIColor(cellStyle.getBorderBottomColor());
        Color leftColor = this.toPOIColor(cellStyle.getBorderLeftColor());
        Color rightColor = this.toPOIColor(cellStyle.getBorderRightColor());
        Color topColor = this.toPOIColor(cellStyle.getBorderTopColor());
        poiCellStyle.setBorder(left, leftColor, top, topColor, right, rightColor, bottom, bottomColor);
        SColor fgColor = cellStyle.getFillColor();
        SColor bgColor = cellStyle.getBackColor();
        if (cellStyle.getFillPattern() == SFill.FillPattern.SOLID) {
            SColor tmp = fgColor;
            fgColor = bgColor;
            bgColor = tmp;
        }
        Color fillColor = this.toPOIColor(fgColor);
        Color backColor = this.toPOIColor(bgColor);
        short pattern = PoiEnumConversion.toPoiFillPattern(cellStyle.getFillPattern());
        poiCellStyle.setFill(fillColor, backColor, pattern);
        short hAlign = PoiEnumConversion.toPoiHorizontalAlignment(cellStyle.getAlignment());
        short vAlign = PoiEnumConversion.toPoiVerticalAlignment(cellStyle.getVerticalAlignment());
        boolean wrapText = cellStyle.isWrapText();
        poiCellStyle.setCellAlignment(hAlign, vAlign, wrapText, (short)cellStyle.getRotation());
        boolean locked = cellStyle.isLocked();
        boolean hidden = cellStyle.isHidden();
        poiCellStyle.setProtection(locked, hidden);
        DataFormat dataFormat = this.workbook.createDataFormat();
        if (cellStyle.isDirectDataFormat()) {
            index = dataFormat.newFormat(cellStyle.getDataFormat());
            poiCellStyle.setDataFormat(index);
        } else {
            index = dataFormat.getFormat(cellStyle.getDataFormat());
            poiCellStyle.setDataFormat(index);
        }
        poiCellStyle.setFont(this.toPOIFont(cellStyle.getFont()));
        this.styleTable.put(cellStyle, poiCellStyle);
        int indention = cellStyle.getIndention();
        if (indention > 0) {
            poiCellStyle.setIndention((short)indention);
        }
        return poiCellStyle;
    }

    protected Color toPOIColor(SColor color) {
        if (color == null) {
            return null;
        }
        Color poiColor = this.colorTable.get(color);
        if (poiColor != null) {
            return poiColor;
        }
        poiColor = BookHelper.HTMLToColor(this.workbook, color.getHtmlColor());
        this.colorTable.put(color, poiColor);
        return poiColor;
    }

    protected Font toPOIFont(SFont font) {
        if (font == null) {
            return null;
        }
        Font poiFont = this.fontTable.get(font);
        if (poiFont != null) {
            return poiFont;
        }
        poiFont = this.workbook.createFont();
        poiFont.setBoldweight(PoiEnumConversion.toPoiBoldweight(font.getBoldweight()));
        poiFont.setStrikeout(font.isStrikeout());
        poiFont.setItalic(font.isItalic());
        BookHelper.setFontColor(this.workbook, poiFont, this.toPOIColor(font.getColor()));
        poiFont.setFontHeightInPoints((short)font.getHeightPoints());
        poiFont.setFontName(font.getName());
        poiFont.setTypeOffset(PoiEnumConversion.toPoiTypeOffset(font.getTypeOffset()));
        poiFont.setUnderline(PoiEnumConversion.toPoiUnderline(font.getUnderline()));
        this.fontTable.put(font, poiFont);
        return poiFont;
    }

    protected void exportSheetProtection(SSheet sheet, Sheet poiSheet) {
        SSheetProtection ssp = sheet.getSheetProtection();
        SheetProtection sp = poiSheet.getOrCreateSheetProtection();
        sp.setAutoFilter(ssp.isAutoFilter());
        sp.setDeleteColumns(ssp.isDeleteColumns());
        sp.setDeleteRows(ssp.isDeleteRows());
        sp.setFormatCells(ssp.isFormatCells());
        sp.setFormatColumns(ssp.isFormatColumns());
        sp.setFormatRows(ssp.isFormatRows());
        sp.setInsertColumns(ssp.isInsertColumns());
        sp.setInsertHyperlinks(ssp.isInsertHyperlinks());
        sp.setInsertRows(ssp.isInsertRows());
        sp.setPivotTables(ssp.isPivotTables());
        sp.setSort(ssp.isSort());
        sp.setObjects(ssp.isObjects());
        sp.setScenarios(ssp.isScenarios());
        sp.setSelectLockedCells(ssp.isSelectLockedCells());
        sp.setSelectUnlockedCells(ssp.isSelectUnlockedCells());
    }

    public void setExportCache(boolean b) {
        this._exportCache = b;
    }

    protected boolean isExportCache() {
        return this._exportCache;
    }

    protected void addPOIDxfCellStyle(SExtraStyle extraStyle) {
    }

    protected void addPOITableStyle(STableStyle tableStyle) {
    }
}

