/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellStyleHolder;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SColor;
import io.keikai.model.SConditionalStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SRichText;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.AbstractTableAdv;
import io.keikai.model.impl.RichTextImpl;
import io.keikai.model.util.CellStyleMatcher;
import io.keikai.model.util.FontMatcher;
import io.keikai.model.util.RichTextHelper;

public class StyleUtil {
    public static final short BORDER_EDGE_BOTTOM = 1;
    public static final short BORDER_EDGE_RIGHT = 2;
    public static final short BORDER_EDGE_TOP = 4;
    public static final short BORDER_EDGE_LEFT = 8;
    public static final short BORDER_EDGE_ALL = 15;

    public static SCellStyle cloneCellStyle(SCell cell) {
        SCellStyle destination = cell.getSheet().getBook().createCellStyle(cell.getCellStyle(), true);
        return destination;
    }

    public static SCellStyle cloneCellStyle(SBook book, SCellStyle style) {
        SCellStyle destination = book.createCellStyle(style, true);
        return destination;
    }

    public static void setFontColor(SBook book, CellStyleHolder holder, String color) {
        SColor newColor;
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SColor orgColor = orgFont.getColor();
        if (orgColor == (newColor = book.createColor(color)) || orgColor != null && orgColor.equals(newColor)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setColor(color);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setColor(newColor);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFillColor(SBook book, CellStyleHolder holder, String htmlColor) {
        SColor newColor;
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgColor = orgStyle.getFillColor();
        if (orgColor == (newColor = book.createColor(htmlColor)) || orgColor != null && orgColor.equals(newColor)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setBackColor(htmlColor);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFillColor(newColor);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setBackColor(SBook book, CellStyleHolder holder, String htmlColor) {
        SColor newColor;
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgColor = orgStyle.getBackColor();
        if (orgColor == (newColor = book.createColor(htmlColor)) || orgColor != null && orgColor.equals(newColor)) {
            return;
        }
        SFill.FillPattern pattern = orgStyle.getFillPattern();
        if (pattern == SFill.FillPattern.NONE && htmlColor != null) {
            pattern = SFill.FillPattern.SOLID;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setBackColor(htmlColor);
        matcher.setFillPattern(pattern);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setBackColor(newColor);
            style.setFillPattern(pattern);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFillOptions(SBook book, CellStyleHolder holder, String bgColor, String fillColor, SFill.FillPattern pattern) {
        SCellStyle orgStyle = holder.getCellStyle();
        SColor orgBackColor = orgStyle.getBackColor();
        SColor newBackColor = book.createColor(bgColor);
        SColor orgFillColor = orgStyle.getFillColor();
        SColor newFillColor = book.createColor(fillColor);
        SFill.FillPattern orgPattern = orgStyle.getFillPattern();
        if ((orgBackColor == newBackColor || orgBackColor != null && orgBackColor.equals(newBackColor)) && (orgFillColor == newFillColor || orgFillColor != null && orgFillColor.equals(newFillColor)) && orgPattern == pattern) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setBackColor(bgColor);
        matcher.setFillColor(fillColor);
        matcher.setFillPattern(pattern);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setBackColor(newBackColor);
            style.setFillColor(newFillColor);
            style.setFillPattern(pattern);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextWrap(SBook book, CellStyleHolder holder, boolean wrap) {
        SCellStyle orgStyle = holder.getCellStyle();
        boolean textWrap = orgStyle.isWrapText();
        if (wrap == textWrap) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setWrapText(wrap);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setWrapText(wrap);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontHeightPoints(SBook book, CellStyleHolder holder, int fontHeightPoints) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        int orgSize = orgFont.getHeightPoints();
        if (orgSize == fontHeightPoints) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setHeightPoints(fontHeightPoints);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setHeightPoints(fontHeightPoints);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontStrikethrough(SBook book, CellStyleHolder holder, boolean strikeout) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        boolean orgStrikeout = orgFont.isStrikeout();
        if (orgStrikeout == strikeout) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setStrikeout(strikeout);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setStrikeout(strikeout);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontName(SBook book, CellStyleHolder holder, String name) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        String orgName = orgFont.getName();
        if (orgName.equals(name)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setName(name);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setName(name);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setBorder(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)15);
    }

    public static void setBorderTop(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)4);
    }

    public static void setBorderLeft(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)8);
    }

    public static void setBorderBottom(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)1);
    }

    public static void setBorderRight(SBook book, CellStyleHolder holder, String color, SBorder.BorderType linestyle) {
        StyleUtil.setBorder(book, holder, color, linestyle, (short)2);
    }

    public static void setBorder(SBook book, CellStyleHolder holder, String htmlColor, SBorder.BorderType lineStyle, short at) {
        boolean hasBorder;
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle style = null;
        SColor color = book.createColor(htmlColor);
        boolean bl = hasBorder = lineStyle != SBorder.BorderType.NONE;
        if (htmlColor != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            if ((at & 8) != 0) {
                if (hasBorder) {
                    matcher.setBorderLeftColor(htmlColor);
                } else {
                    matcher.removeBorderLeftColor();
                }
                matcher.setBorderLeft(lineStyle);
            }
            if ((at & 4) != 0) {
                if (hasBorder) {
                    matcher.setBorderTopColor(htmlColor);
                } else {
                    matcher.removeBorderTopColor();
                }
                matcher.setBorderTop(lineStyle);
            }
            if ((at & 2) != 0) {
                if (hasBorder) {
                    matcher.setBorderRightColor(htmlColor);
                } else {
                    matcher.removeBorderRightColor();
                }
                matcher.setBorderRight(lineStyle);
            }
            if ((at & 1) != 0) {
                if (hasBorder) {
                    matcher.setBorderBottomColor(htmlColor);
                } else {
                    matcher.removeBorderBottomColor();
                }
                matcher.setBorderBottom(lineStyle);
            }
            style = book.searchCellStyle(matcher);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            if ((at & 8) != 0) {
                if (hasBorder) {
                    style.setBorderLeftColor(color);
                }
                style.setBorderLeft(lineStyle);
            }
            if ((at & 4) != 0) {
                if (hasBorder) {
                    style.setBorderTopColor(color);
                }
                style.setBorderTop(lineStyle);
            }
            if ((at & 2) != 0) {
                if (hasBorder) {
                    style.setBorderRightColor(color);
                }
                style.setBorderRight(lineStyle);
            }
            if ((at & 1) != 0) {
                if (hasBorder) {
                    style.setBorderBottomColor(color);
                }
                style.setBorderBottom(lineStyle);
            }
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontBoldWeight(SBook book, CellStyleHolder holder, SFont.Boldweight boldWeight) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.Boldweight orgBoldWeight = orgFont.getBoldweight();
        if (orgBoldWeight.equals((Object)boldWeight)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setBoldweight(boldWeight);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setBoldweight(boldWeight);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontItalic(SBook book, CellStyleHolder holder, boolean italic) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        boolean orgItalic = orgFont.isItalic();
        if (orgItalic == italic) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setItalic(italic);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setItalic(italic);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontUnderline(SBook book, CellStyleHolder holder, SFont.Underline underline) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.Underline orgUnderline = orgFont.getUnderline();
        if (orgUnderline.equals((Object)underline)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setUnderline(underline);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setUnderline(underline);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextHAlign(SBook book, CellStyleHolder holder, SCellStyle.Alignment align) {
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle.Alignment orgAlign = orgStyle.getAlignment();
        if (align.equals((Object)orgAlign)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setAlignment(align);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setAlignment(align);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextVAlign(SBook book, CellStyleHolder holder, SCellStyle.VerticalAlignment valign) {
        SCellStyle orgStyle = holder.getCellStyle();
        SCellStyle.VerticalAlignment orgValign = orgStyle.getVerticalAlignment();
        if (valign.equals((Object)orgValign)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setVerticalAlignment(valign);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setVerticalAlignment(valign);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setDataFormat(SBook book, CellStyleHolder holder, String format) {
        SCellStyle orgStyle = holder.getCellStyle();
        String orgFormat = orgStyle.getDataFormat();
        if (format == orgFormat || format != null && format.equals(orgFormat)) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setDataFormat(format);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setDataFormat(format);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setFontTypeOffset(SBook book, CellStyleHolder holder, SFont.TypeOffset offset) {
        SCellStyle orgStyle = holder.getCellStyle();
        SFont orgFont = orgStyle.getFont();
        SFont.TypeOffset orgOffset = orgFont.getTypeOffset();
        if (orgOffset.equals((Object)offset)) {
            return;
        }
        FontMatcher fontmatcher = new FontMatcher(orgFont);
        fontmatcher.setTypeOffset(offset);
        SFont font = book.searchFont(fontmatcher);
        SCellStyle style = null;
        if (font != null) {
            CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
            matcher.setFont(font);
            style = book.searchCellStyle(matcher);
        } else {
            font = book.createFont(orgFont, true);
            font.setTypeOffset(offset);
        }
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setFont(font);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static boolean setRichTextFontTypeOffset(SBook book, SCell cell, SFont.TypeOffset offset) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SFont.TypeOffset orgOffset = font.getTypeOffset();
            if (!orgOffset.equals((Object)offset)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setTypeOffset(offset);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setTypeOffset(offset);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    private static void updateRichTextCellFont(SBook book, SCell cell, SFont font) {
        SCellStyle cellStyle = cell.getCellStyle();
        CellStyleMatcher matcher = new CellStyleMatcher(cellStyle);
        matcher.setFont(font);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            SCellStyle newStyle = StyleUtil.cloneCellStyle(book, cellStyle);
            newStyle.setFont(font);
            cell.setCellStyle(newStyle);
        }
    }

    public static boolean setRichTextFontBoldweight(SBook book, SCell cell, SFont.Boldweight bold) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SFont.Boldweight orgBold = font.getBoldweight();
            if (!orgBold.equals((Object)bold)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setBoldweight(bold);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setBoldweight(bold);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontItalic(SBook book, SCell cell, boolean italic) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            boolean orgItalic = font.isItalic();
            if (orgItalic != italic) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setItalic(italic);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setItalic(italic);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontUnderline(SBook book, SCell cell, SFont.Underline underline) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SFont.Underline orgUnderline = font.getUnderline();
            if (!orgUnderline.equals((Object)underline)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setUnderline(underline);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setUnderline(underline);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontName(SBook book, SCell cell, String name) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            String orgName = font.getName();
            if (!orgName.equals(name)) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setName(name);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setName(name);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontHeightPoints(SBook book, SCell cell, int heightPoints) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            int orgHeightPoints = font.getHeightPoints();
            if (orgHeightPoints != heightPoints) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setHeightPoints(heightPoints);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setHeightPoints(heightPoints);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontStrikeout(SBook book, SCell cell, boolean strike) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            boolean orgStrike = font.isStrikeout();
            if (orgStrike != strike) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setStrikeout(strike);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setStrikeout(strike);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static boolean setRichTextFontColor(SBook book, SCell cell, String htmlColor) {
        Object value;
        Object object = value = ((AbstractCellAdv)cell).isRichTextValue() ? cell.getValue() : null;
        if (!(value instanceof SRichText)) {
            return false;
        }
        SColor newColor = book.createColor(htmlColor);
        SRichText text = (SRichText)value;
        RichTextImpl newText = new RichTextImpl();
        boolean modified = false;
        for (SRichText.Segment seg : text.getSegments()) {
            SFont font0 = seg.getFont();
            SFont font = RichTextHelper.getRichTextRealFont(font0, cell);
            SColor orgColor = font.getColor();
            if (!(orgColor == newColor || orgColor != null && orgColor.equals(newColor))) {
                FontMatcher fontmatcher = new FontMatcher(font);
                fontmatcher.setColor(htmlColor);
                font = book.searchFont(fontmatcher);
                if (font == null) {
                    font = book.createFont(font, true);
                    font.setColor(newColor);
                }
                modified = true;
            }
            if (modified && font0 == null) {
                StyleUtil.updateRichTextCellFont(book, cell, font);
                font = null;
            }
            newText.addSegment(seg.getText(), font);
        }
        if (modified) {
            cell.setValue(newText);
            return true;
        }
        return false;
    }

    public static void setTextRotation(SBook book, CellStyleHolder holder, int rotation) {
        SCellStyle orgStyle = holder.getCellStyle();
        int rot = orgStyle.getRotation();
        if (rot == rotation) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setRotation(rotation);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setRotation(rotation);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    public static void setTextIndentionOffset(SBook book, CellStyleHolder holder, int offset) {
        if (offset == 0) {
            return;
        }
        StyleUtil.setTextIndention(book, holder, holder.getCellStyle().getIndention() + offset);
    }

    public static void setTextIndention(SBook book, CellStyleHolder holder, int indent) {
        SCellStyle orgStyle = holder.getCellStyle();
        int ind = orgStyle.getIndention();
        if (indent < 0) {
            indent = 0;
        }
        if (ind == indent) {
            return;
        }
        CellStyleMatcher matcher = new CellStyleMatcher(orgStyle);
        matcher.setIndention(indent);
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, orgStyle);
            style.setIndention(indent);
        }
        StyleUtil.setNewCellStyle(holder, style);
    }

    @Deprecated
    public static SFont getFontStyle(SBook book, SCellStyle cellStyle, SCellStyle tbCellStyle) {
        return StyleUtil.getFontStyle(book, cellStyle, tbCellStyle, null);
    }

    public static SFont getFontStyle(SBook book, SCellStyle cellStyle, SCellStyle tbCellStyle, SConditionalStyle cdStyle) {
        SFont font0;
        if (cdStyle != null && cdStyle.getFont() != null) {
            return cdStyle.getFont();
        }
        SFont font = cellStyle.getFont();
        if (tbCellStyle != null && book.getDefaultFont().equals(font) && (font0 = tbCellStyle.getFont()) != null) {
            font = font0;
        }
        return font;
    }

    @Deprecated
    public static SCellStyle getFillStyle(SCellStyle cellStyle, SCellStyle tbStyle) {
        return StyleUtil.getFillStyle(cellStyle, tbStyle, null);
    }

    public static SCellStyle getFillStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getFill() != null ? cdStyle : (cellStyle.getFillPattern() != SFill.FillPattern.NONE ? cellStyle : tbStyle);
    }

    @Deprecated
    public static SCellStyle getLeftStyle(SCellStyle cellStyle, SCellStyle tbStyle) {
        return StyleUtil.getLeftStyle(cellStyle, tbStyle, null);
    }

    public static SCellStyle getLeftStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderLeft() != null ? cdStyle : (tbStyle == null || cellStyle.getBorderLeft() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    @Deprecated
    public static SCellStyle getTopStyle(SCellStyle cellStyle, SCellStyle tbStyle) {
        return StyleUtil.getTopStyle(cellStyle, tbStyle, null);
    }

    public static SCellStyle getTopStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderTop() != null ? cdStyle : (tbStyle == null || cellStyle.getBorderTop() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    @Deprecated
    public static SCellStyle getRightStyle(SCellStyle cellStyle, SCellStyle tbStyle) {
        return StyleUtil.getRightStyle(cellStyle, tbStyle, null);
    }

    public static SCellStyle getRightStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderRight() != null ? cdStyle : (tbStyle == null || cellStyle.getBorderRight() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    @Deprecated
    public static SCellStyle getBottomStyle(SCellStyle cellStyle, SCellStyle tbStyle) {
        return StyleUtil.getBottomStyle(cellStyle, tbStyle, null);
    }

    public static SCellStyle getBottomStyle(SCellStyle cellStyle, SCellStyle tbStyle, SConditionalStyle cdStyle) {
        return cdStyle != null && cdStyle.getBorderBottom() != null ? cellStyle : (tbStyle == null || cellStyle.getBorderBottom() != SBorder.BorderType.NONE ? cellStyle : tbStyle);
    }

    public static SCellStyle prepareStyle(SCell srcCell) {
        int row = srcCell.getRowIndex();
        int col = srcCell.getColumnIndex();
        SSheet sheet = srcCell.getSheet();
        SConditionalStyle cdStyle = null;
        STable table = ((AbstractSheetAdv)sheet).getTableByRowCol(row, col);
        SCellStyle tbStyle = table != null ? ((AbstractTableAdv)table).getCellStyle(row, col) : null;
        SCellStyle cellStyle = srcCell.getCellStyle();
        if (tbStyle == null && cdStyle == null) {
            return cellStyle;
        }
        SBook book = sheet.getBook();
        SFont font = StyleUtil.getFontStyle(book, cellStyle, tbStyle, cdStyle);
        SCellStyle fillStyle = StyleUtil.getFillStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle leftStyle = StyleUtil.getLeftStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle topStyle = StyleUtil.getTopStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle rightStyle = StyleUtil.getRightStyle(cellStyle, tbStyle, cdStyle);
        SCellStyle bottomStyle = StyleUtil.getBottomStyle(cellStyle, tbStyle, cdStyle);
        CellStyleMatcher matcher = new CellStyleMatcher(cellStyle);
        matcher.setBackColor(fillStyle.getBackColor().getHtmlColor());
        matcher.setFillColor(fillStyle.getFillColor().getHtmlColor());
        matcher.setFillPattern(fillStyle.getFillPattern());
        matcher.setFont(font);
        matcher.setBorderBottom(bottomStyle.getBorderBottom());
        matcher.setBorderBottomColor(bottomStyle.getBorderBottomColor().getHtmlColor());
        matcher.setBorderTop(topStyle.getBorderTop());
        matcher.setBorderTopColor(topStyle.getBorderTopColor().getHtmlColor());
        matcher.setBorderLeft(leftStyle.getBorderLeft());
        matcher.setBorderLeftColor(leftStyle.getBorderLeftColor().getHtmlColor());
        matcher.setBorderRight(rightStyle.getBorderRight());
        matcher.setBorderRightColor(rightStyle.getBorderRightColor().getHtmlColor());
        SCellStyle style = book.searchCellStyle(matcher);
        if (style == null) {
            style = StyleUtil.cloneCellStyle(book, cellStyle);
            style.setBackColor(fillStyle.getBackColor());
            style.setFillColor(fillStyle.getFillColor());
            style.setFillPattern(fillStyle.getFillPattern());
            style.setFont(font);
            style.setBorderBottom(bottomStyle.getBorderBottom());
            style.setBorderBottomColor(bottomStyle.getBorderBottomColor());
            style.setBorderTop(topStyle.getBorderTop());
            style.setBorderTopColor(topStyle.getBorderTopColor());
            style.setBorderLeft(leftStyle.getBorderLeft());
            style.setBorderLeftColor(leftStyle.getBorderLeftColor());
            style.setBorderRight(rightStyle.getBorderRight());
            style.setBorderRightColor(rightStyle.getBorderRightColor());
        }
        return style;
    }

    public static void setNewCellStyle(CellStyleHolder holder, SCellStyle cellStyle) {
        SCell cell;
        SCellStyle cellStyle0 = holder.getCellStyle();
        SFont font0 = cellStyle0.getFont();
        int rotate0 = cellStyle0.getRotation();
        int indent0 = cellStyle0.getIndention();
        boolean wrap0 = cellStyle0.isWrapText();
        SFont font = cellStyle.getFont();
        int rotate = cellStyle.getRotation();
        int indent = cellStyle.getIndention();
        boolean wrap = cellStyle.isWrapText();
        boolean to90 = rotate == 90 || rotate == -90;
        boolean processWrap = wrap != wrap0 && !to90;
        holder.setCellStyle(cellStyle);
        if (holder instanceof SCell && !(cell = (SCell)holder).getSheet().getRow(cell.getRowIndex()).isCustomHeight()) {
            SCell.CellType type = cell.getType();
            if (rotate != rotate0 || indent != indent0 || !font.equals(font0) || type == SCell.CellType.STRING && processWrap) {
                ((AbstractCellAdv)cell).setCalcAutoHeight(true);
            }
        }
    }
}

