/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SCell;
import io.keikai.model.SChart;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SheetRegion;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.range.SRange;
import io.keikai.range.impl.RangeHelperBase;

public class ChartDataHelper
extends RangeHelperBase {
    public ChartDataHelper(SRange range) {
        super(range);
    }

    public void fillChartData(SChart chart) {
        if (this.range.isWholeSheet() || this.range.isWholeColumn() || this.range.isWholeRow()) {
            return;
        }
        SGeneralChartData chartData = (SGeneralChartData)chart.getData();
        CellRegion selection = new CellRegion(this.range.getRow(), this.range.getColumn(), this.range.getLastRow(), this.range.getLastColumn());
        switch (chart.getType()) {
            case AREA: 
            case BAR: 
            case COLUMN: 
            case DOUGHNUT: 
            case LINE: 
            case PIE: 
            case STOCK: {
                this.fillCategoryData(selection, chartData);
                break;
            }
            case SCATTER: {
                this.fillXYData(selection, chartData);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknow chart type " + (Object)((Object)chart.getType()));
            }
        }
    }

    private void fillXYData(CellRegion selection, SGeneralChartData chartData) {
        CellRegion dataArea = this.getChartDataRange(selection);
        int firstDataColumn = dataArea.getColumn();
        int firstDataRow = dataArea.getRow();
        int columnCount = selection.getLastColumn() - firstDataColumn;
        int rowCount = selection.getLastRow() - firstDataRow;
        String xValueExpression = null;
        if (rowCount > columnCount) {
            if (firstDataColumn < selection.getLastColumn()) {
                int lCol = selection.getColumn();
                int rCol = lCol;
                if (rCol < firstDataColumn) {
                    rCol = firstDataColumn - 1;
                } else {
                    ++firstDataColumn;
                }
                xValueExpression = new SheetRegion(this.sheet, new CellRegion(firstDataRow, lCol, selection.getLastRow(), rCol)).getReferenceString();
            }
            for (int seriesIndex = firstDataColumn; seriesIndex <= dataArea.getLastColumn(); ++seriesIndex) {
                int nameRow = firstDataRow - 1;
                String nameExpression = null;
                if (nameRow >= selection.getRow()) {
                    nameExpression = new SheetRegion(this.sheet, new CellRegion(selection.getRow(), seriesIndex, nameRow, seriesIndex)).getReferenceString();
                }
                String yValueExpression = new SheetRegion(this.sheet, new CellRegion(dataArea.getRow(), seriesIndex, dataArea.getLastRow(), seriesIndex)).getReferenceString();
                SSeries series = chartData.addSeries();
                series.setXYFormula(nameExpression, xValueExpression, yValueExpression);
            }
        } else {
            if (firstDataRow < selection.getLastRow()) {
                int tRow = selection.getRow();
                int bRow = tRow;
                if (bRow < firstDataRow) {
                    bRow = firstDataRow - 1;
                } else {
                    ++firstDataRow;
                }
                xValueExpression = new SheetRegion(this.sheet, new CellRegion(tRow, firstDataColumn, tRow, selection.getLastColumn())).getReferenceString();
            }
            for (int seriesIndex = firstDataRow; seriesIndex <= dataArea.getLastRow(); ++seriesIndex) {
                String nameExpression = null;
                int nameCol = firstDataColumn - 1;
                if (nameCol >= selection.getColumn()) {
                    nameExpression = new SheetRegion(this.sheet, new CellRegion(seriesIndex, selection.getColumn(), seriesIndex, nameCol)).getReferenceString();
                }
                String yValueExpression = new SheetRegion(this.sheet, new CellRegion(seriesIndex, dataArea.getColumn(), seriesIndex, dataArea.getLastColumn())).getReferenceString();
                SSeries series = chartData.addSeries();
                series.setXYFormula(nameExpression, xValueExpression, yValueExpression);
            }
        }
    }

    private void fillCategoryData(CellRegion selection, SGeneralChartData chartData) {
        CellRegion dataArea = this.getChartDataRange(selection);
        int firstDataColumn = dataArea.getColumn();
        int firstDataRow = dataArea.getRow();
        int columnCount = selection.getLastColumn() - firstDataColumn;
        int rowCount = selection.getLastRow() - firstDataRow;
        if (rowCount > columnCount) {
            int categoryColumn = firstDataColumn - 1;
            if (categoryColumn >= selection.getColumn()) {
                chartData.setCategoriesFormula(new SheetRegion(this.sheet, new CellRegion(dataArea.getRow(), categoryColumn, dataArea.getLastRow(), categoryColumn)).getReferenceString());
            }
            for (int seriesIndex = firstDataColumn; seriesIndex <= dataArea.getLastColumn(); ++seriesIndex) {
                String nameExpression = null;
                int nameRow = firstDataRow - 1;
                if (nameRow >= selection.getRow()) {
                    nameExpression = new SheetRegion(this.sheet, new CellRegion(selection.getRow(), seriesIndex, nameRow, seriesIndex)).getReferenceString();
                }
                String xValueExpression = new SheetRegion(this.sheet, new CellRegion(dataArea.getRow(), seriesIndex, dataArea.getLastRow(), seriesIndex)).getReferenceString();
                SSeries series = chartData.addSeries();
                series.setFormula(nameExpression, xValueExpression);
            }
        } else {
            int categoryRow = firstDataRow - 1;
            if (categoryRow >= selection.getRow()) {
                chartData.setCategoriesFormula(new SheetRegion(this.sheet, new CellRegion(categoryRow, dataArea.getColumn(), categoryRow, dataArea.getLastColumn())).getReferenceString());
            }
            for (int seriesIndex = firstDataRow; seriesIndex <= dataArea.getLastRow(); ++seriesIndex) {
                String nameExpression = null;
                int nameColumn = firstDataColumn - 1;
                if (nameColumn >= selection.getColumn()) {
                    nameExpression = new SheetRegion(this.sheet, new CellRegion(seriesIndex, selection.getColumn(), seriesIndex, nameColumn)).getReferenceString();
                }
                String xValueExpression = new SheetRegion(this.sheet, new CellRegion(seriesIndex, dataArea.getColumn(), seriesIndex, dataArea.getLastColumn())).getReferenceString();
                SSeries series = chartData.addSeries();
                series.setFormula(nameExpression, xValueExpression);
            }
        }
    }

    private CellRegion getChartDataRange(CellRegion selection) {
        SSheet sheet = this.range.getSheet();
        int colIdx = selection.getColumn();
        int rowIdx = -1;
        for (int r = selection.getLastRow(); r >= selection.getRow(); --r) {
            SRow row = sheet.getRow(r);
            if (row == null) continue;
            int rCol = colIdx;
            int c = selection.getLastColumn();
            while (c >= rCol && this.isQualifiedCell(sheet.getCell(r, c))) {
                colIdx = c--;
                rowIdx = r;
            }
        }
        if (rowIdx == -1) {
            rowIdx = selection.getLastRow();
            colIdx = selection.getLastColumn();
        }
        return new CellRegion(rowIdx, colIdx, selection.getLastRow(), selection.getLastColumn());
    }

    private boolean isQualifiedCell(SCell cell) {
        if (cell == null) {
            return true;
        }
        SCell.CellType cellType = cell.getType();
        return cellType == SCell.CellType.NUMBER || cellType == SCell.CellType.FORMULA || cellType == SCell.CellType.BLANK;
    }
}

