/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.PasteOption;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SCell;
import io.keikai.model.SChart;
import io.keikai.model.SColorScale;
import io.keikai.model.SColumn;
import io.keikai.model.SColumnArray;
import io.keikai.model.SConditionalFormatting;
import io.keikai.model.SConditionalFormattingRule;
import io.keikai.model.SDataBar;
import io.keikai.model.SDataValidation;
import io.keikai.model.SExtraStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SIconSet;
import io.keikai.model.SPicture;
import io.keikai.model.SPrintSetup;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.SSheetProtection;
import io.keikai.model.SSheetViewInfo;
import io.keikai.model.STable;
import io.keikai.model.SheetRegion;
import io.keikai.model.ViewAnchor;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractBookSeriesAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractColumnArrayAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.AbstractPictureAdv;
import io.keikai.model.impl.AbstractRowAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.AbstractTableAdv;
import io.keikai.model.impl.AutoFilterImpl;
import io.keikai.model.impl.BookImpl;
import io.keikai.model.impl.CellAttribute;
import io.keikai.model.impl.CellProxy;
import io.keikai.model.impl.CellValue;
import io.keikai.model.impl.ChartImpl;
import io.keikai.model.impl.ColumnArrayImpl;
import io.keikai.model.impl.ColumnArrayPool;
import io.keikai.model.impl.ColumnProxy;
import io.keikai.model.impl.ConditionalFormattingImpl;
import io.keikai.model.impl.ConditionalFormattingRuleImpl;
import io.keikai.model.impl.ConditionalStyleImpl;
import io.keikai.model.impl.DataValidationImpl;
import io.keikai.model.impl.FormulaTunerHelper;
import io.keikai.model.impl.IndexPool;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.ObjectRefImpl;
import io.keikai.model.impl.PasteCellHelper;
import io.keikai.model.impl.PictureImpl;
import io.keikai.model.impl.PrintSetupImpl;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.impl.RowImpl;
import io.keikai.model.impl.RowProxy;
import io.keikai.model.impl.SheetProtectionImpl;
import io.keikai.model.impl.SheetViewInfoImpl;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.dependency.DependencyTable;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaClearContext;
import io.keikai.model.util.Validations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.zkoss.lang.Library;
import org.zkoss.poi.ss.usermodel.DateUtil;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.ss.util.SheetUtil;
import org.zkoss.poi.ss.util.WorkbookUtil;
import org.zkoss.util.logging.Log;

public class SheetImpl
extends AbstractSheetAdv {
    private static final long serialVersionUID = 1L;
    private static final Log _logger = Log.lookup(SheetImpl.class);
    private AbstractBookAdv _book;
    private String _name;
    private final String _id;
    private boolean _protected;
    private short _password;
    private SAutoFilter _autoFilter;
    private SSheetProtection _sheetProtection;
    private SSheet.SheetVisible _visible = SSheet.SheetVisible.VISIBLE;
    private String _hashValue;
    private String _spinCount;
    private String _algName;
    private String _saltValue;
    private List<SConditionalFormatting> _conditionalFormattings;
    private int _conditionalId = 0;
    private Map<Integer, SConditionalFormatting> _conditionalMap;
    private final IndexPool<AbstractRowAdv> _rows = new IndexPool<AbstractRowAdv>(){
        private static final long serialVersionUID = 1L;

        @Override
        void resetIndex(int newidx, AbstractRowAdv obj) {
            obj.setIndex(newidx);
        }
    };
    private final ColumnArrayPool _columnArrays = new ColumnArrayPool();
    private final List<AbstractPictureAdv> _pictures = new LinkedList<AbstractPictureAdv>();
    private final List<AbstractChartAdv> _charts = new LinkedList<AbstractChartAdv>();
    private final List<AbstractDataValidationAdv> _dataValidations = new ArrayList<AbstractDataValidationAdv>();
    private final List<CellRegion> _mergedRegions = new LinkedList<CellRegion>();
    private final SSheetViewInfo _viewInfo = new SheetViewInfoImpl();
    private final SPrintSetup _printSetup = new PrintSetupImpl();
    private HashMap<String, Object> _attributes;
    private int _defaultColumnWidth = 64;
    private int _defaultRowHeight = 20;
    private final List<STable> _tables = new ArrayList<STable>();
    private int _mergeOutOfSync;
    private static boolean COLUMN_ARRAY_CHECK = false;

    public SheetImpl(AbstractBookAdv book, String id) {
        this._book = book;
        this._id = id;
    }

    protected void checkOwnership(SPicture picture) {
        if (!this._pictures.contains(picture)) {
            throw new IllegalStateException("doesn't has ownership " + picture);
        }
    }

    protected void checkOwnership(SChart chart) {
        if (!this._charts.contains(chart)) {
            throw new IllegalStateException("doesn't has ownership " + chart);
        }
    }

    protected void checkOwnership(SDataValidation validation) {
        if (!this._dataValidations.contains(validation)) {
            throw new IllegalStateException("doesn't has ownership " + validation);
        }
    }

    @Override
    public SBook getBook() {
        this.checkOrphan();
        return this._book;
    }

    @Override
    public String getSheetName() {
        return this._name;
    }

    @Override
    public SRow getRow(int rowIdx) {
        return this.getRow(rowIdx, true);
    }

    @Override
    AbstractRowAdv getRow(int rowIdx, boolean proxy) {
        AbstractRowAdv rowObj = this._rows.get(rowIdx);
        if (rowObj != null) {
            return rowObj;
        }
        return proxy ? new RowProxy(this, rowIdx) : null;
    }

    @Override
    AbstractRowAdv getOrCreateRow(int rowIdx) {
        AbstractRowAdv rowObj = this._rows.get(rowIdx);
        if (rowObj == null) {
            this.checkOrphan();
            if (rowIdx > this.getBook().getMaxRowIndex()) {
                throw new IllegalStateException("can't create the row that exceeds max row size " + this.getBook().getMaxRowIndex());
            }
            rowObj = new RowImpl(this, rowIdx);
            this._rows.put(rowIdx, rowObj);
        }
        return rowObj;
    }

    @Override
    public SColumn getColumn(int columnIdx) {
        return this.getColumn(columnIdx, true);
    }

    @Override
    SColumn getColumn(int columnIdx, boolean proxy) {
        SColumnArray array = this.getColumnArray(columnIdx);
        if (array == null && !proxy) {
            return null;
        }
        return new ColumnProxy(this, columnIdx);
    }

    @Override
    public SColumnArray getColumnArray(int columnIdx) {
        if (this._columnArrays.hasLastKey(columnIdx)) {
            return null;
        }
        SortedMap<Integer, AbstractColumnArrayAdv> submap = this._columnArrays.lastSubMap(columnIdx);
        return submap.size() > 0 ? (SColumnArray)submap.get(submap.firstKey()) : null;
    }

    private void checkColumnArrayStatus() {
        if (!COLUMN_ARRAY_CHECK) {
            return;
        }
        SColumnArray prev = null;
        try {
            for (AbstractColumnArrayAdv array : this._columnArrays.values()) {
                if (prev == null) {
                    if (array.getIndex() != 0) {
                        throw new IllegalStateException("column array doesn't not start with 0 is " + array.getIndex());
                    }
                } else if (prev.getLastIndex() + 1 != array.getIndex()) {
                    throw new IllegalStateException("column array doesn't continue, " + prev.getLastIndex() + " to " + array.getIndex());
                }
                prev = array;
            }
        }
        catch (RuntimeException x) {
            _logger.error(x.getMessage(), (Throwable)x);
            for (AbstractColumnArrayAdv array : this._columnArrays.values()) {
                _logger.info("ColumnArray " + array.getIndex() + ":" + array.getLastIndex());
            }
            throw x;
        }
    }

    @Override
    public SColumnArray setupColumnArray(int index, int lastIndex) {
        ColumnArrayImpl array;
        if (index < 0 && lastIndex > index) {
            throw new IllegalArgumentException(index + "," + lastIndex);
        }
        int end1 = -1;
        int start1 = -1;
        AbstractColumnArrayAdv ov = this._columnArrays.overlap(index, lastIndex);
        if (ov != null) {
            throw new IllegalStateException("Can't setup an overlapped column array " + index + "," + lastIndex + " overlppaed " + ov);
        }
        start1 = this._columnArrays.size() == 0 ? 0 : this._columnArrays.lastLastKey() + 1;
        if (start1 <= (end1 = index - 1) && end1 > -1) {
            array = new ColumnArrayImpl(this, start1, end1);
            this._columnArrays.put(array);
        }
        array = new ColumnArrayImpl(this, index, lastIndex);
        this._columnArrays.put(array);
        this.checkColumnArrayStatus();
        return array;
    }

    @Override
    AbstractColumnArrayAdv getOrSplitColumnArray(int columnIdx) {
        AbstractColumnArrayAdv contains = (AbstractColumnArrayAdv)this.getColumnArray(columnIdx);
        if (contains != null && contains.getIndex() == columnIdx && contains.getLastIndex() == columnIdx) {
            return contains;
        }
        if (columnIdx > this.getBook().getMaxColumnIndex()) {
            throw new IllegalStateException("can't create the column array that exceeds max row size " + this.getBook().getMaxRowIndex());
        }
        int end2 = -1;
        int start2 = -1;
        int end1 = -1;
        int start1 = -1;
        if (contains == null) {
            start1 = this._columnArrays.size() == 0 ? 0 : this._columnArrays.lastLastKey() + 1;
            end1 = columnIdx - 1;
        } else if (contains.getIndex() == columnIdx) {
            start2 = columnIdx + 1;
            end2 = contains.getLastIndex();
        } else if (contains.getLastIndex() == columnIdx) {
            start1 = contains.getIndex();
            end1 = columnIdx - 1;
        } else {
            start1 = contains.getIndex();
            end1 = columnIdx - 1;
            end2 = contains.getLastIndex();
            start2 = columnIdx + 1;
        }
        ColumnArrayImpl array = null;
        ColumnArrayImpl prev = null;
        if (contains != null) {
            this._columnArrays.remove(contains);
        }
        if (start2 <= end2 && end2 > -1) {
            prev = new ColumnArrayImpl(this, start2, end2);
            this._columnArrays.put(prev);
            if (contains != null) {
                prev.setCellStyle(contains.getCellStyle());
                prev.setHidden(contains.isHidden());
                prev.setWidth(contains.getWidth());
            }
        }
        array = new ColumnArrayImpl(this, columnIdx, columnIdx);
        this._columnArrays.put(array);
        if (contains != null) {
            array.setCellStyle(contains.getCellStyle());
            array.setHidden(contains.isHidden());
            array.setWidth(contains.getWidth());
        }
        if (start1 <= end1 && end1 > -1) {
            prev = new ColumnArrayImpl(this, start1, end1);
            this._columnArrays.put(prev);
            if (contains != null) {
                prev.setCellStyle(contains.getCellStyle());
                prev.setHidden(contains.isHidden());
                prev.setWidth(contains.getWidth());
            }
        }
        this.checkColumnArrayStatus();
        return array;
    }

    @Override
    public SCell getCell(int rowIdx, int columnIdx) {
        return this.getCell(rowIdx, columnIdx, true);
    }

    @Override
    public SCell getCell(String cellRef) {
        CellRegion region = new CellRegion(cellRef);
        if (!region.isSingle()) {
            throw new InvalidModelOpException("not a single ref " + cellRef);
        }
        return this.getCell(region.getRow(), region.getColumn(), true);
    }

    @Override
    AbstractCellAdv getCell(int rowIdx, int columnIdx, boolean proxy) {
        AbstractRowAdv rowObj = this.getRow(rowIdx, false);
        if (rowObj != null) {
            return rowObj.getCell(columnIdx, proxy);
        }
        return proxy ? new CellProxy(this, rowIdx, columnIdx) : null;
    }

    @Override
    AbstractCellAdv getOrCreateCell(int rowIdx, int columnIdx) {
        AbstractRowAdv rowObj = this.getOrCreateRow(rowIdx);
        AbstractCellAdv cell = rowObj.getOrCreateCell(columnIdx);
        return cell;
    }

    @Override
    public int getStartRowIndex() {
        return this._rows.firstKey();
    }

    @Override
    public int getEndRowIndex() {
        return this._rows.lastKey();
    }

    @Override
    public int getStartColumnIndex() {
        return this._columnArrays.size() > 0 ? this._columnArrays.firstFirstKey() : -1;
    }

    @Override
    public int getEndColumnIndex() {
        return this._columnArrays.size() > 0 ? this._columnArrays.lastLastKey() : -1;
    }

    @Override
    public int getStartCellIndex(int rowIdx) {
        int idx1 = -1;
        AbstractRowAdv rowObj = this.getRow(rowIdx, false);
        if (rowObj != null) {
            idx1 = rowObj.getStartCellIndex();
        }
        return idx1;
    }

    @Override
    public int getEndCellIndex(int rowIdx) {
        int idx1 = -1;
        AbstractRowAdv rowObj = this.getRow(rowIdx, false);
        if (rowObj != null) {
            idx1 = rowObj.getEndCellIndex();
        }
        return idx1;
    }

    @Override
    void setSheetName(String name) {
        this.checkLegalSheetName(name);
        this._name = name;
    }

    private void checkLegalSheetName(String name) {
        try {
            WorkbookUtil.validateSheetName((String)name);
        }
        catch (IllegalArgumentException x) {
            throw new InvalidModelOpException(x.getMessage());
        }
        catch (Exception x) {
            throw new InvalidModelOpException("The sheet name " + name + " is not allowed");
        }
    }

    @Override
    public void clearCell(CellRegion region) {
        this.clearCell(region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn());
    }

    @Override
    public void clearCell(int rowIdx, int columnIdx, int rowIdx2, int columnIdx2) {
        int rowStart = Math.min(rowIdx, rowIdx2);
        int rowEnd = Math.max(rowIdx, rowIdx2);
        int columnStart = Math.min(columnIdx, columnIdx2);
        int columnEnd = Math.max(columnIdx, columnIdx2);
        Collection<AbstractRowAdv> effected = this._rows.subValues(rowStart, rowEnd);
        for (AbstractRowAdv row : effected) {
            row.clearCell(columnStart, columnEnd);
        }
    }

    @Override
    public void insertRow(int rowIdx, int lastRowIdx) {
        this.checkOrphan();
        if (rowIdx > lastRowIdx) {
            throw new IllegalArgumentException(rowIdx + ">" + lastRowIdx);
        }
        int size = lastRowIdx - rowIdx + 1;
        this._rows.insert(rowIdx, size);
        int maxSize = this.getBook().getMaxRowSize();
        ArrayList<AbstractRowAdv> exceeds = new ArrayList<AbstractRowAdv>(this._rows.subValues(maxSize, Integer.MAX_VALUE));
        if (exceeds.size() > 0) {
            this._rows.trim(maxSize);
        }
        for (AbstractRowAdv row : exceeds) {
            row.destroy();
        }
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        Map<String, Object> dataBefore = this.shiftBeforeRowInsert(rowIdx, lastRowIdx);
        ModelUpdateUtil.addInsertDeleteUpdate(this, true, true, rowIdx, lastRowIdx);
        this.shiftAfterRowInsert(dataBefore, rowIdx, lastRowIdx);
    }

    private Map<String, Object> shiftBeforeRowInsert(int rowIdx, int lastRowIdx) {
        HashMap<String, Object> dataBefore = new HashMap<String, Object>();
        CellRegion affectedRegion = new CellRegion(rowIdx, 0, this._book.getMaxRowIndex(), this._book.getMaxColumnIndex());
        List<CellRegion> toExtend = this.getOverlapsMergedRegions(affectedRegion, true);
        List<CellRegion> toShift = this.getContainsMergedRegions(affectedRegion);
        this.removeMergedRegion(affectedRegion, true);
        dataBefore.put("toExtend", toExtend);
        dataBefore.put("toShift", toShift);
        return dataBefore;
    }

    private void shiftAfterRowInsert(Map<String, Object> dataBefore, int rowIdx, int lastRowIdx) {
        int idx;
        Object anchor;
        int size = lastRowIdx - rowIdx + 1;
        for (AbstractPictureAdv pic : this._pictures) {
            anchor = pic.getAnchor();
            idx = ((ViewAnchor)anchor).getRowIndex();
            if (idx < rowIdx) continue;
            ((ViewAnchor)anchor).setRowIndex(idx + size);
        }
        for (AbstractChartAdv chart : this._charts) {
            anchor = chart.getAnchor();
            idx = ((ViewAnchor)anchor).getRowIndex();
            if (idx < rowIdx) continue;
            ((ViewAnchor)anchor).setRowIndex(idx + size);
        }
        List toExtend = (List)dataBefore.get("toExtend");
        List toShift = (List)dataBefore.get("toShift");
        for (CellRegion r : toExtend) {
            this.addMergedRegion(new CellRegion(r.row, r.column, r.lastRow + size, r.lastColumn));
        }
        for (CellRegion r : toShift) {
            this.addMergedRegion(new CellRegion(r.row + size, r.column, r.lastRow + size, r.lastColumn));
        }
        this.extendFormula(new CellRegion(rowIdx, 0, lastRowIdx, this._book.getMaxColumnIndex()), false);
        int freezeIdx = this._viewInfo.getNumOfRowFreeze() - 1;
        if (freezeIdx >= rowIdx) {
            freezeIdx = freezeIdx < lastRowIdx ? (freezeIdx += freezeIdx - rowIdx + 1) : (freezeIdx += lastRowIdx - rowIdx + 1);
            this._viewInfo.setNumOfRowFreeze(freezeIdx < 0 ? 0 : freezeIdx + 1);
        }
    }

    @Override
    public void deleteRow(int rowIdx, int lastRowIdx) {
        this.checkOrphan();
        if (rowIdx > lastRowIdx) {
            throw new IllegalArgumentException(rowIdx + ">" + lastRowIdx);
        }
        for (AbstractRowAdv row : this._rows.subValues(rowIdx, lastRowIdx)) {
            row.destroy();
        }
        int size = lastRowIdx - rowIdx + 1;
        this._rows.delete(rowIdx, size);
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        Map<String, Object> dataBefore = this.shiftBeforeRowDelete(rowIdx, lastRowIdx);
        ModelUpdateUtil.addInsertDeleteUpdate(this, false, true, rowIdx, lastRowIdx);
        this.shiftAfterRowDelete(dataBefore, rowIdx, lastRowIdx);
    }

    private Map<String, Object> shiftBeforeRowDelete(int rowIdx, int lastRowIdx) {
        HashMap<String, Object> dataBefore = new HashMap<String, Object>();
        CellRegion affectedRegion = new CellRegion(rowIdx, 0, this._book.getMaxRowIndex(), this._book.getMaxColumnIndex());
        List<CellRegion> toShrink = this.getOverlapsMergedRegions(affectedRegion, false);
        this.removeMergedRegion(affectedRegion, true);
        dataBefore.put("toShrink", toShrink);
        return dataBefore;
    }

    /*
     * WARNING - void declaration
     */
    private void shiftAfterRowDelete(Map<String, Object> dataBefore, int rowIdx, int lastRowIdx) {
        int idx;
        ViewAnchor anchor;
        int size = lastRowIdx - rowIdx + 1;
        for (AbstractPictureAdv abstractPictureAdv : this._pictures) {
            anchor = abstractPictureAdv.getAnchor();
            idx = anchor.getRowIndex();
            if (idx >= rowIdx + size) {
                anchor.setRowIndex(idx - size);
                continue;
            }
            if (idx < rowIdx) continue;
            anchor.setRowIndex(rowIdx);
            anchor.setYOffset(0);
        }
        for (AbstractChartAdv abstractChartAdv : this._charts) {
            anchor = abstractChartAdv.getAnchor();
            idx = anchor.getRowIndex();
            if (idx >= rowIdx + size) {
                anchor.setRowIndex(idx - size);
                continue;
            }
            if (idx < rowIdx) continue;
            anchor.setRowIndex(rowIdx);
            anchor.setYOffset(0);
        }
        List toShrink = (List)dataBefore.get("toShrink");
        for (CellRegion r : toShrink) {
            CellRegion shrank = this.shrinkRow(r, rowIdx, lastRowIdx);
            if (shrank == null) continue;
            this.addMergedRegion(shrank);
        }
        this.shrinkFormula(new CellRegion(rowIdx, 0, lastRowIdx, this._book.getMaxColumnIndex()), false);
        int n = this._viewInfo.getNumOfRowFreeze() - 1;
        if (n >= rowIdx) {
            void var6_13;
            if (n < lastRowIdx) {
                int n2 = rowIdx - 1;
            } else {
                int n3 = n - (lastRowIdx - rowIdx + 1);
            }
            this._viewInfo.setNumOfRowFreeze(var6_13 < 0 ? 0 : var6_13 + true);
        }
    }

    private CellRegion shrinkRow(CellRegion region, int row, int lastRow) {
        int[] shrank = this.shrinkIndexes(region.row, region.lastRow, row, lastRow);
        return shrank != null ? new CellRegion(shrank[0], region.column, shrank[1], region.lastColumn) : null;
    }

    private CellRegion shrinkColumn(CellRegion region, int column, int lastColumn) {
        int[] shrank = this.shrinkIndexes(region.column, region.lastColumn, column, lastColumn);
        return shrank != null ? new CellRegion(region.row, shrank[0], region.lastRow, shrank[1]) : null;
    }

    private int[] shrinkIndexes(int a, int b, int c, int d) {
        int[] nArray;
        if (a < 0 || b < 0 || c < 0 || d < 0 || a > b || c > d) {
            throw new IllegalArgumentException("indexes must be >= 0 and ascending");
        }
        int delta = d - c + 1;
        if (a > d) {
            a -= delta;
        } else if (a >= c) {
            a = c;
            a = d + 1 - delta;
        }
        if (b > d) {
            b -= delta;
        } else if (b >= c) {
            b = c - 1;
        }
        if (b >= a) {
            int[] nArray2 = new int[2];
            nArray2[0] = a;
            nArray = nArray2;
            nArray2[1] = b;
        } else {
            nArray = null;
        }
        return nArray;
    }

    @Override
    public void insertCell(CellRegion region, boolean horizontal) {
        this.insertCell(region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn(), horizontal);
    }

    @Override
    public void insertCell(int rowIdx, int columnIdx, int lastRowIdx, int lastColumnIdx, boolean horizontal) {
        this.checkOrphan();
        if (rowIdx > lastRowIdx) {
            throw new IllegalArgumentException(rowIdx + ">" + lastRowIdx);
        }
        if (columnIdx > lastColumnIdx) {
            throw new IllegalArgumentException(columnIdx + ">" + lastColumnIdx);
        }
        int columnSize = lastColumnIdx - columnIdx + 1;
        int rowSize = lastRowIdx - rowIdx + 1;
        if (horizontal) {
            Collection<AbstractRowAdv> effectedRows = this._rows.subValues(rowIdx, lastRowIdx);
            for (AbstractRowAdv row : effectedRows) {
                row.insertCell(columnIdx, columnSize);
            }
            EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
            ModelUpdateUtil.addCellUpdate(this, rowIdx, columnIdx, lastRowIdx, this.getBook().getMaxColumnIndex(), CellAttribute.ALL);
        } else {
            int maxSize = this.getBook().getMaxRowSize();
            Collection<AbstractRowAdv> effectedRows = this._rows.descendingSubValues(rowIdx, Integer.MAX_VALUE);
            for (AbstractRowAdv row : new ArrayList<AbstractRowAdv>(effectedRows)) {
                int idx = row.getIndex() + rowSize;
                if (idx >= maxSize) {
                    row.clearCell(columnIdx, lastColumnIdx);
                    continue;
                }
                AbstractRowAdv target = this.getOrCreateRow(idx);
                row.moveCellTo(target, columnIdx, lastColumnIdx, 0);
            }
            EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
            ModelUpdateUtil.addCellUpdate(this, rowIdx, columnIdx, this.getBook().getMaxRowIndex(), lastColumnIdx, CellAttribute.ALL);
        }
        this.shiftAfterCellInsert(rowIdx, columnIdx, lastRowIdx, lastColumnIdx, horizontal);
    }

    @Override
    public void deleteCell(CellRegion region, boolean horizontal) {
        this.deleteCell(region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn(), horizontal);
    }

    @Override
    public void deleteCell(int rowIdx, int columnIdx, int lastRowIdx, int lastColumnIdx, boolean horizontal) {
        this.checkOrphan();
        if (rowIdx > lastRowIdx) {
            throw new IllegalArgumentException(rowIdx + ">" + lastRowIdx);
        }
        if (columnIdx > lastColumnIdx) {
            throw new IllegalArgumentException(columnIdx + ">" + lastColumnIdx);
        }
        int columnSize = lastColumnIdx - columnIdx + 1;
        int rowSize = lastRowIdx - rowIdx + 1;
        if (horizontal) {
            Collection<AbstractRowAdv> effected = this._rows.subValues(rowIdx, lastRowIdx);
            for (AbstractRowAdv row : effected) {
                row.deleteCell(columnIdx, columnSize);
            }
            EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
            ModelUpdateUtil.addCellUpdate(this, rowIdx, columnIdx, lastRowIdx, this.getBook().getMaxColumnIndex(), CellAttribute.ALL);
        } else {
            Collection<AbstractRowAdv> effectedRows = this._rows.subValues(rowIdx, lastRowIdx);
            for (AbstractRowAdv row : effectedRows) {
                row.clearCell(columnIdx, lastColumnIdx);
            }
            effectedRows = this._rows.subValues(rowIdx + rowSize, Integer.MAX_VALUE);
            for (AbstractRowAdv row : new ArrayList<AbstractRowAdv>(effectedRows)) {
                AbstractRowAdv target = this.getOrCreateRow(row.getIndex() - rowSize);
                row.moveCellTo(target, columnIdx, lastColumnIdx, 0);
            }
            EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
            ModelUpdateUtil.addCellUpdate(this, rowIdx, columnIdx, this.getBook().getMaxRowIndex(), lastColumnIdx, CellAttribute.ALL);
        }
        this.shiftAfterCellDelete(rowIdx, columnIdx, lastRowIdx, lastColumnIdx, horizontal);
    }

    private void shiftAfterCellInsert(int rowIdx, int columnIdx, int lastRowIdx, int lastColumnIdx, boolean horizontal) {
        if (horizontal) {
            int size = lastColumnIdx - columnIdx + 1;
            CellRegion affectedRegion = new CellRegion(rowIdx, columnIdx, lastRowIdx, this._book.getMaxColumnIndex());
            List<CellRegion> toShift = this.getContainsMergedRegions(affectedRegion);
            this.removeMergedRegion(affectedRegion, true);
            for (CellRegion r : toShift) {
                this.addMergedRegion(new CellRegion(r.row, r.column + size, r.lastRow, r.lastColumn + size));
            }
        } else {
            int size = lastRowIdx - rowIdx + 1;
            CellRegion affectedRegion = new CellRegion(rowIdx, columnIdx, this._book.getMaxRowIndex(), lastColumnIdx);
            List<CellRegion> toShift = this.getContainsMergedRegions(affectedRegion);
            this.removeMergedRegion(affectedRegion, true);
            for (CellRegion r : toShift) {
                this.addMergedRegion(new CellRegion(r.row + size, r.column, r.lastRow + size, r.lastColumn));
            }
        }
        this.extendFormula(new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx), horizontal);
    }

    private void shiftAfterCellDelete(int rowIdx, int columnIdx, int lastRowIdx, int lastColumnIdx, boolean horizontal) {
        this.removeMergedRegion(new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx), true);
        if (horizontal) {
            int size = lastColumnIdx - columnIdx + 1;
            CellRegion affectedRegion = new CellRegion(rowIdx, lastColumnIdx, lastRowIdx, this._book.getMaxColumnIndex());
            List<CellRegion> toShift = this.getContainsMergedRegions(affectedRegion);
            this.removeMergedRegion(affectedRegion, true);
            for (CellRegion r : toShift) {
                this.addMergedRegion(new CellRegion(r.row, r.column - size, r.lastRow, r.lastColumn - size));
            }
        } else {
            int size = lastRowIdx - rowIdx + 1;
            CellRegion affectedRegion = new CellRegion(lastRowIdx, columnIdx, this._book.getMaxRowIndex(), lastColumnIdx);
            List<CellRegion> toShift = this.getContainsMergedRegions(affectedRegion);
            this.removeMergedRegion(affectedRegion, true);
            for (CellRegion r : toShift) {
                this.addMergedRegion(new CellRegion(r.row - size, r.column, r.lastRow - size, r.lastColumn));
            }
        }
        this.shrinkFormula(new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx), horizontal);
    }

    @Override
    void copyTo(AbstractSheetAdv sheet) {
        if (sheet == this) {
            return;
        }
        this.checkOrphan();
        sheet.checkOrphan();
        this.copyToBook(sheet, this.getBook().equals(sheet.getBook()) ? null : sheet.getBook());
    }

    private void copyToBook(AbstractSheetAdv sheet, SBook book0) {
        BookImpl book = (BookImpl)book0;
        SheetImpl tgt = (SheetImpl)sheet;
        tgt._protected = this._protected;
        tgt._password = this._password;
        for (CellRegion rgn : this._mergedRegions) {
            tgt._mergedRegions.add(new CellRegion(rgn.row, rgn.column, rgn.lastRow, rgn.lastColumn));
        }
        if (this._autoFilter != null) {
            tgt._autoFilter = ((AutoFilterImpl)this._autoFilter).cloneAutoFilterImpl();
            tgt.addIntoDependency(tgt._autoFilter);
        }
        if (this._sheetProtection != null) {
            tgt._sheetProtection = ((SheetProtectionImpl)this._sheetProtection).cloneSheetProtectionImpl();
        }
        for (STable tb : this._tables) {
            tgt._tables.add(((AbstractTableAdv)tb).cloneTable(tgt, book));
        }
        for (AbstractRowAdv srcrow : this._rows.values()) {
            AbstractRowAdv tgtrow = srcrow.cloneRow(tgt, book);
            tgt._rows.put(tgtrow.getIndex(), tgtrow);
        }
        for (AbstractColumnArrayAdv ca : this._columnArrays.values()) {
            tgt._columnArrays.put(((ColumnArrayImpl)ca).cloneColumnArray(tgt, book));
        }
        for (AbstractPictureAdv pic : this._pictures) {
            tgt._pictures.add(((PictureImpl)pic).clonePicture(tgt, book));
        }
        for (AbstractChartAdv chart : this._charts) {
            tgt._charts.add(((ChartImpl)chart).cloneChartImpl(tgt));
        }
        for (AbstractDataValidationAdv dv : this._dataValidations) {
            tgt._dataValidations.add(((DataValidationImpl)dv).cloneDataValidationImpl(tgt));
        }
        ((SheetViewInfoImpl)tgt._viewInfo).copyFrom((SheetViewInfoImpl)this._viewInfo);
        ((PrintSetupImpl)tgt._printSetup).copyFrom((PrintSetupImpl)this._printSetup);
        tgt._defaultColumnWidth = this._defaultColumnWidth;
        tgt._defaultRowHeight = this._defaultRowHeight;
        tgt._hashValue = this._hashValue;
        tgt._saltValue = this._saltValue;
        tgt._spinCount = this._spinCount;
        tgt._algName = this._algName;
    }

    public void dump(StringBuilder builder) {
        int i;
        builder.append("'").append(this.getSheetName()).append("' {\n");
        int endColumn = this.getEndColumnIndex();
        int endRow = this.getEndRowIndex();
        builder.append("  ==Columns==\n\t");
        for (i = 0; i <= endColumn; ++i) {
            builder.append(CellReference.convertNumToColString((int)i)).append(":").append(i).append("\t");
        }
        builder.append("\n");
        builder.append("  ==Row=={");
        for (i = 0; i <= endRow; ++i) {
            builder.append("\n  ").append(i).append("\t");
            if (this.getRow(i).isNull()) {
                builder.append("-*");
                continue;
            }
            int endCell = this.getEndCellIndex(i);
            for (int j = 0; j <= endCell; ++j) {
                SCell cell = this.getCell(i, j);
                Object cellvalue = cell.isNull() ? "-" : cell.getValue();
                String str = cellvalue == null ? "null" : cellvalue.toString();
                str = str.length() > 8 ? str.substring(0, 8) : str + "\t";
                builder.append(str);
            }
        }
        builder.append("\n}\n");
    }

    @Override
    public void insertColumn(int columnIdx, int lastColumnIdx) {
        this.checkOrphan();
        if (columnIdx > lastColumnIdx) {
            throw new IllegalArgumentException(columnIdx + ">" + lastColumnIdx);
        }
        int size = lastColumnIdx - columnIdx + 1;
        this.insertAndSplitColumnArray(columnIdx, size);
        for (AbstractRowAdv row : this._rows.values()) {
            row.insertCell(columnIdx, size);
        }
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        Map<String, Object> dataBefore = this.shiftBeforeColumnInsert(columnIdx, lastColumnIdx);
        ModelUpdateUtil.addInsertDeleteUpdate(this, true, false, columnIdx, lastColumnIdx);
        this.shiftAfterColumnInsert(dataBefore, columnIdx, lastColumnIdx);
    }

    private Map<String, Object> shiftBeforeColumnInsert(int columnIdx, int lastColumnIdx) {
        HashMap<String, Object> dataBefore = new HashMap<String, Object>();
        CellRegion affectedRegion = new CellRegion(0, columnIdx, this._book.getMaxRowIndex(), this._book.getMaxColumnIndex());
        List<CellRegion> toExtend = this.getOverlapsMergedRegions(affectedRegion, true);
        List<CellRegion> toShift = this.getContainsMergedRegions(affectedRegion);
        this.removeMergedRegion(affectedRegion, true);
        dataBefore.put("toExtend", toExtend);
        dataBefore.put("toShift", toShift);
        return dataBefore;
    }

    private void shiftAfterColumnInsert(Map<String, Object> dataBefore, int columnIdx, int lastColumnIdx) {
        int idx;
        Object anchor;
        int size = lastColumnIdx - columnIdx + 1;
        for (AbstractPictureAdv pic : this._pictures) {
            anchor = pic.getAnchor();
            idx = ((ViewAnchor)anchor).getColumnIndex();
            if (idx < columnIdx) continue;
            ((ViewAnchor)anchor).setColumnIndex(idx + size);
        }
        for (AbstractChartAdv chart : this._charts) {
            anchor = chart.getAnchor();
            idx = ((ViewAnchor)anchor).getColumnIndex();
            if (idx < columnIdx) continue;
            ((ViewAnchor)anchor).setColumnIndex(idx + size);
        }
        List toExtend = (List)dataBefore.get("toExtend");
        List toShift = (List)dataBefore.get("toShift");
        for (CellRegion r : toExtend) {
            this.addMergedRegion(new CellRegion(r.row, r.column, r.lastRow, r.lastColumn + size));
        }
        for (CellRegion r : toShift) {
            this.addMergedRegion(new CellRegion(r.row, r.column + size, r.lastRow, r.lastColumn + size));
        }
        this.extendFormula(new CellRegion(0, columnIdx, this._book.getMaxRowIndex(), lastColumnIdx), true);
        int freezeIdx = this._viewInfo.getNumOfColumnFreeze() - 1;
        if (freezeIdx >= columnIdx) {
            freezeIdx = freezeIdx < lastColumnIdx ? (freezeIdx += freezeIdx - columnIdx + 1) : (freezeIdx += lastColumnIdx - columnIdx + 1);
            this._viewInfo.setNumOfColumnFreeze(freezeIdx < 0 ? 0 : freezeIdx + 1);
        }
    }

    private void insertAndSplitColumnArray(int columnIdx, int size) {
        int maxSize;
        ArrayList<AbstractColumnArrayAdv> exceeds;
        SColumnArray contains = null;
        int end2 = -1;
        int start2 = -1;
        int end1 = -1;
        int start1 = -1;
        if (this._columnArrays.hasLastKey(columnIdx)) {
            return;
        }
        LinkedList<AbstractColumnArrayAdv> shift = new LinkedList<AbstractColumnArrayAdv>();
        for (AbstractColumnArrayAdv array : this._columnArrays.lastSubMap(columnIdx).values()) {
            if (array.getIndex() <= columnIdx && array.getLastIndex() >= columnIdx) {
                contains = array;
            }
            if (array.getIndex() <= columnIdx) continue;
            shift.add(0, array);
        }
        for (AbstractColumnArrayAdv array : shift) {
            this._columnArrays.remove(array);
            array.setIndex(array.getIndex() + size);
            array.setLastIndex(array.getLastIndex() + size);
            this._columnArrays.put(array);
        }
        if (contains == null) {
            return;
        }
        if (contains.getIndex() == columnIdx) {
            start2 = columnIdx + size;
            end2 = contains.getLastIndex() + size;
        } else {
            start1 = contains.getIndex();
            end1 = columnIdx - 1;
            start2 = columnIdx + size;
            end2 = contains.getLastIndex() + size;
        }
        ColumnArrayImpl array = null;
        ColumnArrayImpl prev = null;
        this._columnArrays.remove((AbstractColumnArrayAdv)contains);
        if (start2 <= end2 && end2 > -1) {
            prev = new ColumnArrayImpl(this, start2, end2);
            this._columnArrays.put(prev);
            if (contains != null) {
                prev.setCellStyle(contains.getCellStyle());
                prev.setHidden(contains.isHidden());
                prev.setWidth(contains.getWidth());
            }
        }
        array = new ColumnArrayImpl(this, columnIdx, columnIdx + size - 1);
        this._columnArrays.put(array);
        if (start1 <= end1 && end1 > -1) {
            prev = new ColumnArrayImpl(this, start1, end1);
            this._columnArrays.put(prev);
            if (contains != null) {
                prev.setCellStyle(contains.getCellStyle());
                prev.setHidden(contains.isHidden());
                prev.setWidth(contains.getWidth());
            }
        }
        if ((exceeds = new ArrayList<AbstractColumnArrayAdv>(this._columnArrays.firstSubValues(maxSize = this.getBook().getMaxColumnSize(), Integer.MAX_VALUE))).size() > 0) {
            this._columnArrays.trim(maxSize);
        }
        for (AbstractColumnArrayAdv ca : exceeds) {
            ca.destroy();
        }
        this.checkColumnArrayStatus();
    }

    @Override
    public void deleteColumn(int columnIdx, int lastColumnIdx) {
        this.checkOrphan();
        if (columnIdx > lastColumnIdx) {
            throw new IllegalArgumentException(columnIdx + ">" + lastColumnIdx);
        }
        int size = lastColumnIdx - columnIdx + 1;
        this.deleteAndShrinkColumnArray(columnIdx, size);
        for (AbstractRowAdv row : this._rows.values()) {
            row.deleteCell(columnIdx, size);
        }
        EngineFactory.getInstance().createFormulaEngine().clearCache(new FormulaClearContext(this));
        Map<String, Object> dataBefore = this.shiftBeforeColumnDelete(columnIdx, lastColumnIdx);
        ModelUpdateUtil.addInsertDeleteUpdate(this, false, false, columnIdx, lastColumnIdx);
        this.shiftAfterColumnDelete(dataBefore, columnIdx, lastColumnIdx);
    }

    private Map<String, Object> shiftBeforeColumnDelete(int columnIdx, int lastColumnIdx) {
        HashMap<String, Object> dataBefore = new HashMap<String, Object>();
        CellRegion affectedRegion = new CellRegion(0, columnIdx, this._book.getMaxRowIndex(), this._book.getMaxColumnIndex());
        List<CellRegion> toShrink = this.getOverlapsMergedRegions(affectedRegion, false);
        this.removeMergedRegion(affectedRegion, true);
        dataBefore.put("toShrink", toShrink);
        return dataBefore;
    }

    /*
     * WARNING - void declaration
     */
    private void shiftAfterColumnDelete(Map<String, Object> dataBefore, int columnIdx, int lastColumnIdx) {
        int idx;
        ViewAnchor anchor;
        int size = lastColumnIdx - columnIdx + 1;
        for (AbstractPictureAdv abstractPictureAdv : this._pictures) {
            anchor = abstractPictureAdv.getAnchor();
            idx = anchor.getColumnIndex();
            if (idx >= columnIdx + size) {
                anchor.setColumnIndex(idx - size);
                continue;
            }
            if (idx < columnIdx) continue;
            anchor.setColumnIndex(columnIdx);
            anchor.setXOffset(0);
        }
        for (AbstractChartAdv abstractChartAdv : this._charts) {
            anchor = abstractChartAdv.getAnchor();
            idx = anchor.getColumnIndex();
            if (idx >= columnIdx + size) {
                anchor.setColumnIndex(idx - size);
                continue;
            }
            if (idx < columnIdx) continue;
            anchor.setColumnIndex(columnIdx);
            anchor.setXOffset(0);
        }
        List toShrink = (List)dataBefore.get("toShrink");
        for (CellRegion r : toShrink) {
            CellRegion shrank = this.shrinkColumn(r, columnIdx, lastColumnIdx);
            if (shrank == null) continue;
            this.addMergedRegion(shrank);
        }
        this.shrinkFormula(new CellRegion(0, columnIdx, this._book.getMaxRowIndex(), lastColumnIdx), true);
        int n = this._viewInfo.getNumOfColumnFreeze() - 1;
        if (n >= columnIdx) {
            void var6_13;
            if (n < lastColumnIdx) {
                int n2 = columnIdx - 1;
            } else {
                int n3 = n - (lastColumnIdx - columnIdx + 1);
            }
            this._viewInfo.setNumOfColumnFreeze(var6_13 < 0 ? 0 : var6_13 + true);
        }
    }

    private void deleteAndShrinkColumnArray(int columnIdx, int size) {
        int arrLastIdx;
        int arrIdx;
        if (this._columnArrays.hasLastKey(columnIdx)) {
            return;
        }
        LinkedList<AbstractColumnArrayAdv> remove = new LinkedList<AbstractColumnArrayAdv>();
        LinkedList<AbstractColumnArrayAdv> contains = new LinkedList<AbstractColumnArrayAdv>();
        LinkedList<AbstractColumnArrayAdv> leftOver = new LinkedList<AbstractColumnArrayAdv>();
        LinkedList<AbstractColumnArrayAdv> rightOver = new LinkedList<AbstractColumnArrayAdv>();
        LinkedList<AbstractColumnArrayAdv> right = new LinkedList<AbstractColumnArrayAdv>();
        int lastColumnIdx = columnIdx + size - 1;
        for (AbstractColumnArrayAdv array : this._columnArrays.lastSubMap(columnIdx).values()) {
            arrIdx = array.getIndex();
            arrLastIdx = array.getLastIndex();
            if (arrIdx < columnIdx && arrLastIdx > lastColumnIdx) {
                contains.add(array);
                continue;
            }
            if (arrIdx < columnIdx && arrLastIdx >= columnIdx) {
                leftOver.add(array);
                continue;
            }
            if (arrIdx >= columnIdx && arrLastIdx <= lastColumnIdx) {
                remove.add(array);
                continue;
            }
            if (arrIdx <= lastColumnIdx && arrLastIdx > lastColumnIdx) {
                rightOver.add(array);
                continue;
            }
            if (arrIdx > lastColumnIdx) {
                right.add(array);
                continue;
            }
            throw new IllegalStateException("wrong array state");
        }
        for (AbstractColumnArrayAdv array : contains) {
            this._columnArrays.remove(array);
            array.setLastIndex(array.getLastIndex() - size);
            this._columnArrays.put(array);
        }
        for (AbstractColumnArrayAdv array : leftOver) {
            this._columnArrays.remove(array);
            array.setLastIndex(columnIdx - 1);
            this._columnArrays.put(array);
        }
        for (AbstractColumnArrayAdv array : remove) {
            this._columnArrays.remove(array);
        }
        for (AbstractColumnArrayAdv array : rightOver) {
            arrIdx = array.getIndex();
            arrLastIdx = array.getLastIndex();
            this._columnArrays.remove(array);
            array.setIndex(columnIdx);
            array.setLastIndex(columnIdx + arrLastIdx - lastColumnIdx - 1);
            this._columnArrays.put(array);
        }
        for (AbstractColumnArrayAdv array : right) {
            arrIdx = array.getIndex();
            arrLastIdx = array.getLastIndex();
            this._columnArrays.remove(array);
            array.setIndex(arrIdx - size);
            array.setLastIndex(arrLastIdx - size);
            this._columnArrays.put(array);
        }
        this.checkColumnArrayStatus();
    }

    @Override
    public void moveCell(CellRegion region, int rowOffset, int columnOffset) {
        this.moveCell(region.getRow(), region.getColumn(), region.getLastRow(), region.getLastColumn(), rowOffset, columnOffset);
    }

    @Override
    public void moveCell(int rowIdx, int columnIdx, int lastRowIdx, int lastColumnIdx, int rowOffset, int columnOffset) {
        if (rowOffset == 0 && columnOffset == 0) {
            return;
        }
        int maxRow = this.getBook().getMaxRowIndex();
        int maxCol = this.getBook().getMaxColumnIndex();
        if (rowIdx < 0 || columnIdx < 0 || rowIdx > lastRowIdx || lastRowIdx > maxRow || columnIdx > lastColumnIdx || lastColumnIdx > maxCol) {
            throw new InvalidModelOpException(new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx).getReferenceString() + " is illegal");
        }
        if (rowIdx + rowOffset < 0 || columnIdx + columnOffset < 0 || lastRowIdx + rowOffset > maxRow || lastColumnIdx + columnOffset > maxCol) {
            throw new InvalidModelOpException(new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx).getReferenceString() + " can't move to offset " + rowOffset + "," + columnOffset);
        }
        CellRegion srcRegion = new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx);
        List<CellRegion> containsMerge = this.getContainsMergedRegions(srcRegion);
        List<CellRegion> overlapsMerge = this.getOverlapsMergedRegions(srcRegion, true);
        if (overlapsMerge.size() > 0) {
            throw new InvalidModelOpException("Can't move " + srcRegion.getReferenceString() + " which overlaps merge area " + ((CellRegion)overlapsMerge.iterator().next()).getReferenceString());
        }
        CellRegion targetRegion = new CellRegion(rowIdx + rowOffset, columnIdx + columnOffset, lastRowIdx + rowOffset, lastColumnIdx + columnOffset);
        this.removeMergedRegion(targetRegion, true);
        boolean reverseYDir = rowOffset > 0;
        boolean reverseXDir = columnOffset > 0;
        int rowStart = reverseYDir ? lastRowIdx : rowIdx;
        int rowEnd = reverseYDir ? rowIdx : lastRowIdx;
        int colStart = reverseXDir ? lastColumnIdx : columnIdx;
        int colEnd = reverseXDir ? columnIdx : lastColumnIdx;
        int r = rowStart;
        while (reverseYDir ? r >= rowEnd : r <= rowEnd) {
            int tr = r + rowOffset;
            AbstractRowAdv row = this.getRow(r, false);
            int c = colStart;
            while (reverseXDir ? c >= colEnd : c <= colEnd) {
                AbstractCellAdv cell;
                int tc = c + columnOffset;
                AbstractCellAdv abstractCellAdv = cell = row == null ? null : row.getCell(c, false);
                if (cell == null) {
                    this.clearCell(tr, tc, tr, tc);
                } else {
                    AbstractRowAdv target = this.getOrCreateRow(tr);
                    row.moveCellTo(target, c, c, columnOffset);
                }
                if (reverseXDir) {
                    --c;
                    continue;
                }
                ++c;
            }
            if (reverseYDir) {
                --r;
                continue;
            }
            ++r;
        }
        if (!this._book.isPostProcessing()) {
            ModelUpdateUtil.handlePrecedentUpdate(this.getBook().getBookSeries(), new RefImpl(this.getBook().getBookName(), this.getSheetName(), rowIdx, columnIdx, lastRowIdx, lastColumnIdx));
            ModelUpdateUtil.handlePrecedentUpdate(this.getBook().getBookSeries(), new RefImpl(this.getBook().getBookName(), this.getSheetName(), rowIdx + rowOffset, columnIdx + columnOffset, lastRowIdx + rowOffset, lastColumnIdx + columnOffset));
        }
        this._mergedRegions.removeAll(containsMerge);
        for (CellRegion merge : containsMerge) {
            CellRegion newMerge = new CellRegion(merge.getRow() + rowOffset, merge.getColumn() + columnOffset, merge.getLastRow() + rowOffset, merge.getLastColumn() + columnOffset);
            this._mergedRegions.add(newMerge);
            ModelUpdateUtil.addMergeUpdate(this, merge, newMerge);
        }
        this.shiftAfterCellMove(rowIdx, columnIdx, lastRowIdx, lastColumnIdx, rowOffset, columnOffset);
    }

    private void shiftAfterCellMove(int rowIdx, int columnIdx, int lastRowIdx, int lastColumnIdx, int rowOffset, int columnOffset) {
        this.moveFormula(new CellRegion(rowIdx, columnIdx, lastRowIdx, lastColumnIdx), rowOffset, columnOffset);
    }

    private void moveFormula(CellRegion src, int rowOffset, int columnOffset) {
        SBook book = this.getBook();
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)book.getBookSeries();
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(new RefImpl(book.getBookName(), this.getSheetName(), src.getRow(), src.getColumn(), src.getLastRow(), src.getLastColumn()));
        if (dependents.size() > 0) {
            FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
            tuner.move(new SheetRegion((SSheet)this, src), dependents, rowOffset, columnOffset);
        }
    }

    private void shrinkFormula(CellRegion src, boolean horizontal) {
        RefImpl ref;
        SBook book = this.getBook();
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)book.getBookSeries();
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(ref = new RefImpl(book.getBookName(), this.getSheetName(), src.getRow(), src.getColumn(), horizontal ? src.getLastRow() : book.getMaxRowIndex(), horizontal ? book.getMaxColumnIndex() : src.getLastColumn()));
        if (dependents.size() > 0) {
            FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
            tuner.shrink(new SheetRegion((SSheet)this, src), dependents, horizontal);
        }
    }

    private void extendFormula(CellRegion src, boolean horizontal) {
        RefImpl ref;
        SBook book = this.getBook();
        AbstractBookSeriesAdv bs = (AbstractBookSeriesAdv)book.getBookSeries();
        DependencyTable dt = bs.getDependencyTable();
        Set<Ref> dependents = dt.getDirectDependents(ref = new RefImpl(book.getBookName(), this.getSheetName(), src.getRow(), src.getColumn(), horizontal ? src.getLastRow() : book.getMaxRowIndex(), horizontal ? book.getMaxColumnIndex() : src.getLastColumn()));
        if (dependents.size() > 0) {
            FormulaTunerHelper tuner = new FormulaTunerHelper(bs);
            tuner.extend(new SheetRegion((SSheet)this, src), dependents, horizontal);
        }
    }

    @Override
    public void checkOrphan() {
        if (this._book == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        for (AbstractColumnArrayAdv column : this._columnArrays.values()) {
            column.destroy();
        }
        this._columnArrays.clear();
        for (AbstractRowAdv row : this._rows.values()) {
            row.destroy();
        }
        this._rows.clear();
        for (AbstractChartAdv chart : this._charts) {
            chart.destroy();
        }
        this._charts.clear();
        for (AbstractPictureAdv picture : this._pictures) {
            picture.destroy();
        }
        this._pictures.clear();
        for (AbstractDataValidationAdv validation : this._dataValidations) {
            validation.destroy();
        }
        this._dataValidations.clear();
        this._book = null;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public SPicture addPicture(SPicture.Format format, byte[] data, ViewAnchor anchor) {
        this.checkOrphan();
        PictureImpl pic = new PictureImpl(this, this._book.nextObjId("pic"), format, data, anchor);
        this._pictures.add(pic);
        return pic;
    }

    @Override
    public SPicture addPicture(int picDataIndex, ViewAnchor anchor) {
        this.checkOrphan();
        PictureImpl pic = new PictureImpl(this, this._book.nextObjId("pic"), picDataIndex, anchor);
        this._pictures.add(pic);
        return pic;
    }

    @Override
    public SPicture getPicture(String picid) {
        for (SPicture sPicture : this._pictures) {
            if (!sPicture.getId().equals(picid)) continue;
            return sPicture;
        }
        return null;
    }

    @Override
    public void deletePicture(SPicture picture) {
        this.checkOrphan();
        this.checkOwnership(picture);
        ((AbstractPictureAdv)picture).destroy();
        this._pictures.remove(picture);
    }

    @Override
    public List<SPicture> getPictures() {
        return Collections.unmodifiableList(this._pictures);
    }

    @Override
    public int getNumOfPicture() {
        return this._pictures.size();
    }

    @Override
    public SPicture getPicture(int idx) {
        return this._pictures.get(idx);
    }

    @Override
    public SChart addChart(SChart.ChartType type, ViewAnchor anchor) {
        this.checkOrphan();
        ChartImpl pic = new ChartImpl(this, this._book.nextObjId("chart"), type, anchor);
        this._charts.add(pic);
        return pic;
    }

    @Override
    public SChart getChart(String picid) {
        for (SChart sChart : this._charts) {
            if (!sChart.getId().equals(picid)) continue;
            return sChart;
        }
        return null;
    }

    @Override
    public void deleteChart(SChart chart) {
        this.checkOrphan();
        this.checkOwnership(chart);
        ((AbstractChartAdv)chart).destroy();
        this._charts.remove(chart);
    }

    @Override
    public List<SChart> getCharts() {
        return Collections.unmodifiableList(this._charts);
    }

    @Override
    public int getNumOfChart() {
        return this._charts.size();
    }

    @Override
    public SChart getChart(int idx) {
        return this._charts.get(idx);
    }

    @Override
    public List<CellRegion> getMergedRegions() {
        return Collections.unmodifiableList(this._mergedRegions);
    }

    @Override
    public void removeMergedRegion(CellRegion region, boolean removeOverlaps) {
        boolean removed = false;
        for (CellRegion r : new ArrayList<CellRegion>(this._mergedRegions)) {
            if ((!removeOverlaps || !region.overlaps(r)) && !region.contains(r)) continue;
            this._mergedRegions.remove(r);
            ModelUpdateUtil.addMergeUpdate(this, r, null);
            removed = true;
        }
        if (removed && this.getMergeOutOfSync() == 0) {
            this.setMergeOutOfSync(1);
        }
    }

    @Override
    public void addMergedRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (region.isSingle()) {
            return;
        }
        for (CellRegion r : this._mergedRegions) {
            if (!r.overlaps(region)) continue;
            throw new InvalidModelOpException("the region is overlapped " + r + ":" + region);
        }
        this._mergedRegions.add(region);
        ModelUpdateUtil.addMergeUpdate(this, null, region);
        if (this.getMergeOutOfSync() == 0) {
            this.setMergeOutOfSync(1);
        }
    }

    @Override
    public List<CellRegion> getOverlapsMergedRegions(CellRegion region, boolean excludeContains) {
        LinkedList<CellRegion> list = new LinkedList<CellRegion>();
        for (CellRegion r : this._mergedRegions) {
            if (excludeContains && region.contains(r) || !r.overlaps(region)) continue;
            list.add(r);
        }
        return list;
    }

    @Override
    public List<CellRegion> getContainsMergedRegions(CellRegion region) {
        LinkedList<CellRegion> list = new LinkedList<CellRegion>();
        for (CellRegion r : this._mergedRegions) {
            if (!region.contains(r)) continue;
            list.add(r);
        }
        return list;
    }

    @Override
    public CellRegion getMergedRegion(String cellRef) {
        CellRegion region = new CellRegion(cellRef);
        if (!region.isSingle()) {
            throw new InvalidModelOpException("not a single ref " + cellRef);
        }
        return this.getMergedRegion(region.getRow(), region.getColumn());
    }

    @Override
    public CellRegion getMergedRegion(int row, int column) {
        for (CellRegion r : this._mergedRegions) {
            if (!r.contains(row, column)) continue;
            return r;
        }
        return null;
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes == null ? null : this._attributes.get(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        return this._attributes.put(name, value);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attributes == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this._attributes);
    }

    @Override
    public Iterator<SRow> getRowIterator() {
        return Collections.unmodifiableCollection(this._rows.values()).iterator();
    }

    @Override
    public Iterator<SColumnArray> getColumnArrayIterator() {
        return Collections.unmodifiableCollection(this._columnArrays.values()).iterator();
    }

    @Override
    public Iterator<SColumn> getColumnIterator() {
        return new Iterator<SColumn>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                return SheetImpl.this.getColumnArray(this.index + 1) != null;
            }

            @Override
            public SColumn next() {
                ++this.index;
                return SheetImpl.this.getColumn(this.index);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("readonly");
            }
        };
    }

    @Override
    public Iterator<SCell> getCellIterator(int row) {
        return ((AbstractRowAdv)this.getRow(row)).getCellIterator(false);
    }

    @Override
    public int getDefaultRowHeight() {
        return this._defaultRowHeight;
    }

    @Override
    public int getDefaultColumnWidth() {
        return this._defaultColumnWidth;
    }

    @Override
    public void setDefaultRowHeight(int height) {
        this._defaultRowHeight = height;
    }

    @Override
    public void setDefaultColumnWidth(int width) {
        this._defaultColumnWidth = width;
    }

    @Override
    public int getNumOfMergedRegion() {
        return this._mergedRegions.size();
    }

    @Override
    public CellRegion getMergedRegion(int idx) {
        return this._mergedRegions.get(idx);
    }

    @Override
    public boolean isProtected() {
        return this._protected;
    }

    @Override
    public void setPassword(String password) {
        this._protected = password != null;
        short s = this._password = password == null || password.isEmpty() ? (short)0 : WorkbookUtil.hashPassword((String)password);
        if (password != null && !password.isEmpty()) {
            this._algName = "SHA-512";
            this._saltValue = SheetUtil.base64Random16Bytes();
            this._spinCount = "100000";
            this._hashValue = SheetUtil.encryptPassword((String)password, (String)this._algName, (String)this._saltValue, (int)Integer.parseInt(this._spinCount));
        } else {
            this._algName = null;
            this._saltValue = null;
            this._spinCount = null;
            this._hashValue = null;
        }
    }

    @Override
    public short getHashedPassword() {
        return this._password;
    }

    @Override
    public SSheetViewInfo getViewInfo() {
        return this._viewInfo;
    }

    @Override
    public SPrintSetup getPrintSetup() {
        return this._printSetup;
    }

    @Override
    public SDataValidation addDataValidation(CellRegion region) {
        return this.addDataValidation(region, null);
    }

    @Override
    public SDataValidation addDataValidation(CellRegion region, SDataValidation src) {
        this.checkOrphan();
        Validations.argInstance(src, AbstractDataValidationAdv.class);
        DataValidationImpl validation = new DataValidationImpl((AbstractSheetAdv)this, this._book.nextObjId("valid"));
        this._dataValidations.add(validation);
        if (src != null) {
            ((AbstractDataValidationAdv)validation).copyFrom((AbstractDataValidationAdv)src);
        }
        if (region != null) {
            validation.addRegion(region);
        }
        return validation;
    }

    @Override
    public SDataValidation getDataValidation(String validationid) {
        for (SDataValidation sDataValidation : this._dataValidations) {
            if (!sDataValidation.getId().equals(validationid)) continue;
            return sDataValidation;
        }
        return null;
    }

    @Override
    public void deleteDataValidation(SDataValidation validationid) {
        this.checkOrphan();
        this.checkOwnership(validationid);
        ((AbstractDataValidationAdv)validationid).destroy();
        this._dataValidations.remove(validationid);
    }

    @Override
    public void removeDataValidationRegion(CellRegion region) {
        this.deleteDataValidationRegion(region);
    }

    @Override
    public List<SDataValidation> deleteDataValidationRegion(CellRegion region) {
        ArrayList<SDataValidation> dels = new ArrayList<SDataValidation>();
        for (SDataValidation validation : this.getDataValidations()) {
            validation.removeRegion(region);
            if (validation.getRegions() != null) continue;
            dels.add(validation);
        }
        for (SDataValidation validation : dels) {
            this.deleteDataValidation(validation);
        }
        return dels;
    }

    @Override
    public List<SDataValidation> getDataValidations() {
        return Collections.unmodifiableList(this._dataValidations);
    }

    @Override
    public int getNumOfDataValidation() {
        return this._dataValidations.size();
    }

    @Override
    public SDataValidation getDataValidation(int idx) {
        return this._dataValidations.get(idx);
    }

    @Override
    public SDataValidation getDataValidation(int rowIdx, int columnIdx) {
        for (SDataValidation sDataValidation : this._dataValidations) {
            for (CellRegion regn : sDataValidation.getRegions()) {
                if (!regn.contains(rowIdx, columnIdx)) continue;
                return sDataValidation;
            }
        }
        return null;
    }

    @Override
    public SAutoFilter getAutoFilter() {
        return this._autoFilter;
    }

    @Override
    public SAutoFilter createAutoFilter(CellRegion region) {
        Validations.argNotNull(region);
        this._autoFilter = new AutoFilterImpl(region);
        int left = region.getColumn();
        int top = region.getRow();
        int right = region.getLastColumn();
        int bottom = region.getLastRow();
        for (CellRegion mrng : this.getMergedRegions()) {
            int t = mrng.getRow();
            int b = mrng.getLastRow();
            int l = mrng.getColumn();
            int r = mrng.getLastColumn();
            if (t != top || l > right || l < left) continue;
            for (int c = l; c < r; ++c) {
                int colId = c - left;
                SAutoFilter.NFilterColumn col = this._autoFilter.getFilterColumn(colId, true);
                col.setProperties(SAutoFilter.FilterOp.and, null, null, false);
            }
        }
        this.addIntoDependency(this._autoFilter);
        return this._autoFilter;
    }

    private void addIntoDependency(SAutoFilter filter) {
        SBook book = this.getBook();
        String bookName = book.getBookName();
        String sheetName = this.getSheetName();
        ObjectRefImpl dependent = new ObjectRefImpl(bookName, sheetName, "AUTO_FILTER", ObjectRef.ObjectType.AUTO_FILTER);
        CellRegion rgn = filter.getRegion();
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        RefImpl dummy = new RefImpl(bookName, sheetName, rgn.row, rgn.column, rgn.lastRow, rgn.lastColumn);
        dt.add(dependent, dummy);
        ModelUpdateUtil.addRefUpdate(dependent);
    }

    private void deleteFromDependency() {
        SBook book = this.getBook();
        String bookName = book.getBookName();
        String sheetName = this.getSheetName();
        ObjectRefImpl dependent = new ObjectRefImpl(bookName, sheetName, "AUTO_FILTER", ObjectRef.ObjectType.AUTO_FILTER);
        DependencyTable dt = ((AbstractBookSeriesAdv)book.getBookSeries()).getDependencyTable();
        dt.clearDependents(dependent);
    }

    @Override
    public void deleteAutoFilter() {
        this.deleteFromDependency();
        this._autoFilter = null;
    }

    @Override
    public void clearAutoFilter() {
        this._autoFilter = null;
    }

    @Override
    public CellRegion pasteCell(SheetRegion src, CellRegion dest, PasteOption option) {
        return new PasteCellHelper(this).pasteCell(src, dest, option);
    }

    @Override
    public SSheetProtection getSheetProtection() {
        if (this._sheetProtection == null) {
            this._sheetProtection = new SheetProtectionImpl();
        }
        return this._sheetProtection;
    }

    @Override
    public void setHashedPassword(short hashpass) {
        this._password = hashpass;
    }

    @Override
    public SSheet.SheetVisible getSheetVisible() {
        return this._visible;
    }

    @Override
    public void setSheetVisible(SSheet.SheetVisible state) {
        this._visible = state;
    }

    @Override
    public void addTable(STable table) {
        this._tables.add(table);
    }

    @Override
    public List<STable> getTables() {
        return Collections.unmodifiableList(this._tables);
    }

    @Override
    public void removeTable(String name) {
        Iterator<STable> it = this._tables.iterator();
        while (it.hasNext()) {
            STable tb = it.next();
            if (!name.equalsIgnoreCase(tb.getName())) continue;
            it.remove();
            break;
        }
    }

    @Override
    public STable getTableByRowCol(int rowIdx, int colIdx) {
        for (STable tb : this._tables) {
            SheetRegion srgn = tb.getAllRegion();
            CellRegion rgn = srgn.getRegion();
            if (rgn.getColumn() > colIdx || colIdx > rgn.getLastColumn() || rgn.getRow() > rowIdx || rowIdx > rgn.getLastRow()) continue;
            return tb;
        }
        return null;
    }

    @Override
    public boolean isHidden(int rowIdx, int colIdx) {
        SRow row = this.getRow(rowIdx);
        if (row.isHidden()) {
            return true;
        }
        SColumnArray colArray = this.getColumnArray(colIdx);
        return colArray == null ? false : colArray.isHidden();
    }

    @Override
    public void removeTables(Set<String> tableNames) {
        if (tableNames.isEmpty()) {
            return;
        }
        Iterator<STable> it = this._tables.iterator();
        while (it.hasNext()) {
            STable tb = it.next();
            String tbName = tb.getName().toUpperCase();
            if (!tableNames.contains(tbName)) continue;
            it.remove();
            tableNames.remove(tbName);
            if (!tableNames.isEmpty()) continue;
            break;
        }
    }

    @Override
    public void removeTable(STable table) {
        this._tables.remove(table);
    }

    @Override
    public void clearTables() {
        this._tables.clear();
    }

    @Override
    public void setHashValue(String hashValue) {
        this._hashValue = hashValue;
    }

    public String getHashValue() {
        return this._hashValue;
    }

    @Override
    public void setSpinCount(String spinCount) {
        this._spinCount = spinCount;
    }

    public String getSpinCount() {
        return this._spinCount;
    }

    @Override
    public void setSaltValue(String saltValue) {
        this._saltValue = saltValue;
    }

    public String getSaltValue() {
        return this._saltValue;
    }

    @Override
    public void setAlgName(String algName) {
        this._algName = algName;
    }

    public String getAlgName() {
        return this._algName;
    }

    public CellRegion checkMergedRegion(CellRegion region) {
        Validations.argNotNull(region);
        if (region.isSingle()) {
            return null;
        }
        for (CellRegion r : this._mergedRegions) {
            if (!r.overlaps(region)) continue;
            return r;
        }
        return null;
    }

    public void addDirectlyMergedRegion(CellRegion region) {
        if (region.isSingle()) {
            return;
        }
        this._mergedRegions.add(region);
        ModelUpdateUtil.addMergeUpdate(this, null, region);
    }

    @Override
    public List<SConditionalFormatting> getConditionalFormattings() {
        return this._conditionalFormattings == null ? Collections.EMPTY_LIST : this._conditionalFormattings;
    }

    @Override
    public void addConditionalFormatting(SConditionalFormatting scf) {
        if (this._conditionalFormattings == null) {
            this._conditionalFormattings = new ArrayList<SConditionalFormatting>();
        }
        this._conditionalFormattings.add(scf);
        if (this._conditionalMap == null) {
            this._conditionalMap = new HashMap<Integer, SConditionalFormatting>();
        }
        this._conditionalMap.put(scf.getId(), scf);
    }

    @Override
    public void setMergeOutOfSync(int state) {
        this._mergeOutOfSync = state;
    }

    @Override
    public int getMergeOutOfSync() {
        return this._mergeOutOfSync;
    }

    @Override
    public CellRegion getDataRegion() {
        List<SChart> charts;
        int firstCol = 0;
        int endCol = -1;
        int firstRow = 0;
        int endRow = -1;
        SBook _wb = this.getBook();
        Iterator<SRow> rowIter = this.getRowIterator();
        while (rowIter.hasNext()) {
            int col;
            int lastNonBlankCol;
            CellRegion mergedRegion;
            SRow row = rowIter.next();
            int rowIdx = row.getIndex();
            int lastCol = this.getEndCellIndex(rowIdx);
            if (lastCol < 0) {
                if (row.getCellStyle(true) == null || row.getCellStyle().getFill().equals(_wb.getDefaultCellStyle().getFill())) continue;
                endRow = Math.max(endRow, rowIdx);
            }
            if ((mergedRegion = this.getMergedRegionIfAny(rowIdx, lastNonBlankCol = this.searchNonBlankEndColumn(rowIdx, lastCol))) != null) {
                col = mergedRegion.getLastColumn();
                if (col > lastCol) {
                    lastCol = col;
                }
            } else {
                col = lastNonBlankCol;
                if (col > lastCol) {
                    lastCol = col;
                }
            }
            endCol = Math.max(endCol, lastCol);
            endRow = Math.max(endRow, row.getIndex());
        }
        List<SPicture> pics = this.getPictures();
        if (pics != null && pics.size() != 0) {
            for (SPicture pic : pics) {
                ViewAnchor anchor1 = pic.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(this);
                if (anchor2.getColumnIndex() > endCol) {
                    endCol = anchor2.getColumnIndex();
                }
                if (anchor2.getRowIndex() <= endRow) continue;
                endRow = anchor2.getRowIndex();
            }
        }
        if ((charts = this.getCharts()) != null && charts.size() != 0) {
            for (SChart chart : charts) {
                ViewAnchor anchor1 = chart.getAnchor();
                ViewAnchor anchor2 = anchor1.getRightBottomAnchor(this);
                if (anchor2.getColumnIndex() > endCol) {
                    endCol = anchor2.getColumnIndex();
                }
                if (anchor2.getRowIndex() <= endRow) continue;
                endRow = anchor2.getRowIndex();
            }
        }
        return endRow < 0 || endCol < 0 ? null : new CellRegion(firstRow, firstCol, endRow, endCol);
    }

    private CellRegion getMergedRegionIfAny(int rowIdx, int colIdx) {
        CellRegion partOfRange = null;
        for (CellRegion range : this.getMergedRegions()) {
            if (colIdx < range.getColumn() || colIdx > range.getLastColumn() || rowIdx < range.getRow() || rowIdx > range.getLastRow()) continue;
            partOfRange = range;
            break;
        }
        return partOfRange;
    }

    private int searchNonBlankEndColumn(int rowIdx, int lastColIdx) {
        int last = -1;
        for (int i = lastColIdx; i >= 0; --i) {
            SCell cell = this.getCell(rowIdx, i);
            if (cell.isNull() || cell.getType() == SCell.CellType.BLANK) continue;
            last = i;
            break;
        }
        return last;
    }

    @Override
    public ConditionalStyleImpl getConditionalFormattingStyle(int row, int col) {
        String dataFormat = null;
        SFont font = null;
        SBorder border = null;
        SFill fill = null;
        SColorScale scale = null;
        SIconSet iconSet = null;
        SDataBar dataBar = null;
        Double barPercent = null;
        Integer iconSetId = null;
        ArrayList<SConditionalFormatting> cdfmts = new ArrayList<SConditionalFormatting>();
        block0: for (SConditionalFormatting fmt : this.getConditionalFormattings()) {
            for (CellRegion rgn : fmt.getRegions()) {
                if (!rgn.contains(row, col)) continue;
                cdfmts.add(fmt);
                continue block0;
            }
        }
        SCell cell = this.getCell(row, col);
        CellValue cv = ((AbstractCellAdv)cell).getEvalCellValue(true);
        SCell.CellType type = cv.getType();
        Object value = cv.getValue();
        boolean found = false;
        block2: for (SConditionalFormatting fmt : cdfmts) {
            Set<CellRegion> rgns = fmt.getRegions();
            for (SConditionalFormattingRule rule : fmt.getRules()) {
                if (!((ConditionalFormattingRuleImpl)rule).match(cell)) continue;
                SExtraStyle extraStyle = rule.getExtraStyle();
                if (extraStyle != null) {
                    if (dataFormat == null) {
                        dataFormat = extraStyle.getDataFormat();
                    }
                    if (font == null) {
                        font = extraStyle.getFont();
                    }
                    if (border == null) {
                        border = extraStyle.getBorder();
                    }
                    if (fill == null) {
                        fill = extraStyle.getFill();
                    }
                }
                if (type == SCell.CellType.NUMBER) {
                    SFill fill0;
                    if (value instanceof Date) {
                        value = DateUtil.getExcelDate((Date)((Date)value));
                    }
                    if (scale == null && (scale = rule.getColorScale()) != null && (fill0 = ((ConditionalFormattingRuleImpl)rule).getColorScaleFill((double)((Double)value))) != null) {
                        fill = fill0;
                    }
                    if (iconSet == null && (iconSet = rule.getIconSet()) != null) {
                        iconSetId = ((ConditionalFormattingRuleImpl)rule).getIconSetId((double)((Double)value));
                    }
                    if (dataBar == null && (dataBar = rule.getDataBar()) != null) {
                        barPercent = ((ConditionalFormattingRuleImpl)rule).getDataBarPercent((double)((Double)value));
                    }
                }
                found = true;
                if (!rule.isStopIfTrue()) continue;
                continue block2;
            }
        }
        return !found ? null : new ConditionalStyleImpl(font, fill, border, dataFormat, scale, dataBar, barPercent, iconSet, iconSetId);
    }

    @Override
    public void removeConditionalFormatting(SConditionalFormatting scf) {
        if (this._conditionalFormattings == null) {
            return;
        }
        int len = this._conditionalFormattings.size();
        for (int j = 0; j < len; ++j) {
            SConditionalFormatting scf0 = this._conditionalFormattings.get(j);
            if (!scf0.equals(scf)) continue;
            this._conditionalFormattings.remove(j);
            this._conditionalMap.remove(scf0.getId());
            break;
        }
    }

    @Override
    public SConditionalFormatting addConditionalFormatting(CellRegion srcrgn, CellRegion dstrgn, SConditionalFormatting src, int rowOff, int colOff) {
        this.checkOrphan();
        Validations.argInstance(src, ConditionalFormattingImpl.class);
        ConditionalFormattingImpl dstcfmt = new ConditionalFormattingImpl(this);
        if (src != null) {
            dstcfmt.copyFrom((ConditionalFormattingImpl)src, rowOff, colOff);
        }
        if (dstrgn != null) {
            for (CellRegion rgn : src.getRegions()) {
                CellRegion xrgn = rgn.intersect(srcrgn);
                if (xrgn == null) continue;
                int r1 = xrgn.getRow() + rowOff;
                int r2 = xrgn.getLastRow() + rowOff;
                int c1 = xrgn.getColumn() + colOff;
                int c2 = xrgn.getLastColumn() + colOff;
                dstcfmt.addRegion(new CellRegion(r1, c1, r2, c2));
            }
        }
        this.addConditionalFormatting(dstcfmt);
        return dstcfmt;
    }

    @Override
    public int nextConditionalId() {
        return this._conditionalId++;
    }

    @Override
    public SConditionalFormatting getConditionalFormatting(int id) {
        return this._conditionalMap != null ? this._conditionalMap.get(id) : null;
    }

    @Override
    public SConditionalFormatting getConditionalFormatting(int row, int col) {
        if (this._conditionalFormattings == null) {
            return null;
        }
        for (SConditionalFormatting scf0 : this._conditionalFormattings) {
            for (CellRegion rgn : scf0.getRegions()) {
                if (!rgn.contains(row, col)) continue;
                return scf0;
            }
        }
        return null;
    }

    @Override
    public void deleteConditionalFormatting(SConditionalFormatting cfmt) {
        this.checkOrphan();
        ((ConditionalFormattingImpl)cfmt).destroy();
        this._conditionalFormattings.remove(cfmt);
    }

    @Override
    public void removeConditionalFormattingRegion(CellRegion region) {
        this.deleteConditionalFormattingRegion(region);
    }

    @Override
    public List<SConditionalFormatting> deleteConditionalFormattingRegion(CellRegion region) {
        ArrayList<SConditionalFormatting> dels = new ArrayList<SConditionalFormatting>();
        for (SConditionalFormatting cfmt : this.getConditionalFormattings()) {
            cfmt.removeRegion(region);
            if (cfmt.getRegions() != null) continue;
            dels.add(cfmt);
        }
        for (SConditionalFormatting cfmt : dels) {
            this.deleteConditionalFormatting(cfmt);
        }
        return dels;
    }

    static {
        if ("true".equalsIgnoreCase(Library.getProperty((String)"io.keikai.model.internal.CollumnArrayCheck"))) {
            COLUMN_ARRAY_CHECK = true;
        }
    }
}

