/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SCellStyle;
import io.keikai.model.SColumn;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractColumnArrayAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import java.lang.ref.WeakReference;

class ColumnProxy
implements SColumn {
    private static final long serialVersionUID = 1L;
    private final WeakReference<AbstractSheetAdv> _sheetRef;
    private final int _index;
    private AbstractColumnArrayAdv _proxy;

    public ColumnProxy(AbstractSheetAdv sheet, int index) {
        this._sheetRef = new WeakReference<AbstractSheetAdv>(sheet);
        this._index = index;
    }

    protected void loadProxy(boolean split) {
        if (split) {
            this._proxy = ((AbstractSheetAdv)this.getSheet()).getOrSplitColumnArray(this._index);
        } else if (this._proxy == null) {
            this._proxy = (AbstractColumnArrayAdv)((AbstractSheetAdv)this.getSheet()).getColumnArray(this._index);
        }
    }

    @Override
    public SSheet getSheet() {
        AbstractSheetAdv sheet = (AbstractSheetAdv)this._sheetRef.get();
        if (sheet == null) {
            throw new IllegalStateException("proxy target lost, you should't keep this instance");
        }
        return sheet;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public boolean isNull() {
        this.loadProxy(false);
        return this._proxy == null;
    }

    @Override
    public SCellStyle getCellStyle() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.getCellStyle();
        }
        return this.getSheet().getBook().getDefaultCellStyle();
    }

    @Override
    public SCellStyle getCellStyle(boolean local) {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.getCellStyle(local);
        }
        return local ? null : this.getSheet().getBook().getDefaultCellStyle();
    }

    @Override
    public void setCellStyle(SCellStyle cellStyle) {
        this.loadProxy(true);
        this._proxy.setCellStyle(cellStyle);
    }

    @Override
    public int getWidth() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.getWidth();
        }
        return this.getSheet().getDefaultColumnWidth();
    }

    @Override
    public boolean isHidden() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.isHidden();
        }
        return false;
    }

    @Override
    public void setWidth(int width) {
        this.loadProxy(true);
        this._proxy.setWidth(width);
    }

    @Override
    public void setHidden(boolean hidden) {
        this.loadProxy(true);
        this._proxy.setHidden(hidden);
    }

    @Override
    public boolean isCustomWidth() {
        this.loadProxy(false);
        if (this._proxy != null) {
            return this._proxy.isCustomWidth();
        }
        return false;
    }

    @Override
    public void setCustomWidth(boolean custom) {
        this.loadProxy(true);
        this._proxy.setCustomWidth(custom);
    }
}

