/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.impl.AbstractColumnArrayAdv;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

class ColumnArrayPool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeMap<Integer, AbstractColumnArrayAdv> _columnArrayFirst = new TreeMap();
    private final TreeMap<Integer, AbstractColumnArrayAdv> _columnArrayLast = new TreeMap();

    public boolean hasLastKey(int columnIdx) {
        return this._columnArrayLast.size() <= 0 || columnIdx > this._columnArrayLast.lastKey();
    }

    public SortedMap<Integer, AbstractColumnArrayAdv> lastSubMap(int columnIdx) {
        return this._columnArrayLast.subMap(columnIdx, true, this._columnArrayLast.lastKey(), true);
    }

    public Collection<AbstractColumnArrayAdv> firstSubValues(int start, int end) {
        return this._columnArrayFirst.subMap(start, true, end, true).values();
    }

    public Collection<AbstractColumnArrayAdv> values() {
        return this._columnArrayLast.values();
    }

    public AbstractColumnArrayAdv overlap(int index, int lastIndex) {
        NavigableMap<Integer, AbstractColumnArrayAdv> overlap;
        NavigableMap<Integer, AbstractColumnArrayAdv> navigableMap = overlap = this._columnArrayFirst.size() == 0 ? null : this._columnArrayFirst.subMap(index, true, lastIndex, true);
        if (overlap != null && overlap.size() > 0) {
            return (AbstractColumnArrayAdv)overlap.get(overlap.firstKey());
        }
        NavigableMap<Integer, AbstractColumnArrayAdv> navigableMap2 = overlap = this._columnArrayLast.size() == 0 ? null : this._columnArrayLast.subMap(index, true, lastIndex, true);
        if (overlap != null && overlap.size() > 0) {
            return (AbstractColumnArrayAdv)overlap.get(overlap.firstKey());
        }
        return null;
    }

    public int size() {
        return this._columnArrayLast.size();
    }

    public int lastLastKey() {
        return this._columnArrayLast.lastKey();
    }

    public void put(AbstractColumnArrayAdv array) {
        AbstractColumnArrayAdv old = this._columnArrayFirst.put(array.getIndex(), array);
        if (old != null) {
            throw new IllegalStateException("try to replace a column array in first map " + old + ", new " + array);
        }
        old = this._columnArrayLast.put(array.getLastIndex(), array);
        if (old != null) {
            throw new IllegalStateException("try to replace a column array in last map" + old + ", new " + array);
        }
    }

    public void remove(AbstractColumnArrayAdv array) {
        this._columnArrayFirst.remove(array.getIndex());
        this._columnArrayLast.remove(array.getLastIndex());
    }

    public int firstFirstKey() {
        return this._columnArrayFirst.firstKey();
    }

    public void clear() {
        this._columnArrayFirst.clear();
        this._columnArrayLast.clear();
    }

    public Collection<AbstractColumnArrayAdv> trim(int start) {
        Collection effected = this._columnArrayFirst.tailMap(start, true).values();
        LinkedList<AbstractColumnArrayAdv> remove = new LinkedList<AbstractColumnArrayAdv>();
        for (AbstractColumnArrayAdv array : new ArrayList(effected)) {
            this.remove(array);
            remove.add(array);
        }
        return remove;
    }
}

