/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.PersistenceClusterDataRecoveryPolicy;
import com.hazelcast.config.PersistenceConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Objects;

public final class PersistenceAndHotRestartPersistenceMerger {
    private static final ILogger LOGGER = Logger.getLogger(PersistenceAndHotRestartPersistenceMerger.class);

    private PersistenceAndHotRestartPersistenceMerger() {
    }

    public static void merge(HotRestartPersistenceConfig hotRestartPersistenceConfig, PersistenceConfig persistenceConfig) {
        if (PersistenceAndHotRestartPersistenceMerger.equals(hotRestartPersistenceConfig, persistenceConfig)) {
            return;
        }
        if (hotRestartPersistenceConfig.isEnabled() && !persistenceConfig.isEnabled()) {
            persistenceConfig.setEnabled(true).setBaseDir(hotRestartPersistenceConfig.getBaseDir()).setBackupDir(hotRestartPersistenceConfig.getBackupDir()).setAutoRemoveStaleData(hotRestartPersistenceConfig.isAutoRemoveStaleData()).setEncryptionAtRestConfig(hotRestartPersistenceConfig.getEncryptionAtRestConfig()).setDataLoadTimeoutSeconds(hotRestartPersistenceConfig.getDataLoadTimeoutSeconds()).setParallelism(hotRestartPersistenceConfig.getParallelism()).setValidationTimeoutSeconds(hotRestartPersistenceConfig.getValidationTimeoutSeconds()).setClusterDataRecoveryPolicy(PersistenceClusterDataRecoveryPolicy.valueOf(hotRestartPersistenceConfig.getClusterDataRecoveryPolicy().name()));
            return;
        }
        boolean override = hotRestartPersistenceConfig.isEnabled() && persistenceConfig.isEnabled();
        hotRestartPersistenceConfig.setEnabled(persistenceConfig.isEnabled()).setBaseDir(persistenceConfig.getBaseDir()).setBackupDir(persistenceConfig.getBackupDir()).setAutoRemoveStaleData(persistenceConfig.isAutoRemoveStaleData()).setEncryptionAtRestConfig(persistenceConfig.getEncryptionAtRestConfig()).setDataLoadTimeoutSeconds(persistenceConfig.getDataLoadTimeoutSeconds()).setParallelism(persistenceConfig.getParallelism()).setValidationTimeoutSeconds(persistenceConfig.getValidationTimeoutSeconds()).setClusterDataRecoveryPolicy(HotRestartClusterDataRecoveryPolicy.valueOf(persistenceConfig.getClusterDataRecoveryPolicy().name()));
        if (override) {
            LOGGER.warning("Please note that HotRestartPersistence is deprecated and should not be used. Since both HotRestartPersistence and Persistence are enabled, and thus there is a conflict, the latter is used in persistence configuration.");
        }
    }

    private static boolean equals(HotRestartPersistenceConfig hotRestartPersistenceConfig, PersistenceConfig persistenceConfig) {
        if (hotRestartPersistenceConfig.isEnabled() != persistenceConfig.isEnabled()) {
            return false;
        }
        if (!Objects.equals(hotRestartPersistenceConfig.getBaseDir(), persistenceConfig.getBaseDir())) {
            return false;
        }
        if (!Objects.equals(hotRestartPersistenceConfig.getBackupDir(), persistenceConfig.getBackupDir())) {
            return false;
        }
        if (!Objects.equals(hotRestartPersistenceConfig.isAutoRemoveStaleData(), persistenceConfig.isAutoRemoveStaleData())) {
            return false;
        }
        if (!Objects.equals(hotRestartPersistenceConfig.getEncryptionAtRestConfig(), persistenceConfig.getEncryptionAtRestConfig())) {
            return false;
        }
        if (hotRestartPersistenceConfig.getClusterDataRecoveryPolicy().ordinal() != persistenceConfig.getClusterDataRecoveryPolicy().ordinal()) {
            return false;
        }
        return hotRestartPersistenceConfig.getDataLoadTimeoutSeconds() == persistenceConfig.getDataLoadTimeoutSeconds() && hotRestartPersistenceConfig.getParallelism() == persistenceConfig.getParallelism() && hotRestartPersistenceConfig.getValidationTimeoutSeconds() == persistenceConfig.getValidationTimeoutSeconds();
    }
}

