/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.apps.graph.IChartRendererService;
import org.adempiere.webui.apps.graph.model.IndicatorModel;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MGoal;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.jfree.chart.ChartPanel;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.AfterSizeEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;

public class WPerformanceIndicator
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = 4102528939759426552L;
    public static final String ON_AFTER_RENDER_CHART_EVENT = "onAfterRenderChart";
    public static final String TICK_COLOR = "tickColor";
    public static final String NEEDLE_COLOR = "needleColor";
    public static final String DIAL_BACKGROUND = "dialBackground";
    public static final String CHART_BACKGROUND = "chartBackground";
    private MGoal m_goal = null;
    private String m_text = null;
    private static DecimalFormat s_format = DisplayType.getNumberFormat((int)11);
    protected Menupopup popupMenu = new Menupopup();
    private Menuitem mRefresh = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"), ThemeManager.getThemeResource("images/Refresh16.png"));
    private Color chartBackground = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color dialBackground = Color.white;
    private Color needleColor = Color.darkGray;
    private Color tickColor = Color.darkGray;
    protected ChartPanel chartPanel;

    public WPerformanceIndicator(MGoal goal) {
        this(goal, null);
    }

    public WPerformanceIndicator(MGoal goal, Options options) {
        if (options != null && options.colorMap != null) {
            Color color = options.colorMap.get(CHART_BACKGROUND);
            if (color != null) {
                this.chartBackground = color;
            }
            if ((color = options.colorMap.get(DIAL_BACKGROUND)) != null) {
                this.dialBackground = color;
            }
            if ((color = options.colorMap.get(NEEDLE_COLOR)) != null) {
                this.needleColor = color;
            }
            if ((color = options.colorMap.get(TICK_COLOR)) != null) {
                this.dialBackground = color;
            }
        }
        this.setSclass("performance-indicator");
        this.m_goal = goal;
        this.init();
        this.mRefresh.addEventListener("onClick", (EventListener)this);
        this.popupMenu.appendChild((Component)this.mRefresh);
        this.addEventListener("onDoubleClick", this);
        this.addEventListener("onClick", this);
    }

    public MGoal getGoal() {
        return this.m_goal;
    }

    private void init() {
        StringBuilder text = new StringBuilder(this.m_goal.getName());
        if (this.m_goal.isTarget()) {
            text.append(": ").append(this.m_goal.getPercent()).append("%");
        } else {
            text.append(": ").append(s_format.format(this.m_goal.getMeasureActual()));
        }
        this.m_text = text.toString();
        text = new StringBuilder();
        if (this.m_goal.getDescription() != null) {
            text.append(this.m_goal.getDescription()).append(": ");
        }
        text.append(s_format.format(this.m_goal.getMeasureActual()));
        if (this.m_goal.isTarget()) {
            text.append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"of")).append(" ").append(s_format.format(this.m_goal.getMeasureTarget()));
        }
        this.setTooltiptext(text.toString());
        this.addEventListener("onAfterSize", this);
    }

    public void onEvent(Event event) throws Exception {
        if ("onAfterSize".equals(event.getName())) {
            this.onAfterSize((AfterSizeEvent)event);
        } else if (event.getTarget() == this.getFirstChild()) {
            event.stopPropagation();
            Events.sendEvent((String)"onClick", (Component)this, (Object)event.getData());
        }
    }

    private void onAfterSize(AfterSizeEvent event) {
        int width = event.getWidth();
        if (width == 0) {
            return;
        }
        int height = event.getHeight();
        if (width == 0 && height == 0) {
            return;
        }
        if (height == 0) {
            int n = height = width > 300 ? width * 40 / 100 : width * 85 / 100;
            if (height == 0) {
                return;
            }
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, height + "px");
        } else {
            int ratio = height * 100 / width;
            if (ratio > 85 || ratio < 50) {
                int n = height = width > 300 ? width * 40 / 100 : width * 85 / 100;
                if (height == 0) {
                    return;
                }
                ZKUpdateUtil.setHeight((HtmlBasedComponent)this, height + "px");
            }
        }
        this.getChildren().clear();
        this.renderChart(width, height);
        Events.sendEvent((Component)this, (Event)new Event(ON_AFTER_RENDER_CHART_EVENT, (Component)this));
    }

    public String getTitle() {
        return this.m_text;
    }

    private void renderChart(int chartWidth, int chartHeight) {
        IndicatorModel model = new IndicatorModel();
        model.goalModel = this.m_goal;
        model.chartBackground = this.chartBackground;
        model.dialBackground = this.dialBackground;
        model.needleColor = this.needleColor;
        model.tickColor = this.tickColor;
        List<IChartRendererService> list = Extensions.getChartRendererServices();
        for (IChartRendererService renderer : list) {
            if (renderer.renderPerformanceIndicator((Component)this, chartWidth, chartHeight, model)) break;
        }
        this.getFirstChild().addEventListener("onClick", (EventListener)this);
    }

    public static class Options {
        public Map<String, Color> colorMap;
    }
}

