/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.exceptions.DBException;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.WArchive;
import org.adempiere.webui.WRequest;
import org.adempiere.webui.WZoomAcross;
import org.adempiere.webui.acct.WAcctViewer;
import org.adempiere.webui.adwindow.ADSortTab;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowToolbar;
import org.adempiere.webui.adwindow.BreadCrumb;
import org.adempiere.webui.adwindow.BreadCrumbLink;
import org.adempiere.webui.adwindow.GridTabRowRenderer;
import org.adempiere.webui.adwindow.IADTabbox;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.adwindow.ProcessButtonPopup;
import org.adempiere.webui.adwindow.QuickGridView;
import org.adempiere.webui.adwindow.StatusBar;
import org.adempiere.webui.adwindow.validator.WindowValidatorEvent;
import org.adempiere.webui.adwindow.validator.WindowValidatorEventType;
import org.adempiere.webui.adwindow.validator.WindowValidatorManager;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialogTemplate;
import org.adempiere.webui.apps.HelpWindow;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.apps.form.WCreateFromFactory;
import org.adempiere.webui.apps.form.WCreateFromWindow;
import org.adempiere.webui.apps.form.WQuickForm;
import org.adempiere.webui.component.DesktopTabpanel;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.ProcessInfoDialog;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.editor.IProcessButton;
import org.adempiere.webui.editor.WButtonEditor;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.event.ActionEvent;
import org.adempiere.webui.event.ActionListener;
import org.adempiere.webui.event.ToolbarListener;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.panel.WAttachment;
import org.adempiere.webui.panel.WDocActionPanel;
import org.adempiere.webui.panel.action.CSVImportAction;
import org.adempiere.webui.panel.action.ExportAction;
import org.adempiere.webui.panel.action.FileImportAction;
import org.adempiere.webui.panel.action.ReportAction;
import org.adempiere.webui.part.AbstractUIPart;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.CustomizeGridViewDialog;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.FindWindow;
import org.adempiere.webui.window.LabelAction;
import org.adempiere.webui.window.WChat;
import org.adempiere.webui.window.WPostIt;
import org.adempiere.webui.window.WRecordAccessDialog;
import org.compiere.grid.ICreateFrom;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MImage;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRecentItem;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.SystemProperties;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Div;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Row;
import org.zkoss.zul.RowRenderer;
import org.zkoss.zul.Window;
import org.zkoss.zul.impl.LabelImageElement;

public abstract class AbstractADWindowContent
extends AbstractUIPart
implements ToolbarListener,
EventListener<Event>,
DataStatusListener,
ActionListener,
ITabOnSelectHandler {
    private static final String DETAIL_TABPANEL_SAVED_ATTR = "detail.adtabpanel.saved";
    private static final String ON_FOCUS_DEFER_EVENT = "onFocusDefer";
    private static final String ON_DEFER_SET_DETAILPANE_SELECTION_EVENT = "onDeferSetDetailpaneSelection";
    private static final String PROCESS_POST_CALLBACK_ATTRIBUTE = "processPostCallbackAttribute";
    private static final CLogger logger = CLogger.getCLogger(AbstractADWindowContent.class);
    private Properties ctx;
    private GridWindow gridWindow;
    protected StatusBar statusBar;
    protected IADTabbox adTabbox;
    private int curWindowNo;
    private boolean m_onlyCurrentRows = true;
    protected ADWindowToolbar toolbar;
    protected String title;
    private int m_onlyCurrentDays = 0;
    private boolean m_findCancelled;
    private boolean m_findCreateNew;
    private boolean m_queryInitiating;
    protected BreadCrumb breadCrumb;
    private int adWindowId;
    private MImage image;
    private String deleteConfirmationLogic;
    protected StatusBar statusBarQF;
    protected ArrayList<Integer> quickFormOpenTabs = new ArrayList();
    protected Component lastFocusEditor = null;
    private Menupopup m_popup = null;
    private Menuitem m_lock = null;
    private Menuitem m_access = null;
    private HashMap<GridTab, FindWindow> tabFindWindowHashMap = new HashMap();
    private int masterRecord = -1;
    private Div mask;
    protected ADWindow adwindow;
    protected boolean showingOnExitDialog;
    protected QuickGridView currQGV = null;

    public AbstractADWindowContent(Properties ctx, int windowNo, int adWindowId) {
        this.ctx = ctx;
        this.curWindowNo = windowNo;
        this.adWindowId = adWindowId;
        this.initComponents();
    }

    @Override
    public Component createPart(Object parent) {
        this.adTabbox = this.createADTab();
        this.adTabbox.setSelectionEventListener(this);
        this.adTabbox.setADWindowPanel(this);
        Component comp = super.createPart(parent);
        comp.addEventListener("onRedraw", (EventListener)this);
        comp.addEventListener(ON_DEFER_SET_DETAILPANE_SELECTION_EVENT, (EventListener)this);
        comp.addEventListener(ON_FOCUS_DEFER_EVENT, (EventListener)this);
        comp.setAttribute("TabOnSelectHandler", (Object)this);
        return comp;
    }

    public BreadCrumb getBreadCrumb() {
        return this.breadCrumb;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    private void initComponents() {
        this.toolbar = new ADWindowToolbar(this, this.getWindowNo());
        this.toolbar.setId("windowToolbar");
        this.toolbar.addListener(this);
        this.statusBar = new StatusBar();
        GridWindowVO gWindowVO = AEnv.getMWindowVO(this.curWindowNo, this.adWindowId, 0);
        if (gWindowVO == null) {
            throw new ApplicationException(Msg.getMsg((Properties)this.ctx, (String)"AccessTableNoView") + "(No Window Model Info)");
        }
        this.gridWindow = new GridWindow(gWindowVO, true);
        this.title = this.gridWindow.getName();
        this.image = this.gridWindow.getMImage();
    }

    protected abstract IADTabbox createADTab();

    protected abstract void switchEditStatus(boolean var1);

    public void focusToActivePanel() {
        IADTabpanel adTabPanel = this.adTabbox.getSelectedTabpanel();
        this.focusToTabpanel(adTabPanel);
    }

    private void focusToTabpanel(IADTabpanel adTabPanel) {
        if (adTabPanel != null && adTabPanel instanceof HtmlBasedComponent) {
            Events.echoEvent((String)ON_FOCUS_DEFER_EVENT, (Component)this.getComponent(), (Object)((HtmlBasedComponent)adTabPanel));
        }
    }

    public boolean initPanel(MQuery query) {
        Session currSess = Executions.getCurrent().getDesktop().getSession();
        int checkad_user_id = -1;
        if (currSess != null && currSess.getAttribute("Check_AD_User_ID") != null) {
            checkad_user_id = (Integer)currSess.getAttribute("Check_AD_User_ID");
        }
        if (checkad_user_id != Env.getAD_User_ID((Properties)this.ctx)) {
            String msg = "Timestamp=" + String.valueOf(new Date()) + ", Bug 2832968 SessionUser=" + checkad_user_id + ", ContextUser=" + Env.getAD_User_ID((Properties)this.ctx) + ".  Please report conditions to your system administrator or in sf tracker 2832968";
            ApplicationException ex = new ApplicationException(msg);
            logger.log(Level.SEVERE, msg, (Throwable)ex);
            throw ex;
        }
        Env.setAutoCommit((Properties)this.ctx, (int)this.curWindowNo, (boolean)Env.isAutoCommit((Properties)this.ctx));
        boolean autoNew = Env.isAutoNew((Properties)this.ctx);
        Env.setAutoNew((Properties)this.ctx, (int)this.curWindowNo, (boolean)autoNew);
        Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"WindowName", (String)this.gridWindow.getName());
        Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"_WinInfo_WindowName", (String)this.gridWindow.getName());
        Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"_WinInfo_AD_Window_ID", (int)this.gridWindow.getAD_Window_ID());
        Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"_WinInfo_AD_Window_UU", (String)this.gridWindow.getAD_Window_UU());
        Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"IsSOTrx", (boolean)this.gridWindow.isSOTrx());
        if (!autoNew && this.gridWindow.isTransaction()) {
            Env.setAutoNew((Properties)this.ctx, (int)this.curWindowNo, (boolean)true);
        }
        this.m_onlyCurrentRows = this.gridWindow.isTransaction();
        MQuery detailQuery = null;
        if (query != null && query.getZoomTableName() != null && query.getZoomColumnName() != null && !query.getZoomTableName().equalsIgnoreCase(this.gridWindow.getTab(0).getTableName())) {
            detailQuery = query;
            query = new MQuery();
            query.addRestriction("1=2");
            query.setRecordCount(0);
        }
        int tabSize = this.gridWindow.getTabCount();
        GridTab gridTab = null;
        int tab = 0;
        while (tab < tabSize) {
            gridTab = this.initTab(query, tab);
            if (tab == 0 && gridTab == null && this.m_findCancelled) {
                return false;
            }
            ++tab;
        }
        if (gridTab != null) {
            gridTab.getTableModel().setChanged(false);
        }
        this.adTabbox.setSelectedIndex(0);
        if (Env.getContext((Properties)this.ctx, (int)this.curWindowNo, (String)"IsSOTrx", (boolean)true) == null) {
            Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"IsSOTrx", (boolean)this.gridWindow.isSOTrx());
        }
        this.toolbar.enableTabNavigation(this.adTabbox.getTabCount() > 1);
        this.toolbar.enableFind(true);
        this.adTabbox.evaluate(null);
        this.toolbar.updateToolbarAccess();
        this.updateToolbar();
        if (query == null && this.toolbar.initDefaultQuery()) {
            this.doOnQueryChange();
        }
        if (detailQuery != null && this.zoomToDetailTab(detailQuery)) {
            return true;
        }
        SessionManager.getAppDesktop().updateHelpContext("T", this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
        return true;
    }

    private boolean zoomToDetailTab(MQuery query) {
        if (query != null && query.getZoomTableName() != null && query.getZoomColumnName() != null) {
            GridTab gTab = this.gridWindow.getTab(0);
            if (!query.getZoomTableName().equalsIgnoreCase(gTab.getTableName())) {
                int tabSize = this.gridWindow.getTabCount();
                int tab = 0;
                while (tab < tabSize) {
                    gTab = this.gridWindow.getTab(tab);
                    if (!gTab.isSortTab() && gTab.getTableName().equalsIgnoreCase(query.getZoomTableName()) && this.doZoomToDetail(gTab, query, tab)) {
                        return true;
                    }
                    ++tab;
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean doZoomToDetail(GridTab gTab, MQuery query, int tabIndex) {
        var8_5 = fields = gTab.getFields();
        var7_6 = fields.length;
        var6_7 = 0;
        while (var6_7 < var7_6) {
            block27: {
                field = var8_5[var6_7];
                if (!field.getColumnName().equalsIgnoreCase(query.getZoomColumnName())) break block27;
                this.gridWindow.initTab(tabIndex);
                sql = new StringBuilder("SELECT ").append(gTab.getLinkColumnName()).append(" FROM ").append(gTab.getTableName()).append(" WHERE ").append(query.getWhereClause());
                parentIds = DB.getSQLArrayObjectsEx(null, (String)sql.toString(), (Object[])new Object[0]);
                if (parentIds == null || parentIds.size() <= 0) break block27;
                queryMap = new TreeMap<Integer, MQuery>();
                for (List parentIdList : parentIds) {
                    parentId = parentIdList.get(0);
                    parentMap = new TreeMap<Integer, Object[]>();
                    index = tabIndex;
                    oldpid = parentId;
                    currentTab = gTab;
                    while (index > 0) {
                        if ((pTab = this.gridWindow.getTab(--index)).getTabLevel() >= currentTab.getTabLevel()) continue;
                        this.gridWindow.initTab(index);
                        if (index > 0) {
                            if (pTab.getLinkColumnName() == null || pTab.getLinkColumnName().trim().length() <= 0) continue;
                            pid = DB.getSQLValue(null, (String)("SELECT " + pTab.getLinkColumnName() + " FROM " + pTab.getTableName() + " WHERE " + currentTab.getLinkColumnName() + " = ?"), (Object[])new Object[]{oldpid});
                            if (pid > 0) {
                                parentMap.put(index, new Object[]{currentTab.getLinkColumnName(), oldpid});
                                oldpid = pid;
                                currentTab = pTab;
                                continue;
                            }
                            parentMap.clear();
                            break;
                        }
                        parentMap.put(index, new Object[]{currentTab.getLinkColumnName(), oldpid});
                    }
                    for (Map.Entry<K, V> entry : parentMap.entrySet()) {
                        pTab = this.gridWindow.getTab(((Integer)entry.getKey()).intValue());
                        value /* !! */  = (Object[])entry.getValue();
                        pquery = new MQuery(pTab.getAD_Table_ID());
                        queryMap.put((Integer)entry.getKey(), pquery);
                        pquery.addRestriction((String)value /* !! */ [0], "=", value /* !! */ [1]);
                    }
                }
                pTab = null;
                for (Map.Entry<K, V> entry : queryMap.entrySet()) {
                    pTab = this.gridWindow.getTab(((Integer)entry.getKey()).intValue());
                    tp = this.adTabbox.findADTabpanel(pTab);
                    tp.createUI();
                    if (tp.getTabLevel() == 0) {
                        pTab.setQuery((MQuery)entry.getValue());
                        tp.query();
                        if (pTab.getRowCount() <= 0) continue;
                        v0 = pTabUpdateWindowContext = pTab != null ? pTab.isUpdateWindowContext() : false;
                        if (pTab != null && !pTabUpdateWindowContext) {
                            pTab.setUpdateWindowContext(true);
                        }
                        pTab.setCurrentRow(0, false);
                        if (pTab == null || pTabUpdateWindowContext) continue;
                        pTab.setUpdateWindowContext(false);
                        continue;
                    }
                    tp.query();
                    tabQuery = (MQuery)entry.getValue();
                    rowFound = -1;
                    i = 0;
                    while (i < pTab.getRowCount()) {
                        block28: {
                            tabValue = pTab.getValue(i, tabQuery.getColumnName(0));
                            if (tabValue == null || tabQuery.getCode(0) == null) break block28;
                            if (!tabQuery.getColumnName(0).endsWith("_ID") || !((var24_34 = tabValue) instanceof Number)) ** GOTO lbl-1000
                            (Number)var24_34;
                            (Number)var24_34;
                            var25_35 = tabQuery.getCode(0);
                            if (var25_35 instanceof Number) {
                                (Number)var25_35;
                                (Number)var25_35;
                                if (n1.intValue() == n2.intValue()) {
                                    rowFound = i;
                                    break;
                                }
                            } else if (tabValue.equals(tabQuery.getCode(0))) {
                                rowFound = i;
                                break;
                            }
                        }
                        ++i;
                    }
                    if (rowFound == -1) {
                        pTab.setQuery((MQuery)entry.getValue());
                        tp.query();
                        rowFound = 0;
                    }
                    if (pTab.getRowCount() <= 0) continue;
                    v1 = pTabUpdateWindowContext = pTab != null ? pTab.isUpdateWindowContext() : false;
                    if (pTab != null && !pTabUpdateWindowContext) {
                        pTab.setUpdateWindowContext(true);
                    }
                    pTab.setCurrentRow(rowFound, false);
                    if (pTab == null || pTabUpdateWindowContext) continue;
                    pTab.setUpdateWindowContext(false);
                }
                gc = null;
                gc = this.adTabbox.findADTabpanel(gTab);
                gc.createUI();
                gc.query(false, 0, 0);
                zoomColumnIndex = -1;
                table = gTab.getTableModel();
                i = 0;
                while (i < table.getColumnCount()) {
                    if (table.getColumnName(i).equalsIgnoreCase(query.getZoomColumnName())) {
                        zoomColumnIndex = i;
                        break;
                    }
                    ++i;
                }
                count = table.getRowCount();
                tbl = MTable.get((Properties)this.ctx, (String)table.getTableName());
                i = 0;
                while (i < count) {
                    id = null;
                    if (zoomColumnIndex >= 0) {
                        zoomValue = table.getValueAt(i, zoomColumnIndex);
                        if (zoomValue != null && zoomValue instanceof Number) {
                            id = ((Number)zoomValue).intValue();
                        } else if (zoomValue != null && zoomValue instanceof String) {
                            id = zoomValue.toString();
                        }
                    } else {
                        id = tbl.isUUIDKeyTable() != false ? table.getUUID(i) : Integer.valueOf(table.getKeyID(i));
                    }
                    if (id != null && id.equals(query.getZoomValue())) {
                        v2 = pTabUpdateWindowContext = pTab != null ? pTab.isUpdateWindowContext() : false;
                        if (pTab != null && !pTabUpdateWindowContext) {
                            pTab.setUpdateWindowContext(true);
                        }
                        this.setActiveTab(this.gridWindow.getTabIndex(gTab), null);
                        if (pTab != null && !pTabUpdateWindowContext) {
                            pTab.setUpdateWindowContext(false);
                        }
                        gTab.navigate(i);
                        return true;
                    }
                    ++i;
                }
            }
            ++var6_7;
        }
        return false;
    }

    private void initQueryOnNew(MQuery result) {
        GridTab curTab = this.adTabbox.getSelectedGridTab();
        boolean onNew = false;
        if (curTab.isHighVolume() && this.m_findCreateNew) {
            onNew = true;
        } else if (result == null && curTab.getRowCount() == 0 && Env.isAutoNew((Properties)this.ctx, (int)this.curWindowNo)) {
            onNew = true;
        } else if (!curTab.isReadOnly() && curTab.isQueryNewRecord()) {
            onNew = true;
        }
        if (onNew) {
            Executions.schedule((Desktop)AEnv.getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractADWindowContent.this.onNew();
                    ADTabpanel adtabpanel = (ADTabpanel)AbstractADWindowContent.this.getADTab().getSelectedTabpanel();
                    adtabpanel.focusToFirstEditor(false);
                }
            }, (Event)new Event("onInsert"));
        }
    }

    protected GridTab initTab(final MQuery query, int tabIndex) {
        this.gridWindow.initTab(tabIndex);
        final GridTab gTab = this.gridWindow.getTab(tabIndex);
        Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (int)tabIndex, (String)"_TabInfo_TabLevel", (String)Integer.toString(gTab.getTabLevel()));
        final AtomicBoolean zoomQuery = new AtomicBoolean(false);
        if (tabIndex == 0) {
            gTab.setUpdateWindowContext(true);
            this.m_queryInitiating = true;
            this.getComponent().setVisible(false);
            this.initialQuery(query, gTab, new Callback<MQuery>(){

                public void onCallback(MQuery result) {
                    AbstractADWindowContent.this.m_queryInitiating = false;
                    if (AbstractADWindowContent.this.m_findCancelled) {
                        SessionManager.getAppDesktop().closeWindow(AbstractADWindowContent.this.curWindowNo);
                        return;
                    }
                    if (!AbstractADWindowContent.this.getComponent().isVisible()) {
                        AbstractADWindowContent.this.getComponent().setVisible(true);
                    }
                    if (result != null) {
                        AbstractADWindowContent.this.m_onlyCurrentRows = false;
                        gTab.setQuery(result);
                    }
                    if (AbstractADWindowContent.this.adTabbox.getSelectedTabpanel() != null) {
                        AbstractADWindowContent.this.initFirstTabpanel();
                        AbstractADWindowContent.this.initQueryOnNew(result);
                    }
                    if (query != null && query == result) {
                        zoomQuery.set(true);
                    }
                }
            });
        } else {
            gTab.setUpdateWindowContext(false);
        }
        String type = gTab.getTabType();
        if (!Util.isEmpty((String)type)) {
            IADTabpanel adTabPanal = Extensions.getADTabPanel(type);
            if (adTabPanal != null) {
                this.initTabPanel(query, tabIndex, gTab, adTabPanal);
            } else {
                logger.log(Level.SEVERE, "No implementation for tab type " + type + " Found", (Throwable)new Exception("No implementation for tab type " + type + " Found"));
            }
        } else if (gTab.isSortTab()) {
            ADSortTab sortTab = new ADSortTab();
            sortTab.init(this, gTab);
            this.adTabbox.addTab(gTab, sortTab);
            sortTab.registerAPanel(this);
            if (tabIndex == 0) {
                sortTab.createUI();
                if (!this.m_queryInitiating) {
                    this.initFirstTabpanel();
                }
            }
            gTab.addDataStatusListener((DataStatusListener)this);
        } else {
            ADTabpanel fTabPanel = new ADTabpanel();
            this.initTabPanel(query, tabIndex, gTab, fTabPanel);
            if (query != null && zoomQuery.get() && gTab.getRowCount() == 1 && !gTab.isNew() && this.adTabbox.getSelectedTabpanel().isGridView() && this.adTabbox.getSelectedTabpanel().getGridTab() == gTab) {
                this.adTabbox.getSelectedTabpanel().switchRowPresentation();
            }
        }
        return gTab;
    }

    private void initTabPanel(MQuery query, int tabIndex, GridTab gTab, IADTabpanel adTabPanal) {
        block5: {
            adTabPanal.addEventListener("onDynamicDisplay", this);
            gTab.addDataStatusListener((DataStatusListener)this);
            adTabPanal.init(this, gTab);
            this.adTabbox.addTab(gTab, adTabPanal);
            if (tabIndex == 0) {
                adTabPanal.createUI();
                if (!this.m_queryInitiating) {
                    try {
                        this.initFirstTabpanel();
                    }
                    catch (Exception e) {
                        if (!DBException.isTimeout((Exception)e)) break block5;
                        Dialog.error(this.curWindowNo, "GridTabLoadTimeoutError");
                    }
                }
            }
        }
        if (!this.m_queryInitiating && tabIndex == 0) {
            this.initQueryOnNew(query);
        }
    }

    private void initFirstTabpanel() {
        this.adTabbox.getSelectedTabpanel().query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, this.adTabbox.getSelectedGridTab().getMaxQueryRecords());
        this.adTabbox.getSelectedTabpanel().activate(true);
        Events.echoEvent((Event)new Event("onPostInit", (Component)this.adTabbox.getSelectedTabpanel()));
    }

    private void initialQuery(MQuery query, GridTab mTab, final Callback<MQuery> callback) {
        if (query != null && query.isActive()) {
            callback.onCallback((Object)query);
            return;
        }
        StringBuffer where = new StringBuffer(Env.parseContext((Properties)this.ctx, (int)this.curWindowNo, (String)mTab.getWhereExtended(), (boolean)false));
        boolean require = mTab.isHighVolume();
        if (!require && !this.m_onlyCurrentRows) {
            int no;
            String wh2;
            if (query != null && (wh2 = query.getWhereClause()).length() > 0) {
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                where.append(wh2);
            }
            boolean bl = require = (no = this.getRecordCount(mTab, where)) == -1 ? true : mTab.isQueryRequire(no);
        }
        if (require) {
            this.m_findCancelled = false;
            this.m_findCreateNew = false;
            GridField[] findFields = mTab.getFields();
            final FindWindow findWindow = new FindWindow(this.curWindowNo, mTab.getTabNo(), mTab.getName(), mTab.getAD_Table_ID(), mTab.getTableName(), where.toString(), findFields, 10, mTab.getAD_Tab_ID(), this);
            this.tabFindWindowHashMap.put(mTab, findWindow);
            this.setupEmbeddedFindwindow(findWindow);
            if (findWindow.initialize()) {
                findWindow.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        if (!findWindow.isCancel()) {
                            AbstractADWindowContent.this.m_findCreateNew = findWindow.isCreateNew();
                            MQuery result = findWindow.getQuery();
                            callback.onCallback((Object)result);
                            EventListener listener = (EventListener)findWindow.getEventListeners("onWindowClose").iterator().next();
                            findWindow.removeEventListener("onWindowClose", listener);
                        } else {
                            AbstractADWindowContent.this.m_findCancelled = true;
                            callback.onCallback(null);
                        }
                    }
                });
                this.getComponent().addEventListener("onInitialQuery", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        if (findWindow.getParent() != AbstractADWindowContent.this.getComponent().getParent()) {
                            AbstractADWindowContent.this.getComponent().getParent().appendChild((Component)findWindow);
                        }
                        LayoutUtils.openEmbeddedWindow(AbstractADWindowContent.this.getComponent().getParent(), findWindow, "overlap");
                    }
                });
                Events.echoEvent((String)"onInitialQuery", (Component)this.getComponent(), null);
            } else {
                callback.onCallback((Object)query);
            }
        } else {
            callback.onCallback((Object)query);
        }
    }

    private int getRecordCount(GridTab mTab, StringBuffer where) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(mTab.getTableName());
        if (where.length() > 0) {
            sql.append(" WHERE ").append(where);
        }
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), mTab.getTableName(), false, false);
        int no = -1;
        int timeout = MSysConfig.getIntValue((String)"GRIDTABLE_INITIAL_COUNT_TIMEOUT_IN_SECONDS", (int)1, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)finalSQL, null);){
                ResultSet rs;
                if (timeout > 0) {
                    stmt.setQueryTimeout(timeout);
                }
                if ((rs = stmt.executeQuery()).next()) {
                    no = rs.getInt(1);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, e.getMessage(), (Throwable)e);
            no = -1;
        }
        return no;
    }

    private void setupEmbeddedFindwindow(FindWindow findWindow) {
        findWindow.setTitle(null);
        findWindow.setBorder("none");
        findWindow.setStyle("position: absolute;background-color: #fff;");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)findWindow, "100%");
        if (ClientInfo.maxHeight(699)) {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)findWindow, "100%");
        } else {
            ZKUpdateUtil.setHeight((HtmlBasedComponent)findWindow, "60%");
        }
        findWindow.setZindex(1000);
        findWindow.setSizable(false);
        findWindow.setContentStyle("background-color: #fff; width: 99%; margin: auto;");
    }

    public String getTitle() {
        return this.title;
    }

    public MImage getImage() {
        return this.image;
    }

    @Override
    public void onDetailRecord() {
        this.adTabbox.onDetailRecord();
    }

    @Override
    public void onParentRecord() {
        List<BreadCrumbLink> parents = this.breadCrumb.getParentLinks();
        if (!parents.isEmpty()) {
            Events.sendEvent((Component)((Component)parents.get(parents.size() - 1)), (Event)new Event("onClick", (Component)parents.get(parents.size() - 1)));
        }
    }

    @Override
    public void onFirst() {
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().navigate(-1);
                    AbstractADWindowContent.this.focusToActivePanel();
                }
            }
        };
        this.saveAndNavigate(callback);
    }

    @Override
    public void onLast() {
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().navigate(AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getRowCount() - 1);
                    AbstractADWindowContent.this.focusToActivePanel();
                }
            }
        };
        this.onSave(false, true, callback);
    }

    @Override
    public void onNext() {
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().navigateRelative(1);
                    AbstractADWindowContent.this.focusToActivePanel();
                }
            }
        };
        this.saveAndNavigate(callback);
    }

    @Override
    public void onPrevious() {
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().navigateRelative(-1);
                    AbstractADWindowContent.this.focusToActivePanel();
                }
            }
        };
        this.saveAndNavigate(callback);
    }

    public void onTreeNavigate(final GridTab gt, final int rowIndex) {
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    gt.navigate(rowIndex);
                }
            }
        };
        this.saveAndNavigate(callback);
    }

    @Override
    public void onLock() {
        if (!this.toolbar.isPersonalLock) {
            return;
        }
        if (this.adTabbox.getSelectedGridTab().getRecord_ID() == -1) {
            return;
        }
        if (this.m_popup == null) {
            this.m_popup = new Menupopup();
            this.m_lock = new Menuitem(Msg.translate((Properties)Env.getCtx(), (String)"Lock"));
            this.m_popup.appendChild((Component)this.m_lock);
            this.m_lock.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().lock(Env.getCtx(), AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getRecord_ID(), !AbstractADWindowContent.this.toolbar.getButton("Lock").isPressed());
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().loadLocks();
                    AbstractADWindowContent.this.toolbar.lock(AbstractADWindowContent.this.adTabbox.getSelectedGridTab().isLocked());
                }
            });
            this.m_access = new Menuitem(Msg.translate((Properties)Env.getCtx(), (String)"RecordAccessDialog"));
            this.m_popup.appendChild((Component)this.m_access);
            this.m_access.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    WRecordAccessDialog recordAccessDialog = new WRecordAccessDialog(null, AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getAD_Table_ID(), AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getRecord_ID());
                    recordAccessDialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                        public void onEvent(Event event) throws Exception {
                            (this).AbstractADWindowContent.this.toolbar.lock((this).AbstractADWindowContent.this.adTabbox.getSelectedGridTab().isLocked());
                            AbstractADWindowContent.this.focusToLastFocusEditor();
                        }
                    });
                    AEnv.showWindow(recordAccessDialog);
                }
            });
            LayoutUtils.autoDetachOnClose((Popup)this.m_popup);
        }
        if (this.m_popup.getPage() == null) {
            LabelImageElement btn = this.toolbar.getToolbarItem("Lock");
            Popup popup = LayoutUtils.findPopup(btn.getParent());
            if (popup != null) {
                popup.appendChild((Component)this.m_popup);
            } else {
                this.m_popup.setPage(this.toolbar.getToolbarItem("Lock").getPage());
            }
        }
        this.m_popup.open((Component)this.toolbar.getToolbarItem("Lock"), "after_start");
    }

    @Override
    public void onAttachment() {
        int record_ID = this.adTabbox.getSelectedGridTab().getRecord_ID();
        String recordUU = this.adTabbox.getSelectedGridTab().getRecord_UU();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Record_ID=" + record_ID + ", Record_UU=" + recordUU);
        }
        if (record_ID == -1 && Util.isEmpty((String)recordUU)) {
            return;
        }
        EventListener<Event> listener = new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                AbstractADWindowContent.this.toolbar.setPressed("Attachment", AbstractADWindowContent.this.adTabbox.getSelectedGridTab().hasAttachment());
                AbstractADWindowContent.this.focusToLastFocusEditor();
            }
        };
        WAttachment win = new WAttachment(this.curWindowNo, this.adTabbox.getSelectedGridTab().getAD_AttachmentID(), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), record_ID, recordUU, null, listener);
        win.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                AbstractADWindowContent.this.hideBusyMask();
            }
        });
        this.getComponent().getParent().appendChild((Component)win);
        this.showBusyMask(win);
        LayoutUtils.openOverlappedWindow(this.getComponent(), win, "middle_center");
        win.focus();
    }

    @Override
    public void onChat() {
        int recordId = this.adTabbox.getSelectedGridTab().getRecord_ID();
        String recordUU = this.adTabbox.getSelectedGridTab().getRecord_UU();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Record_ID=" + recordId + ", Record_UU=" + recordUU);
        }
        if (recordId == -1 && Util.isEmpty((String)recordUU)) {
            return;
        }
        String infoName = null;
        String infoDisplay = null;
        int i = 0;
        while (i < this.adTabbox.getSelectedGridTab().getFieldCount()) {
            GridField field = this.adTabbox.getSelectedGridTab().getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
            ++i;
        }
        if (infoDisplay == null) {
            infoDisplay = "";
        }
        String description = infoName + ": " + infoDisplay;
        WChat chat = new WChat(this.curWindowNo, this.adTabbox.getSelectedGridTab().getCM_ChatID(), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), recordId, recordUU, description, null);
        chat.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                AbstractADWindowContent.this.hideBusyMask();
                AbstractADWindowContent.this.toolbar.setPressed("Chat", AbstractADWindowContent.this.adTabbox.getSelectedGridTab().hasChat());
                AbstractADWindowContent.this.focusToLastFocusEditor();
            }
        });
        this.getComponent().getParent().appendChild((Component)chat);
        this.showBusyMask(chat);
        LayoutUtils.openOverlappedWindow(this.getComponent(), chat, "middle_center");
        chat.showWindow();
    }

    public void onPostIt() {
        int recordId = this.adTabbox.getSelectedGridTab().getRecord_ID();
        String recordUU = this.adTabbox.getSelectedGridTab().getRecord_UU();
        if (recordId == -1 && Util.isEmpty((String)recordUU)) {
            return;
        }
        String infoName = null;
        String infoDisplay = null;
        int i = 0;
        while (i < this.adTabbox.getSelectedGridTab().getFieldCount()) {
            GridField field = this.adTabbox.getSelectedGridTab().getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
            ++i;
        }
        String header = infoName + ": " + infoDisplay;
        WPostIt postit = new WPostIt(header, this.adTabbox.getSelectedGridTab().getAD_PostIt_ID(), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), recordId, recordUU, null);
        postit.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                AbstractADWindowContent.this.hideBusyMask();
                AbstractADWindowContent.this.toolbar.setPressed("PostIt", AbstractADWindowContent.this.adTabbox.getSelectedGridTab().hasPostIt());
                AbstractADWindowContent.this.focusToLastFocusEditor();
            }
        });
        this.getComponent().getParent().appendChild((Component)postit);
        this.showBusyMask(postit);
        LayoutUtils.openOverlappedWindow(this.getComponent(), postit, "middle_center");
        postit.showWindow();
    }

    public void onLabel() {
        this.toolbar.setPressed("Label", false);
        LabelAction labelAction = new LabelAction(this);
        labelAction.show();
    }

    @Override
    public void onToggle() {
        this.adTabbox.getSelectedTabpanel().switchRowPresentation();
        this.toolbar.enableCustomize(this.adTabbox.getSelectedTabpanel().isEnableCustomizeButton());
        this.focusToActivePanel();
    }

    public synchronized void onExit(Callback<Boolean> callback) {
        if (this.isPendingChanges()) {
            this.showingOnExitDialog = true;
            Dialog.ask(this.curWindowNo, "CloseUnSave?", (Callback<Boolean>)((Callback)b -> {
                this.showingOnExitDialog = false;
                callback.onCallback(b);
                if (!b.booleanValue()) {
                    this.focusToLastFocusEditor();
                }
            }));
        } else {
            callback.onCallback((Object)Boolean.TRUE);
        }
    }

    public boolean focusToLastFocusEditor() {
        return this.focusToLastFocusEditor(false);
    }

    public boolean focusToLastFocusEditor(boolean defer) {
        if (this.lastFocusEditor != null && this.lastFocusEditor instanceof HtmlBasedComponent && this.lastFocusEditor.getPage() != null && LayoutUtils.isReallyVisible(this.lastFocusEditor)) {
            if (defer) {
                HtmlBasedComponent editor = (HtmlBasedComponent)this.lastFocusEditor;
                Executions.schedule((Desktop)this.getComponent().getDesktop(), e -> editor.focus(), (Event)new Event("onScheduleFocusToLastFocusEditor"));
            } else {
                ((HtmlBasedComponent)this.lastFocusEditor).focus();
            }
            return true;
        }
        return false;
    }

    public void onQuickForm() {
        this.onQuickForm(false);
    }

    public void onQuickForm(boolean stayInParent) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Invoke Quick Form");
        }
        if (!this.registerQuickFormTab(this.getADTab().getSelectedGridTab().getAD_Tab_ID())) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("TabID=" + this.getActiveGridTab().getAD_Tab_ID() + "  is already open.");
            }
            return;
        }
        int table_ID = this.adTabbox.getSelectedGridTab().getAD_Table_ID();
        if (table_ID == -1) {
            return;
        }
        this.statusBarQF = new StatusBar();
        int tabLevel = this.getToolbar().getQuickFormTabHrchyLevel();
        if (tabLevel > 0 && this.getCurrQGV() != null) {
            SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this.getCurrQGV());
        }
        WQuickForm form = new WQuickForm(this, this.m_onlyCurrentRows, this.m_onlyCurrentDays);
        form.setTitle(this.getADTab().getSelectedGridTab().getName());
        form.setVisible(true);
        form.setSizable(true);
        form.setMaximizable(true);
        form.setMaximized(true);
        form.setPosition("center");
        form.setStayInParent(stayInParent);
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)form, 550);
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)form, 900);
        ZkCssHelper.appendStyle((HtmlBasedComponent)form, "z-index: 900;");
        AEnv.showWindow(form);
    }

    public void onEvent(Event event) {
        if ("onSelectionChanged".equals(event.getName())) {
            Object eventData = event.getData();
            if (eventData != null && eventData instanceof Object[] && ((Object[])eventData).length == 2) {
                Object[] indexes = (Object[])eventData;
                final int newTabIndex = (Integer)indexes[1];
                final int originalTabIndex = this.adTabbox.getSelectedIndex();
                final int originalTabRow = this.adTabbox.getSelectedGridTab().getCurrentRow();
                this.setActiveTab(newTabIndex, new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            if (newTabIndex < originalTabIndex) {
                                if (AbstractADWindowContent.this.adTabbox.isDetailPaneLoaded()) {
                                    AbstractADWindowContent.this.adTabbox.setDetailPaneSelectedTab(originalTabIndex, originalTabRow);
                                } else {
                                    Events.echoEvent((Event)new Event(AbstractADWindowContent.ON_DEFER_SET_DETAILPANE_SELECTION_EVENT, AbstractADWindowContent.this.getComponent(), (Object)new Integer[]{originalTabIndex, originalTabRow}));
                                }
                            }
                        } else {
                            AbstractADWindowContent.this.adTabbox.setSelectedIndex(originalTabIndex);
                        }
                    }
                });
                SessionManager.getAppDesktop().updateHelpContext("T", this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
            }
        } else if (event.getTarget() instanceof ProcessModalDialog) {
            if (!"onWindowClose".equals(event.getName())) {
                return;
            }
            this.hideBusyMask();
            ProcessModalDialog dialog = (ProcessModalDialog)event.getTarget();
            ProcessInfo pi = dialog.getProcessInfo();
            this.onModalClose(pi);
            String s = null;
            boolean b = false;
            ProcessInfoLog[] logs = null;
            if (this.getActiveGridTab().isQuickForm) {
                s = this.statusBarQF.getStatusLine();
                b = this.statusBarQF.getStatusError();
                logs = this.statusBarQF.getPLogs();
            } else {
                s = this.statusBar.getStatusLine();
                b = this.statusBar.getStatusError();
                logs = this.statusBar.getPLogs();
            }
            MPInstance instance = new MPInstance(this.ctx, pi.getAD_PInstance_ID(), "false");
            if (!instance.isRunAsJob() && !dialog.isCancel()) {
                this.onRefresh(true, false);
            }
            if (this.getActiveGridTab().isQuickForm) {
                this.statusBarQF.setStatusLine(s, b, logs);
            } else {
                this.statusBar.setStatusLine(s, b, logs);
            }
            if (dialog.getAttribute(PROCESS_POST_CALLBACK_ATTRIBUTE) != null && dialog.getAttribute(PROCESS_POST_CALLBACK_ATTRIBUTE) instanceof Callback) {
                Callback callback = (Callback)dialog.getAttribute(PROCESS_POST_CALLBACK_ATTRIBUTE);
                callback.onCallback((Object)(dialog.getProcessInfo() != null && !dialog.getProcessInfo().isError() ? 1 : 0));
            }
        } else if ("onDynamicDisplay".equals(event.getName())) {
            IADTabpanel adtab = (IADTabpanel)event.getTarget();
            if (adtab == this.adTabbox.getSelectedTabpanel()) {
                this.toolbar.enableProcessButton(adtab.isEnableProcessButton());
                this.toolbar.dynamicDisplay();
            }
        } else if (event.getTarget() == this.getComponent() && event.getName().equals("onRedraw")) {
            ExecutionCtrl ctrl = (ExecutionCtrl)Executions.getCurrent();
            Event evt = ctrl.getNextEvent();
            if (evt != null) {
                Events.sendEvent((Event)evt);
                Events.postEvent((Event)new Event("onRedraw", this.getComponent()));
                return;
            }
            LayoutUtils.redraw((AbstractComponent)this.getComponent());
        } else if (event.getName().equals(ON_DEFER_SET_DETAILPANE_SELECTION_EVENT)) {
            Integer[] data = (Integer[])event.getData();
            this.adTabbox.setDetailPaneSelectedTab(data[0], data[1]);
        } else if (event.getName().equals(ON_FOCUS_DEFER_EVENT)) {
            HtmlBasedComponent comp = (HtmlBasedComponent)event.getData();
            if (comp instanceof ADTabpanel) {
                ((ADTabpanel)comp).focusToFirstEditor(false);
            } else {
                comp.focus();
            }
        }
    }

    private void setActiveTab(final int newTabIndex, final Callback<Boolean> callback) {
        final int oldTabIndex = this.adTabbox.getSelectedIndex();
        if (oldTabIndex == newTabIndex) {
            if (callback != null) {
                callback.onCallback((Object)true);
            }
        } else {
            Callback<Boolean> command = new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        AbstractADWindowContent.this.setActiveTab0(oldTabIndex, newTabIndex, (Callback<Boolean>)callback);
                    } else if (callback != null) {
                        callback.onCallback((Object)false);
                    }
                }
            };
            Object value = Executions.getCurrent().getAttribute("ADTabbox.onEditDetail");
            if (value != null && value == this.adTabbox.getSelectedDetailADTabpanel() && (this.adTabbox.getDirtyADTabpanel() == this.adTabbox.getSelectedDetailADTabpanel() || this.adTabbox.getDirtyADTabpanel() == null && this.adTabbox.getSelectedDetailADTabpanel().getGridTab().isNew())) {
                command.onCallback((Object)true);
            } else {
                this.saveAndNavigate(command);
            }
        }
    }

    public void saveAndNavigate(Callback<Boolean> callback) {
        if (this.adTabbox != null) {
            boolean newrecod = this.adTabbox.getSelectedGridTab().isNew();
            if (this.adTabbox.isSortTab()) {
                this.onSave(false, true, callback);
            } else if (this.adTabbox.needSave(true, false)) {
                if (this.adTabbox.needSave(true, true)) {
                    this.onSave(false, true, callback);
                } else {
                    this.adTabbox.dataIgnore();
                    if (newrecod) {
                        this.onRefresh(true, false);
                    }
                    callback.onCallback((Object)true);
                }
            } else {
                this.adTabbox.dataIgnore();
                if (newrecod) {
                    this.onRefresh(true, false);
                }
                callback.onCallback((Object)true);
            }
        } else {
            callback.onCallback((Object)true);
        }
    }

    private void setActiveTab0(int oldTabIndex, int newTabIndex, Callback<Boolean> callback) {
        boolean back = false;
        IADTabpanel oldTabpanel = this.adTabbox.getSelectedTabpanel();
        if (!this.adTabbox.updateSelectedIndex(oldTabIndex, newTabIndex)) {
            Dialog.warn(this.curWindowNo, "TabSwitchJumpGo", this.title);
            if (callback != null) {
                callback.onCallback((Object)false);
            }
            return;
        }
        IADTabpanel newTabpanel = this.adTabbox.getSelectedTabpanel();
        if (newTabpanel.getGridTab() != null) {
            newTabpanel.getGridTab().setUpdateWindowContext(true);
        }
        if (oldTabIndex > newTabIndex && oldTabpanel.getGridTab() != null) {
            oldTabpanel.getGridTab().setUpdateWindowContext(false);
        }
        boolean activated = newTabpanel.isActivated();
        if (oldTabpanel != null) {
            oldTabpanel.activate(false);
        }
        if (!activated) {
            newTabpanel.activate(true);
        }
        boolean bl = back = newTabIndex < oldTabIndex;
        if (back && newTabpanel.getTabLevel() > 0) {
            if (newTabpanel.getTabLevel() >= oldTabpanel.getTabLevel()) {
                back = false;
            } else if (newTabIndex - oldTabIndex > 1) {
                int i = oldTabIndex - 1;
                while (i > newTabIndex) {
                    IADTabpanel next = this.adTabbox.getADTabpanel(i);
                    if (next != null && next.getTabLevel() <= newTabpanel.getTabLevel()) {
                        back = false;
                        break;
                    }
                    --i;
                }
            }
        }
        if (!back) {
            Object value = Executions.getCurrent().removeAttribute("ADTabbox.onEditDetail");
            if (value != newTabpanel) {
                newTabpanel.query();
                if (newTabpanel instanceof ADTabpanel) {
                    adtabpanel = (ADTabpanel)newTabpanel;
                    Events.echoEvent((String)"onPostInit", (Component)adtabpanel, null);
                }
            } else if (newTabpanel instanceof ADTabpanel) {
                adtabpanel = (ADTabpanel)newTabpanel;
                Events.echoEvent((String)"onPostInit", (Component)adtabpanel, null);
            }
        } else {
            newTabpanel.refresh();
        }
        if (this.adTabbox.getSelectedTabpanel() instanceof ADSortTab) {
            ((ADSortTab)this.adTabbox.getSelectedTabpanel()).registerAPanel(this);
        } else if (this.adTabbox.getSelectedGridTab().getRowCount() == 0 && Env.isAutoNew((Properties)this.ctx, (int)this.getWindowNo())) {
            this.onNew();
        }
        this.updateToolbar();
        this.breadCrumb.setNavigationToolbarVisibility(!this.adTabbox.getSelectedGridTab().isSortTab());
        if (callback != null) {
            callback.onCallback((Object)true);
        }
    }

    private void updateToolbar() {
        this.toolbar.enableTabNavigation(this.breadCrumb.hasParentLink(), this.adTabbox.getSelectedDetailADTabpanel() != null);
        this.toolbar.setPressed("Attachment", this.adTabbox.getSelectedGridTab().hasAttachment());
        this.toolbar.setPressed("PostIt", this.adTabbox.getSelectedGridTab().hasPostIt());
        this.toolbar.setPressed("Chat", this.adTabbox.getSelectedGridTab().hasChat());
        if (this.toolbar.isPersonalLock) {
            this.toolbar.lock(this.adTabbox.getSelectedGridTab().isLocked());
        }
        this.toolbar.enablePrint(this.adTabbox.getSelectedGridTab().isPrinted() && !this.adTabbox.getSelectedGridTab().isNew());
        this.toolbar.enableQuickForm(this.adTabbox.getSelectedTabpanel().isEnableQuickFormButton() && !this.adTabbox.getSelectedGridTab().isReadOnly());
        boolean isNewRow = this.adTabbox.getSelectedGridTab().getRowCount() == 0 || this.adTabbox.getSelectedGridTab().isNew();
        IADTabpanel adtab = this.adTabbox.getSelectedTabpanel();
        this.toolbar.enableProcessButton(adtab != null && adtab.isEnableProcessButton());
        this.toolbar.enableCustomize(adtab.isEnableCustomizeButton());
        this.toolbar.setPressed("Find", this.adTabbox.getSelectedGridTab().isQueryActive() || !isNewRow && (this.m_onlyCurrentRows || this.m_onlyCurrentDays > 0));
        this.toolbar.refreshUserQuery(this.adTabbox.getSelectedGridTab().getAD_Tab_ID(), this.getCurrentFindWindow() != null ? this.getCurrentFindWindow().getAD_UserQuery_ID() : 0);
        adtab.updateToolbar(this.toolbar);
    }

    public void dataStatusChanged(DataStatusEvent e) {
        boolean canHaveAttachment;
        boolean deleteRecord;
        IADTabpanel tabPanel;
        String adInfo;
        if (Executions.getCurrent() == null) {
            if (e.isLoading() && e.getSource() != null && e.getSource().equals(this.adTabbox.getSelectedGridTab().getTableModel())) {
                Executions.schedule((Desktop)this.getComponent().getDesktop(), evt -> this.dataStatusChanged(e), (Event)new Event("onAsynchronousDataStatusChanged"));
            }
            return;
        }
        boolean detailTab = false;
        if (e.getSource() instanceof GridTable) {
            GridTable gridTable = (GridTable)e.getSource();
            if (this.adTabbox.getSelectedGridTab() != null && this.adTabbox.getSelectedGridTab().getTableModel() != gridTable) {
                detailTab = true;
            }
        } else if (e.getSource() instanceof GridTab) {
            GridTab gridTab = (GridTab)e.getSource();
            if (this.adTabbox.getSelectedGridTab() != gridTab) {
                detailTab = true;
            }
        }
        if ((adInfo = e.getAD_Message()) == null || "NavigateOrUpdate".equals(adInfo) || "Refreshed".equals(adInfo) || "Inserted".equals(adInfo) || "Ignored".equals(adInfo) || "UpdateCopied".equals(adInfo) || "Saved".equals(adInfo)) {
            String prefix = null;
            if (this.adTabbox.needSave(true, false) || this.adTabbox.getSelectedGridTab().isNew() || this.adTabbox.getSelectedDetailADTabpanel() != null && this.adTabbox.getSelectedDetailADTabpanel().getGridTab().isNew()) {
                prefix = "*";
            }
            String titleLogic = null;
            int windowID = this.getADTab().getSelectedGridTab().getAD_Window_ID();
            if (windowID > 0) {
                titleLogic = MWindow.get((Properties)Env.getCtx(), (int)windowID).getTitleLogic();
            }
            String header = null;
            if (!Util.isEmpty(titleLogic)) {
                StringBuilder sb = new StringBuilder();
                if (prefix != null) {
                    sb.append(prefix);
                }
                sb.append(Env.getContext((Properties)this.ctx, (int)this.curWindowNo, (String)"_WinInfo_WindowName", (boolean)false)).append(": ");
                if (titleLogic.contains("<")) {
                    if (this.getADTab() != null && this.getADTab().getADTabpanel(0) != null && this.getADTab().getADTabpanel(0).getGridTab() != null && this.getADTab().getADTabpanel(0).getGridTab().getTableModel() != null) {
                        GridTab tab = this.getADTab().getADTabpanel(0).getGridTab();
                        int row = tab.getCurrentRow();
                        int cnt = tab.getRowCount();
                        boolean inserting = tab.getTableModel().isInserting();
                        if (row >= 0 && cnt > 0 && !inserting) {
                            PO po = tab.getTableModel().getPO(row);
                            titleLogic = Env.parseVariable((String)titleLogic, (PO)po, null, (boolean)false);
                        } else {
                            titleLogic = Env.parseContext((Properties)Env.getCtx(), (int)this.curWindowNo, (String)titleLogic, (boolean)false, (boolean)true);
                        }
                    }
                } else {
                    titleLogic = Env.parseContext((Properties)Env.getCtx(), (int)this.curWindowNo, (String)titleLogic, (boolean)false, (boolean)true);
                }
                sb.append(titleLogic);
                header = sb.toString().trim();
                if (header.endsWith(":")) {
                    header = header.substring(0, header.length() - 1);
                }
            }
            if (Util.isEmpty(header)) {
                header = AEnv.getDialogHeader(Env.getCtx(), this.curWindowNo, prefix);
            }
            SessionManager.getAppDesktop().setTabTitle(header, this.curWindowNo);
        }
        if (!detailTab) {
            Object dbInfo = e.getMessage();
            if (logger.isLoggable(Level.INFO)) {
                logger.info((String)dbInfo);
            }
            if (this.adTabbox.getSelectedGridTab() != null && this.adTabbox.getSelectedGridTab().isQueryActive()) {
                dbInfo = "[ " + (String)dbInfo + " ]";
            }
            this.breadCrumb.setStatusDB((String)dbInfo, e, this.adTabbox.getSelectedGridTab());
        } else if (this.adTabbox.getSelectedDetailADTabpanel() == null) {
            return;
        }
        if (e.getAD_Message() != null || e.getInfo() != null) {
            if ("NavigateOrUpdate".equals(e.getAD_Message())) {
                if (detailTab) {
                    String msg = e.getTotalRows() + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Records");
                    this.adTabbox.setDetailPaneStatusMessage(msg, false);
                } else if (this.getActiveGridTab().isQuickForm) {
                    this.statusBarQF.setStatusLine("", false);
                } else {
                    this.statusBar.setStatusLine("", false);
                }
            } else {
                String info;
                StringBuilder sb = new StringBuilder();
                String msg = e.getMessage();
                StringBuilder adMessage = new StringBuilder();
                Object origmsg = null;
                if (msg != null && msg.length() > 0) {
                    origmsg = detailTab && "Refreshed".equals(e.getAD_Message()) ? e.getTotalRows() + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"Records") : Msg.getMsg((Properties)Env.getCtx(), (String)e.getAD_Message());
                    adMessage.append((String)origmsg);
                }
                if ((info = e.getInfo()) != null && info.length() > 0) {
                    String[] arguments = info.split("[;]");
                    int index = 0;
                    while (index < arguments.length) {
                        String expr = "{" + index + "}";
                        if (adMessage.indexOf(expr) < 0) break;
                        ++index;
                    }
                    if (index < arguments.length) {
                        if (adMessage.length() > 0 && !adMessage.toString().trim().endsWith(":")) {
                            adMessage.append(": ");
                        }
                        StringBuilder tail = new StringBuilder();
                        while (index < arguments.length) {
                            if (tail.length() > 0) {
                                tail.append(", ");
                            }
                            tail.append("{").append(index).append("}");
                            ++index;
                        }
                        adMessage.append((CharSequence)tail);
                    }
                    if (arguments.length == 1 && origmsg != null && ((String)origmsg).equals(arguments[0])) {
                        sb.append((String)origmsg);
                    } else {
                        String adMessageQuot = Util.replace((String)adMessage.toString(), (String)"'", (String)"''");
                        sb.append(new MessageFormat(adMessageQuot, Env.getLanguage((Properties)Env.getCtx()).getLocale()).format(arguments));
                    }
                } else {
                    sb.append((CharSequence)adMessage);
                }
                if (sb.length() > 0) {
                    int pos = sb.indexOf("\n");
                    if (pos != -1 && pos + 1 < sb.length()) {
                        sb.replace(pos, pos + 1, " - ");
                    }
                    if (detailTab) {
                        this.adTabbox.setDetailPaneStatusMessage(sb.toString(), e.isError());
                    } else if (this.getActiveGridTab().isQuickForm) {
                        this.statusBarQF.setStatusLine(sb.toString(), e.isError());
                    } else {
                        this.statusBar.setStatusLine(sb.toString(), e.isError());
                    }
                }
            }
        }
        IADTabpanel iADTabpanel = tabPanel = detailTab ? this.adTabbox.getSelectedDetailADTabpanel() : this.getADTab().getSelectedTabpanel();
        if (e.isError() && !e.isConfirmed() && tabPanel instanceof ADTabpanel) {
            GridField[] fields;
            GridField[] pos = fields = tabPanel.getGridTab().getFields();
            int info = fields.length;
            int origmsg = 0;
            while (origmsg < info) {
                GridField field = pos[origmsg];
                if (field.isError()) {
                    ((ADTabpanel)tabPanel).setFocusToField(field.getColumnName());
                    break;
                }
                ++origmsg;
            }
            e.setConfirmed(true);
        } else if (e.isWarning() && !e.isConfirmed()) {
            boolean isImporting = false;
            if (e.getSource() instanceof GridTab) {
                GridTab gridTab = (GridTab)e.getSource();
                isImporting = gridTab.getTableModel().isImporting();
            } else if (e.getSource() instanceof GridTable) {
                GridTable gridTable = (GridTable)e.getSource();
                isImporting = gridTable.isImporting();
            }
            if (!isImporting) {
                Dialog.warn(this.curWindowNo, e.getAD_Message(), e.getInfo(), null);
                e.setConfirmed(true);
            }
        }
        boolean changed = e.isChanged() || e.isInserting();
        boolean readOnly = this.adTabbox.getSelectedGridTab().isReadOnly();
        boolean processed = this.adTabbox.getSelectedGridTab().isProcessed();
        boolean insertRecord = !readOnly;
        boolean bl = deleteRecord = !readOnly;
        if (!detailTab) {
            if (insertRecord) {
                insertRecord = tabPanel.getGridTab().isInsertRecord();
            }
            this.toolbar.enableNew(!changed && insertRecord && !tabPanel.getGridTab().isSortTab());
            this.toolbar.enableCopy(!changed && insertRecord && !tabPanel.getGridTab().isSortTab() && this.adTabbox.getSelectedGridTab().getRowCount() > 0);
            this.toolbar.enableRefresh(!changed);
            if (deleteRecord) {
                deleteRecord = tabPanel.getGridTab().isDeleteRecord();
            }
            this.toolbar.enableDelete(!changed && deleteRecord && !tabPanel.getGridTab().isSortTab() && !processed);
            if (readOnly && this.adTabbox.getSelectedGridTab().isAlwaysUpdateField()) {
                readOnly = false;
            }
        } else {
            this.adTabbox.updateDetailPaneToolbar(changed, readOnly);
        }
        boolean isEditting = this.adTabbox.needSave(true, false) || this.adTabbox.getSelectedGridTab().isNew() || this.adTabbox.getSelectedDetailADTabpanel() != null && this.adTabbox.getSelectedDetailADTabpanel().getGridTab().isNew();
        this.toolbar.enableIgnore(isEditting);
        this.switchEditStatus(isEditting);
        if (!(!changed || readOnly || this.toolbar.isSaveEnable() || Util.isEmpty((String)tabPanel.getGridTab().getRecord_UU()) && tabPanel.getGridTab().getRecord_ID() <= 0)) {
            if (this.adTabbox.getSelectedIndex() == 0 && !detailTab) {
                MRecentItem.addModifiedField((Properties)this.ctx, (int)this.adTabbox.getSelectedGridTab().getAD_Table_ID(), (int)this.adTabbox.getSelectedGridTab().getRecord_ID(), (String)this.adTabbox.getSelectedGridTab().getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx), (int)Env.getAD_Role_ID((Properties)this.ctx), (int)this.adTabbox.getSelectedGridTab().getAD_Window_ID(), (int)this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
            } else {
                GridTab mainTab = this.getMainTabAbove();
                if (mainTab != null) {
                    MRecentItem.addModifiedField((Properties)this.ctx, (int)mainTab.getAD_Table_ID(), (int)mainTab.getRecord_ID(), (String)mainTab.getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx), (int)Env.getAD_Role_ID((Properties)this.ctx), (int)mainTab.getAD_Window_ID(), (int)mainTab.getAD_Tab_ID());
                }
            }
        }
        this.toolbar.enableSave(this.adTabbox.needSave(true, false) || this.adTabbox.getSelectedGridTab().isNew() || this.adTabbox.getSelectedDetailADTabpanel() != null && this.adTabbox.getSelectedDetailADTabpanel().getGridTab().isNew());
        if (!e.isError() && Util.isEmpty((String)adInfo)) {
            this.autoSaveChanges(e);
        }
        if (e.getTotalRows() == 0 && insertRecord && !detailTab && !tabPanel.getGridTab().isSortTab()) {
            this.toolbar.enableNew(true);
            this.toolbar.enableCopy(false);
            this.toolbar.enableDelete(false);
        }
        if (!detailTab) {
            GridTab gt = this.adTabbox.getSelectedGridTab();
            String trxInfo = gt.getStatusLine();
            if (trxInfo == null) {
                trxInfo = "";
            }
            this.statusBar.setInfo(trxInfo);
            SessionManager.getAppDesktop().updateHelpQuickInfo(gt);
        }
        if ((canHaveAttachment = this.adTabbox.getSelectedGridTab().canHaveAttachment()) && e.isLoading() && this.adTabbox.getSelectedGridTab().getCurrentRow() > e.getLoadedRows()) {
            canHaveAttachment = false;
        }
        if (canHaveAttachment && this.adTabbox.getSelectedGridTab().getRecord_ID() == -1 && Util.isEmpty((String)this.adTabbox.getSelectedGridTab().getRecord_UU())) {
            canHaveAttachment = false;
        }
        if (canHaveAttachment) {
            this.toolbar.enableAttachment(true);
            this.toolbar.setPressed("Attachment", this.adTabbox.getSelectedGridTab().hasAttachment());
        } else {
            this.toolbar.enableAttachment(false);
        }
        boolean canHaveChat = true;
        if (e.isLoading() && this.adTabbox.getSelectedGridTab().getCurrentRow() > e.getLoadedRows()) {
            canHaveChat = false;
        }
        if (canHaveChat && this.adTabbox.getSelectedGridTab().getRecord_ID() == -1 && Util.isEmpty((String)this.adTabbox.getSelectedGridTab().getRecord_UU())) {
            canHaveChat = false;
        }
        if (canHaveChat) {
            this.toolbar.enableChat(true);
            this.toolbar.setPressed("Chat", this.adTabbox.getSelectedGridTab().hasChat());
            this.toolbar.enablePostIt(true);
            this.toolbar.setPressed("PostIt", this.adTabbox.getSelectedGridTab().hasPostIt());
            this.toolbar.enableLabel(true);
            this.toolbar.setPressed("Label", this.adTabbox.getSelectedGridTab().hasLabel());
        } else {
            this.toolbar.enableChat(false);
            this.toolbar.enablePostIt(false);
            this.toolbar.enableLabel(false);
        }
        if (this.toolbar.isPersonalLock) {
            this.toolbar.lock(this.adTabbox.getSelectedGridTab().isLocked());
        }
        if (!detailTab) {
            this.adTabbox.evaluate(e);
        }
        int record_ID = this.adTabbox.getSelectedGridTab().getRecord_ID();
        if (this.adTabbox.getSelectedGridTab().getTabLevel() == 0 && record_ID != this.masterRecord) {
            this.cleanFindWindowHashMap();
            this.masterRecord = record_ID;
        }
        boolean isNewRow = this.adTabbox.getSelectedGridTab().getRowCount() == 0 || this.adTabbox.getSelectedGridTab().isNew();
        this.toolbar.enableArchive(!isNewRow);
        this.toolbar.enableZoomAcross(!isNewRow);
        this.toolbar.enableActiveWorkflows(!isNewRow);
        this.toolbar.enableRequests(!isNewRow);
        this.toolbar.setPressed("Find", this.adTabbox.getSelectedGridTab().isQueryActive() || !isNewRow && (this.m_onlyCurrentRows || this.m_onlyCurrentDays > 0));
        this.toolbar.refreshUserQuery(this.adTabbox.getSelectedGridTab().getAD_Tab_ID(), this.getCurrentFindWindow() != null ? this.getCurrentFindWindow().getAD_UserQuery_ID() : 0);
        this.toolbar.enablePrint(this.adTabbox.getSelectedGridTab().isPrinted() && !isNewRow);
        this.toolbar.enableReport(!isNewRow);
        this.toolbar.enableExport(!isNewRow && !this.adTabbox.getSelectedGridTab().isSortTab());
        this.toolbar.enableFileImport(this.toolbar.isNewEnabled());
        this.toolbar.enableCSVImport(this.toolbar.isNewEnabled() && this.adTabbox.getSelectedGridTab().hasTemplate());
        this.toolbar.enableTabNavigation(this.breadCrumb.hasParentLink(), this.adTabbox.getSelectedDetailADTabpanel() != null);
        IADTabpanel adtab = this.adTabbox.getSelectedTabpanel();
        this.toolbar.enableProcessButton(adtab != null && adtab.isEnableProcessButton());
        this.toolbar.enableCustomize(adtab.isEnableCustomizeButton());
    }

    private synchronized void autoSaveChanges(DataStatusEvent e) {
        IADTabpanel dirtyTabpanel;
        if (!e.isInitEdit() && this.toolbar.isSaveEnable() && MSysConfig.getBooleanValue((String)"ZK_AUTO_SAVE_CHANGES", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && (dirtyTabpanel = this.adTabbox.getDirtyADTabpanel()) != null && !dirtyTabpanel.getGridTab().isSortTab() && Util.isEmpty((String)dirtyTabpanel.getGridTab().getCommitWarning(), (boolean)true) && Env.isAutoCommit((Properties)this.ctx, (int)this.curWindowNo) && dirtyTabpanel.getGridTab().isNeedSaveAndMandatoryFill()) {
            String tabsExcluded = MSysConfig.getValue((String)"ZK_AUTO_SAVE_TABS_EXCLUDED", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            boolean isTabExcluded = false;
            if (!Util.isEmpty((String)tabsExcluded)) {
                String tabID = String.valueOf(dirtyTabpanel.getGridTab().getAD_Tab_ID());
                String tabUU = dirtyTabpanel.getGridTab().getAD_Tab_UU();
                String[] stringArray = tabsExcluded.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String excl = stringArray[n2];
                    if (excl.equals(tabID) || excl.equals(tabUU)) {
                        isTabExcluded = true;
                    }
                    ++n2;
                }
            }
            if (!isTabExcluded) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                if (!this.showingOnExitDialog) {
                    Executions.schedule((Desktop)this.getComponent().getDesktop(), e1 -> this.asyncAutoSave(), (Event)new Event("onAutoSave"));
                }
            }
        }
    }

    private synchronized void asyncAutoSave() {
        IADTabpanel dirtyTabpanel;
        if (this.toolbar.isSaveEnable() && !this.showingOnExitDialog && (dirtyTabpanel = this.adTabbox.getDirtyADTabpanel()) != null && dirtyTabpanel.getGridTab().isNeedSaveAndMandatoryFill()) {
            this.onSave(false, false, null);
        }
    }

    public boolean isFirstTab() {
        int selTabIndex = this.adTabbox.getSelectedIndex();
        return selTabIndex == 0;
    }

    public void onRefresh(boolean fireEvent) {
        this.onRefresh(fireEvent, true);
    }

    public void onRefresh(final boolean fireEvent, boolean saveCurrentRow) {
        if (saveCurrentRow) {
            this.onSave(false, true, new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    AbstractADWindowContent.this.doOnRefresh(fireEvent);
                }
            });
        } else {
            this.doOnRefresh(fireEvent);
        }
    }

    protected void doOnRefresh(boolean fireEvent) {
        IADTabpanel headerTab = this.adTabbox.getSelectedTabpanel();
        IADTabpanel detailTab = this.adTabbox.getSelectedDetailADTabpanel();
        try {
            this.adTabbox.getSelectedGridTab().dataRefreshAll(fireEvent, true);
        }
        catch (Exception e) {
            if (DBException.isTimeout((Exception)e)) {
                Dialog.error(this.getWindowNo(), "GridTabLoadTimeoutError");
            } else {
                Dialog.error(this.getWindowNo(), "Error", e.getMessage());
                logger.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            this.adTabbox.getSelectedGridTab().reset();
            return;
        }
        this.adTabbox.getSelectedGridTab().refreshParentTabs();
        headerTab.dynamicDisplay(0);
        if (detailTab != null) {
            detailTab.dynamicDisplay(0);
        }
        this.focusToActivePanel();
        MRecentItem.touchUpdatedRecord((Properties)this.ctx, (int)this.adTabbox.getSelectedGridTab().getAD_Table_ID(), (int)this.adTabbox.getSelectedGridTab().getRecord_ID(), (String)this.adTabbox.getSelectedGridTab().getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx));
    }

    @Override
    public void onRefresh() {
        GridTab gridTab = this.adTabbox.getSelectedGridTab();
        this.onRefresh(true, false);
        if (gridTab.isSortTab()) {
            IADTabpanel tabPanel = this.adTabbox.getSelectedTabpanel();
            tabPanel.query(false, 0, 0);
        }
    }

    @Override
    public void onHelp() {
        this.closeToolbarPopup("Help");
        SessionManager.getAppDesktop().showWindow(new HelpWindow(this.gridWindow), "center");
    }

    @Override
    public void onNew() {
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_NEW.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
            private final /* synthetic */ Callback val$postCallback;
            {
                this.val$postCallback = callback;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onNewCallback((Callback<Boolean>)this.val$postCallback);
                }
            }
        };
        WindowValidatorEvent event = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_NEW.getName());
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, preCallback);
    }

    private void onNewCallback(final Callback<Boolean> postCallback) {
        if (!this.adTabbox.getSelectedGridTab().isInsertRecord()) {
            logger.warning("Insert Record disabled for Tab");
            if (postCallback != null) {
                postCallback.onCallback((Object)false);
            }
            return;
        }
        this.saveAndNavigate(new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    boolean newRecord = AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataNew(false);
                    if (newRecord) {
                        AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().dynamicDisplay(0);
                        AbstractADWindowContent.this.toolbar.enableNew(false);
                        AbstractADWindowContent.this.toolbar.enableCopy(false);
                        AbstractADWindowContent.this.toolbar.enableDelete(false);
                        AbstractADWindowContent.this.breadCrumb.enableFirstNavigation(AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getCurrentRow() > 0);
                        AbstractADWindowContent.this.breadCrumb.enableLastNavigation(AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getCurrentRow() + 1 < AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getRowCount());
                        AbstractADWindowContent.this.toolbar.enableTabNavigation(AbstractADWindowContent.this.breadCrumb.hasParentLink(), AbstractADWindowContent.this.adTabbox.getSelectedDetailADTabpanel() != null);
                        AbstractADWindowContent.this.toolbar.enableIgnore(true);
                        if (AbstractADWindowContent.this.adTabbox.getSelectedGridTab().isSingleRow() && AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().isGridView()) {
                            AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().switchRowPresentation();
                        }
                        if (AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().isGridView()) {
                            AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().getGridView().onEditCurrentRow();
                        }
                        if (postCallback != null) {
                            postCallback.onCallback((Object)true);
                        }
                    } else {
                        logger.severe("Could not create new record");
                        if (postCallback != null) {
                            postCallback.onCallback((Object)false);
                        }
                    }
                    AbstractADWindowContent.this.focusToActivePanel();
                } else if (postCallback != null) {
                    postCallback.onCallback((Object)result);
                }
            }
        });
    }

    @Override
    public void onCopy() {
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_COPY.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
            private final /* synthetic */ Callback val$postCallback;
            {
                this.val$postCallback = callback;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onCopyCallback((Callback<Boolean>)this.val$postCallback);
                }
            }
        };
        WindowValidatorEvent event = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_COPY.getName());
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, preCallback);
    }

    private void onCopyCallback(Callback<Boolean> postCallback) {
        if (!this.adTabbox.getSelectedGridTab().isInsertRecord()) {
            logger.warning("Insert Record disabled for Tab");
            if (postCallback != null) {
                postCallback.onCallback((Object)false);
            }
            return;
        }
        boolean newRecord = this.adTabbox.getSelectedGridTab().dataNew(true);
        if (newRecord) {
            this.adTabbox.getSelectedTabpanel().dynamicDisplay(0);
            this.toolbar.enableNew(false);
            this.toolbar.enableCopy(false);
            this.toolbar.enableDelete(false);
            this.breadCrumb.enableFirstNavigation(this.adTabbox.getSelectedGridTab().getCurrentRow() > 0);
            this.breadCrumb.enableLastNavigation(this.adTabbox.getSelectedGridTab().getCurrentRow() + 1 < this.adTabbox.getSelectedGridTab().getRowCount());
            this.toolbar.enableTabNavigation(false);
            this.toolbar.enableIgnore(true);
            if (this.adTabbox.getSelectedGridTab().isSingleRow() && this.adTabbox.getSelectedTabpanel().isGridView()) {
                this.adTabbox.getSelectedTabpanel().switchRowPresentation();
            }
            if (this.adTabbox.getSelectedTabpanel().isGridView()) {
                this.adTabbox.getSelectedTabpanel().getGridView().onEditCurrentRow();
            }
            this.focusToActivePanel();
            if (postCallback != null) {
                postCallback.onCallback((Object)true);
            }
        } else {
            logger.severe("Could not create new record");
            if (postCallback != null) {
                postCallback.onCallback((Object)false);
            }
        }
        this.focusToActivePanel();
    }

    @Override
    public void onFind() {
        if (this.adTabbox.getSelectedGridTab() == null) {
            return;
        }
        this.clearTitleRelatedContext();
        if (this.adTabbox.getDirtyADTabpanel() == null) {
            this.doOnFind();
        } else {
            this.onSave(false, true, new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        AbstractADWindowContent.this.doOnFind();
                    }
                }
            });
        }
    }

    private void doOnFind() {
        GridField[] findFields = this.adTabbox.getSelectedGridTab().getFields();
        if (!this.isCurrentFindWindowValid() && !this.getFindWindow(findFields)) {
            return;
        }
        if (!this.getCurrentFindWindow().getEventListeners("onWindowClose").iterator().hasNext()) {
            this.getCurrentFindWindow().addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractADWindowContent.this.hideBusyMask();
                    if (!AbstractADWindowContent.this.getCurrentFindWindow().isCancel()) {
                        MQuery query = AbstractADWindowContent.this.getCurrentFindWindow().getQuery();
                        if (query != null) {
                            AbstractADWindowContent.this.m_onlyCurrentRows = false;
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().setQuery(query);
                            AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().query(AbstractADWindowContent.this.m_onlyCurrentRows, AbstractADWindowContent.this.m_onlyCurrentDays, AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getMaxQueryRecords());
                        }
                        if (AbstractADWindowContent.this.getCurrentFindWindow().isCreateNew()) {
                            AbstractADWindowContent.this.onNew();
                        } else {
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefresh(false);
                            if (!AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().isGridView()) {
                                boolean forceGridView = false;
                                String up = Env.getContext((Properties)Env.getCtx(), (String)"ViewFindResult");
                                if (up.equals("0")) {
                                    forceGridView = MSysConfig.getBooleanValue((String)"ZK_GRID_AFTER_FIND", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
                                } else if (up.equals("1")) {
                                    forceGridView = true;
                                } else if (up.equals("2")) {
                                    boolean bl = forceGridView = AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().getGridTab().getRowCount() >= Env.getContextAsInt((Properties)Env.getCtx(), (String)"GridAfterFindThreshold");
                                }
                                if (forceGridView) {
                                    AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().switchRowPresentation();
                                }
                            }
                        }
                        AbstractADWindowContent.this.toolbar.refreshUserQuery(AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getAD_Tab_ID(), AbstractADWindowContent.this.getCurrentFindWindow().getAD_UserQuery_ID());
                        AbstractADWindowContent.this.focusToActivePanel();
                    } else {
                        AbstractADWindowContent.this.toolbar.setPressed("Find", AbstractADWindowContent.this.adTabbox.getSelectedGridTab().isQueryActive());
                        AbstractADWindowContent.this.focusToLastFocusEditor();
                    }
                }
            });
        }
        if (this.getCurrentFindWindow().getParent() != this.getComponent().getParent()) {
            this.getComponent().getParent().appendChild((Component)this.getCurrentFindWindow());
        } else {
            this.getCurrentFindWindow().setVisible(true);
        }
        this.showBusyMask(this.getCurrentFindWindow());
        LayoutUtils.openEmbeddedWindow((Component)this.toolbar, this.getCurrentFindWindow(), "after_start");
    }

    private boolean isCurrentFindWindowValid() {
        GridField[] findFields = this.adTabbox.getSelectedGridTab().getFields();
        return this.getCurrentFindWindow() != null && this.getCurrentFindWindow().validate(this.adTabbox.getSelectedGridTab().getWindowNo(), this.adTabbox.getSelectedGridTab().getName(), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), this.adTabbox.getSelectedGridTab().getTableName(), this.adTabbox.getSelectedGridTab().getWhereExtended(), findFields, 1, this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
    }

    @Override
    public void onIgnore() {
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_IGNORE.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
            private final /* synthetic */ Callback val$postCallback;
            {
                this.val$postCallback = callback;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onIgnoreCallback((Callback<Boolean>)this.val$postCallback);
                }
            }
        };
        WindowValidatorEvent event = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_IGNORE.getName());
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, preCallback);
    }

    private void onIgnoreCallback(Callback<Boolean> postCallback) {
        IADTabpanel dirtyTabpanel = this.adTabbox.getDirtyADTabpanel();
        boolean newrecod = this.adTabbox.getSelectedGridTab().isNew();
        if (dirtyTabpanel != null && dirtyTabpanel.getGridTab().isSortTab()) {
            this.adTabbox.dataIgnore();
            this.toolbar.enableIgnore(false);
        } else {
            this.clearTitleRelatedContext();
            this.adTabbox.dataIgnore();
            this.toolbar.enableIgnore(false);
            if (newrecod) {
                this.onRefresh(true, false);
            } else if (dirtyTabpanel != null) {
                dirtyTabpanel.getGridTab().dataRefresh(true);
                dirtyTabpanel.dynamicDisplay(0);
            } else {
                this.onRefresh(true, false);
            }
        }
        if (dirtyTabpanel != null) {
            RowRenderer renderer;
            GridTabRowRenderer gtr;
            Row row;
            this.focusToTabpanel(dirtyTabpanel);
            if (dirtyTabpanel.getGridView() != null && dirtyTabpanel.getGridView().getListbox() != null && dirtyTabpanel.getGridView().getListbox().getRowRenderer() != null && (row = (gtr = (GridTabRowRenderer)(renderer = dirtyTabpanel.getGridView().getListbox().getRowRenderer())).getCurrentRow()) != null) {
                gtr.setCurrentRow(row);
            }
        } else {
            this.focusToActivePanel();
        }
        this.updateToolbar();
        if (postCallback != null) {
            postCallback.onCallback((Object)true);
        }
    }

    @Override
    public void onSave() {
        final IADTabpanel dirtyTabpanel = this.adTabbox.getDirtyADTabpanel();
        this.onSave(true, false, new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    String statusLine = null;
                    statusLine = AbstractADWindowContent.this.getActiveGridTab().isQuickForm ? AbstractADWindowContent.this.statusBarQF.getStatusLine() : AbstractADWindowContent.this.statusBar.getStatusLine();
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefreshAll(true, true);
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().refreshParentTabs();
                    if (AbstractADWindowContent.this.getActiveGridTab().isQuickForm) {
                        AbstractADWindowContent.this.statusBarQF.setStatusLine(statusLine);
                    } else {
                        AbstractADWindowContent.this.statusBar.setStatusLine(statusLine);
                    }
                    if (AbstractADWindowContent.this.adTabbox.getSelectedDetailADTabpanel() != null && AbstractADWindowContent.this.adTabbox.getSelectedDetailADTabpanel().getGridTab() != null) {
                        AbstractADWindowContent.this.adTabbox.getSelectedDetailADTabpanel().getGridTab().dataRefreshAll(true, true);
                    }
                }
                if (dirtyTabpanel != null) {
                    if (dirtyTabpanel == AbstractADWindowContent.this.adTabbox.getSelectedDetailADTabpanel()) {
                        Clients.scrollIntoView((Component)dirtyTabpanel);
                    }
                    AbstractADWindowContent.this.focusToTabpanel(dirtyTabpanel);
                } else {
                    AbstractADWindowContent.this.focusToActivePanel();
                }
                if (AbstractADWindowContent.this.adTabbox.getSelectedGridTab().isQuickForm()) {
                    AbstractADWindowContent.this.onRefresh(true, true);
                }
            }
        });
    }

    public void onSave(final boolean onSaveEvent, final boolean onNavigationEvent, final Callback<Boolean> callback) {
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_SAVE.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, (Callback<Boolean>)callback);
                } else if (callback != null) {
                    callback.onCallback((Object)result);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback, callback){
            private final /* synthetic */ Callback val$postCallback;
            private final /* synthetic */ Callback val$callback;
            {
                this.val$postCallback = callback;
                this.val$callback = callback2;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onSaveCallback(onSaveEvent, onNavigationEvent, (Callback<Boolean>)this.val$postCallback);
                } else if (this.val$callback != null) {
                    this.val$callback.onCallback((Object)result);
                }
            }
        };
        WindowValidatorEvent event = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_SAVE.getName());
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, preCallback);
    }

    public void onSavePayment() {
        this.onSave(false, false, new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                AbstractADWindowContent.this.onRefresh(true, false);
            }
        });
    }

    private void onSaveCallback(final boolean onSaveEvent, final boolean onNavigationEvent, final Callback<Boolean> callback) {
        boolean newRecord;
        final boolean wasChanged = this.toolbar.isSaveEnable();
        IADTabpanel dirtyTabpanel = this.adTabbox.getDirtyADTabpanel();
        boolean bl = newRecord = dirtyTabpanel != null ? dirtyTabpanel.getGridTab().isNew() : this.adTabbox.getSelectedGridTab().isNew();
        if (dirtyTabpanel == null) {
            this.onSave0(onSaveEvent, onNavigationEvent, newRecord, wasChanged, callback);
            return;
        }
        if (!Util.isEmpty((String)dirtyTabpanel.getGridTab().getCommitWarning()) || !Env.isAutoCommit((Properties)this.ctx, (int)this.curWindowNo) && onNavigationEvent) {
            Dialog.ask(this.curWindowNo, "SaveChanges?", dirtyTabpanel.getGridTab().getCommitWarning(), new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        AbstractADWindowContent.this.onSave0(onSaveEvent, onNavigationEvent, newRecord, wasChanged, (Callback<Boolean>)callback);
                    } else if (callback != null) {
                        callback.onCallback((Object)false);
                    }
                }
            });
        } else {
            this.onSave0(onSaveEvent, onNavigationEvent, newRecord, wasChanged, callback);
        }
    }

    private void onSave0(boolean onSaveEvent, boolean navigationEvent, boolean newRecord, boolean wasChanged, Callback<Boolean> callback) {
        ADSortTab sortTab;
        IADTabpanel dirtyTabpanel2;
        IADTabpanel dirtyTabpanel = this.adTabbox.getDirtyADTabpanel();
        boolean retValue = this.adTabbox.dataSave(onSaveEvent);
        if (!retValue) {
            if (CLogger.peekError() == null && !wasChanged && callback != null) {
                callback.onCallback((Object)true);
                return;
            }
            this.showLastError();
            if (callback != null) {
                callback.onCallback((Object)false);
            }
            return;
        }
        if (!onSaveEvent && dirtyTabpanel != null && !(dirtyTabpanel instanceof ADSortTab)) {
            dirtyTabpanel.getGridTab().setCurrentRow(dirtyTabpanel.getGridTab().getCurrentRow());
        }
        if (!navigationEvent && dirtyTabpanel != null) {
            dirtyTabpanel.dynamicDisplay(0);
            dirtyTabpanel.afterSave(onSaveEvent);
        }
        if ((dirtyTabpanel2 = this.adTabbox.getDirtyADTabpanel()) != null && dirtyTabpanel2 != dirtyTabpanel) {
            this.onSave(onSaveEvent, navigationEvent, callback);
            return;
        }
        if (dirtyTabpanel instanceof ADSortTab && !(sortTab = (ADSortTab)dirtyTabpanel).isChanged()) {
            if (sortTab == this.adTabbox.getSelectedTabpanel()) {
                if (this.getActiveGridTab().isQuickForm) {
                    this.statusBarQF.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Saved"));
                } else {
                    this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Saved"));
                }
            } else {
                this.adTabbox.setDetailPaneStatusMessage(Msg.getMsg((Properties)Env.getCtx(), (String)"Saved"), false);
            }
        }
        if (wasChanged) {
            if (newRecord) {
                if (!Util.isEmpty((String)this.adTabbox.getSelectedGridTab().getRecord_UU()) || this.adTabbox.getSelectedGridTab().getRecord_ID() > 0) {
                    if (this.adTabbox.getSelectedIndex() == 0) {
                        MRecentItem.addModifiedField((Properties)this.ctx, (int)this.adTabbox.getSelectedGridTab().getAD_Table_ID(), (int)this.adTabbox.getSelectedGridTab().getRecord_ID(), (String)this.adTabbox.getSelectedGridTab().getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx), (int)Env.getAD_Role_ID((Properties)this.ctx), (int)this.adTabbox.getSelectedGridTab().getAD_Window_ID(), (int)this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
                    } else {
                        mainTab = this.getMainTabAbove();
                        if (mainTab != null) {
                            MRecentItem.addModifiedField((Properties)this.ctx, (int)mainTab.getAD_Table_ID(), (int)mainTab.getRecord_ID(), (String)mainTab.getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx), (int)Env.getAD_Role_ID((Properties)this.ctx), (int)mainTab.getAD_Window_ID(), (int)mainTab.getAD_Tab_ID());
                        }
                    }
                }
            } else if (this.adTabbox.getSelectedIndex() == 0) {
                MRecentItem.touchUpdatedRecord((Properties)this.ctx, (int)this.adTabbox.getSelectedGridTab().getAD_Table_ID(), (int)this.adTabbox.getSelectedGridTab().getRecord_ID(), (String)this.adTabbox.getSelectedGridTab().getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx));
            } else {
                mainTab = this.getMainTabAbove();
                if (mainTab != null) {
                    MRecentItem.touchUpdatedRecord((Properties)this.ctx, (int)mainTab.getAD_Table_ID(), (int)mainTab.getRecord_ID(), (String)mainTab.getRecord_UU(), (int)Env.getAD_User_ID((Properties)this.ctx));
                }
            }
        }
        if (dirtyTabpanel != null && dirtyTabpanel != this.adTabbox.getSelectedTabpanel()) {
            Executions.getCurrent().setAttribute(DETAIL_TABPANEL_SAVED_ATTR, (Object)dirtyTabpanel);
            dirtyTabpanel.getGridTab().refreshParentTabs();
        }
        if (callback != null) {
            callback.onCallback((Object)true);
        }
    }

    private GridTab getMainTabAbove() {
        GridTab mainTab = this.adTabbox.getSelectedGridTab();
        while (mainTab != null && mainTab.getTabLevel() > 0) {
            GridTab parentTab = mainTab.getParentTab();
            if (parentTab == mainTab) break;
            mainTab = parentTab;
        }
        return mainTab;
    }

    private void showLastError() {
        String msg = CLogger.retrieveErrorString(null);
        if (msg != null) {
            if (this.getActiveGridTab().isQuickForm) {
                this.statusBarQF.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)msg), true);
            } else {
                this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)msg), true);
            }
        }
    }

    private void showLastWarning() {
        String msg = CLogger.retrieveWarningString(null);
        if (msg != null) {
            this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)msg), true);
        }
    }

    @Override
    public void onSaveCreate() {
        this.onSave(true, true, new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefreshAll(true, true);
                    AbstractADWindowContent.this.adTabbox.getSelectedGridTab().refreshParentTabs();
                    IADTabpanel dirtyTabpanel = (IADTabpanel)Executions.getCurrent().removeAttribute(AbstractADWindowContent.DETAIL_TABPANEL_SAVED_ATTR);
                    if (dirtyTabpanel != null && dirtyTabpanel.getGridTab().isDetail()) {
                        try {
                            AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().getDetailPane().onNew();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        AbstractADWindowContent.this.onNew();
                    }
                }
            }
        });
    }

    @Override
    public void onDelete() {
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_DELETE.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
            private final /* synthetic */ Callback val$postCallback;
            {
                this.val$postCallback = callback;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onDeleteCallback((Callback<Boolean>)this.val$postCallback);
                }
            }
        };
        WindowValidatorEvent event = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_DELETE.getName());
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, preCallback);
    }

    private void onDeleteCallback(final Callback<Boolean> postCallback) {
        if (this.adTabbox.getSelectedGridTab().isReadOnly()) {
            if (postCallback != null) {
                postCallback.onCallback((Object)false);
            }
            return;
        }
        int[] indices = this.adTabbox.getSelectedGridTab().getSelection();
        if (indices.length > 0 && this.adTabbox.getSelectedTabpanel().isGridView()) {
            this.onDeleteSelected(postCallback);
            return;
        }
        this.deleteConfirmationLogic = this.adTabbox.getSelectedGridTab().getDeleteConfirmationLogic();
        if (Util.isEmpty((String)this.deleteConfirmationLogic)) {
            Dialog.ask(this.curWindowNo, "DeleteRecord?", new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        boolean success = AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataDelete();
                        AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefreshAll(true, true);
                        AbstractADWindowContent.this.adTabbox.getSelectedGridTab().refreshParentTabs();
                        if (!success) {
                            AbstractADWindowContent.this.showLastWarning();
                        }
                        AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().dynamicDisplay(0);
                        AbstractADWindowContent.this.focusToActivePanel();
                        MRecentItem.publishChangedEvent((int)Env.getAD_User_ID((Properties)AbstractADWindowContent.this.ctx));
                    }
                    if (postCallback != null) {
                        postCallback.onCallback((Object)result);
                    }
                }
            });
        } else {
            int tableID = this.adTabbox.getSelectedGridTab().getAD_Table_ID();
            int recordID = this.adTabbox.getSelectedGridTab().getRecord_ID();
            this.deleteConfirmationLogic = FileUtil.parseTitle((Properties)this.ctx, (String)this.deleteConfirmationLogic, (int)tableID, (int)recordID, (int)this.curWindowNo, null);
            this.deleteConfirmationLogic = Msg.parseTranslation((Properties)this.ctx, (String)this.deleteConfirmationLogic);
            WStringEditor editor = new WStringEditor();
            editor.fillHorizontal();
            editor.setValidInput(this.deleteConfirmationLogic);
            Dialog.askForInputTextConfirmation(this.curWindowNo, editor, "DeleteRecordWithConfirm?", new Object[]{this.deleteConfirmationLogic}, null, new Callback<Map.Entry<Boolean, String>>(){

                public void onCallback(Map.Entry<Boolean, String> result) {
                    if (!result.getKey().booleanValue() || !(result.getValue() instanceof String)) {
                        return;
                    }
                    if (result.getValue().equals(AbstractADWindowContent.this.deleteConfirmationLogic)) {
                        boolean success = AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataDelete();
                        AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefreshAll(true, true);
                        AbstractADWindowContent.this.adTabbox.getSelectedGridTab().refreshParentTabs();
                        if (!success) {
                            AbstractADWindowContent.this.showLastWarning();
                        }
                        AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().dynamicDisplay(0);
                        AbstractADWindowContent.this.focusToActivePanel();
                        MRecentItem.publishChangedEvent((int)Env.getAD_User_ID((Properties)AbstractADWindowContent.this.ctx));
                    }
                    if (postCallback != null) {
                        postCallback.onCallback((Object)result.getValue().equals(AbstractADWindowContent.this.deleteConfirmationLogic));
                    }
                }
            });
        }
    }

    private void onDeleteSelected(final Callback<Boolean> postCallback) {
        if (this.adTabbox.getSelectedGridTab().isReadOnly() || !this.adTabbox.getSelectedTabpanel().isGridView()) {
            if (postCallback != null) {
                postCallback.onCallback((Object)false);
            }
            return;
        }
        this.deleteConfirmationLogic = this.adTabbox.getSelectedGridTab().getDeleteConfirmationLogic();
        final int[] indices = this.adTabbox.getSelectedGridTab().getSelection();
        if (indices.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(Env.getContext((Properties)this.ctx, (int)this.curWindowNo, (String)"_WinInfo_WindowName", (boolean)false)).append(" - ").append(indices.length).append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected"));
            if (Util.isEmpty((String)this.deleteConfirmationLogic)) {
                Dialog.ask(sb.toString(), this.curWindowNo, "DeleteSelection", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().clearSelection();
                            Arrays.sort(indices);
                            int offset = 0;
                            int count = 0;
                            int i = 0;
                            while (i < indices.length) {
                                AbstractADWindowContent.this.adTabbox.getSelectedGridTab().navigate(indices[i] - offset);
                                if (AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataDelete()) {
                                    ++offset;
                                    ++count;
                                }
                                ++i;
                            }
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefreshAll(true, true);
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().refreshParentTabs();
                            AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().dynamicDisplay(0);
                            if (AbstractADWindowContent.this.getActiveGridTab().isQuickForm) {
                                AbstractADWindowContent.this.statusBarQF.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted") + ": " + count, false);
                            } else {
                                AbstractADWindowContent.this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted") + ": " + count, false);
                            }
                            MRecentItem.publishChangedEvent((int)Env.getAD_User_ID((Properties)AbstractADWindowContent.this.ctx));
                        }
                        if (postCallback != null) {
                            postCallback.onCallback((Object)result);
                        }
                    }
                }, new Object[0]);
            } else {
                this.deleteConfirmationLogic = Msg.getMsg((Properties)this.ctx, (String)"DeleteSelection");
                WStringEditor editor = new WStringEditor();
                editor.fillHorizontal();
                editor.setValidInput(this.deleteConfirmationLogic);
                Dialog.askForInputTextConfirmation(this.curWindowNo, editor, "DeleteSelectionWithConfirm?", new String[]{Integer.toString(indices.length), this.deleteConfirmationLogic}, null, new Callback<Map.Entry<Boolean, String>>(){

                    public void onCallback(Map.Entry<Boolean, String> result) {
                        if (!result.getKey().booleanValue() || !(result.getValue() instanceof String)) {
                            return;
                        }
                        if (result.getValue().equals(AbstractADWindowContent.this.deleteConfirmationLogic)) {
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().clearSelection();
                            Arrays.sort(indices);
                            int offset = 0;
                            int count = 0;
                            int i = 0;
                            while (i < indices.length) {
                                AbstractADWindowContent.this.adTabbox.getSelectedGridTab().navigate(indices[i] - offset);
                                if (AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataDelete()) {
                                    ++offset;
                                    ++count;
                                }
                                ++i;
                            }
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().dataRefreshAll(true, true);
                            AbstractADWindowContent.this.adTabbox.getSelectedGridTab().refreshParentTabs();
                            AbstractADWindowContent.this.adTabbox.getSelectedTabpanel().dynamicDisplay(0);
                            if (AbstractADWindowContent.this.getActiveGridTab().isQuickForm) {
                                AbstractADWindowContent.this.statusBarQF.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted") + ": " + count, false);
                            } else {
                                AbstractADWindowContent.this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted") + ": " + count, false);
                            }
                            MRecentItem.publishChangedEvent((int)Env.getAD_User_ID((Properties)AbstractADWindowContent.this.ctx));
                        }
                        if (postCallback != null) {
                            postCallback.onCallback((Object)result.getValue().equals(AbstractADWindowContent.this.deleteConfirmationLogic));
                        }
                    }
                });
            }
        } else {
            if (this.getActiveGridTab().isQuickForm) {
                this.statusBarQF.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected") + ": 0", false);
            } else {
                this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected") + ": 0", false);
            }
            if (postCallback != null) {
                postCallback.onCallback((Object)false);
            }
        }
    }

    @Override
    public void onPrint() {
        this.closeToolbarPopup("Print");
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_PRINT.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
            private final /* synthetic */ Callback val$postCallback;
            {
                this.val$postCallback = callback;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onPrintCallback((Callback<Boolean>)this.val$postCallback);
                }
            }
        };
        WindowValidatorEvent event = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_PRINT.getName());
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, preCallback);
    }

    private void onPrintCallback(final Callback<Boolean> postCallback) {
        final int AD_Process_ID = this.adTabbox.getSelectedGridTab().getAD_Process_ID();
        if (AD_Process_ID == 0) {
            this.onReport();
            return;
        }
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    int table_ID = AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getAD_Table_ID();
                    int record_ID = AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getRecord_ID();
                    String record_UU = AbstractADWindowContent.this.adTabbox.getSelectedGridTab().getRecord_UU();
                    final ProcessModalDialog dialog = new ProcessModalDialog(AbstractADWindowContent.this, AbstractADWindowContent.this.getWindowNo(), AD_Process_ID, table_ID, record_ID, record_UU, true);
                    if (dialog.isValid()) {
                        dialog.setBorder("normal");
                        AbstractADWindowContent.this.getComponent().getParent().appendChild((Component)dialog);
                        AbstractADWindowContent.this.showBusyMask(dialog);
                        LayoutUtils.openOverlappedWindow(AbstractADWindowContent.this.getComponent(), dialog, "middle_center");
                        if (postCallback != null) {
                            dialog.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                                public void onEvent(Event event) throws Exception {
                                    postCallback.onCallback((Object)(!dialog.isCancel() ? 1 : 0));
                                }
                            });
                        }
                        dialog.focus();
                    } else if (postCallback != null) {
                        postCallback.onCallback((Object)result);
                    }
                } else if (postCallback != null) {
                    postCallback.onCallback((Object)result);
                }
            }
        };
        this.onSave(false, true, callback);
    }

    @Override
    public void onReport() {
        if (!MRole.getDefault().isCanReport(this.adTabbox.getSelectedGridTab().getAD_Table_ID())) {
            Dialog.error(this.curWindowNo, "AccessCannotReport");
            return;
        }
        Callback<Boolean> callback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.onReport0();
                } else {
                    AbstractADWindowContent.this.focusToLastFocusEditor();
                }
            }
        };
        this.onSave(false, true, callback);
    }

    private void onReport0() {
        ReportAction reportAction = new ReportAction(this);
        reportAction.show();
    }

    @Override
    public void onZoomAcross() {
        if (this.toolbar.getEvent() != null) {
            MTable table2;
            int record_ID = this.adTabbox.getSelectedGridTab().getRecord_ID();
            if (record_ID <= 0 && !(table2 = MTable.get((int)this.adTabbox.getSelectedGridTab().getAD_Table_ID())).isUUIDKeyTable()) {
                return;
            }
            MQuery query = new MQuery();
            String link = this.adTabbox.getSelectedGridTab().getKeyColumnName();
            if (link.length() == 0) {
                link = this.adTabbox.getSelectedGridTab().getLinkColumnName();
            }
            if (link.length() != 0) {
                if (link.endsWith("_ID")) {
                    query.addRestriction(link, "=", (Object)Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)link));
                } else {
                    query.addRestriction(link, "=", (Object)Env.getContext((Properties)this.ctx, (int)this.curWindowNo, (String)link));
                }
            }
            new WZoomAcross((Component)this.toolbar.getToolbarItem("ZoomAcross"), this.adTabbox.getSelectedGridTab().getTableName(), this.adTabbox.getSelectedGridTab().getAD_Window_ID(), query);
        }
    }

    @Override
    public void onActiveWorkflows() {
        if (this.toolbar.getEvent() != null) {
            if (this.adTabbox.getSelectedGridTab().getRecord_ID() <= 0) {
                return;
            }
            this.closeToolbarPopup("ActiveWorkflows");
            try {
                AEnv.startWorkflowProcess(this.adTabbox.getSelectedGridTab().getAD_Table_ID(), this.adTabbox.getSelectedGridTab().getRecord_ID());
            }
            catch (Exception e) {
                CLogger.get().saveError("Error", e);
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    private void closeToolbarPopup(String btnName) {
        LabelImageElement btn = this.toolbar.getToolbarItem(btnName);
        Popup popup = LayoutUtils.findPopup(btn.getParent());
        if (popup != null) {
            popup.close();
        }
    }

    @Override
    public void onRequests() {
        if (this.toolbar.getEvent() != null) {
            int C_BPartner_ID = 0;
            Object bpartner = this.adTabbox.getSelectedGridTab().getValue("C_BPartner_ID");
            if (bpartner != null) {
                C_BPartner_ID = Integer.valueOf(bpartner.toString());
            }
            new WRequest((Component)this.toolbar.getToolbarItem("Requests"), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), this.adTabbox.getSelectedGridTab().getRecord_ID(), this.adTabbox.getSelectedGridTab().getRecord_UU(), C_BPartner_ID);
        }
    }

    @Override
    public void onProductInfo() {
        this.closeToolbarPopup("ProductInfo");
        InfoPanel.showPanel("M_Product");
    }

    @Override
    public void onArchive() {
        if (this.toolbar.getEvent() != null) {
            new WArchive((Component)this.toolbar.getToolbarItem("Archive"), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), this.adTabbox.getSelectedGridTab().getRecord_ID(), this.adTabbox.getSelectedGridTab().getRecord_UU());
        }
    }

    @Override
    public void onExport() {
        int AD_Table_ID = this.getActiveGridTab().getAD_Table_ID();
        boolean isCanExport = MRole.getDefault().isCanExport(AD_Table_ID);
        if (!isCanExport) {
            Dialog.error(this.curWindowNo, "AccessCannotExport");
            return;
        }
        ExportAction action = new ExportAction(this);
        action.export();
    }

    @Override
    public void onFileImport() {
        FileImportAction action = new FileImportAction(this);
        action.fileImport();
    }

    @Override
    public void onCSVImport() {
        CSVImportAction action = new CSVImportAction(this);
        action.fileImport();
    }

    @Override
    public void onSearchQuery() {
        if (this.adTabbox.getSelectedGridTab() == null) {
            return;
        }
        this.clearTitleRelatedContext();
        if (this.adTabbox.getDirtyADTabpanel() == null) {
            this.doOnQueryChange();
        } else {
            this.onSave(false, false, new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        AbstractADWindowContent.this.doOnQueryChange();
                    }
                }
            });
        }
    }

    public void doOnQueryChange() {
        GridField[] findFields = this.adTabbox.getSelectedGridTab().getFields();
        if (!this.isCurrentFindWindowValid() && !this.getFindWindow(findFields)) {
            return;
        }
        this.getCurrentFindWindow().setAD_UserQuery_ID(this.toolbar.getAD_UserQuery_ID());
        this.getCurrentFindWindow().advancedOkClick();
        MQuery query = this.getCurrentFindWindow().getQuery();
        if (query != null) {
            this.m_onlyCurrentRows = false;
            this.adTabbox.getSelectedGridTab().setQuery(query);
            try {
                this.adTabbox.getSelectedTabpanel().query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, MRole.getDefault().getMaxQueryRecords());
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof SQLException && DB.getDatabase().isQueryTimeout((SQLException)e.getCause())) {
                    return;
                }
                throw new DBException(e);
            }
        }
        this.adTabbox.getSelectedGridTab().dataRefresh(false);
        this.focusToActivePanel();
        this.getCurrentFindWindow().dispose();
    }

    private void actionButton(final IProcessButton wButton) {
        String col;
        if (this.adTabbox.getSelectedGridTab().hasChangedCurrentTabAndParents()) {
            String msg = CLogger.retrieveErrorString((String)"Please ReQuery Window");
            Dialog.error(this.curWindowNo, null, msg);
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(wButton.toString());
        }
        if ((col = wButton.getColumnName()).equals("Record_ID")) {
            int AD_Table_ID = -1;
            int Record_ID = -1;
            if (wButton instanceof WButtonEditor) {
                int curTabNo = 0;
                WButtonEditor be = (WButtonEditor)wButton;
                if (be.getGridField() != null && be.getGridField().getGridTab() != null) {
                    curTabNo = ((WButtonEditor)wButton).getGridField().getGridTab().getTabNo();
                    AD_Table_ID = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (int)curTabNo, (String)"AD_Table_ID");
                    Record_ID = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (int)curTabNo, (String)"Record_ID");
                }
            }
            if (AD_Table_ID < 0) {
                AD_Table_ID = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)"AD_Table_ID");
            }
            if (Record_ID < 0) {
                Record_ID = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)"Record_ID");
            }
            AEnv.zoom(AD_Table_ID, Record_ID);
            return;
        }
        if (this.adTabbox.needSave(true, false)) {
            this.onSave(false, true, new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        AbstractADWindowContent.this.actionButton0(col, wButton);
                    }
                }
            });
        } else {
            this.actionButton0(col, wButton);
        }
    }

    private void actionButton0(String col, final IProcessButton wButton) {
        IADTabpanel adtabPanel = null;
        adtabPanel = this.adTabbox.getSelectedGridTab().isQuickForm() ? this.getADTab().getSelectedTabpanel() : this.findADTabpanel(wButton);
        final boolean startWOasking = false;
        if (adtabPanel == null) {
            return;
        }
        final int table_ID = adtabPanel.getGridTab().getAD_Table_ID();
        int record_ID = adtabPanel.getGridTab().getRecord_ID();
        String record_UU = adtabPanel.getGridTab().getRecord_UU();
        if (record_ID == -1 && adtabPanel.getGridTab().getKeyColumnName().equals("AD_Language")) {
            record_ID = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)"AD_Language_ID");
        }
        if (record_ID == -1 && (wButton.getProcess_ID() == 306 || wButton.getProcess_ID() == 307)) {
            Integer id = (Integer)adtabPanel.getGridTab().getValue("AD_ChangeLog_ID");
            record_ID = id;
        }
        if (record_ID == -1 && adtabPanel.getGridTab().getKeyColumnName().endsWith("_ID")) {
            Dialog.error(this.curWindowNo, "SaveErrorRowNotFound");
            return;
        }
        final boolean isProcessMandatory = false;
        if (col.equals("DocAction")) {
            final WDocActionPanel win = new WDocActionPanel(adtabPanel.getGridTab());
            if (win.getNumberOfOptions() == 0) {
                logger.info("DocAction - No Options");
                return;
            }
            final int recordIdParam = record_ID;
            win.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractADWindowContent.this.hideBusyMask();
                    AbstractADWindowContent.this.focusToLastFocusEditor();
                    if (!win.isStartProcess()) {
                        return;
                    }
                    Callback<Boolean> postCallback = new Callback<Boolean>(){

                        public void onCallback(Boolean result) {
                            if (result.booleanValue()) {
                                WindowValidatorEvent event = new WindowValidatorEvent((this).AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_DOC_ACTION.getName());
                                WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                            }
                        }
                    };
                    Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
                        private final /* synthetic */ Callback val$postCallback;
                        {
                            this.val$postCallback = callback;
                        }

                        public void onCallback(Boolean result) {
                            if (result.booleanValue()) {
                                boolean startWOasking = true;
                                boolean isProcessMandatory = true;
                                AbstractADWindowContent.this.executeButtonProcess(wButton, startWOasking, table_ID, recordIdParam, isProcessMandatory, (Callback<Boolean>)this.val$postCallback);
                            }
                        }
                    };
                    WindowValidatorEvent validatorEvent = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.BEFORE_DOC_ACTION.getName(), wButton);
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(validatorEvent, preCallback);
                }
            });
            this.getComponent().getParent().appendChild((Component)win);
            this.showBusyMask(win);
            LayoutUtils.openOverlappedWindow(this.getComponent(), win, "middle_center");
            win.focus();
            return;
        }
        if (col.equals("CreateFrom")) {
            ICreateFrom cf = WCreateFromFactory.create(adtabPanel.getGridTab());
            if (cf != null) {
                if (cf.isInitOK()) {
                    final WCreateFromWindow window = (WCreateFromWindow)cf.getWindow();
                    if (SystemProperties.isZkUnitTest()) {
                        window.setWidgetAttribute("instanceName", AdempiereIdGenerator.escapeId(window.getTitle()));
                    }
                    window.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                        public void onEvent(Event event) throws Exception {
                            AbstractADWindowContent.this.hideBusyMask();
                            if (!window.isCancel()) {
                                AbstractADWindowContent.this.onRefresh(true, false);
                            } else {
                                AbstractADWindowContent.this.focusToLastFocusEditor();
                            }
                        }
                    });
                    window.setZindex(1000);
                    window.setMaximizable(true);
                    window.setSizable(true);
                    ZkCssHelper.appendStyle((HtmlBasedComponent)window, "position: absolute; ");
                    this.getComponent().getParent().appendChild((Component)window);
                    this.showBusyMask(window);
                    cf.showWindow();
                    LayoutUtils.openOverlappedWindow(this.getComponent(), window, "middle_center");
                    window.focus();
                }
                return;
            }
        } else if (col.equals("Posted") && MRole.getDefault().isShowAcct()) {
            Object ps;
            String docStatus;
            String processed = Env.getContext((Properties)this.ctx, (int)this.curWindowNo, (String)"Processed");
            if (!(processed.equals("Y") || "CO".equals(docStatus = Env.getContext((Properties)this.ctx, (int)this.curWindowNo, (String)"DocStatus")) || "CL".equals(docStatus) || "RE".equals(docStatus) || "VO".equals(docStatus) || table_ID == 623)) {
                Dialog.error(this.curWindowNo, "PostDocNotComplete");
                return;
            }
            int tableId = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)"AD_Table_ID", (boolean)true);
            int recordId = Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)"Record_ID", (boolean)true);
            if (tableId == 0 || recordId == 0) {
                tableId = adtabPanel.getGridTab().getAD_Table_ID();
                recordId = adtabPanel.getGridTab().getRecord_ID();
            }
            if ((ps = adtabPanel.getGridTab().getValue("Posted")) != null && ps.equals("Y")) {
                new WAcctViewer(Env.getContextAsInt((Properties)this.ctx, (int)this.curWindowNo, (String)"AD_Client_ID"), tableId, recordId);
            } else {
                final int tableIdRef = tableId;
                final int recordIdRef = recordId;
                Dialog.ask(this.curWindowNo, "PostImmediate?", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            boolean force = ps != null && !ps.equals("N");
                            String error = AEnv.postImmediate(AbstractADWindowContent.this.curWindowNo, Env.getAD_Client_ID((Properties)AbstractADWindowContent.this.ctx), tableIdRef, recordIdRef, force);
                            AbstractADWindowContent.this.onRefresh(true, false);
                            if (error != null) {
                                if (AbstractADWindowContent.this.getActiveGridTab().isQuickForm) {
                                    AbstractADWindowContent.this.statusBarQF.setStatusLine(error, true);
                                } else {
                                    AbstractADWindowContent.this.statusBar.setStatusLine(error, true);
                                }
                            }
                        }
                    }
                });
            }
            return;
        }
        final int finalRecordId = record_ID;
        final String finalRecordUU = record_UU;
        Callback<Boolean> postCallback = new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    WindowValidatorEvent event = new WindowValidatorEvent(AbstractADWindowContent.this.adwindow, WindowValidatorEventType.AFTER_PROCESS.getName());
                    WindowValidatorManager.getInstance().fireWindowValidatorEvent(event, null);
                }
            }
        };
        Callback<Boolean> preCallback = new Callback<Boolean>((Callback)postCallback){
            private final /* synthetic */ Callback val$postCallback;
            {
                this.val$postCallback = callback;
            }

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    AbstractADWindowContent.this.executeButtonProcess(wButton, startWOasking, table_ID, finalRecordId, finalRecordUU, isProcessMandatory, (Callback<Boolean>)this.val$postCallback);
                }
            }
        };
        WindowValidatorEvent validatorEvent = new WindowValidatorEvent(this.adwindow, WindowValidatorEventType.BEFORE_PROCESS.getName(), wButton);
        WindowValidatorManager.getInstance().fireWindowValidatorEvent(validatorEvent, preCallback);
    }

    private Div getMask() {
        if (this.mask == null) {
            this.mask = new Mask();
        }
        return this.mask;
    }

    public void hideBusyMask() {
        if (this.mask != null && this.mask.getParent() != null) {
            this.mask.detach();
            StringBuilder script = new StringBuilder("(function(){let w=zk.Widget.$('#");
            script.append(this.getComponent().getParent().getUuid()).append("');if(w) w.busy=false;");
            script.append("})()");
            Clients.response((AuResponse)new AuScript(script.toString()));
        }
    }

    public void showBusyMask(Window window) {
        this.getComponent().getParent().appendChild((Component)this.getMask());
        StringBuilder script = new StringBuilder("(function(){let w=zk.Widget.$('#");
        script.append(this.getComponent().getParent().getUuid()).append("');");
        if (window != null) {
            script.append("let d=zk.Widget.$('#").append(window.getUuid()).append("');w.busy=d;");
        } else {
            script.append("w.busy=true;");
        }
        script.append("})()");
        Clients.response((AuResponse)new AuScript(script.toString()));
    }

    public boolean isBlock() {
        if (this.mask != null && this.mask.getParent() != null) {
            return true;
        }
        if (this.getComponent() != null && this.getComponent().getPage() != null) {
            Collection roots = this.getComponent().getPage().getRoots();
            for (Component comp : roots) {
                org.zkoss.zul.Window wnd;
                if (!(comp instanceof org.zkoss.zul.Window) || !(wnd = (org.zkoss.zul.Window)comp).isVisible() || !wnd.inHighlighted()) continue;
                return true;
            }
        }
        if (this.getComponent() != null) {
            Component p = this.getComponent().getParent();
            while (p != null) {
                if (p instanceof Mask) {
                    if (p.isVisible()) {
                        return true;
                    }
                } else if (p instanceof DesktopTabpanel) {
                    for (Component c : p.getChildren()) {
                        if (!(c instanceof Mask) || !c.isVisible()) continue;
                        return true;
                    }
                }
                p = p.getParent();
            }
        }
        return false;
    }

    public void executeButtonProcess(IProcessButton wButton, boolean startWOasking, int table_ID, int record_ID, boolean isProcessMandatory, Callback<Boolean> callback) {
        this.executeButtonProcess(wButton, startWOasking, table_ID, record_ID, null, isProcessMandatory, callback);
    }

    public void executeButtonProcess(final IProcessButton wButton, final boolean startWOasking, final int table_ID, final int record_ID, String record_UU, boolean isProcessMandatory, final Callback<Boolean> callback) {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Process_ID=" + wButton.getProcess_ID() + ", InfoWindow_ID=" + wButton.getInfoWindow_ID() + ", Record_ID=" + record_ID + ", Record_UU=" + record_UU);
        }
        if (wButton.getProcess_ID() == 0 && wButton.getInfoWindow_ID() == 0) {
            if (isProcessMandatory) {
                Dialog.error(this.curWindowNo, null, Msg.parseTranslation((Properties)this.ctx, (String)"@NotFound@ @AD_Process_ID@ @AD_InfoWindow_ID@"));
            }
            return;
        }
        if (this.adTabbox.needSave(true, false)) {
            this.onSave(false, false, new Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        if (wButton.getInfoWindow_ID() > 0) {
                            AbstractADWindowContent.this.executionButtonInfoWindow0(wButton);
                        } else {
                            AbstractADWindowContent.this.executeButtonProcess0(wButton, startWOasking, table_ID, record_ID, (Callback<Boolean>)callback);
                        }
                    }
                }
            });
        } else if (wButton.getInfoWindow_ID() > 0) {
            this.executionButtonInfoWindow0(wButton);
        } else {
            this.executeButtonProcess0(wButton, startWOasking, table_ID, record_ID, record_UU, callback);
        }
    }

    private void executeButtonProcess0(IProcessButton wButton, boolean startWOasking, int table_ID, int record_ID, Callback<Boolean> callback) {
        this.executeButtonProcess0(wButton, startWOasking, table_ID, record_ID, null, callback);
    }

    private void executeButtonProcess0(IProcessButton wButton, boolean startWOasking, int table_ID, int record_ID, String record_UU, Callback<Boolean> callback) {
        MProcess pr = new MProcess(this.ctx, wButton.getProcess_ID(), null);
        int adFormID = pr.getAD_Form_ID();
        if (adFormID != 0) {
            String title = wButton.getDescription();
            if (title == null || title.length() == 0) {
                title = wButton.getDisplay();
            }
            ProcessInfo pi = new ProcessInfo(title, wButton.getProcess_ID(), table_ID, record_ID, record_UU);
            pi.setAD_User_ID(Env.getAD_User_ID((Properties)this.ctx));
            pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)this.ctx));
            IADTabpanel adtabPanel = null;
            adtabPanel = this.adTabbox.getSelectedGridTab().isQuickForm() ? this.getADTab().getSelectedTabpanel() : this.findADTabpanel(wButton);
            GridTab gridTab = null;
            if (adtabPanel != null) {
                gridTab = adtabPanel.getGridTab();
            }
            ADForm form = ADForm.openForm(adFormID, gridTab);
            form.setProcessInfo(pi);
            Window.Mode mode = form.getWindowMode();
            form.setAttribute("mode", form.getWindowMode());
            form.setAttribute("insertPosition", "insertNext");
            if (mode == Window.Mode.HIGHLIGHTED || mode == Window.Mode.MODAL) {
                form.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        AbstractADWindowContent.this.hideBusyMask();
                        AbstractADWindowContent.this.onRefresh(true, false);
                    }
                });
                form.setPage(this.getComponent().getPage());
                form.doHighlighted();
                form.focus();
            } else {
                SessionManager.getAppDesktop().showWindow(form);
            }
        } else {
            ProcessModalDialog dialog;
            int[] indices;
            IADTabpanel adtabPanel = null;
            adtabPanel = this.adTabbox.getSelectedGridTab().isQuickForm() ? this.getADTab().getSelectedTabpanel() : this.findADTabpanel(wButton);
            ProcessInfo pi = new ProcessInfo("", wButton.getProcess_ID(), table_ID, record_ID, record_UU);
            if (adtabPanel != null && adtabPanel.isGridView() && adtabPanel.getGridTab() != null && (indices = adtabPanel.getGridTab().getSelection()).length > 0) {
                MTable table2 = MTable.get((int)adtabPanel.getGridTab().getAD_Table_ID());
                if (table2.isUUIDKeyTable()) {
                    ArrayList<String> records = new ArrayList<String>();
                    int i = 0;
                    while (i < indices.length) {
                        String keyUUID = adtabPanel.getGridTab().getKeyUUID(indices[i]);
                        if (!Util.isEmpty((String)keyUUID)) {
                            records.add(keyUUID);
                        }
                        ++i;
                    }
                    pi.setRecord_UUs(records);
                } else {
                    ArrayList<Integer> records = new ArrayList<Integer>();
                    int i = 0;
                    while (i < indices.length) {
                        int keyID = adtabPanel.getGridTab().getKeyID(indices[i]);
                        if (keyID > 0) {
                            records.add(keyID);
                        }
                        ++i;
                    }
                    pi.setRecord_IDs(records);
                }
            }
            if ((dialog = adtabPanel != null && adtabPanel.getGridTab() != null ? new ProcessModalDialog(this, this.curWindowNo, adtabPanel.getGridTab().getTabNo(), pi, startWOasking) : new ProcessModalDialog((EventListener<Event>)this, this.curWindowNo, pi, startWOasking)).isValid()) {
                dialog.setBorder("normal");
                this.getComponent().getParent().appendChild((Component)dialog);
                if (callback != null) {
                    dialog.setAttribute(PROCESS_POST_CALLBACK_ATTRIBUTE, callback);
                }
                if (ClientInfo.isMobile()) {
                    dialog.doHighlighted();
                } else {
                    this.showBusyMask(dialog);
                    LayoutUtils.openOverlappedWindow(this.getComponent(), dialog, "middle_center");
                }
                Executions.schedule((Desktop)this.getComponent().getDesktop(), e -> dialog.focus(), (Event)new Event("onPostShowProcessModalDialog"));
            } else if (callback != null) {
                if (dialog.isCancel()) {
                    callback.onCallback((Object)Boolean.FALSE);
                } else {
                    pi = dialog.getProcessInfo();
                    if (pi == null || pi.isError()) {
                        callback.onCallback((Object)Boolean.FALSE);
                    } else {
                        callback.onCallback((Object)Boolean.TRUE);
                    }
                }
            }
        }
    }

    private void executionButtonInfoWindow0(IProcessButton wButton) {
        IADTabpanel adtabPanel = null;
        adtabPanel = this.adTabbox.getSelectedGridTab().isQuickForm() ? this.getADTab().getSelectedTabpanel() : this.findADTabpanel(wButton);
        if (adtabPanel == null) {
            return;
        }
        GridTab gridTab = adtabPanel.getGridTab();
        if (gridTab == null) {
            return;
        }
        final InfoWindow infoWindow = InfoManager.create(gridTab.getWindowNo(), wButton.getInfoWindow_ID(), null);
        infoWindow.setAttribute("mode", Window.Mode.OVERLAPPED);
        infoWindow.setCloseAfterExecutionOfProcess(true);
        infoWindow.setBorder("normal");
        infoWindow.setClosable(true);
        infoWindow.moveProcessButtonsToBeforeRight();
        int height = ClientInfo.get().desktopHeight;
        int width = ClientInfo.get().desktopWidth;
        if (width <= 1000) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)infoWindow, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)infoWindow, "100%");
        } else {
            height = height * 85 / 100;
            width = width * 80 / 100;
            ZKUpdateUtil.setWidth((HtmlBasedComponent)infoWindow, width + "px");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)infoWindow, height + "px");
        }
        infoWindow.setContentStyle("overflow: auto");
        if (SystemProperties.isZkUnitTest()) {
            infoWindow.setWidgetAttribute("instanceName", AdempiereIdGenerator.escapeId(infoWindow.getTitle()));
        }
        infoWindow.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                AbstractADWindowContent.this.hideBusyMask();
                if (!infoWindow.isCancelled()) {
                    AbstractADWindowContent.this.onRefresh(true, false);
                } else {
                    AbstractADWindowContent.this.focusToLastFocusEditor();
                }
            }
        });
        infoWindow.setZindex(1000);
        infoWindow.setMaximizable(true);
        infoWindow.setSizable(true);
        this.getComponent().getParent().appendChild((Component)infoWindow);
        this.showBusyMask(infoWindow);
        LayoutUtils.openOverlappedWindow(this.getComponent(), infoWindow, "middle_center");
        infoWindow.focusToFirstEditor();
    }

    @Override
    public void actionPerformed(final ActionEvent event) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String error = AbstractADWindowContent.this.processButtonCallout((IProcessButton)event.getSource());
                if (error != null && error.trim().length() > 0) {
                    if (AbstractADWindowContent.this.getActiveGridTab().isQuickForm) {
                        AbstractADWindowContent.this.statusBarQF.setStatusLine(error, true);
                    } else {
                        AbstractADWindowContent.this.statusBar.setStatusLine(error, true);
                    }
                    AbstractADWindowContent.this.focusToLastFocusEditor();
                    return;
                }
                AbstractADWindowContent.this.actionButton((IProcessButton)event.getSource());
            }
        };
        BusyDialogTemplate template = new BusyDialogTemplate(runnable);
        template.run();
    }

    private String processButtonCallout(IProcessButton button) {
        IADTabpanel adtab = null;
        adtab = this.adTabbox.getSelectedGridTab().isQuickForm() ? this.getADTab().getSelectedTabpanel() : this.findADTabpanel(button);
        if (adtab != null) {
            GridField field = adtab.getGridTab().getField(button.getColumnName());
            if (field != null) {
                return adtab.getGridTab().processCallout(field);
            }
            return "";
        }
        return "";
    }

    public IADTabpanel findADTabpanel(IProcessButton button) {
        IADTabpanel adtab = null;
        if (button.getADTabpanel() != null) {
            return button.getADTabpanel();
        }
        Component c = button instanceof WEditor ? ((WEditor)((Object)button)).getComponent() : (Component)button;
        while (c != null) {
            if (c instanceof IADTabpanel) {
                adtab = (IADTabpanel)c;
                break;
            }
            c = c.getParent();
        }
        return adtab;
    }

    public IADTabbox getADTab() {
        return this.adTabbox;
    }

    @Deprecated(forRemoval=true, since="11")
    public void executeASync(ProcessInfo pi) {
    }

    private void onModalClose(ProcessInfo pi) {
        boolean notPrint;
        if (this.getActiveGridTab().isQuickForm) {
            this.statusBarQF.setStatusLine(null);
        } else {
            this.statusBar.setStatusLine(null);
        }
        boolean bl = notPrint = pi != null && pi.getAD_Process_ID() != this.adTabbox.getSelectedGridTab().getAD_Process_ID() && !pi.isReportingProcess();
        if (Executions.getCurrent() != null) {
            if (notPrint || pi.isError()) {
                this.updateUI(pi);
            }
        } else {
            try {
                Executions.activate((Desktop)this.getComponent().getDesktop(), (long)2000L);
                try {
                    if (notPrint || pi.isError()) {
                        this.updateUI(pi);
                    }
                }
                finally {
                    Executions.deactivate((Desktop)this.getComponent().getDesktop());
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to update UI upon unlock.", (Throwable)e);
            }
        }
    }

    private void updateUI(ProcessInfo pi) {
        String summary;
        if (pi.isTimeout()) {
            Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"Processed", (String)"Y");
        }
        if ((summary = pi.getSummary()) != null && summary.indexOf(64) != -1) {
            pi.setSummary(Msg.parseTranslation((Properties)Env.getCtx(), (String)summary));
        }
        ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
        ProcessInfoLog[] m_logs = pi.getLogs();
        if (this.getActiveGridTab().isQuickForm) {
            this.statusBarQF.setStatusLine(pi.getSummary(), pi.isError(), m_logs);
        } else {
            this.statusBar.setStatusLine(pi.getSummary(), pi.isError(), m_logs);
        }
        if (m_logs != null && m_logs.length > 0) {
            ProcessInfoDialog dialog = ProcessInfoDialog.showProcessInfo(pi, this.curWindowNo, this.getComponent(), false);
            dialog.addEventListener("onWindowClose", e -> this.focusToActivePanel());
        }
    }

    public ADWindowToolbar getToolbar() {
        return this.toolbar;
    }

    public GridTab getActiveGridTab() {
        return this.adTabbox.getSelectedGridTab();
    }

    public int getWindowNo() {
        return this.curWindowNo;
    }

    @Override
    public void onCustomize() {
        ADTabpanel tabPanel = (ADTabpanel)this.getADTab().getSelectedTabpanel();
        CustomizeGridViewDialog.onCustomize(tabPanel, (Callback<Boolean>)((Callback)b -> this.focusToLastFocusEditor()));
    }

    @Override
    public void onProcess() {
        ProcessButtonPopup popup = new ProcessButtonPopup();
        popup.setWidgetAttribute("instanceName", "processButtonPopup");
        IADTabpanel adtab = this.adTabbox.getSelectedTabpanel();
        popup.render(adtab.getToolbarButtons());
        if (popup.getChildren().size() > 0) {
            popup.setPage(this.getComponent().getPage());
            popup.open((Component)this.getToolbar().getToolbarItem("Process"), "after_start");
        }
    }

    @Override
    public void onSelect() {
        if (this.getCurrentFindWindow() != null && this.getCurrentFindWindow().getPage() != null && this.getCurrentFindWindow().isVisible() && this.m_queryInitiating) {
            LayoutUtils.openEmbeddedWindow(this.getComponent().getParent(), this.getCurrentFindWindow(), "overlap");
        } else {
            this.focusToLastFocusEditor();
        }
    }

    public boolean isPendingChanges() {
        return this.adTabbox.getDirtyADTabpanel() != null;
    }

    public void setADWindow(ADWindow adwindow) {
        this.adwindow = adwindow;
    }

    public ADWindow getADWindow() {
        return this.adwindow;
    }

    public boolean getFindWindow(GridField[] findFields) {
        FindWindow findWindow = this.getCurrentFindWindow();
        if (findWindow != null && this.isCurrentFindWindowValid()) {
            this.toolbar.setSelectedUserQuery(findWindow.getAD_UserQuery_ID());
        } else {
            if (findWindow != null) {
                FindWindow old = findWindow;
                old.setId("");
                if (old.getDesktop() != null) {
                    AEnv.detachInputElement((Component)old);
                    Executions.schedule((Desktop)old.getDesktop(), e -> old.detach(), (Event)new Event("onDetachOldFindWindow"));
                }
            }
            findWindow = new FindWindow(this.adTabbox.getSelectedGridTab().getWindowNo(), this.adTabbox.getSelectedGridTab().getTabNo(), this.adTabbox.getSelectedGridTab().getName(), this.adTabbox.getSelectedGridTab().getAD_Table_ID(), this.adTabbox.getSelectedGridTab().getTableName(), this.adTabbox.getSelectedGridTab().getWhereExtended(), findFields, 1, this.adTabbox.getSelectedGridTab().getAD_Tab_ID(), this);
            this.setupEmbeddedFindwindow(findWindow);
            if (!findWindow.initialize()) {
                if (findWindow.getTotalRecords() == 0) {
                    Dialog.info(this.curWindowNo, "NoRecordsFound");
                }
                return false;
            }
            this.tabFindWindowHashMap.put(this.adTabbox.getSelectedGridTab(), findWindow);
        }
        return true;
    }

    public FindWindow getCurrentFindWindow() {
        return this.tabFindWindowHashMap.get(this.adTabbox.getSelectedGridTab());
    }

    private void cleanFindWindowHashMap() {
        List<FindWindow> list = this.tabFindWindowHashMap.entrySet().stream().filter(e -> ((GridTab)e.getKey()).getTabLevel() != 0).map(Map.Entry::getValue).collect(Collectors.toList());
        this.tabFindWindowHashMap.keySet().removeIf(tab -> tab.getTabLevel() != 0);
        if (!list.isEmpty()) {
            list.forEach(e -> AEnv.detachInputElement((Component)e));
            Executions.schedule((Desktop)this.getComponent().getDesktop(), e -> list.forEach(f -> f.detach()), (Event)new Event("onDetachCacheFindWindow"));
        }
    }

    private void clearTitleRelatedContext() {
        String titleLogic = null;
        int windowID = this.getADTab().getSelectedGridTab().getAD_Window_ID();
        if (windowID > 0) {
            titleLogic = MWindow.get((Properties)Env.getCtx(), (int)windowID).getTitleLogic();
        }
        if (titleLogic != null) {
            String inStr = new String(titleLogic);
            int i = inStr.indexOf(64);
            while (i != -1) {
                int j = (inStr = inStr.substring(i + 1, inStr.length())).indexOf(64);
                if (j < 0) {
                    logger.log(Level.SEVERE, "No second tag: " + inStr);
                    return;
                }
                String token = inStr.substring(0, j);
                Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)token, (String)"");
                inStr = inStr.substring(j + 1, inStr.length());
                i = inStr.indexOf(64);
            }
        } else {
            Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"DocumentNo", (String)"");
            Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"Value", (String)"");
            Env.setContext((Properties)this.ctx, (int)this.curWindowNo, (String)"Name", (String)"");
        }
    }

    public StatusBar getStatusBarQF() {
        return this.statusBarQF;
    }

    public void setStatusBarQF(StatusBar statusBar) {
        this.statusBarQF = statusBar;
    }

    public QuickGridView getCurrQGV() {
        return this.currQGV;
    }

    public void setCurrQGV(QuickGridView currQGV) {
        this.currQGV = currQGV;
    }

    public void closeQuickFormTab(Integer AD_Tab_ID) {
        this.quickFormOpenTabs.remove(AD_Tab_ID);
    }

    public ArrayList<Integer> getOpenQuickFormTabs() {
        return this.quickFormOpenTabs;
    }

    public boolean registerQuickFormTab(Integer AD_Tab_ID) {
        if (this.quickFormOpenTabs.contains(AD_Tab_ID)) {
            return false;
        }
        this.quickFormOpenTabs.add(AD_Tab_ID);
        return true;
    }

    public GridWindow getGridWindow() {
        return this.gridWindow;
    }

    public void setLastFocusEditor(Component component) {
        this.lastFocusEditor = component;
    }
}

