/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.server.cluster.callable;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.compiere.util.CLogFile;
import org.idempiere.server.cluster.callable.LogFileCallable;

public class GetLogInfoCallable
extends LogFileCallable
implements Callable<LogInfo>,
Serializable {
    private static final long serialVersionUID = 33969865104073117L;
    private String fileName;

    public GetLogInfoCallable(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public LogInfo call() throws Exception {
        File file;
        CLogFile fileHandler = CLogFile.get((boolean)false, null, (boolean)false);
        if (fileHandler != null && fileHandler.getFileName().equals(this.fileName)) {
            fileHandler.flush();
        }
        if (!this.isAccessible(file = new File(this.fileName))) {
            return null;
        }
        long length = file.length();
        int noOfBlocks = 1;
        if (length > 0x500000L) {
            int v = (int)((length - 1L) / 0x500000L + 1L);
            if (v == 0) {
                v = 1;
            }
            noOfBlocks = v;
        }
        return new LogInfo(this.fileName, length, 0x500000, noOfBlocks);
    }

    public static class LogInfo
    implements Serializable {
        private static final long serialVersionUID = -4154825003947713729L;
        private String fileName;
        private long length;
        private int blockSize;
        private int noOfBlocks;

        public LogInfo(String fileName, long length, int blockSize, int noOfBlocks) {
            this.fileName = fileName;
            this.length = length;
            this.blockSize = blockSize;
            this.noOfBlocks = noOfBlocks;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getLength() {
            return this.length;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public int getNoOfBlocks() {
            return this.noOfBlocks;
        }
    }
}

