/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.eclipse.equinox.http.servlet;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.adempiere.base.sso.SSOUtils;
import org.adempiere.eclipse.equinox.http.servlet.Registration;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.osgi.service.http.HttpContext;

public class ServletRegistration
extends Registration {
    protected static CLogger log = CLogger.getCLogger(ServletRegistration.class);
    private Servlet servlet;
    private HttpContext httpContext;
    private ClassLoader registeredContextClassLoader;

    public ServletRegistration(Servlet servlet, HttpContext context) {
        this.servlet = servlet;
        this.httpContext = context;
        this.registeredContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            super.destroy();
            this.servlet.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            this.servlet.init(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            boolean isSSOEnable = MSysConfig.getBooleanValue((String)"ENABLE_SSO_OSGI_CONSOLE", (boolean)false);
            if (isSSOEnable && SSOUtils.getSSOPrincipalService() != null) {
                Object token = req.getSession().getAttribute("sso.principal.token");
                if (this.checkSSOAuthorization(token)) {
                    this.servlet.service((ServletRequest)req, (ServletResponse)resp);
                    if (req.getPathInfo().endsWith("logout")) {
                        req.getSession().removeAttribute("sso.principal.token");
                        resp.sendRedirect("osgi/system/console/bundles");
                    }
                } else {
                    req.getSession().removeAttribute("sso.principal.token");
                }
            } else if (this.httpContext.handleSecurity(req, resp)) {
                this.servlet.service((ServletRequest)req, (ServletResponse)resp);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    private boolean checkSSOAuthorization(Object token) {
        if (token == null) {
            return false;
        }
        try {
            String username = SSOUtils.getSSOPrincipalService().getUserName(token);
            return this.validateUser(username, null, true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "SSOAuthorizationChekError", (Throwable)e);
            return false;
        }
    }

    private boolean validateUser(String name, String password, boolean isSSO) {
        MUser user = MUser.get((Properties)Env.getCtx(), (String)name, (String)password, (boolean)isSSO);
        if (user == null) {
            log.warning("User not found: '" + name);
            return false;
        }
        if (!user.isAdministrator() && !user.hasURLFormAccess("/osgi/system/console")) {
            log.warning("User doesn't have access to /osgi/system/console = " + name);
            return false;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Name=" + name);
        }
        return Boolean.TRUE;
    }
}

