/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.SimpleDateFormat;
import org.compiere.Adempiere;
import org.compiere.model.MClientInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.layout.HeaderFooter;
import org.compiere.print.layout.ImageElement;
import org.compiere.print.layout.PrintElement;
import org.compiere.print.layout.StringElement;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.print.IPrintHeaderFooter;

public class StandardHeaderFooter
implements IPrintHeaderFooter {
    @Override
    public void createHeaderFooter(MPrintFormat m_format, HeaderFooter m_headerFooter, Rectangle m_header, Rectangle m_footer, MQuery m_query) {
        MClientInfo ci = MClientInfo.get(Env.getCtx());
        PrintElement element = null;
        element = ci.getLogoReport_ID() > 0 ? new ImageElement(ci.getLogoReport_ID(), false) : new ImageElement(Adempiere.getHeaderLogo());
        element.layout(48.0f, 15.0f, false, "L");
        element.setLocation(m_header.getLocation());
        m_headerFooter.addElement(element);
        MPrintTableFormat tf = m_format.getTableFormat();
        Font font = tf.getPageHeader_Font();
        Color color = tf.getPageHeaderFG_Color();
        element = new StringElement("@*ReportName@", font, color, null, true);
        element.layout(m_header.width, 0.0f, true, "C");
        element.setLocation(m_header.getLocation());
        m_headerFooter.addElement(element);
        element = new StringElement("@Page@ @*Page@ @of@ @*PageCount@", font, color, null, true);
        element.layout(m_header.width, 0.0f, true, "T");
        element.setLocation(m_header.getLocation());
        m_headerFooter.addElement(element);
        font = tf.getPageFooter_Font();
        color = tf.getPageFooterFG_Color();
        element = new StringElement(Env.getStandardReportFooterTrademarkText(), font, color, null, true);
        element.layout(m_footer.width, 0.0f, true, "L");
        Point ft = m_footer.getLocation();
        ft.y = (int)((float)ft.y + ((float)m_footer.height - element.getHeight() - 2.0f));
        element.setLocation(ft);
        m_headerFooter.addElement(element);
        String s = MSysConfig.getValue("ZK_FOOTER_SERVER_MSG", "", Env.getAD_Client_ID(Env.getCtx()));
        if (Util.isEmpty(s, true)) {
            s = "@*Header@";
        }
        element = new StringElement(s, font, color, null, true);
        element.layout(m_footer.width, 0.0f, true, "C");
        element.setLocation(ft);
        m_headerFooter.addElement(element);
        String timestamp = "";
        s = MSysConfig.getValue("ZK_FOOTER_SERVER_DATETIME_FORMAT", Env.getAD_Client_ID(Env.getCtx()));
        timestamp = !Util.isEmpty(s, true) ? new SimpleDateFormat(s).format(System.currentTimeMillis()) : "@*CurrentDateTime@";
        element = new StringElement(timestamp, font, color, null, true);
        element.layout(m_footer.width, 0.0f, true, "T");
        element.setLocation(ft);
        m_headerFooter.addElement(element);
    }

    @Override
    public int getHeaderHeight() {
        return 18;
    }

    @Override
    public int getFooterHeight() {
        return 18;
    }
}

