/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MQuery;
import org.compiere.print.MPrintTableFormat;
import org.compiere.print.layout.GridElement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class PInstanceLogElement
extends GridElement {
    private static final long serialVersionUID = 8315529954507023182L;
    private int m_effectiveRowCount = 0;

    public PInstanceLogElement(Properties ctx, MQuery query, MPrintTableFormat tFormat) {
        super(PInstanceLogElement.calculateRowCount(query, ctx), 4);
        int AD_PInstance_ID = query.getAD_PInstance_ID();
        if (AD_PInstance_ID > 0) {
            MPInstance instance = new MPInstance(ctx, AD_PInstance_ID, null);
            MPInstanceLog[] logs = instance.getLog();
            int r = 0;
            while (r < logs.length) {
                Timestamp date;
                BigDecimal num;
                int col = 0;
                String msg = logs[r].getP_Msg();
                if (!Util.isEmpty(msg, true)) {
                    String s = Msg.parseTranslation(ctx, msg);
                    this.setData(r, col++, s, tFormat.getParameter_Font(), tFormat.getParameter_Color());
                }
                if ((num = logs[r].getP_Number()) != null) {
                    String s = num.toString();
                    this.setData(r, col++, s, tFormat.getParameter_Font(), tFormat.getParameter_Color());
                }
                if ((date = logs[r].getP_Date()) != null) {
                    String s = date.toString();
                    this.setData(r, col++, s, tFormat.getParameter_Font(), tFormat.getParameter_Color());
                }
                if (col > 0) {
                    ++this.m_effectiveRowCount;
                }
                ++r;
            }
        }
    }

    public int getEffectiveRowCount() {
        return this.m_effectiveRowCount;
    }

    private static int calculateRowCount(MQuery query, Properties ctx) {
        String sql;
        int no;
        int AD_PInstance_ID = query.getAD_PInstance_ID();
        if (AD_PInstance_ID > 0 && (no = DB.getSQLValue(null, sql = "SELECT COUNT(*) FROM AD_PInstance_Log WHERE AD_PInstance_ID=?", AD_PInstance_ID)) > 0) {
            return no;
        }
        return 0;
    }
}

