/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.adempiere.exceptions.DBException;
import org.compiere.print.MPrintFormatItem;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.compiere.print.layout.InstanceAttributeColumn;
import org.compiere.print.layout.TableProperties;
import org.compiere.print.util.SerializableMatrix;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class InstanceAttributeData {
    private MPrintFormatItem item;
    private List<String> attributes;
    private List<Map<String, String>> attributeRows;
    private int columnIndex;

    public InstanceAttributeData(MPrintFormatItem item, int columnIndex) {
        this.item = item;
        this.columnIndex = columnIndex;
    }

    public String getAttributeValue(int rowIndex, String attributeName) {
        if (this.attributeRows == null) {
            return null;
        }
        if (rowIndex >= this.attributeRows.size()) {
            return null;
        }
        Map<String, String> valueMap = this.attributeRows.get(rowIndex);
        return valueMap.get(attributeName);
    }

    public MPrintFormatItem getPrintFormatItem() {
        return this.item;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public List<InstanceAttributeColumn> getColumns() {
        ArrayList<InstanceAttributeColumn> list = new ArrayList<InstanceAttributeColumn>();
        for (String s : this.attributes) {
            InstanceAttributeColumn col = new InstanceAttributeColumn(s, this);
            list.add(col);
        }
        return list;
    }

    public void readAttributesData(PrintData printData) {
        this.attributes = new ArrayList<String>();
        this.attributeRows = new ArrayList<Map<String, String>>();
        int i2 = 0;
        while (i2 < printData.getRowCount()) {
            KeyNamePair knp;
            int asiId;
            PrintDataElement dataElement;
            Object value;
            printData.setRowIndex(i2);
            HashMap<String, String> attributeMap = new HashMap<String, String>();
            Object node = printData.getNodeByPrintFormatItem(this.item);
            if (node instanceof PrintDataElement && (value = (dataElement = (PrintDataElement)node).getValue()) != null && value instanceof KeyNamePair && (asiId = (knp = (KeyNamePair)value).getKey()) > 0) {
                String sql = "SELECT b.Name, a.Value FROM M_AttributeInstance a JOIN M_Attribute b ON (a.M_Attribute_ID=b.M_Attribute_ID) WHERE a.M_AttributeSetInstance_ID=?";
                try {
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (CPreparedStatement stmt = DB.prepareStatement(sql, null);){
                        stmt.setInt(1, asiId);
                        ResultSet rs = stmt.executeQuery();
                        while (rs.next()) {
                            String attribute = rs.getString(1);
                            String attributeValue = rs.getString(2);
                            if (Util.isEmpty(attributeValue)) continue;
                            if (!this.attributes.contains(attribute)) {
                                this.attributes.add(attribute);
                            }
                            attributeMap.put(attribute, attributeValue);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e);
                }
            }
            this.attributeRows.add(attributeMap);
            ++i2;
        }
    }

    public void updateTable(SerializableMatrix<Serializable> elements, TableProperties tableProperties, int columnOffset) {
        String valueJustification;
        ArrayList<ValueNamePair> columnHeaderList = new ArrayList<ValueNamePair>();
        Collections.addAll(columnHeaderList, tableProperties.getColumnHeader());
        ArrayList<Integer> columnMaxWidthList = new ArrayList<Integer>();
        int[] nArray = tableProperties.getColumnMaxWidth();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int t = nArray[n2];
            columnMaxWidthList.add(t);
            ++n2;
        }
        ArrayList<Integer> columnMaxHeightList = new ArrayList<Integer>();
        int[] nArray2 = tableProperties.getColumnMaxHeight();
        int n3 = nArray2.length;
        n = 0;
        while (n < n3) {
            int t = nArray2[n];
            columnMaxHeightList.add(t);
            ++n;
        }
        ArrayList<String> columnJustificationList = new ArrayList<String>();
        Collections.addAll(columnJustificationList, tableProperties.getColumnJustification());
        ArrayList<Boolean> fixedWidthList = new ArrayList<Boolean>();
        boolean[] blArray = tableProperties.getFixedWidth();
        int n4 = blArray.length;
        int n5 = 0;
        while (n5 < n4) {
            boolean t = blArray[n5];
            fixedWidthList.add(t);
            ++n5;
        }
        ArrayList<Boolean> colSuppressRepeatsList = new ArrayList<Boolean>();
        Boolean[] booleanArray = tableProperties.getColSuppressRepeats();
        int n6 = booleanArray.length;
        n4 = 0;
        while (n4 < n6) {
            boolean t = booleanArray[n4];
            colSuppressRepeatsList.add(t);
            ++n4;
        }
        int valueMaxWidth = this.item.getMaxWidth();
        boolean valueFixedWidth = valueMaxWidth != 0 && this.item.isFixedWidth();
        boolean valueSuppressRepeats = this.item.isSuppressRepeats();
        if (this.item.isSuppressNull()) {
            valueMaxWidth = valueMaxWidth == 0 ? -1 : (valueMaxWidth *= -1);
        }
        int valueMaxHeight = this.item.getMaxHeight();
        if (this.item.isHeightOneLine()) {
            valueMaxHeight = -1;
        }
        if ((valueJustification = this.item.getFieldAlignmentType()) == null || valueJustification.equals("D")) {
            valueJustification = "L";
        }
        int index = this.columnIndex + columnOffset;
        for (String s : this.attributes) {
            columnHeaderList.add(index, new ValueNamePair(s, s));
            columnMaxWidthList.add(index, valueMaxWidth);
            columnMaxHeightList.add(index, valueMaxHeight);
            columnJustificationList.add(index, valueJustification);
            fixedWidthList.add(index, valueFixedWidth);
            colSuppressRepeatsList.add(index, valueSuppressRepeats);
            ++index;
        }
        tableProperties.setColumnHeader(columnHeaderList.toArray(new ValueNamePair[0]));
        tableProperties.setColumnMaxWidth(columnMaxWidthList.stream().mapToInt(i2 -> i2).toArray());
        tableProperties.setColumnMaxHeight(columnMaxHeightList.stream().mapToInt(i2 -> i2).toArray());
        tableProperties.setColumnJustification(columnJustificationList.toArray(new String[0]));
        boolean[] fixedWidth = new boolean[fixedWidthList.size()];
        int i3 = 0;
        while (i3 < fixedWidthList.size()) {
            fixedWidth[i3] = (Boolean)fixedWidthList.get(i3);
            ++i3;
        }
        tableProperties.setFixedWidth(fixedWidth);
        Boolean[] colSuppressRepeats = new Boolean[colSuppressRepeatsList.size()];
        int i4 = 0;
        while (i4 < colSuppressRepeatsList.size()) {
            colSuppressRepeats[i4] = (Boolean)colSuppressRepeatsList.get(i4);
            ++i4;
        }
        tableProperties.setColSuppressRepeats(colSuppressRepeats);
        i4 = 0;
        while (i4 < elements.getRowCount()) {
            elements.setRowIndex(i4);
            List<Serializable> columns = elements.getRowData();
            Map<String, String> attributeRow = this.attributeRows.get(i4);
            index = this.columnIndex + columnOffset;
            for (String s : this.attributes) {
                String value = attributeRow.get(s);
                columns.add(index, (Serializable)((Object)value));
                ++index;
            }
            ++i4;
        }
    }
}

