/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.POIterator;
import org.compiere.model.POResultSet;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class Query {
    public static final String AGGREGATE_COUNT = "COUNT";
    public static final String AGGREGATE_SUM = "SUM";
    public static final String AGGREGATE_AVG = "AVG";
    public static final String AGGREGATE_MIN = "MIN";
    public static final String AGGREGATE_MAX = "MAX";
    private static CLogger log = CLogger.getCLogger(Query.class);
    private Properties ctx = null;
    private MTable table = null;
    private String whereClause = null;
    private String orderBy = null;
    private String trxName = null;
    private Object[] parameters = null;
    private String[] virtualColumns = null;
    private boolean applyAccessFilter = false;
    private boolean applyAccessFilterRW = false;
    private boolean applyAccessFilterFullyQualified = true;
    private boolean onlyActiveRecords = false;
    private boolean onlyClient_ID = false;
    private int onlySelection_ID = -1;
    private boolean forUpdate = false;
    private boolean noVirtualColumn = true;
    private int queryTimeout = 0;
    private List<String> joinClauseList = new ArrayList<String>();
    private int pageSize;
    private int recordsToSkip;

    public Query(MTable table2, String whereClause, String trxName) {
        this.ctx = table2.getCtx();
        this.table = table2;
        this.whereClause = whereClause;
        this.trxName = trxName;
    }

    public Query(Properties ctx, MTable table2, String whereClause, String trxName) {
        this.ctx = ctx;
        this.table = table2;
        this.whereClause = whereClause;
        this.trxName = trxName;
    }

    public Query(Properties ctx, String tableName, String whereClause, String trxName) {
        this(ctx, MTable.get(ctx, tableName), whereClause, trxName);
        if (this.table == null) {
            throw new IllegalArgumentException("Table Name Not Found - " + tableName);
        }
    }

    public Query setParameters(Object ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public Query setParameters(List<Object> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return this;
        }
        this.parameters = new Object[parameters.size()];
        parameters.toArray(this.parameters);
        return this;
    }

    public Query setOrderBy(String orderBy) {
        String string = this.orderBy = orderBy != null ? orderBy.trim() : null;
        if (this.orderBy != null && this.orderBy.toUpperCase().startsWith("ORDER BY")) {
            this.orderBy = this.orderBy.substring(8);
        }
        return this;
    }

    public Query setApplyAccessFilter(boolean flag) {
        this.applyAccessFilter = flag;
        return this;
    }

    public Query setApplyAccessFilter(boolean fullyQualified, boolean RW) {
        this.applyAccessFilter = true;
        this.applyAccessFilterFullyQualified = fullyQualified;
        this.applyAccessFilterRW = RW;
        return this;
    }

    public Query setOnlyActiveRecords(boolean onlyActiveRecords) {
        this.onlyActiveRecords = onlyActiveRecords;
        return this;
    }

    public Query setClient_ID() {
        return this.setClient_ID(true);
    }

    public Query setClient_ID(boolean isIncludeClient) {
        this.onlyClient_ID = isIncludeClient;
        return this;
    }

    public Query setOnlySelection(int AD_PInstance_ID) {
        this.onlySelection_ID = AD_PInstance_ID;
        return this;
    }

    public Query setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
        return this;
    }

    public Query setNoVirtualColumn(boolean noVirtualColumn) {
        this.noVirtualColumn = noVirtualColumn;
        return this;
    }

    public Query setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
        return this;
    }

    public Query addJoinClause(String joinClause) {
        this.joinClauseList.add(joinClause);
        return this;
    }

    public void addTableDirectJoin(String foreignTableName) {
        String foreignId = foreignTableName + "_ID";
        this.addJoinClause("INNER JOIN " + foreignTableName + " ON (" + this.table.getTableName() + "." + foreignId + "=" + foreignTableName + "." + foreignId + ")");
    }

    public <T extends PO> List<T> list() throws DBException {
        ArrayList<PO> list = new ArrayList<PO>();
        String sql = this.buildSQL(null, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                while (rs.next()) {
                    PO po = this.table.getPO(rs, this.trxName);
                    list.add(po);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return list;
    }

    public <T extends PO> T first() throws DBException {
        PO po = null;
        int oldPageSize = this.pageSize;
        if (DB.getDatabase().isPagingSupported()) {
            this.setPageSize(1);
        }
        String sql = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                sql = this.buildSQL(null, true);
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                if (rs.next()) {
                    po = this.table.getPO(rs, this.trxName);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            this.setPageSize(oldPageSize);
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.setPageSize(oldPageSize);
        return (T)po;
    }

    public <T extends PO> T firstOnly() throws DBException {
        PO po = null;
        int oldPageSize = this.pageSize;
        if (DB.getDatabase().isPagingSupported()) {
            this.setPageSize(2);
        }
        String sql = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                sql = this.buildSQL(null, true);
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                if (rs.next()) {
                    po = this.table.getPO(rs, this.trxName);
                }
                if (rs.next()) {
                    throw new DBException(Msg.getMsg(Env.getCtx(), "QueryMoreThanOneRecordsFound"));
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            this.setPageSize(oldPageSize);
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.setPageSize(oldPageSize);
        return (T)po;
    }

    public int firstId() throws DBException {
        return this.firstId(false);
    }

    public int firstIdOnly() throws DBException {
        return this.firstId(true);
    }

    private int firstId(boolean assumeOnlyOneResult) throws DBException {
        String[] keys = this.table.getKeyColumns();
        if (keys.length != 1) {
            throw new DBException("Table " + String.valueOf(this.table) + " has 0 or more than 1 key columns");
        }
        StringBuilder selectClause = new StringBuilder("SELECT ");
        if (!this.joinClauseList.isEmpty()) {
            selectClause.append(this.table.getTableName()).append(".");
        }
        selectClause.append(keys[0]);
        selectClause.append(" FROM ").append(this.table.getTableName());
        int oldPageSize = this.pageSize;
        if (DB.getDatabase().isPagingSupported()) {
            this.setPageSize(assumeOnlyOneResult ? 2 : 1);
        }
        String sql = null;
        int id = -1;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                sql = this.buildSQL(selectClause, true);
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                if (rs.next()) {
                    id = rs.getInt(1);
                }
                if (assumeOnlyOneResult && rs.next()) {
                    throw new DBException(Msg.getMsg(Env.getCtx(), "QueryMoreThanOneRecordsFound"));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            this.setPageSize(oldPageSize);
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.setPageSize(oldPageSize);
        return id;
    }

    public String getSQL() throws DBException {
        return this.buildSQL(null, true);
    }

    public BigDecimal aggregate(String sqlExpression, String sqlFunction) throws DBException {
        return this.aggregate(sqlExpression, sqlFunction, BigDecimal.class);
    }

    public <T> T aggregate(String sqlExpression, String sqlFunction, Class<T> returnType) throws DBException {
        if (Util.isEmpty(sqlFunction, true)) {
            throw new DBException("No Aggregate Function defined");
        }
        if (Util.isEmpty(sqlExpression, true)) {
            if (AGGREGATE_COUNT == sqlFunction) {
                sqlExpression = "*";
            } else {
                throw new DBException("No Expression defined");
            }
        }
        StringBuilder sqlSelect = new StringBuilder("SELECT ").append(sqlFunction).append("(").append(sqlExpression).append(")").append(" FROM ").append(this.table.getTableName());
        Object value = null;
        Comparable<BigDecimal> defaultValue = null;
        String sql = this.buildSQL(sqlSelect, false);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                if (rs.next()) {
                    if (returnType.isAssignableFrom(BigDecimal.class)) {
                        value = rs.getBigDecimal(1);
                        defaultValue = Env.ZERO;
                    } else if (returnType.isAssignableFrom(Double.class)) {
                        value = rs.getDouble(1);
                        defaultValue = 0.0;
                    } else if (returnType.isAssignableFrom(Integer.class)) {
                        value = rs.getInt(1);
                        defaultValue = 0;
                    } else if (returnType.isAssignableFrom(Timestamp.class)) {
                        value = rs.getTimestamp(1);
                    } else if (returnType.isAssignableFrom(Boolean.class)) {
                        value = "Y".equals(rs.getString(1));
                        defaultValue = Boolean.FALSE;
                    } else {
                        value = rs.getObject(1);
                    }
                }
                if (rs.next()) {
                    throw new DBException(Msg.getMsg(Env.getCtx(), "QueryMoreThanOneRecordsFound"));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (value == null) {
            value = defaultValue;
        }
        return (T)value;
    }

    public int count() throws DBException {
        return this.aggregate("*", AGGREGATE_COUNT).intValue();
    }

    public BigDecimal sum(String sqlExpression) {
        return this.aggregate(sqlExpression, AGGREGATE_SUM);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean match() throws DBException {
        ResultSet rs;
        CPreparedStatement pstmt;
        block4: {
            String sql = this.buildSQL(new StringBuilder("SELECT 1 FROM ").append(this.table.getTableName()), false);
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                if (!rs.next()) break block4;
            }
            catch (SQLException e) {
                try {
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            return true;
        }
        DB.close(rs, pstmt);
        return false;
    }

    public <T extends PO> Stream<T> stream() throws DBException {
        final String sql = this.buildSQL(null, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            CPreparedStatement finalPstmt = pstmt = DB.prepareStatement(sql, this.trxName);
            final ResultSet finalRS = rs = this.createResultSet(pstmt);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

                @Override
                public boolean tryAdvance(Consumer<? super T> action) {
                    block3: {
                        try {
                            if (finalRS.next()) break block3;
                            return false;
                        }
                        catch (SQLException ex) {
                            log.log(Level.SEVERE, sql, ex);
                            throw new DBException(ex, sql);
                        }
                    }
                    PO newRec = Query.this.table.getPO(finalRS, Query.this.trxName);
                    action.accept(newRec);
                    return true;
                }
            }, false).onClose(() -> DB.close(finalRS, finalPstmt));
        }
        catch (SQLException e) {
            DB.close(rs, pstmt);
            log.log(Level.SEVERE, sql, e);
            throw new DBException(e, sql);
        }
    }

    public <T extends PO> Iterator<T> iterate() throws DBException {
        String[] keys = this.table.getKeyColumns();
        StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
        int i2 = 0;
        while (i2 < keys.length) {
            if (i2 > 0) {
                sqlBuffer.append(", ");
            }
            if (!this.joinClauseList.isEmpty()) {
                sqlBuffer.append(this.table.getTableName()).append(".");
            }
            sqlBuffer.append(keys[i2]);
            ++i2;
        }
        sqlBuffer.append(" FROM ").append(this.table.getTableName());
        String sql = this.buildSQL(sqlBuffer, true);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<Object[]> idList = new ArrayList<Object[]>();
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                while (rs.next()) {
                    Object[] ids = new Object[keys.length];
                    int i3 = 0;
                    while (i3 < ids.length) {
                        ids[i3] = rs.getObject(i3 + 1);
                        ++i3;
                    }
                    idList.add(ids);
                }
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return new POIterator(this.table, idList, this.trxName);
    }

    public <T extends PO> POResultSet<T> scroll() throws DBException {
        POResultSet pOResultSet;
        block5: {
            String sql = this.buildSQL(null, true);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            POResultSet rsPO = null;
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                rsPO = new POResultSet(this.table, pstmt, rs, this.trxName);
                rsPO.setCloseOnError(true);
                pOResultSet = rsPO;
                if (rsPO != null) break block5;
            }
            catch (SQLException e) {
                try {
                    log.log(Level.SEVERE, sql, e);
                    throw new DBException(e, sql);
                }
                catch (Throwable throwable) {
                    if (rsPO == null) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                    }
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return pOResultSet;
    }

    private final String buildSQL(StringBuilder selectClause, boolean useOrderByClause) {
        if (selectClause == null) {
            POInfo info = POInfo.getPOInfo(this.ctx, this.table.getAD_Table_ID(), this.trxName);
            if (info == null) {
                throw new IllegalStateException("No POInfo found for AD_Table_ID=" + this.table.getAD_Table_ID());
            }
            boolean isFullyQualified = !this.joinClauseList.isEmpty();
            selectClause = this.virtualColumns == null ? info.buildSelect(isFullyQualified, this.noVirtualColumn) : info.buildSelect(isFullyQualified, this.virtualColumns);
        }
        if (!this.joinClauseList.isEmpty()) {
            for (String joinClause : this.joinClauseList) {
                selectClause.append(" ").append(joinClause);
            }
        }
        StringBuilder whereBuffer = new StringBuilder();
        if (!Util.isEmpty(this.whereClause, true)) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append("(").append(this.whereClause).append(")");
        }
        if (this.onlyActiveRecords) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            if (!this.joinClauseList.isEmpty()) {
                whereBuffer.append(this.table.getTableName()).append(".");
            }
            whereBuffer.append("IsActive=?");
        }
        if (this.onlyClient_ID) {
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            if (!this.joinClauseList.isEmpty()) {
                whereBuffer.append(this.table.getTableName()).append(".");
            }
            whereBuffer.append("AD_Client_ID=?");
        }
        if (this.onlySelection_ID > 0) {
            String[] keys = this.table.getKeyColumns();
            if (keys.length != 1) {
                throw new DBException("Table " + String.valueOf(this.table) + " has 0 or more than 1 key columns");
            }
            if (whereBuffer.length() > 0) {
                whereBuffer.append(" AND ");
            }
            whereBuffer.append(" EXISTS (SELECT 1 FROM T_Selection s WHERE s.AD_PInstance_ID=? AND s.");
            if (this.table.isUUIDKeyTable()) {
                whereBuffer.append("T_Selection_UU=");
            } else {
                whereBuffer.append("T_Selection_ID=");
            }
            whereBuffer.append(this.table.getTableName()).append(".").append(keys[0]).append(")");
        }
        StringBuilder sqlBuffer = new StringBuilder(selectClause);
        if (whereBuffer.length() > 0) {
            sqlBuffer.append(" WHERE ").append((CharSequence)whereBuffer);
        }
        if (useOrderByClause && !Util.isEmpty(this.orderBy, true)) {
            sqlBuffer.append(" ORDER BY ").append(this.orderBy);
        }
        Object sql = sqlBuffer.toString();
        if (this.applyAccessFilter) {
            MRole role = MRole.getDefault(this.ctx, false);
            sql = role.addAccessSQL((String)sql, this.table.getTableName(), this.applyAccessFilterFullyQualified, this.applyAccessFilterRW);
        }
        if (this.forUpdate) {
            sql = (String)sql + " FOR UPDATE";
            if (DB.isPostgreSQL()) {
                sql = (String)sql + " OF " + this.table.getTableName();
            }
        }
        if (this.pageSize > 0 || this.recordsToSkip > 0) {
            sql = this.appendPagination((String)sql);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("TableName = " + this.table.getTableName() + "... SQL = " + (String)sql);
        }
        return sql;
    }

    public Query setPageSize(int pPageSize) {
        this.pageSize = pPageSize;
        return this;
    }

    public Query setPage(int pPageSize, int pPagesToSkip) {
        if (pPageSize > 0) {
            this.pageSize = pPageSize;
            this.recordsToSkip = pPagesToSkip * this.pageSize;
        } else {
            log.warning("Wrong PageSize <= 0");
        }
        return this;
    }

    public Query setRecordstoSkip(int pRecordsToSkip) {
        this.recordsToSkip = pRecordsToSkip;
        return this;
    }

    private String appendPagination(String pQuery) {
        String query = pQuery;
        if (this.pageSize > 0 || this.recordsToSkip > 0) {
            if (DB.getDatabase().isPagingSupported()) {
                query = DB.getDatabase().addPagingSQL(query, this.recordsToSkip + 1, this.pageSize <= 0 ? 0 : this.recordsToSkip + this.pageSize);
            } else {
                throw new IllegalArgumentException("Pagination not supported by database");
            }
        }
        return query;
    }

    private final ResultSet createResultSet(PreparedStatement pstmt) throws SQLException {
        DB.setParameters(pstmt, this.parameters);
        int i2 = 1 + (this.parameters != null ? this.parameters.length : 0);
        if (this.onlyActiveRecords) {
            DB.setParameter(pstmt, i2++, true);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Parameter IsActive = Y");
            }
        }
        if (this.onlyClient_ID) {
            int AD_Client_ID = Env.getAD_Client_ID(this.ctx);
            DB.setParameter(pstmt, i2++, AD_Client_ID);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Parameter AD_Client_ID = " + AD_Client_ID);
            }
        }
        if (this.onlySelection_ID > 0) {
            DB.setParameter(pstmt, i2++, this.onlySelection_ID);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Parameter Selection AD_PInstance_ID = " + this.onlySelection_ID);
            }
        }
        if (this.queryTimeout > 0) {
            pstmt.setQueryTimeout(this.queryTimeout);
        }
        return pstmt.executeQuery();
    }

    public int[] getIDs() {
        String[] keys = this.table.getKeyColumns();
        if (keys.length != 1) {
            throw new DBException("Table " + String.valueOf(this.table) + " has 0 or more than 1 key columns");
        }
        StringBuilder selectClause = new StringBuilder("SELECT ");
        if (!this.joinClauseList.isEmpty()) {
            selectClause.append(this.table.getTableName()).append(".");
        }
        selectClause.append(keys[0]);
        selectClause.append(" FROM ").append(this.table.getTableName());
        String sql = this.buildSQL(selectClause, true);
        ArrayList<Integer> list = new ArrayList<Integer>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.trxName);
                rs = this.createResultSet(pstmt);
                while (rs.next()) {
                    list.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = list.stream().mapToInt(Integer::intValue).toArray();
        return retValue;
    }

    public Query setVirtualColumns(String ... virtualColumns) {
        this.virtualColumns = virtualColumns;
        return this;
    }
}

