/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MAssetGroup;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciation;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.X_I_FixedAsset;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MIFixedAsset
extends X_I_FixedAsset {
    private static final long serialVersionUID = -6394518107160329652L;
    private static final String s_defaultDepreciationType = "SL";
    private int m_M_Product_Category_ID = 0;
    private int m_A_Asset_Group_ID = 0;
    private MProduct m_product = null;

    public MIFixedAsset(Properties ctx, String I_FixedAsset_UU, String trxName) {
        super(ctx, I_FixedAsset_UU, trxName);
    }

    public MIFixedAsset(Properties ctx, int I_FixedAsset_ID, String trxName) {
        super(ctx, I_FixedAsset_ID, trxName);
    }

    public MIFixedAsset(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProduct getCreateProduct() {
        Object sql;
        Properties ctx = this.getCtx();
        String trxName = this.get_TrxName();
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID <= 0) {
            StringBuilder whereClause = new StringBuilder();
            String key = this.getProductValue();
            if (key == null || key.trim().length() == 0) {
                key = this.getName();
                whereClause.append("UPPER(Name)=");
            } else {
                whereClause.append("UPPER(Value)=");
            }
            if (key == null || key.trim().length() == 0) {
                throw new FillMandatoryException("ProductValue", "Name");
            }
            key = key.toUpperCase();
            whereClause.append(DB.TO_STRING(key));
            whereClause.append(" AND AD_Client_ID=").append(this.getAD_Client_ID());
            sql = "SELECT M_Product_ID FROM M_Product WHERE " + whereClause.toString();
            M_Product_ID = DB.getSQLValueEx(trxName, (String)sql, new Object[0]);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("M_Product_ID=" + M_Product_ID + " -- sql=" + (String)sql);
            }
        }
        MProduct prod = null;
        if (M_Product_ID <= 0) {
            prod = new MProduct(ctx, 0, trxName);
            prod.setName(this.getName());
            String value = this.getProductValue();
            if (value != null && value.trim().length() > 0) {
                prod.setValue(value);
            }
            prod.setM_Product_Category_ID(this.m_M_Product_Category_ID);
            if (this.getC_UOM_ID() > 0) {
                prod.setC_UOM_ID(this.getC_UOM_ID());
            } else {
                prod.setC_UOM_ID(MUOM.getDefault_UOM_ID(ctx));
            }
            sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE AD_Client_ID IN (0,?) ORDER BY IsDefault DESC, AD_Client_ID DESC, C_TaxCategory_ID";
            int C_TaxCategory_ID = DB.getSQLValueEx(null, (String)sql, Env.getAD_Client_ID(ctx));
            prod.setC_TaxCategory_ID(C_TaxCategory_ID);
            prod.saveEx(trxName);
        } else {
            prod = new MProduct(ctx, M_Product_ID, trxName);
        }
        this.setProduct(prod);
        return prod;
    }

    private void fixAmount(int idx) {
        BigDecimal amt = (BigDecimal)this.get_Value(idx);
        if (amt == null) {
            return;
        }
        int precision = this.getStdPrecision();
        BigDecimal newAmt = amt.setScale(this.getStdPrecision(), RoundingMode.HALF_UP);
        this.set_Value(idx, (Object)newAmt);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.getInventoryNo() + ": " + this.get_ColumnName(idx) + "=" + String.valueOf(amt) + "->" + String.valueOf(newAmt) + " (precision=" + precision + ")");
        }
    }

    private void fixKeyValue(int idx) {
        String name = (String)this.get_Value(idx);
        if (name == null) {
            return;
        }
        String newName = name.trim().replaceAll("[ ]+", " ");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.getInventoryNo() + ": " + this.get_ColumnName(idx) + "=[" + name + "]->[" + newName + "]");
        }
        this.set_Value(idx, (Object)newName);
    }

    @Deprecated
    public void process() {
        if (this.isProcessed()) {
            return;
        }
        try {
            if (this.getUseLifeMonths() <= 0) {
                throw new FillMandatoryException(new String[]{"UseLifeMonths"});
            }
            int col_count = this.get_ColumnCount();
            int idx = 0;
            while (idx < col_count) {
                int dt = this.get_ColumnDisplayType(idx);
                if (12 == dt) {
                    this.fixAmount(idx);
                } else if (DisplayType.isText(dt)) {
                    this.fixKeyValue(idx);
                }
                ++idx;
            }
            MProduct product = this.getCreateProduct();
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("product=" + String.valueOf(product));
            }
            if (this.getM_Product_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"M_Product_ID"});
            }
            int A_Asset_Group_ID = this.getA_Asset_Group_ID();
            if (A_Asset_Group_ID <= 0) {
                A_Asset_Group_ID = this.m_A_Asset_Group_ID > 0 ? this.m_A_Asset_Group_ID : product.getA_Asset_Group_ID();
            }
            if (A_Asset_Group_ID <= 0) {
                throw new FillMandatoryException(new String[]{"A_Asset_Group_ID"});
            }
            this.setA_Asset_Group_ID(A_Asset_Group_ID);
            if (this.getA_Remaining_Period() == 0) {
                this.setDateAcct(this.getAssetDepreciationDate());
            } else {
                Timestamp dateAcct = this.getDateAcct();
                if (dateAcct == null) {
                    dateAcct = Env.getContextAsDate(this.getCtx(), "#Date");
                    this.setDateAcct(dateAcct);
                }
            }
            if (this.getDateAcct() == null) {
                throw new FillMandatoryException(new String[]{"DateAcct"});
            }
            this.setProcessed(true);
            this.setI_ErrorMsg(null);
            this.saveEx();
        }
        catch (Exception e) {
            this.setError(e.getLocalizedMessage());
            this.saveEx();
        }
    }

    public boolean isFullyDepreciated() {
        BigDecimal cost = this.getA_Asset_Cost();
        BigDecimal depr_c = this.getA_Accumulated_Depr();
        BigDecimal depr_f = this.getA_Accumulated_Depr_F();
        return cost.compareTo(depr_c) == 0 && cost.compareTo(depr_f) == 0;
    }

    public boolean isDepreciating() {
        MAssetGroup assetGroup = MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
        if (assetGroup == null) {
            return false;
        }
        return assetGroup.isDepreciated();
    }

    public int getA_Last_Period() {
        int life_f;
        int life = this.getUseLifeMonths();
        return life > (life_f = this.getUseLifeMonths_F()) ? life : life_f;
    }

    public void setDefault_Product_Category_ID(int M_Product_Category_ID) {
        this.m_M_Product_Category_ID = M_Product_Category_ID;
    }

    public void setDefault_Asset_Group_ID(int A_Asset_Group_ID) {
        this.m_A_Asset_Group_ID = A_Asset_Group_ID;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        this.setM_Product_ID(product.get_ID());
        this.setProductValue(product.getValue());
        if (Util.isEmpty(this.getName())) {
            this.setName(product.getName());
        }
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() > 0) {
            this.m_product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return this.m_product;
    }

    public int getA_Depreciation_ID() {
        MDepreciation depr = MDepreciation.get(this.getCtx(), s_defaultDepreciationType);
        return depr != null ? depr.get_ID() : 0;
    }

    public int getA_Depreciation_F_ID() {
        return this.getA_Depreciation_ID();
    }

    public int getStdPrecision() {
        return MClient.get(this.getCtx()).getAcctSchema().getStdPrecision();
    }

    public String getSummary() {
        return this.getInventoryNo() + " - " + this.getName();
    }

    public void setError(String msg) {
        String msg_trl = Msg.parseTranslation(this.getCtx(), msg);
        this.setI_ErrorMsg(msg_trl);
    }
}

