/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_M_Attribute;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutablePOSupport;

public class MAttribute
extends X_M_Attribute
implements ImmutablePOSupport {
    private static final long serialVersionUID = 8266487405778526776L;
    private static CLogger s_log = CLogger.getCLogger(MAttribute.class);
    private static CCache<Integer, MAttribute> s_cache = new CCache("M_Attribute", 30, CCache.DEFAULT_EXPIRE_MINUTE);
    private MAttributeValue[] m_values = null;

    public static MAttribute[] getOfClient(Properties ctx, boolean onlyProductAttributes, boolean onlyListAttributes) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        Object sql = "";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(AD_Client_ID);
        if (onlyProductAttributes) {
            sql = (String)sql + " AND IsInstanceAttribute=?";
            params.add(false);
        }
        if (onlyListAttributes) {
            sql = (String)sql + " AND AttributeValueType=?";
            params.add("L");
        }
        StringBuilder whereClause = new StringBuilder("AD_Client_ID=?").append((String)sql);
        List<MAttribute> list = new Query(ctx, "M_Attribute", whereClause.toString(), null).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Name").list();
        MAttribute[] retValue = new MAttribute[list.size()];
        list.toArray(retValue);
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("AD_Client_ID=" + AD_Client_ID + " - #" + list.size());
        }
        return retValue;
    }

    public MAttribute(Properties ctx, String M_Attribute_UU, String trxName) {
        super(ctx, M_Attribute_UU, trxName);
        if (Util.isEmpty(M_Attribute_UU)) {
            this.setInitialDefaults();
        }
    }

    public MAttribute(Properties ctx, int M_Attribute_ID, String trxName) {
        super(ctx, M_Attribute_ID, trxName);
        if (M_Attribute_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setAttributeValueType("S");
        this.setIsInstanceAttribute(false);
        this.setIsMandatory(false);
    }

    public MAttribute(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttribute(MAttribute copy) {
        this(Env.getCtx(), copy);
    }

    public MAttribute(Properties ctx, MAttribute copy) {
        this(ctx, copy, null);
    }

    public MAttribute(Properties ctx, MAttribute copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_values = copy.m_values != null ? (MAttributeValue[])Arrays.stream(copy.m_values).map(e -> new MAttributeValue(ctx, (MAttributeValue)e, trxName)).toArray(MAttributeValue[]::new) : null;
    }

    public MAttribute(Properties ctx, int M_Attribute_ID, String trxName, String ... virtualColumns) {
        super(ctx, M_Attribute_ID, trxName, virtualColumns);
    }

    public MAttributeValue[] getMAttributeValues() {
        if (this.m_values == null && "L".equals(this.getAttributeValueType())) {
            List<Object> list = new ArrayList<Object>();
            if (!this.isMandatory()) {
                list.add(null);
            }
            list = new Query(this.getCtx(), "M_AttributeValue", "M_Attribute_ID=?", this.get_TrxName()).setParameters(this.getM_Attribute_ID()).setOrderBy("Value").list();
            this.m_values = new MAttributeValue[list.size()];
            list.toArray(this.m_values);
        }
        return this.m_values;
    }

    public static MAttribute get(Properties ctx, int M_Attribute_ID) {
        Integer key = M_Attribute_ID;
        MAttribute retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = (MAttribute)MTable.get(ctx, 562).getPO(M_Attribute_ID, null);
        s_cache.put(key, retValue);
        return retValue;
    }

    public MAttributeInstance getMAttributeInstance(int M_AttributeSetInstance_ID) {
        MAttributeInstance retValue = (MAttributeInstance)new Query(this.getCtx(), "M_AttributeInstance", "M_Attribute_ID=? AND M_AttributeSetInstance_ID=?", this.get_TrxName()).setParameters(this.getM_Attribute_ID(), M_AttributeSetInstance_ID).first();
        return retValue;
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, MAttributeValue value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = value != null ? new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value.getM_AttributeValue_ID(), value.getName(), this.get_TrxName()) : new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, 0, null, this.get_TrxName());
        } else if (value != null) {
            instance.setM_AttributeValue_ID(value.getM_AttributeValue_ID());
            instance.setValue(value.getName());
        } else {
            instance.setM_AttributeValue_ID(0);
            instance.setValue(null);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, String value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValue(value);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, BigDecimal value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValueNumber(value);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, int value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValueInt(value);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, KeyNamePair value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValueKeyNamePair(value);
        }
        instance.saveEx();
    }

    public void setMAttributeInstance(int M_AttributeSetInstance_ID, Timestamp value) {
        MAttributeInstance instance = this.getMAttributeInstance(M_AttributeSetInstance_ID);
        if (instance == null) {
            instance = new MAttributeInstance(this.getCtx(), this.getM_Attribute_ID(), M_AttributeSetInstance_ID, value, this.get_TrxName());
        } else {
            instance.setValueDate(value);
        }
        instance.saveEx();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MAttribute[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Type=").append(this.getAttributeValueType()).append(",Instance=").append(this.isInstanceAttribute()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || "R".equals(this.getAttributeValueType())) && !MRole.getDefault().isAccessAdvanced()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ActionNotAllowedHere"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord && this.is_ValueChanged("IsInstanceAttribute") && this.isInstanceAttribute()) {
            StringBuilder sql = new StringBuilder("UPDATE M_AttributeSet mas ").append("SET IsInstanceAttribute='Y' ").append("WHERE IsInstanceAttribute='N'").append(" AND EXISTS (SELECT * FROM M_AttributeUse mau ").append("WHERE mas.M_AttributeSet_ID=mau.M_AttributeSet_ID").append(" AND mau.M_Attribute_ID=").append(this.getM_Attribute_ID()).append(")");
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("AttributeSet Instance set #" + no);
            }
        }
        return success;
    }

    public boolean isAttributeValueTypeReference() {
        return "R".equals(this.getAttributeValueType());
    }

    @Override
    public MAttribute markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

