/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_C_POS;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MPOS
extends X_C_POS
implements ImmutablePOSupport {
    private static final long serialVersionUID = 2499679269059812831L;
    private static ImmutableIntPOCache<Integer, MPOS> s_cache = new ImmutableIntPOCache("C_POS", 20);
    private MBPartner m_template = null;

    public static MPOS get(int C_POS_ID) {
        return MPOS.get(Env.getCtx(), C_POS_ID);
    }

    public static MPOS get(Properties ctx, int C_POS_ID) {
        Integer key = C_POS_ID;
        MPOS retValue = s_cache.get(ctx, key, e -> new MPOS(ctx, (MPOS)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MPOS(ctx, C_POS_ID, null);
        if (retValue.get_ID() == C_POS_ID) {
            s_cache.put(key, retValue, e -> new MPOS(Env.getCtx(), (MPOS)e));
            return retValue;
        }
        return null;
    }

    public static MPOS[] getAll(Properties ctx, String field, int ID) {
        String whereClause = field + "=?";
        List<MPOS> list = new Query(ctx, "C_POS", whereClause, null).setParameters(ID).setOnlyActiveRecords(true).setOrderBy("Name").list();
        return list.toArray(new MPOS[list.size()]);
    }

    public MPOS(Properties ctx, String C_POS_UU, String trxName) {
        super(ctx, C_POS_UU, trxName);
        if (Util.isEmpty(C_POS_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPOS(Properties ctx, int C_POS_ID, String trxName) {
        super(ctx, C_POS_ID, trxName);
        if (C_POS_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsModifyPrice(false);
    }

    public MPOS(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPOS(MPOS copy) {
        this(Env.getCtx(), copy);
    }

    public MPOS(Properties ctx, MPOS copy) {
        this(ctx, copy, null);
    }

    public MPOS(Properties ctx, MPOS copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_template = copy.m_template != null ? new MBPartner(ctx, copy.m_template, trxName) : null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MWarehouse wh;
        MBankAccount cb;
        if ((newRecord || this.is_ValueChanged("C_BankAccount_ID")) && (cb = MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@AD_Org_ID@: @C_BankAccount_ID@"));
            return false;
        }
        if ((newRecord || this.is_ValueChanged("M_Warehouse_ID")) && (wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID(), this.get_TrxName())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@AD_Org_ID@: @M_Warehouse_ID@"));
            return false;
        }
        return true;
    }

    public MBPartner getBPartner() {
        if (this.m_template == null) {
            this.m_template = this.getC_BPartnerCashTrx_ID() == 0 ? MBPartner.getBPartnerCashTrx(this.getCtx(), this.getAD_Client_ID()) : new MBPartner(this.getCtx(), this.getC_BPartnerCashTrx_ID(), this.get_TrxName());
            if (this.is_Immutable() && this.m_template != null) {
                this.m_template.markImmutable();
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("getBPartner - " + String.valueOf(this.m_template));
            }
        }
        return this.m_template;
    }

    @Override
    public MPOS markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_template != null) {
            this.m_template.markImmutable();
        }
        return this;
    }

    @Override
    public String toString() {
        return super.getName();
    }
}

