/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

public class SystemProperties {
    private static final String ADEMPIERE_DB_SYSTEM_USER = "ADEMPIERE_DB_SYSTEM_USER";
    private static final String ADEMPIERE_SECURE = "ADEMPIERE_SECURE";
    private static final String Cache_ExpireMinute = "Cache.ExpireMinute";
    private static final String Cache_MaxSize = "Cache.MaxSize";
    private static final String Cache_MaxSize_Per_Table_Prefix = "Cache.MaxSize.";
    private static final String env_IDEMPIERE_HOME = "env.IDEMPIERE_HOME";
    private static final String IDEMPIERE_HOME = "IDEMPIERE_HOME";
    private static final String IDEMPIERE_SECURE_PROPERTIES = "IDEMPIERE_SECURE_PROPERTIES";
    private static final String LogLevel = "LogLevel";
    private static final String org_adempiere_po_useTimeoutForUpdate = "org.adempiere.po.useTimeoutForUpdate";
    private static final String org_compiere_report_path = "org.compiere.report.path";
    private static final String org_idempiere_db_debug = "org.idempiere.db.debug";
    private static final String org_idempiere_db_debug_convert = "org.idempiere.db.debug.convert";
    private static final String org_idempiere_db_debug_filter = "org.idempiere.db.debug.filter";
    private static final String org_idempiere_FileLogPrefix = "org.idempiere.FileLogPrefix";
    private static final String org_idempiere_FullExceptionTraceInLog = "org.idempiere.FullExceptionTraceInLog";
    private static final String org_idempiere_postgresql_URLParameters = "org.idempiere.postgresql.URLParameters";
    private static final String org_idempiere_po_useOptimisticLocking = "org.idempiere.po.useOptimisticLocking";
    private static final String PostgreSQLNative = "PostgreSQLNative";
    private static final String PropertyFile = "PropertyFile";
    private static final String PropertyHomeFile = "PropertyHomeFile";
    private static final String TestOCI = "TestOCI";
    private static final String TRACE_NULL_TRX_CONNECTION = "TRACE_NULL_TRX_CONNECTION";
    private static final String ZK_THEME = "ZK_THEME";
    private static final String ZkUnitTest = "ZkUnitTest";

    public static String getAdempiereDBSystemUser() {
        return System.getProperty(ADEMPIERE_DB_SYSTEM_USER);
    }

    public static String getAdempiereSecure() {
        return System.getProperty(ADEMPIERE_SECURE);
    }

    public static String getCacheExpireMinute() {
        return System.getProperty(Cache_ExpireMinute);
    }

    public static String getCacheMaxSize() {
        return System.getProperty(Cache_MaxSize);
    }

    public static String getCacheMaxSizeTable(String tableName) {
        return System.getProperty(Cache_MaxSize_Per_Table_Prefix + tableName);
    }

    public static String getEnvIdempiereHome() {
        return System.getProperty(env_IDEMPIERE_HOME);
    }

    public static String getIdempiereHome() {
        return System.getProperty(IDEMPIERE_HOME);
    }

    public static String setIdempiereHome(String idempiereHome) {
        return System.setProperty(IDEMPIERE_HOME, idempiereHome);
    }

    public static boolean isSecureProperties() {
        String secureProps = System.getProperty(IDEMPIERE_SECURE_PROPERTIES);
        return secureProps == null || !secureProps.equals("false");
    }

    public static String getLogLevel() {
        return System.getProperty(LogLevel);
    }

    public static boolean isUseTimeoutForUpdate() {
        return "true".equalsIgnoreCase(System.getProperty(org_adempiere_po_useTimeoutForUpdate, "false"));
    }

    public static String getReportPath() {
        return System.getProperty(org_compiere_report_path);
    }

    public static boolean isDBDebug() {
        return "true".equals(System.getProperty(org_idempiere_db_debug));
    }

    public static String getDBDebugFilter() {
        return System.getProperty(org_idempiere_db_debug_filter);
    }

    public static boolean isDBDebugConvert() {
        return "true".equals(System.getProperty(org_idempiere_db_debug_convert));
    }

    public static String getFileLogPrefix() {
        return System.getProperty(org_idempiere_FileLogPrefix);
    }

    public static String setFileLogPrefix(String fileLogPrefix) {
        return System.setProperty(org_idempiere_FileLogPrefix, fileLogPrefix);
    }

    public static String getPostgresqlURLParameters() {
        return System.getProperty(org_idempiere_postgresql_URLParameters);
    }

    public static boolean isOptimisticLocking() {
        return "true".equalsIgnoreCase(System.getProperty(org_idempiere_po_useOptimisticLocking, "false"));
    }

    public static String getPostgreSQLNative() {
        return System.getProperty(PostgreSQLNative);
    }

    public static String getPropertyFile() {
        return System.getProperty(PropertyFile);
    }

    public static String getPropertyHomeFile() {
        return System.getProperty(PropertyHomeFile);
    }

    public static boolean isTestOCI() {
        return System.getProperty(TestOCI, "N").equals("Y");
    }

    public static String getZkTheme() {
        return System.getProperty(ZK_THEME);
    }

    public static boolean isZkUnitTest() {
        return "true".equals(System.getProperty(ZkUnitTest));
    }

    public static boolean isTraceNullTrxConnection() {
        return "true".equals(System.getProperty(TRACE_NULL_TRX_CONNECTION));
    }

    public static boolean isFullExceptionTraceInLog() {
        return "true".equals(System.getProperty(org_idempiere_FullExceptionTraceInLog));
    }
}

