/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.SchedulingPattern;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.compiere.model.X_AD_Schedule;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MSchedule
extends X_AD_Schedule
implements ImmutablePOSupport {
    private static final long serialVersionUID = 7183417983901074702L;
    private static Pattern VALID_IPV4_PATTERN = null;
    private static Pattern VALID_IPV6_PATTERN = null;
    private static final String ipv4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static final String ipv6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    private static ImmutableIntPOCache<Integer, MSchedule> s_cache = new ImmutableIntPOCache("AD_Schedule", 10);

    public MSchedule(Properties ctx, String AD_Schedule_UU, String trxName) {
        super(ctx, AD_Schedule_UU, trxName);
    }

    public MSchedule(Properties ctx, int AD_Schedule_ID, String trxName) {
        super(ctx, AD_Schedule_ID, trxName);
    }

    public MSchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSchedule(MSchedule copy) {
        this(Env.getCtx(), copy);
    }

    public MSchedule(Properties ctx, MSchedule copy) {
        this(ctx, copy, null);
    }

    public MSchedule(Properties ctx, MSchedule copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String pattern;
        if ("F".equals(this.getScheduleType())) {
            if (this.getFrequencyType() == null) {
                this.setFrequencyType("D");
            }
            if (this.getFrequency() < 1) {
                this.setFrequency(1);
            }
            this.setCronPattern(null);
        } else if ("C".equals(this.getScheduleType()) && (pattern = this.getCronPattern()) != null && pattern.trim().length() > 0 && !SchedulingPattern.validate((String)pattern)) {
            this.log.saveError("Error", "InvalidCronPattern");
            return false;
        }
        return true;
    }

    public boolean isOKtoRunOnIP() {
        if (!this.isActive()) {
            return false;
        }
        String ipOnly = this.getRunOnlyOnIP();
        if (ipOnly == null || ipOnly.length() == 0 || "0.0.0.0".equals(ipOnly)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(ipOnly, ";");
        while (st.hasMoreElements()) {
            String ip = st.nextToken();
            if (!this.checkIP(ip)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIP(String ipOnly) {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    String retVal = inetAddress.getHostAddress().toString();
                    retVal = this.chekIPFormat(ipOnly) ? inetAddress.getHostAddress().toString() : inetAddress.getHostName();
                    if (ipOnly.equals(retVal)) {
                        if (!this.log.isLoggable(Level.INFO)) return true;
                        this.log.info("Allowed here - IP=" + retVal + " match");
                        return true;
                    }
                    if (!this.log.isLoggable(Level.INFO)) continue;
                    this.log.info("Not Allowed here - IP=" + retVal + " does not match " + ipOnly);
                }
            }
            if (this.chekIPFormat(ipOnly)) return false;
            String retVal = InetAddress.getLocalHost().getHostName();
            retVal = InetAddress.getLocalHost().getCanonicalHostName();
            if (ipOnly.equals(retVal)) {
                if (!this.log.isLoggable(Level.INFO)) return true;
                this.log.info("Allowed here - IP=" + retVal + " match");
                return true;
            }
            if (!this.log.isLoggable(Level.INFO)) return false;
            this.log.info("Not Allowed here - IP=" + retVal + " does not match " + ipOnly);
            return false;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return false;
    }

    public static MSchedule get(int AD_Schedule_ID) {
        return MSchedule.get(Env.getCtx(), AD_Schedule_ID);
    }

    public static MSchedule get(Properties ctx, int AD_Schedule_ID) {
        Integer key = AD_Schedule_ID;
        MSchedule retValue = s_cache.get(ctx, key, e -> new MSchedule(ctx, (MSchedule)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MSchedule(ctx, AD_Schedule_ID, null);
        if (retValue.get_ID() == AD_Schedule_ID) {
            s_cache.put(key, retValue, e -> new MSchedule(Env.getCtx(), (MSchedule)e));
            return retValue;
        }
        return null;
    }

    public boolean chekIPFormat(String ipOnly) {
        boolean IsIp;
        block2: {
            IsIp = false;
            try {
                Matcher m2;
                VALID_IPV4_PATTERN = Pattern.compile(ipv4Pattern, 2);
                VALID_IPV6_PATTERN = Pattern.compile(ipv6Pattern, 2);
                Matcher m1 = VALID_IPV4_PATTERN.matcher(ipOnly);
                IsIp = m1.matches() ? true : (m2 = VALID_IPV6_PATTERN.matcher(ipOnly)).matches();
            }
            catch (PatternSyntaxException e) {
                if (!this.log.isLoggable(Level.FINE)) break block2;
                this.log.fine("Error: " + e.getLocalizedMessage());
            }
        }
        return IsIp;
    }

    @Deprecated
    public static long getNextRunMS(long last, String scheduleType, String frequencyType, int frequency, String cronPattern) {
        return MSchedule.getNextRunMS(last, scheduleType, frequencyType, frequency, cronPattern, null);
    }

    public static long getNextRunMS(long last, String scheduleType, String frequencyType, int frequency, String cronPattern, String timeZone) {
        long now = System.currentTimeMillis();
        if ("F".equals(scheduleType)) {
            if (frequency < 1) {
                frequency = 1;
            }
            long typeSec = 600L;
            if (frequencyType == null) {
                typeSec = 300L;
            } else if ("M".equals(frequencyType)) {
                typeSec = 60L;
            } else if ("H".equals(frequencyType)) {
                typeSec = 3600L;
            } else if ("D".equals(frequencyType)) {
                typeSec = 86400L;
            }
            long sleepInterval = typeSec * 1000L * (long)frequency;
            long next = last + sleepInterval;
            while (next < now) {
                next += sleepInterval;
            }
            return next;
        }
        if ("C".equals(scheduleType) && cronPattern != null && cronPattern.trim().length() > 0 && SchedulingPattern.validate((String)cronPattern)) {
            TimeZone tz = null;
            if (!Util.isEmpty(timeZone) && (tz = TimeZone.getTimeZone(timeZone)) != null && !tz.getID().equals(timeZone)) {
                tz = null;
            }
            Predictor predictor = new Predictor(cronPattern, last);
            if (tz != null) {
                predictor.setTimeZone(tz);
            }
            long next = predictor.nextMatchingTime();
            while (next < now) {
                predictor = new Predictor(cronPattern, next);
                if (tz != null) {
                    predictor.setTimeZone(tz);
                }
                next = predictor.nextMatchingTime();
            }
            return next;
        }
        return 0L;
    }

    @Override
    public MSchedule markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

