/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.compiere.model.MAlertRecipient;
import org.compiere.model.MAlertRule;
import org.compiere.model.MUserRoles;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Alert;
import org.compiere.util.Util;

public class MAlert
extends X_AD_Alert {
    private static final long serialVersionUID = -5684705878618526801L;
    private MAlertRule[] m_rules = null;
    private MAlertRecipient[] m_recipients = null;

    public MAlert(Properties ctx, String AD_Alert_UU, String trxName) {
        super(ctx, AD_Alert_UU, trxName);
        if (Util.isEmpty(AD_Alert_UU)) {
            this.setInitialDefaults();
        }
    }

    public MAlert(Properties ctx, int AD_Alert_ID, String trxName) {
        super(ctx, AD_Alert_ID, trxName);
        if (AD_Alert_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setEnforceClientSecurity(true);
        this.setEnforceRoleSecurity(true);
        this.setIsValid(true);
    }

    public MAlert(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAlertRule[] getRules(boolean reload) {
        if (this.m_rules != null && !reload) {
            return this.m_rules;
        }
        List<MAlertRule> list = new Query(this.getCtx(), "AD_AlertRule", "AD_Alert_ID=?", null).setParameters(this.getAD_Alert_ID()).setOrderBy("Name, AD_AlertRule_ID").setOnlyActiveRecords(true).list();
        int i = 0;
        while (i < list.size()) {
            MAlertRule rule = (MAlertRule)list.get(i);
            rule.setParent(this);
            ++i;
        }
        this.m_rules = new MAlertRule[list.size()];
        this.m_rules = list.toArray(this.m_rules);
        return this.m_rules;
    }

    public MAlertRecipient[] getRecipients(boolean reload) {
        if (this.m_recipients != null && !reload) {
            return this.m_recipients;
        }
        List<MAlertRecipient> list = new Query(this.getCtx(), "AD_AlertRecipient", "AD_Alert_ID=?", null).setParameters(this.getAD_Alert_ID()).setOnlyActiveRecords(true).list();
        this.m_recipients = new MAlertRecipient[list.size()];
        this.m_recipients = list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public int getFirstAD_Role_ID() {
        this.getRecipients(false);
        int i = 0;
        while (i < this.m_recipients.length) {
            if (this.m_recipients[i].getAD_Role_ID() != -1) {
                return this.m_recipients[i].getAD_Role_ID();
            }
            ++i;
        }
        return -1;
    }

    public int getFirstUserAD_Role_ID() {
        this.getRecipients(false);
        int AD_User_ID = this.getFirstAD_User_ID();
        if (AD_User_ID != -1) {
            MUserRoles[] urs = MUserRoles.getOfUser(this.getCtx(), AD_User_ID);
            int i = 0;
            while (i < urs.length) {
                if (urs[i].isActive()) {
                    return urs[i].getAD_Role_ID();
                }
                ++i;
            }
        }
        return -1;
    }

    public int getFirstAD_User_ID() {
        this.getRecipients(false);
        int i = 0;
        while (i < this.m_recipients.length) {
            if (this.m_recipients[i].getAD_User_ID() != -1) {
                return this.m_recipients[i].getAD_User_ID();
            }
            ++i;
        }
        return -1;
    }

    public Collection<Integer> getRecipientUsers() {
        MAlertRecipient[] recipients = this.getRecipients(false);
        TreeSet<Integer> users = new TreeSet<Integer>();
        int i = 0;
        while (i < recipients.length) {
            MAlertRecipient recipient = recipients[i];
            if (recipient.getAD_User_ID() >= 0) {
                users.add(recipient.getAD_User_ID());
            }
            if (recipient.getAD_Role_ID() >= 0) {
                MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), recipient.getAD_Role_ID());
                int j = 0;
                while (j < urs.length) {
                    MUserRoles ur = urs[j];
                    if (ur.isActive()) {
                        users.add(ur.getAD_User_ID());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return users;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MAlert[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Valid=").append(this.isValid());
        if (this.m_rules != null) {
            sb.append(",Rules=").append(this.m_rules.length);
        }
        if (this.m_recipients != null) {
            sb.append(",Recipients=").append(this.m_recipients.length);
        }
        sb.append("]");
        return sb.toString();
    }
}

