/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.model.X_AD_EntityType;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MEntityType
extends X_AD_EntityType
implements ImmutablePOSupport {
    private static final long serialVersionUID = -7160389442572466581L;
    private static ImmutablePOCache<String, MEntityType> s_cache = new ImmutablePOCache("AD_EntityType", 20);
    private static CLogger s_log = CLogger.getCLogger(MEntityType.class);
    private static final int s_maxAD_EntityType_ID = 1000000;

    public static MEntityType get(String entityType) {
        return MEntityType.get(Env.getCtx(), entityType);
    }

    public static MEntityType get(Properties ctx, String entityType) {
        MEntityType retValue = s_cache.get(ctx, entityType, e -> new MEntityType(ctx, (MEntityType)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = (MEntityType)new Query(ctx, "AD_EntityType", "EntityType=?", null).setParameters(entityType).firstOnly();
        if (retValue != null) {
            s_cache.put(entityType, retValue, e -> new MEntityType(Env.getCtx(), (MEntityType)e));
        }
        return retValue;
    }

    public MEntityType(Properties ctx, String AD_EntityType_UU, String trxName) {
        super(ctx, AD_EntityType_UU, trxName);
    }

    public MEntityType(Properties ctx, int AD_EntityType_ID, String trxName) {
        super(ctx, AD_EntityType_ID, trxName);
    }

    public MEntityType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MEntityType(MEntityType copy) {
        this(Env.getCtx(), copy);
    }

    public MEntityType(Properties ctx, MEntityType copy) {
        this(ctx, copy, null);
    }

    public MEntityType(Properties ctx, MEntityType copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public boolean isSystemMaintained() {
        int id = this.getAD_EntityType_ID();
        return id < 1000000;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord) {
            boolean systemMaintained;
            int id = this.getAD_EntityType_ID();
            boolean bl = systemMaintained = id == 10 || id == 20;
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify a System maintained entity");
                return false;
            }
            systemMaintained = this.is_ValueChanged("EntityType");
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify EntityType");
                return false;
            }
            boolean bl2 = systemMaintained = this.isSystemMaintained() && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("IsActive"));
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify Name,Description,Help");
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isSystemMaintained()) {
            this.log.saveError("Error", "You cannot delete a System maintained entity");
            return false;
        }
        return true;
    }

    @Override
    public MEntityType markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

