/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.GridTab;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartner;
import org.compiere.model.MChangeRequest;
import org.compiere.model.MGroup;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRefList;
import org.compiere.model.MRequestAction;
import org.compiere.model.MRequestCategory;
import org.compiere.model.MRequestType;
import org.compiere.model.MRequestUpdate;
import org.compiere.model.MResolution;
import org.compiere.model.MStatus;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_R_Request;
import org.compiere.model.X_R_Status;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MRequest
extends X_R_Request {
    private static final long serialVersionUID = -3807801381988066060L;
    private static CLogger s_log = CLogger.getCLogger(MRequest.class);
    private static final String TAG_START = "[Req#";
    private static final String TAG_END = "#ID]";
    private MRequestType m_requestType = null;
    private boolean m_changed = false;
    private MBPartner m_partner = null;
    private MUser m_user = null;
    public static final String SEPARATOR = "\n---------.----------.----------.----------.----------.----------\n";

    public static int getR_Request_ID(String mailText) {
        if (mailText == null) {
            return 0;
        }
        int indexStart = mailText.indexOf(TAG_START);
        if (indexStart == -1) {
            return 0;
        }
        int indexEnd = mailText.indexOf(TAG_END, indexStart);
        if (indexEnd == -1) {
            return 0;
        }
        String idString = mailText.substring(indexStart += 5, indexEnd);
        int R_Request_ID = 0;
        try {
            R_Request_ID = Integer.parseInt(idString);
        }
        catch (Exception exception) {
            s_log.severe("Cannot parse " + idString);
        }
        return R_Request_ID;
    }

    public MRequest(Properties ctx, String R_Request_UU, String trxName) {
        super(ctx, R_Request_UU, trxName);
        if (Util.isEmpty(R_Request_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRequest(Properties ctx, int R_Request_ID, String trxName) {
        this(ctx, R_Request_ID, trxName, null);
    }

    public MRequest(Properties ctx, int R_Request_ID, String trxName, String ... virtualColumns) {
        super(ctx, R_Request_ID, trxName, virtualColumns);
        if (R_Request_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setDueType("5");
        this.setConfidentialType("A");
        this.setConfidentialTypeEntry("A");
        this.setProcessed(false);
        this.setRequestAmt(Env.ZERO);
        this.setPriorityUser("7");
        this.setIsEscalated(false);
        this.setIsSelfService(false);
        this.setIsInvoiced(false);
    }

    public MRequest(Properties ctx, int SalesRep_ID, int R_RequestType_ID, String Summary, boolean isSelfService, String trxName) {
        this(ctx, 0, trxName);
        String ct;
        this.set_Value("SalesRep_ID", (Object)SalesRep_ID);
        this.set_Value("R_RequestType_ID", (Object)R_RequestType_ID);
        this.setSummary(Summary);
        this.setIsSelfService(isSelfService);
        this.getRequestType();
        if (this.m_requestType != null && (ct = this.m_requestType.getConfidentialType()) != null) {
            this.setConfidentialType(ct);
            this.setConfidentialTypeEntry(ct);
        }
    }

    public MRequest(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setR_RequestType_ID() {
        this.m_requestType = MRequestType.getDefault(this.getCtx());
        if (this.m_requestType == null) {
            this.log.warning("No default found");
        } else {
            super.setR_RequestType_ID(this.m_requestType.getR_RequestType_ID());
        }
    }

    public void setR_Status_ID() {
        MStatus status = MStatus.getDefault(this.getCtx(), this.getR_RequestType_ID());
        if (status == null) {
            this.log.warning("No default found");
            if (this.getR_Status_ID() != 0) {
                this.setR_Status_ID(0);
            }
        } else {
            this.setR_Status_ID(status.getR_Status_ID());
        }
    }

    public void addToResult(String Result2) {
        String oldResult = this.getResult();
        if (Result2 != null && Result2.length() != 0) {
            if (oldResult == null || oldResult.length() == 0) {
                this.setResult(Result2);
            } else {
                this.setResult(oldResult + "\n-\n" + Result2);
            }
        }
    }

    public void setDueType() {
        Timestamp due = this.getDateNextAction();
        if (due == null) {
            return;
        }
        Timestamp overdue = TimeUtil.addDays(due, this.getRequestType().getDueDateTolerance());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String DueType = "5";
        if (now.before(due)) {
            DueType = "7";
        } else if (now.after(overdue)) {
            DueType = "3";
        }
        super.setDueType(DueType);
    }

    public MRequestAction[] getActions() {
        List<MRequestAction> list = new Query(this.getCtx(), "R_RequestAction", "R_Request_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Created DESC").list();
        return list.toArray(new MRequestAction[list.size()]);
    }

    public MRequestUpdate[] getUpdates(String confidentialType) {
        List listUpdates = new Query(this.getCtx(), "R_RequestUpdate", "R_Request_ID=?", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("Created DESC").list();
        ArrayList<MRequestUpdate> list = new ArrayList<MRequestUpdate>();
        for (MRequestUpdate ru : listUpdates) {
            if (confidentialType != null && (ru.getConfidentialTypeEntry().equals("P") && !confidentialType.equals("P") || ru.getConfidentialTypeEntry().equals("I") && (confidentialType.equals("C") || confidentialType.equals("A")) || ru.getConfidentialTypeEntry().equals("C") && confidentialType.equals("A"))) continue;
            list.add(ru);
        }
        MRequestUpdate[] retValue = new MRequestUpdate[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRequestUpdate[] getUpdatesPublic() {
        return this.getUpdates("A");
    }

    public MRequestUpdate[] getUpdatesCustomer() {
        return this.getUpdates("C");
    }

    public MRequestUpdate[] getUpdatesInternal() {
        return this.getUpdates("I");
    }

    public MRequestType getRequestType() {
        if (this.m_requestType == null) {
            int R_RequestType_ID = this.getR_RequestType_ID();
            if (R_RequestType_ID == 0) {
                this.setR_RequestType_ID();
                R_RequestType_ID = this.getR_RequestType_ID();
            }
            this.m_requestType = MRequestType.getCopy(this.getCtx(), R_RequestType_ID, this.get_TrxName());
        }
        return this.m_requestType;
    }

    public String getRequestTypeName() {
        if (this.m_requestType == null) {
            this.getRequestType();
        }
        if (this.m_requestType == null) {
            return "??";
        }
        return this.m_requestType.getName();
    }

    public MRequestCategory getCategory() {
        if (this.getR_Category_ID() == 0) {
            return null;
        }
        return MRequestCategory.getCopy(this.getCtx(), this.getR_Category_ID(), this.get_TrxName());
    }

    public String getCategoryName() {
        MRequestCategory cat = this.getCategory();
        if (cat == null) {
            return "";
        }
        return cat.getName();
    }

    public MGroup getGroup() {
        if (this.getR_Group_ID() == 0) {
            return null;
        }
        return MGroup.getCopy(this.getCtx(), this.getR_Group_ID(), this.get_TrxName());
    }

    public String getGroupName() {
        MGroup grp = this.getGroup();
        if (grp == null) {
            return "";
        }
        return grp.getName();
    }

    public MStatus getStatus() {
        if (this.getR_Status_ID() == 0) {
            return null;
        }
        return MStatus.getCopy(this.getCtx(), this.getR_Status_ID(), this.get_TrxName());
    }

    public String getStatusName() {
        MStatus sta = this.getStatus();
        if (sta == null) {
            return "?";
        }
        return sta.getName();
    }

    public MResolution getResolution() {
        if (this.getR_Resolution_ID() == 0) {
            return null;
        }
        return MResolution.getCopy(this.getCtx(), this.getR_Resolution_ID(), this.get_TrxName());
    }

    public String getResolutionName() {
        MResolution res = this.getResolution();
        if (res == null) {
            return "";
        }
        return res.getName();
    }

    public boolean isOverdue() {
        return "3".equals(this.getDueType());
    }

    public boolean isDue() {
        return "5".equals(this.getDueType());
    }

    public String getDueTypeText() {
        return MRefList.getListName(this.getCtx(), 222, this.getDueType());
    }

    public String getPriorityText() {
        return MRefList.getListName(this.getCtx(), 154, this.getPriority());
    }

    public String getPriorityUserText() {
        return MRefList.getListName(this.getCtx(), 154, this.getPriorityUser());
    }

    public String getConfidentialText() {
        return MRefList.getListName(this.getCtx(), 340, this.getConfidentialType());
    }

    public String getConfidentialEntryText() {
        return MRefList.getListName(this.getCtx(), 340, this.getConfidentialTypeEntry());
    }

    public void setDateLastAlert() {
        super.setDateLastAlert(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public MUser getSalesRep() {
        if (this.getSalesRep_ID() == 0) {
            return null;
        }
        return MUser.getCopy(this.getCtx(), this.getSalesRep_ID(), this.get_TrxName());
    }

    public String getSalesRepName() {
        MUser sr = this.getSalesRep();
        if (sr == null) {
            return "n/a";
        }
        return sr.getName();
    }

    public String getCreatedByName() {
        MUser user = MUser.get(this.getCtx(), this.getCreatedBy());
        return user.getName();
    }

    public MUser getUser() {
        if (this.getAD_User_ID() == 0) {
            return null;
        }
        if (this.m_user != null && this.m_user.getAD_User_ID() != this.getAD_User_ID()) {
            this.m_user = null;
        }
        if (this.m_user == null) {
            this.m_user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
        }
        return this.m_user;
    }

    public MBPartner getBPartner() {
        if (this.getC_BPartner_ID() == 0) {
            return null;
        }
        if (this.m_partner != null && this.m_partner.getC_BPartner_ID() != this.getC_BPartner_ID()) {
            this.m_partner = null;
        }
        if (this.m_partner == null) {
            this.m_partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        }
        return this.m_partner;
    }

    public boolean isWebCanUpdate() {
        if (this.isProcessed()) {
            return false;
        }
        if (this.getR_Status_ID() == 0) {
            this.setR_Status_ID();
        }
        if (this.getR_Status_ID() == 0) {
            return false;
        }
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (status == null) {
            return false;
        }
        return status.isWebCanUpdate();
    }

    private void setPriority() {
        MBPGroup bpg;
        String prioBase;
        if (this.getPriorityUser() == null) {
            this.setPriorityUser("7");
        }
        if (this.getBPartner() != null && (prioBase = (bpg = MBPGroup.get(this.getCtx(), this.getBPartner().getC_BP_Group_ID())).getPriorityBase()) != null && !prioBase.equals("S")) {
            char targetPrio = this.getPriorityUser().charAt(0);
            targetPrio = prioBase.equals("L") ? (char)(targetPrio + 2) : (char)(targetPrio - 2);
            if (targetPrio < "3".charAt(0)) {
                targetPrio = "3".charAt(0);
            }
            if (targetPrio > "7".charAt(0)) {
                targetPrio = "7".charAt(0);
            }
            if (this.getPriority() == null) {
                this.setPriority(String.valueOf(targetPrio));
            } else if (targetPrio < this.getPriority().charAt(0)) {
                this.setPriority(String.valueOf(targetPrio));
            }
        }
        if (this.getPriority() == null) {
            this.setPriority(this.getPriorityUser());
        }
    }

    @Override
    public void setConfidentialTypeEntry(String ConfidentialTypeEntry) {
        if (ConfidentialTypeEntry == null) {
            ConfidentialTypeEntry = this.getConfidentialType();
        }
        if ("I".equals(this.getConfidentialType())) {
            super.setConfidentialTypeEntry("I");
        } else if ("P".equals(this.getConfidentialType())) {
            if ("I".equals(ConfidentialTypeEntry) || "P".equals(ConfidentialTypeEntry)) {
                super.setConfidentialTypeEntry(ConfidentialTypeEntry);
            } else {
                super.setConfidentialTypeEntry("P");
            }
        } else if ("C".equals(this.getConfidentialType())) {
            if ("I".equals(ConfidentialTypeEntry) || "P".equals(ConfidentialTypeEntry) || "C".equals(ConfidentialTypeEntry)) {
                super.setConfidentialTypeEntry(ConfidentialTypeEntry);
            } else {
                super.setConfidentialTypeEntry("C");
            }
        } else if ("A".equals(this.getConfidentialType())) {
            super.setConfidentialTypeEntry(ConfidentialTypeEntry);
        }
    }

    public boolean webUpdate(String result) {
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (!status.isWebCanUpdate()) {
            return false;
        }
        if (status.getUpdate_Status_ID() > 0) {
            this.setR_Status_ID(status.getUpdate_Status_ID());
        }
        this.setResult(result);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRequest[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("]");
        return sb.toString();
    }

    public File createPDF() {
        return null;
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MTable table2;
        PO po;
        this.getRequestType();
        if (newRecord || this.is_ValueChanged("R_RequestType_ID")) {
            if (this.m_requestType != null) {
                if (this.isInvoiced() != this.m_requestType.isInvoiced()) {
                    this.setIsInvoiced(this.m_requestType.isInvoiced());
                }
                if (this.getDateNextAction() == null && this.m_requestType.getAutoDueDateDays() > 0) {
                    this.setDateNextAction(TimeUtil.addDays(new Timestamp(System.currentTimeMillis()), this.m_requestType.getAutoDueDateDays()));
                }
            }
            if (this.getR_Status_ID() != 0) {
                MStatus sta = MStatus.get(this.getCtx(), this.getR_Status_ID());
                MRequestType rt = MRequestType.get(this.getCtx(), this.getR_RequestType_ID());
                if (sta.getR_StatusCategory_ID() != rt.getR_StatusCategory_ID()) {
                    this.setR_Status_ID();
                }
            }
        }
        if (this.getR_Status_ID() == 0) {
            this.setR_Status_ID();
        }
        this.setDueType();
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (status != null) {
            if (status.isOpen()) {
                if (this.getStartDate() == null) {
                    this.setStartDate(new Timestamp(System.currentTimeMillis()));
                }
                if (this.getCloseDate() != null) {
                    this.setCloseDate(null);
                }
            }
            if (status.isClosed() && this.getCloseDate() == null) {
                this.setCloseDate(new Timestamp(System.currentTimeMillis()));
            }
            if (status.isFinalClose()) {
                this.setProcessed(true);
            }
        }
        if (this.getConfidentialType() == null) {
            String ct;
            this.getRequestType();
            if (this.m_requestType != null && (ct = this.m_requestType.getConfidentialType()) != null) {
                this.setConfidentialType(ct);
            }
            if (this.getConfidentialType() == null) {
                this.setConfidentialType("A");
            }
        }
        if (this.getConfidentialTypeEntry() == null) {
            this.setConfidentialTypeEntry(this.getConfidentialType());
        } else {
            this.setConfidentialTypeEntry(this.getConfidentialTypeEntry());
        }
        this.setPriority();
        if (this.getRecord_ID() > 0 && this.getAD_Table_ID() > 0 && Util.isEmpty(this.getRecord_UU()) && (po = (table2 = MTable.get(this.getAD_Table_ID())).getPO(this.getRecord_ID(), this.get_TrxName())) != null) {
            this.setRecord_UU(po.get_UUID());
        }
        return true;
    }

    @Override
    public void setSalesRep_ID(int SalesRep_ID) {
        if (SalesRep_ID != 0) {
            super.setSalesRep_ID(SalesRep_ID);
        } else if (this.getSalesRep_ID() != 0) {
            this.log.warning("Ignored - Tried to set SalesRep_ID to 0 from " + this.getSalesRep_ID());
        }
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord && this.getResult() != null) {
            MRequestUpdate update = new MRequestUpdate(this);
            update.saveEx();
        }
        if (this.getM_ChangeRequest_ID() != 0 && this.is_ValueChanged("R_Group_ID")) {
            int oldID = this.get_ValueOldAsInt("R_Group_ID");
            if (this.getR_Group_ID() == 0) {
                this.setM_ChangeRequest_ID(0);
            } else {
                MChangeRequest ecr;
                MGroup oldG = MGroup.get(this.getCtx(), oldID);
                MGroup newG = MGroup.get(this.getCtx(), this.getR_Group_ID());
                if (!(oldG.getPP_Product_BOM_ID() == newG.getPP_Product_BOM_ID() && oldG.getM_ChangeNotice_ID() == newG.getM_ChangeNotice_ID() || (ecr = new MChangeRequest(this.getCtx(), this.getM_ChangeRequest_ID(), this.get_TrxName())).isProcessed() && ecr.getM_FixChangeNotice_ID() != 0)) {
                    ecr.setPP_Product_BOM_ID(newG.getPP_Product_BOM_ID());
                    ecr.setM_ChangeNotice_ID(newG.getM_ChangeNotice_ID());
                    ecr.saveEx();
                }
            }
        }
        return success;
    }

    public String getMailTag() {
        return TAG_START + this.get_ID() + TAG_END;
    }

    public void doClose() {
        MStatus status = MStatus.get(this.getCtx(), this.getR_Status_ID());
        if (!status.isClosed()) {
            MStatus[] closed = MStatus.getClosed(this.getCtx());
            X_R_Status newStatus = null;
            int i = 0;
            while (i < closed.length) {
                if (!closed[i].isFinalClose()) {
                    newStatus = closed[i];
                    break;
                }
                ++i;
            }
            if (newStatus == null && closed.length > 0) {
                newStatus = closed[0];
            }
            if (newStatus != null) {
                this.setR_Status_ID(newStatus.getR_Status_ID());
            }
        }
    }

    public void doEscalate(boolean user) {
        if (user) {
            String Importance = this.getPriorityUser();
            if (!"1".equals(Importance)) {
                if ("3".equals(Importance)) {
                    this.setPriorityUser("1");
                } else if ("5".equals(Importance)) {
                    this.setPriorityUser("3");
                } else if ("7".equals(Importance)) {
                    this.setPriorityUser("5");
                } else if ("9".equals(Importance)) {
                    this.setPriorityUser("7");
                }
            }
        } else {
            String Importance = this.getPriority();
            if (!"1".equals(Importance)) {
                if ("3".equals(Importance)) {
                    this.setPriority("1");
                } else if ("5".equals(Importance)) {
                    this.setPriority("3");
                } else if ("7".equals(Importance)) {
                    this.setPriority("5");
                } else if ("9".equals(Importance)) {
                    this.setPriority("7");
                }
            }
        }
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public void setIsChanged(boolean changed) {
        this.m_changed = changed;
    }

    @Deprecated
    public static int[] getRequestCount(int AD_Table_ID, int Record_ID, StringBuilder whereClause, String trxName) {
        return MRequest.getRequestCount(AD_Table_ID, Record_ID, null, whereClause, trxName);
    }

    public static int[] getRequestCount(int AD_Table_ID, int Record_ID, String Record_UU, StringBuilder whereClause, String trxName) {
        int[] counts = new int[2];
        whereClause.append("(AD_Table_ID=").append(AD_Table_ID);
        if (Util.isEmpty(Record_UU)) {
            whereClause.append(" AND Record_ID=").append(Record_ID);
        } else {
            whereClause.append(" AND Record_UU=").append(DB.TO_STRING(Record_UU));
        }
        whereClause.append(")");
        if (AD_Table_ID == 114) {
            whereClause.append(" OR AD_User_ID=").append(Record_ID).append(" OR SalesRep_ID=").append(Record_ID);
        } else if (AD_Table_ID == 291) {
            whereClause.append(" OR C_BPartner_ID=").append(Record_ID);
        } else if (AD_Table_ID == 259) {
            whereClause.append(" OR C_Order_ID=").append(Record_ID);
        } else if (AD_Table_ID == 318) {
            whereClause.append(" OR C_Invoice_ID=").append(Record_ID);
        } else if (AD_Table_ID == 335) {
            whereClause.append(" OR C_Payment_ID=").append(Record_ID);
        } else if (AD_Table_ID == 208) {
            whereClause.append(" OR M_Product_ID=").append(Record_ID);
        } else if (AD_Table_ID == 203) {
            whereClause.append(" OR C_Project_ID=").append(Record_ID);
        } else if (AD_Table_ID == 274) {
            whereClause.append(" OR C_Campaign_ID=").append(Record_ID);
        } else if (AD_Table_ID == 539) {
            whereClause.append(" OR A_Asset_ID=").append(Record_ID);
        }
        String sql = "SELECT Processed, COUNT(*) FROM R_Request WHERE " + String.valueOf(whereClause) + " GROUP BY Processed ORDER BY Processed DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    if ("Y".equals(rs.getString(1))) {
                        counts[0] = counts[0] + rs.getInt(2);
                        continue;
                    }
                    counts[1] = counts[1] + rs.getInt(2);
                }
            }
            catch (Exception e) {
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return counts;
    }

    @Deprecated
    public static void newRequest(GridTab tab, int AD_Table_ID, int Record_ID, int C_BPartner_ID) {
        MRequest.newRequest(tab, AD_Table_ID, Record_ID, null, C_BPartner_ID);
    }

    public static void newRequest(GridTab tab, int AD_Table_ID, int Record_ID, String Record_UU, int C_BPartner_ID) {
        MOrderLine oLine;
        tab.dataNew(false);
        tab.setValue("AD_Table_ID", (Object)AD_Table_ID);
        tab.setValue("Record_ID", (Object)Record_ID);
        tab.setValue("Record_UU", (Object)Record_UU);
        if (C_BPartner_ID != 0) {
            tab.setValue("C_BPartner_ID", (Object)C_BPartner_ID);
        }
        if (AD_Table_ID == 291) {
            tab.setValue("C_BPartner_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 114) {
            tab.setValue("AD_User_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 203) {
            tab.setValue("C_Project_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 539) {
            tab.setValue("A_Asset_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 259) {
            tab.setValue("C_Order_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 318) {
            tab.setValue("C_Invoice_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 208) {
            tab.setValue("M_Product_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 335) {
            tab.setValue("C_Payment_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 319) {
            tab.setValue("M_InOut_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 661) {
            tab.setValue("M_RMA_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 274) {
            tab.setValue("C_Campaign_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 417) {
            tab.setValue("R_RequestRelated_ID", (Object)Record_ID);
        } else if (AD_Table_ID == 260 && (oLine = new MOrderLine(Env.getCtx(), Record_ID, null)) != null) {
            tab.setValue("C_Order_ID", (Object)oLine.getC_Order_ID());
        }
    }
}

