/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.impexp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public abstract class AbstractExcelExporter {
    protected final transient CLogger log = CLogger.getCLogger(this.getClass());
    protected HSSFWorkbook m_workbook;
    private HSSFDataFormat m_dataFormat;
    private HSSFFont m_fontHeader = null;
    private HSSFFont m_fontDefault = null;
    protected Language m_lang = null;
    private int m_sheetCount = 0;
    private int m_colSplit = 1;
    private int m_rowSplit = 1;
    private boolean currentRowOnly = false;
    private HashMap<String, HSSFCellStyle> m_styles = new HashMap();
    protected Boolean[] colSuppressRepeats;
    private int noOfParameter = 0;

    public abstract boolean isFunctionRow();

    public abstract int getColumnCount();

    public abstract int getRowCount();

    protected abstract void setCurrentRow(int var1);

    protected abstract int getCurrentRow();

    public abstract boolean isColumnPrinted(int var1);

    public abstract String getHeaderName(int var1);

    public abstract int getDisplayType(int var1, int var2);

    public abstract Object getValueAt(int var1, int var2);

    public abstract boolean isPageBreak(int var1, int var2);

    public abstract boolean isDisplayed(int var1, int var2);

    public AbstractExcelExporter() {
        this.m_workbook = new HSSFWorkbook();
        this.m_dataFormat = this.m_workbook.createDataFormat();
    }

    protected Properties getCtx() {
        return Env.getCtx();
    }

    protected void setFreezePane(int colSplit, int rowSplit) {
        this.m_colSplit = colSplit;
        this.m_rowSplit = rowSplit;
    }

    private String fixString(String str) {
        return Util.stripDiacritics(str);
    }

    protected Language getLanguage() {
        if (this.m_lang == null) {
            this.m_lang = Env.getLanguage(this.getCtx());
        }
        return this.m_lang;
    }

    private HSSFFont getFont(boolean isHeader) {
        HSSFFont font = null;
        if (isHeader) {
            if (this.m_fontHeader == null) {
                this.m_fontHeader = this.m_workbook.createFont();
                this.m_fontHeader.setBold(true);
            }
            font = this.m_fontHeader;
        } else if (this.isFunctionRow()) {
            font = this.m_workbook.createFont();
            font.setBold(true);
            font.setItalic(true);
        } else {
            if (this.m_fontDefault == null) {
                this.m_fontDefault = this.m_workbook.createFont();
            }
            font = this.m_fontDefault;
        }
        return font;
    }

    private String getFormatString(NumberFormat df, boolean isHighlightNegativeNumbers) {
        StringBuilder format = new StringBuilder();
        int integerDigitsMin = df.getMinimumIntegerDigits();
        int integerDigitsMax = df.getMaximumIntegerDigits();
        int i2 = 0;
        while (i2 < integerDigitsMax) {
            if (i2 < integerDigitsMin) {
                format.insert(0, "0");
            } else {
                format.insert(0, "#");
            }
            if (i2 == 2) {
                format.insert(0, ",");
            }
            ++i2;
        }
        int fractionDigitsMin = df.getMinimumFractionDigits();
        int fractionDigitsMax = df.getMaximumFractionDigits();
        int i3 = 0;
        while (i3 < fractionDigitsMax) {
            if (i3 == 0) {
                format.append(".");
            }
            if (i3 < fractionDigitsMin) {
                format.append("0");
            } else {
                format.append("#");
            }
            ++i3;
        }
        if (isHighlightNegativeNumbers) {
            String f = format.toString();
            format = new StringBuilder(f).append(";[RED]-").append(f);
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("NumberFormat: " + String.valueOf(format));
        }
        return format.toString();
    }

    private HSSFCellStyle getStyle(int row, int col) {
        int displayType = this.getDisplayType(row, col);
        String key = "cell-" + col + "-" + displayType;
        HSSFCellStyle cs = this.m_styles.get(key);
        if (cs == null) {
            cs = this.m_workbook.createCellStyle();
            HSSFFont font = this.getFont(false);
            cs.setFont(font);
            cs.setBorderLeft(BorderStyle.THIN);
            cs.setBorderTop(BorderStyle.THIN);
            cs.setBorderRight(BorderStyle.THIN);
            cs.setBorderBottom(BorderStyle.THIN);
            String cellFormat = this.getCellFormat(row, col);
            if (cellFormat != null) {
                cs.setDataFormat(this.m_dataFormat.getFormat(cellFormat));
            }
            this.m_styles.put(key, cs);
        }
        return cs;
    }

    protected String getCellFormat(int row, int col) {
        boolean isHighlightNegativeNumbers = true;
        int displayType = this.getDisplayType(row, col);
        String cellFormat = null;
        if (DisplayType.isDate(displayType)) {
            cellFormat = DisplayType.getDateFormat(this.getLanguage()).toPattern();
        } else if (DisplayType.isNumeric(displayType)) {
            DecimalFormat df = DisplayType.getNumberFormat(displayType, this.getLanguage());
            cellFormat = this.getFormatString(df, isHighlightNegativeNumbers);
        }
        return cellFormat;
    }

    private HSSFCellStyle getHeaderStyle(int col) {
        String key = "header-" + col;
        HSSFCellStyle cs_header = this.m_styles.get(key);
        if (cs_header == null) {
            HSSFFont font_header = this.getFont(true);
            cs_header = this.m_workbook.createCellStyle();
            cs_header.setFont(font_header);
            cs_header.setBorderLeft(BorderStyle.MEDIUM);
            cs_header.setBorderTop(BorderStyle.MEDIUM);
            cs_header.setBorderRight(BorderStyle.MEDIUM);
            cs_header.setBorderBottom(BorderStyle.MEDIUM);
            cs_header.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"text"));
            cs_header.setWrapText(true);
            this.m_styles.put(key, cs_header);
        }
        return cs_header;
    }

    private void fixColumnWidth(HSSFSheet sheet, int lastColumnIndex) {
        int colnum = 0;
        while (colnum < lastColumnIndex) {
            sheet.autoSizeColumn(colnum);
            colnum = (short)(colnum + 1);
        }
    }

    private void closeTableSheet(HSSFSheet prevSheet, String prevSheetName, int colCount) {
        if (prevSheet == null) {
            return;
        }
        this.fixColumnWidth(prevSheet, colCount);
        if (!(this.m_colSplit < 0 && this.m_rowSplit < 0 || this.isForm())) {
            prevSheet.createFreezePane(this.m_colSplit >= 0 ? this.m_colSplit : 0, this.m_rowSplit >= 0 ? this.m_rowSplit : 0);
        }
        if (!Util.isEmpty(prevSheetName, true) && this.m_sheetCount > 0) {
            int prevSheetIndex = this.m_sheetCount - 1;
            try {
                this.m_workbook.setSheetName(prevSheetIndex, prevSheetName);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Error setting sheet " + prevSheetIndex + " name to " + prevSheetName, e);
            }
        }
    }

    private HSSFSheet createTableSheet() {
        HSSFSheet sheet = this.m_workbook.createSheet();
        this.formatPage(sheet);
        this.createHeaderFooter(sheet);
        this.createParameter(sheet);
        if (!this.isForm()) {
            this.createTableHeader(sheet);
        }
        ++this.m_sheetCount;
        return sheet;
    }

    private void createTableHeader(HSSFSheet sheet) {
        this.createTableHeader(sheet, Math.max(this.noOfParameter, 0));
    }

    private void createTableHeader(HSSFSheet sheet, int headerRowNum) {
        int colnumMax = 0;
        HSSFRow row = sheet.createRow(headerRowNum);
        int colnum = 0;
        int col = 0;
        while (col < this.getColumnCount()) {
            if (colnum > colnumMax) {
                colnumMax = colnum;
            }
            if (this.isColumnPrinted(col)) {
                HSSFCell cell = row.createCell(colnum);
                HSSFCellStyle style2 = this.getHeaderStyle(col);
                cell.setCellStyle(style2);
                String str = this.fixString(this.getHeaderName(col));
                cell.setCellValue((RichTextString)new HSSFRichTextString(str));
                ++colnum;
            }
            ++col;
        }
    }

    protected int getNoOfParameter() {
        return this.noOfParameter;
    }

    protected void setNoOfParameter(int noOfParameter) {
        this.noOfParameter = noOfParameter;
    }

    protected void createParameter(HSSFSheet sheet) {
    }

    protected void createHeaderFooter(HSSFSheet sheet) {
        HSSFHeader header = sheet.getHeader();
        header.setRight(HSSFHeader.page() + " / " + HSSFHeader.numPages());
        HSSFFooter footer = sheet.getFooter();
        footer.setLeft(Env.getStandardReportFooterTrademarkText());
        String s = MSysConfig.getValue("ZK_FOOTER_SERVER_MSG", "", Env.getAD_Client_ID(Env.getCtx()));
        if (Util.isEmpty(s, true)) {
            footer.setCenter(Env.getHeader(this.getCtx(), 0));
        } else {
            footer.setCenter(Msg.parseTranslation(Env.getCtx(), s));
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        s = MSysConfig.getValue("ZK_FOOTER_SERVER_DATETIME_FORMAT", Env.getAD_Client_ID(Env.getCtx()));
        if (!Util.isEmpty(s, true)) {
            footer.setRight(new SimpleDateFormat(s).format(System.currentTimeMillis()));
        } else {
            footer.setRight(DisplayType.getDateFormat(16, this.getLanguage()).format(now));
        }
    }

    protected void formatPage(HSSFSheet sheet) {
        sheet.setFitToPage(true);
        HSSFPrintSetup ps = sheet.getPrintSetup();
        ps.setFitWidth((short)1);
        ps.setNoColor(true);
        ps.setPaperSize((short)9);
        ps.setLandscape(false);
    }

    protected boolean isCurrentRowOnly() {
        return this.currentRowOnly;
    }

    protected void setCurrentRowOnly(boolean b2) {
        this.currentRowOnly = b2;
    }

    protected void export(OutputStream out) throws Exception {
        HSSFSheet sheet = null;
        if (out != null) {
            sheet = this.createTableSheet();
        } else {
            this.m_dataFormat = this.m_workbook.createDataFormat();
            sheet = this.m_workbook.getSheetAt(0);
            this.createTableHeader(sheet, sheet.getLastRowNum() + 2);
        }
        String sheetName = null;
        int colnumMax = 0;
        int rownum = this.isCurrentRowOnly() ? this.getCurrentRow() : 0;
        int lastRowNum = this.isCurrentRowOnly() ? this.getCurrentRow() + 1 : this.getRowCount();
        Object[] preValues = null;
        int printColIndex = -1;
        if (this.colSuppressRepeats != null) {
            preValues = new Object[this.colSuppressRepeats.length];
        }
        int initxls_rownum = 0;
        initxls_rownum = out != null ? Math.max(this.noOfParameter + 1, 1) : Math.max(this.noOfParameter + 1, sheet.getLastRowNum() + 1);
        int xls_rownum = initxls_rownum;
        while (rownum < lastRowNum) {
            if (!this.isCurrentRowOnly()) {
                this.setCurrentRow(rownum);
            }
            boolean isPageBreak = false;
            HSSFRow row = sheet.createRow(xls_rownum);
            printColIndex = -1;
            int colnum = 0;
            int col = 0;
            while (col < this.getColumnCount()) {
                if (colnum > colnumMax) {
                    colnumMax = colnum;
                }
                if (this.isColumnPrinted(col)) {
                    ++printColIndex;
                    HSSFCell cell = null;
                    Object obj = this.getValueAt(rownum, col);
                    if (this.isForm()) {
                        if (this.isVisible(rownum, col) && (!this.isSuppressNull(col) || obj != null && !Util.isEmpty(obj.toString(), true))) {
                            row = this.getFormRow(sheet, col);
                            cell = this.getFormCell(row, col);
                            String label2 = this.fixString(this.getHeaderName(col));
                            if (!Util.isEmpty(label2, true)) {
                                cell.setCellValue((RichTextString)new HSSFRichTextString(label2));
                                int index = cell.getColumnIndex() + 1;
                                cell = row.getCell(index);
                                if (cell == null) {
                                    cell = row.createCell(index);
                                }
                            }
                        } else if (this.isSetFormRowPosition(col)) {
                            row = this.getFormRow(sheet, col);
                        }
                    } else {
                        cell = row.createCell(colnum);
                    }
                    int displayType = this.getDisplayType(rownum, col);
                    if (obj == null || !this.isDisplayed(rownum, col)) {
                        if (this.colSuppressRepeats != null && this.colSuppressRepeats[printColIndex].booleanValue()) {
                            preValues[printColIndex] = null;
                        }
                    } else if (!(this.colSuppressRepeats != null && this.colSuppressRepeats[printColIndex].booleanValue() && obj.equals(preValues[printColIndex]) || !this.isVisible(rownum, col))) {
                        if (DisplayType.isDate(displayType)) {
                            Timestamp value = null;
                            value = obj instanceof Date ? new Timestamp(((Date)obj).getTime()) : (Timestamp)obj;
                            cell.setCellValue((java.util.Date)value);
                        } else if (DisplayType.isNumeric(displayType)) {
                            double value = 0.0;
                            if (obj instanceof Number) {
                                value = ((Number)obj).doubleValue();
                            }
                            cell.setCellValue(value);
                        } else if (20 == displayType) {
                            boolean value = false;
                            value = obj instanceof Boolean ? ((Boolean)obj).booleanValue() : "Y".equals(obj);
                            cell.setCellValue((RichTextString)new HSSFRichTextString(Msg.getMsg(this.getLanguage(), value ? "Y" : "N")));
                        } else {
                            String value = this.fixString(obj.toString());
                            cell.setCellValue((RichTextString)new HSSFRichTextString(value));
                        }
                    }
                    if (cell != null) {
                        HSSFCellStyle style2 = this.getStyle(rownum, col);
                        if (this.isForm()) {
                            style2.setWrapText(true);
                        }
                        cell.setCellStyle(style2);
                    }
                    if (this.isPageBreak(rownum, col)) {
                        isPageBreak = true;
                        sheetName = this.fixString(cell.getRichStringCellValue().getString());
                    }
                    ++colnum;
                    if (this.colSuppressRepeats != null) {
                        preValues[printColIndex] = obj;
                    }
                }
                ++col;
            }
            if (isPageBreak) {
                this.closeTableSheet(sheet, sheetName, colnumMax);
                sheet = this.createTableSheet();
                xls_rownum = 0;
                isPageBreak = false;
            }
            ++rownum;
            ++xls_rownum;
        }
        if (out == null) {
            this.fixColumnWidth(sheet, colnumMax);
        } else {
            this.closeTableSheet(sheet, sheetName, colnumMax);
        }
        if (out != null) {
            this.m_workbook.write(out);
            out.close();
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sheets #" + this.m_sheetCount);
            this.log.fine("Styles used #" + this.m_styles.size());
        }
    }

    public void export(File file, Language language) throws Exception {
        this.export(file, language, true);
    }

    public void export(File file, Language language, boolean autoOpen) throws Exception {
        this.m_lang = language;
        if (file == null) {
            file = File.createTempFile("Report_", ".xls");
        }
        FileOutputStream out = new FileOutputStream(file);
        this.export(out);
        if (autoOpen && Ini.isClient()) {
            Env.startBrowser(file.toURI().toString());
        }
    }

    public void exportToWorkbook(HSSFWorkbook workbook, Language language) throws Exception {
        this.m_lang = language;
        this.m_workbook = workbook;
        this.export(null);
    }

    protected boolean isForm() {
        return false;
    }

    protected boolean isVisible(int row, int col) {
        return true;
    }

    protected boolean isSuppressNull(int col) {
        return false;
    }

    protected boolean isSetFormRowPosition(int col) {
        return false;
    }

    protected HSSFCell getFormCell(HSSFRow row, int colnum) {
        return null;
    }

    protected HSSFRow getFormRow(HSSFSheet sheet, int colnum) {
        return null;
    }
}

