/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.base.event.EventManager;
import org.adempiere.base.event.EventProperty;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocActionEventData;
import org.compiere.process.DocOptions;
import org.compiere.process.IDocsPostProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.osgi.service.event.Event;

public class DocumentEngine
implements DocAction {
    public static final String DOCUMENT_POST_IMMEDIATE_AFTER_COMPLETE = "Document.PostImmediateAfterComplete";
    private DocAction m_document;
    private String m_status = "DR";
    private String m_message = null;
    private String m_action = null;
    private static CLogger log = CLogger.getCLogger(DocumentEngine.class);
    private static String EXCEPTION_MSG = "Document Engine is no Document";

    public DocumentEngine(DocAction po) {
        this(po, "DR");
    }

    public DocumentEngine(DocAction po, String docStatus) {
        this.m_document = po;
        if (docStatus != null) {
            this.m_status = docStatus;
        }
    }

    @Override
    public String getDocStatus() {
        return this.m_status;
    }

    @Override
    public void setDocStatus(String ignored) {
    }

    public boolean isDrafted() {
        return "DR".equals(this.m_status);
    }

    public boolean isInvalid() {
        return "IN".equals(this.m_status);
    }

    public boolean isInProgress() {
        return "IP".equals(this.m_status);
    }

    public boolean isApproved() {
        return "AP".equals(this.m_status);
    }

    public boolean isNotApproved() {
        return "NA".equals(this.m_status);
    }

    public boolean isWaiting() {
        return "WP".equals(this.m_status) || "WC".equals(this.m_status);
    }

    public boolean isCompleted() {
        return "CO".equals(this.m_status);
    }

    public boolean isReversed() {
        return "RE".equals(this.m_status);
    }

    public boolean isClosed() {
        return "CL".equals(this.m_status);
    }

    public boolean isVoided() {
        return "VO".equals(this.m_status);
    }

    public boolean isUnknown() {
        return "??".equals(this.m_status) || !this.isDrafted() && !this.isInvalid() && !this.isInProgress() && !this.isNotApproved() && !this.isApproved() && !this.isWaiting() && !this.isCompleted() && !this.isReversed() && !this.isClosed() && !this.isVoided();
    }

    public boolean processIt(String processAction, String docAction) {
        PO docPO;
        if (this.m_document instanceof PO && (docPO = (PO)((Object)this.m_document)).get_ID() > 0 && docPO.get_TrxName() != null && docPO.get_ValueOld("DocStatus") != null) {
            DB.getDatabase().forUpdate(docPO, 30);
            String docStatusOriginal = (String)docPO.get_ValueOld("DocStatus");
            String statusSql = "SELECT DocStatus FROM " + docPO.get_TableName() + " WHERE " + docPO.get_KeyColumns()[0] + " = ? ";
            String currentStatus = DB.getSQLValueString(null, statusSql, docPO.get_ID());
            if (!docStatusOriginal.equals(currentStatus) && currentStatus != null && !docStatusOriginal.equals(currentStatus = DB.getSQLValueString(docPO.get_TrxName(), statusSql, docPO.get_ID()))) {
                throw new IllegalStateException(Msg.getMsg(docPO.getCtx(), "DocStatusChanged") + " " + docPO.toString());
            }
        }
        this.m_message = null;
        this.m_action = null;
        if (this.isValidAction(processAction)) {
            this.m_action = processAction;
        } else if (this.isValidAction(docAction)) {
            this.m_action = docAction;
        } else {
            if (processAction.equals("--") || docAction.equals("--")) {
                if (this.m_document != null) {
                    this.m_document.get_Logger().info("**** No Action (Prc=" + processAction + "/Doc=" + docAction + ") " + String.valueOf(this.m_document));
                }
                return true;
            }
            throw new IllegalStateException("Status=" + this.getDocStatus() + " - Invalid Actions: Process=" + processAction + ", Doc=" + docAction);
        }
        if (this.m_document != null && this.m_document.get_Logger().isLoggable(Level.INFO)) {
            this.m_document.get_Logger().info("**** Action=" + this.m_action + " (Prc=" + processAction + "/Doc=" + docAction + ") " + String.valueOf(this.m_document));
        }
        boolean success = this.processIt(this.m_action);
        if (this.m_document != null && this.m_document.get_Logger().isLoggable(Level.FINE)) {
            this.m_document.get_Logger().fine("**** Action=" + this.m_action + " - Success=" + success);
        }
        return success;
    }

    @Override
    public boolean processIt(String action) {
        this.m_message = null;
        this.m_action = action;
        if ("XL".equals(this.m_action)) {
            return this.unlockIt();
        }
        if ("IN".equals(this.m_action)) {
            return this.invalidateIt();
        }
        if ("PR".equals(this.m_action)) {
            return "IP".equals(this.prepareIt());
        }
        if ("AP".equals(this.m_action)) {
            return this.approveIt();
        }
        if ("RJ".equals(this.m_action)) {
            return this.rejectIt();
        }
        if ("CO".equals(this.m_action) || "WC".equals(this.m_action)) {
            boolean ok;
            String status = null;
            if ((this.isDrafted() || this.isInvalid()) && !"IP".equals(status = this.prepareIt())) {
                return false;
            }
            status = this.completeIt();
            boolean bl = ok = "CO".equals(status) || "IP".equals(status) || "WP".equals(status) || "WC".equals(status);
            if (this.m_document != null && ok) {
                List<Object> docsPostProcess = new ArrayList();
                if (this.m_document instanceof IDocsPostProcess) {
                    docsPostProcess = ((IDocsPostProcess)((Object)this.m_document)).getDocsPostProcess();
                }
                if (this.m_document instanceof PO && docsPostProcess.size() > 0) {
                    for (PO pO : docsPostProcess) {
                        pO.setProcessedOn("Processed", true, false);
                        pO.saveEx();
                    }
                }
                if ("CO".equals(status) && MClient.isClientAccountingImmediate()) {
                    boolean bl2;
                    Object object;
                    boolean bl3 = true;
                    if (this.m_document instanceof PO && (object = ((PO)((Object)this.m_document)).get_Attribute(DOCUMENT_POST_IMMEDIATE_AFTER_COMPLETE)) != null && object instanceof Boolean) {
                        bl2 = (Boolean)object;
                    }
                    if (bl2) {
                        this.m_document.saveEx();
                        this.postIt();
                        if (this.m_document instanceof PO && docsPostProcess.size() > 0) {
                            for (PO pO : docsPostProcess) {
                                if (pO.get_ValueAsBoolean("Posted")) continue;
                                String ignoreError = DocumentEngine.postImmediate(pO.getCtx(), pO.getAD_Client_ID(), pO.get_Table_ID(), pO.get_ID(), true, pO.get_TrxName());
                                if (!Util.isEmpty(ignoreError, true)) {
                                    log.warning("Error posting " + String.valueOf(pO) + ". Error=" + ignoreError);
                                    continue;
                                }
                                pO.load(pO.get_TrxName(), new String[0]);
                            }
                        }
                    }
                }
            }
            return ok;
        }
        if ("RE".equals(this.m_action)) {
            return this.reActivateIt();
        }
        if ("RA".equals(this.m_action) || "RC".equals(this.m_action)) {
            List<PO> docsPostProcess;
            boolean ok = false;
            if ("RA".equals(this.m_action)) {
                ok = this.reverseAccrualIt();
            } else if ("RC".equals(this.m_action)) {
                ok = this.reverseCorrectIt();
            }
            if (this.m_document != null && ok && MClient.isClientAccountingImmediate() && this.m_document instanceof IDocsPostProcess && this.m_document instanceof PO && (docsPostProcess = ((IDocsPostProcess)((Object)this.m_document)).getDocsPostProcess()).size() > 0 && ((PO)((Object)this.m_document)).get_ValueAsBoolean("Posted")) {
                for (PO docafter : docsPostProcess) {
                    if (docafter.get_ValueAsBoolean("Posted")) continue;
                    String string = DocumentEngine.postImmediate(docafter.getCtx(), docafter.getAD_Client_ID(), docafter.get_Table_ID(), docafter.get_ID(), true, docafter.get_TrxName());
                    if (!Util.isEmpty(string, true)) {
                        log.warning("Error posting " + String.valueOf(docafter) + ". Error=" + string);
                        continue;
                    }
                    docafter.load(docafter.get_TrxName(), new String[0]);
                }
            }
            return ok;
        }
        if ("CL".equals(this.m_action)) {
            return this.closeIt();
        }
        if ("VO".equals(this.m_action)) {
            return this.voidIt();
        }
        if ("PO".equals(this.m_action)) {
            return this.postIt();
        }
        return false;
    }

    @Override
    public boolean unlockIt() {
        if (!this.isValidAction("XL")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.unlockIt()) {
                this.m_status = "DR";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "DR";
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (!this.isValidAction("IN")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.invalidateIt()) {
                this.m_status = "IN";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "IN";
        return true;
    }

    @Override
    public String prepareIt() {
        if (!this.isValidAction("PR")) {
            return this.m_status;
        }
        if (this.m_document != null) {
            this.m_status = this.m_document.prepareIt();
            this.m_document.setDocStatus(this.m_status);
        }
        return this.m_status;
    }

    @Override
    public boolean approveIt() {
        if (!this.isValidAction("AP")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.approveIt()) {
                this.m_status = "AP";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "AP";
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (!this.isValidAction("RJ")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.rejectIt()) {
                this.m_status = "NA";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "NA";
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.isValidAction("CO")) {
            return this.m_status;
        }
        if (this.m_document != null) {
            this.m_status = this.m_document.completeIt();
            this.m_document.setDocStatus(this.m_status);
        }
        return this.m_status;
    }

    public boolean postIt() {
        if (!this.isValidAction("PO") || this.m_document == null) {
            return false;
        }
        String error = DocumentEngine.postImmediate(Env.getCtx(), this.m_document.getAD_Client_ID(), this.m_document.get_Table_ID(), this.m_document.get_ID(), true, this.m_document.get_TrxName());
        if ("PO".equals(this.m_action) && !Util.isEmpty(error)) {
            throw new AdempiereException(error);
        }
        return error == null;
    }

    @Override
    public boolean voidIt() {
        if (!this.isValidAction("VO")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.voidIt()) {
                this.m_status = "VO";
                if (!this.m_document.getDocStatus().equals("RE")) {
                    this.m_document.setDocStatus(this.m_status);
                }
                return true;
            }
            return false;
        }
        this.m_status = "VO";
        return true;
    }

    @Override
    public boolean closeIt() {
        if (!(this.m_document != null && this.m_document.get_Table_ID() == 259 || this.isValidAction("CL"))) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.closeIt()) {
                this.m_status = "CL";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "CL";
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (!this.isValidAction("RC")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reverseCorrectIt()) {
                this.m_status = "RE";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "RE";
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (!this.isValidAction("RA")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reverseAccrualIt()) {
                this.m_status = "RE";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "RE";
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (!this.isValidAction("RE")) {
            return false;
        }
        if (this.m_document != null) {
            if (this.m_document.reActivateIt()) {
                this.m_status = "IP";
                this.m_document.setDocStatus(this.m_status);
                return true;
            }
            return false;
        }
        this.m_status = "IP";
        return true;
    }

    void setStatus(String newStatus) {
        this.m_status = newStatus;
    }

    public String[] getActionOptions() {
        if (this.isInvalid()) {
            return new String[]{"PR", "IN", "XL", "VO"};
        }
        if (this.isDrafted()) {
            return new String[]{"PR", "IN", "CO", "XL", "VO"};
        }
        if (this.isInProgress() || this.isApproved()) {
            return new String[]{"CO", "WC", "AP", "RJ", "XL", "VO", "PR"};
        }
        if (this.isNotApproved()) {
            return new String[]{"RJ", "PR", "XL", "VO"};
        }
        if (this.isWaiting()) {
            return new String[]{"CO", "WC", "RE", "VO", "CL"};
        }
        if (this.isCompleted()) {
            return new String[]{"CL", "RE", "RA", "RC", "PO", "VO"};
        }
        if (this.isClosed()) {
            return new String[]{"PO", "RE"};
        }
        if (this.isReversed() || this.isVoided()) {
            return new String[]{"PO"};
        }
        return new String[0];
    }

    public boolean isValidAction(String action) {
        String[] options = this.getActionOptions();
        int i2 = 0;
        while (i2 < options.length) {
            if (options[i2].equals(action)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public String getProcessMsg() {
        return this.m_message;
    }

    public void setProcessMsg(String msg) {
        this.m_message = msg;
    }

    @Override
    public String getSummary() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocumentNo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocumentInfo() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getDoc_User_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getC_Currency_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public BigDecimal getApprovalAmt() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getAD_Client_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int getAD_Org_ID() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String getDocAction() {
        return this.m_action;
    }

    @Override
    public boolean save() {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public void saveEx() throws AdempiereException {
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public Properties getCtx() {
        if (this.m_document != null) {
            return this.m_document.getCtx();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int get_ID() {
        if (this.m_document != null) {
            return this.m_document.get_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public int get_Table_ID() {
        if (this.m_document != null) {
            return this.m_document.get_Table_ID();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public CLogger get_Logger() {
        if (this.m_document != null) {
            return this.m_document.get_Logger();
        }
        throw new IllegalStateException(EXCEPTION_MSG);
    }

    @Override
    public String get_TrxName() {
        return null;
    }

    @Override
    public File createPDF() {
        return null;
    }

    public static int getValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, boolean periodOpen, PO po) {
        if (options == null) {
            throw new IllegalArgumentException("Option array parameter is null");
        }
        if (docAction == null) {
            throw new IllegalArgumentException("Doc action array parameter is null");
        }
        int index = 0;
        if (processing != null) {
            boolean locked = "Y".equals(processing);
            if (!locked && processing instanceof Boolean) {
                locked = (Boolean)processing;
            }
            if (locked) {
                options[index++] = "XL";
            }
        }
        if (docStatus.equals("NA")) {
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
            options[index++] = "CO";
            options[index++] = "PR";
            options[index++] = "VO";
        } else if (docStatus.equals("AP")) {
            options[index++] = "CO";
            options[index++] = "VO";
        } else if (docStatus.equals("CO")) {
            options[index++] = "CL";
        } else if (docStatus.equals("WP") || docStatus.equals("WC")) {
            options[index++] = "VO";
            options[index++] = "PR";
        }
        if (AD_Table_ID == 259) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                if ("Y".equals(isSOTrx) && ("OB".equals(orderType) || "ON".equals(orderType))) {
                    docAction[0] = "PR";
                }
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            } else if (docStatus.equals("WP")) {
                options[index++] = "RE";
                options[index++] = "CL";
            }
        } else if (AD_Table_ID == 319) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 318) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 335) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 224 || AD_Table_ID == 225) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                    options[index++] = "RE";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 735) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 407) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (AD_Table_ID == 392) {
            if (docStatus.equals("CO") && periodOpen) {
                options[index++] = "VO";
            }
        } else if (AD_Table_ID == 323 || AD_Table_ID == 321) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 53027) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (AD_Table_ID == 325) {
            if (docStatus.equals("CO")) {
                if (periodOpen) {
                    options[index++] = "RC";
                }
                options[index++] = "RA";
            }
        } else if (AD_Table_ID == 53035) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RC";
            }
        } else if (AD_Table_ID == 53037) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (AD_Table_ID == 53092) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "CL";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        } else if (AD_Table_ID == 661) {
            if (docStatus.equals("CO")) {
                options[index++] = "VO";
            }
        } else if (AD_Table_ID == 200246 && docStatus.equals("CO")) {
            options[index++] = "VO";
        }
        if (po instanceof DocOptions) {
            index = ((DocOptions)((Object)po)).customizeValidActions(docStatus, processing, orderType, isSOTrx, AD_Table_ID, docAction, options, index);
        }
        AtomicInteger indexObj = new AtomicInteger(index);
        ArrayList<String> docActionsArray = new ArrayList<String>(Arrays.asList(docAction));
        ArrayList<String> optionsArray = new ArrayList<String>(Arrays.asList(options));
        DocActionEventData eventData = new DocActionEventData(docStatus, processing, orderType, isSOTrx, AD_Table_ID, docActionsArray, optionsArray, indexObj, po);
        Event event = EventManager.newEvent("adempiere/docAction", new EventProperty("event.data", eventData), new EventProperty("tableName", po.get_TableName()));
        EventManager.getInstance().sendEvent(event);
        index = indexObj.get();
        int i2 = 0;
        while (i2 < optionsArray.size()) {
            options[i2] = optionsArray.get(i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < docActionsArray.size()) {
            docAction[i2] = docActionsArray.get(i2);
            ++i2;
        }
        return index;
    }

    public static void readReferenceList(ArrayList<String> v_value, ArrayList<String> v_name, ArrayList<String> v_description) {
        block10: {
            if (v_value == null) {
                throw new IllegalArgumentException("v_value parameter is null");
            }
            if (v_name == null) {
                throw new IllegalArgumentException("v_name parameter is null");
            }
            if (v_description == null) {
                throw new IllegalArgumentException("v_description parameter is null");
            }
            Object sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "' AND l.AD_Reference_ID=? ORDER BY t.Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, 135);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String value = rs.getString(1);
                        String name = rs.getString(2);
                        String description = rs.getString(3);
                        if (description == null) {
                            description = "";
                        }
                        v_value.add(value);
                        v_name.add(name);
                        v_description.add(description);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public static int checkActionAccess(int clientId, int roleId, int docTypeId, String[] options, int maxIndex) {
        return MRole.get(Env.getCtx(), roleId).checkActionAccess(clientId, docTypeId, options, maxIndex);
    }

    public static String postImmediate(Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force, String trxName) {
        if (MColumn.getColumn_ID(MTable.getTableName(ctx, AD_Table_ID), "Posted") <= 0) {
            return null;
        }
        String error = null;
        if (log.isLoggable(Level.INFO)) {
            log.info("Table=" + AD_Table_ID + ", Record=" + Record_ID);
        }
        MAcctSchema[] ass = MAcctSchema.getClientAcctSchema(ctx, AD_Client_ID);
        error = Doc.postImmediate(ass, AD_Table_ID, Record_ID, force, trxName);
        return error;
    }

    public static boolean processIt(DocAction doc, String processAction) {
        boolean success = false;
        DocumentEngine engine = new DocumentEngine(doc, doc.getDocStatus());
        success = engine.processIt(processAction, doc.getDocAction());
        return success;
    }

    public static void readStatusReferenceList(ArrayList<String> v_value, ArrayList<String> v_name, ArrayList<String> v_description) {
        block10: {
            if (v_value == null) {
                throw new IllegalArgumentException("v_value parameter is null");
            }
            if (v_name == null) {
                throw new IllegalArgumentException("v_name parameter is null");
            }
            if (v_description == null) {
                throw new IllegalArgumentException("v_description parameter is null");
            }
            Object sql = Env.isBaseLanguage(Env.getCtx(), "AD_Ref_List") ? "SELECT Value, Name, Description FROM AD_Ref_List WHERE AD_Reference_ID=? ORDER BY Name" : "SELECT l.Value, t.Name, t.Description FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "' AND l.AD_Reference_ID=? ORDER BY t.Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, 131);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        String value = rs.getString(1);
                        String name = rs.getString(2);
                        String description = rs.getString(3);
                        if (description == null) {
                            description = "";
                        }
                        v_value.add(value);
                        v_name.add(name);
                        v_description.add(description);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, (String)sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

