/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MDepositBatch;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_DepositBatchLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MDepositBatchLine
extends X_C_DepositBatchLine {
    private static final long serialVersionUID = -4461960512392850996L;

    public MDepositBatchLine(Properties ctx, String C_DepositBatchLine_UU, String trxName) {
        super(ctx, C_DepositBatchLine_UU, trxName);
        if (Util.isEmpty(C_DepositBatchLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MDepositBatchLine(Properties ctx, int C_DepositBatchLine_ID, String trxName) {
        super(ctx, C_DepositBatchLine_ID, trxName);
        if (C_DepositBatchLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setPayAmt(Env.ZERO);
    }

    public MDepositBatchLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDepositBatchLine(MDepositBatch statement) {
        this(statement.getCtx(), 0, statement.get_TrxName());
        this.setClientOrg(statement);
        this.setC_DepositBatch_ID(statement.getC_DepositBatch_ID());
    }

    public MDepositBatchLine(MDepositBatch statement, int lineNo) {
        this(statement);
        this.setLine(lineNo);
    }

    public void setPayment(MPayment payment) {
        this.setC_Payment_ID(payment.getC_Payment_ID());
        BigDecimal amt = payment.getPayAmt(true);
        this.setPayAmt(amt);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String sql;
        MDepositBatch parent = new MDepositBatch(this.getCtx(), this.getC_DepositBatch_ID(), this.get_TrxName());
        if (newRecord && parent.isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_DepositBatch_ID"));
            return false;
        }
        if (this.getLine() == 0) {
            sql = "SELECT COALESCE(MAX(Line),0)+10 AS DefaultValue FROM C_DepositBatchLine WHERE C_DepositBatch_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getC_DepositBatch_ID());
            this.setLine(ii);
        }
        if (this.getC_Payment_ID() != 0) {
            sql = "UPDATE C_Payment p SET C_DepositBatch_ID=? WHERE p.C_Payment_ID=?";
            DB.executeUpdateEx(sql, new Object[]{this.getC_DepositBatch_ID(), this.getC_Payment_ID()}, this.get_TrxName());
            MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
            this.setPayment(payment);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        this.updateHeader();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        this.updateHeader();
        if (this.getC_Payment_ID() != 0) {
            String sql = "UPDATE C_Payment p SET C_DepositBatch_ID= Null WHERE p.C_Payment_ID=?";
            DB.executeUpdateEx(sql, new Object[]{this.getC_Payment_ID()}, this.get_TrxName());
        }
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE C_DepositBatch dp SET DepositAmt=(SELECT COALESCE(SUM(PayAmt),0) FROM C_DepositBatchLine dpl WHERE dpl.C_DepositBatch_ID=dp.C_DepositBatch_ID AND dpl.IsActive='Y') WHERE C_DepositBatch_ID=?";
        DB.executeUpdateEx(sql, new Object[]{this.getC_DepositBatch_ID()}, this.get_TrxName());
    }
}

