/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MProcessPara;
import org.compiere.model.MWarehouse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

@Process
public class InventoryValue
extends SvrProcess {
    private int p_M_PriceList_Version_ID;
    private Timestamp p_DateValue;
    private int[] p_M_Warehouse_IDs;
    private int p_C_Currency_ID;
    private int p_M_CostElement_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_PriceList_Version_ID")) {
                    this.p_M_PriceList_Version_ID = para[i].getParameterAsInt();
                } else if (name.equals("DateValue")) {
                    this.p_DateValue = (Timestamp)para[i].getParameter();
                } else if (name.equals("M_Warehouse_IDs")) {
                    this.p_M_Warehouse_IDs = para[i].getParameterAsIntArray();
                } else if (name.equals("C_Currency_ID")) {
                    this.p_C_Currency_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_CostElement_ID")) {
                    this.p_M_CostElement_ID = para[i].getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        if (this.p_DateValue == null) {
            this.p_DateValue = new Timestamp(System.currentTimeMillis());
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("M_Warehouse_IDs=" + Arrays.toString(this.p_M_Warehouse_IDs) + ",C_Currency_ID=" + this.p_C_Currency_ID + ",DateValue=" + String.valueOf(this.p_DateValue) + ",M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID + ",M_CostElement_ID=" + this.p_M_CostElement_ID);
        }
        int no = DB.executeUpdateEx((String)"DELETE FROM T_InventoryValue WHERE AD_PInstance_ID=?", (Object[])new Object[]{this.getAD_PInstance_ID()}, (String)this.get_TrxName());
        MClient c = MClient.get((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        MAcctSchema as = c.getAcctSchema();
        Object msg = "";
        if (this.p_M_Warehouse_IDs == null) {
            this.p_M_Warehouse_IDs = DB.getIDsEx((String)this.get_TrxName(), (String)"SELECT M_Warehouse_ID FROM M_Warehouse WHERE AD_Client_ID=? AND IsActive='Y'", (Object[])new Object[]{this.getAD_Client_ID()});
        }
        int[] nArray = this.p_M_Warehouse_IDs;
        int n = this.p_M_Warehouse_IDs.length;
        int n2 = 0;
        while (n2 < n) {
            int l_M_Warehouse_ID = nArray[n2];
            MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)l_M_Warehouse_ID);
            int noInsertStd = DB.executeUpdateEx((String)"INSERT INTO T_InventoryValue (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, AD_Client_ID, AD_Org_ID, CostStandard, T_InventoryValue_UU) SELECT ? , w.M_Warehouse_ID, c.M_Product_ID, c.M_AttributeSetInstance_ID, w.AD_Client_ID, w.AD_Org_ID, c.CurrentCostPrice, generate_UUID() FROM M_Warehouse w INNER JOIN AD_ClientInfo ci ON (w.AD_Client_ID=ci.AD_Client_ID) INNER JOIN C_AcctSchema acs ON (ci.C_AcctSchema1_ID=acs.C_AcctSchema_ID) INNER JOIN M_Cost c ON (acs.C_AcctSchema_ID=c.C_AcctSchema_ID AND acs.M_CostType_ID=c.M_CostType_ID AND c.AD_Org_ID IN (0, w.AD_Org_ID)) INNER JOIN M_CostElement ce ON (c.M_CostElement_ID=ce.M_CostElement_ID AND ce.CostingMethod='S' AND ce.CostElementType='M') WHERE w.M_Warehouse_ID=?", (Object[])new Object[]{this.getAD_PInstance_ID(), l_M_Warehouse_ID}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Inserted Std=" + noInsertStd);
            }
            int noInsertCost = 0;
            if (this.p_M_CostElement_ID != 0) {
                noInsertCost = DB.executeUpdateEx((String)"INSERT INTO T_InventoryValue (AD_PInstance_ID, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, AD_Client_ID, AD_Org_ID, CostStandard, Cost, M_CostElement_ID, T_InventoryValue_UU) SELECT ?, w.M_Warehouse_ID, c.M_Product_ID, c.M_AttributeSetInstance_ID, w.AD_Client_ID, w.AD_Org_ID, 0, c.CurrentCostPrice, c.M_CostElement_ID, generate_UUID() FROM M_Warehouse w INNER JOIN AD_ClientInfo ci ON (w.AD_Client_ID=ci.AD_Client_ID) INNER JOIN C_AcctSchema acs ON (ci.C_AcctSchema1_ID=acs.C_AcctSchema_ID) INNER JOIN M_Cost c ON (acs.C_AcctSchema_ID=c.C_AcctSchema_ID AND acs.M_CostType_ID=c.M_CostType_ID AND c.AD_Org_ID IN (0, w.AD_Org_ID)) WHERE w.M_Warehouse_ID=? AND c.M_CostElement_ID=? AND NOT EXISTS (SELECT * FROM T_InventoryValue iv WHERE iv.AD_PInstance_ID=? AND iv.M_Warehouse_ID=w.M_Warehouse_ID AND iv.M_Product_ID=c.M_Product_ID AND iv.M_AttributeSetInstance_ID=c.M_AttributeSetInstance_ID)".toString(), (Object[])new Object[]{this.getAD_PInstance_ID(), l_M_Warehouse_ID, this.p_M_CostElement_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Inserted Cost=" + noInsertCost);
                }
                int noUpdatedCost = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET (Cost, M_CostElement_ID)=(SELECT c.CurrentCostPrice, c.M_CostElement_ID FROM M_Warehouse w INNER JOIN AD_ClientInfo ci ON (w.AD_Client_ID=ci.AD_Client_ID) INNER JOIN C_AcctSchema acs ON (ci.C_AcctSchema1_ID=acs.C_AcctSchema_ID) INNER JOIN M_Cost c ON (acs.C_AcctSchema_ID=c.C_AcctSchema_ID AND acs.M_CostType_ID=c.M_CostType_ID AND c.AD_Org_ID IN (0, w.AD_Org_ID)) WHERE c.M_CostElement_ID=? AND iv.M_Warehouse_ID=w.M_Warehouse_ID AND iv.M_Product_ID=c.M_Product_ID AND iv.AD_PInstance_ID=?  AND iv.M_AttributeSetInstance_ID=c.M_AttributeSetInstance_ID) WHERE M_Warehouse_ID=? AND EXISTS (SELECT * FROM T_InventoryValue ivv WHERE ivv.AD_PInstance_ID=? AND ivv.M_CostElement_ID IS NULL AND ivv.M_Warehouse_ID=?)", (Object[])new Object[]{this.p_M_CostElement_ID, this.getAD_PInstance_ID(), l_M_Warehouse_ID, this.getAD_PInstance_ID(), l_M_Warehouse_ID}, (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Updated Cost=" + noUpdatedCost);
                }
            }
            if (noInsertStd + noInsertCost == 0) {
                return "No Costs found in warehouse " + wh.getName();
            }
            Timestamp l_DateValue = new Timestamp(TimeUtil.addDays((Timestamp)TimeUtil.getDay((Timestamp)this.p_DateValue), (int)1).getTime() - 1L);
            no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue SET DateValue=?,M_PriceList_Version_ID=?,C_Currency_ID=? WHERE AD_PInstance_ID=? AND M_Warehouse_ID=?".toString(), (Object[])new Object[]{l_DateValue, this.p_M_PriceList_Version_ID, this.p_C_Currency_ID, this.getAD_PInstance_ID(), l_M_Warehouse_ID}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Constants=" + no);
            }
            no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET QtyOnHand = (SELECT SUM(QtyOnHand) FROM M_StorageOnHand s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE iv.M_Product_ID=s.M_Product_ID AND iv.M_Warehouse_ID=l.M_Warehouse_ID AND iv.M_AttributeSetInstance_ID=s.M_AttributeSetInstance_ID) WHERE M_Warehouse_ID=? AND AD_PInstance_ID=? AND iv.M_AttributeSetInstance_ID<>0", (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("QtHand with ASI=" + no);
            }
            no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET QtyOnHand = (SELECT SUM(QtyOnHand) FROM M_StorageOnHand s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) WHERE iv.M_Product_ID=s.M_Product_ID AND iv.M_Warehouse_ID=l.M_Warehouse_ID) WHERE iv.M_Warehouse_ID=? AND iv.AD_PInstance_ID=? AND iv.M_AttributeSetInstance_ID=0", (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("QtHand w/o ASI=" + no);
            }
            no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET QtyOnHand=(SELECT iv.QtyOnHand - NVL(SUM(t.MovementQty), 0) FROM M_Transaction t INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE t.M_Product_ID=iv.M_Product_ID AND t.M_AttributeSetInstance_ID=iv.M_AttributeSetInstance_ID AND t.MovementDate > iv.DateValue AND l.M_Warehouse_ID=iv.M_Warehouse_ID) WHERE iv.M_AttributeSetInstance_ID<>0 AND iv.M_Warehouse_ID=? AND iv.AD_PInstance_ID=?", (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Update with ASI=" + no);
            }
            no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET QtyOnHand=(SELECT iv.QtyOnHand - NVL(SUM(t.MovementQty), 0) FROM M_Transaction t INNER JOIN M_Locator l ON (t.M_Locator_ID=l.M_Locator_ID) WHERE t.M_Product_ID=iv.M_Product_ID AND t.MovementDate > iv.DateValue AND l.M_Warehouse_ID=iv.M_Warehouse_ID) WHERE iv.M_AttributeSetInstance_ID=0 AND iv.M_Warehouse_ID=? AND iv.AD_PInstance_ID=?", (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Update w/o ASI=" + no);
            }
            int noQty = DB.executeUpdateEx((String)"DELETE FROM T_InventoryValue WHERE (QtyOnHand=0 OR QtyOnHand IS NULL) AND M_Warehouse_ID=? AND AD_PInstance_ID=?", (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("NoQty Deleted=" + noQty);
            }
            if ((no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET PricePO = (SELECT MAX(currencyConvert (po.PriceList,po.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, po.AD_Client_ID,po.AD_Org_ID)) FROM M_Product_PO po WHERE po.M_Product_ID=iv.M_Product_ID AND po.IsCurrentVendor='Y'), PriceList = (SELECT currencyConvert(pp.PriceList,pl.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), PriceStd = (SELECT currencyConvert(pp.PriceStd,pl.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID), PriceLimit = (SELECT currencyConvert(pp.PriceLimit,pl.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, pl.AD_Client_ID,pl.AD_Org_ID) FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pp.M_Product_ID=iv.M_Product_ID AND pp.M_PriceList_Version_ID=iv.M_PriceList_Version_ID AND pp.M_PriceList_Version_ID=plv.M_PriceList_Version_ID AND plv.M_PriceList_ID=pl.M_PriceList_ID) WHERE iv.M_Warehouse_ID=? AND iv.AD_PInstance_ID=?", (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName())) == 0) {
                msg = (String)msg + " / No Prices in warehouse " + wh.getName();
            }
            if (as.getC_Currency_ID() != this.p_C_Currency_ID) {
                no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue iv SET CostStandard= (SELECT currencyConvert(iv.CostStandard,acs.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, iv.AD_Client_ID,iv.AD_Org_ID) FROM C_AcctSchema acs WHERE acs.C_AcctSchema_ID=?),\tCost= (SELECT currencyConvert(iv.Cost,acs.C_Currency_ID,iv.C_Currency_ID,iv.DateValue,null, iv.AD_Client_ID,iv.AD_Org_ID) FROM C_AcctSchema acs WHERE acs.C_AcctSchema_ID=?) WHERE iv.M_Warehouse_ID=? AND iv.AD_PInstance_ID=?", (Object[])new Object[]{as.getC_AcctSchema_ID(), as.getC_AcctSchema_ID(), l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Converted=" + no);
                }
            }
            no = DB.executeUpdateEx((String)"UPDATE T_InventoryValue SET PricePOAmt = QtyOnHand * PricePO, PriceListAmt = QtyOnHand * PriceList, PriceStdAmt = QtyOnHand * PriceStd, PriceLimitAmt = QtyOnHand * PriceLimit, CostStandardAmt = QtyOnHand * CostStandard, CostAmt = QtyOnHand * Cost WHERE M_Warehouse_ID=? AND AD_PInstance_ID=?".toString(), (Object[])new Object[]{l_M_Warehouse_ID, this.getAD_PInstance_ID()}, (String)this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Calculation=" + no);
            }
            ++n2;
        }
        return "@OK@";
    }
}

