/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.SQLException;
import java.util.List;
import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.eevolution.model.MPPProductBOMLine;

@Process
public class UniversalSubstitution
extends SvrProcess {
    int productId = 0;
    int replacementId = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("M_Product_ID")) {
                this.productId = para[i].getParameterAsInt();
            } else if (name.equals("Substitute_ID")) {
                this.replacementId = para[i].getParameterAsInt();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
    }

    protected String doIt() throws SQLException {
        if (this.productId == 0 || this.replacementId == 0) {
            throw new AdempiereException("Product and replacement product required");
        }
        MProduct product = new MProduct(this.getCtx(), this.productId, this.get_TrxName());
        List boms = MPPProductBOMLine.getByProduct((MProduct)product);
        int count = 0;
        for (MPPProductBOMLine bom : boms) {
            bom.setM_Product_ID(this.replacementId);
            bom.saveEx();
            ++count;
        }
        StringBuilder msgreturn = new StringBuilder().append(count).append(" BOM Line products updated");
        return msgreturn.toString();
    }
}

