/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.server.scheduler.model.event;

import java.util.logging.Level;
import org.adempiere.base.event.AbstractEventHandler;
import org.adempiere.base.event.IEventManager;
import org.compiere.model.MScheduler;
import org.compiere.server.AdempiereServerMgr;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.compiere.util.TrxEventListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;

@Component(name="org.adempiere.server.scheduler.model.event.SchedulerModelEventHandler", reference={@Reference(name="eventManager", service=IEventManager.class, bind="bindEventManager", unbind="unbindEventManager", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)})
public class SchedulerModelEventHandler
extends AbstractEventHandler {
    protected void doHandleEvent(Event event) {
        if (event.getTopic().equals("adempiere/po/beforeChange")) {
            final MScheduler scheduler = (MScheduler)this.getPO(event);
            if (scheduler.isActive() && !scheduler.is_new() && scheduler.is_ValueChanged("AD_Schedule_ID")) {
                Trx trx = Trx.get((String)scheduler.get_TrxName(), (boolean)false);
                trx.addTrxEventListener(new TrxEventListener(){

                    public void afterRollback(Trx trx, boolean success) {
                    }

                    public void afterCommit(Trx trx, boolean success) {
                        AdempiereServerMgr serverMgr;
                        if (success && (serverMgr = AdempiereServerMgr.get(false)) != null) {
                            try {
                                String error;
                                int state = serverMgr.getServerStatus(scheduler.getServerID());
                                if (state == 1 && (error = serverMgr.stop(scheduler.getServerID())) == null) {
                                    serverMgr.start(scheduler.getServerID());
                                }
                            }
                            catch (Exception e) {
                                CLogger.getCLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
                            }
                        }
                    }

                    public void afterClose(Trx trx) {
                    }
                });
            }
        } else if (event.getTopic().equals("adempiere/po/afterChange")) {
            AdempiereServerMgr serverMgr;
            MScheduler scheduler = (MScheduler)this.getPO(event);
            if (!scheduler.isActive() && (serverMgr = AdempiereServerMgr.get(false)) != null && serverMgr.getServerInstance(scheduler.getServerID()) != null) {
                serverMgr.removeScheduler(scheduler);
            }
        } else if (event.getTopic().equals("adempiere/po/afterDelete")) {
            MScheduler scheduler = (MScheduler)this.getPO(event);
            AdempiereServerMgr serverMgr = AdempiereServerMgr.get(false);
            if (serverMgr != null && serverMgr.getServerInstance(scheduler.getServerID()) != null) {
                serverMgr.removeScheduler(scheduler);
            }
        }
    }

    protected void initialize() {
        this.registerTableEvent("adempiere/po/beforeChange", "AD_Scheduler");
        this.registerTableEvent("adempiere/po/afterChange", "AD_Scheduler");
        this.registerTableEvent("adempiere/po/afterDelete", "AD_Scheduler");
    }
}

