/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.List;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionPlan;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;
import org.compiere.util.Util;

@Process
public class ProductionCreate
extends SvrProcess {
    private int p_M_Production_ID = 0;
    private MProduction m_production = null;
    private boolean mustBeStocked = false;
    private boolean recreate = false;
    private BigDecimal newQty = null;
    private int p_PP_Product_BOM_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if ("Recreate".equals(name)) {
                this.recreate = "Y".equals(para[i].getParameter());
            } else if ("ProductionQty".equals(name)) {
                this.newQty = (BigDecimal)para[i].getParameter();
            } else if ("PP_Product_BOM_ID".equals(name)) {
                this.p_PP_Product_BOM_ID = para[i].getParameterAsInt();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.p_M_Production_ID = this.getRecord_ID();
        this.m_production = new MProduction(this.getCtx(), this.p_M_Production_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        if (this.m_production.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production header");
        }
        if (this.m_production.isProcessed()) {
            return "Already processed";
        }
        return this.createLines();
    }

    protected String createLines() throws Exception {
        int created = 0;
        if (!this.m_production.isUseProductionPlan()) {
            String msg = this.validateEndProduct(this.m_production.getM_Product_ID());
            if (!Util.isEmpty((String)msg)) {
                throw new AdempiereUserError(msg);
            }
            if (!this.recreate && "Y".equalsIgnoreCase(this.m_production.getIsCreated())) {
                throw new AdempiereUserError("Production already created.");
            }
            if (this.newQty != null) {
                this.m_production.setProductionQty(this.newQty);
            }
            this.m_production.deleteLines(this.get_TrxName());
            created = this.m_production.createLines(this.mustBeStocked, this.p_PP_Product_BOM_ID);
        } else {
            Query planQuery = new Query(this.getCtx(), "M_ProductionPlan", "M_ProductionPlan.M_Production_ID=?", this.get_TrxName());
            List plans = planQuery.setParameters(new Object[]{this.m_production.getM_Production_ID()}).list();
            for (MProductionPlan plan : plans) {
                this.validateEndProduct(plan.getM_Product_ID());
                if (!this.recreate && "Y".equalsIgnoreCase(this.m_production.getIsCreated())) {
                    throw new AdempiereUserError("Production already created.");
                }
                plan.deleteLines(this.get_TrxName());
                int n = plan.createLines(this.mustBeStocked);
                if (n == 0) {
                    return "Failed to create production lines";
                }
                created += n;
            }
        }
        if (created == 0) {
            return "Failed to create production lines";
        }
        this.m_production.setIsCreated("Y");
        this.m_production.save(this.get_TrxName());
        StringBuilder msgreturn = new StringBuilder().append(created).append(" production lines were created");
        return msgreturn.toString();
    }

    private String validateEndProduct(int M_Product_ID) throws Exception {
        MProduction production = new MProduction(Env.getCtx(), 0, this.get_TrxName());
        return production.validateEndProduct(M_Product_ID);
    }
}

