/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

public class Accordion
extends Borderlayout
implements EventListener<Event> {
    private static final long serialVersionUID = 5898232602746332810L;
    private Vbox southBox;
    private Vbox northBox;
    private List<String> labelList = new ArrayList<String>();
    private List<Div> headerList = new ArrayList<Div>();
    private List<Component> componentList = new ArrayList<Component>();
    private int selectedIndex = -1;

    public Accordion() {
        North north = new North();
        this.appendChild((Component)north);
        this.northBox = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.northBox, "100%");
        north.appendChild((Component)this.northBox);
        north.setSplittable(false);
        north.setCollapsible(false);
        Center center = new Center();
        this.appendChild((Component)center);
        South south = new South();
        this.appendChild((Component)south);
        this.southBox = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.southBox, "100%");
        south.appendChild((Component)this.southBox);
        south.setSplittable(false);
        south.setCollapsible(false);
    }

    public void add(Component component, String label) {
        ToolBarButton button = new ToolBarButton();
        button.setLabel(label);
        button.addEventListener("onClick", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)button, "100%");
        Div div = new Div();
        div.setClass("z-center-header");
        div.appendChild((Component)button);
        this.northBox.appendChild((Component)div);
        this.labelList.add(label);
        this.headerList.add(div);
        this.componentList.add(component);
    }

    public void setLabel(int index, String label) {
        this.labelList.set(index, label);
        ((ToolBarButton)this.headerList.get(index).getFirstChild()).setLabel(label);
        if (this.selectedIndex == index) {
            this.getCenter().setTitle(label);
        }
    }

    public void onEvent(Event event) throws Exception {
        ToolBarButton button;
        String label;
        int index;
        if ("onClick".equals(event.getName()) && event.getTarget() instanceof ToolBarButton && (index = this.labelList.indexOf(label = (button = (ToolBarButton)event.getTarget()).getLabel())) >= 0) {
            this.setSelectedIndex(index);
        }
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.render(index);
    }

    private void render(int index) {
        this.northBox.getChildren().clear();
        this.southBox.getChildren().clear();
        this.getCenter().getChildren().clear();
        int i = 0;
        while (i < index) {
            this.northBox.appendChild((Component)this.headerList.get(i));
            ++i;
        }
        this.getCenter().setTitle(this.labelList.get(index));
        this.getCenter().appendChild(this.componentList.get(index));
        i = index + 1;
        while (i < this.labelList.size()) {
            this.southBox.appendChild((Component)this.headerList.get(i));
            ++i;
        }
        this.invalidate();
    }

    public void setTooltiptext(int index, String tooltiptext) {
        this.headerList.get(index).setTooltiptext(tooltiptext);
    }

    public Div getHeader(int index) {
        return this.headerList.get(index);
    }
}

