/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.web;

import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.adempiere.base.sso.ISSOPrincipalService;
import org.adempiere.base.sso.SSOUtils;
import org.apache.commons.codec.binary.Base64;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class AdempiereMonitorFilter
implements Filter {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static final String AUTHORIZATION = "AdempiereAuthorization";
    private Long m_authorization = System.currentTimeMillis();

    public void init(FilterConfig config) throws ServletException {
        this.log.info("");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String errorPage = "/error.html";
        boolean pass = false;
        try {
            if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                request.getRequestDispatcher(errorPage).forward(request, response);
                return;
            }
            boolean isSSOEnable = MSysConfig.getBooleanValue((String)"ENABLE_SSO_IDEMPIERE_MONITOR", (boolean)false);
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            boolean isRedirectToLoginOnError = false;
            ISSOPrincipalService m_SSOPrincipal = null;
            if (isSSOEnable) {
                try {
                    m_SSOPrincipal = SSOUtils.getSSOPrincipalService();
                    if (m_SSOPrincipal != null) {
                        if (m_SSOPrincipal.hasAuthenticationCode(req, resp)) {
                            String currentUri = req.getRequestURL().toString();
                            m_SSOPrincipal.getAuthenticationToken(req, resp, "SSO_MODE_MONITOR");
                            if (!resp.isCommitted()) {
                                resp.sendRedirect(currentUri);
                            }
                        } else if (!m_SSOPrincipal.isAuthenticated(req, resp)) {
                            m_SSOPrincipal.redirectForAuthentication(req, resp, "SSO_MODE_MONITOR");
                            return;
                        }
                        if (this.checkSSOAuthorization(m_SSOPrincipal, req.getSession().getAttribute("sso.principal.token"))) {
                            chain.doFilter(request, response);
                            return;
                        }
                    }
                    req.getSession().removeAttribute("sso.principal.token");
                }
                catch (Throwable exc) {
                    this.log.log(Level.SEVERE, "Exception while authenticating: ", exc);
                    if (m_SSOPrincipal != null) {
                        m_SSOPrincipal.removePrincipalFromSession(req);
                    }
                    if (isRedirectToLoginOnError) {
                        resp.sendRedirect("idempiereMonitor");
                    } else {
                        resp.setStatus(500);
                        response.setContentType("text/html");
                        response.getWriter().append(SSOUtils.getCreateErrorResponce((String)exc.getLocalizedMessage()));
                    }
                    return;
                }
            }
            if (m_SSOPrincipal == null || !isSSOEnable) {
                HttpSession session = req.getSession(true);
                Long compare = (Long)session.getAttribute(AUTHORIZATION);
                if (compare != null && compare.compareTo(this.m_authorization) == 0) {
                    pass = true;
                } else if (this.checkAuthorization(req.getHeader("Authorization"))) {
                    session.setAttribute(AUTHORIZATION, (Object)this.m_authorization);
                    pass = true;
                }
                if (pass) {
                    chain.doFilter(request, response);
                } else {
                    resp.setStatus(401);
                    resp.setHeader("WWW-Authenticate", "BASIC realm=\"Adempiere Server\"");
                }
            }
            return;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "filter", (Throwable)e);
            request.getRequestDispatcher(errorPage).forward(request, response);
            return;
        }
    }

    private boolean checkSSOAuthorization(ISSOPrincipalService principalService, Object token) {
        if (token == null) {
            return false;
        }
        try {
            String username = principalService.getUserName(token);
            return this.validateUser(username, null, true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "check", (Throwable)e);
            return false;
        }
    }

    private boolean checkAuthorization(String authorization) {
        if (authorization == null) {
            return false;
        }
        try {
            String userInfo = authorization.substring(6).trim();
            Base64 decoder = new Base64();
            String namePassword = new String(decoder.decode(userInfo.getBytes()));
            int index = namePassword.indexOf(58);
            String name = namePassword.substring(0, index);
            String password = namePassword.substring(index + 1);
            return this.validateUser(name, password, false);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "check", (Throwable)e);
            return false;
        }
    }

    private boolean validateUser(String name, String password, boolean isSSO) {
        MUser user = MUser.get((Properties)Env.getCtx(), (String)name, (String)password, (boolean)isSSO);
        if (user == null) {
            this.log.warning("User not found: '" + name);
            return false;
        }
        if (!user.isAdministrator() && !user.hasURLFormAccess("/idempiereMonitor")) {
            this.log.warning("User doesn't have access to /idempiereMonitor = " + name);
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Name=" + name);
        }
        return true;
    }

    public void destroy() {
        this.log.info("");
    }
}

