/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.part;

import java.util.List;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.apps.ProcessDialog;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.part.AbstractUIPart;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.ZkReportViewer;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SwipeEvent;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Style;
import org.zkoss.zul.Tab;

public class WindowContainer
extends AbstractUIPart
implements EventListener<Event> {
    private static final String OPTION_CLOSE = "Close";
    private static final String OPTION_CLOSE_OTHER_WINDOWS = "CloseOtherWindows";
    private static final String OPTION_CLOSE_WINDOWS_TO_THE_LEFT = "CloseWindowsToTheLeft";
    private static final String OPTION_CLOSE_WINDOWS_TO_THE_RIGHT = "CloseWindowsToTheRight";
    private static final String OPTION_CLOSE_ALL_WINDOWS = "CloseAllWindows";
    public static final String ON_MOBILE_SET_SELECTED_TAB = "onMobileSetSelectedTab";
    private static final String ON_AFTER_TAB_CLOSE = "onAfterTabClose";
    private static final String ON_DEFER_SET_SELECTED_TAB = "onDeferSetSelectedTab";
    public static final String ON_WINDOW_CONTAINER_SELECTION_CHANGED_EVENT = "onWindowContainerSelectionChanged";
    public static final String DEFER_SET_SELECTED_TAB = "deferSetSelectedTab";
    private static final int DEFAULT_MAX_TITLE_LENGTH = 30;
    public static final String REPLACE_WINDOW_NO = "replaceWindowNo";
    private Tabbox tabbox;
    private ToolBar toolbar;
    private ToolBarButton tabListBtn;

    public static WindowContainer createFrom(Tabbox tb) {
        WindowContainer wc = new WindowContainer();
        wc.tabbox = tb;
        return wc;
    }

    @Override
    protected Component doCreatePart(Component parent) {
        if (this.isDesktopAutoShrinkTabTitle()) {
            Style style = new Style();
            style.setContent(".desktop-tabbox > .z-tabs > .z-tabs-content {display:flex;width: auto !important;} .desktop-tabbox > .z-tabs > .z-tabs-content > .z-tab {text-overflow: ellipsis;flex-shrink: 1;flex-basis: auto;min-width: 70px;} .desktop-tabbox.z-tabbox > .z-tabbox-icon.z-tabbox-left-scroll,.desktop-tabbox.z-tabbox > .z-tabbox-icon.z-tabbox-right-scroll {color:transparent;border:none;background:none;width:0px;} .desktop-tabbox.z-tabbox-scroll > .z-tabs {margin:0px;} ");
            parent.getParent().getParent().appendChild((Component)style);
        }
        this.tabbox = new Tabbox();
        this.tabbox.addEventListener("onPageAttached", this);
        this.tabbox.addEventListener("onPageDetached", this);
        this.tabbox.setSupportTabDragDrop(!this.isMobile());
        this.tabbox.setActiveBySeq(true);
        this.tabbox.setCheckVisibleOnlyForNextActive(!this.isMobile());
        this.tabbox.setSclass("desktop-tabbox");
        this.tabbox.setId("desktop_tabbox");
        this.tabbox.setMaximalHeight(true);
        this.tabbox.addEventListener(ON_DEFER_SET_SELECTED_TAB, (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)event.getData());
                if (tab != null) {
                    WindowContainer.this.setSelectedTab(tab);
                }
            }
        });
        this.tabbox.addEventListener(ON_AFTER_TAB_CLOSE, evt -> {
            if (this.isMobile()) {
                this.updateMobileTabState(this.tabbox.getSelectedTab());
            }
            if (this.isShowTabList()) {
                this.updateTabListButton();
            }
        });
        Tabpanels tabpanels = new Tabpanels();
        Tabs tabs = new Tabs();
        if (!this.isMobile()) {
            StringBuilder f = new StringBuilder();
            f.append("function(way, tb) {\n").append("  let tabbox = this.getTabbox();let tabs = this.$n();\n").append("  this.$_scrollcheck(way,tb);\n").append("  if (tabs && !tabbox.isVertical() && !tabbox.inAccordionMold()) {\n").append("    this.__offsetWidth=tabs.offsetWidth;this.__scrollLeft=tabs.scrollLeft;\n").append("    this.__selectedIndex=tabbox.getSelectedIndex();\n").append("    this.__selectedTab=tabbox.getSelectedTab();\n").append("  } else {\n").append("    this.__offsetWidth=this.__scrollLeft==0;this.__selectedTab=null;this.__selectedIndex=-1;\n").append("  }\n").append("}");
            tabs.setWidgetOverride("_scrollcheck", f.toString());
            f = new StringBuilder();
            f.append("function (toSel) {\n").append("  let tabbox = this.getTabbox();\n").append("  let tabs = this.$n();\n").append("  let tabsOffsetWidth=tabs.offsetWidth;\n").append("  this.$_fixWidth(toSel);\n").append("  if(this.__selectedTab && this.__selectedTab == tabbox.getSelectedTab() && this.__selectedIndex == tabbox.getSelectedIndex()) {\n").append("    if(tabs.offsetWidth == this.__offsetWidth) {\n").append("      if(tabsOffsetWidth != this.__offsetWidth && tabs.scrollLeft != this.__scrollLeft) {\n").append("        this._fixTabsScrollLeft(this.__scrollLeft);\n").append("      }\n").append("    }\n").append("  }\n").append("}");
            tabs.setWidgetOverride("_fixWidth", f.toString());
            f = new StringBuilder();
            f.append("function (to, move) {\n").append("  if (move <= 0) return;\n").append("  let self=this,tabs = this.$n();\n").append("  switch (to) {\n").append("  case 'right':\n").append("    self._fixTabsScrollLeft(self._tabsScrollLeft + move);break;").append("  case 'left':\n").append("    self._fixTabsScrollLeft(self._tabsScrollLeft - move);break;").append("  case 'up':\n").append("    self._fixTabsScrollTop(self._tabsScrollTop - move);break;").append("  default:\n").append("    self._fixTabsScrollTop(self._tabsScrollTop + move);\n").append("  }\n").append("  let tabsScrollLeft = self._tabsScrollLeft, tabsScrollTop = self._tabsScrollTop;\n").append("  self._fixTabsScrollLeft(tabsScrollLeft <= 0 ? 0 : tabsScrollLeft);\n").append("  self._fixTabsScrollTop(tabsScrollTop <= 0 ? 0 : tabsScrollTop);\n").append("}");
            tabs.setWidgetOverride("_doScroll", f.toString());
        }
        this.tabbox.appendChild((Component)tabs);
        this.tabbox.appendChild((Component)tabpanels);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbox, "1");
        this.tabbox.setParent(parent);
        this.toolbar = new ToolBar();
        this.toolbar.setSclass("window-container-toolbar");
        this.tabbox.appendChild((Component)this.toolbar);
        if (this.isShowHomeButton()) {
            ToolBarButton homeButton = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                homeButton.setIconSclass("z-icon-Home");
            } else {
                homeButton.setImage(ThemeManager.getThemeResource("images/Home16.png"));
            }
            homeButton.setSclass("window-container-toolbar-btn");
            homeButton.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Home")));
            homeButton.addEventListener("onClick", evt -> this.setSelectedTab(this.tabbox.getTabpanel(0).getLinkedTab()));
            this.toolbar.appendChild((Component)homeButton);
        }
        if (this.isShowTabList()) {
            this.tabListBtn = new ToolBarButton();
            if (ThemeManager.isUseFontIconForImage()) {
                this.tabListBtn.setIconSclass("z-icon-Expand");
            } else {
                this.tabListBtn.setImage(ThemeManager.getThemeResource("images/expand-header.png"));
            }
            this.tabListBtn.setSclass("window-container-toolbar-btn tab-list");
            this.tabListBtn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ShowAllWindow")) + "   Alt+W");
            this.tabListBtn.addEventListener("onClick", evt -> this.showTabList());
            this.tabListBtn.setVisible(false);
            this.toolbar.appendChild((Component)this.tabListBtn);
        }
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", e -> this.onCtrlKey((KeyEvent)e));
        return this.tabbox;
    }

    private void onCtrlKey(KeyEvent e) {
        if (e.isAltKey() && !e.isCtrlKey() && !e.isShiftKey() && e.getKeyCode() == 87 && this.tabListBtn != null && this.tabListBtn.isVisible()) {
            Events.postEvent((String)"onClick", (Component)this.tabListBtn, null);
        }
    }

    private boolean isShowHomeButton() {
        return this.isMobile() || this.isDesktopShowHomeButton();
    }

    private boolean isDesktopShowHomeButton() {
        return MSysConfig.getBooleanValue((String)"ZK_DESKTOP_SHOW_HOME_BUTTON", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    private boolean isShowTabList() {
        return this.isMobile() || this.isDesktopAutoShrinkTabTitle() || this.isDesktopShowTabList();
    }

    private boolean isDesktopShowTabList() {
        return MSysConfig.getBooleanValue((String)"ZK_DESKTOP_SHOW_TAB_LIST_BUTTON", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    private boolean isDesktopAutoShrinkTabTitle() {
        return MSysConfig.getBooleanValue((String)"ZK_DESKTOP_TAB_AUTO_SHRINK_TO_FIT", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    private void showTabList() {
        org.zkoss.zul.Tabs tabs = this.tabbox.getTabs();
        List list = tabs.getChildren();
        Menupopup popup = new Menupopup();
        int i = 1;
        while (i < list.size()) {
            org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)list.get(i));
            Menuitem item = new Menuitem(tab.getLabel().endsWith("...") && !Util.isEmpty((String)tab.getTooltiptext(), (boolean)true) ? tab.getTooltiptext() : tab.getLabel());
            item.setValue(Integer.toString(i));
            if (!Util.isEmpty((String)tab.getTooltiptext(), (boolean)true) && !item.getLabel().equals(tab.getTooltiptext())) {
                item.setTooltiptext(tab.getTooltiptext());
            }
            if (i == this.tabbox.getSelectedIndex()) {
                item.setSclass("selected");
            }
            popup.appendChild((Component)item);
            item.addEventListener("onClick", evt -> {
                Menuitem t = (Menuitem)evt.getTarget();
                String s = t.getValue();
                Integer ti = Integer.parseInt(s);
                this.setSelectedTab(this.tabbox.getTabpanel(ti).getLinkedTab());
            });
            ++i;
        }
        popup.setPage(this.tabbox.getPage());
        popup.open((Component)this.tabListBtn, "after_start");
    }

    @Deprecated(forRemoval=true, since="11")
    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable) {
        return this.addWindow(comp, title, closeable, true, null);
    }

    @Deprecated(forRemoval=true, since="11")
    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable, boolean enable) {
        return this.addWindow(comp, title, closeable, true, null);
    }

    @Deprecated(forRemoval=true, since="11")
    public org.adempiere.webui.component.Tab insertBefore(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable) {
        return this.insertBefore(refTab, comp, title, closeable, enable, null);
    }

    @Deprecated(forRemoval=true, since="11")
    public org.adempiere.webui.component.Tab insertAfter(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable) {
        return this.insertAfter(refTab, comp, title, closeable, enable, null);
    }

    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable, Tab.DecorateInfo decorateInfo) {
        return this.addWindow(comp, title, closeable, true, decorateInfo);
    }

    public org.adempiere.webui.component.Tab addWindow(Component comp, String title, boolean closeable, boolean enable, Tab.DecorateInfo decorateInfo) {
        return this.insertBefore(null, comp, title, closeable, enable, decorateInfo);
    }

    public org.adempiere.webui.component.Tab insertBefore(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable, Tab.DecorateInfo decorateInfo) {
        Menuitem mi;
        final Menupopup popupClose = new Menupopup();
        final org.adempiere.webui.component.Tab tab = new org.adempiere.webui.component.Tab(){
            private static final long serialVersionUID = 2387473442130217806L;

            @Override
            public void close() {
                super.close();
                popupClose.detach();
                popupClose.removeEventListener("onOpen", WindowContainer.this);
            }

            public void onPageDetached(Page page) {
                super.onPageDetached(page);
                if (WindowContainer.this.tabbox != null && WindowContainer.this.tabbox.getPage() != null) {
                    Events.postEvent((String)WindowContainer.ON_AFTER_TAB_CLOSE, (Component)WindowContainer.this.tabbox, null);
                }
            }
        };
        popupClose.addEventListener("onOpen", this);
        popupClose.setAttribute("tab", (Object)tab);
        tab.setDecorateInfo(decorateInfo);
        if (title != null) {
            this.setTabTitle(title, tab);
        }
        tab.setClosable(closeable);
        tab.addEventListener("onSwipe", (EventListener)new EventListener<SwipeEvent>(){

            public void onEvent(SwipeEvent event) throws Exception {
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)event.getTarget();
                if (ClientInfo.isMobile() && tab.isClosable() && ("right".equals(event.getSwipeDirection()) || "left".equals(event.getSwipeDirection()))) {
                    tab.onClose();
                }
            }
        });
        tab.addEventListener("onSelect", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)event.getTarget();
                org.zkoss.zul.Tabpanel panel = tab.getLinkedPanel();
                if (panel == null) {
                    return;
                }
                Component component = panel.getFirstChild();
                if (component != null && component.getAttribute("TabOnSelectHandler") instanceof ITabOnSelectHandler) {
                    ITabOnSelectHandler handler = (ITabOnSelectHandler)component.getAttribute("TabOnSelectHandler");
                    handler.onSelect();
                }
                if (component instanceof IHelpContext) {
                    Events.sendEvent((Event)new Event(WindowContainer.ON_WINDOW_CONTAINER_SELECTION_CHANGED_EVENT, component));
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
            }
        });
        if (ClientInfo.isMobile()) {
            tab.setClientAttribute("onselectstart", "return false");
        }
        Tabpanel tabpanel = null;
        if (comp instanceof Tabpanel) {
            tabpanel = (Tabpanel)comp;
        } else {
            tabpanel = new Tabpanel();
            tabpanel.appendChild(comp);
        }
        ZKUpdateUtil.setHeight((HtmlBasedComponent)tabpanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)tabpanel, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)tabpanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)tabpanel, "1");
        tabpanel.setSclass("desktop-tabpanel");
        if (refTab == null) {
            this.tabbox.getTabs().appendChild((Component)tab);
            this.tabbox.getTabpanels().appendChild((Component)tabpanel);
        } else {
            org.zkoss.zul.Tabpanel refpanel = refTab.getLinkedPanel();
            this.tabbox.getTabs().insertBefore((Component)tab, (Component)refTab);
            this.tabbox.getTabpanels().insertBefore((Component)tabpanel, (Component)refpanel);
        }
        if (enable) {
            Boolean b = (Boolean)comp.getAttribute(DEFER_SET_SELECTED_TAB);
            if (b != null && b.booleanValue()) {
                Events.echoEvent((String)ON_DEFER_SET_SELECTED_TAB, (Component)this.tabbox, (Object)((Object)tab));
            } else {
                this.setSelectedTab(tab);
            }
        }
        if (tab.getIndex() != 0) {
            mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)OPTION_CLOSE));
            mi.setAttribute("option", (Object)OPTION_CLOSE);
            popupClose.appendChild((Component)mi);
            mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int currentTabIndex;
                    int focusTabIndex = currentTabIndex = tab.getIndex();
                    int tabsSizeBeforeClose = WindowContainer.this.tabbox.getTabs().getChildren().size();
                    if (tabsSizeBeforeClose == currentTabIndex + 1) {
                        focusTabIndex = currentTabIndex - 1;
                    }
                    WindowContainer.this.closeTabs(tab, currentTabIndex, currentTabIndex, focusTabIndex);
                }
            });
            mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)OPTION_CLOSE_OTHER_WINDOWS));
            mi.setAttribute("option", (Object)OPTION_CLOSE_OTHER_WINDOWS);
            popupClose.appendChild((Component)mi);
            mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int currentTabIndex = tab.getIndex();
                    WindowContainer.this.closeTabs(tab, currentTabIndex + 1, -1, currentTabIndex);
                    int focusTabIndex = 1;
                    WindowContainer.this.closeTabs(tab, 1, currentTabIndex - 1, focusTabIndex);
                }
            });
            mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)OPTION_CLOSE_WINDOWS_TO_THE_LEFT));
            mi.setAttribute("option", (Object)OPTION_CLOSE_WINDOWS_TO_THE_LEFT);
            popupClose.appendChild((Component)mi);
            mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int currentTabIndex = tab.getIndex();
                    int focusTabIndex = 1;
                    WindowContainer.this.closeTabs(tab, 1, currentTabIndex - 1, focusTabIndex);
                }
            });
            mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)OPTION_CLOSE_WINDOWS_TO_THE_RIGHT));
            mi.setAttribute("option", (Object)OPTION_CLOSE_WINDOWS_TO_THE_RIGHT);
            popupClose.appendChild((Component)mi);
            mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    int currentTabIndex = tab.getIndex();
                    WindowContainer.this.closeTabs(tab, currentTabIndex + 1, -1, currentTabIndex);
                }
            });
        }
        mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)OPTION_CLOSE_ALL_WINDOWS));
        mi.setAttribute("option", (Object)OPTION_CLOSE_ALL_WINDOWS);
        popupClose.appendChild((Component)mi);
        mi.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                int focusTabIndex = 0;
                WindowContainer.this.closeTabs(tab, 1, -1, focusTabIndex);
            }
        });
        ZKUpdateUtil.setWidth((HtmlBasedComponent)popupClose, "auto");
        popupClose.setPage(tab.getPage());
        tab.setContext((Popup)popupClose);
        if (this.isShowTabList()) {
            this.updateTabListButton();
        }
        return tab;
    }

    protected void closeTabs(org.adempiere.webui.component.Tab tab, int start, int end, int focus) {
        List tabs = this.tabbox.getTabs().getChildren();
        if (end == -1) {
            end = tabs.size() - 1;
        }
        int i = end;
        while (i >= start) {
            ((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).setSelected(false);
            ((org.adempiere.webui.component.Tab)((Object)tabs.get(i))).onClose();
            --i;
        }
        this.tabbox.setSelectedIndex(focus);
        Events.postEvent((String)ON_AFTER_TAB_CLOSE, (Component)this.tabbox, null);
    }

    private void updateTabListButton() {
        if (this.isShowTabList() && this.tabListBtn != null) {
            int cnt = this.tabbox.getTabs().getChildren().size() - 1;
            if (cnt > 0) {
                this.tabListBtn.setLabel(Integer.toString(cnt));
                this.tabListBtn.setVisible(true);
            } else {
                this.tabListBtn.setLabel("");
                this.tabListBtn.setVisible(false);
            }
        }
    }

    public void setTabTitle(String title, int windowNo) {
        this.setTabTitle(title, this.getTab(windowNo));
    }

    public Tab getTab(int windowNo) {
        org.zkoss.zul.Tabpanels panels = this.tabbox.getTabpanels();
        List childrens = panels.getChildren();
        for (Object child : childrens) {
            Object att;
            Tabpanel panel = (Tabpanel)child;
            Component component = panel.getFirstChild();
            Object object = att = component != null ? component.getAttribute("desktop.windowno") : null;
            if (att == null || !(att instanceof Integer) || windowNo != (Integer)att) continue;
            Tab tab = panel.getLinkedTab();
            return tab;
        }
        return null;
    }

    public void setTabTitle(String title, Tab tab) {
        if (tab == null) {
            return;
        }
        tab.setTooltiptext((String)title);
        if (((String)title).length() <= this.getMaxTitleLength()) {
            tab.setLabel((String)title);
        } else {
            title = ((String)title).substring(0, this.getMaxTitleLength() - 3) + "...";
            tab.setLabel((String)title);
        }
    }

    private int getMaxTitleLength() {
        return MSysConfig.getIntValue((String)"ZK_DESKTOP_TAB_MAX_TITLE_LENGTH", (int)30, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    public org.adempiere.webui.component.Tab insertAfter(org.adempiere.webui.component.Tab refTab, Component comp, String title, boolean closeable, boolean enable, Tab.DecorateInfo decorateInfo) {
        if (refTab == null) {
            return this.addWindow(comp, title, closeable, enable, decorateInfo);
        }
        return this.insertBefore((org.adempiere.webui.component.Tab)refTab.getNextSibling(), comp, title, closeable, enable, decorateInfo);
    }

    public Tab replace(Tab refTab, Window comp, String title) {
        if (refTab == null) {
            throw new IllegalArgumentException();
        }
        org.zkoss.zul.Tabpanel refpanel = refTab.getLinkedPanel();
        Component firstChild = refpanel.getFirstChild();
        if (firstChild instanceof Window) {
            if (firstChild instanceof ProcessDialog) {
                ((ProcessDialog)firstChild).unlockUI(null);
            } else if (firstChild instanceof ZkReportViewer) {
                ((ZkReportViewer)firstChild).hideBusyMask();
            } else if (firstChild instanceof AbstractADWindowContent) {
                ((AbstractADWindowContent)firstChild).hideBusyMask();
            }
            ((Window)firstChild).onClose();
            comp.setParent((Component)refpanel);
        } else {
            firstChild.detach();
            comp.setParent((Component)refpanel);
        }
        if (title != null) {
            this.setTabTitle(title, refTab);
        }
        return refTab;
    }

    public void setSelectedTab(Tab tab) {
        if (this.isMobile()) {
            this.updateMobileTabState(tab);
        }
        this.tabbox.setSelectedTab(tab);
    }

    private void updateMobileTabState(Tab tab) {
        if (this.isMobile() && this.tabListBtn != null) {
            List tabs = this.tabbox.getTabs().getChildren();
            for (Component c : tabs) {
                org.adempiere.webui.component.Tab t;
                if (!(c instanceof org.adempiere.webui.component.Tab)) continue;
                t.setVisible((t = (org.adempiere.webui.component.Tab)c) == tab);
                t.getLinkedPanel().setVisible(t == tab);
                if (!t.isVisible()) continue;
                Events.postEvent((String)ON_MOBILE_SET_SELECTED_TAB, (Component)t.getLinkedPanel(), null);
            }
        }
    }

    private boolean isMobile() {
        return ClientInfo.isMobile();
    }

    public boolean closeActiveWindow() {
        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)this.tabbox.getSelectedTab();
        this.tabbox.getSelectedTab().onClose();
        return tab.getParent() == null;
    }

    public org.adempiere.webui.component.Tab getSelectedTab() {
        return (org.adempiere.webui.component.Tab)this.tabbox.getSelectedTab();
    }

    public void setTabTitle(int tabNo, String title, String tooltip) {
        if (tabNo < 0 || tabNo >= this.tabbox.getTabs().getChildren().size()) {
            return;
        }
        org.zkoss.zul.Tabs tabs = this.tabbox.getTabs();
        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)tabs.getChildren().get(tabNo));
        this.setTabTitle(title, tab);
        if (tooltip != null && tooltip.trim().length() > 0) {
            tab.setTooltiptext(tooltip);
        }
    }

    public Tabbox getComponent() {
        return this.tabbox;
    }

    public ToolBar getToobar() {
        return this.toolbar;
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.tabbox && "onPageDetached".equals(event.getName())) {
            try {
                SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
            }
            catch (Exception exception) {}
        } else if (event.getTarget() == this.tabbox && "onPageAttached".equals(event.getName())) {
            try {
                SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
            }
            catch (Exception exception) {}
        } else if (event instanceof OpenEvent && event.getTarget() instanceof Menupopup) {
            if (((OpenEvent)event).isOpen()) {
                Menupopup popup = (Menupopup)event.getTarget();
                List tabs = this.tabbox.getTabs().getChildren();
                int tabsSize = tabs.size();
                int currentTabIdx = -1;
                if (popup.getAttribute("tab") != null) {
                    org.adempiere.webui.component.Tab currentTab = (org.adempiere.webui.component.Tab)((Object)popup.getAttribute("tab"));
                    int i = tabsSize - 1;
                    while (i > 0) {
                        org.adempiere.webui.component.Tab tab = (org.adempiere.webui.component.Tab)((Object)tabs.get(i));
                        if (((Object)((Object)currentTab)).equals((Object)tab)) {
                            currentTabIdx = i;
                            break;
                        }
                        --i;
                    }
                }
                if (currentTabIdx > 0) {
                    List items = popup.getChildren();
                    for (Component item : items) {
                        if (!(item instanceof Menuitem)) continue;
                        String option = (String)item.getAttribute("option");
                        boolean visible = OPTION_CLOSE.equals(option) || tabsSize > 2 && (OPTION_CLOSE_OTHER_WINDOWS.equals(option) || OPTION_CLOSE_ALL_WINDOWS.equals(option)) || currentTabIdx < tabsSize - 1 && OPTION_CLOSE_WINDOWS_TO_THE_RIGHT.equals(option) || currentTabIdx > 1 && OPTION_CLOSE_WINDOWS_TO_THE_LEFT.equals(option);
                        item.setVisible(visible);
                    }
                }
            }
        } else if ("onCtrlKey".equals(event.getName())) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 34 && this.tabbox.getSelectedTab() != null && this.tabbox.getSelectedTab().getNextSibling() != null) {
                this.tabbox.setSelectedTab((Tab)this.tabbox.getSelectedTab().getNextSibling());
                keyEvent.stopPropagation();
            } else if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 33 && this.tabbox.getSelectedTab() != null && this.tabbox.getSelectedTab().getPreviousSibling() != null) {
                this.tabbox.setSelectedTab((Tab)this.tabbox.getSelectedTab().getPreviousSibling());
                keyEvent.stopPropagation();
            }
        }
    }
}

