import { string } from 'alga-js'
import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  if(body?.ids) {
    for(let id of body.ids) {
      const res: any = await event.context.fetch(`models/m_productprice?$filter=${string.urlEncode('M_Product_ID eq '+id)}`, 'GET', token, null)
      if(res) {
        for(let fi of res.records) {
          await event.context.fetch('models/m_productprice/'+fi.id, 'DELETE', token, null)
        }
      }

      await event.context.fetch('models/m_product/'+id, 'DELETE', token, null)
    }
  }
 
  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})