import { string } from 'alga-js'
import refreshTokenHelper from "../../utils/refreshTokenHelper"
import getTokenHelper from "../../utils/getTokenHelper"
import forceLogoutHelper from "../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../utils/errorHandlingHelper"
import fetchHelper from "../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const query = getQuery(event)

  // Get org IDs from query parameter (comma-separated) - now using AD_Org_ID instead of C_BPartner_ID
  const orgIds = query.orgIds ? (query.orgIds as string).split(',') : []

  console.log('First Material Receipts API - orgIds:', orgIds)

  if (orgIds.length === 0) {
    return { records: {} }
  }

  // Process results to get first material receipt per org
  const firstReceipts: any = {}

  // Fetch first material receipt for each org individually (more reliable)
  for (const orgId of orgIds) {
    try {
      const filter = `C_DocType_ID eq 1000014 AND IsSOTrx eq false AND (DocStatus eq 'CO' or DocStatus eq 'CL') AND AD_Org_ID eq ${orgId}`
      const res: any = await fetchHelper(
        event,
        `models/m_inout?$top=1&$filter=${string.urlEncode(filter)}&$select=M_InOut_ID,MovementDate,AD_Org_ID&$orderby=${string.urlEncode('MovementDate asc')}`,
        'GET',
        token,
        null
      )

      if (res?.records && res.records.length > 0) {
        const record = res.records[0]
        const movementDate = new Date(record.MovementDate)
        firstReceipts[orgId] = {
          id: record.M_InOut_ID,
          date: record.MovementDate,
          month: movementDate.getMonth() + 1,
          year: movementDate.getFullYear()
        }
        console.log(`First Material Receipt for org ${orgId}:`, firstReceipts[orgId])
      }
    } catch (err) {
      console.error(`Error fetching material receipt for org ${orgId}:`, err)
    }
  }

  console.log('First Material Receipts API - results:', firstReceipts)

  data = { records: firstReceipts }
  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
