import { string } from 'alga-js'
import getTokenHelper from "../../utils/getTokenHelper"
import refreshTokenHelper from "../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../utils/errorHandlingHelper"
import fetchHelper from "../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const organizationId = getCookie(event, 'organizationId')

  // Fetch all organizations first (full data to ensure we get the Name field)
  const orgsRes: any = await fetchHelper(
    event,
    `models/ad_org`,
    'GET',
    token,
    null
  )

  // Fetch fulfillment fee line data with organization, LineTotalAmt, shipping_date, and FulfillTypeAccounting
  const res: any = await fetchHelper(
    event,
    `models/cust_fulfillmentfeeline?$select=AD_Org_ID,LineTotalAmt,shipping_date,FulfillTypeAccounting`,
    'GET',
    token,
    null
  )

  if(res) {
    data = res

    // Create a map of organization IDs to names for easy lookup
    const orgMap: Record<number, string> = {}
    if (orgsRes?.records) {
      orgsRes.records.forEach((org: any) => {
        orgMap[org.id] = org.Name || `Org-${org.id}`
      })
    }

    // Add org names to each record
    if (data.records) {
      data.records = data.records.map((record: any) => {
        const orgId = record.AD_Org_ID?.id || record.AD_Org_ID
        return {
          ...record,
          orgName: orgMap[orgId] || `Org-${orgId}`
        }
      })
    }

    // Also add organizations array for reference
    data.organizations = orgsRes?.records || []
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
