import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const query = getQuery(event)
  
  const orgId = query.orgId

  if (!orgId) {
    return {
      status: 400,
      message: 'Organization ID is required'
    }
  }

  try {
    // Fetch organization to get C_BPartner_ID
    const orgRes: any = await fetchHelper(
      event, 
      `models/ad_org/${orgId}?$select=C_Bpartner_ID`, 
      'GET', 
      token
    )

    const bpartnerId = orgRes?.C_BPartner_ID?.id
    
    if (!bpartnerId) {
      return {
        status: 404,
        message: 'Business Partner not found for organization'
      }
    }

    // Fetch business partner to get default values
    const bpartnerRes: any = await fetchHelper(
      event, 
      `models/c_bpartner/${bpartnerId}`, 
      'GET', 
      token
    )

    // Extract default values
    const defaults: any = {}

    // DeliveryViaRule
    if (bpartnerRes?.DeliveryViaRule?.id) {
      defaults.deliveryViaRuleId = bpartnerRes.DeliveryViaRule.id
      defaults.deliveryViaRule = bpartnerRes.DeliveryViaRule.identifier || ''
    }

    // OrderSource - check both possible field names
    if (bpartnerRes?.C_OrderSource_CustomOrder_ID?.id) {
      defaults.orderSourceId = bpartnerRes.C_OrderSource_CustomOrder_ID.id
      defaults.orderSource = bpartnerRes.C_OrderSource_CustomOrder_ID.identifier || ''
    } else if (bpartnerRes?.C_OrderSource_ID?.id) {
      defaults.orderSourceId = bpartnerRes.C_OrderSource_ID.id
      defaults.orderSource = bpartnerRes.C_OrderSource_ID.identifier || ''
    }

    // PriceList
    if (bpartnerRes?.M_PriceList_ID?.id) {
      defaults.priceListId = bpartnerRes.M_PriceList_ID.id
      defaults.priceList = bpartnerRes.M_PriceList_ID.identifier || ''
    }

    // Shipper - check both possible field names
    if (bpartnerRes?.M_Shipper_OrderDefault_ID?.id) {
      defaults.shipperId = bpartnerRes.M_Shipper_OrderDefault_ID.id
      defaults.shipper = bpartnerRes.M_Shipper_OrderDefault_ID.identifier || ''
    } else if (bpartnerRes?.M_Shipper_ID?.id) {
      defaults.shipperId = bpartnerRes.M_Shipper_ID.id
      defaults.shipper = bpartnerRes.M_Shipper_ID.identifier || ''
    }

    data = {
      status: 200,
      defaults
    }
  } catch (err: any) {
    throw err
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
