# PWA Icon Generation

## Overview

This script generates PWA icons from an SVG source file at multiple sizes required for Progressive Web Apps.

## Files

- `icon.svg` - Source SVG icon (located in `/public`)
- `generate-icons.js` - Script to generate PNG icons from SVG

## Generated Icons

The script generates the following icon sizes:
- 72x72px
- 96x96px
- 128x128px
- 144x144px
- 152x152px
- 192x192px
- 384x384px
- 512x512px

## Usage

### Automatic (during build)

Icons are automatically generated during the build process:

```bash
npm run build
```

### Manual Generation

To regenerate icons manually:

```bash
npm run generate:icons
```

Or directly:

```bash
node scripts/generate-icons.js
```

## Customizing the Icon

To customize the app icon:

1. Edit `/public/icon.svg`
2. Run `npm run generate:icons`
3. All PNG icons will be regenerated

## Requirements

- Node.js 18+
- `sharp` package (installed as devDependency)

## Icon Design Tips

The current icon design includes:
- Dark background (#1a1a1a)
- White foreground elements
- Green accent color (#4CAF50)
- Letter "L" for LogShip branding

For best results:
- Use simple, bold designs
- Ensure good contrast
- Test at small sizes (72x72)
- Avoid fine details that don't scale well
