import { createError } from "./error.js";
function renderStubMessage(name) {
  const message = `\`${name}\` is provided by @nuxt/scripts. Check your console to install it or run 'npx nuxi@latest module add @nuxt/scripts' to install it.`;
  if (import.meta.client) {
    throw createError({
      fatal: true,
      statusCode: 500,
      statusMessage: message
    });
  }
}
export function useScript(input, options) {
  renderStubMessage("useScript");
}
export function useScriptTriggerElement(...args) {
  renderStubMessage("useScriptTriggerElement");
}
export function useScriptTriggerConsent(...args) {
  renderStubMessage("useScriptTriggerConsent");
}
export function useScriptEventPage(...args) {
  renderStubMessage("useScriptEventPage");
}
export function useScriptGoogleAnalytics(...args) {
  renderStubMessage("useScriptGoogleAnalytics");
}
export function useScriptPlausibleAnalytics(...args) {
  renderStubMessage("useScriptPlausibleAnalytics");
}
export function useScriptCloudflareWebAnalytics(...args) {
  renderStubMessage("useScriptCloudflareWebAnalytics");
}
export function useScriptCrisp(...args) {
  renderStubMessage("useScriptCrisp");
}
export function useScriptFathomAnalytics(...args) {
  renderStubMessage("useScriptFathomAnalytics");
}
export function useScriptMatomoAnalytics(...args) {
  renderStubMessage("useScriptMatomoAnalytics");
}
export function useScriptGoogleTagManager(...args) {
  renderStubMessage("useScriptGoogleTagManager");
}
export function useScriptSegment(...args) {
  renderStubMessage("useScriptSegment");
}
export function useScriptClarity(...args) {
  renderStubMessage("useScriptClarity");
}
export function useScriptMetaPixel(...args) {
  renderStubMessage("useScriptMetaPixel");
}
export function useScriptXPixel(...args) {
  renderStubMessage("useScriptXPixel");
}
export function useScriptIntercom(...args) {
  renderStubMessage("useScriptIntercom");
}
export function useScriptHotjar(...args) {
  renderStubMessage("useScriptHotjar");
}
export function useScriptStripe(...args) {
  renderStubMessage("useScriptStripe");
}
export function useScriptLemonSqueezy(...args) {
  renderStubMessage("useScriptLemonSqueezy");
}
export function useScriptVimeoPlayer(...args) {
  renderStubMessage("useScriptVimeoPlayer");
}
export function useScriptYouTubeIframe(...args) {
  renderStubMessage("useScriptYouTubeIframe");
}
export function useScriptGoogleMaps(...args) {
  renderStubMessage("useScriptGoogleMaps");
}
export function useScriptNpm(...args) {
  renderStubMessage("useScriptNpm");
}
export function useScriptGoogleAdsense(...args) {
  renderStubMessage("useScriptGoogleAdsense");
}
export function useScriptYouTubePlayer(...args) {
  renderStubMessage("useScriptYouTubePlayer");
}
export function useScriptUmamiAnalytics(...args) {
  renderStubMessage("useScriptUmamiAnalytics");
}
export function useScriptSnapchatPixel(...args) {
  renderStubMessage("useScriptSnapchatPixel");
}
