// https://github.com/cloudflare/workerd/blob/main/src/node/util.ts

import workerdUtil from "#workerd/node:util";

import {
  _errnoException,
  _exceptionWithHostPort,
  getSystemErrorMap,
  getSystemErrorName,
  isBoolean,
  isBuffer,
  isDate,
  isError,
  isFunction,
  isNull,
  isNullOrUndefined,
  isNumber,
  isObject,
  isPrimitive,
  isRegExp,
  isString,
  isSymbol,
  isUndefined,
  parseEnv,
  styleText,
} from "unenv/node/util";

export {
  _errnoException,
  _exceptionWithHostPort,
  getSystemErrorMap,
  getSystemErrorName,
  isBoolean,
  isBuffer,
  isDate,
  isError,
  isFunction,
  isNull,
  isNullOrUndefined,
  isNumber,
  isObject,
  isPrimitive,
  isRegExp,
  isString,
  isSymbol,
  isUndefined,
  parseEnv,
  styleText,
} from "unenv/node/util";

export const {
  MIMEParams,
  MIMEType,
  TextDecoder,
  TextEncoder,
  _extend,
  aborted,
  callbackify,
  debug,
  debuglog,
  deprecate,
  format,
  formatWithOptions,
  getCallSite,
  inherits,
  inspect,
  log,
  parseArgs,
  promisify,
  stripVTControlCharacters,
  toUSVString,
  transferableAbortController,
  transferableAbortSignal,
  isArray,
  isDeepStrictEqual,
} = workerdUtil;

export const types = workerdUtil.types;

export default {
  _errnoException,
  _exceptionWithHostPort,
  getSystemErrorMap,
  getSystemErrorName,
  isArray,
  isBoolean,
  isBuffer,
  isDate,
  isDeepStrictEqual,
  isError,
  isFunction,
  isNull,
  isNullOrUndefined,
  isNumber,
  isObject,
  isPrimitive,
  isRegExp,
  isString,
  isSymbol,
  isUndefined,
  parseEnv,
  styleText,
  MIMEParams,
  MIMEType,
  TextDecoder,
  TextEncoder,
  _extend,
  aborted,
  callbackify,
  debug,
  debuglog,
  deprecate,
  format,
  formatWithOptions,
  getCallSite,
  inherits,
  inspect,
  log,
  parseArgs,
  promisify,
  stripVTControlCharacters,
  toUSVString,
  transferableAbortController,
  transferableAbortSignal,
  types,
};
