var tape = require('tape'),
  d3PolygonClip = require('../build/d3-polygon-clip');

tape('polygonClip(...) should handle colinear edges of clip and subject', function (test) {
  // specifically test loc "isFinite(intersection[0])"
  // wihtout these lines, clipped polygon contains 12 verteces, with 2 [NaN,NaN] verteces at indeces 1 and 2
  // no smaller example :-(
  var subject = [
    [177.53046858417892, 338.15545417120717],
    [375.73770205311564, 232.9701589419706],
    [488.19344738331495, -230.26529355780923],
    [236.61455454667117, -520.1972300945229],
    [-178.67595317886338, -57.93242787880229],
  ];
  var clip = [
    [455.8, 227.9],
    [441.3482085224992, 211.22311709277227],
    [333.61626533916024, 88.65723104458745],
    [306.68327954332545, 58.015759532541246],
    [281.7208909066584, 30.086582322904963],
    [248.6984249983278, 18.18660350304314],
    [230.59294545332884, 12.754616211125438],
    [212.4874659083305, 24.402628919208375],
    [179.46499999999997, 46.6626500993466],
    [80.39760227500838, 113.44271363976128],
    [72.93910909334228, 118.74871787578893],
    [64.39910909334228, 133.99387814131532],
    [60.12910909334263, 141.61645827407816],
    [25.96910909334254, 209.3022596017102],
    [17.429109093342298, 227.90000000000003],
    [25.969109093342297, 246.49774039828958],
    [43.0491090933423, 280.3406410621056],
    [60.1291090933423, 314.18354172592154],
    [68.6691090933423, 329.42870199144795],
    [72.9391090933423, 337.0512821242111],
    [80.39760227500834, 342.3572863602387],
    [113.42006818333884, 364.6173075403769],
    [146.44253409166936, 386.8773287205151],
    [212.48746590833042, 431.3973710807915],
    [230.59294545332887, 443.0453837888746],
    [248.69842499832717, 437.6133964969575],
    [281.7208909066577, 425.7134176770957],
    [300.44268238415856, 404.766534769868],
    [306.6832795433254, 397.7842404674588],
    [333.6162653391602, 367.1427689554126],
    [441.3482085224992, 244.5768829072277],
  ];

  var clipped = d3PolygonClip.polygonClip(clip, subject);
  test.equal(clipped.filter((v) => isNaN(v[0]) || isNaN(v[1])).length, 0);
  test.end();
});
