'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var uniq = function (fromArray, byProp) {
    if (byProp === void 0) { byProp = ''; }
    var newArray = [];
    var byNumber = Number(byProp);
    var newSet = new Set();
    for (var _i = 0, fromArray_1 = fromArray; _i < fromArray_1.length; _i++) {
        var fromItem = fromArray_1[_i];
        if (typeof fromItem === 'object' && fromItem !== null && typeof byProp === 'string' && byProp !== '' && Array.isArray(fromItem) === false) {
            if (!newSet.has(fromItem[byProp])) {
                newArray.push(fromItem);
                newSet.add(fromItem[byProp]);
            }
        }
        else if (Array.isArray(fromItem) && isNaN(byNumber) === false && Number(fromItem.length) > Number(byProp)) {
            var newIndex = Number(byProp);
            if (!newSet.has(fromItem[newIndex])) {
                newArray.push(fromItem);
                newSet.add(fromItem[newIndex]);
            }
        }
        else {
            if (!newSet.has(JSON.stringify(fromItem))) {
                newArray.push(fromItem);
                newSet.add(JSON.stringify(fromItem));
            }
        }
    }
    return newArray;
};

var take = function (fromArray, byProp, cbProp) {
    if (cbProp === void 0) { cbProp = ''; }
    var newArray = [];
    var byNumber = Number(byProp);
    if (Array.isArray(fromArray) && fromArray.length >= 1) {
        if (typeof fromArray[0] === 'object' && fromArray[0] !== null && typeof byProp === 'string' && Object.keys(fromArray[0]).includes(byProp)) {
            newArray = fromArray.map(function (item) {
                return item[byProp];
            });
            if (cbProp === 'uniq') {
                newArray = Array.from(new Set(newArray));
            }
        }
        else if (Array.isArray(fromArray[0]) && isNaN(byNumber) === false) {
            newArray = fromArray.map(function (item) {
                return item[byNumber];
            });
            if (cbProp === 'uniq') {
                newArray = Array.from(new Set(newArray));
            }
        }
        else if (typeof byProp === 'function') {
            newArray = fromArray.filter(function (item) {
                return byProp(item);
            });
            if (cbProp !== '') {
                newArray = newArray.map(function (item) { return item[cbProp]; });
            }
        }
    }
    return newArray;
};

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __awaiter(thisArg, _arguments, P, generator) {
  function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
  return new (P || (P = Promise))(function (resolve, reject) {
      function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
      function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
      function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
      step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}

function __generator(thisArg, body) {
  var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
  return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
  function verb(n) { return function (v) { return step([n, v]); }; }
  function step(op) {
      if (f) throw new TypeError("Generator is already executing.");
      while (g && (g = 0, op[0] && (_ = 0)), _) try {
          if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
          if (y = 0, t) op = [op[0] & 2, t.value];
          switch (op[0]) {
              case 0: case 1: t = op; break;
              case 4: _.label++; return { value: op[1], done: false };
              case 5: _.label++; y = op[1]; op = [0]; continue;
              case 7: op = _.ops.pop(); _.trys.pop(); continue;
              default:
                  if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                  if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                  if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                  if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                  if (t[2]) _.ops.pop();
                  _.trys.pop(); continue;
          }
          op = body.call(thisArg, _);
      } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
      if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
  }
}

function __spreadArray(to, from, pack) {
  if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
      if (ar || !(i in from)) {
          if (!ar) ar = Array.prototype.slice.call(from, 0, i);
          ar[i] = from[i];
      }
  }
  return to.concat(ar || Array.prototype.slice.call(from));
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
  var e = new Error(message);
  return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var nested = function (flatArray, options) {
    if (options === void 0) { options = { prop: 'id', parent: 'parent', children: 'children' }; }
    var nestedArray = [];
    var flattenArray = Array.from(flatArray);
    var nestedOptions = options;
    var parentArray = function (flattenArr) {
        nestedArray = flattenArr.filter(function (item) {
            return typeof item === 'object' && item !== null && !flattenArr.map(function (i) { return String(i[nestedOptions.prop]).trim(); }).includes(String(item[nestedOptions.parent]).trim());
        }).map(function (item) { return createNewObject(item); });
    };
    var createNewObject = function (itemObj) {
        var newObject = itemObj;
        if (itemObj[nestedOptions.children] === undefined || itemObj[nestedOptions.children] === null) {
            newObject[nestedOptions.children] = childrenArray(itemObj[nestedOptions.prop]);
            if (newObject[nestedOptions.children].length <= 0) {
                delete newObject[nestedOptions.children];
            }
        }
        delete newObject[nestedOptions.parent];
        return newObject;
    };
    var childrenArray = function (parent) {
        var childArray = [];
        if (filteredArray(parent).length >= 1) {
            filteredArray(parent).forEach(function (item) {
                childArray.push(createNewObject(item));
            });
        }
        return childArray;
    };
    var filteredArray = function (parent) {
        return flattenArray.filter(function (item) { return item[nestedOptions.parent] === parent; });
    };
    parentArray(flattenArray);
    return nestedArray;
};
var nestedAsync = function (flatPromise, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var flatArray;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.resolve(flatPromise)];
                case 1:
                    flatArray = _a.sent();
                    return [2 /*return*/, Promise.resolve(nested(flatArray, options))];
            }
        });
    });
};

var flatten = function (nestArray, options) {
    if (options === void 0) { options = { prop: 'id', parent: 'parent', children: 'children' }; }
    var flattenArray = [];
    var flattenOptions = options;
    var parentArray = function () {
        var nestedArray = Array.from(nestArray);
        nestedArray.forEach(function (item) {
            if (typeof item === 'object' && item !== null) {
                var newObject = item;
                newObject[flattenOptions.parent] = '0';
                if (typeof newObject[flattenOptions.children] === 'object' && Array.isArray(newObject[flattenOptions.children])) {
                    childrenArray(newObject[flattenOptions.children], item);
                    delete newObject[flattenOptions.children];
                }
                flattenArray.push(newObject);
            }
        });
    };
    var childrenArray = function (childArr, parentObj) {
        if (childArr.length >= 1) {
            var nestedArray = Array.from(childArr);
            nestedArray.forEach(function (item) {
                if (typeof item === 'object' && item !== null) {
                    var newObject = item;
                    newObject[flattenOptions.parent] = parentObj[flattenOptions.prop];
                    if (typeof newObject[flattenOptions.children] === 'object' && Array.isArray(newObject[flattenOptions.children])) {
                        childrenArray(newObject[flattenOptions.children], item);
                        delete newObject[flattenOptions.children];
                    }
                    flattenArray.push(newObject);
                }
            });
        }
    };
    parentArray();
    return flattenArray;
};
var flattenAsync = function (nestPromise, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(void 0, void 0, void 0, function () {
        var nestArray;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.resolve(nestPromise)];
                case 1:
                    nestArray = _a.sent();
                    return [2 /*return*/, Promise.resolve(flatten(nestArray, options))];
            }
        });
    });
};

var search = function (fromArrayay) {
    var searchString = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        searchString[_i - 1] = arguments[_i];
    }
    var newArray = [];
    var _loop_1 = function (searchItem) {
        var filterArray = Array.from(fromArrayay).filter(function (item) {
            if (isNaN(item) === false && Number(item) === Number(searchItem)) {
                return true;
            }
            else if (typeof item === 'string' && String(item).toLowerCase().includes(String(searchItem).toLowerCase())) {
                return true;
            }
            else if (typeof item === 'object' && item !== null) {
                for (var _i = 0, _a = Object.keys(item); _i < _a.length; _i++) {
                    var key = _a[_i];
                    if (isNaN(item[key]) === false && Number(item[key]) === Number(searchItem)) {
                        return true;
                    }
                    else if (typeof item[key] === 'string' && String(item[key]).toLowerCase().includes(String(searchItem).toLowerCase())) {
                        return true;
                    }
                }
            }
            return false;
        });
        newArray = uniq(__spreadArray(__spreadArray([], newArray, true), filterArray, true));
    };
    for (var _a = 0, _b = searchString.flat(); _a < _b.length; _a++) {
        var searchItem = _b[_a];
        _loop_1(searchItem);
    }
    return newArray;
};
var searchBy = function (fromArray, queryArray, propArray) {
    var newArray = [];
    var _loop_2 = function (query) {
        var filterArray = Array.from(fromArray).filter(function (item) {
            for (var _i = 0, _a = Array.from(propArray); _i < _a.length; _i++) {
                var val = _a[_i];
                if (val in item) {
                    if (isNaN(item[val]) === false && Number(item[val]) === Number(query)) {
                        return true;
                    }
                    else if (typeof item[val] === 'string' && String(item[val]).toLowerCase().indexOf(String(query).toLowerCase()) !== -1) {
                        return true;
                    }
                }
            }
            return false;
        });
        newArray = uniq(__spreadArray(__spreadArray([], newArray, true), filterArray, true));
    };
    for (var _i = 0, queryArray_1 = queryArray; _i < queryArray_1.length; _i++) {
        var query = queryArray_1[_i];
        _loop_2(query);
    }
    return newArray;
};

var remove = function (fromObject) {
    var propKey = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        propKey[_i - 1] = arguments[_i];
    }
    var newObject = Object.assign({}, fromObject);
    for (var _a = 0, propKey_1 = propKey; _a < propKey_1.length; _a++) {
        var key = propKey_1[_a];
        if (key in newObject) {
            delete newObject[key];
        }
    }
    return newObject;
};
var removeBy = function (fromObject) {
    var propVal = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        propVal[_i - 1] = arguments[_i];
    }
    var newObject = {};
    var newSet = new Set(propVal.map(function (i) { return String(i); }));
    for (var _a = 0, _b = Object.keys(fromObject); _a < _b.length; _a++) {
        var key = _b[_a];
        if (!newSet.has(String(fromObject[key]))) {
            newObject[key] = fromObject[key];
        }
    }
    return newObject;
};
var removeByKey = remove;
var removeByVal = removeBy;

var filter$1 = function (fromArray, filterObject) {
    var newArray = Array.from(fromArray);
    var clearObject = removeBy(filterObject, '', 0);
    var _loop_1 = function (ftrKey) {
        var filterArray = newArray.filter(function (object) {
            if (ftrKey in object) {
                if (isNaN(object[ftrKey]) === false && Number(object[ftrKey]) === Number(clearObject[ftrKey])) {
                    return true;
                }
                else if (typeof object[ftrKey] === 'string' && String(object[ftrKey]).toLowerCase().includes(String(clearObject[ftrKey]).toLowerCase())) {
                    return true;
                }
            }
            return false;
        });
        newArray = filterArray;
    };
    for (var _i = 0, _a = Object.keys(clearObject); _i < _a.length; _i++) {
        var ftrKey = _a[_i];
        _loop_1(ftrKey);
    }
    return newArray;
};

/*interface CallBack<Type> {
  (a: Type, b: Type): number;
} compareFunc: CallBack<any>*/
var sortBy = function (fromArray, propString, sortString) {
    if (sortString === void 0) { sortString = 'asc'; }
    var newArray = Array.from(fromArray);
    if (sortString === 'asc') {
        newArray.sort(function (a, b) {
            if (propString in a && propString in b) {
                if (isNaN(a[propString]) === false && isNaN(b[propString]) === false) {
                    return Number(a[propString]) - Number(b[propString]);
                }
                else if (typeof a[propString] === 'string' && typeof b[propString] === 'string') {
                    var propA = a[propString].toLowerCase();
                    var propB = b[propString].toLowerCase();
                    var propRes = 0;
                    if (propA < propB) {
                        propRes = -1;
                    }
                    else if (propA > propB) {
                        propRes = 1;
                    }
                    return propRes;
                }
            }
        });
    }
    else if (sortString === 'desc') {
        newArray.sort(function (a, b) {
            if (propString in a && propString in b) {
                if (isNaN(a[propString]) === false && isNaN(b[propString]) === false) {
                    return Number(b[propString]) - Number(a[propString]);
                }
                else if (typeof a[propString] === 'string' && typeof b[propString] === 'string') {
                    var propA = a[propString].toLowerCase();
                    var propB = b[propString].toLowerCase();
                    var propRes = 0;
                    if (propB < propA) {
                        propRes = -1;
                    }
                    else if (propB > propA) {
                        propRes = 1;
                    }
                    return propRes;
                }
            }
        });
    }
    return newArray;
};
var sort = sortBy;
var order = function (fromArray, newProp) {
    if (newProp === void 0) { newProp = 'order'; }
    var newArray = Array.from(fromArray);
    return newArray.map(function (item, index) {
        if (typeof item === 'object' && item !== null) {
            item[newProp] = Number(index) + 1;
        }
        return item;
    });
};

var paginate = function (fromArray, pageActive, limitPerPage) {
    if (pageActive === void 0) { pageActive = 1; }
    if (limitPerPage === void 0) { limitPerPage = 10; }
    var newArray = Array.from(fromArray);
    var startPaginate = (Number(limitPerPage) * Number(pageActive)) - (Number(limitPerPage) - 1);
    var endPaginate = Number(limitPerPage) * Number(pageActive);
    return newArray.slice(startPaginate - 1, (endPaginate <= newArray.length) ? endPaginate : newArray.length);
};
var pages = function (lengthOfArray, limitPerPage) {
    if (limitPerPage === void 0) { limitPerPage = 10; }
    var arrayLength = Array.isArray(lengthOfArray) ? lengthOfArray.length : lengthOfArray;
    var divideLength = Number(arrayLength) / Number(limitPerPage);
    var pageNumber = Math.ceil(divideLength);
    return pageNumber;
};
var pageStart = function (pageActive, limitPerPage) {
    if (pageActive === void 0) { pageActive = 1; }
    if (limitPerPage === void 0) { limitPerPage = 10; }
    return (Number(pageActive) - 1) * Number(limitPerPage);
};
var pageInfo = function (fromArray, pageActive, limitPerPage) {
    if (pageActive === void 0) { pageActive = 1; }
    if (limitPerPage === void 0) { limitPerPage = 10; }
    var newArray = Array.from(fromArray);
    var startPaginate = (Number(limitPerPage) * Number(pageActive)) - (Number(limitPerPage) - 1);
    var endPaginate = Number(limitPerPage) * Number(pageActive);
    return {
        from: (newArray.length >= 1) ? startPaginate : 0,
        start: (newArray.length >= 1) ? startPaginate : 0,
        to: (endPaginate <= newArray.length) ? endPaginate : newArray.length,
        end: (endPaginate <= newArray.length) ? endPaginate : newArray.length,
        of: newArray.length,
        length: newArray.length
    };
};
var pagination = function (totalPages, pageActive, positionOfEllipsis) {
    if (pageActive === void 0) { pageActive = 1; }
    if (positionOfEllipsis === void 0) { positionOfEllipsis = 0; }
    var newArray = [];
    var maxPages = (Number(totalPages) < Number(pageActive)) ? Number(totalPages) : Number(pageActive);
    var minPages = (Number(pageActive) < 1) ? 1 : Number(pageActive);
    var pageAddition = maxPages + Number(positionOfEllipsis);
    var pageSubtraction = minPages - Number(positionOfEllipsis);
    if (Number(positionOfEllipsis) === 0) {
        for (var i = 1; i <= Number(totalPages); i++) {
            newArray.push(String(i));
        }
    }
    else {
        if (minPages > 1) {
            for (var i = pageSubtraction; i < minPages; i++) {
                newArray.push(String(i));
            }
        }
        for (var i = maxPages; i <= pageAddition; i++) {
            newArray.push(String(i));
        }
    }
    var filterNegative = newArray.filter(function (num) { return Number(num) > 0; });
    var filterMax = filterNegative.filter(function (num) { return Number(num) <= Number(totalPages); });
    if (pageAddition < Number(totalPages) && Number(positionOfEllipsis) !== 0) {
        filterMax.push('...');
    }
    if (pageSubtraction > 1 && Number(positionOfEllipsis) !== 0) {
        filterMax.unshift('...');
    }
    return filterMax;
};

var duplication = function (fromArray, prop) {
    if (prop === void 0) { prop = ''; }
    var newArray = [];
    var newArrSet = Array.from(new Set(fromArray));
    if (prop !== '') {
        newArrSet = Array.from(new Set(fromArray.map(function (i) { return i[prop]; })));
    }
    var _loop_1 = function (setItem) {
        var tempArr = Array.from(fromArray).filter(function (filterItem) {
            if (prop !== '') {
                return filterItem[prop] === setItem;
            }
            else {
                return filterItem === setItem;
            }
        });
        if (Number(tempArr.length) >= 2) {
            tempArr.forEach(function (arrItem) {
                newArray.push(arrItem);
            });
        }
    };
    for (var _i = 0, newArrSet_1 = newArrSet; _i < newArrSet_1.length; _i++) {
        var setItem = newArrSet_1[_i];
        _loop_1(setItem);
    }
    return newArray;
};
var duplicationGroup = function (fromArray, prop) {
    if (prop === void 0) { prop = ''; }
    var newObj = {};
    var newSet = new Set();
    var newArrSet = Array.from(new Set(fromArray));
    if (prop !== '') {
        newArrSet = Array.from(new Set(fromArray.map(function (i) { return i[prop]; })));
    }
    var _loop_2 = function (setItem) {
        var tempArr = Array.from(fromArray).filter(function (filterItem) {
            if (prop !== '') {
                return filterItem[prop] === setItem;
            }
            else {
                return filterItem === setItem;
            }
        });
        if (!newSet.has(tempArr.length)) {
            newSet.add(tempArr.length);
            newObj[tempArr.length] = [];
        }
        tempArr.forEach(function (arrItem) {
            newObj[tempArr.length].push(arrItem);
        });
    };
    for (var _i = 0, newArrSet_2 = newArrSet; _i < newArrSet_2.length; _i++) {
        var setItem = newArrSet_2[_i];
        _loop_2(setItem);
    }
    return newObj;
};

// Fisher-Yates or Durstenfeld shuffle
var shuffle = function (arr) {
    var _a;
    // Define all the variables that we need
    var newArr = arr;
    var len = arr.length;
    var ind = 0;
    // Loop it using while for getting the randomize index (for loop is not good for this)
    while (len >= 1) {
        //@ts-ignore
        ind = Math.floor(Math.random() * len);
        // Decrease the len value for getting the current index
        len--;
        // Swap the value of the current index of new array with the randomize one and vice versa
        _a = [newArr[ind], newArr[len]], newArr[len] = _a[0], newArr[ind] = _a[1];
    }
    // Make sure it return a new array (immutable value)
    return newArr;
};

var column = function (fromArray, column) {
    if (column === void 0) { column = 2; }
    var resArray = [];
    var lenNumber = Math.ceil(Number(Array.from(fromArray).length) / Number(column));
    for (var i = 0; i < Number(column); i++) {
        var startNumber = Number(i) * Number(lenNumber);
        var endNumber = (Number(i) + 1) * Number(lenNumber);
        var newArray = Array.from(fromArray).slice(startNumber, endNumber);
        resArray.push(newArray);
    }
    return resArray;
};

var math = function (fromArray, mathType, propName) {
    if (mathType === void 0) { mathType = 'max'; }
    if (propName === void 0) { propName = ''; }
    var resNum = 0;
    if (propName !== '') {
        var newArray = fromArray.map(function (it) { return it[propName]; }).filter(function (i) { return isNaN(i) === false; });
        if (newArray.length > 1) {
            resNum = Math[mathType].apply(Math, newArray);
        }
    }
    else {
        var newArray = fromArray.filter(function (i) { return isNaN(i) === false; });
        if (newArray.length > 1) {
            resNum = Math[mathType].apply(Math, newArray);
        }
    }
    return resNum;
};

var move = function (fromArray, currentIndex, propName, moveType) {
    if (currentIndex === void 0) { currentIndex = 0; }
    if (propName === void 0) { propName = ''; }
    if (moveType === void 0) { moveType = 'up'; }
    var resArr = Array.from(fromArray);
    if (resArr.length >= 1 && propName !== '') {
        var startIndex = 0;
        var endIndex = Number(resArr.length) - 1;
        if (moveType === 'down') {
            var nextIndex_1 = Number(currentIndex) >= Number(endIndex) ? 0 : (Number(currentIndex) + 1);
            var currentItem_1 = resArr[String(currentIndex)];
            var nextItem_1 = resArr[String(nextIndex_1)];
            resArr = resArr.map(function (item, index) {
                if (Number(currentIndex) === Number(index)) {
                    item = nextItem_1;
                }
                if (Number(nextIndex_1) === Number(index)) {
                    item = currentItem_1;
                }
                item[propName] = Number(index) + 1;
                return item;
            });
        }
        else {
            var prevIndex_1 = Number(currentIndex) <= Number(startIndex) ? Number(endIndex) : (Number(currentIndex) - 1);
            var currentItem_2 = resArr[String(currentIndex)];
            var prevItem_1 = resArr[String(prevIndex_1)];
            resArr = resArr.map(function (item, index) {
                if (Number(currentIndex) === Number(index)) {
                    item = prevItem_1;
                }
                if (Number(prevIndex_1) === Number(index)) {
                    item = currentItem_2;
                }
                item[propName] = Number(index) + 1;
                return item;
            });
        }
    }
    return resArr;
};

var array = /*#__PURE__*/Object.freeze({
    __proto__: null,
    uniq: uniq,
    take: take,
    nested: nested,
    nestedAsync: nestedAsync,
    flatten: flatten,
    flattenAsync: flattenAsync,
    search: search,
    searchBy: searchBy,
    filter: filter$1,
    sortBy: sortBy,
    sort: sort,
    order: order,
    paginate: paginate,
    pages: pages,
    pageStart: pageStart,
    pageInfo: pageInfo,
    pagination: pagination,
    duplication: duplication,
    duplicationGroup: duplicationGroup,
    shuffle: shuffle,
    column: column,
    math: math,
    move: move
});

var doubleFormat = function (arg) {
    var newStr = String(arg);
    if (newStr.length === 1) {
        newStr = '0' + newStr;
    }
    return newStr;
};

var format$1 = function (date, type, locale, options) {
    if (type === void 0) { type = ''; }
    if (locale === void 0) { locale = ''; }
    if (options === void 0) { options = {}; }
    var newDate = new Date(date || null);
    var newValue = "".concat(newDate.getFullYear(), "-").concat(doubleFormat(Number(newDate.getMonth()) + 1), "-").concat(doubleFormat(newDate.getDate()), " ").concat(doubleFormat(newDate.getHours()), ":").concat(doubleFormat(newDate.getMinutes()), ":").concat(doubleFormat(newDate.getSeconds()));
    if (locale === '' && (options === null || options === void 0 ? void 0 : options.timeZone) === 'UTC') {
        newValue = "".concat(newDate.getUTCFullYear(), "-").concat(doubleFormat(Number(newDate.getUTCMonth()) + 1), "-").concat(doubleFormat(newDate.getUTCDate()), " ").concat(doubleFormat(newDate.getUTCHours()), ":").concat(doubleFormat(newDate.getUTCMinutes()), ":").concat(doubleFormat(newDate.getUTCSeconds()));
    }
    if (type === 'date') {
        newValue = "".concat(newDate.getFullYear(), "-").concat(doubleFormat(Number(newDate.getMonth()) + 1), "-").concat(doubleFormat(newDate.getDate()));
        if (locale === '' && (options === null || options === void 0 ? void 0 : options.timeZone) === 'UTC') {
            newValue = "".concat(newDate.getUTCFullYear(), "-").concat(doubleFormat(Number(newDate.getUTCMonth()) + 1), "-").concat(doubleFormat(newDate.getUTCDate()));
        }
        if (locale !== '') {
            newValue = newDate.toLocaleDateString(locale, options);
        }
    }
    else if (type === 'time') {
        newValue = "".concat(doubleFormat(newDate.getHours()), ":").concat(doubleFormat(newDate.getMinutes()), ":").concat(doubleFormat(newDate.getSeconds()));
        if (locale === '' && (options === null || options === void 0 ? void 0 : options.timeZone) === 'UTC') {
            newValue = "".concat(doubleFormat(newDate.getUTCHours()), ":").concat(doubleFormat(newDate.getUTCMinutes()), ":").concat(doubleFormat(newDate.getUTCSeconds()));
        }
        if (locale !== '') {
            newValue = newDate.toLocaleTimeString(locale, options);
        }
    }
    else {
        if (locale !== '') {
            newValue = newDate.toLocaleString(locale, options);
        }
    }
    return newValue;
};

var now$1 = function (type, locale, options) {
    if (type === void 0) { type = ''; }
    if (locale === void 0) { locale = ''; }
    if (options === void 0) { options = {}; }
    var newDate = new Date();
    return format$1(newDate, type, locale, options);
};

var modeDateHelper = function (date, mode) {
    var numberDate = 0;
    var jsonDate = new Date(date).toJSON().split(/T|\./);
    if (mode === 'date') {
        numberDate = Number(jsonDate[0].replaceAll('-', ''));
    }
    else if (mode === 'time') {
        numberDate = Number(jsonDate[1].replaceAll(':', ''));
    }
    else {
        numberDate = new Date(date).valueOf();
    }
    return numberDate;
};
var getYearHelper = function () {
    return Number(new Date().getFullYear());
};
var getMonthHelper = function () {
    return Number(new Date().getMonth());
};

var isBefore = function (isDate, beforeDate, modeDate) {
    if (modeDate === void 0) { modeDate = 'dateTime'; }
    var startNum = modeDateHelper(isDate, modeDate);
    var endNum = modeDateHelper(beforeDate, modeDate);
    var resultDate = false;
    if (startNum < endNum) {
        resultDate = true;
    }
    return resultDate;
};
var isAfter = function (isDate, afterDate, modeDate) {
    if (modeDate === void 0) { modeDate = 'dateTime'; }
    var startNum = modeDateHelper(isDate, modeDate);
    var endNum = modeDateHelper(afterDate, modeDate);
    var resultDate = false;
    if (startNum > endNum) {
        resultDate = true;
    }
    return resultDate;
};
var isBetween$1 = function (isDate, startDate, endDate, modeDate) {
    if (modeDate === void 0) { modeDate = 'dateTime'; }
    var isNum = modeDateHelper(isDate, modeDate);
    var startNum = modeDateHelper(startDate, modeDate);
    var endNum = modeDateHelper(endDate, modeDate);
    var resultDate = false;
    if (isNum >= startNum && isNum <= endNum) {
        resultDate = true;
    }
    return resultDate;
};

var daysInMonth = function (yearNum, monthNum) {
    if (yearNum === void 0) { yearNum = getYearHelper(); }
    if (monthNum === void 0) { monthNum = getMonthHelper(); }
    var commonDays = [28, 29, 30, 31];
    var numOfDays = Number(new Date(yearNum, monthNum, 0).getDate());
    return (commonDays.includes(numOfDays)) ? numOfDays : 31;
};
var daysOfPrevMonth = function (yearNum, monthNum) {
    if (yearNum === void 0) { yearNum = getYearHelper(); }
    if (monthNum === void 0) { monthNum = getMonthHelper(); }
    var prevDays = [];
    var getDays = Number(new Date(yearNum, Number(monthNum) - 1, 1).getDay());
    for (var i = Number(getDays) - 1; i >= 0; i--) {
        prevDays.push(Number(new Date(yearNum, Number(monthNum) - 1, Number('-' + i)).getDate()));
    }
    return prevDays;
};
var daysOfNextMonth = function (yearNum, monthNum) {
    if (yearNum === void 0) { yearNum = getYearHelper(); }
    if (monthNum === void 0) { monthNum = getMonthHelper(); }
    var getDays = Number(new Date(yearNum, Number(monthNum) - 1, daysInMonth(yearNum, monthNum)).getDay());
    var nextMonthDays = 6 - Number(getDays);
    var totalMonthDays = Number(daysInMonth(yearNum, monthNum)) + Number(daysOfPrevMonth(yearNum, monthNum).length) + Number(nextMonthDays);
    return Number(nextMonthDays) + (42 - Number(totalMonthDays));
};
var daysInYear = function (yearNum) {
    if (yearNum === void 0) { yearNum = getYearHelper(); }
    return (Number(yearNum) % 400 === 0 || (Number(yearNum) % 100 !== 0 && Number(yearNum) % 4 === 0)) ? 366 : 365;
};
var daysInBetween = function (startDate, endDate, modeDate) {
    if (modeDate === void 0) { modeDate = 'dateTime'; }
    var startNum = modeDateHelper(startDate, modeDate);
    var endNum = modeDateHelper(endDate, modeDate);
    var timeDifference = Number(endNum) - Number(startNum);
    return Math.floor(timeDifference / (1000 * 60 * 60 * 24));
};
var monthsInBetween = function (startDate, endDate) {
    var calcMonth = Number(new Date(endDate).getMonth()) - Number(new Date(startDate).getMonth());
    var calcYear = (Number(new Date(endDate).getFullYear()) - Number(new Date(startDate).getFullYear())) * 12;
    return Math.floor(calcMonth + calcYear);
};
var yearsInBetween = function (startDate, endDate) {
    return Math.floor(monthsInBetween(startDate, endDate) / 12);
};

var week = function (current) {
    if (current === void 0) { current = new Date(); }
    var currentDate = new Date(current || null);
    currentDate.setTime(currentDate.getTime() + 24 * 60 * 60 * 1000);
    var startDate = new Date(currentDate.getFullYear(), 0, 1);
    var currentDays = Math.floor((Number(currentDate.valueOf()) - Number(startDate.valueOf())) / (24 * 60 * 60 * 1000));
    var subtractWeek = 0;
    if (Number(startDate.getDay()) !== 0) {
        subtractWeek = 1;
    }
    return Number(Math.ceil(currentDays / 7)) - Number(subtractWeek);
};
var weeks = function () {
    var daysOfYear = Number(daysInYear(new Date().getFullYear()));
    var startDate = new Date(new Date().getFullYear(), 0, 1);
    var subtractWeek = 0;
    if (Number(startDate.getDay()) !== 0) {
        subtractWeek = 1;
    }
    return Number(Math.ceil(daysOfYear / 7)) - Number(subtractWeek);
};
var weekDates = function (current) {
    if (current === void 0) { current = new Date(); }
    var newWeekDates = [];
    var currentDate = new Date(current || null);
    for (var i = Number(currentDate.getDay()); i >= 0; i--) {
        newWeekDates.push(format$1(new Date(currentDate.getFullYear(), currentDate.getMonth(), Number(currentDate.getDate()) - Number(i)), 'date'));
    }
    for (var j = Number(currentDate.getDay()) - 1; j < 5; j++) {
        newWeekDates.push(format$1(new Date(currentDate.getFullYear(), currentDate.getMonth(), Number(currentDate.getDate()) + Number(j)), 'date'));
    }
    return newWeekDates;
};

var day = function (dateArg, locale, dayType) {
    if (dateArg === void 0) { dateArg = new Date(); }
    if (locale === void 0) { locale = 'en-US'; }
    if (dayType === void 0) { dayType = 'long'; }
    var currentDate = new Date(dateArg);
    //@ts-ignore
    return new Intl.DateTimeFormat(locale, { weekday: dayType }).format(currentDate);
};
var days = function (dateArg, locale, dayType) {
    if (dateArg === void 0) { dateArg = new Date(); }
    if (locale === void 0) { locale = 'en-US'; }
    if (dayType === void 0) { dayType = 'long'; }
    var newDays = [];
    var newWeeks = weekDates(dateArg);
    for (var _i = 0, newWeeks_1 = newWeeks; _i < newWeeks_1.length; _i++) {
        var newWeek = newWeeks_1[_i];
        var newObj = {};
        var currentDate = new Date(newWeek || null);
        newObj['value'] = newWeek;
        //@ts-ignore
        newObj['text'] = new Intl.DateTimeFormat(locale, { weekday: dayType }).format(currentDate);
        newDays.push(newObj);
    }
    return newDays;
};

var month = function (yearArg, monthArg, locale, monthType) {
    if (yearArg === void 0) { yearArg = getYearHelper(); }
    if (monthArg === void 0) { monthArg = getMonthHelper(); }
    if (locale === void 0) { locale = 'en-US'; }
    if (monthType === void 0) { monthType = 'long'; }
    var currentMonth = new Date(yearArg, Number(monthArg) - 1);
    //@ts-ignore
    return new Intl.DateTimeFormat(locale, { month: monthType }).format(currentMonth);
};
var months = function (locale, monthType) {
    if (locale === void 0) { locale = 'en-US'; }
    if (monthType === void 0) { monthType = 'long'; }
    var newMonths = [];
    var newYear = Number(new Date().getFullYear());
    for (var i = 0; i <= 11; i++) {
        var newObj = {};
        var currentMonth = new Date(newYear, i);
        newObj['value'] = doubleFormat(Number(i) + 1);
        //@ts-ignore
        newObj['text'] = new Intl.DateTimeFormat(locale, { month: monthType }).format(currentMonth);
        newMonths.push(newObj);
    }
    return newMonths;
};

var years = function (year, ellipsis, control) {
    if (year === void 0) { year = new Date().getFullYear(); }
    if (ellipsis === void 0) { ellipsis = 5; }
    if (control === void 0) { control = false; }
    var newYears = [];
    var prevYear = Number(year) - (Number(ellipsis) + 1);
    var nextYear = Number(year) + Number(ellipsis);
    for (var i = prevYear; i <= nextYear; i++) {
        if (control) {
            var newObj = {
                value: i,
                text: i
            };
            if (i === prevYear) {
                newObj.text = 'Prev';
            }
            else if (i === nextYear) {
                newObj.text = 'Next';
            }
            newYears.push(newObj);
        }
        else {
            newYears.push(i);
        }
    }
    return newYears;
};

var add = function (date, value, type, locale, options) {
    if (type === void 0) { type = ''; }
    if (locale === void 0) { locale = ''; }
    if (options === void 0) { options = {}; }
    var newDate = new Date(date || null);
    newDate.setDate(newDate.getDate() + (value || 1));
    return format$1(newDate, type, locale, options);
};
var sub = function (date, value, type, locale, options) {
    if (type === void 0) { type = ''; }
    if (locale === void 0) { locale = ''; }
    if (options === void 0) { options = {}; }
    var newDate = new Date(date || null);
    newDate.setDate(newDate.getDate() - (value || 1));
    return format$1(newDate, type, locale, options);
};

var date = /*#__PURE__*/Object.freeze({
    __proto__: null,
    now: now$1,
    format: format$1,
    isBefore: isBefore,
    isAfter: isAfter,
    isBetween: isBetween$1,
    daysInMonth: daysInMonth,
    daysOfPrevMonth: daysOfPrevMonth,
    daysOfNextMonth: daysOfNextMonth,
    daysInYear: daysInYear,
    daysInBetween: daysInBetween,
    monthsInBetween: monthsInBetween,
    yearsInBetween: yearsInBetween,
    doubleFormat: doubleFormat,
    day: day,
    days: days,
    week: week,
    weeks: weeks,
    weekDates: weekDates,
    month: month,
    months: months,
    years: years,
    add: add,
    sub: sub
});

var separator = function (value, separator, float, digit) {
    if (separator === void 0) { separator = ','; }
    if (float === void 0) { float = false; }
    if (digit === void 0) { digit = 2; }
    var locale = (separator === '.') ? 'de-DE' : 'en-US';
    var newNumber = String(new Intl.NumberFormat(locale).format(Number(value)));
    if (float === true) {
        var takeNumber = String(Number(value));
        if (takeNumber.includes('.')) {
            takeNumber = Number(takeNumber).toFixed(digit);
            takeNumber = takeNumber.split('.')[1];
        }
        else {
            takeNumber = new Array(digit).fill(0).join('');
        }
        // the float separator will be the oposite
        var dotComma = (separator === '.') ? ',' : '.';
        newNumber = newNumber.split(dotComma)[0].trim();
        newNumber = newNumber + dotComma + takeNumber;
    }
    return newNumber;
};

var percentage = function (curVal, fromVal, symbol) {
    if (symbol === void 0) { symbol = false; }
    var resNum = String(Math.round(((Number(curVal) / Number(fromVal)) - 1) * 100));
    if (symbol === true) {
        resNum = resNum + '%';
    }
    return resNum;
};

var unit = function (value, digits, type) {
    if (digits === void 0) { digits = 2; }
    if (type === void 0) { type = 'normal'; }
    var lookup = [
        { id: 1, value: 1, symbol: '' },
        { id: 2, value: 1e3, symbol: 'K' },
        { id: 3, value: 1e6, symbol: 'M' },
        { id: 4, value: 1e9, symbol: 'G' },
        { id: 5, value: 1e12, symbol: 'T' },
        { id: 6, value: 1e15, symbol: 'P' },
        { id: 7, value: 1e18, symbol: 'E' },
        { id: 8, value: 1e21, symbol: 'Z' },
        { id: 9, value: 1e24, symbol: 'Y' }
    ];
    if (type !== 'normal') {
        lookup = lookup.map(function (item) {
            if (type === 'decimal') {
                if (item.id === 2) {
                    item.symbol = 'k';
                }
            }
            else if (type === 'money') {
                if (item.id === 4) {
                    item.symbol = 'B';
                }
            }
            else if (type === 'binary') {
                if (item.id !== 1) {
                    item.value = item.value + (24 * (item.id - 1));
                    item.symbol = item.symbol + 'i';
                }
            }
            else if (type === 'byte') {
                if (item.id !== 1) {
                    item.value = item.value + (24 * (item.id - 1));
                    item.symbol = item.symbol + 'B';
                }
            }
            return item;
        });
    }
    var rx = /\.0+$|(\.[0-9]*[1-9])0+$/;
    var item = lookup.slice().reverse().find(function (item) {
        return Number(value) >= item.value;
    });
    return item ? (Number(value) / item.value).toFixed(digits).replace(rx, '$1') + '' + item.symbol : '0';
};

var spaceBetween = function (numArg) {
    return String(numArg).replace(/\d{4}(?=.)/g, '$& ');
};

var roundOf = function (numArg) {
    var lookup = [1, 1e3, 1e6, 1e9, 1e12, 1e15, 1e18, 1e21, 1e24];
    var item = lookup.slice().reverse().find(function (item) {
        return Number(numArg) >= item;
    });
    return Math.round(Number(numArg) / item) * item;
};

// Taking random number between two numbers
var between = function (minArg, maxArg, exclude) {
    /* between helper from Alga JS by Tedir Ghazali */
    if (exclude === void 0) { exclude = true; }
    // make sure all the argument numbers are not in string type 
    // and here we will produce a number in between minVal and maxVal
    var minVal = exclude ? (Number(minArg) + 1) : Number(minArg);
    var maxVal = exclude ? (Number(maxArg) - 1) : Number(maxArg);
    // generate random number from 0 to maxVal number
    var randVal = Math.floor(Math.random() * Number(maxVal));
    // and check if the randVal is less than minVal, then calculate between minVal and randVal
    if (randVal <= minVal) {
        randVal = Number(minVal) + Number(randVal);
    }
    return randVal;
};
// Checking is this number in between two numbers
var isBetween = function (numArg, minArg, maxArg) {
    /* isBetween helper from Alga JS by Tedir Ghazali */
    // make sure all the argument numbers are not in string type
    var numVal = Number(numArg);
    var minVal = Number(minArg);
    var maxVal = Number(maxArg);
    // the result of this helper will be in boolean type
    var boolVal = false;
    // if numVal is above minVal and below maxVal, then return it to true
    if (numVal >= minVal && numVal <= maxVal) {
        boolVal = true;
    }
    return boolVal;
};

var number = /*#__PURE__*/Object.freeze({
    __proto__: null,
    separator: separator,
    percentage: percentage,
    unit: unit,
    spaceBetween: spaceBetween,
    roundOf: roundOf,
    between: between,
    isBetween: isBetween
});

var filter = function (fromObject, propKey, valArray) {
    if (valArray === void 0) { valArray = false; }
    var newObject = {};
    var filterObject = Object.entries(fromObject).filter(function (item) {
        return item[0].includes(propKey);
    });
    newObject = Object.fromEntries(new Map(filterObject));
    if (valArray === true) {
        newObject = filterObject.map(function (item) {
            return item[1];
        });
    }
    return newObject;
};
var filterBy = function (fromObject, propVal, valArray) {
    if (valArray === void 0) { valArray = false; }
    var newObject = {};
    var filterObject = Object.entries(fromObject).filter(function (item) {
        return item[1].includes(propVal);
    });
    newObject = Object.fromEntries(new Map(filterObject));
    if (valArray === true) {
        newObject = filterObject.map(function (item) {
            return item[1];
        });
    }
    return newObject;
};
var filterByKey = filter;
var filterByVal = filterBy;

var count = function (fromObject) {
    return Number(Object.entries(fromObject).length);
};

var object = /*#__PURE__*/Object.freeze({
    __proto__: null,
    remove: remove,
    removeBy: removeBy,
    removeByKey: removeByKey,
    removeByVal: removeByVal,
    filter: filter,
    filterBy: filterBy,
    filterByKey: filterByKey,
    filterByVal: filterByVal,
    count: count
});

var urlEncode = function (text, type) {
    if (type === void 0) { type = 'raw'; }
    var newString = encodeURI(text);
    if (type === 'param') {
        newString = encodeURIComponent(text);
    }
    return newString;
};
var urlDecode = function (text, type) {
    if (type === void 0) { type = 'raw'; }
    var newString = decodeURI(text);
    if (type === 'param') {
        newString = decodeURIComponent(text);
    }
    return newString;
};
var urlEncodeAsync = function (textPromise, type) {
    if (type === void 0) { type = 'raw'; }
    return __awaiter(void 0, void 0, void 0, function () {
        var text;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.resolve(textPromise)];
                case 1:
                    text = _a.sent();
                    return [2 /*return*/, Promise.resolve(urlEncode(text, type))];
            }
        });
    });
};
var urlDecodeAsync = function (textPromise, type) {
    if (type === void 0) { type = 'raw'; }
    return __awaiter(void 0, void 0, void 0, function () {
        var text;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, Promise.resolve(textPromise)];
                case 1:
                    text = _a.sent();
                    return [2 /*return*/, Promise.resolve(urlDecode(text, type))];
            }
        });
    });
};
var urlData = function (content, type) {
    return "data:".concat(type, ";base64,").concat(content);
};

var uniqid = function (lastId) {
    if (lastId === void 0) { lastId = 0; }
    var newId = '';
    var chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    var times = String(JSON.parse(new Date().toJSON().replace(/-|T|Z|:|\./g, '')));
    if (Number(lastId) >= 1) {
        newId += String(Number(lastId) + 1);
    }
    for (var i = 0; i < times.length; i++) {
        newId += chars.charAt(Math.floor(Math.random() * chars.length));
        newId += times.charAt(i);
    }
    return newId;
};

var random = function (size, type) {
    if (size === void 0) { size = 11; }
    if (type === void 0) { type = ''; }
    var randomString = '';
    var characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_~!@#$%^&*()+={}[]|:;<>,./?';
    if (type === 'alphadash') {
        characters = characters.slice(0, 64);
    }
    else if (type === 'alphanumeric') {
        characters = characters.slice(0, 62);
    }
    else if (type === 'alpha') {
        characters = characters.slice(10, 62);
    }
    else if (type === 'hex') {
        characters = characters.slice(0, 16);
    }
    else if (type === 'numeric') {
        characters = characters.slice(0, 10);
    }
    for (var i = 0; i < size; i++) {
        randomString += characters.charAt(Math.floor(Math.random() * characters.length));
    }
    return randomString;
};

var capitalize = function (str, opt) {
    if (opt === void 0) { opt = ''; }
    var capStr = str;
    if (opt === 'multiple') {
        capStr = capStr.toLowerCase().replace(/\w\S*/g, function (w) { return (w.replace(/^\w/, function (c) { return c.toUpperCase(); })); });
    }
    else if (opt === 'single') {
        capStr = capStr.toLowerCase().trimStart().replace(/^\w/, function (c) { return c.toUpperCase(); });
    }
    else {
        capStr = capStr.trimStart().replace(/^\w/, function (c) { return c.toUpperCase(); });
    }
    return capStr;
};

var camelCase = function (strCase) {
    var newCase = strCase.replace(/-|_/g, ' ').replace(/[A-Z]/g, ' $&');
    newCase = capitalize(newCase, 'multiple');
    return newCase.trimStart().replace(/^\w/, function (c) { return c.toLowerCase(); }).replaceAll(' ', '');
};
var pascalCase = function (strCase) {
    var newCase = strCase.replace(/-|_/g, ' ').replace(/[A-Z]/g, ' $&');
    newCase = capitalize(newCase, 'multiple');
    return newCase.replaceAll(' ', '');
};
var snakeCase = function (strCase) {
    var newCase = strCase.replace(/-|_/g, ' ').replace(/[A-Z]/g, ' $&');
    newCase = capitalize(newCase, 'multiple');
    return newCase.replaceAll(' ', '').replace(/[A-Z]+(?![a-z])|[A-Z]/g, function (match, offset) {
        return (offset > 0 ? '_' : '') + match.toLowerCase();
    });
};
var kebabCase = function (strCase) {
    var newCase = strCase.replace(/-|_/g, ' ').replace(/[A-Z]/g, ' $&');
    newCase = capitalize(newCase, 'multiple');
    return newCase.replaceAll(' ', '').replace(/[A-Z]+(?![a-z])|[A-Z]/g, function (match, offset) {
        return (offset > 0 ? '-' : '') + match.toLowerCase();
    });
};

var slug = function (val, max, duplicate) {
    if (max === void 0) { max = 0; }
    if (duplicate === void 0) { duplicate = 0; }
    var newVal = val.trim();
    // Make the string lowercase and nomalize or replace accented characters or swap ñ for n.
    newVal = newVal.toLowerCase().normalize("NFD").replace(/[\u0300-\u036f]/g, "");
    // only allow lowercase chars and numbers, replace spaces and dashes to single dash.
    newVal = newVal.replace(/[^a-z0-9 -]/g, '').replace(/\s+/g, '-').replace(/-+/g, '-');
    if (Number(max) > 0) {
        newVal = newVal.slice(0, Number(max));
    }
    if (Number(duplicate) > 0) {
        newVal = newVal + '-' + duplicate;
    }
    return newVal;
};

var string = /*#__PURE__*/Object.freeze({
    __proto__: null,
    urlEncode: urlEncode,
    urlDecode: urlDecode,
    urlEncodeAsync: urlEncodeAsync,
    urlDecodeAsync: urlDecodeAsync,
    urlData: urlData,
    uniqid: uniqid,
    random: random,
    capitalize: capitalize,
    camelCase: camelCase,
    pascalCase: pascalCase,
    snakeCase: snakeCase,
    kebabCase: kebabCase,
    slug: slug
});

var relative = function (dateValue, timeZone, locale, options, type) {
    if (timeZone === void 0) { timeZone = 'utc'; }
    if (locale === void 0) { locale = 'en-US'; }
    if (options === void 0) { options = {}; }
    if (type === void 0) { type = 'long'; }
    var nowDate = new Date();
    var valDate = new Date(dateValue);
    if (timeZone !== 'utc') {
        valDate = new Date(new Date(dateValue).toJSON());
    }
    var seconds = Math.round((valDate.valueOf() - nowDate.valueOf()) / 1000);
    var newTimeRelative = new Intl.RelativeTimeFormat(locale, options).format(seconds, 'second');
    if (type === 'short') {
        newTimeRelative = "".concat(Math.abs(Math.round(seconds)), "s");
    }
    var interval = seconds / 31536000;
    if (Math.abs(interval) > 1) {
        var newInterval = Math.round(interval);
        newTimeRelative = new Intl.RelativeTimeFormat(locale, options).format(newInterval, 'year');
        if (type === 'short') {
            newTimeRelative = "".concat(Math.abs(Math.round(newInterval)), "y");
        }
    }
    else {
        interval = seconds / 2592000;
        if (Math.abs(interval) > 1) {
            var newInterval = Math.round(interval);
            newTimeRelative = new Intl.RelativeTimeFormat(locale, options).format(newInterval, 'month');
            if (type === 'short') {
                newTimeRelative = "".concat(Math.abs(Math.round(newInterval)), "mo");
            }
        }
        else {
            interval = seconds / 86400;
            if (Math.abs(interval) > 1) {
                var newInterval = Math.round(interval);
                newTimeRelative = new Intl.RelativeTimeFormat(locale, options).format(newInterval, 'day');
                if (type === 'short') {
                    newTimeRelative = "".concat(Math.abs(Math.round(newInterval)), "d");
                }
            }
            else {
                interval = seconds / 3600;
                if (Math.abs(interval) > 1) {
                    var newInterval = Math.round(interval);
                    newTimeRelative = new Intl.RelativeTimeFormat(locale, options).format(newInterval, 'hour');
                    if (type === 'short') {
                        newTimeRelative = "".concat(Math.abs(Math.round(newInterval)), "h");
                    }
                }
                else {
                    interval = seconds / 60;
                    if (Math.abs(interval) > 1) {
                        var newInterval = Math.round(interval);
                        newTimeRelative = new Intl.RelativeTimeFormat(locale, options).format(newInterval, 'minute');
                        if (type === 'short') {
                            newTimeRelative = "".concat(Math.abs(Math.round(newInterval)), "m");
                        }
                    }
                }
            }
        }
    }
    return newTimeRelative;
};

var hoursInBetween = function (startDateArg, endDateArg) {
    var startDate = new Date(startDateArg);
    var endDate = new Date(endDateArg);
    var milliseconds = Math.abs(Number(startDate.getTime()) - Number(endDate.getTime()));
    var newHours = milliseconds / 36e5;
    return Number(newHours.toFixed(0));
};

var reading = function (textArg, wpmArg, typeArg) {
    if (textArg === void 0) { textArg = ''; }
    if (wpmArg === void 0) { wpmArg = 250; }
    if (typeArg === void 0) { typeArg = 'minute'; }
    var words = textArg.split(' ').length;
    var readingTime = Number(words) / Number(wpmArg);
    if (typeArg === 'second') {
        readingTime = Number(readingTime) * 60;
    }
    else if (typeArg === 'millisecond') {
        readingTime = Number(readingTime) * 60000;
    }
    return Math.ceil(readingTime);
};

var format = function (value, separator, display) {
    var _a;
    if (separator === void 0) { separator = ':'; }
    if (display === void 0) { display = 3; }
    var newValues = (_a = value === null || value === void 0 ? void 0 : value.split(separator)) === null || _a === void 0 ? void 0 : _a.slice(0, display);
    if (newValues.length < display) {
        for (var i = 0; i < (Number(display) - Number(newValues.length)); i++) {
            newValues.push('0');
        }
    }
    return newValues.join(separator);
};

var now = function (separator, display) {
    if (separator === void 0) { separator = ':'; }
    if (display === void 0) { display = 3; }
    var newNow = new Date().toTimeString().split(' ')[0];
    newNow = format(newNow, separator, display);
    return newNow;
};

var double = function (value, separator, type) {
    if (separator === void 0) { separator = ':'; }
    if (type === void 0) { type = 'double'; }
    var newValues = value.split(separator);
    if (type === 'double') {
        newValues = newValues.map(function (i) {
            if (i.length <= 1) {
                i = '0' + i;
            }
            return i;
        });
    }
    else if (type === 'normal') {
        newValues = newValues.map(function (i, ind) {
            if (i.length <= 1 && ind >= 1) {
                i = '0' + i;
            }
            return i;
        });
    }
    return newValues.join(separator);
};

var toDecimal = function (value, fixed, separator, msDivider) {
    if (fixed === void 0) { fixed = 2; }
    if (separator === void 0) { separator = ':'; }
    if (msDivider === void 0) { msDivider = '.'; }
    var minuteDecimal = 100 / 60;
    var timeArr = value.trim().split(separator);
    var countDecimal = 0;
    if (timeArr.length >= 2) {
        countDecimal = Number(timeArr[1]) * Number(minuteDecimal);
        if (timeArr.length >= 3) {
            var secondArr = String(timeArr[2]).split(msDivider);
            var countSecond = (Number(secondArr[0]) * Number(minuteDecimal)) / 100;
            var countMillisecond = 0;
            if (secondArr.length >= 2) {
                countMillisecond = Number(secondArr[1]) / 1000;
            }
            countDecimal = Number(countDecimal) + (Number(countSecond) + Number(countMillisecond));
        }
    }
    return (Number(timeArr[0]) + (Number(countDecimal) / 100)).toFixed(fixed);
};
var fromDecimal = function (value, separator, display) {
    if (separator === void 0) { separator = ':'; }
    if (display === void 0) { display = 2; }
    var timeArr = String(value).split('.');
    var countMinute = '00';
    if (timeArr.length >= 2) {
        countMinute = (60 * Number('0.' + timeArr[1])).toFixed(2);
        countMinute = countMinute.replace('.', ':');
    }
    return format((timeArr[0] + separator + countMinute), separator, display);
};

//export * from './nowTime.js'

var time = /*#__PURE__*/Object.freeze({
    __proto__: null,
    relative: relative,
    hoursInBetween: hoursInBetween,
    reading: reading,
    now: now,
    format: format,
    double: double,
    toDecimal: toDecimal,
    fromDecimal: fromDecimal
});

exports.array = array;
exports.date = date;
exports.number = number;
exports.object = object;
exports.string = string;
exports.time = time;
