(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["agGrid"] = factory();
	else
		root["agGrid"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 5372:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.advancedFilterCSS = void 0;
exports.advancedFilterCSS = `.ag-advanced-filter-header{align-items:center;background-color:var(--ag-header-background-color);border-bottom:var(--ag-header-row-border);display:flex;padding-left:var(--ag-cell-horizontal-padding);padding-right:var(--ag-cell-horizontal-padding);position:relative}.ag-advanced-filter{align-items:center;display:flex;width:100%}.ag-advanced-filter-apply-button,.ag-advanced-filter-builder-button{line-height:normal;white-space:nowrap}:where(.ag-ltr) .ag-advanced-filter-apply-button,:where(.ag-ltr) .ag-advanced-filter-builder-button{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-advanced-filter-apply-button,:where(.ag-rtl) .ag-advanced-filter-builder-button{margin-right:calc(var(--ag-spacing)*2)}.ag-advanced-filter-builder-button{align-items:center;background-color:unset;border:0;display:flex;font-size:var(--ag-font-size);font-weight:600;padding:var(--ag-spacing);&:where(:not(:disabled)){cursor:pointer;&:hover{background-color:var(--ag-row-hover-color)}}}:where(.ag-ltr) .ag-advanced-filter-builder-button-label{margin-left:var(--ag-spacing)}:where(.ag-rtl) .ag-advanced-filter-builder-button-label{margin-right:var(--ag-spacing)}.ag-advanced-filter-builder{display:flex;flex-direction:column;-webkit-user-select:none;-moz-user-select:none;user-select:none;width:100%}.ag-advanced-filter-builder-list{flex:1;overflow:auto}.ag-advanced-filter-builder-button-panel{border-top:var(--ag-advanced-filter-builder-button-bar-border);display:flex;justify-content:flex-end;padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}:where(.ag-ltr) .ag-advanced-filter-builder-apply-button,:where(.ag-ltr) .ag-advanced-filter-builder-cancel-button{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-advanced-filter-builder-apply-button,:where(.ag-rtl) .ag-advanced-filter-builder-cancel-button{margin-right:calc(var(--ag-spacing)*2)}.ag-advanced-filter-builder-item-wrapper{align-items:center;display:flex;flex:1 1 auto;justify-content:space-between;overflow:hidden}:where(.ag-ltr) .ag-advanced-filter-builder-item-wrapper{padding-left:calc(var(--ag-icon-size)/2);padding-right:var(--ag-icon-size)}:where(.ag-rtl) .ag-advanced-filter-builder-item-wrapper{padding-left:var(--ag-icon-size);padding-right:calc(var(--ag-icon-size)/2)}:where(.ag-virtual-list-viewport .ag-advanced-filter-builder-item-wrapper) .ag-tab-guard{position:absolute}.ag-advanced-filter-builder-item-tree-lines>*{width:var(--ag-advanced-filter-builder-indent-size)}.ag-advanced-filter-builder-item-tree-line-root{width:var(--ag-icon-size);&:before{height:50%;top:50%}}.ag-advanced-filter-builder-item-tree-line-horizontal,.ag-advanced-filter-builder-item-tree-line-vertical,.ag-advanced-filter-builder-item-tree-line-vertical-bottom,.ag-advanced-filter-builder-item-tree-line-vertical-top{align-items:center;display:flex;height:100%;position:relative;&:after,&:before{content:"";height:100%;position:absolute}}.ag-advanced-filter-builder-item-tree-line-horizontal:after{border-bottom:1px solid var(--ag-border-color);height:50%;top:0;width:calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size))}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-horizontal:after{left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-horizontal:after{right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-tree-line-vertical:before{top:0;width:calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size)/2)}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-vertical:before{border-left:1px solid var(--ag-border-color);left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-vertical:before{border-right:1px solid var(--ag-border-color);right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-tree-line-vertical-top:before{height:50%;top:0;width:calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size)/2)}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-vertical-top:before{border-left:1px solid var(--ag-border-color);left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-vertical-top:before{border-right:1px solid var(--ag-border-color);right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-tree-line-vertical-bottom:before{height:calc(50% - var(--ag-icon-size)*1.5/2);top:calc(50% + var(--ag-icon-size)*1.5/2);width:calc(var(--ag-icon-size)/2)}:where(.ag-ltr) .ag-advanced-filter-builder-item-tree-line-vertical-bottom:before{border-left:1px solid var(--ag-border-color);left:calc(var(--ag-icon-size)/2)}:where(.ag-rtl) .ag-advanced-filter-builder-item-tree-line-vertical-bottom:before{border-right:1px solid var(--ag-border-color);right:calc(var(--ag-icon-size)/2)}.ag-advanced-filter-builder-item-condition{padding-bottom:var(--ag-spacing);padding-top:var(--ag-spacing)}.ag-advanced-filter-builder-item,.ag-advanced-filter-builder-item-buttons,.ag-advanced-filter-builder-item-condition,.ag-advanced-filter-builder-item-tree-lines,.ag-advanced-filter-builder-pill,.ag-advanced-filter-builder-pill-wrapper{align-items:center;display:flex;height:100%}.ag-advanced-filter-builder-pill-wrapper{margin:0 var(--ag-spacing)}.ag-advanced-filter-builder-pill{border-radius:var(--ag-border-radius);min-height:calc(100% - var(--ag-spacing)*3);min-width:calc(var(--ag-spacing)*2);padding:var(--ag-spacing) calc(var(--ag-spacing)*2);position:relative}:where(.ag-advanced-filter-builder-pill){.ag-advanced-filter-builder-value-number{font-family:monospace;font-weight:700}.ag-advanced-filter-builder-value-empty{color:var(--ag-subtle-text-color)}}:where(.ag-ltr) :where(.ag-advanced-filter-builder-pill){.ag-picker-field-display{margin-right:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-advanced-filter-builder-pill){.ag-picker-field-display{margin-left:var(--ag-spacing)}}.ag-advanced-filter-builder-pill-display{font-weight:500;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-advanced-filter-builder-join-pill{background-color:var(--ag-advanced-filter-builder-join-pill-color);cursor:pointer}.ag-advanced-filter-builder-column-pill{background-color:var(--ag-advanced-filter-builder-column-pill-color);cursor:pointer}.ag-advanced-filter-builder-option-pill{background-color:var(--ag-advanced-filter-builder-option-pill-color);cursor:pointer}.ag-advanced-filter-builder-value-pill{background-color:var(--ag-advanced-filter-builder-value-pill-color);cursor:text;max-width:140px;:where(.ag-advanced-filter-builder-pill-display){display:block}}.ag-advanced-filter-builder-item-buttons>*{margin:0 calc(var(--ag-spacing)*.5)}.ag-advanced-filter-builder-item-button{color:var(--ag-subtle-text-color);cursor:pointer;position:relative}.ag-advanced-filter-builder-item-button,.ag-advanced-filter-builder-pill{&:focus-visible{box-shadow:var(--ag-focus-shadow)}}.ag-advanced-filter-builder-item-button-disabled{cursor:default;opacity:.5}.ag-advanced-filter-builder-virtual-list-container{top:var(--ag-spacing)}.ag-advanced-filter-builder-virtual-list-item{cursor:default;display:flex;height:var(--ag-list-item-height);&:hover{background-color:var(--ag-row-hover-color);:where(.ag-advanced-filter-builder-item-button){opacity:1}}}.ag-advanced-filter-builder-invalid{color:var(--ag-invalid-color);cursor:default;margin:0 var(--ag-spacing)}:where(.ag-advanced-filter-builder-validation) .ag-advanced-filter-builder-invalid,:where(.ag-advanced-filter-builder-virtual-list-item-highlight) .ag-advanced-filter-builder-item-button:focus-visible{opacity:1}`;


/***/ }),

/***/ 6138:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hideAdvancedFilterBuilder = exports.showAdvancedFilterBuilder = exports.setAdvancedFilterModel = exports.getAdvancedFilterModel = void 0;
function getAdvancedFilterModel(beans) {
    return beans.filterManager?.getAdvFilterModel() ?? null;
}
exports.getAdvancedFilterModel = getAdvancedFilterModel;
function setAdvancedFilterModel(beans, advancedFilterModel) {
    beans.filterManager?.setAdvFilterModel(advancedFilterModel);
}
exports.setAdvancedFilterModel = setAdvancedFilterModel;
function showAdvancedFilterBuilder(beans) {
    beans.filterManager?.toggleAdvFilterBuilder(true, 'api');
}
exports.showAdvancedFilterBuilder = showAdvancedFilterBuilder;
function hideAdvancedFilterBuilder(beans) {
    beans.filterManager?.toggleAdvFilterBuilder(false, 'api');
}
exports.hideAdvancedFilterBuilder = hideAdvancedFilterBuilder;


/***/ }),

/***/ 2583:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agAutocomplete_1 = __webpack_require__(2611);
class AdvancedFilterComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.advFilterExpSvc = beans.advFilterExpSvc;
        this.advancedFilter = beans.advancedFilter;
        this.filterManager = beans.filterManager;
        this.registry = beans.registry;
    }
    constructor() {
        super(
        /* html */ `
            <div class="ag-advanced-filter" role="presentation" tabindex="-1">
                <ag-autocomplete data-ref="eAutocomplete"></ag-autocomplete>
                <button class="ag-button ag-standard-button ag-advanced-filter-apply-button" data-ref="eApplyFilterButton"></button>
                <button class="ag-button ag-advanced-filter-builder-button" data-ref="eBuilderFilterButton">
                    <span data-ref="eBuilderFilterButtonIcon" aria-hidden="true"></span>
                    <span class="ag-advanced-filter-builder-button-label" data-ref="eBuilderFilterButtonLabel"></span>
                </button>
            </div>`, [agAutocomplete_1.AgAutocompleteSelector]);
        this.eAutocomplete = ag_grid_community_1.RefPlaceholder;
        this.eApplyFilterButton = ag_grid_community_1.RefPlaceholder;
        this.eBuilderFilterButton = ag_grid_community_1.RefPlaceholder;
        this.eBuilderFilterButtonIcon = ag_grid_community_1.RefPlaceholder;
        this.eBuilderFilterButtonLabel = ag_grid_community_1.RefPlaceholder;
        this.expressionParser = null;
        this.isApplyDisabled = true;
        this.builderOpen = false;
    }
    postConstruct() {
        this.tooltipFeature = this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.getGui(),
            getTooltipShowDelayOverride: () => 1000,
            getLocation: () => 'advancedFilter',
        }));
        this.eAutocomplete
            .setListGenerator((_value, position) => this.generateAutocompleteListParams(position))
            .setValidator(() => this.validateValue())
            .setForceLastSelection((lastSelection, searchString) => this.forceLastSelection(lastSelection, searchString))
            .setInputAriaLabel(this.advFilterExpSvc.translate('ariaAdvancedFilterInput'))
            .setListAriaLabel(this.advFilterExpSvc.translate('ariaLabelAdvancedFilterAutocomplete'));
        this.refresh();
        this.addManagedListeners(this.eAutocomplete, {
            eventValueChanged: ({ value }) => this.onValueChanged(value),
            eventValueConfirmed: ({ isValid }) => this.onValueConfirmed(isValid),
            eventOptionSelected: ({ position, updateEntry, autocompleteType }) => this.onOptionSelected(position, updateEntry, autocompleteType),
            eventValidChanged: ({ isValid, validationMessage }) => this.onValidChanged(isValid, validationMessage),
        });
        this.setupApplyButton();
        this.setupBuilderButton();
    }
    refresh() {
        const expression = this.advancedFilter.getExpressionDisplayValue();
        this.eAutocomplete.setValue({
            value: expression ?? '',
            position: expression?.length,
            updateListOnlyIfOpen: true,
        });
    }
    setInputDisabled(disabled) {
        this.eAutocomplete.setInputDisabled(disabled);
        (0, ag_grid_community_1._setDisabled)(this.eApplyFilterButton, disabled || this.isApplyDisabled);
    }
    setupApplyButton() {
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.eApplyFilterButton.innerText = this.advFilterExpSvc.translate('advancedFilterApply');
        this.activateTabIndex([this.eApplyFilterButton]);
        this.addManagedElementListeners(this.eApplyFilterButton, {
            click: () => this.onValueConfirmed(this.eAutocomplete.isValid()),
        });
        (0, ag_grid_community_1._setDisabled)(this.eApplyFilterButton, this.isApplyDisabled);
    }
    setupBuilderButton() {
        this.eBuilderFilterButtonIcon.appendChild((0, ag_grid_community_1._createIconNoSpan)('advancedFilterBuilder', this.beans));
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.eBuilderFilterButtonLabel.innerText = this.advFilterExpSvc.translate('advancedFilterBuilder');
        this.activateTabIndex([this.eBuilderFilterButton]);
        this.addManagedElementListeners(this.eBuilderFilterButton, { click: () => this.openBuilder() });
        this.addManagedListeners(this.advancedFilter.getCtrl(), {
            advancedFilterBuilderClosed: () => this.closeBuilder(),
        });
    }
    onValueChanged(value) {
        value = (0, ag_grid_community_1._makeNull)(value);
        this.advancedFilter.setExpressionDisplayValue(value);
        this.expressionParser = this.advancedFilter.createExpressionParser(value);
        const updatedExpression = this.expressionParser?.parseExpression();
        if (updatedExpression && updatedExpression !== value) {
            this.eAutocomplete.setValue({ value: updatedExpression, silent: true, restoreFocus: true });
        }
    }
    onValueConfirmed(isValid) {
        if (!isValid || this.isApplyDisabled) {
            return;
        }
        (0, ag_grid_community_1._setDisabled)(this.eApplyFilterButton, true);
        this.advancedFilter.applyExpression();
        this.filterManager?.onFilterChanged({ source: 'advancedFilter' });
    }
    onOptionSelected(position, updateEntry, type) {
        const { updatedValue, updatedPosition, hideAutocomplete } = this.updateExpression(position, updateEntry, type);
        this.eAutocomplete.setValue({
            value: updatedValue,
            position: updatedPosition,
            updateListOnlyIfOpen: hideAutocomplete,
            restoreFocus: true,
        });
    }
    validateValue() {
        return this.expressionParser?.isValid() ? null : this.expressionParser?.getValidationMessage() ?? null;
    }
    onValidChanged(isValid, validationMessage) {
        this.isApplyDisabled = !isValid || this.advancedFilter.isCurrentExpressionApplied();
        (0, ag_grid_community_1._setDisabled)(this.eApplyFilterButton, this.isApplyDisabled);
        this.tooltipFeature?.setTooltipAndRefresh(validationMessage);
    }
    generateAutocompleteListParams(position) {
        return this.expressionParser
            ? this.expressionParser.getAutocompleteListParams(position)
            : this.advFilterExpSvc.getDefaultAutocompleteListParams('');
    }
    updateExpression(position, updateEntry, type) {
        this.advFilterExpSvc.updateAutocompleteCache(updateEntry, type);
        return (this.expressionParser?.updateExpression(position, updateEntry, type) ??
            this.advancedFilter.getDefaultExpression(updateEntry));
    }
    forceLastSelection({ key, displayValue }, searchString) {
        return !!searchString.toLocaleLowerCase().match(`^${(displayValue ?? key).toLocaleLowerCase()}\\s*$`);
    }
    openBuilder() {
        if (this.builderOpen) {
            return;
        }
        this.builderOpen = true;
        (0, ag_grid_community_1._setDisabled)(this.eBuilderFilterButton, true);
        this.advancedFilter.getCtrl().toggleFilterBuilder({ source: 'ui', eventSource: this.eBuilderFilterButton });
    }
    closeBuilder() {
        if (!this.builderOpen) {
            return;
        }
        this.builderOpen = false;
        (0, ag_grid_community_1._setDisabled)(this.eBuilderFilterButton, false);
        this.eBuilderFilterButton.focus();
    }
}
exports.AdvancedFilterComp = AdvancedFilterComp;


/***/ }),

/***/ 5865:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterCtrl = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agDialog_1 = __webpack_require__(8775);
const advancedFilterComp_1 = __webpack_require__(2583);
const advancedFilterHeaderComp_1 = __webpack_require__(4858);
const advancedFilterBuilderComp_1 = __webpack_require__(8986);
class AdvancedFilterCtrl extends ag_grid_community_1.BeanStub {
    wireBeans(beans) {
        this.ctrlsSvc = beans.ctrlsSvc;
        this.popupSvc = beans.popupSvc;
        this.advFilterExpSvc = beans.advFilterExpSvc;
        this.environment = beans.environment;
    }
    constructor(enabled) {
        super();
        this.enabled = enabled;
    }
    postConstruct() {
        this.hasAdvancedFilterParent = !!this.gos.get('advancedFilterParent');
        this.ctrlsSvc.whenReady(this, () => this.setAdvancedFilterComp());
        this.addManagedEventListeners({
            advancedFilterEnabledChanged: ({ enabled }) => this.onEnabledChanged(enabled),
        });
        this.addManagedPropertyListener('advancedFilterParent', () => this.updateComps());
        this.addDestroyFunc(() => {
            this.destroyAdvancedFilterComp();
            this.destroyBean(this.eBuilderComp);
            if (this.eBuilderDialog && this.eBuilderDialog.isAlive()) {
                this.destroyBean(this.eBuilderDialog);
            }
        });
    }
    setupHeaderComp(eCompToInsertBefore) {
        if (this.eHeaderComp) {
            this.eHeaderComp?.getGui().remove();
            this.destroyBean(this.eHeaderComp);
        }
        this.eHeaderComp = this.createManagedBean(new advancedFilterHeaderComp_1.AdvancedFilterHeaderComp(this.enabled && !this.hasAdvancedFilterParent));
        eCompToInsertBefore.insertAdjacentElement('beforebegin', this.eHeaderComp.getGui());
    }
    focusHeaderComp() {
        if (this.eHeaderComp) {
            this.eHeaderComp.getFocusableElement().focus();
            return true;
        }
        return false;
    }
    refreshComp() {
        this.eFilterComp?.refresh();
        this.eHeaderComp?.refresh();
    }
    refreshBuilderComp() {
        this.eBuilderComp?.refresh();
    }
    getHeaderHeight() {
        return this.eHeaderComp?.getHeight() ?? 0;
    }
    setInputDisabled(disabled) {
        this.eFilterComp?.setInputDisabled(disabled);
        this.eHeaderComp?.setInputDisabled(disabled);
    }
    toggleFilterBuilder(params) {
        const { source, force, eventSource } = params;
        if ((force && this.eBuilderDialog) || (force === false && !this.eBuilderDialog)) {
            // state requested is already active
            return;
        }
        if (this.eBuilderDialog) {
            this.builderDestroySource = source;
            this.destroyBean(this.eBuilderDialog);
            return;
        }
        this.setInputDisabled(true);
        const { width, height, minWidth } = this.getBuilderDialogSize();
        this.eBuilderComp = this.createBean(new advancedFilterBuilderComp_1.AdvancedFilterBuilderComp());
        this.eBuilderDialog = this.createBean(new agDialog_1.AgDialog({
            title: this.advFilterExpSvc.translate('advancedFilterBuilderTitle'),
            component: this.eBuilderComp,
            width,
            height,
            resizable: true,
            movable: true,
            maximizable: true,
            centered: true,
            closable: true,
            minWidth,
            afterGuiAttached: () => this.eBuilderComp?.afterGuiAttached(),
            postProcessPopupParams: {
                type: 'advancedFilterBuilder',
                eventSource,
            },
        }));
        this.dispatchFilterBuilderVisibleChangedEvent(source, true);
        this.eBuilderDialog.addEventListener('destroyed', () => {
            this.destroyBean(this.eBuilderComp);
            this.eBuilderComp = undefined;
            this.eBuilderDialog = undefined;
            this.setInputDisabled(false);
            this.dispatchLocalEvent({
                type: 'advancedFilterBuilderClosed',
            });
            this.dispatchFilterBuilderVisibleChangedEvent(this.builderDestroySource ?? 'ui', false);
            this.builderDestroySource = undefined;
        });
    }
    dispatchFilterBuilderVisibleChangedEvent(source, visible) {
        this.eventSvc.dispatchEvent({
            type: 'advancedFilterBuilderVisibleChanged',
            source,
            visible,
        });
    }
    getBuilderDialogSize() {
        const minWidth = this.gos.get('advancedFilterBuilderParams')?.minWidth ?? 500;
        const popupParent = this.popupSvc.getPopupParent();
        const maxWidth = Math.round((0, ag_grid_community_1._getAbsoluteWidth)(popupParent)) - 2; // assume 1 pixel border
        const maxHeight = Math.round((0, ag_grid_community_1._getAbsoluteHeight)(popupParent) * 0.75) - 2;
        const width = Math.min(Math.max(600, minWidth), maxWidth);
        const height = Math.min(600, maxHeight);
        return { width, height, minWidth };
    }
    onEnabledChanged(enabled) {
        this.enabled = enabled;
        this.updateComps();
    }
    updateComps() {
        this.setAdvancedFilterComp();
        this.setHeaderCompEnabled();
        this.eventSvc.dispatchEvent({
            type: 'headerHeightChanged',
        });
    }
    setAdvancedFilterComp() {
        this.destroyAdvancedFilterComp();
        if (!this.enabled) {
            return;
        }
        const advancedFilterParent = this.gos.get('advancedFilterParent');
        this.hasAdvancedFilterParent = !!advancedFilterParent;
        if (advancedFilterParent) {
            // unmanaged as can be recreated
            const eAdvancedFilterComp = this.createBean(new advancedFilterComp_1.AdvancedFilterComp());
            const eAdvancedFilterCompGui = eAdvancedFilterComp.getGui();
            this.environment.applyThemeClasses(eAdvancedFilterCompGui);
            eAdvancedFilterCompGui.classList.add(this.gos.get('enableRtl') ? 'ag-rtl' : 'ag-ltr');
            advancedFilterParent.appendChild(eAdvancedFilterCompGui);
            this.eFilterComp = eAdvancedFilterComp;
        }
    }
    setHeaderCompEnabled() {
        this.eHeaderComp?.setEnabled(this.enabled && !this.hasAdvancedFilterParent);
    }
    destroyAdvancedFilterComp() {
        if (this.eFilterComp) {
            (0, ag_grid_community_1._removeFromParent)(this.eFilterComp.getGui());
            this.destroyBean(this.eFilterComp);
        }
    }
}
exports.AdvancedFilterCtrl = AdvancedFilterCtrl;


/***/ }),

/***/ 1723:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterExpressionService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const advancedFilterLocaleText_1 = __webpack_require__(8397);
const colFilterExpressionParser_1 = __webpack_require__(9023);
const filterExpressionOperators_1 = __webpack_require__(9459);
class AdvancedFilterExpressionService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'advFilterExpSvc';
        this.columnNameToIdMap = {};
        this.columnAutocompleteEntries = null;
        this.expressionEvaluatorParams = {};
    }
    wireBeans(beans) {
        this.valueSvc = beans.valueSvc;
        this.colModel = beans.colModel;
        this.colNames = beans.colNames;
        this.dataTypeSvc = beans.dataTypeSvc;
    }
    postConstruct() {
        this.expressionJoinOperators = this.generateExpressionJoinOperators();
        this.expressionOperators = this.generateExpressionOperators();
    }
    parseJoinOperator(model) {
        const { type } = model;
        return this.expressionJoinOperators[type] ?? type;
    }
    getColumnDisplayValue(model) {
        const { colId } = model;
        const columnEntries = this.getColumnAutocompleteEntries();
        const columnEntry = columnEntries.find(({ key }) => key === colId);
        let columnName;
        if (columnEntry) {
            columnName = columnEntry.displayValue;
            this.columnNameToIdMap[columnName.toLocaleUpperCase()] = { colId, columnName };
        }
        else {
            columnName = colId;
        }
        return columnName;
    }
    getOperatorDisplayValue(model) {
        return this.getExpressionOperator(model.filterType, model.type)?.displayValue ?? model.type;
    }
    getOperandModelValue(operand, baseCellDataType, column) {
        switch (baseCellDataType) {
            case 'number':
                return (0, ag_grid_community_1._exists)(operand) ? Number(operand) : null;
            case 'date':
                return (0, ag_grid_community_1._serialiseDate)(this.valueSvc.parseValue(column, null, operand, undefined), false);
            case 'dateString': {
                // displayed string format may be different from data string format, so parse before converting to date
                const parsedDateString = this.valueSvc.parseValue(column, null, operand, undefined);
                return this.dataTypeSvc
                    ? (0, ag_grid_community_1._serialiseDate)(this.dataTypeSvc.getDateParserFunction(column)(parsedDateString) ?? null, false)
                    : parsedDateString;
            }
        }
        return operand;
    }
    getOperandDisplayValue(model, skipFormatting) {
        const { colId, filter } = model;
        const column = this.colModel.getColDefCol(colId);
        let operand = '';
        if (filter != null) {
            let operand1;
            switch (model.filterType) {
                case 'number':
                    operand1 = (0, ag_grid_community_1._toStringOrNull)(filter) ?? '';
                    break;
                case 'date': {
                    const dateValue = (0, ag_grid_community_1._parseDateTimeFromString)(filter);
                    operand1 = column ? this.valueSvc.formatValue(column, null, dateValue) : null;
                    break;
                }
                case 'dateString': {
                    let dateStringStringValue;
                    if (this.dataTypeSvc) {
                        // need to convert from ISO date string to Date to data string format to formatted string format
                        const dateStringDateValue = (0, ag_grid_community_1._parseDateTimeFromString)(filter);
                        dateStringStringValue = column
                            ? this.dataTypeSvc?.getDateFormatterFunction(column)(dateStringDateValue ?? undefined)
                            : null;
                    }
                    else {
                        dateStringStringValue = filter;
                    }
                    operand1 = column ? this.valueSvc.formatValue(column, null, dateStringStringValue) : null;
                    break;
                }
            }
            if (model.filterType !== 'number') {
                operand1 = operand1 ?? (0, ag_grid_community_1._toStringOrNull)(filter) ?? '';
                if (!skipFormatting) {
                    operand1 = `"${operand1}"`;
                }
            }
            operand = skipFormatting ? operand1 : ` ${operand1}`;
        }
        return operand;
    }
    parseColumnFilterModel(model) {
        const columnName = this.getColumnDisplayValue(model) ?? '';
        const operator = this.getOperatorDisplayValue(model) ?? '';
        const operands = this.getOperandDisplayValue(model);
        return `[${columnName}] ${operator}${operands}`;
    }
    updateAutocompleteCache(updateEntry, type) {
        if (type === 'column') {
            const { key: colId, displayValue } = updateEntry;
            this.columnNameToIdMap[updateEntry.displayValue.toLocaleUpperCase()] = {
                colId,
                columnName: displayValue,
            };
        }
    }
    translate(key, variableValues) {
        let defaultValue = advancedFilterLocaleText_1.ADVANCED_FILTER_LOCALE_TEXT[key];
        if (typeof defaultValue === 'function') {
            defaultValue = defaultValue(variableValues);
        }
        return this.getLocaleTextFunc()(key, defaultValue, variableValues);
    }
    generateAutocompleteListParams(entries, type, searchString) {
        return {
            enabled: true,
            type,
            searchString,
            entries,
        };
    }
    getColumnAutocompleteEntries() {
        if (this.columnAutocompleteEntries) {
            return this.columnAutocompleteEntries;
        }
        const columns = this.colModel.getColDefCols() ?? [];
        const entries = [];
        const includeHiddenColumns = this.gos.get('includeHiddenColumnsInAdvancedFilter');
        columns.forEach((column) => {
            if (column.getColDef().filter &&
                (includeHiddenColumns || column.isVisible() || column.isRowGroupActive())) {
                entries.push({
                    key: column.getColId(),
                    displayValue: this.colNames.getDisplayNameForColumn(column, 'advancedFilter'),
                });
            }
        });
        entries.sort((a, b) => {
            const aValue = a.displayValue ?? '';
            const bValue = b.displayValue ?? '';
            if (aValue < bValue) {
                return -1;
            }
            else if (bValue > aValue) {
                return 1;
            }
            return 0;
        });
        return entries;
    }
    getOperatorAutocompleteEntries(column, baseCellDataType) {
        const activeOperators = this.getActiveOperators(column);
        return this.getDataTypeExpressionOperator(baseCellDataType).getEntries(activeOperators);
    }
    getJoinOperatorAutocompleteEntries() {
        // eslint-disable-next-line no-restricted-properties
        return Object.entries(this.expressionJoinOperators).map(([key, displayValue]) => ({ key, displayValue }));
    }
    getDefaultAutocompleteListParams(searchString) {
        return this.generateAutocompleteListParams(this.getColumnAutocompleteEntries(), 'column', searchString);
    }
    getDataTypeExpressionOperator(baseCellDataType) {
        return this.expressionOperators[baseCellDataType];
    }
    getExpressionOperator(baseCellDataType, operator) {
        return this.getDataTypeExpressionOperator(baseCellDataType)?.operators?.[operator];
    }
    getExpressionJoinOperators() {
        return this.expressionJoinOperators;
    }
    getColId(columnName) {
        const upperCaseColumnName = columnName.toLocaleUpperCase();
        const cachedColId = this.columnNameToIdMap[upperCaseColumnName];
        if (cachedColId) {
            return cachedColId;
        }
        const columnAutocompleteEntries = this.getColumnAutocompleteEntries();
        const colEntry = columnAutocompleteEntries.find(({ displayValue }) => displayValue.toLocaleUpperCase() === upperCaseColumnName);
        if (colEntry) {
            const { key: colId, displayValue } = colEntry;
            const colValue = { colId, columnName: displayValue };
            // cache for faster lookup
            this.columnNameToIdMap[upperCaseColumnName] = colValue;
            return colValue;
        }
        return null;
    }
    getExpressionEvaluatorParams(colId) {
        let params = this.expressionEvaluatorParams[colId];
        if (params) {
            return params;
        }
        const column = this.colModel.getColDefCol(colId);
        if (!column) {
            return { valueConverter: (v) => v };
        }
        const baseCellDataType = this.dataTypeSvc?.getBaseDataType(column);
        switch (baseCellDataType) {
            case 'dateString':
                params = {
                    valueConverter: this.dataTypeSvc?.getDateParserFunction(column) ?? ((v) => v),
                };
                break;
            case 'object':
                // If there's a filter value getter, assume the value is already a string. Otherwise we need to format it.
                if (column.getColDef().filterValueGetter) {
                    params = { valueConverter: (v) => v };
                }
                else {
                    params = {
                        valueConverter: (value, node) => this.valueSvc.formatValue(column, node, value) ??
                            (typeof value.toString === 'function' ? value.toString() : ''),
                    };
                }
                break;
            case 'text':
            case undefined:
                params = { valueConverter: (v) => (0, ag_grid_community_1._toStringOrNull)(v) };
                break;
            default:
                params = { valueConverter: (v) => v };
                break;
        }
        const { filterParams } = column.getColDef();
        if (filterParams) {
            ['caseSensitive', 'includeBlanksInEquals', 'includeBlanksInLessThan', 'includeBlanksInGreaterThan'].forEach((param) => {
                const paramValue = filterParams[param];
                if (paramValue) {
                    params[param] = paramValue;
                }
            });
        }
        this.expressionEvaluatorParams[colId] = params;
        return params;
    }
    getColumnDetails(colId) {
        const column = this.colModel.getColDefCol(colId) ?? undefined;
        const baseCellDataType = (column ? this.dataTypeSvc?.getBaseDataType(column) : undefined) ?? 'text';
        return { column, baseCellDataType };
    }
    generateExpressionOperators() {
        const translate = (key, variableValues) => this.translate(key, variableValues);
        return {
            text: new filterExpressionOperators_1.TextFilterExpressionOperators({ translate }),
            boolean: new filterExpressionOperators_1.BooleanFilterExpressionOperators({ translate }),
            object: new filterExpressionOperators_1.TextFilterExpressionOperators({ translate }),
            number: new filterExpressionOperators_1.ScalarFilterExpressionOperators({ translate, equals: (v, o) => v === o }),
            date: new filterExpressionOperators_1.ScalarFilterExpressionOperators({
                translate,
                equals: (v, o) => v.getTime() === o.getTime(),
            }),
            dateString: new filterExpressionOperators_1.ScalarFilterExpressionOperators({
                translate,
                equals: (v, o) => v.getTime() === o.getTime(),
            }),
        };
    }
    getColumnValue({ displayValue }) {
        return `${colFilterExpressionParser_1.COL_FILTER_EXPRESSION_START_CHAR}${displayValue}${colFilterExpressionParser_1.COL_FILTER_EXPRESSION_END_CHAR}`;
    }
    generateExpressionJoinOperators() {
        return {
            AND: this.translate('advancedFilterAnd'),
            OR: this.translate('advancedFilterOr'),
        };
    }
    getActiveOperators(column) {
        const filterOptions = column.getColDef().filterParams?.filterOptions;
        if (!filterOptions) {
            return undefined;
        }
        const isValid = filterOptions.every((filterOption) => typeof filterOption === 'string');
        return isValid ? filterOptions : undefined;
    }
    resetColumnCaches() {
        this.columnAutocompleteEntries = null;
        this.columnNameToIdMap = {};
        this.expressionEvaluatorParams = {};
    }
}
exports.AdvancedFilterExpressionService = AdvancedFilterExpressionService;


/***/ }),

/***/ 4858:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterHeaderComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const advancedFilterComp_1 = __webpack_require__(2583);
class AdvancedFilterHeaderComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.focusSvc = beans.focusSvc;
        this.ctrlsSvc = beans.ctrlsSvc;
    }
    constructor(enabled) {
        super(/* html */ `
            <div class="ag-advanced-filter-header" role="row">
            </div>`);
        this.enabled = enabled;
    }
    postConstruct() {
        this.setupAdvancedFilter(this.enabled);
        this.addDestroyFunc(() => this.destroyBean(this.eAdvancedFilter));
        const heightListener = () => {
            if (this.enabled) {
                this.setEnabledHeight();
            }
        };
        this.addManagedEventListeners({
            gridColumnsChanged: () => this.onGridColumnsChanged(),
            columnHeaderHeightChanged: heightListener,
            gridStylesChanged: heightListener,
        });
        this.addManagedPropertyListener('headerHeight', heightListener);
        this.addManagedPropertyListener('floatingFiltersHeight', heightListener);
        this.addGuiEventListener('keydown', (event) => this.onKeyDown(event));
        this.addGuiEventListener('focusout', (event) => {
            if (!this.getFocusableElement().contains(event.relatedTarget)) {
                this.focusSvc.clearAdvancedFilterColumn();
            }
        });
    }
    getFocusableElement() {
        return this.eAdvancedFilter?.getGui() ?? this.getGui();
    }
    setEnabled(enabled) {
        if (enabled === this.enabled) {
            return;
        }
        this.setupAdvancedFilter(enabled);
    }
    refresh() {
        this.eAdvancedFilter?.refresh();
    }
    getHeight() {
        return this.height;
    }
    setInputDisabled(disabled) {
        this.eAdvancedFilter?.setInputDisabled(disabled);
    }
    setupAdvancedFilter(enabled) {
        const eGui = this.getGui();
        if (enabled) {
            // unmanaged as can be recreated
            this.eAdvancedFilter = this.createBean(new advancedFilterComp_1.AdvancedFilterComp());
            const eAdvancedFilterGui = this.eAdvancedFilter.getGui();
            this.eAdvancedFilter.addCssClass('ag-advanced-filter-header-cell');
            this.setEnabledHeight();
            this.setAriaRowIndex();
            (0, ag_grid_community_1._setAriaRole)(eAdvancedFilterGui, 'gridcell');
            (0, ag_grid_community_1._setAriaColIndex)(eAdvancedFilterGui, 1);
            this.setAriaColumnCount(eAdvancedFilterGui);
            eGui.appendChild(eAdvancedFilterGui);
        }
        else {
            (0, ag_grid_community_1._clearElement)(eGui);
            this.destroyBean(this.eAdvancedFilter);
            this.height = 0;
        }
        (0, ag_grid_community_1._setDisplayed)(eGui, enabled);
        this.enabled = enabled;
    }
    setEnabledHeight() {
        const eGui = this.getGui();
        this.height = (0, ag_grid_community_1._getFloatingFiltersHeight)(this.beans);
        const height = `${this.height}px`;
        eGui.style.height = height;
        eGui.style.minHeight = height;
    }
    setAriaColumnCount(eAdvancedFilterGui) {
        (0, ag_grid_community_1._setAriaColSpan)(eAdvancedFilterGui, this.colModel.getCols().length);
    }
    setAriaRowIndex() {
        (0, ag_grid_community_1._setAriaRowIndex)(this.getGui(), this.ctrlsSvc.getHeaderRowContainerCtrl()?.getRowCount() ?? 0);
    }
    onGridColumnsChanged() {
        if (!this.eAdvancedFilter) {
            return;
        }
        this.setAriaColumnCount(this.eAdvancedFilter.getGui());
        this.setAriaRowIndex();
    }
    onKeyDown(event) {
        switch (event.key) {
            case ag_grid_community_1.KeyCode.ENTER: {
                if (this.hasFocus()) {
                    if ((0, ag_grid_community_1._focusInto)(this.getFocusableElement())) {
                        event.preventDefault();
                    }
                }
                break;
            }
            case ag_grid_community_1.KeyCode.ESCAPE:
                if (!this.hasFocus()) {
                    this.getFocusableElement().focus();
                }
                break;
            case ag_grid_community_1.KeyCode.UP:
                this.navigateUpDown(true, event);
                break;
            case ag_grid_community_1.KeyCode.DOWN:
                this.navigateUpDown(false, event);
                break;
            case ag_grid_community_1.KeyCode.TAB:
                if (this.hasFocus()) {
                    this.navigateLeftRight(event);
                }
                else {
                    const nextFocusableEl = (0, ag_grid_community_1._findNextFocusableElement)(this.beans, this.getFocusableElement(), null, event.shiftKey);
                    if (nextFocusableEl) {
                        event.preventDefault();
                        nextFocusableEl.focus();
                    }
                    else {
                        this.navigateLeftRight(event);
                    }
                }
                break;
        }
    }
    navigateUpDown(backwards, event) {
        if (this.hasFocus()) {
            if (this.focusSvc.focusNextFromAdvancedFilter(backwards)) {
                event.preventDefault();
            }
        }
    }
    navigateLeftRight(event) {
        if (event.shiftKey ? this.focusSvc.focusLastHeader() : this.focusSvc.focusNextFromAdvancedFilter(false, true)) {
            event.preventDefault();
        }
    }
    hasFocus() {
        return (0, ag_grid_community_1._getActiveDomElement)(this.beans) === this.getFocusableElement();
    }
}
exports.AdvancedFilterHeaderComp = AdvancedFilterHeaderComp;


/***/ }),

/***/ 8397:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ADVANCED_FILTER_LOCALE_TEXT = void 0;
exports.ADVANCED_FILTER_LOCALE_TEXT = {
    ariaAdvancedFilterBuilderItem: (variableValues) => `${variableValues[0]}. Level ${variableValues[1]}. Press ENTER to edit`,
    ariaAdvancedFilterBuilderItemValidation: (variableValues) => `${variableValues[0]}. Level ${variableValues[1]}. ${variableValues[2]} Press ENTER to edit`,
    ariaAdvancedFilterBuilderList: 'Advanced Filter Builder List',
    ariaAdvancedFilterBuilderFilterItem: 'Filter Condition',
    ariaAdvancedFilterBuilderGroupItem: 'Filter Group',
    ariaAdvancedFilterBuilderColumn: 'Column',
    ariaAdvancedFilterBuilderOption: 'Option',
    ariaAdvancedFilterBuilderValue: 'Value',
    ariaAdvancedFilterBuilderJoinOperator: 'Join Operator',
    ariaAdvancedFilterInput: 'Advanced Filter Input',
    ariaLabelAdvancedFilterAutocomplete: 'Advanced Filter Autocomplete',
    advancedFilterContains: 'contains',
    advancedFilterNotContains: 'does not contain',
    advancedFilterTextEquals: 'equals',
    advancedFilterTextNotEqual: 'does not equal',
    advancedFilterStartsWith: 'begins with',
    advancedFilterEndsWith: 'ends with',
    advancedFilterBlank: 'is blank',
    advancedFilterNotBlank: 'is not blank',
    advancedFilterEquals: '=',
    advancedFilterNotEqual: '!=',
    advancedFilterGreaterThan: '>',
    advancedFilterGreaterThanOrEqual: '>=',
    advancedFilterLessThan: '<',
    advancedFilterLessThanOrEqual: '<=',
    advancedFilterTrue: 'is true',
    advancedFilterFalse: 'is false',
    advancedFilterAnd: 'AND',
    advancedFilterOr: 'OR',
    advancedFilterApply: 'Apply',
    advancedFilterBuilder: 'Builder',
    advancedFilterValidationMissingColumn: 'Column is missing',
    advancedFilterValidationMissingOption: 'Option is missing',
    advancedFilterValidationMissingValue: 'Value is missing',
    advancedFilterValidationInvalidColumn: 'Column not found',
    advancedFilterValidationInvalidOption: 'Option not found',
    advancedFilterValidationMissingQuote: 'Value is missing an end quote',
    advancedFilterValidationNotANumber: 'Value is not a number',
    advancedFilterValidationInvalidDate: 'Value is not a valid date',
    advancedFilterValidationMissingCondition: 'Condition is missing',
    advancedFilterValidationJoinOperatorMismatch: 'Join operators within a condition must be the same',
    advancedFilterValidationInvalidJoinOperator: 'Join operator not found',
    advancedFilterValidationMissingEndBracket: 'Missing end bracket',
    advancedFilterValidationExtraEndBracket: 'Too many end brackets',
    advancedFilterValidationMessage: (variableValues) => `Expression has an error. ${variableValues[0]} - ${variableValues[1]}.`,
    advancedFilterValidationMessageAtEnd: (variableValues) => `Expression has an error. ${variableValues[0]} at end of expression.`,
    advancedFilterBuilderTitle: 'Advanced Filter',
    advancedFilterBuilderApply: 'Apply',
    advancedFilterBuilderCancel: 'Cancel',
    advancedFilterBuilderAddButtonTooltip: 'Add Filter or Group',
    advancedFilterBuilderRemoveButtonTooltip: 'Remove',
    advancedFilterBuilderMoveUpButtonTooltip: 'Move Up',
    advancedFilterBuilderMoveDownButtonTooltip: 'Move Down',
    advancedFilterBuilderAddJoin: 'Add Group',
    advancedFilterBuilderAddCondition: 'Add Filter',
    advancedFilterBuilderSelectColumn: 'Select a column',
    advancedFilterBuilderSelectOption: 'Select an option',
    advancedFilterBuilderEnterValue: 'Enter a value...',
    advancedFilterBuilderValidationAlreadyApplied: 'Current filter already applied.',
    advancedFilterBuilderValidationIncomplete: 'Not all conditions are complete.',
    advancedFilterBuilderValidationSelectColumn: 'Must select a column.',
    advancedFilterBuilderValidationSelectOption: 'Must select an option.',
    advancedFilterBuilderValidationEnterValue: 'Must enter a value.',
};


/***/ }),

/***/ 7976:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterModule = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGridEnterpriseModule_1 = __webpack_require__(9206);
const version_1 = __webpack_require__(7205);
const advanced_filter_css_GENERATED_1 = __webpack_require__(5372);
const advancedFilterApi_1 = __webpack_require__(6138);
const advancedFilterExpressionService_1 = __webpack_require__(1723);
const advancedFilterService_1 = __webpack_require__(3065);
/**
 * @feature Filtering -> Advanced Filter
 * @gridOption enableAdvanced Filter
 */
exports.AdvancedFilterModule = {
    moduleName: 'AdvancedFilter',
    version: version_1.VERSION,
    beans: [advancedFilterService_1.AdvancedFilterService, advancedFilterExpressionService_1.AdvancedFilterExpressionService],
    icons: {
        // Builder button in Advanced Filter
        advancedFilterBuilder: 'group',
        // drag handle used to pick up Advanced Filter Builder rows
        advancedFilterBuilderDrag: 'grip',
        // Advanced Filter Builder row validation error
        advancedFilterBuilderInvalid: 'not-allowed',
        // shown on Advanced Filter Builder rows to move them up
        advancedFilterBuilderMoveUp: 'up',
        // shown on Advanced Filter Builder rows to move them down
        advancedFilterBuilderMoveDown: 'down',
        // shown on Advanced Filter Builder rows to add new rows
        advancedFilterBuilderAdd: 'plus',
        // shown on Advanced Filter Builder rows to remove row
        advancedFilterBuilderRemove: 'minus',
        // shown on Advanced Filter Builder selection pills
        advancedFilterBuilderSelectOpen: 'small-down',
        // remove for rich select editor pills
        richSelectRemove: 'cancel',
    },
    apiFunctions: {
        getAdvancedFilterModel: advancedFilterApi_1.getAdvancedFilterModel,
        setAdvancedFilterModel: advancedFilterApi_1.setAdvancedFilterModel,
        showAdvancedFilterBuilder: advancedFilterApi_1.showAdvancedFilterBuilder,
        hideAdvancedFilterBuilder: advancedFilterApi_1.hideAdvancedFilterBuilder,
    },
    dependsOn: [agGridEnterpriseModule_1.EnterpriseCoreModule, ag_grid_community_1._FilterCoreModule, ag_grid_community_1._SharedDragAndDropModule, ag_grid_community_1._PopupModule, ag_grid_community_1._FilterValueModule],
    css: [advanced_filter_css_GENERATED_1.advancedFilterCSS],
};


/***/ }),

/***/ 3065:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const advancedFilterCtrl_1 = __webpack_require__(5865);
const filterExpressionParser_1 = __webpack_require__(4899);
class AdvancedFilterService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'advancedFilter';
        this.appliedExpression = null;
        /** The value displayed in the input, which may be invalid */
        this.expression = null;
        this.isValid = true;
    }
    wireBeans(beans) {
        this.valueSvc = beans.valueSvc;
        this.colModel = beans.colModel;
        this.dataTypeSvc = beans.dataTypeSvc;
        this.advFilterExpSvc = beans.advFilterExpSvc;
        this.filterValueSvc = beans.filterValueSvc;
    }
    postConstruct() {
        this.setEnabled(this.gos.get('enableAdvancedFilter'), true);
        this.ctrl = this.createManagedBean(new advancedFilterCtrl_1.AdvancedFilterCtrl(this.enabled));
        this.expressionProxy = {
            getValue: (colId, node) => {
                const column = this.colModel.getColDefCol(colId);
                return column ? this.filterValueSvc.getValue(column, node) : undefined;
            },
        };
        this.addManagedPropertyListener('enableAdvancedFilter', (event) => this.setEnabled(!!event.currentValue));
        this.addManagedEventListeners({
            newColumnsLoaded: (event) => this.onNewColumnsLoaded(event),
        });
        this.addManagedPropertyListener('includeHiddenColumnsInAdvancedFilter', () => this.updateValidity());
    }
    isEnabled() {
        return this.enabled;
    }
    isFilterPresent() {
        return !!this.expressionFunction;
    }
    doesFilterPass(node) {
        return this.expressionFunction(this.expressionProxy, node, this.expressionParams);
    }
    getModel() {
        const expressionParser = this.createExpressionParser(this.appliedExpression);
        expressionParser?.parseExpression();
        return expressionParser?.getModel() ?? null;
    }
    setModel(model) {
        const parseModel = (model, isFirstParent) => {
            if (model.filterType === 'join') {
                const operator = this.advFilterExpSvc.parseJoinOperator(model);
                const expression = model.conditions
                    .map((condition) => parseModel(condition))
                    .filter((condition) => (0, ag_grid_community_1._exists)(condition))
                    .join(` ${operator} `);
                return isFirstParent || model.conditions.length <= 1 ? expression : `(${expression})`;
            }
            else {
                return this.advFilterExpSvc.parseColumnFilterModel(model);
            }
        };
        const expression = model ? parseModel(model, true) : null;
        this.setExpressionDisplayValue(expression);
        this.applyExpression();
        this.ctrl.refreshComp();
        this.ctrl.refreshBuilderComp();
    }
    getExpressionDisplayValue() {
        return this.expression;
    }
    setExpressionDisplayValue(expression) {
        this.expression = expression;
    }
    isCurrentExpressionApplied() {
        return this.appliedExpression === this.expression;
    }
    createExpressionParser(expression) {
        if (!expression) {
            return null;
        }
        return new filterExpressionParser_1.FilterExpressionParser({
            expression,
            colModel: this.colModel,
            dataTypeSvc: this.dataTypeSvc,
            valueSvc: this.valueSvc,
            advFilterExpSvc: this.advFilterExpSvc,
        });
    }
    getDefaultExpression(updateEntry) {
        const updatedValue = this.advFilterExpSvc.getColumnValue(updateEntry) + ' ';
        return {
            updatedValue,
            updatedPosition: updatedValue.length,
        };
    }
    isHeaderActive() {
        return !this.gos.get('advancedFilterParent');
    }
    getCtrl() {
        return this.ctrl;
    }
    setEnabled(enabled, silent) {
        const previousValue = this.enabled;
        const isValidRowModel = (0, ag_grid_community_1._isClientSideRowModel)(this.gos) || (0, ag_grid_community_1._isServerSideRowModel)(this.gos);
        if (enabled && !isValidRowModel) {
            (0, ag_grid_community_1._warn)(123);
        }
        this.enabled = enabled && isValidRowModel;
        if (!silent && this.enabled !== previousValue) {
            this.eventSvc.dispatchEvent({
                type: 'advancedFilterEnabledChanged',
                enabled: this.enabled,
            });
        }
    }
    applyExpression() {
        const expressionParser = this.createExpressionParser(this.expression);
        expressionParser?.parseExpression();
        this.applyExpressionFromParser(expressionParser);
    }
    applyExpressionFromParser(expressionParser) {
        this.isValid = !expressionParser || expressionParser.isValid();
        if (!expressionParser || !this.isValid) {
            this.expressionFunction = null;
            this.expressionParams = null;
            this.appliedExpression = null;
            return;
        }
        const { expressionFunction, params } = this.getFunction(expressionParser);
        this.expressionFunction = expressionFunction;
        this.expressionParams = params;
        this.appliedExpression = this.expression;
    }
    getFunction(expressionParser) {
        if (this.gos.get('suppressAdvancedFilterEval')) {
            return expressionParser.getFunctionParsed();
        }
        else {
            const { functionString, params } = expressionParser.getFunctionString();
            return {
                expressionFunction: new Function('expressionProxy', 'node', 'params', functionString),
                params,
            };
        }
    }
    updateValidity() {
        this.advFilterExpSvc.resetColumnCaches();
        const expressionParser = this.createExpressionParser(this.expression);
        expressionParser?.parseExpression();
        const isValid = !expressionParser || expressionParser.isValid();
        const updatedValidity = isValid !== this.isValid;
        this.applyExpressionFromParser(expressionParser);
        this.ctrl.refreshComp();
        this.ctrl.refreshBuilderComp();
        return updatedValidity;
    }
    onNewColumnsLoaded(event) {
        if (event.source !== 'gridInitializing' || !this.dataTypeSvc?.isPendingInference) {
            return;
        }
        this.ctrl.setInputDisabled(true);
        const [destroyFunc] = this.addManagedEventListeners({
            dataTypesInferred: () => {
                destroyFunc?.();
                this.ctrl.setInputDisabled(false);
            },
        });
    }
}
exports.AdvancedFilterService = AdvancedFilterService;


/***/ }),

/***/ 9546:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agAutocompleteCSS = void 0;
exports.agAutocompleteCSS = `.ag-autocomplete{align-items:center;display:flex;width:100%;>*{flex:1 1 auto}}.ag-autocomplete-list-popup{background-color:var(--ag-background-color);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);padding:0;position:absolute;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-autocomplete-list{height:calc(var(--ag-row-height)*6.5);min-width:200px;position:relative;width:100%}.ag-autocomplete-virtual-list-item{cursor:default;display:flex;height:var(--ag-list-item-height);&:focus-visible:after{content:none}&:hover{background-color:var(--ag-row-hover-color)}}.ag-autocomplete-row{align-items:center;display:flex;flex:1 1 auto;overflow:hidden}.ag-autocomplete-row-label{margin:0 var(--ag-widget-container-horizontal-padding);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-autocomplete-row-selected{background-color:var(--ag-selected-row-background-color)}`;


/***/ }),

/***/ 2611:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAutocompleteSelector = exports.AgAutocomplete = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agAutocomplete_css_GENERATED_1 = __webpack_require__(9546);
const agAutocompleteList_1 = __webpack_require__(3359);
class AgAutocomplete extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.popupSvc = beans.popupSvc;
    }
    constructor() {
        super(
        /* html */ `
            <div class="ag-autocomplete" role="presentation">
                <ag-input-text-field data-ref="eAutocompleteInput"></ag-input-text-field>
            </div>`, [ag_grid_community_1.AgInputTextFieldSelector]);
        this.eAutocompleteInput = ag_grid_community_1.RefPlaceholder;
        this.isListOpen = false;
        this.lastPosition = 0;
        this.valid = true;
        this.registerCSS(agAutocomplete_css_GENERATED_1.agAutocompleteCSS);
    }
    postConstruct() {
        this.eAutocompleteInput.onValueChange((value) => this.onValueChanged(value));
        this.eAutocompleteInput.getInputElement().setAttribute('autocomplete', 'off');
        this.addGuiEventListener('keydown', this.onKeyDown.bind(this));
        this.addGuiEventListener('click', this.updatePositionAndList.bind(this));
        this.addDestroyFunc(() => {
            this.destroyBean(this.autocompleteList);
        });
        this.addGuiEventListener('focusout', () => this.onFocusOut());
    }
    onValueChanged(value) {
        const parsedValue = (0, ag_grid_community_1._makeNull)(value);
        this.updateValue(parsedValue);
        this.updateAutocompleteList(parsedValue);
    }
    updateValue(value) {
        this.updateLastPosition();
        this.dispatchLocalEvent({
            type: 'eventValueChanged',
            value,
        });
        this.validate(value);
    }
    updateAutocompleteList(value) {
        const autocompleteListParams = this.listGenerator?.(value, this.lastPosition) ?? { enabled: false };
        if (!autocompleteListParams.type || autocompleteListParams.type !== this.autocompleteListParams?.type) {
            if (this.isListOpen) {
                this.closeList();
            }
        }
        const isListOpen = this.isListOpen;
        this.autocompleteListParams = autocompleteListParams;
        if (autocompleteListParams?.enabled) {
            if (!isListOpen) {
                this.openList();
            }
            const { searchString } = autocompleteListParams;
            this.autocompleteList.setSearch(searchString ?? '');
        }
        else {
            if (isListOpen) {
                this.closeList();
            }
        }
    }
    onKeyDown(event) {
        const key = event.key;
        this.updateLastPosition();
        switch (key) {
            case ag_grid_community_1.KeyCode.ENTER:
                this.onEnterKeyDown(event);
                break;
            case ag_grid_community_1.KeyCode.TAB:
                this.onTabKeyDown(event);
                break;
            case ag_grid_community_1.KeyCode.DOWN:
            case ag_grid_community_1.KeyCode.UP:
                this.onUpDownKeyDown(event, key);
                break;
            case ag_grid_community_1.KeyCode.LEFT:
            case ag_grid_community_1.KeyCode.RIGHT:
            case ag_grid_community_1.KeyCode.PAGE_HOME:
            case ag_grid_community_1.KeyCode.PAGE_END:
                // input position is updated after this is called, so do async
                setTimeout(() => {
                    this.updatePositionAndList();
                });
                break;
            case ag_grid_community_1.KeyCode.ESCAPE:
                this.onEscapeKeyDown(event);
                break;
            case ag_grid_community_1.KeyCode.SPACE:
                if (event.ctrlKey && !this.isListOpen) {
                    event.preventDefault();
                    this.forceOpenList();
                }
                break;
        }
    }
    confirmSelection() {
        const selectedValue = this.autocompleteList?.getSelectedValue();
        if (selectedValue) {
            this.closeList();
            this.dispatchLocalEvent({
                type: 'eventOptionSelected',
                value: this.getValue(),
                position: this.lastPosition,
                updateEntry: selectedValue,
                autocompleteType: this.autocompleteListParams.type,
            });
        }
    }
    onTabKeyDown(event) {
        if (this.isListOpen) {
            event.preventDefault();
            event.stopPropagation();
            this.confirmSelection();
        }
    }
    onEnterKeyDown(event) {
        event.preventDefault();
        if (this.isListOpen) {
            this.confirmSelection();
        }
        else {
            this.onCompleted();
        }
    }
    onUpDownKeyDown(event, key) {
        event.preventDefault();
        if (!this.isListOpen) {
            this.forceOpenList();
        }
        else {
            this.autocompleteList?.onNavigationKeyDown(event, key);
        }
    }
    onEscapeKeyDown(event) {
        if (this.isListOpen) {
            event.preventDefault();
            event.stopPropagation();
            this.closeList();
            this.setCaret(this.lastPosition, true);
        }
    }
    onFocusOut() {
        if (this.isListOpen) {
            this.closeList();
        }
    }
    updatePositionAndList() {
        this.updateLastPosition();
        this.updateAutocompleteList(this.eAutocompleteInput.getValue() ?? null);
    }
    setCaret(position, setFocus) {
        if (setFocus && (0, ag_grid_community_1._isNothingFocused)(this.beans)) {
            // clicking on the list loses focus, so restore
            this.eAutocompleteInput.getFocusableElement().focus();
        }
        const eInput = this.eAutocompleteInput.getInputElement();
        eInput.setSelectionRange(position, position);
        if (position === eInput.value.length) {
            // ensure the caret is visible
            eInput.scrollLeft = eInput.scrollWidth;
        }
    }
    forceOpenList() {
        this.onValueChanged(this.eAutocompleteInput.getValue());
    }
    updateLastPosition() {
        this.lastPosition = this.eAutocompleteInput.getInputElement().selectionStart ?? 0;
    }
    validate(value) {
        if (!this.validator) {
            return;
        }
        const validationMessage = (this.validationMessage = this.validator(value));
        this.eAutocompleteInput.getInputElement().setCustomValidity(validationMessage ?? '');
        this.valid = !validationMessage;
        this.dispatchLocalEvent({
            type: 'eventValidChanged',
            isValid: this.valid,
            validationMessage,
        });
    }
    openList() {
        this.isListOpen = true;
        // this is unmanaged as it gets destroyed/created each time it is opened
        this.autocompleteList = this.createBean(new agAutocompleteList_1.AgAutocompleteList({
            autocompleteEntries: this.autocompleteListParams.entries,
            onConfirmed: () => this.confirmSelection(),
            forceLastSelection: this.forceLastSelection,
        }));
        const ePopupGui = this.autocompleteList.getGui();
        const positionParams = {
            ePopup: ePopupGui,
            type: 'autocomplete',
            eventSource: this.getGui(),
            position: 'under',
            alignSide: this.gos.get('enableRtl') ? 'right' : 'left',
            keepWithinBounds: true,
        };
        const addPopupRes = this.popupSvc.addPopup({
            eChild: ePopupGui,
            anchorToElement: this.getGui(),
            positionCallback: () => this.popupSvc.positionPopupByComponent(positionParams),
            ariaLabel: this.listAriaLabel,
        });
        this.hidePopup = addPopupRes.hideFunc;
        this.autocompleteList.afterGuiAttached();
    }
    closeList() {
        this.isListOpen = false;
        this.hidePopup();
        this.destroyBean(this.autocompleteList);
        this.autocompleteList = null;
    }
    onCompleted() {
        if (this.isListOpen) {
            this.closeList();
        }
        this.dispatchLocalEvent({
            type: 'eventValueConfirmed',
            value: this.getValue(),
            isValid: this.isValid(),
        });
    }
    getValue() {
        return (0, ag_grid_community_1._makeNull)(this.eAutocompleteInput.getValue());
    }
    setInputPlaceholder(placeholder) {
        this.eAutocompleteInput.setInputPlaceholder(placeholder);
        return this;
    }
    setInputAriaLabel(label) {
        this.eAutocompleteInput.setInputAriaLabel(label);
        return this;
    }
    setListAriaLabel(label) {
        this.listAriaLabel = label;
        return this;
    }
    setListGenerator(listGenerator) {
        this.listGenerator = listGenerator;
        return this;
    }
    setValidator(validator) {
        this.validator = validator;
        return this;
    }
    isValid() {
        return this.valid;
    }
    setValue(params) {
        const { value, position, silent, updateListOnlyIfOpen, restoreFocus } = params;
        this.eAutocompleteInput.setValue(value, true);
        this.setCaret(position ?? this.lastPosition, restoreFocus);
        if (!silent) {
            this.updateValue(value);
        }
        if (!updateListOnlyIfOpen || this.isListOpen) {
            this.updateAutocompleteList(value);
        }
    }
    setForceLastSelection(forceLastSelection) {
        this.forceLastSelection = forceLastSelection;
        return this;
    }
    setInputDisabled(disabled) {
        this.eAutocompleteInput.setDisabled(disabled);
        return this;
    }
}
exports.AgAutocomplete = AgAutocomplete;
exports.AgAutocompleteSelector = {
    selector: 'AG-AUTOCOMPLETE',
    component: AgAutocomplete,
};


/***/ }),

/***/ 3359:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAutocompleteList = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const virtualList_1 = __webpack_require__(7904);
const agAutocompleteRow_1 = __webpack_require__(9087);
class AgAutocompleteList extends ag_grid_community_1.PopupComponent {
    constructor(params) {
        super(/* html */ `<div class="ag-autocomplete-list-popup">
            <div data-ref="eList" class="ag-autocomplete-list"></div>
        <div>`);
        this.params = params;
        this.eList = ag_grid_community_1.RefPlaceholder;
        this.searchString = '';
    }
    postConstruct() {
        this.autocompleteEntries = this.params.autocompleteEntries;
        this.virtualList = this.createManagedBean(new virtualList_1.VirtualList({ cssIdentifier: 'autocomplete' }));
        this.virtualList.setComponentCreator(this.createRowComponent.bind(this));
        this.eList.appendChild(this.virtualList.getGui());
        this.virtualList.setModel({
            getRowCount: () => this.autocompleteEntries.length,
            getRow: (index) => this.autocompleteEntries[index],
        });
        const virtualListGui = this.virtualList.getGui();
        this.addManagedListeners(virtualListGui, {
            click: () => this.params.onConfirmed(),
            mousemove: this.onMouseMove.bind(this),
            mousedown: (e) => e.preventDefault(),
        });
        this.setSelectedValue(0);
    }
    onNavigationKeyDown(event, key) {
        // if we don't preventDefault the page body and/or grid scroll will move.
        event.preventDefault();
        const oldIndex = this.autocompleteEntries.indexOf(this.selectedValue);
        const newIndex = key === ag_grid_community_1.KeyCode.UP ? oldIndex - 1 : oldIndex + 1;
        this.checkSetSelectedValue(newIndex);
    }
    setSearch(searchString) {
        this.searchString = searchString;
        if ((0, ag_grid_community_1._exists)(searchString)) {
            this.runSearch();
        }
        else {
            // reset
            this.autocompleteEntries = this.params.autocompleteEntries;
            this.virtualList.refresh();
            this.checkSetSelectedValue(0);
        }
        this.updateSearchInList();
    }
    runContainsSearch(searchString, searchStrings) {
        let topMatch;
        let topMatchStartsWithSearchString = false;
        const lowerCaseSearchString = searchString.toLocaleLowerCase();
        const allMatches = searchStrings.filter((string) => {
            const lowerCaseString = string.toLocaleLowerCase();
            const index = lowerCaseString.indexOf(lowerCaseSearchString);
            const startsWithSearchString = index === 0;
            const isMatch = index >= 0;
            // top match is shortest value that starts with the search string, otherwise shortest value that includes the search string
            if (isMatch &&
                (!topMatch ||
                    (!topMatchStartsWithSearchString && startsWithSearchString) ||
                    (topMatchStartsWithSearchString === startsWithSearchString && string.length < topMatch.length))) {
                topMatch = string;
                topMatchStartsWithSearchString = startsWithSearchString;
            }
            return isMatch;
        });
        if (!topMatch && allMatches.length) {
            topMatch = allMatches[0];
        }
        return { topMatch, allMatches };
    }
    runSearch() {
        const { autocompleteEntries, useFuzzySearch, forceLastSelection } = this.params;
        const searchStrings = autocompleteEntries.map((v) => v.displayValue ?? v.key);
        let matchingStrings;
        let topSuggestion;
        if (useFuzzySearch) {
            matchingStrings = (0, ag_grid_community_1._fuzzySuggestions)({
                inputValue: this.searchString,
                allSuggestions: searchStrings,
                hideIrrelevant: true,
                addSequentialWeight: true,
            }).values;
            topSuggestion = matchingStrings.length ? matchingStrings[0] : undefined;
        }
        else {
            const containsMatches = this.runContainsSearch(this.searchString, searchStrings);
            matchingStrings = containsMatches.allMatches;
            topSuggestion = containsMatches.topMatch;
        }
        let filteredEntries = autocompleteEntries.filter(({ key, displayValue }) => matchingStrings.includes(displayValue ?? key));
        if (!filteredEntries.length &&
            this.selectedValue &&
            forceLastSelection?.(this.selectedValue, this.searchString)) {
            filteredEntries = [this.selectedValue];
        }
        this.autocompleteEntries = filteredEntries;
        this.virtualList.refresh();
        if (!topSuggestion) {
            return;
        }
        const topSuggestionIndex = matchingStrings.indexOf(topSuggestion);
        this.checkSetSelectedValue(topSuggestionIndex);
    }
    updateSearchInList() {
        this.virtualList.forEachRenderedRow((row) => row.setSearchString(this.searchString));
    }
    checkSetSelectedValue(index) {
        if (index >= 0 && index < this.autocompleteEntries.length) {
            this.setSelectedValue(index);
        }
    }
    setSelectedValue(index) {
        const value = this.autocompleteEntries[index];
        if (this.selectedValue === value) {
            return;
        }
        this.selectedValue = value;
        this.virtualList.ensureIndexVisible(index);
        this.virtualList.forEachRenderedRow((cmp, idx) => {
            cmp.updateSelected(index === idx);
        });
    }
    createRowComponent(value) {
        const row = new agAutocompleteRow_1.AgAutocompleteRow();
        this.createBean(row);
        row.setState(value.displayValue ?? value.key, value === this.selectedValue);
        return row;
    }
    onMouseMove(mouseEvent) {
        const virtualList = this.virtualList;
        const rect = virtualList.getGui().getBoundingClientRect();
        const scrollTop = virtualList.getScrollTop();
        const mouseY = mouseEvent.clientY - rect.top + scrollTop;
        const row = Math.floor(mouseY / virtualList.getRowHeight());
        this.checkSetSelectedValue(row);
    }
    afterGuiAttached() {
        this.virtualList.refresh();
    }
    getSelectedValue() {
        if (!this.autocompleteEntries.length) {
            return null;
        }
        return this.selectedValue ?? null;
    }
}
exports.AgAutocompleteList = AgAutocompleteList;


/***/ }),

/***/ 9087:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAutocompleteRow = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AgAutocompleteRow extends ag_grid_community_1.Component {
    constructor() {
        super(/* html */ `
        <div class="ag-autocomplete-row" role="presentation">
            <div class="ag-autocomplete-row-label"></div>
        </div>`);
        this.hasHighlighting = false;
    }
    setState(value, selected) {
        this.value = value;
        this.render();
        this.updateSelected(selected);
    }
    updateSelected(selected) {
        this.addOrRemoveCssClass('ag-autocomplete-row-selected', selected);
    }
    setSearchString(searchString) {
        let keepHighlighting = false;
        if ((0, ag_grid_community_1._exists)(searchString)) {
            const index = this.value?.toLocaleLowerCase().indexOf(searchString.toLocaleLowerCase());
            if (index >= 0) {
                keepHighlighting = true;
                this.hasHighlighting = true;
                const highlightEndIndex = index + searchString.length;
                const startPart = (0, ag_grid_community_1._escapeString)(this.value.slice(0, index));
                const highlightedPart = (0, ag_grid_community_1._escapeString)(this.value.slice(index, highlightEndIndex));
                const endPart = (0, ag_grid_community_1._escapeString)(this.value.slice(highlightEndIndex));
                this.getGui().lastElementChild.innerHTML = `${startPart}<b>${highlightedPart}</b>${endPart}`;
            }
        }
        if (!keepHighlighting && this.hasHighlighting) {
            this.hasHighlighting = false;
            this.render();
        }
    }
    render() {
        // putting in blank if missing, so at least the user can click on it
        this.getGui().lastElementChild.innerHTML = (0, ag_grid_community_1._escapeString)(this.value) ?? '&nbsp;';
    }
}
exports.AgAutocompleteRow = AgAutocompleteRow;


/***/ }),

/***/ 5219:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddDropdownComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agRichSelect_1 = __webpack_require__(2005);
class AddDropdownComp extends agRichSelect_1.AgRichSelect {
    constructor(params) {
        super({
            ...params,
            template: /* html */ `
                <div class="ag-picker-field" role="presentation">
                    <div data-ref="eLabel"></div>
                    <div data-ref="eWrapper" class="ag-wrapper ag-picker-collapsed">
                        <div data-ref="eDisplayField" class="ag-picker-field-display"></div>
                        <ag-input-text-field data-ref="eInput" class="ag-rich-select-field-input"></ag-input-text-field>
                        <span data-ref="eDeselect" class="ag-rich-select-deselect-button ag-picker-field-icon" role="presentation"></span>
                        <div data-ref="eIcon" class="ag-picker-field-icon" aria-hidden="true"></div>
                    </div>
                </div>`,
            agComponents: [ag_grid_community_1.AgInputTextFieldSelector],
        });
        this.params = params;
    }
    showPicker() {
        // avoid focus handling issues with multiple rich selects
        setTimeout(() => super.showPicker());
    }
    hidePicker() {
        // avoid focus handling issues with multiple rich selects
        setTimeout(() => super.hidePicker());
    }
    postConstruct() {
        super.postConstruct();
        const { wrapperClassName, ariaLabel } = this.params;
        (0, ag_grid_community_1._setDisplayed)(this.eDisplayField, false);
        if (wrapperClassName) {
            this.eWrapper.classList.add(wrapperClassName);
        }
        (0, ag_grid_community_1._setAriaLabelledBy)(this.eWrapper, '');
        (0, ag_grid_community_1._setAriaLabel)(this.eWrapper, ariaLabel);
    }
    onEnterKeyDown(event) {
        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
        if (this.isPickerDisplayed) {
            super.onEnterKeyDown(event);
        }
        else {
            event.preventDefault();
            this.showPicker();
        }
    }
}
exports.AddDropdownComp = AddDropdownComp;


/***/ }),

/***/ 8986:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterBuilderComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const virtualList_1 = __webpack_require__(7904);
const advancedFilterBuilderDragFeature_1 = __webpack_require__(2865);
const advancedFilterBuilderItemAddComp_1 = __webpack_require__(2172);
const advancedFilterBuilderItemComp_1 = __webpack_require__(9889);
class AdvancedFilterBuilderComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.filterManager = beans.filterManager;
        this.advancedFilter = beans.advancedFilter;
        this.advFilterExpSvc = beans.advFilterExpSvc;
        this.registry = beans.registry;
    }
    constructor() {
        super(/* html */ `
            <div role="presentation" class="ag-advanced-filter-builder" tabindex="-1">
                <div role="presentation" class="ag-advanced-filter-builder-list" data-ref="eList"></div>
                <div role="presentation" class="ag-advanced-filter-builder-button-panel">
                    <button class="ag-button ag-standard-button ag-advanced-filter-builder-apply-button" data-ref="eApplyFilterButton"></button>
                    <button class="ag-button ag-standard-button ag-advanced-filter-builder-cancel-button" data-ref="eCancelFilterButton"></button>
                </div>
            </div>`);
        this.eList = ag_grid_community_1.RefPlaceholder;
        this.eApplyFilterButton = ag_grid_community_1.RefPlaceholder;
        this.eCancelFilterButton = ag_grid_community_1.RefPlaceholder;
        this.validationMessage = null;
    }
    postConstruct() {
        const { showMoveButtons } = this.gos.get('advancedFilterBuilderParams') ?? {};
        this.showMove = !!showMoveButtons;
        this.addManagedPropertyListener('advancedFilterBuilderParams', ({ currentValue }) => {
            this.showMove = !!currentValue?.showMoveButtons;
            this.refreshList(false);
        });
        this.filterModel = this.setupFilterModel();
        this.setupVirtualList();
        this.dragFeature = this.createManagedBean(new advancedFilterBuilderDragFeature_1.AdvancedFilterBuilderDragFeature(this, this.virtualList));
        this.setupButtons();
    }
    refresh() {
        const virtualList = this.virtualList;
        let indexToFocus = virtualList.getLastFocusedRow();
        this.setupFilterModel();
        this.validateItems();
        this.refreshList(false);
        if (indexToFocus != null) {
            // last focused row is cleared on focus out, so if defined, we need to put the focus back
            if (!virtualList.getComponentAt(indexToFocus)) {
                indexToFocus = 0;
            }
            virtualList.focusRow(indexToFocus);
        }
    }
    getNumItems() {
        return this.items.length;
    }
    moveItem(item, destination) {
        if (!destination || !item) {
            return;
        }
        this.moveItemToIndex(item, destination.rowIndex, destination.position);
    }
    afterGuiAttached() {
        this.virtualList.awaitStable(() => this.virtualList.focusRow(0));
    }
    setupVirtualList() {
        const virtualList = (this.virtualList = this.createManagedBean(new virtualList_1.VirtualList({
            cssIdentifier: 'advanced-filter-builder',
            ariaRole: 'tree',
            listName: this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderList'),
        })));
        virtualList.setComponentCreator(this.createItemComponent.bind(this));
        virtualList.setComponentUpdater(this.updateItemComponent.bind(this));
        virtualList.setRowHeight(40);
        this.eList.appendChild(virtualList.getGui());
        virtualList.setModel({
            getRowCount: () => this.items.length,
            getRow: (index) => this.items[index],
            areRowsEqual: (oldRow, newRow) => oldRow === newRow,
        });
        this.buildList();
        virtualList.refresh();
    }
    setupButtons() {
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.eApplyFilterButton.innerText = this.advFilterExpSvc.translate('advancedFilterBuilderApply');
        this.activateTabIndex([this.eApplyFilterButton]);
        this.addManagedElementListeners(this.eApplyFilterButton, {
            click: () => {
                this.advancedFilter.setModel(this.filterModel);
                this.filterManager?.onFilterChanged({ source: 'advancedFilter' });
                this.close();
            },
        });
        this.validationTooltipFeature = this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.eApplyFilterButton,
            getLocation: () => 'advancedFilter',
            getTooltipValue: () => this.validationMessage,
            getTooltipShowDelayOverride: () => 1000,
        }));
        this.validate();
        const mouseListener = (isEnter) => this.addOrRemoveCssClass('ag-advanced-filter-builder-validation', isEnter);
        this.addManagedListeners(this.eApplyFilterButton, {
            mouseenter: () => mouseListener(true),
            mouseleave: () => mouseListener(false),
        });
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.eCancelFilterButton.innerText = this.advFilterExpSvc.translate('advancedFilterBuilderCancel');
        this.activateTabIndex([this.eCancelFilterButton]);
        this.addManagedElementListeners(this.eCancelFilterButton, { click: () => this.close() });
    }
    removeItemFromParent(item) {
        const sourceParentIndex = item.parent.conditions.indexOf(item.filterModel);
        item.parent.conditions.splice(sourceParentIndex, 1);
        return sourceParentIndex;
    }
    moveItemToIndex(item, destinationRowIndex, destinationPosition) {
        const destinationItem = this.items[destinationRowIndex];
        const destinationIsParent = destinationItem.filterModel?.filterType === 'join' && destinationPosition === 'bottom';
        const destinationParent = destinationIsParent
            ? destinationItem.filterModel
            : destinationItem.parent;
        // trying to move before the root
        if (!destinationParent) {
            return;
        }
        // can't move into itself
        if (this.isChildOrSelf(destinationParent, item.filterModel) || destinationItem === item) {
            return;
        }
        this.removeItemFromParent(item);
        let destinationParentIndex;
        if (destinationIsParent) {
            destinationParentIndex = 0;
        }
        else {
            destinationParentIndex = destinationParent.conditions.indexOf(destinationItem.filterModel);
            if (destinationParentIndex === -1) {
                destinationParentIndex = destinationParent.conditions.length;
            }
            else if (destinationPosition === 'bottom') {
                destinationParentIndex += 1;
            }
        }
        destinationParent.conditions.splice(destinationParentIndex, 0, item.filterModel);
        this.refreshList(false);
    }
    isChildOrSelf(modelToCheck, potentialParentModel) {
        return (modelToCheck === potentialParentModel ||
            (potentialParentModel.filterType === 'join' &&
                potentialParentModel.conditions.some((condition) => this.isChildOrSelf(modelToCheck, condition))));
    }
    setupFilterModel() {
        const filterModel = this.formatFilterModel(this.advancedFilter.getModel());
        this.stringifiedModel = JSON.stringify(filterModel);
        return filterModel;
    }
    formatFilterModel(filterModel) {
        filterModel = filterModel ?? {
            filterType: 'join',
            type: 'AND',
            conditions: [],
        };
        if (filterModel.filterType !== 'join') {
            filterModel = {
                filterType: 'join',
                type: 'AND',
                conditions: [filterModel],
            };
        }
        return filterModel;
    }
    buildList() {
        const parseFilterModel = (filterModel, items, level, parent) => {
            items.push({ filterModel, level, parent, valid: true, showMove: this.showMove });
            if (filterModel.filterType === 'join') {
                filterModel.conditions.forEach((childFilterModel) => parseFilterModel(childFilterModel, items, level + 1, filterModel));
                if (level === 0) {
                    items.push({ filterModel: null, level: level + 1, parent: filterModel, valid: true });
                }
            }
        };
        this.items = [];
        parseFilterModel(this.filterModel, this.items, 0);
    }
    refreshList(softRefresh) {
        if (!softRefresh) {
            const invalidModels = [];
            this.items.forEach((item) => {
                if (!item.valid) {
                    invalidModels.push(item.filterModel);
                }
            });
            this.buildList();
            if (invalidModels.length) {
                this.items.forEach((item) => {
                    if (item.filterModel && invalidModels.includes(item.filterModel)) {
                        item.valid = false;
                    }
                });
            }
        }
        this.virtualList.refresh(softRefresh);
        this.validate();
    }
    updateItemComponent(item, comp) {
        const index = this.items.indexOf(item);
        const populateTreeLines = (filterModel, treeLines) => {
            const parentItem = this.items.find((itemToCheck) => itemToCheck.filterModel === filterModel);
            const parentFilterModel = parentItem?.parent;
            if (parentFilterModel) {
                const { conditions } = parentFilterModel;
                // check parent
                populateTreeLines(parentFilterModel, treeLines);
                treeLines.push(conditions[conditions.length - 1] === filterModel);
            }
        };
        const treeLines = [];
        const { filterModel } = item;
        if (filterModel) {
            populateTreeLines(filterModel, treeLines);
            // the add item button is always last child
            treeLines[0] = false;
        }
        const showStartTreeLine = filterModel?.filterType === 'join' && !!filterModel.conditions.length;
        comp.setState({
            disableMoveUp: index === 1,
            disableMoveDown: !this.canMoveDown(item, index),
            treeLines,
            showStartTreeLine,
        });
    }
    createItemComponent(item, focusWrapper) {
        const itemComp = this.createBean(item.filterModel
            ? new advancedFilterBuilderItemComp_1.AdvancedFilterBuilderItemComp(item, this.dragFeature, focusWrapper)
            : new advancedFilterBuilderItemAddComp_1.AdvancedFilterBuilderItemAddComp(item, focusWrapper));
        itemComp.addManagedListeners(itemComp, {
            advancedFilterBuilderRemoved: ({ item }) => this.removeItem(item),
            advancedFilterBuilderValueChanged: () => this.validate(),
            advancedFilterBuilderAdded: ({ item, isJoin }) => this.addItem(item, isJoin),
            advancedFilterBuilderMoved: ({ item, backwards }) => this.moveItemUpDown(item, backwards),
        });
        if (itemComp instanceof advancedFilterBuilderItemComp_1.AdvancedFilterBuilderItemComp) {
            this.updateItemComponent(item, itemComp);
        }
        return itemComp;
    }
    addItem(item, isJoin) {
        const { parent: itemParent, level, filterModel: itemFilterModel } = item;
        const itemIsJoin = itemFilterModel?.filterType === 'join';
        const filterModel = isJoin
            ? {
                filterType: 'join',
                type: 'AND',
                conditions: [],
            }
            : {};
        const parent = (itemIsJoin ? itemFilterModel : itemParent);
        let insertIndex = itemIsJoin ? 0 : parent.conditions.indexOf(itemFilterModel);
        if (insertIndex >= 0) {
            if (!itemIsJoin) {
                insertIndex += 1;
            }
            parent.conditions.splice(insertIndex, 0, filterModel);
        }
        else {
            parent.conditions.push(filterModel);
        }
        let index = this.items.indexOf(item);
        const softRefresh = index >= 0;
        if (softRefresh) {
            if (item.filterModel) {
                index++;
            }
            const newItems = [
                {
                    filterModel,
                    level: itemIsJoin ? level + 1 : level,
                    parent,
                    valid: isJoin,
                    showMove: this.showMove,
                },
            ];
            this.items.splice(index, 0, ...newItems);
        }
        this.refreshList(softRefresh);
        if (softRefresh) {
            this.virtualList.getComponentAt(index)?.afterAdd();
        }
    }
    removeItem(item) {
        const parent = item.parent;
        const { filterModel } = item;
        const parentIndex = parent.conditions.indexOf(filterModel);
        parent.conditions.splice(parentIndex, 1);
        const isJoin = item.filterModel?.filterType === 'join';
        const index = this.items.indexOf(item);
        // if it's a join, we don't know how many children there are, so always rebuild
        const softRefresh = !isJoin && index >= 0;
        if (softRefresh) {
            this.items.splice(index, 1);
        }
        this.refreshList(softRefresh);
        if (index >= 0) {
            this.virtualList.focusRow(index);
        }
    }
    moveItemUpDown(item, backwards) {
        const itemIndex = this.items.indexOf(item);
        const destinationIndex = backwards ? itemIndex - 1 : itemIndex + 1;
        if (destinationIndex === 0 || (!backwards && !this.canMoveDown(item, itemIndex))) {
            return;
        }
        const destinationItem = this.items[destinationIndex];
        const indexInParent = this.removeItemFromParent(item);
        const { level, filterModel, parent } = item;
        const { level: destinationLevel, filterModel: destinationFilterModel, parent: destinationParent, } = destinationItem;
        if (backwards) {
            if (destinationLevel === level && destinationFilterModel.filterType === 'join') {
                // destination is empty join. move to last child
                destinationFilterModel.conditions.push(filterModel);
            }
            else if (destinationLevel <= level) {
                // same parent or first child. move above destination in destination parent
                const destinationIndex = destinationParent.conditions.indexOf(destinationFilterModel);
                destinationParent.conditions.splice(destinationIndex, 0, filterModel);
            }
            else {
                // need to move up a level. move to end of previous item's children
                const newParentItem = parent.conditions[indexInParent - 1];
                newParentItem.conditions.push(filterModel);
            }
        }
        else {
            if (destinationLevel === level) {
                if (destinationFilterModel.filterType === 'join') {
                    // destination is join. move to first child
                    destinationFilterModel.conditions.splice(0, 0, filterModel);
                }
                else {
                    // switch positions
                    const destinationIndex = destinationParent.conditions.indexOf(destinationFilterModel);
                    destinationParent.conditions.splice(destinationIndex + 1, 0, filterModel);
                }
            }
            else {
                if (indexInParent < parent.conditions.length) {
                    // keep in parent, but swap with next child
                    parent.conditions.splice(indexInParent + 1, 0, filterModel);
                }
                else {
                    // need to move down a level. move after parent in its parent
                    const parentItem = this.items.find((itemToCheck) => itemToCheck.filterModel === parent);
                    const destinationIndex = parentItem.parent.conditions.indexOf(parentItem.filterModel) + 1;
                    parentItem.parent.conditions.splice(destinationIndex, 0, filterModel);
                }
            }
        }
        this.refreshList(false);
        const newIndex = this.items.findIndex(({ filterModel: filterModelToCheck }) => filterModelToCheck === filterModel);
        if (newIndex >= 0) {
            const comp = this.virtualList.getComponentAt(newIndex);
            if (comp instanceof advancedFilterBuilderItemComp_1.AdvancedFilterBuilderItemComp) {
                comp.focusMoveButton(backwards);
            }
        }
    }
    canMoveDown(item, index) {
        return !((item.level === 1 && index === this.items.length - 2) ||
            (item.level === 1 && item.parent.conditions[item.parent.conditions.length - 1] === item.filterModel));
    }
    close() {
        this.advancedFilter.getCtrl().toggleFilterBuilder({ source: 'ui' });
    }
    validate() {
        let disableApply = !this.items.every(({ valid }) => valid);
        if (!disableApply) {
            disableApply = JSON.stringify(this.filterModel) === this.stringifiedModel;
            if (disableApply) {
                this.validationMessage = this.advFilterExpSvc.translate('advancedFilterBuilderValidationAlreadyApplied');
            }
            else {
                this.validationMessage = null;
            }
        }
        else {
            this.validationMessage = this.advFilterExpSvc.translate('advancedFilterBuilderValidationIncomplete');
        }
        (0, ag_grid_community_1._setDisabled)(this.eApplyFilterButton, disableApply);
        this.validationTooltipFeature?.refreshTooltip();
    }
    validateItems() {
        const clearOperator = (filterModel) => {
            filterModel.type = undefined;
        };
        const clearOperand = (filterModel) => {
            delete filterModel.filter;
        };
        this.items.forEach((item) => {
            if (!item.valid || !item.filterModel || item.filterModel.filterType === 'join') {
                return;
            }
            const { filterModel } = item;
            const { colId } = filterModel;
            const hasColumn = this.advFilterExpSvc.getColumnAutocompleteEntries().find(({ key }) => key === colId);
            const columnDetails = this.advFilterExpSvc.getColumnDetails(filterModel.colId);
            if (!hasColumn || !columnDetails.column) {
                item.valid = false;
                filterModel.colId = undefined;
                clearOperator(filterModel);
                clearOperand(filterModel);
                return;
            }
            const operatorForType = this.advFilterExpSvc.getDataTypeExpressionOperator(columnDetails.baseCellDataType);
            const operator = operatorForType.operators[filterModel.type];
            if (!operator) {
                item.valid = false;
                clearOperator(filterModel);
                clearOperand(filterModel);
                return;
            }
            if (operator.numOperands > 0 && !(0, ag_grid_community_1._exists)(filterModel.filter)) {
                item.valid = false;
                return;
            }
        });
    }
}
exports.AdvancedFilterBuilderComp = AdvancedFilterBuilderComp;


/***/ }),

/***/ 2865:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterBuilderDragFeature = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const virtualListDragFeature_1 = __webpack_require__(5760);
class AdvancedFilterBuilderDragFeature extends ag_grid_community_1.BeanStub {
    constructor(comp, virtualList) {
        super();
        this.comp = comp;
        this.virtualList = virtualList;
    }
    postConstruct() {
        this.createManagedBean(new virtualListDragFeature_1.VirtualListDragFeature(this.comp, this.virtualList, {
            dragSourceType: ag_grid_community_1.DragSourceType.AdvancedFilterBuilder,
            listItemDragStartEvent: 'advancedFilterBuilderDragStarted',
            listItemDragEndEvent: 'advancedFilterBuilderDragEnded',
            eventSource: this,
            getCurrentDragValue: (listItemDragStartEvent) => this.getCurrentDragValue(listItemDragStartEvent),
            isMoveBlocked: () => false,
            getNumRows: (comp) => comp.getNumItems(),
            moveItem: (currentDragValue, lastHoveredListItem) => this.moveItem(currentDragValue, lastHoveredListItem),
        }));
    }
    getCurrentDragValue(listItemDragStartEvent) {
        return listItemDragStartEvent.item;
    }
    moveItem(currentDragValue, lastHoveredListItem) {
        this.comp.moveItem(currentDragValue, lastHoveredListItem);
    }
}
exports.AdvancedFilterBuilderDragFeature = AdvancedFilterBuilderDragFeature;


/***/ }),

/***/ 2172:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterBuilderItemAddComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const addDropdownComp_1 = __webpack_require__(5219);
const advancedFilterBuilderItemNavigationFeature_1 = __webpack_require__(1748);
const advancedFilterBuilderUtils_1 = __webpack_require__(6608);
class AdvancedFilterBuilderItemAddComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.advFilterExpSvc = beans.advFilterExpSvc;
        this.registry = beans.registry;
    }
    constructor(item, focusWrapper) {
        super(/* html */ `
            <div class="ag-advanced-filter-builder-item-wrapper" role="presentation">
                <div data-ref="eItem" class="ag-advanced-filter-builder-item" role="presentation">
                    <div class="ag-advanced-filter-builder-item-tree-lines" aria-hidden="true">
                        <div class="ag-advanced-filter-builder-item-tree-line-vertical-top ag-advanced-filter-builder-item-tree-line-horizontal"></div>
                    </div>
                </div>
            </div>
        `);
        this.item = item;
        this.focusWrapper = focusWrapper;
        this.eItem = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        (0, ag_grid_community_1._setAriaLevel)(this.focusWrapper, 2);
        const addButtonParams = (0, advancedFilterBuilderUtils_1.getAdvancedFilterBuilderAddButtonParams)((key) => this.advFilterExpSvc.translate(key), this.gos.get('advancedFilterBuilderParams')?.addSelectWidth);
        const eAddButton = this.createManagedBean(new addDropdownComp_1.AddDropdownComp(addButtonParams));
        this.addManagedListeners(eAddButton, {
            fieldPickerValueSelected: ({ value }) => {
                this.dispatchLocalEvent({
                    type: 'advancedFilterBuilderAdded',
                    item: this.item,
                    isJoin: value.key === 'join',
                });
            },
        });
        this.eItem.appendChild(eAddButton.getGui());
        this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => eAddButton.getGui(),
            getLocation: () => 'advancedFilter',
            getTooltipValue: () => this.advFilterExpSvc.translate('advancedFilterBuilderAddButtonTooltip'),
        }));
        this.createManagedBean(new advancedFilterBuilderItemNavigationFeature_1.AdvancedFilterBuilderItemNavigationFeature(this.getGui(), this.focusWrapper, eAddButton));
        (0, ag_grid_community_1._setAriaLabel)(this.focusWrapper, this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderItem', [
            this.advFilterExpSvc.translate('advancedFilterBuilderAddButtonTooltip'),
            `${this.item.level + 1}`,
        ]));
    }
    afterAdd() {
        // do nothing
    }
}
exports.AdvancedFilterBuilderItemAddComp = AdvancedFilterBuilderItemAddComp;


/***/ }),

/***/ 9889:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterBuilderItemComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const addDropdownComp_1 = __webpack_require__(5219);
const advancedFilterBuilderItemNavigationFeature_1 = __webpack_require__(1748);
const advancedFilterBuilderUtils_1 = __webpack_require__(6608);
const conditionPillWrapperComp_1 = __webpack_require__(6106);
const inputPillComp_1 = __webpack_require__(4042);
const joinPillWrapperComp_1 = __webpack_require__(1395);
const selectPillComp_1 = __webpack_require__(3036);
class AdvancedFilterBuilderItemComp extends ag_grid_community_1.TabGuardComp {
    wireBeans(beans) {
        this.dragAndDrop = beans.dragAndDrop;
        this.advFilterExpSvc = beans.advFilterExpSvc;
        this.registry = beans.registry;
    }
    constructor(item, dragFeature, focusWrapper) {
        super(/* html */ `
            <div class="ag-advanced-filter-builder-item-wrapper" role="presentation">
                <div class="ag-advanced-filter-builder-item" role="presentation">
                    <div data-ref="eTreeLines" class="ag-advanced-filter-builder-item-tree-lines" aria-hidden="true"></div>
                    <span data-ref="eDragHandle" class="ag-drag-handle" aria-hidden="true"></span>
                    <span data-ref="eValidation" class="ag-advanced-filter-builder-item-button ag-advanced-filter-builder-invalid" aria-hidden="true"></span>
                </div>
                <div data-ref="eButtons" class="ag-advanced-filter-builder-item-buttons">
                    <span data-ref="eMoveUpButton" class="ag-advanced-filter-builder-item-button" role="button"></span>
                    <span data-ref="eMoveDownButton" class="ag-advanced-filter-builder-item-button" role="button"></span>
                    <div data-ref="eAddButton" role="presentation"></div>
                    <span data-ref="eRemoveButton" class="ag-advanced-filter-builder-item-button" role="button"></span>
                </div>
            </div>
        `);
        this.item = item;
        this.dragFeature = dragFeature;
        this.focusWrapper = focusWrapper;
        this.eTreeLines = ag_grid_community_1.RefPlaceholder;
        this.eDragHandle = ag_grid_community_1.RefPlaceholder;
        this.eButtons = ag_grid_community_1.RefPlaceholder;
        this.eValidation = ag_grid_community_1.RefPlaceholder;
        this.eMoveUpButton = ag_grid_community_1.RefPlaceholder;
        this.eMoveDownButton = ag_grid_community_1.RefPlaceholder;
        this.eAddButton = ag_grid_community_1.RefPlaceholder;
        this.eRemoveButton = ag_grid_community_1.RefPlaceholder;
        this.moveUpDisabled = false;
        this.moveDownDisabled = false;
    }
    postConstruct() {
        const { filterModel, level, showMove } = this.item;
        const isJoin = filterModel.filterType === 'join';
        this.ePillWrapper = this.createManagedBean(isJoin ? new joinPillWrapperComp_1.JoinPillWrapperComp() : new conditionPillWrapperComp_1.ConditionPillWrapperComp());
        this.ePillWrapper.init({ item: this.item, createPill: (params) => this.createPill(params) });
        this.eDragHandle.insertAdjacentElement('afterend', this.ePillWrapper.getGui());
        if (level === 0) {
            const eTreeLine = document.createElement('div');
            eTreeLine.classList.add('ag-advanced-filter-builder-item-tree-line-vertical-bottom');
            eTreeLine.classList.add('ag-advanced-filter-builder-item-tree-line-root');
            this.eTreeLines.appendChild(eTreeLine);
            (0, ag_grid_community_1._setDisplayed)(this.eDragHandle, false);
            (0, ag_grid_community_1._setDisplayed)(this.eButtons, false);
            (0, ag_grid_community_1._setAriaExpanded)(this.focusWrapper, true);
        }
        else {
            this.setupTreeLines(level);
            this.eDragHandle.appendChild((0, ag_grid_community_1._createIconNoSpan)('advancedFilterBuilderDrag', this.beans));
            this.setupValidation();
            this.setupMoveButtons(showMove);
            this.setupAddButton();
            this.setupRemoveButton();
            this.setupDragging();
            this.updateAriaExpanded();
        }
        (0, ag_grid_community_1._setAriaLevel)(this.focusWrapper, level + 1);
        this.initialiseTabGuard({});
        this.createManagedBean(new advancedFilterBuilderItemNavigationFeature_1.AdvancedFilterBuilderItemNavigationFeature(this.getGui(), this.focusWrapper, this.ePillWrapper));
        this.updateAriaLabel();
        this.addManagedListeners(this.ePillWrapper, {
            advancedFilterBuilderValueChanged: () => this.dispatchLocalEvent({
                type: 'advancedFilterBuilderValueChanged',
            }),
            advancedFilterBuilderValidChanged: () => this.updateValidity(),
        });
    }
    setState(params) {
        const { level } = this.item;
        if (level === 0) {
            return;
        }
        const { showMove } = this.item;
        const { disableMoveUp, disableMoveDown, treeLines, showStartTreeLine } = params;
        this.updateTreeLines(treeLines, showStartTreeLine);
        this.updateAriaExpanded();
        if (showMove) {
            this.moveUpDisabled = !!disableMoveUp;
            this.moveDownDisabled = !!disableMoveDown;
            this.eMoveUpButton.classList.toggle('ag-advanced-filter-builder-item-button-disabled', disableMoveUp);
            this.eMoveDownButton.classList.toggle('ag-advanced-filter-builder-item-button-disabled', disableMoveDown);
            (0, ag_grid_community_1._setAriaDisabled)(this.eMoveUpButton, !!disableMoveUp);
            (0, ag_grid_community_1._setAriaDisabled)(this.eMoveDownButton, !!disableMoveDown);
            this.moveUpTooltipFeature?.refreshTooltip();
            this.moveDownTooltipFeature?.refreshTooltip();
        }
    }
    focusMoveButton(backwards) {
        (backwards ? this.eMoveUpButton : this.eMoveDownButton).focus();
    }
    afterAdd() {
        this.ePillWrapper.getFocusableElement().focus();
    }
    setupTreeLines(level) {
        for (let i = 0; i < level; i++) {
            const eTreeLine = document.createElement('div');
            this.eTreeLines.appendChild(eTreeLine);
        }
    }
    updateTreeLines(treeLines, showStartTreeLine) {
        const lastTreeLineIndex = treeLines.length - 1;
        const { children } = this.eTreeLines;
        for (let i = 0; i < lastTreeLineIndex; i++) {
            const eTreeLine = children.item(i);
            if (eTreeLine) {
                eTreeLine.classList.toggle('ag-advanced-filter-builder-item-tree-line-vertical', !treeLines[i]);
            }
        }
        const eTreeLine = children.item(lastTreeLineIndex);
        if (eTreeLine) {
            eTreeLine.classList.add('ag-advanced-filter-builder-item-tree-line-horizontal');
            const isLastChild = treeLines[lastTreeLineIndex];
            eTreeLine.classList.toggle('ag-advanced-filter-builder-item-tree-line-vertical-top', isLastChild);
            eTreeLine.classList.toggle('ag-advanced-filter-builder-item-tree-line-vertical', !isLastChild);
        }
        this.eDragHandle.classList.toggle('ag-advanced-filter-builder-item-tree-line-vertical-bottom', showStartTreeLine);
    }
    setupValidation() {
        this.eValidation.appendChild((0, ag_grid_community_1._createIconNoSpan)('advancedFilterBuilderInvalid', this.beans));
        this.validationTooltipFeature = this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.eValidation,
            getLocation: () => 'advancedFilter',
            getTooltipValue: () => this.ePillWrapper.getValidationMessage(),
            getTooltipShowDelayOverride: () => 1000,
        }));
        this.updateValidity();
    }
    setupAddButton() {
        const addButtonParams = (0, advancedFilterBuilderUtils_1.getAdvancedFilterBuilderAddButtonParams)((key) => this.advFilterExpSvc.translate(key), this.gos.get('advancedFilterBuilderParams')?.addSelectWidth);
        const eAddButton = this.createManagedBean(new addDropdownComp_1.AddDropdownComp(addButtonParams));
        this.addManagedListeners(eAddButton, {
            fieldPickerValueSelected: ({ value }) => this.dispatchLocalEvent({
                type: 'advancedFilterBuilderAdded',
                item: this.item,
                isJoin: value.key === 'join',
            }),
        });
        this.eAddButton.appendChild(eAddButton.getGui());
        this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.eAddButton,
            getLocation: () => 'advancedFilter',
            getTooltipValue: () => this.advFilterExpSvc.translate('advancedFilterBuilderAddButtonTooltip'),
        }));
    }
    setupRemoveButton() {
        this.eRemoveButton.appendChild((0, ag_grid_community_1._createIconNoSpan)('advancedFilterBuilderRemove', this.beans));
        this.addManagedListeners(this.eRemoveButton, {
            click: () => this.removeItem(),
            keydown: (event) => {
                switch (event.key) {
                    case ag_grid_community_1.KeyCode.ENTER:
                        event.preventDefault();
                        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                        this.removeItem();
                        break;
                }
            },
        });
        this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.eRemoveButton,
            getLocation: () => 'advancedFilter',
            getTooltipValue: () => this.advFilterExpSvc.translate('advancedFilterBuilderRemoveButtonTooltip'),
        }));
        (0, ag_grid_community_1._setAriaLabel)(this.eRemoveButton, this.advFilterExpSvc.translate('advancedFilterBuilderRemoveButtonTooltip'));
        this.activateTabIndex([this.eRemoveButton]);
    }
    setupMoveButtons(showMove) {
        if (showMove) {
            this.eMoveUpButton.appendChild((0, ag_grid_community_1._createIconNoSpan)('advancedFilterBuilderMoveUp', this.beans));
            this.addManagedListeners(this.eMoveUpButton, {
                click: () => this.moveItem(true),
                keydown: (event) => {
                    switch (event.key) {
                        case ag_grid_community_1.KeyCode.ENTER:
                            event.preventDefault();
                            (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                            this.moveItem(true);
                            break;
                    }
                },
            });
            this.moveUpTooltipFeature = this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
                getGui: () => this.eMoveUpButton,
                getLocation: () => 'advancedFilter',
                getTooltipValue: () => this.moveUpDisabled
                    ? null
                    : this.advFilterExpSvc.translate('advancedFilterBuilderMoveUpButtonTooltip'),
            }));
            (0, ag_grid_community_1._setAriaLabel)(this.eMoveUpButton, this.advFilterExpSvc.translate('advancedFilterBuilderMoveUpButtonTooltip'));
            this.eMoveDownButton.appendChild((0, ag_grid_community_1._createIconNoSpan)('advancedFilterBuilderMoveDown', this.beans));
            this.addManagedListeners(this.eMoveDownButton, {
                click: () => this.moveItem(false),
                keydown: (event) => {
                    switch (event.key) {
                        case ag_grid_community_1.KeyCode.ENTER:
                            event.preventDefault();
                            (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                            this.moveItem(false);
                            break;
                    }
                },
            });
            this.moveDownTooltipFeature = this.createOptionalManagedBean(this.registry.createDynamicBean('tooltipFeature', false, {
                getGui: () => this.eMoveDownButton,
                getLocation: () => 'advancedFilter',
                getTooltipValue: () => this.moveDownDisabled
                    ? null
                    : this.advFilterExpSvc.translate('advancedFilterBuilderMoveDownButtonTooltip'),
            }));
            (0, ag_grid_community_1._setAriaLabel)(this.eMoveDownButton, this.advFilterExpSvc.translate('advancedFilterBuilderMoveDownButtonTooltip'));
            this.activateTabIndex([this.eMoveUpButton, this.eMoveDownButton]);
        }
        else {
            (0, ag_grid_community_1._setDisplayed)(this.eMoveUpButton, false);
            (0, ag_grid_community_1._setDisplayed)(this.eMoveDownButton, false);
        }
    }
    updateValidity() {
        (0, ag_grid_community_1._setVisible)(this.eValidation, !this.item.valid);
        this.validationTooltipFeature?.refreshTooltip();
        this.updateAriaLabel();
    }
    createPill(params) {
        const { key, cssClass, update, ariaLabel } = params;
        const onUpdated = (key) => {
            if (key == null) {
                return;
            }
            update(key);
            this.dispatchLocalEvent({
                type: 'advancedFilterBuilderValueChanged',
            });
        };
        if (params.isSelect) {
            const { getEditorParams, pickerAriaLabelKey, pickerAriaLabelValue, displayValue } = params;
            const advancedFilterBuilderParams = this.gos.get('advancedFilterBuilderParams');
            const minPickerWidth = `${advancedFilterBuilderParams?.pillSelectMinWidth ?? 140}px`;
            const maxPickerWidth = `${advancedFilterBuilderParams?.pillSelectMaxWidth ?? 200}px`;
            const comp = this.createBean(new selectPillComp_1.SelectPillComp({
                pickerAriaLabelKey,
                pickerAriaLabelValue,
                pickerType: 'ag-list',
                value: {
                    key,
                    displayValue,
                },
                valueFormatter: (value) => value == null ? '' : value.displayValue ?? value.key,
                variableWidth: true,
                minPickerWidth,
                maxPickerWidth,
                getEditorParams,
                wrapperClassName: cssClass,
                ariaLabel,
                pickerIcon: 'advancedFilterBuilderSelectOpen',
            }));
            this.addManagedListeners(comp, {
                fieldPickerValueSelected: ({ value }) => onUpdated(value?.key),
            });
            return comp;
        }
        else {
            const { baseCellDataType, valueFormatter } = params;
            const comp = this.createBean(new inputPillComp_1.InputPillComp({
                value: key,
                valueFormatter,
                cssClass,
                type: this.getInputType(baseCellDataType),
                ariaLabel,
            }));
            this.addManagedListeners(comp, { fieldValueChanged: ({ value }) => onUpdated(value) });
            return comp;
        }
    }
    getInputType(baseCellDataType) {
        switch (baseCellDataType) {
            case 'text':
            case 'object':
            case 'boolean':
                return 'text';
            case 'number':
                return 'number';
            case 'date':
            case 'dateString':
                return 'date';
        }
    }
    setupDragging() {
        const dragSource = {
            type: ag_grid_community_1.DragSourceType.AdvancedFilterBuilder,
            eElement: this.eDragHandle,
            dragItemName: () => this.ePillWrapper.getDragName(),
            getDefaultIconName: () => 'notAllowed',
            getDragItem: () => ({}),
            onDragStarted: () => this.dragFeature.dispatchLocalEvent({
                type: 'advancedFilterBuilderDragStarted',
                item: this.item,
            }),
            onDragStopped: () => this.dragFeature.dispatchLocalEvent({
                type: 'advancedFilterBuilderDragEnded',
            }),
        };
        this.dragAndDrop.addDragSource(dragSource, true);
        this.addDestroyFunc(() => this.dragAndDrop.removeDragSource(dragSource));
    }
    updateAriaLabel() {
        const wrapperLabel = this.ePillWrapper.getAriaLabel();
        const level = `${this.item.level + 1}`;
        const validationMessage = this.ePillWrapper.getValidationMessage();
        let ariaLabel;
        if (validationMessage) {
            ariaLabel = this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderItemValidation', [
                wrapperLabel,
                level,
                validationMessage,
            ]);
        }
        else {
            ariaLabel = this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderItem', [wrapperLabel, level]);
        }
        (0, ag_grid_community_1._setAriaLabel)(this.focusWrapper, ariaLabel);
    }
    updateAriaExpanded() {
        (0, ag_grid_community_1._removeAriaExpanded)(this.focusWrapper);
        const { filterModel } = this.item;
        if (filterModel?.filterType === 'join' && filterModel.conditions.length) {
            (0, ag_grid_community_1._setAriaExpanded)(this.focusWrapper, true);
        }
    }
    removeItem() {
        this.dispatchLocalEvent({
            type: 'advancedFilterBuilderRemoved',
            item: this.item,
        });
    }
    moveItem(backwards) {
        this.dispatchLocalEvent({
            type: 'advancedFilterBuilderMoved',
            item: this.item,
            backwards,
        });
    }
}
exports.AdvancedFilterBuilderItemComp = AdvancedFilterBuilderItemComp;


/***/ }),

/***/ 1748:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedFilterBuilderItemNavigationFeature = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AdvancedFilterBuilderItemNavigationFeature extends ag_grid_community_1.BeanStub {
    constructor(eGui, focusWrapper, eFocusableComp) {
        super();
        this.eGui = eGui;
        this.focusWrapper = focusWrapper;
        this.eFocusableComp = eFocusableComp;
    }
    postConstruct() {
        this.addManagedElementListeners(this.eGui, {
            keydown: (event) => {
                switch (event.key) {
                    case ag_grid_community_1.KeyCode.TAB:
                        if (!event.defaultPrevented) {
                            // tab guard handled the navigation. stop from reaching virtual list
                            (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                        }
                        break;
                    case ag_grid_community_1.KeyCode.UP:
                    case ag_grid_community_1.KeyCode.DOWN:
                        // if this hasn't been handled by an editor, prevent virtual list navigation
                        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                        break;
                    case ag_grid_community_1.KeyCode.ESCAPE:
                        if ((0, ag_grid_community_1._isStopPropagationForAgGrid)(event)) {
                            return;
                        }
                        if (this.eGui.contains((0, ag_grid_community_1._getActiveDomElement)(this.beans))) {
                            event.preventDefault();
                            (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                            this.focusWrapper.focus();
                        }
                        break;
                }
            },
        });
        const highlightClass = 'ag-advanced-filter-builder-virtual-list-item-highlight';
        this.addManagedListeners(this.focusWrapper, {
            keydown: (event) => {
                switch (event.key) {
                    case ag_grid_community_1.KeyCode.ENTER:
                        if ((0, ag_grid_community_1._isStopPropagationForAgGrid)(event)) {
                            return;
                        }
                        if ((0, ag_grid_community_1._getActiveDomElement)(this.beans) === this.focusWrapper) {
                            event.preventDefault();
                            (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                            this.eFocusableComp.getFocusableElement().focus();
                        }
                        break;
                }
            },
            focusin: () => {
                this.focusWrapper.classList.add(highlightClass);
            },
            focusout: (event) => {
                if (!this.focusWrapper.contains(event.relatedTarget)) {
                    this.focusWrapper.classList.remove(highlightClass);
                }
            },
        });
    }
}
exports.AdvancedFilterBuilderItemNavigationFeature = AdvancedFilterBuilderItemNavigationFeature;


/***/ }),

/***/ 6608:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getAdvancedFilterBuilderAddButtonParams = void 0;
function getAdvancedFilterBuilderAddButtonParams(translate, maxPickerWidth) {
    return {
        pickerAriaLabelKey: 'ariaLabelAdvancedFilterBuilderAddField',
        pickerAriaLabelValue: 'Advanced Filter Builder Add Field',
        pickerType: 'ag-list',
        valueList: [
            {
                key: 'condition',
                displayValue: translate('advancedFilterBuilderAddCondition'),
            },
            {
                key: 'join',
                displayValue: translate('advancedFilterBuilderAddJoin'),
            },
        ],
        valueFormatter: (value) => (value == null ? '' : value.displayValue ?? value.key),
        pickerIcon: 'advancedFilterBuilderAdd',
        maxPickerWidth: `${maxPickerWidth ?? 120}px`,
        wrapperClassName: 'ag-advanced-filter-builder-item-button',
        ariaLabel: translate('advancedFilterBuilderAddButtonTooltip'),
    };
}
exports.getAdvancedFilterBuilderAddButtonParams = getAdvancedFilterBuilderAddButtonParams;


/***/ }),

/***/ 6106:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConditionPillWrapperComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ConditionPillWrapperComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.advFilterExpSvc = beans.advFilterExpSvc;
    }
    constructor() {
        super(/* html */ `
            <div class="ag-advanced-filter-builder-item-condition" role="presentation"></div>
        `);
        this.validationMessage = null;
    }
    init(params) {
        const { item, createPill } = params;
        this.item = item;
        this.createPill = createPill;
        this.filterModel = item.filterModel;
        this.setupColumnCondition(this.filterModel);
        this.validate();
        this.addDestroyFunc(() => this.destroyBeans([this.eColumnPill, this.eOperatorPill, this.eOperandPill]));
    }
    getDragName() {
        return this.filterModel.colId
            ? this.advFilterExpSvc.parseColumnFilterModel(this.filterModel)
            : this.getDefaultColumnDisplayValue();
    }
    getAriaLabel() {
        return `${this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderFilterItem')} ${this.getDragName()}`;
    }
    getValidationMessage() {
        return this.validationMessage;
    }
    getFocusableElement() {
        return this.eColumnPill.getFocusableElement();
    }
    setupColumnCondition(filterModel) {
        const columnDetails = this.advFilterExpSvc.getColumnDetails(filterModel.colId);
        this.baseCellDataType = columnDetails.baseCellDataType;
        this.column = columnDetails.column;
        this.numOperands = this.getNumOperands(this.getOperatorKey());
        this.eColumnPill = this.createPill({
            key: this.getColumnKey(),
            displayValue: this.getColumnDisplayValue() ?? this.getDefaultColumnDisplayValue(),
            cssClass: 'ag-advanced-filter-builder-column-pill',
            isSelect: true,
            getEditorParams: () => ({ values: this.advFilterExpSvc.getColumnAutocompleteEntries() }),
            update: (key) => this.setColumnKey(key),
            pickerAriaLabelKey: 'ariaLabelAdvancedFilterBuilderColumnSelectField',
            pickerAriaLabelValue: 'Advanced Filter Builder Column Select Field',
            ariaLabel: this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderColumn'),
        });
        this.getGui().appendChild(this.eColumnPill.getGui());
        if ((0, ag_grid_community_1._exists)(this.getColumnKey())) {
            this.createOperatorPill();
            if (this.hasOperand()) {
                this.createOperandPill();
            }
        }
    }
    createOperatorPill() {
        this.eOperatorPill = this.createPill({
            key: this.getOperatorKey(),
            displayValue: this.getOperatorDisplayValue() ?? this.getDefaultOptionSelectValue(),
            cssClass: 'ag-advanced-filter-builder-option-pill',
            isSelect: true,
            getEditorParams: () => ({ values: this.getOperatorAutocompleteEntries() }),
            update: (key) => this.setOperatorKey(key),
            pickerAriaLabelKey: 'ariaLabelAdvancedFilterBuilderOptionSelectField',
            pickerAriaLabelValue: 'Advanced Filter Builder Option Select Field',
            ariaLabel: this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderOption'),
        });
        this.eColumnPill.getGui().insertAdjacentElement('afterend', this.eOperatorPill.getGui());
    }
    createOperandPill() {
        // Date inputs want iso string, so read straight from model. For numbers, convert to string
        const { filter } = this.filterModel;
        const key = (typeof filter === 'number' ? (0, ag_grid_community_1._toStringOrNull)(filter) : filter) ?? '';
        this.eOperandPill = this.createPill({
            key,
            // Convert from the input format to display format.
            // Input format matches model format except for numbers, but these get stringified anyway
            valueFormatter: (value) => this.advFilterExpSvc.getOperandDisplayValue({ ...this.filterModel, filter: value }, true),
            baseCellDataType: this.baseCellDataType,
            cssClass: 'ag-advanced-filter-builder-value-pill',
            isSelect: false,
            update: (key) => this.setOperand(key),
            ariaLabel: this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderValue'),
        });
        this.getGui().appendChild(this.eOperandPill.getGui());
    }
    getColumnKey() {
        return this.filterModel.colId;
    }
    getColumnDisplayValue() {
        return this.advFilterExpSvc.getColumnDisplayValue(this.filterModel);
    }
    getOperatorKey() {
        return this.filterModel.type;
    }
    getOperatorDisplayValue() {
        return this.advFilterExpSvc.getOperatorDisplayValue(this.filterModel);
    }
    getOperandDisplayValue() {
        return this.advFilterExpSvc.getOperandDisplayValue(this.filterModel, true);
    }
    hasOperand() {
        return this.numOperands > 0;
    }
    getOperatorAutocompleteEntries() {
        return this.column
            ? this.advFilterExpSvc.getOperatorAutocompleteEntries(this.column, this.baseCellDataType)
            : [];
    }
    setColumnKey(colId) {
        if (!this.eOperatorPill) {
            this.createOperatorPill();
        }
        const newColumnDetails = this.advFilterExpSvc.getColumnDetails(colId);
        this.column = newColumnDetails.column;
        const newBaseCellDataType = newColumnDetails.baseCellDataType;
        if (this.baseCellDataType !== newBaseCellDataType) {
            this.baseCellDataType = newBaseCellDataType;
            this.setOperatorKey(undefined);
            if (this.eOperatorPill) {
                (0, ag_grid_community_1._removeFromParent)(this.eOperatorPill.getGui());
                this.destroyBean(this.eOperatorPill);
                this.createOperatorPill();
            }
            this.validate();
        }
        this.filterModel.colId = colId;
        this.filterModel.filterType = this.baseCellDataType;
    }
    setOperatorKey(operator) {
        const newNumOperands = this.getNumOperands(operator);
        if (newNumOperands !== this.numOperands) {
            this.numOperands = newNumOperands;
            if (newNumOperands === 0) {
                this.destroyOperandPill();
            }
            else {
                this.createOperandPill();
                if (this.baseCellDataType !== 'number') {
                    this.setOperand('');
                }
            }
        }
        this.filterModel.type = operator;
        this.validate();
    }
    setOperand(operand) {
        let parsedOperand = operand;
        // Number comes back as string from input, so convert. Dates are already in iso string format
        if (this.baseCellDataType === 'number') {
            parsedOperand = (0, ag_grid_community_1._exists)(operand) ? Number(operand) : '';
        }
        this.filterModel.filter = parsedOperand;
        this.validate();
    }
    getNumOperands(operator) {
        return this.advFilterExpSvc.getExpressionOperator(this.baseCellDataType, operator)?.numOperands ?? 0;
    }
    destroyOperandPill() {
        delete this.filterModel.filter;
        this.getGui().removeChild(this.eOperandPill.getGui());
        this.destroyBean(this.eOperandPill);
        this.eOperandPill = undefined;
    }
    validate() {
        let validationMessage = null;
        if (!(0, ag_grid_community_1._exists)(this.getColumnKey())) {
            validationMessage = this.advFilterExpSvc.translate('advancedFilterBuilderValidationSelectColumn');
        }
        else if (!(0, ag_grid_community_1._exists)(this.getOperatorKey())) {
            validationMessage = this.advFilterExpSvc.translate('advancedFilterBuilderValidationSelectOption');
        }
        else if (this.numOperands > 0 && !(0, ag_grid_community_1._exists)(this.getOperandDisplayValue())) {
            validationMessage = this.advFilterExpSvc.translate('advancedFilterBuilderValidationEnterValue');
        }
        this.item.valid = !validationMessage;
        if (validationMessage !== this.validationMessage) {
            this.validationMessage = validationMessage;
            this.dispatchLocalEvent({
                type: 'advancedFilterBuilderValidChanged',
            });
        }
    }
    getDefaultColumnDisplayValue() {
        return this.advFilterExpSvc.translate('advancedFilterBuilderSelectColumn');
    }
    getDefaultOptionSelectValue() {
        return this.advFilterExpSvc.translate('advancedFilterBuilderSelectOption');
    }
}
exports.ConditionPillWrapperComp = ConditionPillWrapperComp;


/***/ }),

/***/ 4042:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputPillComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class InputPillComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.advFilterExpSvc = beans.advFilterExpSvc;
    }
    constructor(params) {
        super(/* html */ `
            <div class="ag-advanced-filter-builder-pill-wrapper" role="presentation">
                <div data-ref="ePill" class="ag-advanced-filter-builder-pill" role="button">
                    <span data-ref="eLabel" class="ag-advanced-filter-builder-pill-display"></span>
                </div>
            </div>
        `);
        this.params = params;
        this.ePill = ag_grid_community_1.RefPlaceholder;
        this.eLabel = ag_grid_community_1.RefPlaceholder;
        const { value, valueFormatter } = params;
        this.value = value;
        this.displayValue = valueFormatter(value);
    }
    postConstruct() {
        const { cssClass, ariaLabel } = this.params;
        this.ePill.classList.add(cssClass);
        this.activateTabIndex([this.ePill]);
        this.eLabel.id = `${this.getCompId()}`;
        (0, ag_grid_community_1._setAriaDescribedBy)(this.ePill, this.eLabel.id);
        (0, ag_grid_community_1._setAriaLabel)(this.ePill, ariaLabel);
        this.renderValue();
        this.addManagedListeners(this.ePill, {
            click: (event) => {
                event.preventDefault();
                this.showEditor();
            },
            keydown: (event) => {
                switch (event.key) {
                    case ag_grid_community_1.KeyCode.ENTER:
                        event.preventDefault();
                        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                        this.showEditor();
                        break;
                }
            },
        });
        this.addDestroyFunc(() => this.destroyBean(this.eEditor));
    }
    getFocusableElement() {
        return this.ePill;
    }
    showEditor() {
        if (this.eEditor) {
            return;
        }
        (0, ag_grid_community_1._setDisplayed)(this.ePill, false);
        this.eEditor = this.createEditorComp(this.params.type);
        this.eEditor.setValue(this.value);
        const eEditorGui = this.eEditor.getGui();
        this.eEditor.addManagedElementListeners(eEditorGui, {
            keydown: (event) => {
                switch (event.key) {
                    case ag_grid_community_1.KeyCode.ENTER:
                        event.preventDefault();
                        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                        this.updateValue(true);
                        break;
                    case ag_grid_community_1.KeyCode.ESCAPE:
                        event.preventDefault();
                        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
                        this.hideEditor(true);
                        break;
                }
            },
            focusout: () => this.updateValue(false),
        });
        this.getGui().appendChild(eEditorGui);
        this.eEditor.getFocusableElement().focus();
    }
    createEditorComp(type) {
        let comp;
        switch (type) {
            case 'text':
                comp = new ag_grid_community_1.AgInputTextField();
                break;
            case 'number':
                comp = new ag_grid_community_1.AgInputNumberField();
                break;
            case 'date':
                comp = new ag_grid_community_1.AgInputDateField();
                break;
        }
        return this.createBean(comp);
    }
    hideEditor(keepFocus) {
        const { eEditor } = this;
        if (!eEditor) {
            return;
        }
        this.eEditor = undefined;
        this.getGui().removeChild(eEditor.getGui());
        this.destroyBean(eEditor);
        (0, ag_grid_community_1._setDisplayed)(this.ePill, true);
        if (keepFocus) {
            this.ePill.focus();
        }
    }
    renderValue() {
        let value;
        const { displayValue, eLabel } = this;
        const { classList } = eLabel;
        classList.remove('ag-advanced-filter-builder-value-empty', 'ag-advanced-filter-builder-value-number', 'ag-advanced-filter-builder-value-text');
        if (!(0, ag_grid_community_1._exists)(displayValue)) {
            value = this.advFilterExpSvc.translate('advancedFilterBuilderEnterValue');
            classList.add('ag-advanced-filter-builder-value-empty');
        }
        else if (this.params.type === 'number') {
            value = displayValue;
            classList.add('ag-advanced-filter-builder-value-number');
        }
        else {
            value = `"${displayValue}"`;
            classList.add('ag-advanced-filter-builder-value-text');
        }
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        eLabel.innerText = value;
    }
    updateValue(keepFocus) {
        if (!this.eEditor) {
            return;
        }
        const value = this.eEditor.getValue() ?? '';
        this.dispatchLocalEvent({
            type: 'fieldValueChanged',
            value,
        });
        this.value = value;
        this.displayValue = this.params.valueFormatter(value);
        this.renderValue();
        this.hideEditor(keepFocus);
    }
}
exports.InputPillComp = InputPillComp;


/***/ }),

/***/ 1395:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.JoinPillWrapperComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class JoinPillWrapperComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.advFilterExpSvc = beans.advFilterExpSvc;
    }
    constructor() {
        super(/* html */ `
            <div class="ag-advanced-filter-builder-item-condition" role="presentation"></div>
        `);
    }
    init(params) {
        const { item, createPill } = params;
        const filterModel = item.filterModel;
        this.filterModel = filterModel;
        this.ePill = createPill({
            key: filterModel.type,
            displayValue: this.advFilterExpSvc.parseJoinOperator(filterModel),
            cssClass: 'ag-advanced-filter-builder-join-pill',
            isSelect: true,
            getEditorParams: () => ({
                values: this.advFilterExpSvc.getJoinOperatorAutocompleteEntries(),
            }),
            update: (key) => (filterModel.type = key),
            pickerAriaLabelKey: 'ariaLabelAdvancedFilterBuilderJoinSelectField',
            pickerAriaLabelValue: 'Advanced Filter Builder Join Operator Select Field',
            ariaLabel: this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderJoinOperator'),
        });
        this.getGui().appendChild(this.ePill.getGui());
        this.addDestroyFunc(() => this.destroyBean(this.ePill));
    }
    getDragName() {
        return this.advFilterExpSvc.parseJoinOperator(this.filterModel);
    }
    getAriaLabel() {
        return `${this.advFilterExpSvc.translate('ariaAdvancedFilterBuilderGroupItem')} ${this.getDragName()}`;
    }
    getValidationMessage() {
        return null;
    }
    getFocusableElement() {
        return this.ePill.getFocusableElement();
    }
}
exports.JoinPillWrapperComp = JoinPillWrapperComp;


/***/ }),

/***/ 3036:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SelectPillComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agRichSelect_1 = __webpack_require__(2005);
class SelectPillComp extends agRichSelect_1.AgRichSelect {
    constructor(params) {
        super({
            ...params,
            template: /* html */ `
                <div class="ag-picker-field ag-advanced-filter-builder-pill-wrapper" role="presentation">
                    <div data-ref="eLabel"></div>
                    <div data-ref="eWrapper" class="ag-wrapper ag-advanced-filter-builder-pill ag-picker-collapsed">
                        <div data-ref="eDisplayField" class="ag-picker-field-display ag-advanced-filter-builder-pill-display"></div>
                        <ag-input-text-field data-ref="eInput" class="ag-rich-select-field-input"></ag-input-text-field>
                        <span data-ref="eDeselect" class="ag-rich-select-deselect-button ag-picker-field-icon" role="presentation"></span>
                        <div data-ref="eIcon" class="ag-picker-field-icon" aria-hidden="true"></div>
                    </div>
                </div>`,
            agComponents: [ag_grid_community_1.AgInputTextFieldSelector],
        });
        this.params = params;
    }
    getFocusableElement() {
        return this.eWrapper;
    }
    showPicker() {
        // avoid focus handling issues with multiple rich selects
        setTimeout(() => super.showPicker());
    }
    hidePicker() {
        // avoid focus handling issues with multiple rich selects
        setTimeout(() => super.hidePicker());
    }
    postConstruct() {
        super.postConstruct();
        const { wrapperClassName, ariaLabel } = this.params;
        this.eWrapper.classList.add(wrapperClassName);
        (0, ag_grid_community_1._setAriaLabelledBy)(this.eWrapper, '');
        (0, ag_grid_community_1._setAriaLabel)(this.eWrapper, ariaLabel);
    }
    createPickerComponent() {
        if (!this.values) {
            const { values } = this.params.getEditorParams();
            this.values = values;
            const key = this.value.key;
            const value = values.find((value) => value.key === key) ?? {
                key,
                displayValue: this.value.displayValue,
            };
            this.value = value;
        }
        return super.createPickerComponent();
    }
    onEnterKeyDown(event) {
        (0, ag_grid_community_1._stopPropagationForAgGrid)(event);
        if (this.isPickerDisplayed) {
            super.onEnterKeyDown(event);
        }
        else {
            event.preventDefault();
            this.showPicker();
        }
    }
}
exports.SelectPillComp = SelectPillComp;


/***/ }),

/***/ 9023:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColFilterExpressionParser = exports.COL_FILTER_EXPRESSION_END_CHAR = exports.COL_FILTER_EXPRESSION_START_CHAR = void 0;
const filterExpressionUtils_1 = __webpack_require__(6487);
class ColumnParser {
    constructor(params, startPosition) {
        this.params = params;
        this.startPosition = startPosition;
        this.type = 'column';
        this.valid = true;
        this.hasStartChar = false;
        this.hasEndChar = false;
        this.colName = '';
    }
    parse(char, position) {
        if (char === exports.COL_FILTER_EXPRESSION_START_CHAR && !this.colName) {
            this.hasStartChar = true;
        }
        else if (char === exports.COL_FILTER_EXPRESSION_END_CHAR && this.hasStartChar) {
            const isMatch = this.parseColumn(false, position);
            if (isMatch) {
                this.hasEndChar = true;
                return false;
            }
            else {
                this.colName += char;
            }
        }
        else {
            this.colName += char;
        }
        return undefined;
    }
    getDisplayValue() {
        return ((this.hasStartChar ? exports.COL_FILTER_EXPRESSION_START_CHAR : '') +
            this.colName +
            (this.hasEndChar ? exports.COL_FILTER_EXPRESSION_END_CHAR : ''));
    }
    getColId() {
        return this.colId;
    }
    complete(position) {
        this.parseColumn(true, position);
    }
    getValidationError() {
        return this.valid
            ? null
            : {
                message: this.params.advFilterExpSvc.translate('advancedFilterValidationInvalidColumn'),
                startPosition: this.startPosition,
                endPosition: this.endPosition ?? this.params.expression.length - 1,
            };
    }
    parseColumn(fromComplete, endPosition) {
        this.endPosition = endPosition;
        const colValue = this.params.advFilterExpSvc.getColId(this.colName);
        if (colValue && this.hasStartChar) {
            this.colId = colValue.colId;
            (0, filterExpressionUtils_1.checkAndUpdateExpression)(this.params, this.colName, colValue.columnName, endPosition - 1);
            this.colName = colValue.columnName;
            this.column = this.params.colModel.getColDefCol(this.colId);
            if (this.column) {
                this.baseCellDataType = this.params.dataTypeSvc?.getBaseDataType(this.column) ?? 'text';
                return true;
            }
        }
        if (fromComplete) {
            this.valid = false;
        }
        this.baseCellDataType = 'text';
        return false;
    }
}
class OperatorParser {
    constructor(params, startPosition, baseCellDataType) {
        this.params = params;
        this.startPosition = startPosition;
        this.baseCellDataType = baseCellDataType;
        this.type = 'operator';
        this.valid = true;
        this.expectedNumOperands = 0;
        this.operator = '';
    }
    parse(char, position) {
        if (char === ' ' || char === ')') {
            const isMatch = this.parseOperator(false, position - 1);
            if (isMatch) {
                return true;
            }
            else {
                this.operator += char;
            }
        }
        else {
            this.operator += char;
        }
        return undefined;
    }
    complete(position) {
        this.parseOperator(true, position);
    }
    getValidationError() {
        return this.valid
            ? null
            : {
                message: this.params.advFilterExpSvc.translate('advancedFilterValidationInvalidOption'),
                startPosition: this.startPosition,
                endPosition: this.endPosition ?? this.params.expression.length - 1,
            };
    }
    getDisplayValue() {
        return this.operator;
    }
    getOperatorKey() {
        return this.parsedOperator;
    }
    parseOperator(fromComplete, endPosition) {
        const operatorForType = this.params.advFilterExpSvc.getDataTypeExpressionOperator(this.baseCellDataType);
        const parsedOperator = operatorForType.findOperator(this.operator);
        this.endPosition = endPosition;
        if (parsedOperator) {
            this.parsedOperator = parsedOperator;
            const operator = operatorForType.operators[parsedOperator];
            this.expectedNumOperands = operator.numOperands;
            const operatorDisplayValue = operator.displayValue;
            (0, filterExpressionUtils_1.checkAndUpdateExpression)(this.params, this.operator, operatorDisplayValue, endPosition);
            this.operator = operatorDisplayValue;
            return true;
        }
        const isPartialMatch = parsedOperator === null;
        if (fromComplete || !isPartialMatch) {
            this.valid = false;
        }
        return false;
    }
}
class OperandParser {
    constructor(params, startPosition, baseCellDataType, column) {
        this.params = params;
        this.startPosition = startPosition;
        this.baseCellDataType = baseCellDataType;
        this.column = column;
        this.type = 'operand';
        this.valid = true;
        this.operand = '';
        this.validationMessage = null;
    }
    parse(char, position) {
        if (char === ' ') {
            if (this.quotes) {
                this.operand += char;
            }
            else {
                this.parseOperand(false, position);
                return true;
            }
        }
        else if (char === ')') {
            if (this.baseCellDataType === 'number' || !this.quotes) {
                this.parseOperand(false, position - 1);
                return true;
            }
            else {
                this.operand += char;
            }
        }
        else if (!this.operand && !this.quotes && (char === `'` || char === `"`)) {
            this.quotes = char;
        }
        else if (this.quotes && char === this.quotes) {
            this.parseOperand(false, position);
            return false;
        }
        else {
            this.operand += char;
        }
        return undefined;
    }
    complete(position) {
        this.parseOperand(true, position);
    }
    getValidationError() {
        return this.validationMessage
            ? {
                message: this.validationMessage,
                startPosition: this.startPosition,
                endPosition: this.endPosition ?? this.params.expression.length - 1,
            }
            : null;
    }
    getRawValue() {
        return this.operand;
    }
    getModelValue() {
        return this.modelValue;
    }
    parseOperand(fromComplete, position) {
        const { advFilterExpSvc } = this.params;
        this.endPosition = position;
        this.modelValue = this.operand;
        if (fromComplete && this.quotes) {
            // missing end quote
            this.valid = false;
            this.validationMessage = advFilterExpSvc.translate('advancedFilterValidationMissingQuote');
        }
        else if (this.modelValue === '') {
            this.valid = false;
            this.validationMessage = advFilterExpSvc.translate('advancedFilterValidationMissingValue');
        }
        else {
            const modelValue = advFilterExpSvc.getOperandModelValue(this.operand, this.baseCellDataType, this.column);
            if (modelValue != null) {
                this.modelValue = modelValue;
            }
            switch (this.baseCellDataType) {
                case 'number':
                    if (this.quotes || isNaN(this.modelValue)) {
                        this.valid = false;
                        this.validationMessage = advFilterExpSvc.translate('advancedFilterValidationNotANumber');
                    }
                    break;
                case 'date':
                case 'dateString':
                    if (modelValue == null) {
                        this.valid = false;
                        this.validationMessage = advFilterExpSvc.translate('advancedFilterValidationInvalidDate');
                    }
                    break;
            }
        }
    }
}
exports.COL_FILTER_EXPRESSION_START_CHAR = '[';
exports.COL_FILTER_EXPRESSION_END_CHAR = ']';
class ColFilterExpressionParser {
    constructor(params, startPosition) {
        this.params = params;
        this.startPosition = startPosition;
        this.isAwaiting = true;
    }
    parseExpression() {
        let i = this.startPosition;
        const { expression } = this.params;
        while (i < expression.length) {
            const char = expression[i];
            if (char === ' ' && this.isAwaiting) {
                // ignore duplicate spaces
            }
            else {
                this.isAwaiting = false;
                if (!this.parser) {
                    let parser;
                    if (!this.columnParser) {
                        this.columnParser = new ColumnParser(this.params, i);
                        parser = this.columnParser;
                    }
                    else if (!this.operatorParser) {
                        this.operatorParser = new OperatorParser(this.params, i, this.columnParser.baseCellDataType);
                        parser = this.operatorParser;
                    }
                    else {
                        this.operandParser = new OperandParser(this.params, i, this.columnParser.baseCellDataType, this.columnParser.column);
                        parser = this.operandParser;
                    }
                    this.parser = parser;
                }
                const hasCompletedOnPrevChar = this.parser.parse(char, i);
                if (hasCompletedOnPrevChar != null) {
                    if (this.isComplete()) {
                        return this.returnEndPosition(hasCompletedOnPrevChar ? i - 1 : i, true);
                    }
                    this.parser = undefined;
                    this.isAwaiting = true;
                }
            }
            i++;
        }
        this.parser?.complete?.(i - 1);
        return this.returnEndPosition(i);
    }
    isValid() {
        return (this.isComplete() &&
            this.columnParser.valid &&
            this.operatorParser.valid &&
            (!this.operandParser || this.operandParser.valid));
    }
    getValidationError() {
        const validationError = this.columnParser?.getValidationError() ??
            this.operatorParser?.getValidationError() ??
            this.operandParser?.getValidationError();
        if (validationError) {
            return validationError;
        }
        const endPosition = this.params.expression.length;
        let translateKey;
        if (!this.columnParser) {
            translateKey = 'advancedFilterValidationMissingColumn';
        }
        else if (!this.operatorParser) {
            translateKey = 'advancedFilterValidationMissingOption';
        }
        else if (this.operatorParser.expectedNumOperands && !this.operandParser) {
            translateKey = 'advancedFilterValidationMissingValue';
        }
        if (translateKey) {
            return {
                message: this.params.advFilterExpSvc.translate(translateKey),
                startPosition: endPosition,
                endPosition,
            };
        }
        return null;
    }
    getFunctionString(params) {
        return this.getFunctionCommon(params, (operandIndex, operatorIndex, colId, evaluatorParamsIndex) => {
            const escapedColId = (0, filterExpressionUtils_1.escapeQuotes)(colId);
            const operand = operandIndex == null ? '' : `, params.operands[${operandIndex}]`;
            return `params.operators[${operatorIndex}].evaluator(expressionProxy.getValue('${escapedColId}', node), node, params.evaluatorParams[${evaluatorParamsIndex}]${operand})`;
        });
    }
    getFunctionParsed(params) {
        return this.getFunctionCommon(params, (operandIndex, operatorIndex, colId, evaluatorParamsIndex) => {
            return (expressionProxy, node, p) => p.operators[operatorIndex].evaluator(expressionProxy.getValue(colId, node), node, p.evaluatorParams[evaluatorParamsIndex], operandIndex == null ? undefined : p.operands[operandIndex]);
        });
    }
    getAutocompleteListParams(position) {
        if (this.isColumnPosition(position)) {
            return this.getColumnAutocompleteListParams(position);
        }
        if (this.isOperatorPosition(position)) {
            return this.getOperatorAutocompleteListParams(position);
        }
        if (this.isBeyondEndPosition(position)) {
            return undefined;
        }
        return { enabled: false };
    }
    updateExpression(position, updateEntry, type) {
        const { expression } = this.params;
        if (this.isColumnPosition(position)) {
            return (0, filterExpressionUtils_1.updateExpression)(this.params.expression, this.startPosition, this.columnParser?.getColId()
                ? this.columnParser.endPosition
                : (0, filterExpressionUtils_1.findEndPosition)(expression, position).endPosition, this.params.advFilterExpSvc.getColumnValue(updateEntry), true);
        }
        else if (this.isOperatorPosition(position)) {
            const baseCellDataType = this.getBaseCellDataTypeFromOperatorAutocompleteType(type);
            const hasOperand = this.hasOperand(baseCellDataType, updateEntry.key);
            const doesOperandNeedQuotes = hasOperand && this.doesOperandNeedQuotes(baseCellDataType);
            let update;
            if (this.operatorParser?.startPosition != null && position < this.operatorParser.startPosition) {
                // in between multiple spaces, just insert direct
                update = (0, filterExpressionUtils_1.updateExpression)(expression, position, position, updateEntry.displayValue ?? updateEntry.key, hasOperand, doesOperandNeedQuotes);
            }
            else {
                let endPosition;
                let empty = false;
                if (this.operatorParser?.getOperatorKey()) {
                    endPosition = this.operatorParser.endPosition;
                }
                else {
                    const { endPosition: calculatedEndPosition, isEmpty } = (0, filterExpressionUtils_1.findEndPosition)(expression, position, true, true);
                    endPosition = calculatedEndPosition;
                    empty = isEmpty;
                }
                update = (0, filterExpressionUtils_1.updateExpression)(expression, (0, filterExpressionUtils_1.findStartPosition)(expression, this.columnParser.endPosition + 1, endPosition), endPosition, updateEntry.displayValue ?? updateEntry.key, hasOperand, doesOperandNeedQuotes, empty);
            }
            return { ...update, hideAutocomplete: !hasOperand };
        }
        return null;
    }
    getModel() {
        const colId = this.columnParser.getColId();
        const model = {
            filterType: this.columnParser.baseCellDataType,
            colId,
            type: this.operatorParser.getOperatorKey(),
        };
        if (this.operatorParser.expectedNumOperands) {
            model.filter = this.operandParser.getModelValue();
        }
        return model;
    }
    getFunctionCommon(params, processFunc) {
        const colId = this.columnParser.getColId();
        const operator = this.operatorParser?.getOperatorKey();
        const { operators, evaluatorParams, operands } = params;
        const operatorForColumn = this.params.advFilterExpSvc.getExpressionOperator(this.columnParser.baseCellDataType, operator);
        const operatorIndex = this.addToListAndGetIndex(operators, operatorForColumn);
        const evaluatorParamsForColumn = this.params.advFilterExpSvc.getExpressionEvaluatorParams(colId);
        const evaluatorParamsIndex = this.addToListAndGetIndex(evaluatorParams, evaluatorParamsForColumn);
        const operandIndex = this.operatorParser?.expectedNumOperands === 0
            ? undefined
            : this.addToListAndGetIndex(operands, this.getOperandValue());
        return processFunc(operandIndex, operatorIndex, colId, evaluatorParamsIndex);
    }
    getOperandValue() {
        let operand = this.operandParser.getRawValue();
        const { baseCellDataType, column } = this.columnParser;
        switch (baseCellDataType) {
            case 'number':
                operand = Number(operand);
                break;
            case 'date':
            case 'dateString':
                operand = this.params.valueSvc.parseValue(column, null, operand, undefined);
                break;
        }
        if (baseCellDataType === 'dateString') {
            const { dataTypeSvc } = this.params;
            return dataTypeSvc ? dataTypeSvc.getDateParserFunction(column)(operand) : operand;
        }
        return operand;
    }
    isComplete() {
        return !!(this.operatorParser &&
            (!this.operatorParser.expectedNumOperands ||
                (this.operatorParser.expectedNumOperands && this.operandParser)));
    }
    isColumnPosition(position) {
        return (!this.columnParser || this.columnParser.endPosition == null || position <= this.columnParser.endPosition + 1);
    }
    isOperatorPosition(position) {
        return (!this.operatorParser ||
            this.operatorParser.endPosition == null ||
            position <= this.operatorParser.endPosition + 1);
    }
    isBeyondEndPosition(position) {
        return (this.isComplete() &&
            this.endPosition != null &&
            position > this.endPosition + 1 &&
            this.endPosition + 1 < this.params.expression.length);
    }
    returnEndPosition(returnPosition, treatAsEnd) {
        this.endPosition = treatAsEnd ? returnPosition : returnPosition - 1;
        return returnPosition;
    }
    getColumnAutocompleteListParams(position) {
        return this.params.advFilterExpSvc.generateAutocompleteListParams(this.params.advFilterExpSvc.getColumnAutocompleteEntries(), 'column', this.getColumnSearchString(position));
    }
    getColumnSearchString(position) {
        const columnName = this.columnParser?.getDisplayValue() ?? '';
        const searchString = (0, filterExpressionUtils_1.getSearchString)(columnName, position, this.columnParser?.endPosition == null ? this.params.expression.length : this.columnParser.endPosition + 1);
        const containsStartChar = this.columnParser?.hasStartChar && searchString.length > 0;
        const containsEndChar = this.columnParser?.hasEndChar && searchString.length === columnName.length + 2;
        if (containsStartChar) {
            return searchString.slice(1, containsEndChar ? -1 : undefined);
        }
        return searchString;
    }
    getOperatorAutocompleteListParams(position) {
        const column = this.columnParser?.column;
        if (!column) {
            return { enabled: false };
        }
        const baseCellDataType = this.columnParser.baseCellDataType;
        const searchString = this.operatorParser?.startPosition != null && position < this.operatorParser.startPosition
            ? ''
            : (0, filterExpressionUtils_1.getSearchString)(this.operatorParser?.getDisplayValue() ?? '', position, this.operatorParser?.endPosition == null
                ? this.params.expression.length
                : this.operatorParser.endPosition + 1);
        return this.params.advFilterExpSvc.generateAutocompleteListParams(this.params.advFilterExpSvc.getOperatorAutocompleteEntries(column, baseCellDataType), `operator-${baseCellDataType}`, searchString);
    }
    getBaseCellDataTypeFromOperatorAutocompleteType(type) {
        return type?.replace('operator-', '');
    }
    hasOperand(baseCellDataType, operator) {
        return (!baseCellDataType ||
            !operator ||
            (this.params.advFilterExpSvc.getExpressionOperator(baseCellDataType, operator)?.numOperands ?? 0) > 0);
    }
    doesOperandNeedQuotes(baseCellDataType) {
        return baseCellDataType !== 'number';
    }
    addToListAndGetIndex(list, value) {
        const index = list.length;
        list.push(value);
        return index;
    }
}
exports.ColFilterExpressionParser = ColFilterExpressionParser;


/***/ }),

/***/ 9459:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BooleanFilterExpressionOperators = exports.ScalarFilterExpressionOperators = exports.TextFilterExpressionOperators = exports.findMatch = void 0;
// null = partial match, undefined = no match
function findMatch(searchValue, values, getDisplayValue) {
    let partialMatch = false;
    const searchValueLowerCase = searchValue.toLocaleLowerCase();
    const partialSearchValue = searchValueLowerCase + ' ';
    const parsedValue = Object.keys(values).find((key) => {
        const value = values[key];
        const displayValueLowerCase = getDisplayValue(value).toLocaleLowerCase();
        if (displayValueLowerCase.startsWith(partialSearchValue)) {
            partialMatch = true;
        }
        return displayValueLowerCase === searchValueLowerCase;
    });
    if (parsedValue) {
        return parsedValue;
    }
    else if (partialMatch) {
        return null;
    }
    else {
        return undefined;
    }
}
exports.findMatch = findMatch;
function getEntries(operators, activeOperatorKeys) {
    const keys = activeOperatorKeys ?? Object.keys(operators);
    return keys.map((key) => ({
        key,
        displayValue: operators[key].displayValue,
    }));
}
class TextFilterExpressionOperators {
    constructor(params) {
        this.params = params;
        this.initOperators();
    }
    getEntries(activeOperators) {
        return getEntries(this.operators, activeOperators);
    }
    findOperator(displayValue) {
        return findMatch(displayValue, this.operators, ({ displayValue }) => displayValue);
    }
    initOperators() {
        const { translate } = this.params;
        this.operators = {
            contains: {
                displayValue: translate('advancedFilterContains'),
                evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v.includes(o)),
                numOperands: 1,
            },
            notContains: {
                displayValue: translate('advancedFilterNotContains'),
                evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, true, (v, o) => !v.includes(o)),
                numOperands: 1,
            },
            equals: {
                displayValue: translate('advancedFilterTextEquals'),
                evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v === o),
                numOperands: 1,
            },
            notEqual: {
                displayValue: translate('advancedFilterTextNotEqual'),
                evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, true, (v, o) => v != o),
                numOperands: 1,
            },
            startsWith: {
                displayValue: translate('advancedFilterStartsWith'),
                evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v.startsWith(o)),
                numOperands: 1,
            },
            endsWith: {
                displayValue: translate('advancedFilterEndsWith'),
                evaluator: (value, node, params, operand1) => this.evaluateExpression(value, node, params, operand1, false, (v, o) => v.endsWith(o)),
                numOperands: 1,
            },
            blank: {
                displayValue: translate('advancedFilterBlank'),
                evaluator: (value) => value == null || (typeof value === 'string' && value.trim().length === 0),
                numOperands: 0,
            },
            notBlank: {
                displayValue: translate('advancedFilterNotBlank'),
                evaluator: (value) => value != null && (typeof value !== 'string' || value.trim().length > 0),
                numOperands: 0,
            },
        };
    }
    evaluateExpression(value, node, params, operand, nullsMatch, expression) {
        if (value == null) {
            return nullsMatch;
        }
        return params.caseSensitive
            ? expression(params.valueConverter(value, node), operand)
            : expression(params.valueConverter(value, node).toLocaleLowerCase(), operand.toLocaleLowerCase());
    }
}
exports.TextFilterExpressionOperators = TextFilterExpressionOperators;
class ScalarFilterExpressionOperators {
    constructor(params) {
        this.params = params;
        this.initOperators();
    }
    getEntries(activeOperators) {
        return getEntries(this.operators, activeOperators);
    }
    findOperator(displayValue) {
        return findMatch(displayValue, this.operators, ({ displayValue }) => displayValue);
    }
    initOperators() {
        const { translate, equals } = this.params;
        this.operators = {
            equals: {
                displayValue: translate('advancedFilterEquals'),
                evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(value, node, params, operand1, !!params.includeBlanksInEquals, equals),
                numOperands: 1,
            },
            notEqual: {
                displayValue: translate('advancedFilterNotEqual'),
                evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(value, node, params, operand1, !!params.includeBlanksInEquals, (v, o) => !equals(v, o)),
                numOperands: 1,
            },
            greaterThan: {
                displayValue: translate('advancedFilterGreaterThan'),
                evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(value, node, params, operand1, !!params.includeBlanksInGreaterThan, (v, o) => v > o),
                numOperands: 1,
            },
            greaterThanOrEqual: {
                displayValue: translate('advancedFilterGreaterThanOrEqual'),
                evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(value, node, params, operand1, !!params.includeBlanksInGreaterThan, (v, o) => v >= o),
                numOperands: 1,
            },
            lessThan: {
                displayValue: translate('advancedFilterLessThan'),
                evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(value, node, params, operand1, !!params.includeBlanksInLessThan, (v, o) => v < o),
                numOperands: 1,
            },
            lessThanOrEqual: {
                displayValue: translate('advancedFilterLessThanOrEqual'),
                evaluator: (value, node, params, operand1) => this.evaluateSingleOperandExpression(value, node, params, operand1, !!params.includeBlanksInLessThan, (v, o) => v <= o),
                numOperands: 1,
            },
            blank: {
                displayValue: translate('advancedFilterBlank'),
                evaluator: (value) => value == null,
                numOperands: 0,
            },
            notBlank: {
                displayValue: translate('advancedFilterNotBlank'),
                evaluator: (value) => value != null,
                numOperands: 0,
            },
        };
    }
    evaluateSingleOperandExpression(value, node, params, operand, nullsMatch, expression) {
        if (value == null) {
            return nullsMatch;
        }
        return expression(params.valueConverter(value, node), operand);
    }
}
exports.ScalarFilterExpressionOperators = ScalarFilterExpressionOperators;
class BooleanFilterExpressionOperators {
    constructor(params) {
        this.params = params;
        this.initOperators();
    }
    getEntries(activeOperators) {
        return getEntries(this.operators, activeOperators);
    }
    findOperator(displayValue) {
        return findMatch(displayValue, this.operators, ({ displayValue }) => displayValue);
    }
    initOperators() {
        const { translate } = this.params;
        this.operators = {
            true: {
                displayValue: translate('advancedFilterTrue'),
                evaluator: (value) => !!value,
                numOperands: 0,
            },
            false: {
                displayValue: translate('advancedFilterFalse'),
                evaluator: (value) => value === false,
                numOperands: 0,
            },
            blank: {
                displayValue: translate('advancedFilterBlank'),
                evaluator: (value) => value == null,
                numOperands: 0,
            },
            notBlank: {
                displayValue: translate('advancedFilterNotBlank'),
                evaluator: (value) => value != null,
                numOperands: 0,
            },
        };
    }
}
exports.BooleanFilterExpressionOperators = BooleanFilterExpressionOperators;


/***/ }),

/***/ 4899:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterExpressionParser = void 0;
const joinFilterExpressionParser_1 = __webpack_require__(9471);
class FilterExpressionParser {
    constructor(params) {
        this.params = params;
        this.valid = false;
    }
    parseExpression() {
        this.joinExpressionParser = new joinFilterExpressionParser_1.JoinFilterExpressionParser(this.params, 0);
        const i = this.joinExpressionParser.parseExpression();
        this.valid = i >= this.params.expression.length - 1 && this.joinExpressionParser.isValid();
        return this.params.expression;
    }
    isValid() {
        return this.valid;
    }
    getValidationMessage() {
        const error = this.joinExpressionParser.getValidationError();
        if (!error) {
            return null;
        }
        const { message, startPosition, endPosition } = error;
        return startPosition < this.params.expression.length
            ? this.params.advFilterExpSvc.translate('advancedFilterValidationMessage', [
                message,
                this.params.expression.slice(startPosition, endPosition + 1).trim(),
            ])
            : this.params.advFilterExpSvc.translate('advancedFilterValidationMessageAtEnd', [message]);
    }
    getFunctionString() {
        const params = this.createFunctionParams();
        return {
            functionString: `return ${this.joinExpressionParser.getFunctionString(params)};`,
            params,
        };
    }
    getFunctionParsed() {
        const params = this.createFunctionParams();
        return {
            expressionFunction: this.joinExpressionParser.getFunctionParsed(params),
            params,
        };
    }
    getAutocompleteListParams(position) {
        return this.joinExpressionParser.getAutocompleteListParams(position) ?? { enabled: false };
    }
    updateExpression(position, updateEntry, type) {
        return this.joinExpressionParser.updateExpression(position, updateEntry, type);
    }
    getModel() {
        return this.isValid() ? this.joinExpressionParser.getModel() : null;
    }
    createFunctionParams() {
        return {
            operands: [],
            operators: [],
            evaluatorParams: [],
        };
    }
}
exports.FilterExpressionParser = FilterExpressionParser;


/***/ }),

/***/ 6487:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.escapeQuotes = exports.checkAndUpdateExpression = exports.findEndPosition = exports.findStartPosition = exports.updateExpression = exports.getSearchString = void 0;
function getSearchString(value, position, endPosition) {
    if (!value) {
        return '';
    }
    const numChars = endPosition - position;
    return numChars ? value.slice(0, value.length - numChars) : value;
}
exports.getSearchString = getSearchString;
function updateExpression(expression, startPosition, endPosition, updatedValuePart, appendSpace, appendQuote, empty) {
    const secondPartStartPosition = endPosition + (!expression.length || empty ? 0 : 1);
    let positionOffset = 0;
    if (appendSpace) {
        if (expression[secondPartStartPosition] === ' ') {
            // already a space, just move the position
            positionOffset = 1;
        }
        else {
            updatedValuePart += ' ';
            if (appendQuote) {
                updatedValuePart += `"`;
            }
        }
    }
    const updatedValue = expression.slice(0, startPosition) + updatedValuePart + expression.slice(secondPartStartPosition);
    return { updatedValue, updatedPosition: startPosition + updatedValuePart.length + positionOffset };
}
exports.updateExpression = updateExpression;
function findStartPosition(expression, position, endPosition) {
    let startPosition = position;
    while (startPosition < endPosition) {
        const char = expression[startPosition];
        if (char !== ' ') {
            break;
        }
        startPosition++;
    }
    return startPosition;
}
exports.findStartPosition = findStartPosition;
function findEndPosition(expression, position, includeCloseBracket, isStartPositionUnknown) {
    let endPosition = position;
    let isEmpty = false;
    while (endPosition < expression.length) {
        const char = expression[endPosition];
        if (char === '(') {
            if (isStartPositionUnknown && expression[endPosition - 1] === ' ') {
                isEmpty = true;
            }
            else {
                endPosition = endPosition - 1;
            }
            break;
        }
        else if (char === ' ' || (includeCloseBracket && char === ')')) {
            endPosition = endPosition - 1;
            break;
        }
        endPosition++;
    }
    return { endPosition, isEmpty };
}
exports.findEndPosition = findEndPosition;
function checkAndUpdateExpression(params, userValue, displayValue, endPosition) {
    if (displayValue !== userValue) {
        params.expression = updateExpression(params.expression, endPosition - userValue.length + 1, endPosition, displayValue).updatedValue;
    }
}
exports.checkAndUpdateExpression = checkAndUpdateExpression;
function escapeQuotes(value) {
    return value.replace(/(['"])/, '\\$1');
}
exports.escapeQuotes = escapeQuotes;


/***/ }),

/***/ 9471:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.JoinFilterExpressionParser = void 0;
const colFilterExpressionParser_1 = __webpack_require__(9023);
const filterExpressionOperators_1 = __webpack_require__(9459);
const filterExpressionUtils_1 = __webpack_require__(6487);
class OperatorParser {
    constructor(params) {
        this.params = params;
        this.operators = [];
        this.operatorStartPositions = [];
        this.operatorEndPositions = [];
        this.activeOperator = 0;
        this.validationError = null;
    }
    parseExpression(i) {
        this.operators.push('');
        this.operatorStartPositions.push(i);
        this.operatorEndPositions.push(undefined);
        const { expression } = this.params;
        while (i < expression.length) {
            const char = expression[i];
            if (char === ' ') {
                const isComplete = this.parseOperator(i - 1);
                if (isComplete) {
                    this.activeOperator++;
                    return i - 1;
                }
                else {
                    this.operators[this.activeOperator] += char;
                }
            }
            else {
                this.operators[this.activeOperator] += char;
            }
            i++;
        }
        this.parseOperator(i - 1);
        return i;
    }
    isValid() {
        return !this.validationError && (!this.operators.length || !!this.parsedOperator);
    }
    getValidationError() {
        return this.validationError;
    }
    getFunction() {
        return this.parsedOperator === 'OR' ? '||' : '&&';
    }
    getModel() {
        return this.parsedOperator === 'OR' ? 'OR' : 'AND';
    }
    getAutocompleteListParams(position, operatorIndex) {
        let searchString;
        if (operatorIndex == null) {
            searchString = '';
        }
        else {
            const operator = this.operators[operatorIndex];
            const operatorEndPosition = this.operatorEndPositions[operatorIndex];
            searchString = (0, filterExpressionUtils_1.getSearchString)(operator, position, operatorEndPosition == null ? this.params.expression.length : operatorEndPosition + 1);
        }
        let entries = this.params.advFilterExpSvc.getJoinOperatorAutocompleteEntries();
        if (operatorIndex || (operatorIndex == null && this.activeOperator)) {
            // if operator already chosen, don't allow other operators
            entries = entries.filter(({ key }) => key === this.parsedOperator);
        }
        return this.params.advFilterExpSvc.generateAutocompleteListParams(entries, 'join', searchString);
    }
    updateExpression(position, updateEntry, operatorIndex) {
        let { expression } = this.params;
        const updatedValuePart = updateEntry.displayValue ?? updateEntry.key;
        if (operatorIndex === 0) {
            // need to update all others
            for (let i = this.operatorEndPositions.length - 1; i > 0; i--) {
                const operatorEndPosition = this.operatorEndPositions[i];
                if (operatorEndPosition == null) {
                    continue;
                }
                expression = (0, filterExpressionUtils_1.updateExpression)(expression, this.operatorStartPositions[i], operatorEndPosition, updatedValuePart).updatedValue;
            }
        }
        // if we don't have a start position, haven't typed anything yet, so use current position
        const startPosition = this.operatorStartPositions.length > operatorIndex ? this.operatorStartPositions[operatorIndex] : position;
        const endPosition = (this.operatorEndPositions.length > operatorIndex ? this.operatorEndPositions[operatorIndex] : undefined) ??
            (0, filterExpressionUtils_1.findEndPosition)(expression, position, true).endPosition;
        return (0, filterExpressionUtils_1.updateExpression)(expression, startPosition, endPosition, updatedValuePart, true);
    }
    getNumOperators() {
        return this.operators.length;
    }
    getLastOperatorEndPosition() {
        return this.operatorEndPositions[this.operatorEndPositions.length - 1];
    }
    parseOperator(endPosition) {
        const operator = this.operators.length > this.activeOperator ? this.operators[this.activeOperator] : '';
        const joinOperators = this.params.advFilterExpSvc.getExpressionJoinOperators();
        const parsedValue = (0, filterExpressionOperators_1.findMatch)(operator, joinOperators, (v) => v);
        if (parsedValue) {
            // exact match
            this.operatorEndPositions[this.activeOperator] = endPosition;
            const displayValue = joinOperators[parsedValue];
            if (this.activeOperator) {
                if (parsedValue !== this.parsedOperator) {
                    if (!this.validationError) {
                        this.validationError = {
                            message: this.params.advFilterExpSvc.translate('advancedFilterValidationJoinOperatorMismatch'),
                            startPosition: endPosition - operator.length + 1,
                            endPosition,
                        };
                    }
                    return false;
                }
            }
            else {
                this.parsedOperator = parsedValue;
            }
            if (operator !== displayValue) {
                (0, filterExpressionUtils_1.checkAndUpdateExpression)(this.params, operator, displayValue, endPosition);
                this.operators[this.activeOperator] = displayValue;
            }
            return true;
        }
        else if (parsedValue === null) {
            // partial match
            return false;
        }
        else {
            // no match
            if (!this.validationError) {
                this.validationError = {
                    message: this.params.advFilterExpSvc.translate('advancedFilterValidationInvalidJoinOperator'),
                    startPosition: endPosition - operator.length + 1,
                    endPosition,
                };
            }
            return true;
        }
    }
}
class JoinFilterExpressionParser {
    constructor(params, startPosition) {
        this.params = params;
        this.startPosition = startPosition;
        this.expectingExpression = true;
        this.expectingOperator = false;
        this.expressionParsers = [];
        this.operatorParser = new OperatorParser(this.params);
        this.missingEndBracket = false;
        this.extraEndBracket = false;
    }
    parseExpression() {
        let i = this.startPosition;
        const { expression } = this.params;
        while (i < expression.length) {
            const char = expression[i];
            if (char === '(' && !this.expectingOperator) {
                const nestedParser = new JoinFilterExpressionParser(this.params, i + 1);
                i = nestedParser.parseExpression();
                this.expressionParsers.push(nestedParser);
                this.expectingExpression = false;
                this.expectingOperator = true;
            }
            else if (char === ')') {
                this.endPosition = i - 1;
                if (this.startPosition === 0) {
                    this.extraEndBracket = true;
                }
                return i;
            }
            else if (char === ' ') {
                // ignore extra whitespace
            }
            else if (this.expectingExpression) {
                const nestedParser = new colFilterExpressionParser_1.ColFilterExpressionParser(this.params, i);
                i = nestedParser.parseExpression();
                this.expressionParsers.push(nestedParser);
                this.expectingExpression = false;
                this.expectingOperator = true;
            }
            else if (this.expectingOperator) {
                i = this.operatorParser.parseExpression(i);
                this.expectingOperator = false;
                this.expectingExpression = true;
            }
            i++;
        }
        if (this.startPosition > 0) {
            this.missingEndBracket = true;
        }
        return i;
    }
    isValid() {
        return (!this.missingEndBracket &&
            !this.extraEndBracket &&
            this.expressionParsers.length === this.operatorParser.getNumOperators() + 1 &&
            this.operatorParser.isValid() &&
            this.expressionParsers.every((expressionParser) => expressionParser.isValid()));
    }
    getValidationError() {
        const operatorError = this.operatorParser.getValidationError();
        for (let i = 0; i < this.expressionParsers.length; i++) {
            const expressionError = this.expressionParsers[i].getValidationError();
            if (expressionError) {
                return operatorError && operatorError.startPosition < expressionError.startPosition
                    ? operatorError
                    : expressionError;
            }
        }
        if (operatorError) {
            return operatorError;
        }
        if (this.extraEndBracket) {
            return {
                message: this.params.advFilterExpSvc.translate('advancedFilterValidationExtraEndBracket'),
                startPosition: this.endPosition + 1,
                endPosition: this.endPosition + 1,
            };
        }
        let translateKey;
        if (this.expressionParsers.length === this.operatorParser.getNumOperators()) {
            translateKey = 'advancedFilterValidationMissingCondition';
        }
        else if (this.missingEndBracket) {
            translateKey = 'advancedFilterValidationMissingEndBracket';
        }
        if (translateKey) {
            return {
                message: this.params.advFilterExpSvc.translate(translateKey),
                startPosition: this.params.expression.length,
                endPosition: this.params.expression.length,
            };
        }
        return null;
    }
    getFunctionString(params) {
        const hasMultipleExpressions = this.expressionParsers.length > 1;
        const expression = this.expressionParsers
            .map((expressionParser) => expressionParser.getFunctionString(params))
            .join(` ${this.operatorParser.getFunction()} `);
        return hasMultipleExpressions ? `(${expression})` : expression;
    }
    getFunctionParsed(params) {
        const operator = this.operatorParser.getFunction();
        const funcs = this.expressionParsers.map((expressionParser) => expressionParser.getFunctionParsed(params));
        const arrayFunc = operator === '&&' ? 'every' : 'some';
        return (expressionProxy, node, p) => funcs[arrayFunc]((func) => func(expressionProxy, node, p));
    }
    getAutocompleteListParams(position) {
        if (this.endPosition != null && position > this.endPosition + 1) {
            return undefined;
        }
        if (!this.expressionParsers.length) {
            return this.getColumnAutocompleteListParams();
        }
        const expressionParserIndex = this.getExpressionParserIndex(position);
        if (expressionParserIndex == null) {
            if (this.params.expression[position] === '(') {
                return { enabled: false };
            }
            // positioned before the expression, so new expression
            return this.getColumnAutocompleteListParams();
        }
        const expressionParser = this.expressionParsers[expressionParserIndex];
        const autocompleteType = expressionParser.getAutocompleteListParams(position);
        if (!autocompleteType) {
            // beyond the end of the expression
            if (expressionParserIndex < this.expressionParsers.length - 1) {
                // in the middle of two expressions
                return this.operatorParser.getAutocompleteListParams(position, expressionParserIndex);
            }
            if (this.expressionParsers.length === this.operatorParser.getNumOperators()) {
                const operatorEndPosition = this.operatorParser.getLastOperatorEndPosition();
                return operatorEndPosition == null || position <= operatorEndPosition + 1
                    ? this.operatorParser.getAutocompleteListParams(position, this.operatorParser.getNumOperators() - 1)
                    : this.getColumnAutocompleteListParams();
            }
            if (this.params.expression[position - 1] === ')') {
                return { enabled: false };
            }
            return this.operatorParser.getAutocompleteListParams(position);
        }
        return autocompleteType;
    }
    updateExpression(position, updateEntry, type) {
        const expression = this.params.expression;
        const expressionParserIndex = this.getExpressionParserIndex(position);
        if (expressionParserIndex == null) {
            // positioned before the expression
            const updatedValuePart = type === 'column'
                ? this.params.advFilterExpSvc.getColumnValue(updateEntry)
                : updateEntry.displayValue ?? updateEntry.key;
            return (0, filterExpressionUtils_1.updateExpression)(expression, this.startPosition, this.startPosition, updatedValuePart, true);
        }
        const expressionParser = this.expressionParsers[expressionParserIndex];
        const updatedExpression = expressionParser.updateExpression(position, updateEntry, type);
        if (updatedExpression == null) {
            if (type === 'column') {
                // beyond the end of the expression, just do simple update
                return (0, filterExpressionUtils_1.updateExpression)(expression, position, expression.length - 1, this.params.advFilterExpSvc.getColumnValue(updateEntry), true);
            }
            else if (this.endPosition != null && position > this.endPosition + 1) {
                return null;
            }
            else {
                return this.operatorParser.updateExpression(position, updateEntry, expressionParserIndex);
            }
        }
        return updatedExpression;
    }
    getModel() {
        if (this.expressionParsers.length > 1) {
            return {
                filterType: 'join',
                type: this.operatorParser.getModel(),
                conditions: this.expressionParsers.map((parser) => parser.getModel()),
            };
        }
        else {
            return this.expressionParsers[0].getModel();
        }
    }
    getColumnAutocompleteListParams() {
        return this.params.advFilterExpSvc.generateAutocompleteListParams(this.params.advFilterExpSvc.getColumnAutocompleteEntries(), 'column', '');
    }
    getExpressionParserIndex(position) {
        let expressionParserIndex;
        for (let i = 0; i < this.expressionParsers.length; i++) {
            const expressionParserToCheck = this.expressionParsers[i];
            if (expressionParserToCheck.startPosition > position) {
                break;
            }
            expressionParserIndex = i;
        }
        return expressionParserIndex;
    }
}
exports.JoinFilterExpressionParser = JoinFilterExpressionParser;


/***/ }),

/***/ 9206:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnterpriseCoreModule = exports.AgWatermark = void 0;
const gridLicenseManager_1 = __webpack_require__(3159);
const version_1 = __webpack_require__(7205);
var watermark_1 = __webpack_require__(3879);
Object.defineProperty(exports, "AgWatermark", ({ enumerable: true, get: function () { return watermark_1.AgWatermark; } }));
/**
 * @internal
 */
exports.EnterpriseCoreModule = {
    moduleName: 'EnterpriseCore',
    version: version_1.VERSION,
    beans: [gridLicenseManager_1.GridLicenseManager],
    icons: {
        // accordion open (filter tool panel group, charts group)
        accordionOpen: 'tree-open',
        // accordion closed (filter tool panel group, charts group)
        accordionClosed: 'tree-closed',
        // accordion indeterminate - shown when some children are expanded and
        //     others are collapsed (filter tool panel group, charts group)
        accordionIndeterminate: 'tree-indeterminate',
        // dialog title bar
        close: 'cross',
        // X (remove) on column 'pill' after adding it to a drop zone list
        cancel: 'cancel',
        // button in chart regular size window title bar (click to maximise)
        maximize: 'maximize',
        // button in chart maximised window title bar (click to make regular size)
        minimize: 'minimize',
        // drag handle used to pick up draggable columns
        columnDrag: 'grip',
    },
    dependsOn: [],
};


/***/ }),

/***/ 2529:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AggColumnNameService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AggColumnNameService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'aggColNameSvc';
    }
    getHeaderName(column, headerName) {
        if (this.gos.get('suppressAggFuncInHeader')) {
            return headerName;
        }
        const { valueColsSvc, colModel, rowGroupColsSvc } = this.beans;
        // only columns with aggregation active can have aggregations
        const pivotValueColumn = column.getColDef().pivotValueColumn;
        const pivotActiveOnThisColumn = (0, ag_grid_community_1._exists)(pivotValueColumn);
        let aggFunc = null;
        let aggFuncFound;
        // otherwise we have a measure that is active, and we are doing aggregation on it
        if (pivotActiveOnThisColumn) {
            const valueColumns = valueColsSvc?.columns ?? [];
            const isCollapsedHeaderEnabled = this.gos.get('removePivotHeaderRowWhenSingleValueColumn') && valueColumns.length === 1;
            const isTotalColumn = column.getColDef().pivotTotalColumnIds !== undefined;
            if (isCollapsedHeaderEnabled && !isTotalColumn) {
                return headerName; // Skip decorating the header - in this case the label is the pivot key, not the value col
            }
            aggFunc = pivotValueColumn ? pivotValueColumn.getAggFunc() : null;
            aggFuncFound = true;
        }
        else {
            const measureActive = column.isValueActive();
            const aggregationPresent = colModel.isPivotMode() || rowGroupColsSvc?.columns.length !== 0;
            if (measureActive && aggregationPresent) {
                aggFunc = column.getAggFunc();
                aggFuncFound = true;
            }
            else {
                aggFuncFound = false;
            }
        }
        if (aggFuncFound) {
            const aggFuncString = typeof aggFunc === 'string' ? aggFunc : 'func';
            const localeTextFunc = this.getLocaleTextFunc();
            const aggFuncStringTranslated = localeTextFunc(aggFuncString, aggFuncString);
            return `${aggFuncStringTranslated}(${headerName})`;
        }
        return headerName;
    }
}
exports.AggColumnNameService = AggColumnNameService;


/***/ }),

/***/ 5780:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AggFuncService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const defaultAggFuncNames = {
    sum: 'Sum',
    first: 'First',
    last: 'Last',
    min: 'Min',
    max: 'Max',
    count: 'Count',
    avg: 'Average',
};
class AggFuncService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'aggFuncSvc';
        this.aggFuncsMap = {};
        this.initialised = false;
    }
    postConstruct() {
        this.init();
    }
    init() {
        if (this.initialised) {
            return;
        }
        this.initialiseWithDefaultAggregations();
        this.addAggFuncs(this.gos.get('aggFuncs'));
    }
    initialiseWithDefaultAggregations() {
        const aggMap = this.aggFuncsMap;
        aggMap['sum'] = aggSum;
        aggMap['first'] = aggFirst;
        aggMap['last'] = aggLast;
        aggMap['min'] = aggMin;
        aggMap['max'] = aggMax;
        aggMap['count'] = aggCount;
        aggMap['avg'] = aggAvg;
        this.initialised = true;
    }
    isAggFuncPossible(column, func) {
        const allKeys = this.getFuncNames(column);
        const allowed = allKeys.includes(func);
        const funcExists = (0, ag_grid_community_1._exists)(this.aggFuncsMap[func]);
        return allowed && funcExists;
    }
    getDefaultFuncLabel(fctName) {
        return defaultAggFuncNames[fctName] ?? fctName;
    }
    getDefaultAggFunc(column) {
        const defaultAgg = column.getColDef().defaultAggFunc;
        if ((0, ag_grid_community_1._exists)(defaultAgg) && this.isAggFuncPossible(column, defaultAgg)) {
            return defaultAgg;
        }
        if (this.isAggFuncPossible(column, 'sum')) {
            return 'sum';
        }
        const allKeys = this.getFuncNames(column);
        return allKeys?.length ? allKeys[0] : null;
    }
    addAggFuncs(aggFuncs) {
        this.init();
        if (!aggFuncs) {
            return;
        }
        for (const key of Object.keys(aggFuncs)) {
            this.aggFuncsMap[key] = aggFuncs[key];
        }
    }
    getAggFunc(name) {
        this.init();
        return this.aggFuncsMap[name];
    }
    getFuncNames(column) {
        const userAllowedFuncs = column.getColDef().allowedAggFuncs;
        return userAllowedFuncs == null ? Object.keys(this.aggFuncsMap).sort() : userAllowedFuncs;
    }
    clear() {
        this.aggFuncsMap = {};
    }
}
exports.AggFuncService = AggFuncService;
function aggSum(params) {
    const { values } = params;
    let result = null; // the logic ensures that we never combine bigint arithmetic with numbers, but TS is hard to please
    // for optimum performance, we use a for loop here rather than calling any helper methods or using functional code
    for (let i = 0; i < values.length; i++) {
        const value = values[i];
        if (typeof value === 'number') {
            if (result === null) {
                result = value;
            }
            else {
                result += typeof result === 'number' ? value : BigInt(value);
            }
        }
        else if (typeof value === 'bigint') {
            if (result === null) {
                result = value;
            }
            else {
                result = (typeof result === 'bigint' ? result : BigInt(result)) + value;
            }
        }
    }
    return result;
}
function aggFirst(params) {
    return params.values.length > 0 ? params.values[0] : null;
}
function aggLast(params) {
    return params.values.length > 0 ? (0, ag_grid_community_1._last)(params.values) : null;
}
function aggMin(params) {
    const { values } = params;
    let result = null;
    // for optimum performance, we use a for loop here rather than calling any helper methods or using functional code
    for (let i = 0; i < values.length; i++) {
        const value = values[i];
        if ((typeof value === 'number' || typeof value === 'bigint') && (result === null || result > value)) {
            result = value;
        }
    }
    return result;
}
function aggMax(params) {
    const { values } = params;
    let result = null;
    // for optimum performance, we use a for loop here rather than calling any helper methods or using functional code
    for (let i = 0; i < values.length; i++) {
        const value = values[i];
        if ((typeof value === 'number' || typeof value === 'bigint') && (result === null || result < value)) {
            result = value;
        }
    }
    return result;
}
function aggCount(params) {
    const { values } = params;
    let result = 0;
    // for optimum performance, we use a for loop here rather than calling any helper methods or using functional code
    for (let i = 0; i < values.length; i++) {
        const value = values[i];
        // check if the value is from a group, in which case use the group's count
        result += value != null && typeof value.value === 'number' ? value.value : 1;
    }
    // the previous aggregation data
    const existingAggData = params.rowNode?.aggData?.[params.column.getColId()];
    if (existingAggData && existingAggData.value === result) {
        // the underlying values haven't changed, return the old object to avoid triggering change detection
        return existingAggData;
    }
    // it's important to wrap it in the object so we can determine if this is a group level
    return {
        value: result,
        toString: function () {
            return this.value.toString();
        },
        // used for sorting
        toNumber: function () {
            return this.value;
        },
    };
}
// the average function is tricky as the multiple levels require weighted averages
// for the non-leaf node aggregations.
function aggAvg(params) {
    const { values } = params;
    let sum = 0; // the logic ensures that we never combine bigint arithmetic with numbers, but TS is hard to please
    let count = 0;
    // for optimum performance, we use a for loop here rather than calling any helper methods or using functional code
    for (let i = 0; i < values.length; i++) {
        const currentValue = values[i];
        let valueToAdd = null;
        if (typeof currentValue === 'number' || typeof currentValue === 'bigint') {
            valueToAdd = currentValue;
            count++;
        }
        else if (currentValue != null &&
            (typeof currentValue.value === 'number' || typeof currentValue.value === 'bigint') &&
            typeof currentValue.count === 'number') {
            // we are aggregating groups, so we take the aggregated values to calculated a weighted average
            valueToAdd =
                currentValue.value *
                    (typeof currentValue.value === 'number' ? currentValue.count : BigInt(currentValue.count));
            count += currentValue.count;
        }
        if (typeof valueToAdd === 'number') {
            sum += typeof sum === 'number' ? valueToAdd : BigInt(valueToAdd);
        }
        else if (typeof valueToAdd === 'bigint') {
            sum = (typeof sum === 'bigint' ? sum : BigInt(sum)) + valueToAdd;
        }
    }
    let value = null;
    // avoid divide by zero error
    if (count > 0) {
        value = sum / (typeof sum === 'number' ? count : BigInt(count));
    }
    // the previous aggregation data
    const existingAggData = params.rowNode?.aggData?.[params.column?.getColId()];
    if (existingAggData && existingAggData.count === count && existingAggData.value === value) {
        // the underlying values haven't changed, return the old object to avoid triggering change detection
        return existingAggData;
    }
    // the result will be an object. when this cell is rendered, only the avg is shown.
    // however when this cell is part of another aggregation, the count is also needed
    // to create a weighted average for the next level.
    return {
        count,
        value,
        // the grid by default uses toString to render values for an object, so this
        // is a trick to get the default cellRenderer to display the avg value
        toString: function () {
            return typeof this.value === 'number' || typeof this.value === 'bigint' ? this.value.toString() : '';
        },
        // used for sorting
        toNumber: function () {
            return this.value;
        },
    };
}


/***/ }),

/***/ 1872:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.setColumnAggFunc = exports.clearAggFuncs = exports.addAggFuncs = void 0;
function addAggFuncs(beans, aggFuncs) {
    if (beans.aggFuncSvc) {
        beans.aggFuncSvc.addAggFuncs(aggFuncs);
    }
}
exports.addAggFuncs = addAggFuncs;
function clearAggFuncs(beans) {
    if (beans.aggFuncSvc) {
        beans.aggFuncSvc.clear();
    }
}
exports.clearAggFuncs = clearAggFuncs;
function setColumnAggFunc(beans, key, aggFunc) {
    beans.valueColsSvc?.setColumnAggFunc?.(key, aggFunc, 'api');
}
exports.setColumnAggFunc = setColumnAggFunc;


/***/ }),

/***/ 7032:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AggregationModule = exports.SharedAggregationModule = void 0;
const agGridEnterpriseModule_1 = __webpack_require__(9206);
const version_1 = __webpack_require__(7205);
const aggColumnNameService_1 = __webpack_require__(2529);
const aggFuncService_1 = __webpack_require__(5780);
const aggregationApi_1 = __webpack_require__(1872);
const aggregationStage_1 = __webpack_require__(3438);
const filterAggregatesStage_1 = __webpack_require__(6948);
const footerService_1 = __webpack_require__(182);
const valueColsSvc_1 = __webpack_require__(7926);
/**
 * @internal
 */
exports.SharedAggregationModule = {
    moduleName: 'SharedAggregation',
    version: version_1.VERSION,
    beans: [aggFuncService_1.AggFuncService, aggColumnNameService_1.AggColumnNameService, footerService_1.FooterService, valueColsSvc_1.ValueColsSvc],
    apiFunctions: {
        addAggFuncs: aggregationApi_1.addAggFuncs,
        clearAggFuncs: aggregationApi_1.clearAggFuncs,
        setColumnAggFunc: aggregationApi_1.setColumnAggFunc,
    },
    dependsOn: [agGridEnterpriseModule_1.EnterpriseCoreModule],
};
/**
 * @internal
 */
exports.AggregationModule = {
    moduleName: 'Aggregation',
    version: version_1.VERSION,
    beans: [aggregationStage_1.AggregationStage, filterAggregatesStage_1.FilterAggregatesStage],
    rowModels: ['clientSide'],
    dependsOn: [exports.SharedAggregationModule],
};


/***/ }),

/***/ 3438:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AggregationStage = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AggregationStage extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'aggStage';
        this.refreshProps = new Set([
            'getGroupRowAgg',
            'alwaysAggregateAtRootLevel',
            'suppressAggFilteredOnly',
            'grandTotalRow',
        ]);
        this.step = 'aggregate';
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.aggFuncSvc = beans.aggFuncSvc;
        this.pivotColsSvc = beans.pivotColsSvc;
        this.valueColsSvc = beans.valueColsSvc;
        this.pivotResultCols = beans.pivotResultCols;
        this.valueSvc = beans.valueSvc;
    }
    // it's possible to recompute the aggregate without doing the other parts
    // + api.refreshClientSideRowModel('aggregate')
    execute(params) {
        // if changed path is active, it means we came from a) change detection or b) transaction update.
        // for both of these, if no value columns are present, it means there is nothing to aggregate now
        // and there is no cleanup to be done (as value columns don't change between transactions or change
        // detections). if no value columns and no changed path, means we have to go through all nodes in
        // case we need to clean up agg data from before.
        const noValueColumns = !this.valueColsSvc?.columns?.length;
        const noUserAgg = !this.gos.getCallback('getGroupRowAgg');
        if (noValueColumns && noUserAgg && params.changedPath?.active) {
            return;
        }
        const aggDetails = this.createAggDetails(params);
        this.recursivelyCreateAggData(aggDetails);
    }
    createAggDetails(params) {
        const pivotActive = this.colModel.isPivotActive();
        const measureColumns = this.valueColsSvc?.columns;
        const pivotColumns = pivotActive && this.pivotColsSvc ? this.pivotColsSvc.columns : [];
        const aggDetails = {
            alwaysAggregateAtRootLevel: this.gos.get('alwaysAggregateAtRootLevel'),
            groupIncludeTotalFooter: !!(0, ag_grid_community_1._getGrandTotalRow)(this.gos),
            changedPath: params.changedPath,
            valueColumns: measureColumns ?? [],
            pivotColumns: pivotColumns,
            filteredOnly: !this.isSuppressAggFilteredOnly(),
            userAggFunc: this.gos.getCallback('getGroupRowAgg'),
        };
        return aggDetails;
    }
    isSuppressAggFilteredOnly() {
        const isGroupAggFiltering = (0, ag_grid_community_1._getGroupAggFiltering)(this.gos) !== undefined;
        return isGroupAggFiltering || this.gos.get('suppressAggFilteredOnly');
    }
    recursivelyCreateAggData(aggDetails) {
        const callback = (rowNode) => {
            const hasNoChildren = !rowNode.hasChildren();
            if (hasNoChildren) {
                // this check is needed for TreeData, in case the node is no longer a child,
                // but it was a child previously.
                if (rowNode.aggData) {
                    this.setAggData(rowNode, null);
                }
                // never agg data for leaf nodes
                return;
            }
            //Optionally enable the aggregation at the root Node
            const isRootNode = rowNode.level === -1;
            // if total footer is displayed, the value is in use
            if (isRootNode && !aggDetails.groupIncludeTotalFooter) {
                const notPivoting = !this.colModel.isPivotMode();
                if (!aggDetails.alwaysAggregateAtRootLevel && notPivoting) {
                    this.setAggData(rowNode, null);
                    return;
                }
            }
            this.aggregateRowNode(rowNode, aggDetails);
        };
        aggDetails.changedPath.forEachChangedNodeDepthFirst(callback, true);
    }
    aggregateRowNode(rowNode, aggDetails) {
        const measureColumnsMissing = aggDetails.valueColumns.length === 0;
        const pivotColumnsMissing = aggDetails.pivotColumns.length === 0;
        let aggResult;
        if (aggDetails.userAggFunc) {
            aggResult = aggDetails.userAggFunc({ nodes: rowNode.childrenAfterFilter });
        }
        else if (measureColumnsMissing) {
            aggResult = null;
        }
        else if (pivotColumnsMissing) {
            aggResult = this.aggregateRowNodeUsingValuesOnly(rowNode, aggDetails);
        }
        else {
            aggResult = this.aggregateRowNodeUsingValuesAndPivot(rowNode);
        }
        this.setAggData(rowNode, aggResult);
        // if we are grouping, then it's possible there is a sibling footer
        // to the group, so update the data here also if there is one
        if (rowNode.sibling) {
            this.setAggData(rowNode.sibling, aggResult);
        }
    }
    aggregateRowNodeUsingValuesAndPivot(rowNode) {
        const result = {};
        const secondaryColumns = this.pivotResultCols?.getPivotResultCols()?.list ?? [];
        let canSkipTotalColumns = true;
        for (let i = 0; i < secondaryColumns.length; i++) {
            const secondaryCol = secondaryColumns[i];
            const colDef = secondaryCol.getColDef();
            if (colDef.pivotTotalColumnIds != null) {
                canSkipTotalColumns = false;
                continue;
            }
            const keys = colDef.pivotKeys ?? [];
            let values;
            if (rowNode.leafGroup) {
                // lowest level group, get the values from the mapped set
                values = this.getValuesFromMappedSet(rowNode.childrenMapped, keys, colDef.pivotValueColumn);
            }
            else {
                // value columns and pivot columns, non-leaf group
                values = this.getValuesPivotNonLeaf(rowNode, colDef.colId);
            }
            // bit of a memory drain storing null/undefined, but seems to speed up performance.
            result[colDef.colId] = this.aggregateValues(values, colDef.pivotValueColumn.getAggFunc(), colDef.pivotValueColumn, rowNode, secondaryCol);
        }
        if (!canSkipTotalColumns) {
            for (let i = 0; i < secondaryColumns.length; i++) {
                const secondaryCol = secondaryColumns[i];
                const colDef = secondaryCol.getColDef();
                if (colDef.pivotTotalColumnIds == null || !colDef.pivotTotalColumnIds.length) {
                    continue;
                }
                const aggResults = colDef.pivotTotalColumnIds.map((currentColId) => result[currentColId]);
                // bit of a memory drain storing null/undefined, but seems to speed up performance.
                result[colDef.colId] = this.aggregateValues(aggResults, colDef.pivotValueColumn.getAggFunc(), colDef.pivotValueColumn, rowNode, secondaryCol);
            }
        }
        return result;
    }
    aggregateRowNodeUsingValuesOnly(rowNode, aggDetails) {
        const result = {};
        const { changedPath, valueColumns, filteredOnly } = aggDetails;
        const changedValueColumns = changedPath.active
            ? changedPath.getValueColumnsForNode(rowNode, valueColumns)
            : valueColumns;
        const notChangedValueColumns = changedPath.active
            ? changedPath.getNotValueColumnsForNode(rowNode, valueColumns)
            : null;
        const values2d = this.getValuesNormal(rowNode, changedValueColumns, filteredOnly);
        const oldValues = rowNode.aggData;
        changedValueColumns.forEach((valueColumn, index) => {
            result[valueColumn.getId()] = this.aggregateValues(values2d[index], valueColumn.getAggFunc(), valueColumn, rowNode);
        });
        if (notChangedValueColumns && oldValues) {
            notChangedValueColumns.forEach((valueColumn) => {
                result[valueColumn.getId()] = oldValues[valueColumn.getId()];
            });
        }
        return result;
    }
    getValuesPivotNonLeaf(rowNode, colId) {
        return rowNode.childrenAfterFilter.map((childNode) => childNode.aggData[colId]);
    }
    getValuesFromMappedSet(mappedSet, keys, valueColumn) {
        let mapPointer = mappedSet;
        for (let i = 0; i < keys.length; i++) {
            const key = keys[i];
            mapPointer = mapPointer ? mapPointer[key] : null;
        }
        if (!mapPointer) {
            return [];
        }
        return mapPointer.map((rowNode) => this.valueSvc.getValue(valueColumn, rowNode));
    }
    getValuesNormal(rowNode, valueColumns, filteredOnly) {
        // create 2d array, of all values for all valueColumns
        const values = [];
        valueColumns.forEach(() => values.push([]));
        const valueColumnCount = valueColumns.length;
        const nodeList = filteredOnly ? rowNode.childrenAfterFilter : rowNode.childrenAfterGroup;
        const rowCount = nodeList.length;
        for (let i = 0; i < rowCount; i++) {
            const childNode = nodeList[i];
            for (let j = 0; j < valueColumnCount; j++) {
                const valueColumn = valueColumns[j];
                // if the row is a group, then it will only have an agg result value,
                // which means valueGetter is never used.
                const value = this.valueSvc.getValue(valueColumn, childNode);
                values[j].push(value);
            }
        }
        return values;
    }
    aggregateValues(values, aggFuncOrString, column, rowNode, pivotResultColumn) {
        const aggFunc = typeof aggFuncOrString === 'string' ? this.aggFuncSvc.getAggFunc(aggFuncOrString) : aggFuncOrString;
        if (typeof aggFunc !== 'function') {
            (0, ag_grid_community_1._error)(109, { aggFuncOrString });
            return null;
        }
        const aggFuncAny = aggFunc;
        const params = (0, ag_grid_community_1._addGridCommonParams)(this.gos, {
            values: values,
            column: column,
            colDef: column ? column.getColDef() : undefined,
            pivotResultColumn: pivotResultColumn,
            rowNode: rowNode,
            data: rowNode ? rowNode.data : undefined,
        }); // the "as any" is needed to allow the deprecation warning messages
        return aggFuncAny(params);
    }
    setAggData(rowNode, newAggData) {
        const oldAggData = rowNode.aggData;
        rowNode.aggData = newAggData;
        // if no event service, nobody has registered for events, so no need fire event
        if (rowNode.__localEventService) {
            const eventFunc = (colId) => {
                const value = rowNode.aggData ? rowNode.aggData[colId] : undefined;
                const oldValue = oldAggData ? oldAggData[colId] : undefined;
                if (value === oldValue) {
                    return;
                }
                // do a quick lookup - despite the event it's possible the column no longer exists
                const column = this.colModel.getCol(colId);
                if (!column) {
                    return;
                }
                rowNode.dispatchCellChangedEvent(column, value, oldValue);
            };
            if (oldAggData) {
                for (const key of Object.keys(oldAggData)) {
                    eventFunc(key); // raise for old keys
                }
            }
            if (newAggData) {
                for (const key of Object.keys(newAggData)) {
                    if (!oldAggData || !(key in oldAggData)) {
                        eventFunc(key); // new key, event not yet raised
                    }
                }
            }
        }
    }
}
exports.AggregationStage = AggregationStage;


/***/ }),

/***/ 6948:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FilterAggregatesStage = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class FilterAggregatesStage extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'filterAggStage';
        this.refreshProps = new Set([]);
        this.step = 'filter_aggregates';
    }
    wireBeans(beans) {
        this.filterManager = beans.filterManager;
    }
    execute(params) {
        const isPivotMode = this.beans.colModel.isPivotMode();
        const isAggFilterActive = this.filterManager?.isAggregateFilterPresent() || this.filterManager?.isAggregateQuickFilterPresent();
        // This is the default filter for applying only to leaf nodes, realistically this should not apply as primary agg columns,
        // should not be applied by the filterManager if getGroupAggFiltering is missing. Predicate will apply filters to leaf level.
        const defaultPrimaryColumnPredicate = (params) => !params.node.group;
        // Default secondary column predicate, selecting only leaf level groups.
        const defaultSecondaryColumnPredicate = (params) => params.node.leafGroup;
        // The predicate to determine whether filters should apply to this row. Either defined by the user in groupAggFiltering or a default depending
        // on current pivot mode status.
        const applyFilterToNode = (0, ag_grid_community_1._getGroupAggFiltering)(this.gos) ||
            (isPivotMode ? defaultSecondaryColumnPredicate : defaultPrimaryColumnPredicate);
        const { changedPath } = params;
        const preserveChildren = (node, recursive = false) => {
            if (node.childrenAfterFilter) {
                node.childrenAfterAggFilter = node.childrenAfterFilter;
                if (recursive) {
                    node.childrenAfterAggFilter.forEach((child) => preserveChildren(child, recursive));
                }
                this.setAllChildrenCount(node);
            }
            if (node.sibling) {
                node.sibling.childrenAfterAggFilter = node.childrenAfterAggFilter;
            }
        };
        const filterChildren = (node) => {
            node.childrenAfterAggFilter =
                node.childrenAfterFilter?.filter((child) => {
                    const shouldFilterRow = applyFilterToNode({ node: child });
                    if (shouldFilterRow) {
                        const doesNodePassFilter = this.filterManager.doesRowPassAggregateFilters({ rowNode: child });
                        if (doesNodePassFilter) {
                            // Node has passed, so preserve children
                            preserveChildren(child, true);
                            return true;
                        }
                    }
                    const hasChildPassed = child.childrenAfterAggFilter?.length;
                    return hasChildPassed;
                }) || null;
            this.setAllChildrenCount(node);
            if (node.sibling) {
                node.sibling.childrenAfterAggFilter = node.childrenAfterAggFilter;
            }
        };
        changedPath.forEachChangedNodeDepthFirst(isAggFilterActive ? filterChildren : preserveChildren, true);
    }
    /** for tree data, we include all children, groups and leafs */
    setAllChildrenCountTreeData(rowNode) {
        const childrenAfterAggFilter = rowNode.childrenAfterAggFilter;
        let allChildrenCount = 0;
        if (childrenAfterAggFilter) {
            const length = childrenAfterAggFilter.length;
            allChildrenCount = length; // include direct children too
            for (let i = 0; i < length; ++i) {
                allChildrenCount += childrenAfterAggFilter[i].allChildrenCount ?? 0; // include children of children
            }
        }
        rowNode.setAllChildrenCount(
        // Maintain the historical behaviour:
        // - allChildrenCount is 0 in the root if there are no children
        // - allChildrenCount is null in any non-root row if there are no children
        allChildrenCount === 0 && rowNode.level >= 0 ? null : allChildrenCount);
    }
    /* for grid data, we only count the leafs */
    setAllChildrenCountGridGrouping(rowNode) {
        let allChildrenCount = 0;
        rowNode.childrenAfterAggFilter.forEach((child) => {
            if (child.group) {
                allChildrenCount += child.allChildrenCount;
            }
            else {
                allChildrenCount++;
            }
        });
        rowNode.setAllChildrenCount(allChildrenCount);
    }
    setAllChildrenCount(rowNode) {
        if (!rowNode.hasChildren()) {
            rowNode.setAllChildrenCount(null);
            return;
        }
        if (this.gos.get('treeData')) {
            this.setAllChildrenCountTreeData(rowNode);
        }
        else {
            this.setAllChildrenCountGridGrouping(rowNode);
        }
    }
}
exports.FilterAggregatesStage = FilterAggregatesStage;


/***/ }),

/***/ 182:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FooterService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const footerUtils_1 = __webpack_require__(6432);
class FooterService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'footerSvc';
    }
    addTotalRows(startIndex, node, callback, includeFooterNodes, isRootNode, position) {
        let index = startIndex;
        if (isRootNode) {
            const grandTotal = includeFooterNodes && (0, ag_grid_community_1._getGrandTotalRow)(this.gos);
            if (grandTotal === position) {
                (0, footerUtils_1._createRowNodeFooter)(node, this.beans);
                callback(node.sibling, index++);
            }
            return index;
        }
        const isGroupIncludeFooter = (0, ag_grid_community_1._getGroupTotalRowCallback)(this.gos);
        const groupTotal = includeFooterNodes && isGroupIncludeFooter({ node });
        if (groupTotal === position) {
            (0, footerUtils_1._createRowNodeFooter)(node, this.beans);
            callback(node.sibling, index++);
        }
        return index;
    }
    getTopDisplayIndex(rowsToDisplay, topLevelIndex, childrenAfterSort, getDefaultIndex) {
        let adjustedIndex = topLevelIndex;
        if (rowsToDisplay[0].footer) {
            // if footer is first displayed row and looking for first row, return footer
            if (topLevelIndex === 0) {
                return 0;
            }
            // if first row is footer, offset index to check sorted rows by 1
            adjustedIndex -= 1;
        }
        const lastRow = rowsToDisplay[rowsToDisplay.length - 1];
        const indexOutsideGroupBounds = adjustedIndex >= childrenAfterSort.length;
        // if last row is footer, and attempting to retrieve row of too high index, return footer row index
        if (lastRow.footer && indexOutsideGroupBounds) {
            return lastRow.rowIndex;
        }
        return getDefaultIndex(adjustedIndex);
    }
}
exports.FooterService = FooterService;


/***/ }),

/***/ 6432:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports._destroyRowNodeFooter = exports._createRowNodeFooter = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
/**
 * When creating sibling nodes (e.g. footers), we don't copy these properties as they
 * cause the sibling to have properties which should be unique to the row.
 *
 * Note that `keyof T` does not include private members of `T`, so these need to be
 * added explicitly to this list. Take care when adding or renaming private properties
 * of `RowNode`.
 */
const IGNORED_SIBLING_PROPERTIES = new Set(['__localEventService', '__objectId', 'sticky', '__autoHeights', '__checkAutoHeightsDebounced']);
function _createRowNodeFooter(rowNode, beans) {
    // only create footer node once, otherwise we have daemons and
    // the animate screws up with the daemons hanging around
    if (rowNode.sibling) {
        return;
    }
    const footerNode = new ag_grid_community_1.RowNode(beans);
    Object.keys(rowNode).forEach((key) => {
        if (IGNORED_SIBLING_PROPERTIES.has(key)) {
            return;
        }
        footerNode[key] = rowNode[key];
    });
    footerNode.footer = true;
    footerNode.setRowTop(null);
    footerNode.setRowIndex(null);
    // manually set oldRowTop to null so we discard any
    // previous information about its position.
    footerNode.oldRowTop = null;
    footerNode.id = 'rowGroupFooter_' + rowNode.id;
    // get both header and footer to reference each other as siblings. this is never undone,
    // only overwritten. so if a group is expanded, then contracted, it will have a ghost
    // sibling - but that's fine, as we can ignore this if the header is contracted.
    footerNode.sibling = rowNode;
    rowNode.sibling = footerNode;
}
exports._createRowNodeFooter = _createRowNodeFooter;
function _destroyRowNodeFooter(rowNode) {
    if (!rowNode.sibling) {
        return;
    }
    rowNode.sibling.setRowTop(null);
    rowNode.sibling.setRowIndex(null);
    rowNode.sibling = undefined;
}
exports._destroyRowNodeFooter = _destroyRowNodeFooter;


/***/ }),

/***/ 7926:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValueColsSvc = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ValueColsSvc extends ag_grid_community_1.BaseColsService {
    constructor() {
        super(...arguments);
        this.beanName = 'valueColsSvc';
        this.eventName = 'columnValueChanged';
        this.columnProcessors = {
            set: (column, added, source) => this.setValueActive(added, column, source),
            add: (column, added, source) => this.setValueActive(true, column, source),
            remove: (column, added, source) => this.setValueActive(false, column, source),
        };
        this.columnExtractors = {
            setFlagFunc: (col, flag, source) => this.setColValueActive(col, flag, source),
            getIndexFunc: () => undefined,
            getInitialIndexFunc: () => undefined,
            getValueFunc: (colDef) => {
                const aggFunc = colDef.aggFunc;
                // null or empty string means clear
                if (aggFunc === null || aggFunc === '') {
                    return null;
                }
                if (aggFunc === undefined) {
                    return;
                }
                return !!aggFunc;
            },
            getInitialValueFunc: (colDef) => {
                // return false if any of the following: null, undefined, empty string
                return colDef.initialAggFunc != null && colDef.initialAggFunc != '';
            },
        };
        this.modifyColumnsNoEventsCallbacks = {
            addCol: (column) => this.columns.push(column),
            removeCol: (column) => (0, ag_grid_community_1._removeFromArray)(this.columns, column),
        };
    }
    extractCols(source, oldProvidedCols) {
        this.columns = super.extractCols(source, oldProvidedCols);
        // all new columns added will have aggFunc missing, so set it to what is in the colDef
        this.columns.forEach((col) => {
            const colDef = col.getColDef();
            // if aggFunc provided, we always override, as reactive property
            if (colDef.aggFunc != null && colDef.aggFunc != '') {
                this.setColAggFunc(col, colDef.aggFunc);
            }
            else {
                // otherwise we use initialAggFunc only if no agg func set - which happens when new column only
                if (!col.getAggFunc()) {
                    this.setColAggFunc(col, colDef.initialAggFunc);
                }
            }
        });
        return this.columns;
    }
    setColumnAggFunc(key, aggFunc, source) {
        if (!key) {
            return;
        }
        const column = this.colModel.getColDefCol(key);
        if (!column) {
            return;
        }
        this.setColAggFunc(column, aggFunc);
        this.dispatchColumnChangedEvent(this.eventSvc, this.eventName, [column], source);
    }
    syncColumnWithState(column, source, getValue) {
        // noop
        const aggFunc = getValue('aggFunc').value1;
        if (aggFunc !== undefined) {
            if (typeof aggFunc === 'string') {
                this.setColAggFunc(column, aggFunc);
                if (!column.isValueActive()) {
                    this.setColValueActive(column, true, source);
                    this.modifyColumnsNoEventsCallbacks.addCol(column);
                }
            }
            else {
                if ((0, ag_grid_community_1._exists)(aggFunc)) {
                    // stateItem.aggFunc must be a string
                    (0, ag_grid_community_1._warn)(33);
                }
                // Note: we do not call column.setAggFunc(null), so that next time we aggregate
                // by this column (eg drag the column to the agg section int he toolpanel) it will
                // default to the last aggregation function.
                if (column.isValueActive()) {
                    this.setColValueActive(column, false, source);
                    this.modifyColumnsNoEventsCallbacks.removeCol(column);
                }
            }
        }
    }
    setValueActive(active, column, source) {
        if (active === column.isValueActive()) {
            return;
        }
        this.setColValueActive(column, active, source);
        if (active && !column.getAggFunc() && this.aggFuncSvc) {
            const initialAggFunc = this.aggFuncSvc.getDefaultAggFunc(column);
            this.setColAggFunc(column, initialAggFunc);
        }
    }
    setColAggFunc(column, aggFunc) {
        column.aggFunc = aggFunc;
        column.dispatchStateUpdatedEvent('aggFunc');
    }
    setColValueActive(column, value, source) {
        if (column.aggregationActive !== value) {
            column.aggregationActive = value;
            column.dispatchColEvent('columnValueChanged', source);
        }
    }
}
exports.ValueColsSvc = ValueColsSvc;


/***/ }),

/***/ 1809:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AllEnterpriseModule = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const advancedFilterModule_1 = __webpack_require__(7976);
const integratedChartsModule_1 = __webpack_require__(1527);
const clipboardModule_1 = __webpack_require__(3766);
const columnsToolPanelModule_1 = __webpack_require__(6455);
const excelExportModule_1 = __webpack_require__(2886);
const filtersToolPanelModule_1 = __webpack_require__(2515);
const masterDetailModule_1 = __webpack_require__(1594);
const menuModule_1 = __webpack_require__(7130);
const multiFilterModule_1 = __webpack_require__(5434);
const pivotModule_1 = __webpack_require__(5470);
const rangeSelectionModule_1 = __webpack_require__(266);
const richSelectModule_1 = __webpack_require__(9327);
const rowGroupingModule_1 = __webpack_require__(1442);
const rowNumbersModule_1 = __webpack_require__(976);
const serverSideRowModelModule_1 = __webpack_require__(9074);
const setFilterModule_1 = __webpack_require__(9002);
const sideBarModule_1 = __webpack_require__(6358);
const sparklinesModule_1 = __webpack_require__(2949);
const statusBarModule_1 = __webpack_require__(8450);
const treeDataModule_1 = __webpack_require__(9428);
const version_1 = __webpack_require__(7205);
const viewportRowModelModule_1 = __webpack_require__(7794);
const dependsOn = [
    ag_grid_community_1.AllCommunityModule,
    clipboardModule_1.ClipboardModule,
    columnsToolPanelModule_1.ColumnsToolPanelModule,
    excelExportModule_1.ExcelExportModule,
    filtersToolPanelModule_1.FiltersToolPanelModule,
    masterDetailModule_1.MasterDetailModule,
    menuModule_1.ColumnMenuModule,
    menuModule_1.ContextMenuModule,
    rangeSelectionModule_1.CellSelectionModule,
    richSelectModule_1.RichSelectModule,
    rowNumbersModule_1.RowNumbersModule,
    rowGroupingModule_1.RowGroupingModule,
    rowGroupingModule_1.RowGroupingPanelModule,
    rowGroupingModule_1.GroupFilterModule,
    serverSideRowModelModule_1.ServerSideRowModelModule,
    serverSideRowModelModule_1.ServerSideRowModelApiModule,
    setFilterModule_1.SetFilterModule,
    multiFilterModule_1.MultiFilterModule,
    advancedFilterModule_1.AdvancedFilterModule,
    sideBarModule_1.SideBarModule,
    statusBarModule_1.StatusBarModule,
    viewportRowModelModule_1.ViewportRowModelModule,
    pivotModule_1.PivotModule,
    treeDataModule_1.TreeDataModule,
];
const moduleName = 'AllEnterprise';
/**
 * @feature All Enterprise and Community features
 * Registers all the Grid features: Community and Enterprise.
 * If using Integrated Charts or Sparklines then the relevant AG Charts module must be provided.
 * @example
 * // All Enterprise features
 * import { ModuleRegistry } from 'ag-grid-community';
 * import { AllEnterpriseModule } from 'ag-grid-enterprise';
 *
 * ModuleRegistry.registerModules([ AllEnterpriseModule ]);
 * @example
 * // All Enterprise features including Integrated Charts and Sparklines
 * import { ModuleRegistry } from 'ag-grid-community';
 * import { AgChartsEnterpriseModule } from 'ag-charts-enterprise';
 * import { AllEnterpriseModule } from 'ag-grid-enterprise';
 *
 * ModuleRegistry.registerModules([ AllEnterpriseModule.with(AgChartsEnterpriseModule) ]);
 *
 */
exports.AllEnterpriseModule = {
    with: (params) => ({
        moduleName,
        version: version_1.VERSION,
        dependsOn: [...dependsOn, integratedChartsModule_1.IntegratedChartsModule.with(params), sparklinesModule_1.SparklinesModule.with(params)],
    }),
    moduleName,
    version: version_1.VERSION,
    dependsOn: dependsOn,
};


/***/ }),

/***/ 7672:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SkeletonCellRendererModule = exports.LoadingCellRendererModule = void 0;
const agGridEnterpriseModule_1 = __webpack_require__(9206);
const version_1 = __webpack_require__(7205);
const loadingCellRenderer_1 = __webpack_require__(1565);
const skeletonCellRenderer_1 = __webpack_require__(780);
/**
 * @internal
 */
exports.LoadingCellRendererModule = {
    moduleName: 'LoadingCellRenderer',
    version: version_1.VERSION,
    userComponents: {
        agLoadingCellRenderer: loadingCellRenderer_1.LoadingCellRenderer,
    },
    icons: {
        // rotating spinner shown by the loading cell renderer
        groupLoading: 'loading',
    },
    dependsOn: [agGridEnterpriseModule_1.EnterpriseCoreModule],
};
/**
 * @internal
 */
exports.SkeletonCellRendererModule = {
    moduleName: 'SkeletonCellRenderer',
    version: version_1.VERSION,
    userComponents: {
        agSkeletonCellRenderer: skeletonCellRenderer_1.SkeletonCellRenderer,
    },
    dependsOn: [agGridEnterpriseModule_1.EnterpriseCoreModule],
};


/***/ }),

/***/ 1565:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoadingCellRenderer = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class LoadingCellRenderer extends ag_grid_community_1.Component {
    constructor() {
        super(/* html */ `<div class="ag-loading">
            <span class="ag-loading-icon" data-ref="eLoadingIcon"></span>
            <span class="ag-loading-text" data-ref="eLoadingText"></span>
        </div>`);
        this.eLoadingIcon = ag_grid_community_1.RefPlaceholder;
        this.eLoadingText = ag_grid_community_1.RefPlaceholder;
    }
    init(params) {
        params.node.failedLoad ? this.setupFailed() : this.setupLoading();
    }
    setupFailed() {
        const localeTextFunc = this.getLocaleTextFunc();
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.eLoadingText.innerText = localeTextFunc('loadingError', 'ERR');
    }
    setupLoading() {
        const eLoadingIcon = (0, ag_grid_community_1._createIconNoSpan)('groupLoading', this.beans, null);
        if (eLoadingIcon) {
            this.eLoadingIcon.appendChild(eLoadingIcon);
        }
        const localeTextFunc = this.getLocaleTextFunc();
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.eLoadingText.innerText = localeTextFunc('loadingOoo', 'Loading');
    }
    refresh(_params) {
        return false;
    }
}
exports.LoadingCellRenderer = LoadingCellRenderer;


/***/ }),

/***/ 780:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SkeletonCellRenderer = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class SkeletonCellRenderer extends ag_grid_community_1.Component {
    constructor() {
        super(/* html */ `<div class="ag-skeleton-container"></div>`);
    }
    init(params) {
        const id = `ag-cell-skeleton-renderer-${this.getCompId()}`;
        this.getGui().setAttribute('id', id);
        this.addDestroyFunc(() => (0, ag_grid_community_1._setAriaLabelledBy)(params.eParentOfValue));
        (0, ag_grid_community_1._setAriaLabelledBy)(params.eParentOfValue, id);
        params.node.failedLoad ? this.setupFailed() : this.setupLoading(params);
    }
    setupFailed() {
        const localeTextFunc = this.getLocaleTextFunc();
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        this.getGui().innerText = localeTextFunc('loadingError', 'ERR');
        const ariaFailed = localeTextFunc('ariaSkeletonCellLoadingFailed', 'Row failed to load');
        (0, ag_grid_community_1._setAriaLabel)(this.getGui(), ariaFailed);
    }
    setupLoading(params) {
        const eDocument = (0, ag_grid_community_1._getDocument)(this.beans);
        const skeletonEffect = eDocument.createElement('div');
        skeletonEffect.classList.add('ag-skeleton-effect');
        // Use the row index to derive a width value for the skeleton cell
        // to avoid them having uniform width when rendering
        const rowIndex = params.node.rowIndex;
        if (rowIndex != null) {
            // Base value of 75% with variation between [-25%, 25%]. We alternate between sin and
            // cos to achieve a semi-random appearance without actually needing a random number.
            // We avoid using random numbers because then skeletons have consistent widths after
            // being scrolled on and off screen.
            const width = 75 + 25 * (rowIndex % 2 === 0 ? Math.sin(rowIndex) : Math.cos(rowIndex));
            skeletonEffect.style.width = `${width}%`;
        }
        this.getGui().appendChild(skeletonEffect);
        const localeTextFunc = this.getLocaleTextFunc();
        const ariaLoading = localeTextFunc('ariaSkeletonCellLoading', 'Row data is loading');
        (0, ag_grid_community_1._setAriaLabel)(this.getGui(), ariaLoading);
    }
    refresh(_params) {
        return false;
    }
}
exports.SkeletonCellRenderer = SkeletonCellRenderer;


/***/ }),

/***/ 2459:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgChartsExports = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
/** Bean to expose the AG Charts apis from a single location and not require a code dependency on ag-charts-community */
class AgChartsExports extends ag_grid_community_1.BeanStub {
    constructor(params) {
        super();
        this.beanName = 'agChartsExports';
        this.isEnterprise = false;
        this.create = params.create;
        this._Theme = params._Theme;
        this._Scene = params._Scene;
        this.isEnterprise = params.isEnterprise;
        this._Util = params._Util;
    }
}
exports.AgChartsExports = AgChartsExports;


/***/ }),

/***/ 3251:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartController = exports.DEFAULT_THEMES = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const chartTheme_1 = __webpack_require__(8987);
const chartDataModel_1 = __webpack_require__(8592);
const chartParamsValidator_1 = __webpack_require__(8889);
const seriesTypeMapper_1 = __webpack_require__(4237);
exports.DEFAULT_THEMES = ['ag-default', 'ag-material', 'ag-sheets', 'ag-polychroma', 'ag-vivid'];
class ChartController extends ag_grid_community_1.BeanStub {
    wireBeans(beans) {
        this.rangeSvc = beans.rangeSvc;
        this.agChartsExports = beans.agChartsExports;
    }
    constructor(model) {
        super();
        this.model = model;
        this.isEnterprise = () => this.agChartsExports.isEnterprise;
    }
    postConstruct() {
        this.setChartRange();
        if (this.model.unlinked) {
            if (this.rangeSvc) {
                this.rangeSvc.setCellRanges([]);
            }
        }
        const listener = this.updateForGridChange.bind(this, {});
        this.addManagedEventListeners({
            cellSelectionChanged: (event) => {
                if (event.id && event.id === this.model.chartId) {
                    this.updateForRangeChange();
                }
            },
            columnMoved: listener,
            columnPinned: listener,
            columnVisible: listener,
            columnRowGroupChanged: listener,
            modelUpdated: listener,
            cellValueChanged: this.updateForDataChange.bind(this),
        });
    }
    update(params) {
        if (!this.validUpdateType(params))
            return false;
        const validationResult = (0, chartParamsValidator_1.validateUpdateParams)(params, this.agChartsExports.isEnterprise);
        if (!validationResult)
            return false;
        const validParams = validationResult === true ? params : validationResult;
        this.applyValidatedChartParams(validParams);
        return true;
    }
    applyValidatedChartParams(params) {
        const { chartId, chartType, chartThemeName, unlinkChart } = params;
        // create a common base for the chart model parameters (this covers pivot chart updates)
        const common = {
            chartId: chartId,
            pivotChart: this.model.pivotChart,
            chartType: chartType ?? this.model.chartType,
            chartThemeName: chartThemeName ?? this.model.chartThemeName,
            unlinkChart: unlinkChart ?? this.model.unlinked,
            cellRange: this.model.suppliedCellRange,
            switchCategorySeries: this.model.switchCategorySeries,
            aggFunc: this.model.aggFunc,
            seriesChartTypes: undefined,
            suppressChartRanges: false,
            crossFiltering: false,
        };
        const chartModelParams = { ...common };
        // modify the chart model properties based on the type of update
        switch (params.type) {
            case 'rangeChartUpdate':
                chartModelParams.cellRange = this.createCellRange(params) ?? this.model.suppliedCellRange;
                chartModelParams.switchCategorySeries = params.switchCategorySeries ?? this.model.switchCategorySeries;
                chartModelParams.aggFunc = params.aggFunc ?? this.model.aggFunc;
                chartModelParams.seriesChartTypes = params.seriesChartTypes;
                chartModelParams.suppressChartRanges = params.suppressChartRanges ?? this.model.suppressChartRanges;
                chartModelParams.seriesGroupType = params.seriesGroupType ?? this.model.seriesGroupType;
                break;
            case 'crossFilterChartUpdate':
                chartModelParams.cellRange = this.createCellRange(params) ?? this.model.suppliedCellRange;
                chartModelParams.switchCategorySeries = false;
                chartModelParams.aggFunc = params.aggFunc ?? this.model.aggFunc;
                chartModelParams.crossFiltering = true;
                chartModelParams.suppressChartRanges = params.suppressChartRanges ?? this.model.suppressChartRanges;
                break;
            case 'pivotChartUpdate':
                chartModelParams.switchCategorySeries = false;
                break;
        }
        this.model.updateModel(chartModelParams);
        // if the chart should be unlinked or chart ranges suppressed, remove all cell ranges; otherwise, set the chart range
        const removeChartCellRanges = chartModelParams.unlinkChart || chartModelParams.suppressChartRanges;
        removeChartCellRanges ? this.rangeSvc?.setCellRanges([]) : this.setChartRange();
    }
    updateForGridChange(params) {
        if (this.model.unlinked) {
            return;
        }
        const { maintainColState, setColsFromRange } = params ?? {};
        this.model.updateCellRanges({ maintainColState, setColsFromRange });
        this.model.updateData();
        this.setChartRange();
    }
    updateForDataChange() {
        if (this.model.unlinked) {
            return;
        }
        this.model.updateData();
        this.raiseChartModelUpdateEvent();
    }
    updateForRangeChange() {
        this.updateForGridChange({ setColsFromRange: true });
        this.raiseChartRangeSelectionChangedEvent();
    }
    updateForPanelChange(params) {
        this.model.updateCellRanges(params);
        this.model.updateData();
        if (params.skipAnimation) {
            this.getChartProxy().getChartRef().skipAnimations();
        }
        this.setChartRange();
        this.raiseChartRangeSelectionChangedEvent();
    }
    updateThemeOverrides(updatedOverrides) {
        this.chartProxy.updateThemeOverrides(updatedOverrides);
    }
    getChartUpdateParams(updatedOverrides) {
        const selectedCols = this.getSelectedValueColState();
        const fields = selectedCols.map((c) => ({ colId: c.colId, displayName: c.displayName }));
        const data = this.getChartData();
        const selectedDimensions = this.getSelectedDimensions();
        const params = {
            data,
            groupData: this.model.groupChartData,
            grouping: this.isGrouping(),
            categories: selectedDimensions.map((selectedDimension) => ({
                id: selectedDimension.colId,
                name: selectedDimension.displayName,
                chartDataType: this.model.categoryAxisType ?? this.model.getChartDataType(selectedDimension.colId),
            })),
            fields,
            chartId: this.getChartId(),
            getCrossFilteringContext: () => ({ lastSelectedChartId: 'xxx' }),
            seriesChartTypes: this.getSeriesChartTypes(),
            updatedOverrides: updatedOverrides,
            seriesGroupType: this.model.seriesGroupType,
        };
        return this.isCategorySeriesSwitched() ? this.invertCategorySeriesParams(params) : params;
    }
    invertCategorySeriesParams(params) {
        const [category] = params.categories;
        // Create a single synthetic output category that will contain the series name values
        const categories = [{ id: chartDataModel_1.DEFAULT_CHART_CATEGORY, name: '' }];
        // Create an output series corresponding to each row in the input data
        const fields = params.data.map((value, index) => {
            const categoryKey = `${category.id}:${index}`;
            const categoryValue = value[category.id];
            const seriesLabel = categoryValue == null ? '' : String(categoryValue);
            return { colId: categoryKey, displayName: seriesLabel };
        });
        // Create an output data row corresponding to each selected series column
        const data = params.fields.map((field) => {
            // Create a new output row labeled with the series column name
            const row = {
                [chartDataModel_1.DEFAULT_CHART_CATEGORY]: field.displayName,
            };
            // Append fields corresponding to each row in the input data
            for (const [index, value] of params.data.entries()) {
                const categoryKey = `${category.id}:${index}`;
                const seriesLabelValue = value[field.colId];
                row[categoryKey] = seriesLabelValue;
            }
            return row;
        });
        return {
            ...params,
            categories,
            fields,
            data,
        };
    }
    getChartModel() {
        const modelType = this.model.pivotChart ? 'pivot' : 'range';
        const seriesChartTypes = this.isComboChart() ? this.model.comboChartModel.seriesChartTypes : undefined;
        return {
            modelType,
            chartId: this.model.chartId,
            chartType: this.model.chartType,
            chartThemeName: this.getChartThemeName(),
            chartOptions: this.chartProxy?.getChartThemeOverrides(),
            chartPalette: this.chartProxy?.getChartPalette(),
            cellRange: this.getCellRangeParams(),
            switchCategorySeries: this.model.switchCategorySeries,
            suppressChartRanges: this.model.suppressChartRanges,
            aggFunc: this.model.aggFunc,
            unlinkChart: this.model.unlinked,
            seriesChartTypes,
            seriesGroupType: this.model.seriesGroupType,
        };
    }
    getChartId() {
        return this.model.chartId;
    }
    getChartData() {
        return this.model.chartData;
    }
    getChartType() {
        return this.model.chartType;
    }
    setChartType(chartType) {
        this.updateMultiSeriesAndCategory(this.model.chartType, chartType);
        this.model.chartType = chartType;
        this.model.comboChartModel.updateSeriesChartTypes();
        // Reset the inverted category/series toggle whenever the chart type changes
        this.model.switchCategorySeries = false;
        this.model.categoryAxisType = undefined;
        this.model.seriesGroupType = undefined;
        this.raiseChartModelUpdateEvent();
    }
    isCategorySeriesSwitched() {
        return this.model.switchCategorySeries && !this.model.isGrouping();
    }
    switchCategorySeries(inverted) {
        if (!(0, seriesTypeMapper_1.supportsInvertedCategorySeries)(this.getChartType()))
            return;
        this.model.switchCategorySeries = inverted;
        this.raiseChartModelUpdateEvent();
    }
    getAggFunc() {
        return this.model.aggFunc;
    }
    setAggFunc(value, silent) {
        if (this.model.aggFunc === value)
            return;
        this.model.aggFunc = value;
        if (silent)
            return;
        this.model.updateData();
        this.raiseChartModelUpdateEvent();
    }
    updateMultiSeriesAndCategory(previousChartType, chartType) {
        // If we are changing from a multi-category/series chart type to a single-category/series chart type,
        // ensure that only the allowed number of selected category/series column remain selected
        const updateForMax = (columns, maxNum) => {
            let numSelected = 0;
            for (const colState of columns) {
                if (!colState.selected)
                    continue;
                if (numSelected >= maxNum) {
                    colState.selected = false;
                }
                else {
                    numSelected++;
                }
            }
            if (numSelected === 0) {
                columns[0].selected = true;
            }
        };
        const maxNumDimensions = (0, seriesTypeMapper_1.getMaxNumCategories)(chartType);
        const maxNumSeries = (0, seriesTypeMapper_1.getMaxNumSeries)(chartType);
        const updateDimensionColState = maxNumDimensions != null && ((0, seriesTypeMapper_1.getMaxNumCategories)(previousChartType) ?? 100) > (maxNumDimensions ?? 100);
        const updateValueColState = maxNumSeries != null && ((0, seriesTypeMapper_1.getMaxNumSeries)(previousChartType) ?? 100) > (maxNumSeries ?? 100);
        if (updateDimensionColState) {
            updateForMax(this.model.dimensionColState, maxNumDimensions);
        }
        if (updateValueColState) {
            updateForMax(this.model.valueColState, maxNumSeries);
        }
        if (updateDimensionColState || updateValueColState) {
            this.model.resetCellRanges(updateDimensionColState, updateValueColState);
            this.setChartRange(true);
        }
    }
    setChartThemeName(chartThemeName, silent) {
        this.model.chartThemeName = chartThemeName;
        if (!silent) {
            this.raiseChartModelUpdateEvent();
        }
    }
    getChartThemeName() {
        return this.model.chartThemeName;
    }
    isPivotChart() {
        return this.model.pivotChart;
    }
    isPivotMode() {
        return this.model.isPivotMode();
    }
    isGrouping() {
        return this.model.isGrouping();
    }
    isCrossFilterChart() {
        return this.model.crossFiltering;
    }
    getThemeNames() {
        return this.gos.get('chartThemes') || exports.DEFAULT_THEMES;
    }
    getThemes() {
        const themeNames = this.getThemeNames();
        return themeNames.map((themeName) => {
            const stockTheme = (0, chartTheme_1.isStockTheme)(themeName, this.agChartsExports._Theme);
            const theme = stockTheme ? themeName : this.chartProxy.lookupCustomChartTheme(themeName);
            return this.agChartsExports._Theme.getChartTheme(theme);
        });
    }
    getPalettes() {
        const themes = this.getThemes();
        return themes.map((theme) => {
            return theme.palette;
        });
    }
    getThemeTemplateParameters() {
        const themes = this.getThemes();
        return themes.map((theme) => {
            return theme.getTemplateParameters();
        });
    }
    getValueColState() {
        return this.model.valueColState.map(this.displayNameMapper.bind(this));
    }
    getSelectedValueColState() {
        return this.getValueColState().filter((cs) => cs.selected);
    }
    getSelectedDimensions() {
        return this.model.getSelectedDimensions();
    }
    displayNameMapper(col) {
        const { column } = col;
        if (column) {
            col.displayName = this.model.getColDisplayName(column, this.model.isPivotMode());
        }
        else {
            const colNames = this.model.colNames[col.colId];
            col.displayName = colNames ? colNames.join(' - ') : this.model.getColDisplayName(column);
        }
        return col;
    }
    getColStateForMenu() {
        return { dimensionCols: this.model.dimensionColState, valueCols: this.getValueColState() };
    }
    setChartRange(silent = false) {
        if (this.rangeSvc && !this.model.suppressChartRanges && !this.model.unlinked) {
            this.rangeSvc.setCellRanges(this.getCellRanges());
        }
        if (!silent) {
            this.raiseChartModelUpdateEvent();
        }
    }
    detachChartRange() {
        // when chart is detached it won't listen to changes from the grid
        this.model.unlinked = !this.model.unlinked;
        if (this.model.unlinked) {
            // remove range from grid
            if (this.rangeSvc) {
                this.rangeSvc.setCellRanges([]);
            }
        }
        else {
            // update chart data may have changed
            this.updateForGridChange();
        }
        this.dispatchLocalEvent({ type: 'chartLinkedChanged' });
    }
    setChartProxy(chartProxy) {
        this.chartProxy = chartProxy;
    }
    getChartProxy() {
        return this.chartProxy;
    }
    isActiveXYChart() {
        return ['scatter', 'bubble'].includes(this.getChartType());
    }
    isChartLinked() {
        return !this.model.unlinked;
    }
    customComboExists() {
        const savedCustomSeriesChartTypes = this.model.comboChartModel.savedCustomSeriesChartTypes;
        return savedCustomSeriesChartTypes && savedCustomSeriesChartTypes.length > 0;
    }
    getSeriesChartTypes() {
        return this.model.comboChartModel.seriesChartTypes;
    }
    isComboChart(chartType) {
        return this.model.isComboChart(chartType);
    }
    updateSeriesChartType(colId, chartType, secondaryAxis) {
        const seriesChartType = this.model.comboChartModel.seriesChartTypes.find((s) => s.colId === colId);
        if (seriesChartType) {
            // once a combo chart has been modified it is now a 'customCombo' chart
            const updateChartType = this.model.chartType !== 'customCombo';
            if (updateChartType) {
                this.model.chartType = 'customCombo';
            }
            const prevSeriesChartType = seriesChartType.chartType;
            if (chartType != null) {
                seriesChartType.chartType = chartType;
            }
            if (secondaryAxis != null) {
                seriesChartType.secondaryAxis = secondaryAxis;
            }
            // replace existing custom series types with this latest version
            this.model.comboChartModel.savedCustomSeriesChartTypes = this.model.comboChartModel.seriesChartTypes;
            // series chart types can be modified, i.e. column chart types should be moved to primary axis
            this.model.comboChartModel.updateSeriesChartTypes();
            this.updateForDataChange();
            if (updateChartType) {
                // update the settings panel by raising an 'chartTypeChanged' event
                this.dispatchLocalEvent({
                    type: 'chartTypeChanged',
                });
            }
            if (prevSeriesChartType !== chartType) {
                // update the format panel by raising an chartSeriesChartTypeChanged event
                this.dispatchLocalEvent({
                    type: 'chartSeriesChartTypeChanged',
                });
            }
            this.raiseChartOptionsChangedEvent();
        }
    }
    getActiveSeriesChartTypes() {
        const selectedColIds = this.getSelectedValueColState().map((c) => c.colId);
        return this.getSeriesChartTypes().filter((s) => selectedColIds.includes(s.colId));
    }
    getChartSeriesTypes(chartType) {
        const targetChartType = chartType ?? this.getChartType();
        return this.isComboChart(targetChartType) ? ['line', 'bar', 'area'] : [(0, seriesTypeMapper_1.getSeriesType)(targetChartType)];
    }
    getChartSeriesType() {
        const seriesChartTypes = this.getSeriesChartTypes();
        if (seriesChartTypes.length === 0) {
            return 'bar';
        }
        const ct = seriesChartTypes[0].chartType;
        if (ct === 'columnLineCombo') {
            return 'bar';
        }
        if (ct === 'areaColumnCombo') {
            return 'area';
        }
        return (0, seriesTypeMapper_1.getSeriesType)(ct);
    }
    getCellRanges() {
        return [this.model.dimensionCellRange, this.model.valueCellRange].filter((r) => r);
    }
    createCellRange(params) {
        return (params.cellRange &&
            this.rangeSvc?.createPartialCellRangeFromRangeParams(params.cellRange, true));
    }
    validUpdateType(params) {
        if (!params.type) {
            (0, ag_grid_community_1._warn)(136);
            return false;
        }
        const chartTypeMap = {
            'Range Chart': () => !this.isPivotChart() && !this.isCrossFilterChart(),
            'Pivot Chart': () => this.isPivotChart(),
            'Cross Filter Chart': () => this.isCrossFilterChart(),
        };
        const currentChartType = Object.keys(chartTypeMap).find((type) => chartTypeMap[type]()) ?? 'Range Chart';
        const valid = params.type === `${currentChartType[0].toLowerCase()}${currentChartType.slice(1).replace(/ /g, '')}Update`;
        if (!valid) {
            (0, ag_grid_community_1._warn)(137, { currentChartType, type: params.type });
        }
        return valid;
    }
    getCellRangeParams() {
        const cellRanges = this.getCellRanges();
        const firstCellRange = cellRanges[0];
        const startRow = (firstCellRange && firstCellRange.startRow) || null;
        const endRow = (firstCellRange && firstCellRange.endRow) || null;
        return {
            rowStartIndex: startRow && startRow.rowIndex,
            rowStartPinned: startRow && startRow.rowPinned,
            rowEndIndex: endRow && endRow.rowIndex,
            rowEndPinned: endRow && endRow.rowPinned,
            columns: cellRanges.reduce((columns, value) => columns.concat(value.columns.map((c) => c.getId())), []),
        };
    }
    setCategoryAxisType(categoryAxisType) {
        this.model.categoryAxisType = categoryAxisType;
        this.raiseChartModelUpdateEvent();
    }
    getSeriesGroupType() {
        return this.model.seriesGroupType ?? this.chartProxy.getSeriesGroupType();
    }
    setSeriesGroupType(seriesGroupType) {
        this.model.seriesGroupType = seriesGroupType;
        this.raiseChartModelUpdateEvent();
    }
    raiseChartModelUpdateEvent() {
        this.dispatchLocalEvent({ type: 'chartModelUpdate' });
        // every model event effectively updates the chart options
        this.raiseChartOptionsChangedEvent();
    }
    raiseChartUpdatedEvent() {
        this.dispatchLocalEvent({ type: 'chartUpdated' });
    }
    raiseChartApiUpdateEvent() {
        this.dispatchLocalEvent({ type: 'chartApiUpdate' });
    }
    raiseChartOptionsChangedEvent() {
        const { chartId, chartType } = this.getChartModel();
        this.eventSvc.dispatchEvent({
            type: 'chartOptionsChanged',
            chartId,
            chartType,
            chartThemeName: this.getChartThemeName(),
            chartOptions: this.chartProxy?.getChartThemeOverrides(),
        });
    }
    raiseChartRangeSelectionChangedEvent() {
        this.eventSvc.dispatchEvent({
            type: 'chartRangeSelectionChanged',
            id: this.model.chartId,
            chartId: this.model.chartId,
            cellRange: this.getCellRangeParams(),
        });
    }
    destroy() {
        super.destroy();
        if (this.rangeSvc) {
            this.rangeSvc.setCellRanges([]);
        }
    }
}
exports.ChartController = ChartController;


/***/ }),

/***/ 7216:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AreaChartProxy = void 0;
const cartesianChartProxy_1 = __webpack_require__(8631);
class AreaChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(params) {
        const axes = [
            {
                type: this.getXAxisType(params),
                position: 'bottom',
            },
            {
                type: 'number',
                position: 'left',
            },
        ];
        // Add a default label formatter to show '%' for normalized charts if none is provided
        if (this.isNormalised()) {
            const numberAxis = axes[1];
            numberAxis.label = { ...numberAxis.label, formatter: (params) => Math.round(params.value) + '%' };
        }
        return axes;
    }
    getSeries(params) {
        const [category] = params.categories;
        const series = params.fields.map((f) => ({
            type: this.standaloneChartType,
            xKey: category.id,
            xName: category.name,
            yKey: f.colId,
            yName: f.displayName,
            normalizedTo: this.chartType === 'normalizedArea' ? 100 : undefined,
            stacked: ['normalizedArea', 'stackedArea'].includes(this.chartType),
        }));
        return this.crossFiltering ? this.extractLineAreaCrossFilterSeries(series, params) : series;
    }
    isNormalised() {
        return !this.crossFiltering && this.chartType === 'normalizedArea';
    }
}
exports.AreaChartProxy = AreaChartProxy;


/***/ }),

/***/ 3116:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BarChartProxy = void 0;
const color_1 = __webpack_require__(3610);
const seriesTypeMapper_1 = __webpack_require__(4237);
const cartesianChartProxy_1 = __webpack_require__(8631);
const HORIZONTAL_CHART_TYPES = new Set(['bar', 'groupedBar', 'stackedBar', 'normalizedBar']);
class BarChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(params) {
        const axes = [
            {
                type: this.getXAxisType(params),
                position: this.isHorizontal() ? 'left' : 'bottom',
            },
            {
                type: 'number',
                position: this.isHorizontal() ? 'bottom' : 'left',
            },
        ];
        // Add a default label formatter to show '%' for normalized charts if none is provided
        if (this.isNormalised()) {
            const numberAxis = axes[1];
            numberAxis.label = { ...numberAxis.label, formatter: (params) => Math.round(params.value) + '%' };
        }
        return axes;
    }
    getSeries(params) {
        const [category] = params.categories;
        const series = params.fields.map((f) => ({
            type: this.standaloneChartType,
            direction: this.isHorizontal() ? 'horizontal' : 'vertical',
            stacked: this.crossFiltering || (0, seriesTypeMapper_1.isStacked)(this.chartType),
            normalizedTo: this.isNormalised() ? 100 : undefined,
            xKey: category.id,
            xName: category.name,
            yKey: f.colId,
            yName: f.displayName,
        }));
        return this.crossFiltering ? this.extractCrossFilterSeries(series) : series;
    }
    extractCrossFilterSeries(series) {
        const palette = this.getChartPalette();
        const updatePrimarySeries = (seriesOptions, index) => {
            return {
                ...seriesOptions,
                highlightStyle: { item: { fill: undefined } },
                fill: palette?.fills?.[index],
                stroke: palette?.strokes?.[index],
                listeners: {
                    nodeClick: this.crossFilterCallback,
                },
            };
        };
        const updateFilteredOutSeries = (seriesOptions) => {
            const yKey = seriesOptions.yKey + '-filtered-out';
            return {
                ...seriesOptions,
                yKey,
                fill: (0, color_1.hexToRGBA)(seriesOptions.fill, '0.3'),
                stroke: (0, color_1.hexToRGBA)(seriesOptions.stroke, '0.3'),
                showInLegend: false,
            };
        };
        const allSeries = [];
        for (let i = 0; i < series.length; i++) {
            const originalSeries = series[i];
            // update primary series
            allSeries.push(updatePrimarySeries(originalSeries, i));
            // add 'filtered-out' series
            allSeries.push(updateFilteredOutSeries(updatePrimarySeries(originalSeries, i)));
        }
        return allSeries;
    }
    isNormalised() {
        const normalisedCharts = ['normalizedColumn', 'normalizedBar'];
        return !this.crossFiltering && normalisedCharts.includes(this.chartType);
    }
    isHorizontal() {
        return HORIZONTAL_CHART_TYPES.has(this.chartType);
    }
}
exports.BarChartProxy = BarChartProxy;


/***/ }),

/***/ 8631:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CartesianChartProxy = void 0;
const chartProxy_1 = __webpack_require__(6738);
class CartesianChartProxy extends chartProxy_1.ChartProxy {
    constructor() {
        super(...arguments);
        this.crossFilteringAllPoints = new Set();
        this.crossFilteringSelectedPoints = [];
    }
    getUpdateOptions(params, commonChartOptions) {
        const axes = this.getAxes(params, commonChartOptions);
        return {
            ...commonChartOptions,
            data: this.getData(params, axes),
            axes,
            series: this.getSeries(params),
        };
    }
    getData(params, axes) {
        const supportsCrossFiltering = ['area', 'line'].includes(this.standaloneChartType);
        return this.crossFiltering && supportsCrossFiltering
            ? this.getCrossFilterData(params)
            : this.getDataTransformedData(params, axes);
    }
    getDataTransformedData(params, axes) {
        // assumed that the first axis is always the "category" axis
        const xAxisType = axes[0].type;
        const { categories, data } = params;
        const [category] = categories;
        switch (xAxisType) {
            case 'category':
                return this.transformCategoryData(data, category.id);
            case 'time':
                return this.transformTimeData(data, category.id);
            default:
                return data;
        }
    }
    getXAxisType(params) {
        if (params.grouping) {
            return 'grouped-category';
        }
        else if (this.isXAxisOfType(params, 'time', (value) => value instanceof Date)) {
            return 'time';
        }
        else if (this.isXAxisOfType(params, 'number')) {
            return 'number';
        }
        return 'category';
    }
    isXAxisOfType(params, type, isInstance) {
        const [category] = params.categories;
        if (category?.chartDataType) {
            return category.chartDataType === type;
        }
        if (!isInstance) {
            return false;
        }
        const testDatum = params.data[0];
        if (!testDatum) {
            return false;
        }
        return isInstance(testDatum[category.id]);
    }
    transformTimeData(data, categoryKey) {
        const firstValue = data[0]?.[categoryKey];
        if (firstValue instanceof Date) {
            return data;
        }
        return data.map((datum) => {
            const value = datum[categoryKey];
            return typeof value === 'string'
                ? {
                    ...datum,
                    [categoryKey]: new Date(value),
                }
                : datum;
        });
    }
    crossFilteringReset() {
        this.crossFilteringSelectedPoints = [];
        this.crossFilteringAllPoints.clear();
    }
    crossFilteringPointSelected(point) {
        return this.crossFilteringSelectedPoints.length == 0 || this.crossFilteringSelectedPoints.includes(point);
    }
    crossFilteringDeselectedPoints() {
        return (this.crossFilteringSelectedPoints.length > 0 &&
            this.crossFilteringAllPoints.size !== this.crossFilteringSelectedPoints.length);
    }
    extractLineAreaCrossFilterSeries(series, params) {
        const [category] = params.categories;
        const getYKey = (yKey) => {
            if (this.standaloneChartType === 'area') {
                const lastSelectedChartId = params.getCrossFilteringContext().lastSelectedChartId;
                return lastSelectedChartId === params.chartId ? yKey + '-total' : yKey;
            }
            return yKey + '-total';
        };
        return series.map((s) => {
            s.yKey = getYKey(s.yKey);
            s.listeners = {
                nodeClick: (e) => {
                    const value = e.datum[s.xKey];
                    const multiSelection = e.event.metaKey || e.event.ctrlKey;
                    this.crossFilteringAddSelectedPoint(multiSelection, value);
                    this.crossFilterCallback(e);
                },
            };
            s.marker = {
                itemStyler: (p) => {
                    const value = p.datum[category.id];
                    return {
                        fill: p.highlighted ? 'yellow' : p.fill,
                        size: p.highlighted ? 14 : this.crossFilteringPointSelected(value) ? 8 : 0,
                    };
                },
            };
            if (this.standaloneChartType === 'area') {
                s.fillOpacity = this.crossFilteringDeselectedPoints() ? 0.3 : 1;
            }
            if (this.standaloneChartType === 'line') {
                s.strokeOpacity = this.crossFilteringDeselectedPoints() ? 0.3 : 1;
            }
            return s;
        });
    }
    getCrossFilterData(params) {
        this.crossFilteringAllPoints.clear();
        const [category] = params.categories;
        const colId = params.fields[0].colId;
        const filteredOutColId = `${colId}-filtered-out`;
        const lastSelectedChartId = params.getCrossFilteringContext().lastSelectedChartId;
        return params.data.map((d) => {
            const value = d[category.id];
            this.crossFilteringAllPoints.add(value);
            const pointSelected = this.crossFilteringPointSelected(value);
            if (this.standaloneChartType === 'area' && lastSelectedChartId === params.chartId) {
                d[`${colId}-total`] = pointSelected ? d[colId] : d[colId] + d[filteredOutColId];
            }
            if (this.standaloneChartType === 'line') {
                d[`${colId}-total`] = pointSelected ? d[colId] : d[colId] + d[filteredOutColId];
            }
            return d;
        });
    }
    crossFilteringAddSelectedPoint(multiSelection, value) {
        multiSelection ? this.crossFilteringSelectedPoints.push(value) : (this.crossFilteringSelectedPoints = [value]);
    }
    isHorizontal(commonChartOptions) {
        const seriesType = this.standaloneChartType;
        if (seriesType !== 'waterfall' && seriesType !== 'box-plot' && seriesType !== 'range-bar') {
            return false;
        }
        const theme = commonChartOptions.theme;
        const isHorizontal = (theme) => {
            const direction = theme?.overrides?.[seriesType]?.series?.direction;
            if (direction != null) {
                return direction === 'horizontal';
            }
            if (typeof theme?.baseTheme === 'object') {
                return isHorizontal(theme.baseTheme);
            }
            return false;
        };
        return isHorizontal(theme);
    }
}
exports.CartesianChartProxy = CartesianChartProxy;


/***/ }),

/***/ 1051:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HistogramChartProxy = void 0;
const cartesianChartProxy_1 = __webpack_require__(8631);
class HistogramChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getSeries(params) {
        const firstField = params.fields[0]; // multiple series are not supported!
        return [
            {
                type: this.standaloneChartType,
                xKey: firstField.colId,
                xName: firstField.displayName,
                yName: this.chartProxyParams.translate('histogramFrequency'),
                areaPlot: false, // only constant width is supported via integrated charts
            },
        ];
    }
    getAxes(_params) {
        return [
            {
                type: 'number',
                position: 'bottom',
            },
            {
                type: 'number',
                position: 'left',
            },
        ];
    }
}
exports.HistogramChartProxy = HistogramChartProxy;


/***/ }),

/***/ 9235:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LineChartProxy = void 0;
const cartesianChartProxy_1 = __webpack_require__(8631);
class LineChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(params) {
        const axes = [
            {
                type: this.getXAxisType(params),
                position: 'bottom',
            },
            {
                type: 'number',
                position: 'left',
            },
        ];
        // Add a default label formatter to show '%' for normalized charts if none is provided
        if (this.isNormalised()) {
            const numberAxis = axes[1];
            numberAxis.label = { ...numberAxis.label, formatter: (params) => Math.round(params.value) + '%' };
        }
        return axes;
    }
    getSeries(params) {
        const [category] = params.categories;
        const stacked = ['normalizedLine', 'stackedLine'].includes(this.chartType);
        const series = params.fields.map((f) => ({
            type: this.standaloneChartType,
            xKey: category.id,
            xName: category.name,
            yKey: f.colId,
            yName: f.displayName,
            normalizedTo: stacked && this.isNormalised() ? 100 : undefined,
            stacked,
        }));
        return this.crossFiltering ? this.extractLineAreaCrossFilterSeries(series, params) : series;
    }
    isNormalised() {
        const normalisedCharts = ['normalizedLine'];
        return !this.crossFiltering && normalisedCharts.includes(this.chartType);
    }
}
exports.LineChartProxy = LineChartProxy;


/***/ }),

/***/ 7015:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScatterChartProxy = void 0;
const chartDataModel_1 = __webpack_require__(8592);
const cartesianChartProxy_1 = __webpack_require__(8631);
class ScatterChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(_params) {
        return [
            {
                type: 'number',
                position: 'bottom',
            },
            {
                type: 'number',
                position: 'left',
            },
        ];
    }
    getSeries(params) {
        const [category] = params.categories;
        const paired = this.isPaired();
        const seriesDefinitions = this.getSeriesDefinitions(params.fields, paired);
        const labelFieldDefinition = category.id === chartDataModel_1.DEFAULT_CHART_CATEGORY ? undefined : category;
        const series = seriesDefinitions.map((seriesDefinition) => {
            if (seriesDefinition?.sizeField) {
                const opts = {
                    type: 'bubble',
                    xKey: seriesDefinition.xField.colId,
                    xName: seriesDefinition.xField.displayName ?? undefined,
                    yKey: seriesDefinition.yField.colId,
                    yName: seriesDefinition.yField.displayName ?? undefined,
                    title: `${seriesDefinition.yField.displayName} vs ${seriesDefinition.xField.displayName}`,
                    sizeKey: seriesDefinition.sizeField.colId,
                    sizeName: seriesDefinition.sizeField.displayName ?? '',
                    labelKey: labelFieldDefinition ? labelFieldDefinition.id : seriesDefinition.yField.colId,
                    labelName: labelFieldDefinition ? labelFieldDefinition.name : undefined,
                };
                return opts;
            }
            const opts = {
                type: 'scatter',
                xKey: seriesDefinition.xField.colId,
                xName: seriesDefinition.xField.displayName ?? undefined,
                yKey: seriesDefinition.yField.colId,
                yName: seriesDefinition.yField.displayName ?? undefined,
                title: `${seriesDefinition.yField.displayName} vs ${seriesDefinition.xField.displayName}`,
                labelKey: labelFieldDefinition ? labelFieldDefinition.id : seriesDefinition.yField.colId,
                labelName: labelFieldDefinition ? labelFieldDefinition.name : undefined,
            };
            return opts;
        });
        return this.crossFiltering ? this.extractCrossFilterSeries(series, params) : series;
    }
    extractCrossFilterSeries(series, params) {
        const { data } = params;
        const palette = this.getChartPalette();
        const filteredOutKey = (key) => `${key}-filtered-out`;
        const calcMarkerDomain = (data, sizeKey) => {
            const markerDomain = [Infinity, -Infinity];
            if (sizeKey != null) {
                for (const datum of data) {
                    const value = datum[sizeKey] ?? datum[filteredOutKey(sizeKey)];
                    if (value < markerDomain[0]) {
                        markerDomain[0] = value;
                    }
                    if (value > markerDomain[1]) {
                        markerDomain[1] = value;
                    }
                }
            }
            if (markerDomain[0] <= markerDomain[1]) {
                return markerDomain;
            }
            return undefined;
        };
        const updatePrimarySeries = (series, idx) => {
            const fill = palette?.fills?.[idx];
            const stroke = palette?.strokes?.[idx];
            let markerDomain = undefined;
            if (series.type === 'bubble') {
                const { sizeKey } = series;
                markerDomain = calcMarkerDomain(data, sizeKey);
            }
            return {
                ...series,
                fill,
                stroke,
                domain: markerDomain,
                highlightStyle: { item: { fill: 'yellow' } },
                listeners: {
                    ...series.listeners,
                    nodeClick: this.crossFilterCallback,
                },
            };
        };
        const updateFilteredOutSeries = (series) => {
            const { yKey, xKey } = series;
            let alteredSizeKey = {};
            if (series.type === 'bubble') {
                alteredSizeKey = { sizeKey: filteredOutKey(series.sizeKey) };
            }
            return {
                ...series,
                ...alteredSizeKey,
                yKey: filteredOutKey(yKey),
                xKey: filteredOutKey(xKey),
                fillOpacity: 0.3,
                strokeOpacity: 0.3,
                showInLegend: false,
                listeners: {
                    ...series.listeners,
                    nodeClick: (e) => {
                        const value = e.datum[filteredOutKey(xKey)];
                        // Need to remove the `-filtered-out` suffixes from the event so that
                        // upstream processing maps the event correctly onto grid column ids.
                        const filterableEvent = {
                            ...e,
                            xKey,
                            datum: { ...e.datum, [xKey]: value },
                        };
                        this.crossFilterCallback(filterableEvent);
                    },
                },
            };
        };
        const updatedSeries = series.map(updatePrimarySeries);
        return [...updatedSeries, ...updatedSeries.map(updateFilteredOutSeries)];
    }
    getSeriesDefinitions(fields, paired) {
        if (fields.length < 2) {
            return [];
        }
        const isBubbleChart = this.chartType === 'bubble';
        if (paired) {
            if (isBubbleChart) {
                return fields
                    .map((currentXField, i) => i % 3 === 0
                    ? {
                        xField: currentXField,
                        yField: fields[i + 1],
                        sizeField: fields[i + 2],
                    }
                    : null)
                    .filter((x) => x && x.yField && x.sizeField);
            }
            return fields
                .map((currentXField, i) => i % 2 === 0
                ? {
                    xField: currentXField,
                    yField: fields[i + 1],
                }
                : null)
                .filter((x) => x && x.yField);
        }
        const xField = fields[0];
        if (isBubbleChart) {
            return fields
                .map((yField, i) => i % 2 === 1
                ? {
                    xField,
                    yField,
                    sizeField: fields[i + 1],
                }
                : null)
                .filter((x) => x && x.sizeField);
        }
        return fields.filter((value, i) => i > 0).map((yField) => ({ xField, yField }));
    }
}
exports.ScatterChartProxy = ScatterChartProxy;


/***/ }),

/***/ 9303:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WaterfallChartProxy = void 0;
const cartesianChartProxy_1 = __webpack_require__(8631);
class WaterfallChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(params, commonChartOptions) {
        return [
            {
                type: this.getXAxisType(params),
                position: this.isHorizontal(commonChartOptions) ? 'left' : 'bottom',
            },
            {
                type: 'number',
                position: this.isHorizontal(commonChartOptions) ? 'bottom' : 'left',
            },
        ];
    }
    getSeries(params) {
        const [category] = params.categories;
        const [firstField] = params.fields;
        const firstSeries = {
            type: this.standaloneChartType,
            xKey: category.id,
            xName: category.name,
            yKey: firstField.colId,
            yName: firstField.displayName ?? undefined,
        };
        return [firstSeries]; // waterfall only supports a single series!
    }
}
exports.WaterfallChartProxy = WaterfallChartProxy;


/***/ }),

/***/ 6738:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartProxy = void 0;
const integration_1 = __webpack_require__(9687);
const object_1 = __webpack_require__(2210);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartTheme_1 = __webpack_require__(8987);
class ChartProxy {
    constructor(chartProxyParams) {
        this.chartProxyParams = chartProxyParams;
        this.clearThemeOverrides = false;
        this.agChartsExports = chartProxyParams.agChartsExports;
        this.chart = chartProxyParams.chartInstance;
        this.chartType = chartProxyParams.chartType;
        this.crossFiltering = chartProxyParams.crossFiltering;
        this.crossFilterCallback = chartProxyParams.crossFilterCallback;
        this.standaloneChartType = (0, seriesTypeMapper_1.getSeriesType)(this.chartType);
        if (this.chart == null) {
            this.chart = chartProxyParams.agChartsExports.create(this.getCommonChartOptions());
        }
        else {
            // On chart change, reset formatting panel changes.
            this.clearThemeOverrides = true;
        }
    }
    crossFilteringReset() {
        // only required in cartesian charts
    }
    update(params) {
        this.getChartRef().update(this.getUpdateOptions(params, this.getCommonChartOptions(params.updatedOverrides)));
    }
    updateThemeOverrides(themeOverrides) {
        this.getChartRef().updateDelta({ theme: { overrides: themeOverrides } });
    }
    getChart() {
        return (0, integration_1.deproxy)(this.chart);
    }
    getChartRef() {
        return this.chart;
    }
    downloadChart(dimensions, fileName, fileFormat) {
        const { chart } = this;
        const rawChart = (0, integration_1.deproxy)(chart);
        const imageFileName = fileName || (rawChart.title ? rawChart.title.text : 'chart');
        const { width, height } = dimensions || {};
        chart.download({ width, height, fileName: imageFileName, fileFormat });
    }
    getChartImageDataURL(type) {
        return this.getChart().getCanvasDataURL(type);
    }
    getChartOptions() {
        return this.chart.getOptions();
    }
    getChartThemeOverrides() {
        const chartOptionsTheme = this.getChartOptions().theme;
        return chartOptionsTheme.overrides ?? {};
    }
    getChartPalette() {
        return this.agChartsExports._Theme.getChartTheme(this.getChartOptions().theme).palette;
    }
    setPaired(paired) {
        // Special handling to make scatter charts operate in paired mode by default, where
        // columns alternate between being X and Y (and size for bubble). In standard mode,
        // the first column is used for X and every other column is treated as Y
        // (or alternates between Y and size for bubble)
        const seriesType = (0, seriesTypeMapper_1.getSeriesType)(this.chartProxyParams.chartType);
        this.chart.updateDelta({ theme: { overrides: { [seriesType]: { paired } } } });
    }
    isPaired() {
        const seriesType = (0, seriesTypeMapper_1.getSeriesType)(this.chartProxyParams.chartType);
        return (0, object_1.get)(this.getChartThemeOverrides(), `${seriesType}.paired`, true);
    }
    lookupCustomChartTheme(themeName) {
        return (0, chartTheme_1.lookupCustomChartTheme)(this.chartProxyParams, themeName);
    }
    getSeriesGroupType() {
        return undefined;
    }
    transformCategoryData(data, categoryKey) {
        // replace the values for the selected category with a complex object to allow for duplicated categories
        return data.map((d, index) => {
            const value = d[categoryKey];
            const valueString = value && value.toString ? value.toString() : '';
            const datum = { ...d };
            datum[categoryKey] = { id: index, value, toString: () => valueString };
            return datum;
        });
    }
    getCommonChartOptions(updatedOverrides) {
        // Only apply active overrides if chart is initialised.
        const existingOptions = (this.clearThemeOverrides ? {} : this.chart?.getOptions() ?? {});
        const formattingPanelOverrides = this.chart != null ? this.getActiveFormattingPanelOverrides() : undefined;
        this.clearThemeOverrides = false;
        const theme = (0, chartTheme_1.createAgChartTheme)(this.chartProxyParams, this, this.agChartsExports.isEnterprise, this.getChartThemeDefaults(), updatedOverrides ?? formattingPanelOverrides);
        const newOptions = {
            ...existingOptions,
            mode: 'integrated',
        };
        newOptions.theme = theme;
        newOptions.container = this.chartProxyParams.parentElement;
        return newOptions;
    }
    getChartThemeDefaults() {
        const seriesOverrides = this.getSeriesChartThemeDefaults();
        const seriesChartOptions = seriesOverrides
            ? {
                [this.standaloneChartType]: seriesOverrides,
            }
            : {};
        const crosshair = {
            enabled: true,
            snap: true,
            label: {
                enabled: false,
            },
        };
        const common = this.agChartsExports.isEnterprise
            ? {
                zoom: {
                    enabled: true,
                },
                animation: {
                    enabled: true,
                    duration: 500,
                },
                axes: {
                    number: { crosshair },
                    category: { crosshair },
                    log: { crosshair },
                    time: { crosshair },
                },
            }
            : {};
        common.minHeight = 0;
        common.minWidth = 0;
        common.navigator = {
            enabled: false,
        };
        return {
            common,
            ...seriesChartOptions,
        };
    }
    getSeriesChartThemeDefaults() {
        return undefined;
    }
    getActiveFormattingPanelOverrides() {
        if (this.clearThemeOverrides) {
            return {};
        }
        const inUseTheme = this.chart?.getOptions().theme;
        return inUseTheme?.overrides ?? {};
    }
    destroy({ keepChartInstance = false } = {}) {
        if (keepChartInstance) {
            // Reset Charts animation state, so that future updates to this re-used chart instance
            // behave as-if the chart is brand new. When switching chartTypes, this means we hide
            // the fact we are reusing the chart instance; the user sees a new chart which behaves
            // as-if it is a completely new and distinct chart instance.
            this.chart.resetAnimations();
            return this.chart;
        }
        this.destroyChart();
    }
    destroyChart() {
        if (this.chart) {
            this.chart.destroy();
            this.chart = undefined;
        }
    }
}
exports.ChartProxy = ChartProxy;


/***/ }),

/***/ 8987:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.lookupCustomChartTheme = exports.isStockTheme = exports.createAgChartTheme = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const axisTypeMapper_1 = __webpack_require__(2753);
const object_1 = __webpack_require__(2210);
const seriesTypeMapper_1 = __webpack_require__(4237);
function createAgChartTheme(chartProxyParams, proxy, isEnterprise, chartThemeDefaults, updatedOverrides) {
    const { chartOptionsToRestore, chartPaletteToRestore, chartThemeToRestore, agChartsExports } = chartProxyParams;
    const themeName = getSelectedTheme(chartProxyParams);
    const stockTheme = isStockTheme(themeName, agChartsExports._Theme);
    const rootTheme = stockTheme
        ? { baseTheme: themeName }
        : lookupCustomChartTheme(chartProxyParams, themeName) ?? {};
    const gridOptionsThemeOverrides = chartProxyParams.getGridOptionsChartThemeOverrides();
    const apiThemeOverrides = chartProxyParams.apiChartThemeOverrides;
    const standaloneChartType = (0, seriesTypeMapper_1.getSeriesType)(chartProxyParams.chartType);
    const crossFilteringOverrides = chartProxyParams.crossFiltering
        ? createCrossFilterThemeOverrides(proxy, chartProxyParams, standaloneChartType)
        : undefined;
    const isTitleEnabled = () => {
        const isTitleEnabled = (obj) => {
            if (!obj) {
                return false;
            }
            return Object.keys(obj).some((key) => (0, object_1.get)(obj[key], 'title.enabled', false));
        };
        return isTitleEnabled(gridOptionsThemeOverrides) || isTitleEnabled(apiThemeOverrides);
    };
    // Overrides in ascending precedence ordering.
    const overrides = [
        stockTheme ? inbuiltStockThemeOverrides(chartProxyParams, isEnterprise, isTitleEnabled()) : undefined,
        pieAndDonutOverrides(),
        chartThemeDefaults,
        crossFilteringOverrides,
        gridOptionsThemeOverrides,
        apiThemeOverrides,
        { ...(chartOptionsToRestore ?? {}) },
        updatedOverrides,
    ];
    // Recursively nest theme overrides so they are applied with correct precedence in
    // Standalone Charts - this is an undocumented feature.
    // Outermost theme overrides will be the formatting panel configured values, so they are
    // differentiated from grid-config and inbuilt overrides.
    const theme = overrides
        .filter((v) => !!v)
        .reduce((r, n) => ({
        baseTheme: r,
        overrides: n,
    }), rootTheme);
    // Avoid explicitly setting the `theme.palette` property unless we're using the restored theme
    // AND the palette is actually different.
    if (chartPaletteToRestore && themeName === chartThemeToRestore) {
        const rootThemePalette = chartProxyParams.agChartsExports._Theme.getChartTheme(rootTheme).palette;
        if (!isIdenticalPalette(chartPaletteToRestore, rootThemePalette)) {
            theme.palette = chartPaletteToRestore;
        }
    }
    return theme;
}
exports.createAgChartTheme = createAgChartTheme;
function isIdenticalPalette(paletteA, paletteB) {
    const arrayCompare = (arrA, arrB) => {
        if (arrA === arrB)
            return true;
        if (arrA?.length !== arrB?.length)
            return false;
        return arrA?.every((v, i) => v === arrB?.[i]) ?? false;
    };
    return arrayCompare(paletteA.fills, paletteB.fills) && arrayCompare(paletteA.strokes, paletteB.strokes);
}
function isStockTheme(themeName, theme) {
    return Object.keys(theme.themes).includes(themeName);
}
exports.isStockTheme = isStockTheme;
function createCrossFilterThemeOverrides(proxy, chartProxyParams, seriesType) {
    const legend = {
        listeners: {
            legendItemClick: (e) => {
                const chart = proxy.getChart();
                const eligibleSeriesIds = [e.seriesId, `${e.seriesId}-filtered-out`];
                chart.series
                    .filter((s) => eligibleSeriesIds.includes(s.id))
                    .forEach((s) => s.toggleSeriesItem(undefined, 'category', e.itemId, undefined));
            },
        },
    };
    return {
        [seriesType]: {
            tooltip: {
                delay: 500,
            },
            legend,
            listeners: {
                click: (e) => chartProxyParams.crossFilterCallback(e, true),
            },
        },
    };
}
const STATIC_INBUILT_STOCK_THEME_AXES_OVERRIDES = axisTypeMapper_1.ALL_AXIS_TYPES.reduce((r, n) => ({ ...r, [n]: { title: { _enabledFromTheme: true } } }), {});
function inbuiltStockThemeOverrides(params, isEnterprise, titleEnabled) {
    const extraPadding = params.getExtraPaddingDirections();
    return {
        common: {
            ...(isEnterprise ? { animation: { duration: 500 } } : undefined),
            axes: STATIC_INBUILT_STOCK_THEME_AXES_OVERRIDES,
            padding: {
                // don't add extra padding when a title is present!
                top: !titleEnabled && extraPadding.includes('top') ? 40 : 20,
                right: extraPadding.includes('right') ? 30 : 20,
                bottom: extraPadding.includes('bottom') ? 40 : 20,
                left: extraPadding.includes('left') ? 30 : 20,
            },
            suppressFieldDotNotation: true,
        },
    };
}
function pieAndDonutOverrides() {
    return {
        pie: {
            series: {
                title: { _enabledFromTheme: true },
                calloutLabel: { _enabledFromTheme: true },
                sectorLabel: {
                    enabled: false,
                    _enabledFromTheme: true,
                },
            },
        },
        donut: {
            series: {
                title: { _enabledFromTheme: true },
                calloutLabel: { _enabledFromTheme: true },
                sectorLabel: {
                    enabled: false,
                    _enabledFromTheme: true,
                },
            },
        },
    };
}
function getSelectedTheme(chartProxyParams) {
    let chartThemeName = chartProxyParams.getChartThemeName();
    const availableThemes = chartProxyParams.getChartThemes();
    if (!availableThemes.includes(chartThemeName)) {
        chartThemeName = availableThemes[0];
    }
    return chartThemeName;
}
function lookupCustomChartTheme(chartProxyParams, name) {
    const { customChartThemes } = chartProxyParams;
    const customChartTheme = customChartThemes && customChartThemes[name];
    if (!customChartTheme) {
        (0, ag_grid_community_1._warn)(140, { name });
    }
    return customChartTheme;
}
exports.lookupCustomChartTheme = lookupCustomChartTheme;


/***/ }),

/***/ 8995:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComboChartProxy = void 0;
const seriesTypeMapper_1 = __webpack_require__(4237);
const cartesianChartProxy_1 = __webpack_require__(8631);
class ComboChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(params) {
        const fields = params ? params.fields : [];
        const fieldsMap = new Map(fields.map((f) => [f.colId, f]));
        const { primaryYKeys, secondaryYKeys } = this.getYKeys(fields, params.seriesChartTypes);
        const axes = [
            {
                type: this.getXAxisType(params),
                position: 'bottom',
            },
        ];
        if (primaryYKeys.length > 0) {
            axes.push({
                type: 'number',
                keys: primaryYKeys,
                position: 'left',
            });
        }
        if (secondaryYKeys.length > 0) {
            secondaryYKeys.forEach((secondaryYKey) => {
                const field = fieldsMap.get(secondaryYKey);
                const secondaryAxisIsVisible = field && field.colId === secondaryYKey;
                if (!secondaryAxisIsVisible) {
                    return;
                }
                const secondaryAxisOptions = {
                    type: 'number',
                    keys: [secondaryYKey],
                    position: 'right',
                };
                axes.push(secondaryAxisOptions);
            });
        }
        return axes;
    }
    getSeries(params) {
        const { fields, seriesChartTypes } = params;
        const [category] = params.categories;
        return fields.map((field) => {
            const seriesChartType = seriesChartTypes.find((s) => s.colId === field.colId);
            if (seriesChartType) {
                const chartType = seriesChartType.chartType;
                const grouped = ['groupedColumn', 'groupedBar'].includes(chartType);
                const groupedOpts = grouped ? { grouped: true } : {};
                return {
                    type: (0, seriesTypeMapper_1.getSeriesType)(chartType),
                    xKey: category.id,
                    yKey: field.colId,
                    yName: field.displayName,
                    stacked: ['stackedArea', 'stackedColumn'].includes(chartType),
                    ...groupedOpts,
                };
            }
        });
    }
    getYKeys(fields, seriesChartTypes) {
        const primaryYKeys = [];
        const secondaryYKeys = [];
        fields.forEach((field) => {
            const colId = field.colId;
            const seriesChartType = seriesChartTypes.find((s) => s.colId === colId);
            if (seriesChartType) {
                seriesChartType.secondaryAxis ? secondaryYKeys.push(colId) : primaryYKeys.push(colId);
            }
        });
        return { primaryYKeys, secondaryYKeys };
    }
}
exports.ComboChartProxy = ComboChartProxy;


/***/ }),

/***/ 7879:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnterpriseChartProxyFactory = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const histogramChartProxy_1 = __webpack_require__(1051);
const waterfallChartProxy_1 = __webpack_require__(9303);
const funnelChartProxy_1 = __webpack_require__(2817);
const hierarchicalChartProxy_1 = __webpack_require__(3511);
const polarChartProxy_1 = __webpack_require__(9899);
const heatmapChartProxy_1 = __webpack_require__(7562);
const boxPlotChartProxy_1 = __webpack_require__(5413);
const rangeChartProxy_1 = __webpack_require__(6926);
class EnterpriseChartProxyFactory extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'enterpriseChartProxyFactory';
    }
    createChartProxy(chartProxyParams) {
        switch (chartProxyParams.chartType) {
            case 'histogram':
                return new histogramChartProxy_1.HistogramChartProxy(chartProxyParams);
            case 'radarLine':
            case 'radarArea':
            case 'nightingale':
            case 'radialColumn':
            case 'radialBar':
                return new polarChartProxy_1.PolarChartProxy(chartProxyParams);
            case 'rangeBar':
            case 'rangeArea':
                return new rangeChartProxy_1.RangeChartProxy(chartProxyParams);
            case 'boxPlot':
                return new boxPlotChartProxy_1.BoxPlotChartProxy(chartProxyParams);
            case 'treemap':
            case 'sunburst':
                return new hierarchicalChartProxy_1.HierarchicalChartProxy(chartProxyParams);
            case 'heatmap':
                return new heatmapChartProxy_1.HeatmapChartProxy(chartProxyParams);
            case 'waterfall':
                return new waterfallChartProxy_1.WaterfallChartProxy(chartProxyParams);
            case 'funnel':
            case 'coneFunnel':
            case 'pyramid':
                return new funnelChartProxy_1.FunnelChartProxy(chartProxyParams);
        }
        return undefined;
    }
}
exports.EnterpriseChartProxyFactory = EnterpriseChartProxyFactory;


/***/ }),

/***/ 2817:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FunnelChartProxy = void 0;
const chartProxy_1 = __webpack_require__(6738);
class FunnelChartProxy extends chartProxy_1.ChartProxy {
    getUpdateOptions(params, commonChartOptions) {
        return {
            ...commonChartOptions,
            data: this.transformFunnelCategories(params),
            series: this.getSeries(params),
        };
    }
    transformFunnelCategories(params) {
        const { data } = params;
        const [{ id }] = params.categories;
        return data.map((d, index) => ({
            ...d,
            [id]: {
                name: d[id],
                id: index,
                toString: () => d[id],
            },
        }));
    }
    getSeriesChartThemeDefaults() {
        const config = {
            crosshair: {
                enabled: false,
            },
        };
        return {
            axes: {
                category: config,
                number: config,
            },
        };
    }
    getSeries(params) {
        const [{ id }] = params.categories;
        const [{ colId }] = params.fields;
        const series = {
            type: this.standaloneChartType,
            stageKey: id,
            valueKey: colId,
        };
        return [series];
    }
}
exports.FunnelChartProxy = FunnelChartProxy;


/***/ }),

/***/ 3511:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HierarchicalChartProxy = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const chartProxy_1 = __webpack_require__(6738);
const hierarchicalChartUtils_1 = __webpack_require__(6326);
class HierarchicalChartProxy extends chartProxy_1.ChartProxy {
    getUpdateOptions(params, commonChartOptions) {
        const { fields } = params;
        // Hierarchical charts support up to two input series, corresponding to size and color respectively
        const [sizeField, colorField] = fields;
        return {
            ...commonChartOptions,
            series: this.getSeries(sizeField, colorField),
            data: this.getData(params, sizeField, colorField),
        };
    }
    getSeriesChartThemeDefaults() {
        return {
            gradientLegend: {
                gradient: {
                    preferredLength: 200,
                },
            },
        };
    }
    getSeries(sizeField, colorField) {
        return [
            {
                type: this.standaloneChartType,
                labelKey: hierarchicalChartUtils_1.CATEGORY_LABEL_KEY,
                // Size and color fields are inferred from the range data
                sizeKey: sizeField?.colId,
                sizeName: sizeField?.displayName ?? undefined,
                colorKey: colorField?.colId,
                colorName: colorField?.displayName ?? undefined,
            },
        ];
    }
    getData(params, sizeField, colorField) {
        const { categories, data, groupData, grouping: isGrouped } = params;
        if (isGrouped) {
            const processedData = colorField
                ? data.concat(groupData?.map((groupDatum) => {
                    const newDatum = { ...groupDatum };
                    delete newDatum[sizeField.colId];
                    return newDatum;
                }) ?? [])
                : data;
            return (0, hierarchicalChartUtils_1.createAutoGroupHierarchy)(processedData, (item) => item[ag_grid_community_1.GROUP_AUTO_COLUMN_ID]?.labels ?? null);
        }
        else {
            const categoryKeys = categories.map(({ id }) => id);
            return (0, hierarchicalChartUtils_1.createCategoryHierarchy)(data, categoryKeys);
        }
    }
}
exports.HierarchicalChartProxy = HierarchicalChartProxy;


/***/ }),

/***/ 6326:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createAutoGroupHierarchy = exports.createCategoryHierarchy = exports.CATEGORY_LABEL_KEY = void 0;
exports.CATEGORY_LABEL_KEY = 'AG-GRID-DEFAULT-LABEL-KEY';
function createCategoryHierarchy(data, categoryKeys) {
    const hierarchy = buildNestedHierarchy(data, getItemDepth, getItemCategoryLabel);
    return formatCategoryHierarchy(hierarchy);
    function getItemDepth(_item) {
        return categoryKeys.length;
    }
    function getItemCategoryLabel(item, categoryIndex) {
        const categoryKey = categoryKeys[categoryIndex];
        const categoryValue = item[categoryKey];
        return getCategoryLabel(categoryValue);
    }
    function getCategoryLabel(value) {
        if (value == null)
            return null;
        return String(value);
    }
}
exports.createCategoryHierarchy = createCategoryHierarchy;
function createAutoGroupHierarchy(data, getItemLabels) {
    const hierarchy = buildNestedHierarchy(data, getItemDepth, getItemGroupLabel);
    return formatCategoryHierarchy(hierarchy);
    function getItemDepth(item) {
        return getItemLabels(item)?.length ?? 0;
    }
    function getItemGroupLabel(item, groupIndex) {
        const labels = getItemLabels(item);
        if (!labels)
            return null;
        // Autogroup label values are ordered from the leaf outwards
        const labelIndex = labels.length - 1 - groupIndex;
        return labels[labelIndex];
    }
}
exports.createAutoGroupHierarchy = createAutoGroupHierarchy;
/* Utility functions for building and formatting nested category hierarchies */
/** Convert an abstract nested hierarchy structure into an ag-charts-compatible 'category-grouped' data structure */
function formatCategoryHierarchy(hierarchy, key = null, isChild) {
    const { depth, rootValues, value, children: inputChildren } = hierarchy;
    if (rootValues) {
        return rootValues.map((item) => ({ [exports.CATEGORY_LABEL_KEY]: key, ...item }));
    }
    else if (depth === 0) {
        return [{ [exports.CATEGORY_LABEL_KEY]: key, ...value }];
    }
    const children = [];
    for (const [childKey, childHierarchy] of inputChildren.entries()) {
        children.push(...formatCategoryHierarchy(childHierarchy, childKey, true));
    }
    return isChild
        ? [
            {
                [exports.CATEGORY_LABEL_KEY]: key,
                children,
                ...(value ?? {}),
            },
        ]
        : children;
}
/** Build an arbitrarily deeply nested hierarchy from a flat list of input items */
function buildNestedHierarchy(data, getItemDepth, getItemGroupKey) {
    const hierarchy = { depth: 0, children: new Map() };
    data.forEach((item) => {
        const itemDepth = getItemDepth(item);
        createNestedItemHierarchy(item, itemDepth, getItemGroupKey, 0, hierarchy);
    });
    return hierarchy;
    function createNestedItemHierarchy(item, itemDepth, getItemGroupKey, currentDepth, hierarchy) {
        if (currentDepth === itemDepth) {
            if (currentDepth === 0) {
                if (!hierarchy.rootValues) {
                    hierarchy.rootValues = [];
                }
                hierarchy.rootValues.push(item);
            }
            else {
                hierarchy.value = item;
            }
            return hierarchy;
        }
        else {
            const key = getItemGroupKey(item, currentDepth);
            const existingChildHierarchy = hierarchy.children.get(key);
            const childHierarchy = createNestedItemHierarchy(item, itemDepth, getItemGroupKey, currentDepth + 1, existingChildHierarchy || { depth: 0, children: new Map() });
            hierarchy.children.set(key, childHierarchy);
            hierarchy.depth = Math.max(1 + childHierarchy.depth, hierarchy.depth);
            return hierarchy;
        }
    }
}


/***/ }),

/***/ 4104:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PieChartProxy = void 0;
const chartProxy_1 = __webpack_require__(6738);
function calculateOffsets(offset) {
    const outerRadiusOffset = offset.currentOffset;
    offset.currentOffset -= offset.offsetAmount;
    const innerRadiusOffset = offset.currentOffset;
    offset.currentOffset -= offset.offsetAmount;
    return { outerRadiusOffset, innerRadiusOffset };
}
class PieChartProxy extends chartProxy_1.ChartProxy {
    getUpdateOptions(params, commonChartOptions) {
        return {
            ...commonChartOptions,
            data: this.crossFiltering ? this.getCrossFilterData(params) : params.data,
            series: this.getSeries(params),
        };
    }
    getSeries(params) {
        const [category] = params.categories;
        const numFields = params.fields.length;
        const offset = {
            currentOffset: 0,
            offsetAmount: numFields > 1 ? 20 : 40,
        };
        const series = this.getFields(params).map((f) => {
            // options shared by 'pie' and 'donut' charts
            const options = {
                type: this.standaloneChartType,
                angleKey: f.colId,
                angleName: f.displayName,
                sectorLabelKey: f.colId,
                calloutLabelName: category.name,
                calloutLabelKey: category.id,
            };
            if (this.chartType === 'donut' || this.chartType === 'doughnut') {
                const { outerRadiusOffset, innerRadiusOffset } = calculateOffsets(offset);
                const title = f.displayName
                    ? {
                        title: { text: f.displayName, showInLegend: numFields > 1 },
                    }
                    : undefined;
                // augment shared options with 'donut' specific options
                return {
                    ...options,
                    type: 'donut',
                    outerRadiusOffset,
                    innerRadiusOffset,
                    ...title,
                    calloutLine: {
                        colors: this.getChartPalette()?.strokes,
                    },
                };
            }
            return options;
        });
        return this.crossFiltering ? this.extractCrossFilterSeries(series) : series;
    }
    getCrossFilterData(params) {
        const colId = params.fields[0].colId;
        const filteredOutColId = `${colId}-filtered-out`;
        return params.data.map((d) => {
            const total = d[colId] + d[filteredOutColId];
            d[`${colId}-total`] = total;
            d[filteredOutColId] = 1; // normalise to 1
            d[colId] = d[colId] / total; // fraction of 1
            return d;
        });
    }
    extractCrossFilterSeries(series) {
        const palette = this.getChartPalette();
        const primaryOptions = (seriesOptions) => {
            return {
                ...seriesOptions,
                legendItemKey: seriesOptions.calloutLabelKey,
                calloutLabel: { enabled: false },
                highlightStyle: { item: { fill: undefined } },
                radiusKey: seriesOptions.angleKey,
                angleKey: seriesOptions.angleKey + '-total',
                radiusMin: 0,
                radiusMax: 1,
                listeners: {
                    nodeClick: this.crossFilterCallback,
                },
            };
        };
        const filteredOutOptions = (seriesOptions, angleKey) => {
            return {
                ...primaryOpts,
                radiusKey: angleKey + '-filtered-out',
                fills: this.changeOpacity(seriesOptions.fills ?? palette?.fills ?? [], 0.3),
                strokes: this.changeOpacity(seriesOptions.strokes ?? palette?.strokes ?? [], 0.3),
                showInLegend: false,
            };
        };
        // currently, only single 'donut' cross-filter series are supported
        const primarySeries = series[0];
        // update primary series
        const angleKey = primarySeries.angleKey;
        const primaryOpts = primaryOptions(primarySeries);
        return [filteredOutOptions(primaryOptions(primarySeries), angleKey), primaryOpts];
    }
    getFields(params) {
        // pie charts only support a single series, donut charts support multiple series
        return this.chartType === 'pie' ? params.fields.slice(0, 1) : params.fields;
    }
    changeOpacity(fills, alpha) {
        const Color = this.agChartsExports._Util.Color;
        return fills.map((fill) => {
            const c = Color.fromString(fill);
            return new Color(c.r, c.g, c.b, alpha).toHexString();
        });
    }
}
exports.PieChartProxy = PieChartProxy;


/***/ }),

/***/ 9899:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PolarChartProxy = void 0;
const chartProxy_1 = __webpack_require__(6738);
class PolarChartProxy extends chartProxy_1.ChartProxy {
    getAxes(_) {
        const radialBar = this.standaloneChartType === 'radial-bar';
        return [
            { type: radialBar ? 'angle-number' : 'angle-category' },
            { type: radialBar ? 'radius-category' : 'radius-number' },
        ];
    }
    getSeries(params) {
        const { fields, categories, seriesGroupType } = params;
        const [category] = categories;
        const radialBar = this.standaloneChartType === 'radial-bar';
        const seriesGroupTypeOptions = this.getSeriesGroupTypeOptions(seriesGroupType);
        return fields.map((f) => ({
            type: this.standaloneChartType,
            angleKey: radialBar ? f.colId : category.id,
            angleName: radialBar ? f.displayName ?? undefined : category.name,
            radiusKey: radialBar ? category.id : f.colId,
            radiusName: radialBar ? category.name : f.displayName ?? undefined,
            ...seriesGroupTypeOptions,
        }));
    }
    getSeriesGroupType() {
        const standaloneChartType = this.standaloneChartType;
        if (!['nightingale', 'radial-bar', 'radial-column'].includes(standaloneChartType)) {
            return undefined;
        }
        const firstSeriesProperties = this.getChart().series?.[0]?.properties.toJson();
        const getStackedValue = () => (firstSeriesProperties.normalizedTo ? 'normalized' : 'stacked');
        if (standaloneChartType === 'nightingale') {
            return firstSeriesProperties.grouped ? 'grouped' : getStackedValue();
        }
        else {
            return firstSeriesProperties.stacked ? getStackedValue() : 'grouped';
        }
    }
    getUpdateOptions(params, commonChartOptions) {
        const axes = this.getAxes(params);
        return {
            ...commonChartOptions,
            data: this.getData(params, axes),
            axes,
            series: this.getSeries(params),
        };
    }
    getData(params, axes) {
        const isCategoryAxis = axes.some((axis) => axis.type === 'angle-category' || axis.type === 'radius-category');
        if (isCategoryAxis) {
            const [category] = params.categories;
            return this.transformCategoryData(params.data, category.id);
        }
        else {
            return params.data;
        }
    }
    getSeriesGroupTypeOptions(seriesGroupType) {
        if (!seriesGroupType) {
            return {};
        }
        return {
            grouped: seriesGroupType === 'grouped' || undefined,
            stacked: seriesGroupType !== 'grouped' || undefined,
            normalizedTo: seriesGroupType === 'normalized' ? 100 : undefined,
        };
    }
}
exports.PolarChartProxy = PolarChartProxy;


/***/ }),

/***/ 7562:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HeatmapChartProxy = exports.HEATMAP_VALUE_KEY = exports.HEATMAP_SERIES_KEY = exports.HEATMAP_CATEGORY_KEY = void 0;
const array_1 = __webpack_require__(1480);
const chartProxy_1 = __webpack_require__(6738);
exports.HEATMAP_CATEGORY_KEY = 'AG-GRID-DEFAULT-HEATMAP-CATEGORY-KEY';
exports.HEATMAP_SERIES_KEY = 'AG-GRID-DEFAULT-HEATMAP-SERIES-KEY';
exports.HEATMAP_VALUE_KEY = 'AG-GRID-DEFAULT-HEATMAP-VALUE-KEY';
class HeatmapChartProxy extends chartProxy_1.ChartProxy {
    getUpdateOptions(params, commonChartOptions) {
        const xSeriesKey = exports.HEATMAP_SERIES_KEY;
        const xValueKey = exports.HEATMAP_VALUE_KEY;
        const yKey = exports.HEATMAP_CATEGORY_KEY;
        return {
            ...commonChartOptions,
            series: this.getSeries(params, xSeriesKey, xValueKey, yKey),
            data: this.getData(params, xSeriesKey, xValueKey, yKey),
        };
    }
    getSeries(params, xSeriesKey, xValueKey, yKey) {
        const [category] = params.categories;
        return [
            {
                type: this.standaloneChartType,
                // The axis keys reference synthetic fields based on the category values and series column names
                yKey,
                xKey: xSeriesKey,
                // The color key references a synthetic field based on the series column value for a specific cell
                colorKey: xValueKey,
                yName: category.name,
                // We don't know how to label the 'x' series, as it is a synthetic series created from the set of all input columns
                // In future releases we may want to consider inferring the series label from column groupings etc
                xName: undefined,
                colorName: undefined,
            },
        ];
    }
    getData(params, xSeriesKey, xValueKey, yKey) {
        const [category] = params.categories;
        // Heatmap chart expects a flat array of data, with each row representing a single cell in the heatmap
        // This means we need to explode the list of input rows into their individual cells
        return (0, array_1.flatMap)(params.data, (datum, index) => {
            // We need to create a unique y value object for each row to prevent unintended category grouping
            // when there are multiple rows with the same category value
            const value = datum[category.id];
            const valueString = value == null ? '' : String(value);
            const yValue = { id: index, value, toString: () => valueString };
            // Return a flat list of output data items corresponding to each cell,
            // appending the synthetic series and category fields to the cell data
            return params.fields.map(({ colId, displayName }) => ({
                ...datum,
                [xSeriesKey]: displayName,
                [xValueKey]: datum[colId],
                [yKey]: yValue,
            }));
        });
    }
    getSeriesChartThemeDefaults() {
        return {
            gradientLegend: {
                gradient: {
                    preferredLength: 200,
                },
            },
            series: {
                tooltip: {
                    renderer: renderHeatmapTooltip,
                },
            },
        };
    }
}
exports.HeatmapChartProxy = HeatmapChartProxy;
function renderHeatmapTooltip(params) {
    const { xKey, yKey, colorKey, yName, datum } = params;
    const table = [
        { label: yName, value: datum[yKey] },
        { label: datum[xKey], value: colorKey && datum[colorKey] },
    ];
    return {
        title: '',
        data: table.map(({ label, value }) => ({ label: String(label), value: String(value) })),
    };
}


/***/ }),

/***/ 5413:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BoxPlotChartProxy = void 0;
const statisticalChartProxy_1 = __webpack_require__(879);
class BoxPlotChartProxy extends statisticalChartProxy_1.StatisticalChartProxy {
    getSeries(params) {
        const [category] = params.categories;
        return params.fields.map((field, seriesIndex) => ({
            type: this.standaloneChartType,
            // xKey/xName refer to category buckets
            xKey: category.id,
            xName: category.name,
            // yName is used to label the series
            yName: field.displayName ?? undefined,
            // custom field labels shown in the tooltip
            minName: 'Min',
            q1Name: 'Q1',
            medianName: 'Median',
            q3Name: 'Q3',
            maxName: 'Max',
            // generated 'synthetic fields' from getData()
            minKey: `min:${seriesIndex}`,
            q1Key: `q1:${seriesIndex}`,
            medianKey: `median:${seriesIndex}`,
            q3Key: `q3:${seriesIndex}`,
            maxKey: `max:${seriesIndex}`,
        }));
    }
    getData(params) {
        return this.computeSeriesStatistics(params, (seriesValues) => {
            const sortedValues = seriesValues.sort((a, b) => a - b);
            return {
                min: sortedValues[0],
                q1: this.quantile(sortedValues, 0.25),
                median: this.quantile(sortedValues, 0.5),
                q3: this.quantile(sortedValues, 0.75),
                max: sortedValues[sortedValues.length - 1],
            };
        });
    }
    quantile(sortedValues, q) {
        const position = (sortedValues.length - 1) * q;
        const indexBelow = Math.floor(position);
        const aboveValue = position - indexBelow;
        if (sortedValues[indexBelow + 1] !== undefined) {
            return sortedValues[indexBelow] + aboveValue * (sortedValues[indexBelow + 1] - sortedValues[indexBelow]);
        }
        return sortedValues[indexBelow];
    }
}
exports.BoxPlotChartProxy = BoxPlotChartProxy;


/***/ }),

/***/ 6926:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RangeChartProxy = void 0;
const statisticalChartProxy_1 = __webpack_require__(879);
class RangeChartProxy extends statisticalChartProxy_1.StatisticalChartProxy {
    getSeries(params) {
        const [category] = params.categories;
        return params.fields.map((field, seriesIndex) => ({
            type: this.standaloneChartType,
            // xKey/xName refer to category buckets
            xKey: category.id,
            xName: category.name,
            // yName is used to label the series
            yName: field.displayName ?? undefined,
            // custom field labels shown in the tooltip
            yLowName: 'Min',
            yHighName: 'Max',
            // generated 'synthetic fields' from getData()
            yLowKey: `min:${seriesIndex}`,
            yHighKey: `max:${seriesIndex}`,
        }));
    }
    getData(params) {
        return this.computeSeriesStatistics(params, (seriesValues) => {
            return {
                min: Math.min(...seriesValues),
                max: Math.max(...seriesValues),
            };
        });
    }
}
exports.RangeChartProxy = RangeChartProxy;


/***/ }),

/***/ 879:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StatisticalChartProxy = void 0;
const chartDataModel_1 = __webpack_require__(8592);
const cartesianChartProxy_1 = __webpack_require__(8631);
class StatisticalChartProxy extends cartesianChartProxy_1.CartesianChartProxy {
    getAxes(params, commonChartOptions) {
        return [
            {
                type: this.getXAxisType(params),
                position: this.isHorizontal(commonChartOptions) ? 'left' : 'bottom',
            },
            {
                type: 'number',
                position: this.isHorizontal(commonChartOptions) ? 'bottom' : 'left',
            },
        ];
    }
    computeSeriesStatistics(params, computeStatsFn) {
        const { data, fields } = params;
        const [category] = params.categories;
        const categoryKey = category.id || chartDataModel_1.DEFAULT_CHART_CATEGORY;
        const groupedData = this.groupDataByCategory(categoryKey, data);
        return Array.from(groupedData).map(([categoryValue, categoryData]) => {
            const categoryResult = { [category.id]: categoryValue };
            fields.forEach((field, seriesIndex) => {
                // `null` & `NaN` values are omitted from calculations
                const seriesValues = categoryData
                    .map((datum) => datum[field.colId])
                    .filter((value) => typeof value === 'number' && !isNaN(value));
                const computed = computeStatsFn(seriesValues);
                for (const statKey of Object.keys(computed)) {
                    const propertyKey = `${statKey}:${seriesIndex}`;
                    // when no data exists, stat properties are added to results with `null` values!
                    categoryResult[propertyKey] = seriesValues.length > 0 ? computed[statKey] : null;
                }
            });
            return categoryResult;
        });
    }
    groupDataByCategory(categoryKey, data) {
        const getCategory = (datum) => {
            if (categoryKey === chartDataModel_1.DEFAULT_CHART_CATEGORY) {
                return 1;
            }
            const categoryValue = datum[categoryKey];
            if (categoryValue === null || categoryValue === undefined) {
                return ''; // use a blank category for `null` or `undefined` values
            }
            return categoryValue instanceof Date ? categoryValue.getTime() : categoryValue;
        };
        return data.reduce((acc, datum) => {
            const category = getCategory(datum);
            const existingCategoryData = acc.get(category);
            if (existingCategoryData) {
                existingCategoryData.push(datum);
            }
            else {
                acc.set(category, [datum]);
            }
            return acc;
        }, new Map());
    }
}
exports.StatisticalChartProxy = StatisticalChartProxy;


/***/ }),

/***/ 9208:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartDatasource = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const chartDataModel_1 = __webpack_require__(8592);
class ChartDatasource extends ag_grid_community_1.BeanStub {
    wireBeans(beans) {
        this.sortSvc = beans.sortSvc;
        this.gridRowModel = beans.rowModel;
        this.colModel = beans.colModel;
        this.valueSvc = beans.valueSvc;
        this.pivotResultCols = beans.pivotResultCols;
        this.rowNodeSorter = beans.rowNodeSorter;
        this.aggStage = beans.aggStage;
    }
    getData(params) {
        if (params.crossFiltering) {
            if (params.grouping) {
                (0, ag_grid_community_1._warn)(141);
                return { chartData: [], colNames: {} };
            }
            if (!(0, ag_grid_community_1._isClientSideRowModel)(this.gos)) {
                (0, ag_grid_community_1._warn)(142);
                return { chartData: [], colNames: {} };
            }
        }
        const isServerSide = (0, ag_grid_community_1._isServerSideRowModel)(this.gos);
        if (isServerSide && params.pivoting) {
            this.updatePivotKeysForSSRM();
        }
        const result = this.extractRowsFromGridRowModel(params);
        result.chartData = this.aggregateRowsByDimension(params, result.chartData);
        return result;
    }
    extractRowsFromGridRowModel(params) {
        const { crossFiltering, startRow, endRow, valueCols, dimensionCols, grouping } = params;
        let extractedRowData = [];
        const colNames = {};
        // maps used to keep track of expanded groups that need to be removed
        const groupNodeIndexes = {};
        const groupsToRemove = {};
        // only used when cross filtering
        let filteredNodes = {};
        let allRowNodes = [];
        let numRows;
        if (crossFiltering) {
            filteredNodes = this.getFilteredRowNodes();
            allRowNodes = this.getAllRowNodes();
            numRows = allRowNodes.length;
        }
        else {
            // make sure enough rows in range to chart. if user filters and less rows, then end row will be
            // the last displayed row, not where the range ends.
            const modelLastRow = this.gridRowModel.getRowCount() - 1;
            // inclusivity is wrong for end row, so can't detect 0 rows properly
            const hasNoRange = startRow === endRow && startRow === 0 && dimensionCols.length === 0 && valueCols.length === 0;
            if (hasNoRange) {
                numRows = 0;
            }
            else {
                const rangeLastRow = endRow >= 0 ? Math.min(endRow, modelLastRow) : modelLastRow;
                numRows = rangeLastRow - startRow + 1;
            }
        }
        if (numRows > 0) {
            valueCols.forEach((col) => {
                let colNamesArr = [];
                // pivot keys should be added first
                const pivotKeys = col.getColDef().pivotKeys;
                if (pivotKeys) {
                    colNamesArr = pivotKeys.slice();
                }
                // then add column header name to results
                const headerName = col.getColDef().headerName;
                if (headerName) {
                    colNamesArr.push(headerName);
                }
                // add array of column names to results
                if (colNamesArr.length > 0) {
                    colNames[col.getId()] = colNamesArr;
                }
            });
        }
        let numRemovedNodes = 0;
        let id = 0;
        for (let i = 0; i < numRows; i++) {
            const rowNode = crossFiltering ? allRowNodes[i] : this.gridRowModel.getRow(i + startRow);
            if (rowNode.footer || rowNode.detail) {
                numRemovedNodes++;
                continue;
            }
            const data = {};
            // first get data for dimensions columns
            dimensionCols.forEach((col) => {
                const colId = col.colId;
                const column = this.colModel.getCol(colId);
                if (column) {
                    const valueObject = this.valueSvc.getValue(column, rowNode);
                    // when grouping we also need to build up multi category labels for charts
                    if (grouping) {
                        const valueString = valueObject?.toString ? String(valueObject.toString()) : '';
                        // traverse parents to extract group label path
                        const labels = this.getGroupLabels(rowNode, valueString);
                        const value = labels.slice().reverse();
                        data[colId] = {
                            value,
                            // this is needed so that standalone can handle animations properly when data updates
                            id: id++,
                            toString: () => value.filter(Boolean).join(' - '),
                        };
                        // keep track of group node indexes, so they can be padded when other groups are expanded
                        if (rowNode.group) {
                            groupNodeIndexes[labels.toString()] = i - numRemovedNodes;
                        }
                        // if node (group or leaf) has parents then it is expanded and should be removed
                        const groupKey = labels.slice(1, labels.length).toString();
                        if (groupKey) {
                            groupsToRemove[groupKey] = groupNodeIndexes[groupKey];
                        }
                    }
                    else {
                        // leaf nodes can be directly added to dimension columns
                        data[colId] = valueObject;
                    }
                }
                else {
                    // introduce a default category when no dimensions exist with a value based off row index (+1)
                    data[chartDataModel_1.DEFAULT_CHART_CATEGORY] = i + 1;
                }
            });
            // then get data for value columns
            valueCols.forEach((col) => {
                const colId = col.getColId();
                if (crossFiltering) {
                    const filteredOutColId = colId + '-filtered-out';
                    // add data value to value column
                    const value = this.valueSvc.getValue(col, rowNode);
                    const actualValue = value != null && typeof value.toNumber === 'function' ? value.toNumber() : value;
                    if (filteredNodes[rowNode.id]) {
                        data[colId] = actualValue;
                        data[filteredOutColId] = params.aggFunc || params.isScatter ? undefined : 0;
                    }
                    else {
                        data[colId] = params.aggFunc || params.isScatter ? undefined : 0;
                        data[filteredOutColId] = actualValue;
                    }
                }
                else {
                    // add data value to value column
                    let value = this.valueSvc.getValue(col, rowNode);
                    // aggregated value
                    if (value && Object.prototype.hasOwnProperty.call(value, 'toString')) {
                        value = parseFloat(value.toString());
                    }
                    data[colId] = value != null && typeof value.toNumber === 'function' ? value.toNumber() : value;
                }
            });
            // add data to results
            extractedRowData.push(data);
        }
        let groupChartData;
        if (grouping) {
            const groupIndexesToRemove = Object.values(groupsToRemove);
            const allData = extractedRowData;
            extractedRowData = [];
            groupChartData = [];
            for (let i = 0; i < allData.length; i++) {
                (groupIndexesToRemove.includes(i) ? groupChartData : extractedRowData).push(allData[i]);
            }
        }
        return { chartData: extractedRowData, colNames, groupChartData };
    }
    aggregateRowsByDimension(params, dataFromGrid) {
        const dimensionCols = params.dimensionCols;
        if (!params.aggFunc || dimensionCols.length === 0) {
            return dataFromGrid;
        }
        const lastCol = (0, ag_grid_community_1._last)(dimensionCols);
        const lastColId = lastCol && lastCol.colId;
        const map = {};
        const dataAggregated = [];
        dataFromGrid.forEach((data) => {
            let currentMap = map;
            dimensionCols.forEach((col) => {
                const colId = col.colId;
                const key = data[colId];
                if (colId === lastColId) {
                    let groupItem = currentMap[key];
                    if (!groupItem) {
                        groupItem = { __children: [] };
                        dimensionCols.forEach((dimCol) => {
                            const dimColId = dimCol.colId;
                            groupItem[dimColId] = data[dimColId];
                        });
                        currentMap[key] = groupItem;
                        dataAggregated.push(groupItem);
                    }
                    groupItem.__children.push(data);
                }
                else {
                    // map of maps
                    if (!currentMap[key]) {
                        currentMap[key] = {};
                    }
                    currentMap = currentMap[key];
                }
            });
        });
        if (this.gos.assertModuleRegistered('SharedRowGrouping', 1)) {
            const aggStage = this.aggStage;
            dataAggregated.forEach((groupItem) => params.valueCols.forEach((col) => {
                if (params.crossFiltering) {
                    params.valueCols.forEach((valueCol) => {
                        const colId = valueCol.getColId();
                        // filtered data
                        const dataToAgg = groupItem.__children
                            .filter((child) => typeof child[colId] !== 'undefined')
                            .map((child) => child[colId]);
                        const aggResult = aggStage.aggregateValues(dataToAgg, params.aggFunc);
                        groupItem[valueCol.getId()] =
                            aggResult && typeof aggResult.value !== 'undefined' ? aggResult.value : aggResult;
                        // filtered out data
                        const filteredOutColId = `${colId}-filtered-out`;
                        const dataToAggFiltered = groupItem.__children
                            .filter((child) => typeof child[filteredOutColId] !== 'undefined')
                            .map((child) => child[filteredOutColId]);
                        const aggResultFiltered = aggStage.aggregateValues(dataToAggFiltered, params.aggFunc);
                        groupItem[filteredOutColId] =
                            aggResultFiltered && typeof aggResultFiltered.value !== 'undefined'
                                ? aggResultFiltered.value
                                : aggResultFiltered;
                    });
                }
                else {
                    const dataToAgg = groupItem.__children.map((child) => child[col.getId()]);
                    const aggResult = aggStage.aggregateValues(dataToAgg, params.aggFunc);
                    groupItem[col.getId()] =
                        aggResult && typeof aggResult.value !== 'undefined' ? aggResult.value : aggResult;
                }
            }));
        }
        return dataAggregated;
    }
    updatePivotKeysForSSRM() {
        const secondaryColumns = this.pivotResultCols?.getPivotResultCols()?.list;
        if (!secondaryColumns) {
            return;
        }
        // we don't know what the application will use for the pivot key separator (i.e. '_' or '|' ) as the
        // secondary columns are provided to grid by the application via api.setSecondaryColumns()
        const pivotKeySeparator = this.extractPivotKeySeparator(secondaryColumns);
        // `pivotKeys` is not used by the SSRM for pivoting, so it is safe to reuse this colDef property. This way
        // the same logic can be used for CSRM and SSRM to extract legend names in extractRowsFromGridRowModel()
        secondaryColumns.forEach((col) => {
            if (pivotKeySeparator === '') {
                col.getColDef().pivotKeys = [];
            }
            else {
                const keys = col.getColId().split(pivotKeySeparator);
                col.getColDef().pivotKeys = keys.slice(0, keys.length - 1);
            }
        });
    }
    extractPivotKeySeparator(secondaryColumns) {
        if (secondaryColumns.length === 0) {
            return '';
        }
        const extractSeparator = (columnGroup, childId) => {
            const groupId = columnGroup.getGroupId();
            if (!columnGroup.getParent()) {
                // removing groupId ('2000') from childId ('2000|Swimming') yields '|Swimming' so first char is separator
                return childId.split(groupId)[1][0];
            }
            return extractSeparator(columnGroup.getParent(), groupId);
        };
        const firstSecondaryCol = secondaryColumns[0];
        if (firstSecondaryCol.getParent() == null) {
            return '';
        }
        return extractSeparator(firstSecondaryCol.getParent(), firstSecondaryCol.getColId());
    }
    getGroupLabels(rowNode, initialLabel) {
        const labels = [initialLabel];
        while (rowNode && rowNode.level !== 0) {
            rowNode = rowNode.parent;
            if (rowNode) {
                labels.push(rowNode.key);
            }
        }
        return labels;
    }
    getFilteredRowNodes() {
        const filteredNodes = {};
        this.gridRowModel.forEachNodeAfterFilterAndSort((rowNode) => {
            filteredNodes[rowNode.id] = rowNode;
        });
        return filteredNodes;
    }
    getAllRowNodes() {
        const allRowNodes = [];
        this.gridRowModel.forEachNode((rowNode) => {
            allRowNodes.push(rowNode);
        });
        return this.sortRowNodes(allRowNodes);
    }
    sortRowNodes(rowNodes) {
        const sortOptions = this.sortSvc?.getSortOptions();
        if (!sortOptions || sortOptions.length == 0 || !this.rowNodeSorter) {
            return rowNodes;
        }
        return this.rowNodeSorter.doFullSort(rowNodes, sortOptions);
    }
}
exports.ChartDatasource = ChartDatasource;


/***/ }),

/***/ 7760:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GridChartComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agDialog_1 = __webpack_require__(8775);
const chartController_1 = __webpack_require__(3251);
const areaChartProxy_1 = __webpack_require__(7216);
const barChartProxy_1 = __webpack_require__(3116);
const lineChartProxy_1 = __webpack_require__(9235);
const scatterChartProxy_1 = __webpack_require__(7015);
const comboChartProxy_1 = __webpack_require__(8995);
const pieChartProxy_1 = __webpack_require__(4104);
const chartMenu_1 = __webpack_require__(3608);
const chartMenuParamsFactory_1 = __webpack_require__(3786);
const chartDataModel_1 = __webpack_require__(8592);
const chartMenuService_1 = __webpack_require__(7492);
const chartOptionsService_1 = __webpack_require__(6297);
const seriesTypeMapper_1 = __webpack_require__(4237);
class GridChartComp extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.crossFilterService = beans.chartCrossFilterSvc;
        this.chartTranslation = beans.chartTranslation;
        this.chartMenuSvc = beans.chartMenuSvc;
        this.focusSvc = beans.focusSvc;
        this.popupSvc = beans.popupSvc;
        this.enterpriseChartProxyFactory = beans.enterpriseChartProxyFactory;
        this.environment = beans.environment;
    }
    constructor(params) {
        super(/* html */ `
            <div style="height: 100%; width: 100%;">
                <div class="ag-chart" data-ref="eWrapper">
                    <div data-ref="eChartContainer" class="ag-chart-components-wrapper ag-chart-menu-hidden">
                        <div data-ref="eChart" class="ag-chart-canvas-wrapper"></div>
                        <div data-ref="eEmpty" class="ag-chart-empty-text ag-unselectable"></div>
                    </div>
                    <div data-ref="eMenuContainer" class="ag-chart-docked-container"></div>
                </div>
            </div>
            `);
        this.eChart = ag_grid_community_1.RefPlaceholder;
        this.eWrapper = ag_grid_community_1.RefPlaceholder;
        this.eChartContainer = ag_grid_community_1.RefPlaceholder;
        this.eMenuContainer = ag_grid_community_1.RefPlaceholder;
        this.eEmpty = ag_grid_community_1.RefPlaceholder;
        this.params = params;
    }
    postConstruct() {
        const modelParams = {
            ...this.params,
            chartType: (0, seriesTypeMapper_1.getCanonicalChartType)(this.params.chartType),
            chartThemeName: this.getThemeName(),
        };
        const isRtl = this.gos.get('enableRtl');
        this.eWrapper.classList.add(isRtl ? 'ag-rtl' : 'ag-ltr');
        // only the chart controller interacts with the chart model
        const model = this.createBean(new chartDataModel_1.ChartDataModel(modelParams));
        this.chartController = this.createManagedBean(new chartController_1.ChartController(model));
        this.chartOptionsService = this.createManagedBean(new chartOptionsService_1.ChartOptionsService(this.chartController));
        this.validateCustomThemes();
        // create chart before dialog to ensure dialog is correct size
        this.createChart();
        if (this.params.insideDialog) {
            this.addDialog();
        }
        else {
            // don't add the theme if we're in a dialog, since dialogs already
            // add a theme, and legacy themes don't like being applied twice
            this.addManagedEventListeners({
                gridStylesChanged: this.updateTheme.bind(this),
            });
            this.updateTheme();
        }
        this.addMenu();
        this.addManagedElementListeners(this.getGui(), { focusin: this.setActiveChartCellRange.bind(this) });
        this.addManagedListeners(this.chartController, { chartModelUpdate: this.update.bind(this) });
        this.addManagedPropertyListeners(['chartThemeOverrides', 'chartThemes'], this.reactivePropertyUpdate.bind(this));
        this.update();
        this.raiseChartCreatedEvent();
    }
    updateTheme() {
        this.environment.applyThemeClasses(this.getGui());
    }
    createChart() {
        // if chart already exists, destroy it and remove it from DOM
        let chartInstance = undefined;
        if (this.chartProxy) {
            chartInstance = this.chartProxy.destroy({ keepChartInstance: true });
        }
        const crossFilterCallback = (event, reset) => {
            const ctx = this.params.crossFilteringContext;
            ctx.lastSelectedChartId = reset ? '' : this.chartController.getChartId();
            if (reset) {
                this.params.crossFilteringResetCallback();
            }
            this.crossFilterService.filter(event, reset);
        };
        const chartType = this.chartController.getChartType();
        const chartProxyParams = {
            agChartsExports: this.beans.agChartsExports,
            chartType,
            chartInstance,
            getChartThemeName: this.getChartThemeName.bind(this),
            getChartThemes: this.getChartThemes.bind(this),
            customChartThemes: this.gos.get('customChartThemes'),
            getGridOptionsChartThemeOverrides: () => this.getGridOptionsChartThemeOverrides(),
            getExtraPaddingDirections: () => this.chartMenu?.getExtraPaddingDirections() ?? [],
            apiChartThemeOverrides: this.params.chartThemeOverrides,
            crossFiltering: this.params.crossFiltering ?? false,
            crossFilterCallback,
            parentElement: this.eChart,
            grouping: this.chartController.isGrouping(),
            chartThemeToRestore: this.params.chartThemeName,
            chartOptionsToRestore: this.params.chartOptionsToRestore,
            chartPaletteToRestore: this.params.chartPaletteToRestore,
            seriesChartTypes: this.chartController.getSeriesChartTypes(),
            translate: (toTranslate) => this.chartTranslation.translate(toTranslate),
        };
        // ensure 'restoring' options are not reused when switching chart types
        this.params.chartOptionsToRestore = undefined;
        // set local state used to detect when chart changes
        this.chartType = chartType;
        this.chartProxy = this.createChartProxy(chartProxyParams);
        if (!this.chartProxy) {
            (0, ag_grid_community_1._warn)(138, { chartType: chartProxyParams.chartType });
            return;
        }
        this.chartController.setChartProxy(this.chartProxy);
        this.createMenuContext();
    }
    createMenuContext() {
        if (this.chartMenuContext) {
            return;
        }
        const chartMenuParamsFactory = this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(this.chartOptionsService.getChartThemeOverridesProxy()));
        const chartAxisMenuParamsFactory = this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(this.chartOptionsService.getAxisThemeOverridesProxy()));
        this.chartMenuContext = {
            chartController: this.chartController,
            chartOptionsService: this.chartOptionsService,
            chartMenuParamsFactory,
            chartAxisMenuParamsFactory,
        };
    }
    getChartThemeName() {
        return this.chartController.getChartThemeName();
    }
    getChartThemes() {
        return this.chartController.getThemeNames();
    }
    getGridOptionsChartThemeOverrides() {
        return this.gos.get('chartThemeOverrides');
    }
    createChartProxy(chartProxyParams) {
        const { chartType } = chartProxyParams;
        switch (chartType) {
            case 'column':
            case 'bar':
            case 'groupedColumn':
            case 'stackedColumn':
            case 'normalizedColumn':
            case 'groupedBar':
            case 'stackedBar':
            case 'normalizedBar':
                return new barChartProxy_1.BarChartProxy(chartProxyParams);
            case 'pie':
            case 'donut':
            case 'doughnut':
                return new pieChartProxy_1.PieChartProxy(chartProxyParams);
            case 'area':
            case 'stackedArea':
            case 'normalizedArea':
                return new areaChartProxy_1.AreaChartProxy(chartProxyParams);
            case 'line':
            case 'stackedLine':
            case 'normalizedLine':
                return new lineChartProxy_1.LineChartProxy(chartProxyParams);
            case 'scatter':
            case 'bubble':
                return new scatterChartProxy_1.ScatterChartProxy(chartProxyParams);
            case 'columnLineCombo':
            case 'areaColumnCombo':
            case 'customCombo':
                return new comboChartProxy_1.ComboChartProxy(chartProxyParams);
        }
        const enterpriseChartProxy = this.enterpriseChartProxyFactory?.createChartProxy(chartProxyParams);
        if (!enterpriseChartProxy) {
            throw (0, ag_grid_community_1._errMsg)(251, { chartType });
        }
        return enterpriseChartProxy;
    }
    addDialog() {
        const title = this.chartTranslation.translate(this.params.pivotChart ? 'pivotChartTitle' : 'rangeChartTitle');
        const { width, height } = this.getBestDialogSize();
        const afterGuiAttached = this.params.focusDialogOnOpen
            ? () => setTimeout(() => (0, ag_grid_community_1._focusInto)(this.getGui()))
            : undefined;
        this.chartDialog = new agDialog_1.AgDialog({
            resizable: true,
            movable: true,
            maximizable: true,
            title,
            width,
            height,
            component: this,
            centered: true,
            closable: true,
            afterGuiAttached,
            postProcessPopupParams: {
                type: 'chart',
            },
        });
        this.createBean(this.chartDialog);
        this.chartDialog.addEventListener('destroyed', () => {
            this.destroy();
            this.chartMenuSvc.hideAdvancedSettings();
            const lastFocusedCell = this.focusSvc.getFocusedCell();
            setTimeout(() => {
                if (this.focusSvc.isAlive()) {
                    // focus Service may have been destroyed if both grid and chart destroyed together
                    if (lastFocusedCell) {
                        this.focusSvc.setFocusedCell({ ...lastFocusedCell, forceBrowserFocus: true });
                    }
                    else {
                        (0, ag_grid_community_1._focusGridInnerElement)(this.beans);
                    }
                }
            });
        });
    }
    getBestDialogSize() {
        const popupParent = this.popupSvc.getPopupParent();
        const maxWidth = (0, ag_grid_community_1._getAbsoluteWidth)(popupParent) * 0.75;
        const maxHeight = (0, ag_grid_community_1._getAbsoluteHeight)(popupParent) * 0.75;
        const ratio = 0.553;
        const chart = this.chartProxy.getChart();
        let width = this.params.insideDialog ? 850 : chart.width;
        let height = this.params.insideDialog ? 470 : chart.height;
        if (width > maxWidth || height > maxHeight) {
            width = Math.min(width, maxWidth);
            height = Math.round(width * ratio);
            if (height > maxHeight) {
                height = maxHeight;
                width = Math.min(width, Math.round(height / ratio));
            }
        }
        return { width, height };
    }
    addMenu() {
        if (!this.params.crossFiltering) {
            this.chartMenu = this.createBean(new chartMenu_1.ChartMenu(this.eChartContainer, this.eMenuContainer, this.chartMenuContext));
            this.eChartContainer.appendChild(this.chartMenu.getGui());
        }
    }
    update(params) {
        // update chart model for api.updateChart()
        if (params?.chartId) {
            const validUpdate = this.chartController.update(params);
            if (!validUpdate) {
                return; // warning already logged!
            }
        }
        const updatedChartType = this.chartTypeChanged(params);
        // If the chart type has changed, grab the theme overrides from the exisiting chart before destroying it,
        // so that we can retain any compatible theme overrides across different chart types.
        const persistedThemeOverrides = updatedChartType || this.chartEmpty
            ? ((updatedChartType) => {
                const currentChartType = this.chartType;
                const targetChartType = updatedChartType;
                const existingChartInstance = this.chartProxy.getChart();
                const existingChartOptions = existingChartInstance?.getOptions();
                const existingAxes = existingChartInstance?.axes;
                return this.chartOptionsService.getPersistedChartThemeOverrides(existingChartOptions, existingAxes, currentChartType, targetChartType ?? currentChartType);
            })(updatedChartType)
            : undefined;
        // recreate chart if chart type has changed
        if (updatedChartType)
            this.createChart();
        // combine any provided theme overrides with any retained theme overrides from changing chart type
        if (persistedThemeOverrides && params?.chartThemeOverrides) {
            (0, ag_grid_community_1._mergeDeep)(persistedThemeOverrides, params.chartThemeOverrides);
        }
        const updatedThemeOverrides = persistedThemeOverrides ?? params?.chartThemeOverrides;
        // update chart options if chart type hasn't changed or if overrides are supplied
        this.updateChart(updatedThemeOverrides);
        if (params?.chartId) {
            this.chartProxy
                .getChart()
                .waitForUpdate()
                .then(() => {
                this.chartController.raiseChartApiUpdateEvent();
            });
        }
    }
    updateChart(updatedOverrides) {
        const { chartProxy } = this;
        const selectedCols = this.chartController.getSelectedValueColState();
        const data = this.chartController.getChartData();
        const chartEmpty = this.handleEmptyChart(data, selectedCols.length);
        this.chartEmpty = chartEmpty;
        if (chartEmpty) {
            // We don't have enough data to reinstantiate the chart with the new chart type,
            // but we still want to persist any theme overrides for when the data is present
            if (updatedOverrides)
                this.chartController.updateThemeOverrides(updatedOverrides);
            return;
        }
        const chartUpdateParams = this.chartController.getChartUpdateParams(updatedOverrides);
        chartProxy.update(chartUpdateParams);
        this.chartProxy
            .getChart()
            .waitForUpdate()
            .then(() => {
            this.chartController.raiseChartUpdatedEvent();
        });
    }
    chartTypeChanged(updateParams) {
        const [currentType, updatedChartType] = [this.chartController.getChartType(), updateParams?.chartType];
        const targetChartType = updatedChartType ? (0, seriesTypeMapper_1.getCanonicalChartType)(updatedChartType) : undefined;
        // If the grid chart component is out of sync with the existing chart instance type, return the correct chart type
        if (this.chartType !== currentType)
            return targetChartType ?? currentType;
        // If the target chart type is different to the current chart type, return the new chart type
        if (targetChartType && currentType !== targetChartType)
            return targetChartType;
        // Otherwise nothing has changed
        return null;
    }
    getChartModel() {
        return this.chartController.getChartModel();
    }
    getChartImageDataURL(fileFormat) {
        return this.chartProxy.getChartImageDataURL(fileFormat);
    }
    handleEmptyChart(data, numFields) {
        const pivotModeDisabled = this.chartController.isPivotChart() && !this.chartController.isPivotMode();
        // Determine the minimum number of fields based on the chart type
        const chartType = this.chartController.getChartType();
        let minFieldsRequired = 1;
        if (this.chartController.isActiveXYChart()) {
            minFieldsRequired = chartType === 'bubble' ? 3 : 2;
        }
        else if ((0, seriesTypeMapper_1.isHierarchical)((0, seriesTypeMapper_1.getSeriesType)(chartType))) {
            minFieldsRequired = 0;
        }
        const isEmptyChart = numFields < minFieldsRequired || data.length === 0;
        if (this.eChart) {
            const isEmpty = pivotModeDisabled || isEmptyChart;
            (0, ag_grid_community_1._setDisplayed)(this.eChart, !isEmpty);
            (0, ag_grid_community_1._setDisplayed)(this.eEmpty, isEmpty);
        }
        if (pivotModeDisabled) {
            // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
            this.eEmpty.innerText = this.chartTranslation.translate('pivotChartRequiresPivotMode');
            return true;
        }
        if (isEmptyChart) {
            // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
            this.eEmpty.innerText = this.chartTranslation.translate('noDataToChart');
            return true;
        }
        return false;
    }
    downloadChart(dimensions, fileName, fileFormat) {
        this.chartProxy.downloadChart(dimensions, fileName, fileFormat);
    }
    openChartToolPanel(panel) {
        const menuPanel = panel ? chartMenuService_1.CHART_TOOL_PANEL_MENU_OPTIONS[panel] : panel;
        this.chartMenu.showMenu({ panel: menuPanel });
    }
    closeChartToolPanel() {
        this.chartMenu.hideMenu();
    }
    getChartId() {
        return this.chartController.getChartId();
    }
    getUnderlyingChart() {
        return this.chartProxy.getChartRef();
    }
    crossFilteringReset() {
        this.chartProxy.crossFilteringReset();
    }
    setActiveChartCellRange(focusEvent) {
        if (this.getGui().contains(focusEvent.relatedTarget)) {
            return;
        }
        this.chartController.setChartRange(true);
    }
    getThemeName() {
        const availableChartThemes = this.gos.get('chartThemes') || chartController_1.DEFAULT_THEMES;
        if (availableChartThemes.length === 0) {
            throw new Error((0, ag_grid_community_1._errMsg)(254));
        }
        const { chartThemeName } = this.params;
        return availableChartThemes.includes(chartThemeName) ? chartThemeName : availableChartThemes[0];
    }
    getAllKeysInObjects(objects) {
        const allValues = {};
        objects
            .filter((obj) => obj != null)
            .forEach((obj) => {
            Object.keys(obj).forEach((key) => (allValues[key] = null));
        });
        return Object.keys(allValues);
    }
    validateCustomThemes() {
        const suppliedThemes = this.getChartThemes();
        const customChartThemes = this.gos.get('customChartThemes');
        if (customChartThemes) {
            this.getAllKeysInObjects([customChartThemes]).forEach((customThemeName) => {
                if (!suppliedThemes.includes(customThemeName)) {
                    (0, ag_grid_community_1._warn)(139, { customThemeName });
                }
            });
        }
    }
    reactivePropertyUpdate() {
        // switch to the first theme if the current theme is unavailable
        this.chartController.setChartThemeName(this.getThemeName(), true);
        const chartId = this.getChartId();
        const modelType = this.chartController.isCrossFilterChart() ? 'crossFilter' : this.getChartModel().modelType;
        // standalone requires that `undefined` / `null` values are supplied as `{}`
        const chartThemeOverrides = this.gos.get('chartThemeOverrides') || {};
        this.update({
            type: `${modelType}ChartUpdate`,
            chartId,
            chartThemeOverrides,
        });
    }
    raiseChartCreatedEvent() {
        this.chartProxy
            .getChart()
            .waitForUpdate()
            .then(() => {
            this.eventSvc.dispatchEvent({
                type: 'chartCreated',
                chartId: this.chartController.getChartId(),
            });
        });
    }
    raiseChartDestroyedEvent() {
        this.eventSvc.dispatchEvent({
            type: 'chartDestroyed',
            chartId: this.chartController.getChartId(),
        });
    }
    destroy() {
        super.destroy();
        if (this.chartProxy) {
            this.chartProxy.destroy();
        }
        this.destroyBean(this.chartMenu);
        // don't want to invoke destroy() on the Dialog (prevents destroy loop)
        if (this.chartDialog && this.chartDialog.isAlive()) {
            this.destroyBean(this.chartDialog);
        }
        this.onDestroyColorSchemeChangeListener?.();
        // if the user is providing containers for the charts, we need to clean up, otherwise the old chart
        // data will still be visible although the chart is no longer bound to the grid
        const eGui = this.getGui();
        (0, ag_grid_community_1._clearElement)(eGui);
        // remove from parent, so if user provided container, we detach from the provided dom element
        (0, ag_grid_community_1._removeFromParent)(eGui);
        this.raiseChartDestroyedEvent();
    }
}
exports.GridChartComp = GridChartComp;


/***/ }),

/***/ 6353:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedSettingsMenuFactory = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agDialog_1 = __webpack_require__(8775);
const advancedSettingsPanel_1 = __webpack_require__(5776);
class AdvancedSettingsMenuFactory extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'advSettingsMenuFactory';
    }
    showMenu(chartMenuContext, eventSource) {
        this.hideMenu();
        const menu = this.createBean(new AdvancedSettingsMenu(chartMenuContext));
        this.activeDialog = this.createBean(new agDialog_1.AgDialog({
            title: this.beans.chartTranslation.translate('advancedSettings'),
            component: menu,
            width: 300,
            height: 400,
            resizable: true,
            movable: true,
            centered: true,
            closable: true,
            afterGuiAttached: () => {
                (0, ag_grid_community_1._findFocusableElements)(menu.getGui())[0]?.focus();
            },
            closedCallback: () => {
                this.activeMenu = this.destroyBean(this.activeMenu);
                this.activeDialog = undefined;
                eventSource?.focus({ preventScroll: true });
            },
        }));
        this.activeMenu = menu;
    }
    hideMenu() {
        if (this.activeDialog) {
            this.destroyBean(this.activeDialog);
        }
    }
    destroy() {
        this.activeMenu = this.destroyBean(this.activeMenu);
        this.activeDialog = this.destroyBean(this.activeDialog);
        super.destroy();
    }
}
exports.AdvancedSettingsMenuFactory = AdvancedSettingsMenuFactory;
class AdvancedSettingsMenu extends ag_grid_community_1.TabGuardComp {
    constructor(chartMenuContext) {
        super(/* html */ `<div class="ag-chart-advanced-settings"></div>`);
        this.chartMenuContext = chartMenuContext;
    }
    postConstruct() {
        this.advancedSettingsPanel = this.createManagedBean(new advancedSettingsPanel_1.AdvancedSettingsPanel(this.chartMenuContext));
        this.getGui().appendChild(this.advancedSettingsPanel.getGui());
        this.initialiseTabGuard({
            onTabKeyDown: this.onTabKeyDown.bind(this),
            focusTrapActive: true,
        });
    }
    onTabKeyDown(e) {
        if (e.defaultPrevented) {
            return;
        }
        e.preventDefault();
        const backwards = e.shiftKey;
        const panelGui = this.advancedSettingsPanel.getGui();
        const nextEl = (0, ag_grid_community_1._findNextFocusableElement)(this.beans, panelGui, false, backwards);
        if (nextEl) {
            nextEl.focus();
        }
        else {
            const focusableElements = (0, ag_grid_community_1._findFocusableElements)(panelGui);
            if (focusableElements.length) {
                focusableElements[backwards ? focusableElements.length - 1 : 0].focus();
            }
        }
    }
}


/***/ }),

/***/ 5776:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AdvancedSettingsPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartPanelFeature_1 = __webpack_require__(1299);
const animationPanel_1 = __webpack_require__(6671);
const crosshairPanel_1 = __webpack_require__(2337);
const navigatorPanel_1 = __webpack_require__(2738);
const zoomPanel_1 = __webpack_require__(3320);
const INTERACTIVITY_GROUPS = ['navigator', 'zoom', 'animation', 'crosshair'];
class AdvancedSettingsPanel extends ag_grid_community_1.Component {
    constructor(chartMenuContext) {
        super(/* html */ `<div class="ag-chart-advanced-settings-wrapper"></div>`);
        this.chartMenuContext = chartMenuContext;
    }
    postConstruct() {
        this.chartPanelFeature = this.createManagedBean(new chartPanelFeature_1.ChartPanelFeature(this.chartMenuContext.chartController, this.getGui(), 'ag-chart-advanced-settings-section', (chartType, seriesType) => this.createPanels(chartType, seriesType)));
        this.chartPanelFeature.refreshPanels();
    }
    createPanels(chartType, seriesType) {
        INTERACTIVITY_GROUPS.forEach((group) => {
            if (!this.isGroupPanelShownForSeries(group, seriesType)) {
                return;
            }
            const comp = this.createPanel(group);
            this.chartPanelFeature.addComponent(comp);
        });
    }
    isGroupPanelShownForSeries(group, seriesType) {
        return group === 'animation' || (0, seriesTypeMapper_1.isCartesian)(seriesType);
    }
    createPanel(group) {
        const { chartMenuParamsFactory, chartAxisMenuParamsFactory } = this.chartMenuContext;
        switch (group) {
            case 'navigator':
                return new navigatorPanel_1.NavigatorPanel(chartMenuParamsFactory);
            case 'zoom':
                return new zoomPanel_1.ZoomPanel(chartMenuParamsFactory);
            case 'animation':
                return new animationPanel_1.AnimationPanel(chartMenuParamsFactory);
            case 'crosshair':
                return new crosshairPanel_1.CrosshairPanel(chartAxisMenuParamsFactory);
        }
    }
}
exports.AdvancedSettingsPanel = AdvancedSettingsPanel;


/***/ }),

/***/ 6671:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AnimationPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
class AnimationPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuParamsFactory) {
        super();
        this.chartMenuParamsFactory = chartMenuParamsFactory;
    }
    postConstruct() {
        const animationGroupParams = this.chartMenuParamsFactory.addEnableParams('animation.enabled', {
            cssIdentifier: 'charts-advanced-settings-top-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('animation'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const animationHeightInputParams = this.chartMenuParamsFactory.getDefaultNumberInputParams('animation.duration', 'durationMillis', {
            min: 0,
        });
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="animationGroup">
                <ag-input-number-field data-ref="animationHeightInput"></ag-input>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgInputNumberFieldSelector], {
            animationGroup: animationGroupParams,
            animationHeightInput: animationHeightInputParams,
        });
    }
}
exports.AnimationPanel = AnimationPanel;


/***/ }),

/***/ 2337:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CrosshairPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
class CrosshairPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuParamsFactory) {
        super();
        this.chartMenuParamsFactory = chartMenuParamsFactory;
    }
    postConstruct() {
        const crosshairGroupParams = this.chartMenuParamsFactory.addEnableParams('crosshair.enabled', {
            cssIdentifier: 'charts-advanced-settings-top-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('crosshair'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const crosshairLabelCheckboxParams = this.chartMenuParamsFactory.getDefaultCheckboxParams('crosshair.label.enabled', 'crosshairLabel');
        const crosshairSnapCheckboxParams = this.chartMenuParamsFactory.getDefaultCheckboxParams('crosshair.snap', 'crosshairSnap');
        const crosshairStrokeColorPickerParams = this.chartMenuParamsFactory.getDefaultColorPickerParams('crosshair.stroke', 'color');
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="crosshairGroup">
                <ag-checkbox data-ref="crosshairLabelCheckbox"></ag-checkbox>
                <ag-checkbox data-ref="crosshairSnapCheckbox"></ag-checkbox>
                <ag-color-picker data-ref="crosshairStrokeColorPicker"></ag-color-picker>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgCheckboxSelector, agColorPicker_1.AgColorPickerSelector], {
            crosshairGroup: crosshairGroupParams,
            crosshairLabelCheckbox: crosshairLabelCheckboxParams,
            crosshairSnapCheckbox: crosshairSnapCheckboxParams,
            crosshairStrokeColorPicker: crosshairStrokeColorPickerParams,
        });
    }
}
exports.CrosshairPanel = CrosshairPanel;


/***/ }),

/***/ 2738:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NavigatorPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
class NavigatorPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuParamsFactory) {
        super();
        this.chartMenuParamsFactory = chartMenuParamsFactory;
    }
    postConstruct() {
        const navigatorGroupParams = this.chartMenuParamsFactory.addEnableParams('navigator.enabled', {
            cssIdentifier: 'charts-advanced-settings-top-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('navigator'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const navigatorHeightSliderParams = this.chartMenuParamsFactory.getDefaultSliderParams('navigator.height', 'height', 60);
        navigatorHeightSliderParams.minValue = 10;
        const navigatorMiniChartCheckboxParams = this.chartMenuParamsFactory.getDefaultCheckboxParams('navigator.miniChart.enabled', 'miniChart');
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="navigatorGroup">
                <ag-slider data-ref="navigatorHeightSlider"></ag-slider>
                <ag-checkbox data-ref="navigatorMiniChartCheckbox"></ag-checkbox>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agSlider_1.AgSliderSelector, ag_grid_community_1.AgCheckboxSelector], {
            navigatorGroup: navigatorGroupParams,
            navigatorHeightSlider: navigatorHeightSliderParams,
            navigatorMiniChartCheckbox: navigatorMiniChartCheckboxParams,
        });
    }
}
exports.NavigatorPanel = NavigatorPanel;


/***/ }),

/***/ 3320:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ZoomPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
class ZoomPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuParamsFactory) {
        super();
        this.chartMenuParamsFactory = chartMenuParamsFactory;
        this.zoomScrollingStepInput = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        const zoomGroupParams = this.chartMenuParamsFactory.addEnableParams('zoom.enabled', {
            cssIdentifier: 'charts-advanced-settings-top-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('zoom'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const zoomScrollingCheckboxParams = this.chartMenuParamsFactory.getDefaultCheckboxParams('zoom.enableScrolling', 'scrollingZoom');
        const zoomScrollingStepSliderParams = this.chartMenuParamsFactory.getDefaultSliderParams('zoom.scrollingStep', 'scrollingStep', 1);
        zoomScrollingStepSliderParams.step = 0.01;
        zoomScrollingStepSliderParams.minValue = zoomScrollingStepSliderParams.step;
        const zoomSelectingCheckboxParams = this.chartMenuParamsFactory.getDefaultCheckboxParams('zoom.enableSelecting', 'selectingZoom');
        // Enable/disable the scrolling step input according to whether the scrolling checkbox is checked
        zoomScrollingCheckboxParams.onValueChange = ((onValueChange) => (value) => {
            if (!onValueChange)
                return;
            onValueChange(value);
            this.zoomScrollingStepInput.setDisabled(!value);
        })(zoomScrollingCheckboxParams.onValueChange);
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="zoomGroup">
                <ag-checkbox data-ref="zoomSelectingCheckbox"></ag-checkbox>
                <ag-checkbox data-ref="zoomScrollingCheckbox"></ag-checkbox>
                <ag-slider data-ref="zoomScrollingStepInput"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgCheckboxSelector, agSlider_1.AgSliderSelector], {
            zoomGroup: zoomGroupParams,
            zoomScrollingCheckbox: zoomScrollingCheckboxParams,
            zoomScrollingStepInput: zoomScrollingStepSliderParams,
            zoomSelectingCheckbox: zoomSelectingCheckboxParams,
        });
        // Set the initial state of the scrolling step input according to whether the scrolling checkbox is checked
        this.zoomScrollingStepInput.setDisabled(!zoomScrollingCheckboxParams.value);
    }
}
exports.ZoomPanel = ZoomPanel;


/***/ }),

/***/ 3608:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartMenu = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agPanel_1 = __webpack_require__(7325);
const chartToolbar_1 = __webpack_require__(4967);
const tabbedChartMenu_1 = __webpack_require__(5518);
class ChartMenu extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartMenuSvc = beans.chartMenuSvc;
        this.chartMenuListFactory = beans.chartMenuListFactory;
        this.environment = beans.environment;
    }
    constructor(eChartContainer, eMenuPanelContainer, chartMenuContext) {
        super(/* html */ `<div class="ag-chart-menu-wrapper"></div>`);
        this.eChartContainer = eChartContainer;
        this.eMenuPanelContainer = eMenuPanelContainer;
        this.chartMenuContext = chartMenuContext;
        this.buttons = {
            chartLink: { iconName: 'linked', callback: () => this.chartMenuSvc.toggleLinked(this.chartMenuContext) },
            chartUnlink: {
                iconName: 'unlinked',
                callback: () => this.chartMenuSvc.toggleLinked(this.chartMenuContext),
            },
            chartDownload: {
                iconName: 'chartsDownload',
                callback: () => this.chartMenuSvc.downloadChart(this.chartMenuContext),
            },
            chartMenu: { iconName: 'chartsMenu', callback: (eventSource) => this.showMenuList(eventSource) },
        };
        this.panels = [];
        this.menuVisible = false;
        this.chartController = chartMenuContext.chartController;
    }
    postConstruct() {
        this.chartToolbar = this.createManagedBean(new chartToolbar_1.ChartToolbar());
        this.getGui().appendChild(this.chartToolbar.getGui());
        this.refreshToolbarAndPanels();
        this.addManagedEventListeners({
            chartCreated: (e) => {
                if (e.chartId === this.chartController.getChartId()) {
                    const showDefaultToolPanel = Boolean(this.gos.get('chartToolPanelsDef')?.defaultToolPanel);
                    if (showDefaultToolPanel) {
                        this.showMenu({ panel: this.defaultPanel, suppressFocus: true });
                    }
                }
            },
        });
        this.addManagedListeners(this.chartController, {
            chartLinkedChanged: this.refreshToolbarAndPanels.bind(this),
        });
        this.refreshMenuClasses();
        this.addManagedListeners(this.chartController, { chartApiUpdate: this.refreshToolbarAndPanels.bind(this) });
    }
    isVisible() {
        return this.menuVisible;
    }
    getExtraPaddingDirections() {
        return ['chartMenu', 'chartLink', 'chartUnlink', 'chartDownload'].some((v) => this.chartToolbarOptions.includes(v))
            ? ['top']
            : [];
    }
    refreshToolbarAndPanels() {
        this.initToolbarOptionsAndPanels();
        this.updateToolbar();
    }
    initToolbarOptionsAndPanels() {
        const { panels, defaultPanel } = this.chartMenuSvc.getChartToolPanels(this.chartController);
        this.panels = panels;
        this.defaultPanel = defaultPanel;
        this.chartToolbarOptions = this.chartMenuSvc.getChartToolbarOptions();
    }
    updateToolbar() {
        const buttons = this.chartToolbarOptions.map((buttonName) => {
            const { iconName, callback } = this.buttons[buttonName];
            return {
                buttonName,
                iconName,
                callback,
            };
        });
        this.chartToolbar.updateParams({ buttons });
    }
    createMenuPanel(defaultTab) {
        const menuPanel = (this.menuPanel = this.createBean(new agPanel_1.AgPanel({
            height: '100%',
            closable: true,
            hideTitleBar: true,
            cssIdentifier: 'chart-menu',
        })));
        menuPanel.setParentComponent(this);
        this.eMenuPanelContainer.appendChild(menuPanel.getGui());
        this.tabbedMenu = this.createBean(new tabbedChartMenu_1.TabbedChartMenu(this.panels, this.chartMenuContext));
        this.addManagedListeners(this.tabbedMenu, {
            closed: () => {
                this.hideMenu();
            },
        });
        this.addManagedListeners(menuPanel, { destroyed: () => this.destroyBean(this.tabbedMenu) });
        return new ag_grid_community_1.AgPromise((res) => {
            window.setTimeout(() => {
                menuPanel.setBodyComponent(this.tabbedMenu);
                this.tabbedMenu.showTab(defaultTab);
                res(menuPanel);
            }, 100);
        });
    }
    showContainer(eventSource, suppressFocus) {
        if (!this.menuPanel) {
            return;
        }
        this.menuVisible = true;
        this.refreshMenuClasses();
        this.tabbedMenu.showMenu(eventSource, suppressFocus);
    }
    showMenu(params) {
        const { panel, eventSource, suppressFocus } = params ?? {};
        if (this.menuPanel && !panel) {
            this.showContainer(eventSource, suppressFocus);
        }
        else {
            const menuPanel = panel || this.defaultPanel;
            let tab = this.panels.indexOf(menuPanel);
            if (tab < 0) {
                (0, ag_grid_community_1._warn)(143, { panel });
                tab = this.panels.indexOf(this.defaultPanel);
            }
            if (this.menuPanel) {
                this.tabbedMenu.showTab(tab);
                this.showContainer(eventSource, suppressFocus);
            }
            else {
                this.createMenuPanel(tab).then(() => this.showContainer(eventSource, suppressFocus));
            }
        }
    }
    hideMenu() {
        this.menuVisible = false;
        this.refreshMenuClasses();
    }
    refreshMenuClasses() {
        this.eChartContainer.classList.toggle('ag-chart-menu-visible', this.menuVisible);
        this.eChartContainer.classList.toggle('ag-chart-menu-hidden', !this.menuVisible);
    }
    showMenuList(eventSource) {
        this.chartMenuListFactory.showMenuList({
            eventSource,
            showMenu: () => this.showMenu({ eventSource }),
            chartMenuContext: this.chartMenuContext,
        });
    }
    destroy() {
        super.destroy();
        if (this.menuPanel && this.menuPanel.isAlive()) {
            this.destroyBean(this.menuPanel);
        }
        if (this.tabbedMenu && this.tabbedMenu.isAlive()) {
            this.destroyBean(this.tabbedMenu);
        }
    }
}
exports.ChartMenu = ChartMenu;


/***/ }),

/***/ 6292:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartMenuListFactory = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agMenuList_1 = __webpack_require__(9476);
class ChartMenuListFactory extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'chartMenuListFactory';
    }
    wireBeans(beans) {
        this.popupSvc = beans.popupSvc;
        this.chartMenuSvc = beans.chartMenuSvc;
        this.chartTranslation = beans.chartTranslation;
    }
    showMenuList(params) {
        const { eventSource, showMenu, chartMenuContext } = params;
        const areChartToolPanelsEnabled = this.chartMenuSvc.doChartToolPanelsExist(chartMenuContext.chartController);
        const menuItems = this.mapWithStockItems(this.getMenuItems(chartMenuContext.chartController, areChartToolPanelsEnabled), chartMenuContext, showMenu, eventSource, areChartToolPanelsEnabled);
        if (!menuItems.length) {
            return;
        }
        const chartMenuList = this.createBean(new ChartMenuList(menuItems));
        this.activeChartMenuList = chartMenuList;
        let multiplier = -1;
        let alignSide = 'left';
        if (this.gos.get('enableRtl')) {
            multiplier = 1;
            alignSide = 'right';
        }
        const eGui = chartMenuList.getGui();
        this.popupSvc.addPopup({
            modal: true,
            eChild: eGui,
            closeOnEsc: true,
            closedCallback: () => {
                this.destroyBean(chartMenuList);
                this.activeChartMenuList = undefined;
                if ((0, ag_grid_community_1._isNothingFocused)(this.beans)) {
                    eventSource.focus({ preventScroll: true });
                }
            },
            afterGuiAttached: (params) => chartMenuList.afterGuiAttached(params),
            positionCallback: () => {
                {
                    this.popupSvc.positionPopupByComponent({
                        type: 'chartMenu',
                        eventSource,
                        ePopup: eGui,
                        alignSide,
                        nudgeX: 4 * multiplier,
                        nudgeY: 4,
                        position: 'under',
                        keepWithinBounds: true,
                    });
                }
            },
            ariaLabel: 'Chart Menu',
        });
    }
    getMenuItems(chartController, areChartToolPanelsEnabled) {
        const defaultItems = [
            ...(areChartToolPanelsEnabled ? ['chartEdit'] : []),
            ...(chartController.isEnterprise() ? ['chartAdvancedSettings'] : []),
            chartController.isChartLinked() ? 'chartUnlink' : 'chartLink',
            'chartDownload',
        ];
        const chartMenuItems = this.gos.get('chartMenuItems');
        if (!chartMenuItems) {
            return defaultItems;
        }
        else if (Array.isArray(chartMenuItems)) {
            return chartMenuItems;
        }
        else {
            return chartMenuItems((0, ag_grid_community_1._addGridCommonParams)(this.gos, {
                defaultItems,
            }));
        }
    }
    mapWithStockItems(originalList, chartMenuContext, showMenu, eventSource, areChartToolPanelsEnabled) {
        if (!originalList) {
            return [];
        }
        const resultList = [];
        originalList.forEach((menuItemOrString) => {
            let result;
            if (typeof menuItemOrString === 'string') {
                result = this.getStockMenuItem(menuItemOrString, chartMenuContext, showMenu, eventSource, areChartToolPanelsEnabled);
            }
            else {
                result = { ...menuItemOrString };
            }
            if (!result) {
                return;
            }
            const { subMenu } = result;
            if (Array.isArray(subMenu)) {
                result.subMenu = this.mapWithStockItems(subMenu, chartMenuContext, showMenu, eventSource, areChartToolPanelsEnabled);
            }
            resultList.push(result);
        });
        return resultList;
    }
    getStockMenuItem(key, chartMenuContext, showMenu, eventSource, areChartToolPanelsEnabled) {
        switch (key) {
            case 'chartEdit':
                return areChartToolPanelsEnabled
                    ? this.createMenuItem(this.chartTranslation.translate('chartEdit'), 'chartsMenuEdit', showMenu)
                    : null;
            case 'chartAdvancedSettings':
                return this.createMenuItem(this.chartTranslation.translate('chartAdvancedSettings'), 'chartsMenuAdvancedSettings', () => this.chartMenuSvc.openAdvancedSettings(chartMenuContext, eventSource));
            case 'chartUnlink':
                return chartMenuContext.chartController.isChartLinked()
                    ? this.createMenuItem(this.chartTranslation.translate('chartUnlink'), 'unlinked', () => this.chartMenuSvc.toggleLinked(chartMenuContext))
                    : null;
            case 'chartLink':
                return !chartMenuContext.chartController.isChartLinked()
                    ? this.createMenuItem(this.chartTranslation.translate('chartLink'), 'linked', () => this.chartMenuSvc.toggleLinked(chartMenuContext))
                    : null;
            case 'chartDownload':
                return this.createMenuItem(this.chartTranslation.translate('chartDownload'), 'chartsDownload', () => this.chartMenuSvc.downloadChart(chartMenuContext));
        }
        return null;
    }
    createMenuItem(name, iconName, action) {
        return {
            name,
            icon: (0, ag_grid_community_1._createIconNoSpan)(iconName, this.beans, null),
            action,
        };
    }
    destroy() {
        this.destroyBean(this.activeChartMenuList);
        super.destroy();
    }
}
exports.ChartMenuListFactory = ChartMenuListFactory;
class ChartMenuList extends ag_grid_community_1.Component {
    constructor(menuItems) {
        super(/* html */ `
            <div data-ref="eChartsMenu" role="presentation" class="ag-menu ag-chart-menu-popup"></div>
        `);
        this.menuItems = menuItems;
        this.eChartsMenu = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        this.mainMenuList = this.createManagedBean(new agMenuList_1.AgMenuList(0));
        this.mainMenuList.addMenuItems(this.menuItems);
        this.mainMenuList.addEventListener('closeMenu', this.onHidePopup.bind(this));
        this.eChartsMenu.appendChild(this.mainMenuList.getGui());
    }
    onHidePopup() {
        this.hidePopupFunc?.();
    }
    afterGuiAttached({ hidePopup }) {
        if (hidePopup) {
            this.hidePopupFunc = hidePopup;
            this.addDestroyFunc(hidePopup);
        }
        (0, ag_grid_community_1._focusInto)(this.mainMenuList.getGui());
    }
}


/***/ }),

/***/ 3786:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartMenuParamsFactory = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ChartMenuParamsFactory extends ag_grid_community_1.BeanStub {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartOptionsProxy) {
        super();
        this.chartOptionsProxy = chartOptionsProxy;
    }
    getDefaultColorPickerParams(expression, labelKey, options) {
        return this.addValueParams(expression, {
            label: this.chartTranslation.translate(labelKey ?? 'color'),
            labelWidth: 'flex',
            inputWidth: 'flex',
            labelAlignment: 'top',
            pickerGap: 6,
        }, options);
    }
    getDefaultNumberInputParams(expression, labelKey, options) {
        return this.addValueParams(expression, {
            label: this.chartTranslation.translate(labelKey),
            labelAlignment: 'top',
            labelWidth: 'flex',
            inputWidth: 'flex',
            precision: options?.precision,
            step: options?.step,
            min: options?.min,
            max: options?.max,
        }, {
            parseInputValue: (value) => {
                const numberValue = Number(value);
                return isNaN(numberValue) ? undefined : numberValue;
            },
            formatInputValue: (value) => {
                return value == null ? '' : `${value}`;
            },
        });
    }
    getDefaultSliderParams(expression, labelKey, defaultMaxValue, isArray) {
        let value = this.chartOptionsProxy.getValue(expression) ?? 0;
        if (isArray && Array.isArray(value)) {
            value = value[0];
        }
        const params = this.getDefaultSliderParamsWithoutValueParams(value, labelKey, defaultMaxValue);
        params.onValueChange = (value) => this.chartOptionsProxy.setValue(expression, isArray ? [value] : value);
        return params;
    }
    getDefaultSliderParamsWithoutValueParams(value, labelKey, defaultMaxValue) {
        return {
            label: this.chartTranslation.translate(labelKey),
            minValue: 0,
            maxValue: Math.max(value, defaultMaxValue),
            textFieldWidth: 45,
            value: `${value}`,
        };
    }
    getDefaultCheckboxParams(expression, labelKey, options) {
        const value = this.chartOptionsProxy.getValue(expression);
        const params = {
            label: this.chartTranslation.translate(labelKey),
            value,
            readOnly: options?.readOnly,
            passive: options?.passive,
        };
        params.onValueChange = (value) => {
            this.chartOptionsProxy.setValue(expression, typeof value === 'boolean' ? value : undefined);
        };
        return params;
    }
    getDefaultToggleParams(expression, labelKey, options) {
        const value = this.chartOptionsProxy.getValue(expression);
        const params = {
            label: this.chartTranslation.translate(labelKey),
            labelAlignment: 'left',
            labelWidth: 'flex',
            inputWidth: 'flex',
            value,
            readOnly: options?.readOnly,
            passive: options?.passive,
        };
        params.onValueChange = (value) => {
            this.chartOptionsProxy.setValue(expression, typeof value === 'boolean' ? value : undefined);
        };
        return params;
    }
    getDefaultSelectParams(expression, labelKey, dropdownOptions) {
        return this.getDefaultSelectParamsWithoutValueParams(labelKey, dropdownOptions, this.chartOptionsProxy.getValue(expression), (value) => {
            this.chartOptionsProxy.setValue(expression, value);
        });
    }
    getDefaultSelectParamsWithoutValueParams(labelKey, options, value, onValueChange) {
        return {
            label: this.chartTranslation.translate(labelKey),
            labelAlignment: 'top',
            options,
            pickerGap: 6,
            value,
            onValueChange,
        };
    }
    getDefaultFontPanelParams(expression, labelKey) {
        const keyMapper = (key) => `${expression}.${key}`;
        return this.addEnableParams(keyMapper('enabled'), {
            name: this.chartTranslation.translate(labelKey),
            suppressEnabledCheckbox: false,
            chartMenuParamsFactory: this,
            keyMapper,
        });
    }
    addValueParams(expression, params, options) {
        const optionsValue = this.chartOptionsProxy.getValue(expression);
        params.value = options?.formatInputValue ? options.formatInputValue(optionsValue) : optionsValue;
        params.onValueChange = (value) => {
            const optionsValue = options?.parseInputValue ? options.parseInputValue(value) : value;
            this.chartOptionsProxy.setValue(expression, optionsValue);
        };
        return params;
    }
    addEnableParams(expression, params) {
        params.enabled = this.chartOptionsProxy.getValue(expression) ?? false;
        params.onEnableChange = (value) => this.chartOptionsProxy.setValue(expression, value);
        return params;
    }
    getChartOptions() {
        return this.chartOptionsProxy;
    }
}
exports.ChartMenuParamsFactory = ChartMenuParamsFactory;


/***/ }),

/***/ 1299:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartPanelFeature = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const seriesTypeMapper_1 = __webpack_require__(4237);
class ChartPanelFeature extends ag_grid_community_1.BeanStub {
    constructor(chartController, eGui, cssClass, createPanels) {
        super();
        this.chartController = chartController;
        this.eGui = eGui;
        this.cssClass = cssClass;
        this.createPanels = createPanels;
        this.panels = [];
    }
    postConstruct() {
        this.addManagedListeners(this.chartController, {
            chartUpdated: () => this.refreshPanels(true),
            chartApiUpdate: () => this.refreshPanels(false),
        });
    }
    addComponent(component) {
        this.createBean(component);
        this.panels.push(component);
        component.addCssClass(this.cssClass);
        this.eGui.appendChild(component.getGui());
    }
    refreshPanels(reuse) {
        const chartType = this.chartController.getChartType();
        const isGrouping = this.chartController.isGrouping();
        const seriesType = (0, seriesTypeMapper_1.getSeriesType)(chartType);
        if (reuse && chartType === this.chartType && isGrouping === this.isGrouping) {
            // existing panels can be re-used
            return;
        }
        this.destroyPanels();
        this.createPanels(chartType, seriesType);
        this.chartType = chartType;
        this.isGrouping = isGrouping;
    }
    destroyPanels() {
        this.panels.forEach((panel) => {
            (0, ag_grid_community_1._removeFromParent)(panel.getGui());
            this.destroyBean(panel);
        });
        this.panels = [];
    }
    destroy() {
        this.destroyPanels();
        super.destroy();
    }
}
exports.ChartPanelFeature = ChartPanelFeature;


/***/ }),

/***/ 4967:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartToolbar = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ChartToolbar extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor() {
        super(/* html */ `<div class="ag-chart-menu" data-ref="eMenu"></div>`);
        this.eMenu = ag_grid_community_1.RefPlaceholder;
        this.buttonListenersDestroyFuncs = [];
    }
    updateParams(params) {
        const { buttons } = params;
        this.createButtons(buttons);
    }
    createButtons(buttons) {
        this.buttonListenersDestroyFuncs.forEach((func) => func?.());
        this.buttonListenersDestroyFuncs = [];
        const menuEl = this.eMenu;
        (0, ag_grid_community_1._clearElement)(menuEl);
        buttons.forEach((buttonConfig) => {
            const { buttonName, iconName, callback } = buttonConfig;
            const buttonEl = this.createButton(iconName);
            const tooltipTitle = this.chartTranslation.translate((buttonName + 'ToolbarTooltip'));
            if (tooltipTitle && buttonEl instanceof HTMLElement) {
                buttonEl.title = tooltipTitle;
            }
            this.buttonListenersDestroyFuncs.push(...this.addManagedElementListeners(buttonEl, {
                click: (event) => callback(event.currentTarget),
            }));
            menuEl.appendChild(buttonEl);
        });
    }
    createButton(iconName) {
        const buttonEl = (0, ag_grid_community_1._createIconNoSpan)(iconName, this.beans);
        buttonEl.classList.add('ag-chart-menu-icon');
        const wrapperEl = (0, ag_grid_community_1._getDocument)(this.beans).createElement('button');
        wrapperEl.appendChild(buttonEl);
        wrapperEl.classList.add('ag-chart-menu-toolbar-button');
        return wrapperEl;
    }
    destroy() {
        this.buttonListenersDestroyFuncs = [];
        super.destroy();
    }
}
exports.ChartToolbar = ChartToolbar;


/***/ }),

/***/ 2477:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CategoriesDataPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const chartDataModel_1 = __webpack_require__(8592);
const dragDataPanel_1 = __webpack_require__(6532);
const DEFAULT_AGG_FUNC = 'sum';
class CategoriesDataPanel extends dragDataPanel_1.DragDataPanel {
    constructor(chartController, title, allowMultipleSelection, dimensionCols, isOpen) {
        const maxSelection = undefined;
        super(chartController, allowMultipleSelection, maxSelection, /* html */ `<div id="categoriesGroup"></div>`);
        this.title = title;
        this.dimensionCols = dimensionCols;
        this.isOpen = isOpen;
    }
    postConstruct() {
        this.groupComp = this.createBean(new agGroupComponent_1.AgGroupComponent({
            title: this.title,
            enabled: true,
            suppressEnabledCheckbox: true,
            suppressOpenCloseIcons: false,
            cssIdentifier: 'charts-data',
            expanded: this.isOpen,
        }));
        this.createGroup(this.dimensionCols, (col) => col.displayName ?? '', 'categoryAdd', 'categorySelect', () => !this.chartController.getAggFunc());
        this.createAggFuncControls(this.dimensionCols);
        this.getGui().appendChild(this.groupComp.getGui());
    }
    refresh(dimensionCols) {
        this.valuePillSelect?.setValues(dimensionCols, dimensionCols.filter((col) => col.selected));
        this.refreshValueSelect(dimensionCols);
        this.refreshAggFuncControls(dimensionCols, this.chartController.getAggFunc());
    }
    createAggFuncControls(dimensionCols) {
        const aggFunc = this.chartController.getAggFunc();
        this.groupComp.addItem((this.aggFuncToggle = this.createBean(new ag_grid_community_1.AgToggleButton({
            label: this.chartTranslation.translate('aggregate'),
            labelAlignment: 'left',
            labelWidth: 'flex',
            inputWidth: 'flex',
            value: aggFunc != undefined,
            onValueChange: (value) => {
                const aggFunc = value ? DEFAULT_AGG_FUNC : undefined;
                this.chartController.setAggFunc(aggFunc);
                this.aggFuncSelect?.setValue(aggFunc, true);
                this.aggFuncSelect?.setDisplayed(aggFunc != undefined);
            },
        }))));
        this.groupComp.addItem((this.aggFuncSelect = this.createBean(new ag_grid_community_1.AgSelect({
            options: [
                { value: 'sum', text: this.chartTranslation.translate('sum') },
                { value: 'first', text: this.chartTranslation.translate('first') },
                { value: 'last', text: this.chartTranslation.translate('last') },
                { value: 'min', text: this.chartTranslation.translate('min') },
                { value: 'max', text: this.chartTranslation.translate('max') },
                { value: 'count', text: this.chartTranslation.translate('count') },
                { value: 'avg', text: this.chartTranslation.translate('avg') },
            ],
            value: typeof aggFunc === 'string' ? aggFunc : undefined,
            onValueChange: (value) => {
                this.chartController.setAggFunc(value);
            },
        }))));
        this.refreshAggFuncControls(dimensionCols, aggFunc);
    }
    refreshAggFuncControls(dimensionCols, aggFunc) {
        const selectedDimensions = dimensionCols.filter((col) => col.selected);
        const supportsAggregation = selectedDimensions.some((col) => col.colId !== chartDataModel_1.DEFAULT_CHART_CATEGORY);
        this.aggFuncToggle?.setValue(aggFunc != undefined);
        this.aggFuncSelect?.setValue(typeof aggFunc === 'string' ? aggFunc : undefined, true);
        this.aggFuncToggle?.setDisplayed(supportsAggregation);
        this.aggFuncSelect?.setDisplayed(supportsAggregation && aggFunc != undefined);
    }
    clearAggFuncControls() {
        this.aggFuncToggle = this.destroyBean(this.aggFuncToggle);
        this.aggFuncSelect = this.destroyBean(this.aggFuncSelect);
    }
    destroy() {
        this.clearAggFuncControls();
        this.groupComp = this.destroyBean(this.groupComp);
        super.destroy();
    }
}
exports.CategoriesDataPanel = CategoriesDataPanel;


/***/ }),

/***/ 1504:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartDataPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const seriesTypeMapper_1 = __webpack_require__(4237);
const categoriesDataPanel_1 = __webpack_require__(2477);
const chartSpecificDataPanel_1 = __webpack_require__(5524);
const seriesChartTypePanel_1 = __webpack_require__(1625);
const seriesDataPanel_1 = __webpack_require__(3365);
const DefaultDataPanelDef = {
    groups: [
        { type: 'categories', isOpen: true },
        { type: 'series', isOpen: true },
        { type: 'seriesChartType', isOpen: true },
        { type: 'chartSpecific', isOpen: true },
    ],
};
class ChartDataPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
        this.chartSvc = beans.chartSvc;
    }
    constructor(chartMenuContext) {
        super(/* html */ `<div class="ag-chart-data-wrapper ag-scrollable-container"></div>`);
        this.chartMenuContext = chartMenuContext;
        this.isSwitchCategorySeriesToggled = false;
        this.restoreSwitchCategorySeriesToggleFocus = false;
        this.panels = [];
        this.chartController = chartMenuContext.chartController;
    }
    postConstruct() {
        this.createSwitchCategorySeriesToggle();
        this.isSwitchCategorySeriesToggled = this.chartController.isCategorySeriesSwitched();
        this.updatePanels();
        const listener = this.updatePanels.bind(this);
        this.addManagedListeners(this.chartController, {
            chartModelUpdate: listener,
            chartApiUpdate: listener,
        });
    }
    destroy() {
        this.clearPanelComponents();
        super.destroy();
    }
    updatePanels() {
        const currentChartType = this.chartType;
        const isSwitchCategorySeriesToggledCurrent = this.isSwitchCategorySeriesToggled;
        const { dimensionCols, valueCols } = this.chartController.getColStateForMenu();
        this.chartType = this.chartController.getChartType();
        // Determine the state of the category/series toggle
        this.isSwitchCategorySeriesToggled = this.chartController.isCategorySeriesSwitched();
        const hasChangedSwitchCategorySeries = this.isSwitchCategorySeriesToggled !== isSwitchCategorySeriesToggledCurrent;
        // Attempt to re-use existing panels where possible in order to maintain keyboard focus
        if (this.canRefresh(currentChartType, this.chartType) && !hasChangedSwitchCategorySeries) {
            this.categoriesDataPanel?.refresh(dimensionCols);
            this.seriesDataPanel?.refresh(valueCols);
            this.seriesChartTypePanel?.refresh(valueCols);
            this.chartSpecificPanel?.refresh();
        }
        else {
            this.recreatePanels(dimensionCols, valueCols);
        }
        // Ensure the category/series toggle UI control is up-to-date
        const isSwitchCategorySeriesDisplayed = (0, seriesTypeMapper_1.supportsInvertedCategorySeries)(this.chartType) &&
            this.chartSvc.isEnterprise() &&
            !this.chartController.isGrouping();
        (0, ag_grid_community_1._setDisplayed)(this.switchCategorySeriesToggle.getGui(), isSwitchCategorySeriesDisplayed);
        if (hasChangedSwitchCategorySeries) {
            this.switchCategorySeriesToggle?.setValue(this.chartController.isCategorySeriesSwitched());
        }
        if (this.restoreSwitchCategorySeriesToggleFocus) {
            this.restoreSwitchCategorySeriesToggleFocus = false;
            if (isSwitchCategorySeriesDisplayed) {
                this.switchCategorySeriesToggle.getFocusableElement().focus();
            }
        }
    }
    canRefresh(oldChartType, newChartType) {
        if (oldChartType === undefined)
            return false;
        if (oldChartType === newChartType) {
            return true;
        }
        const isCombo = (chartType) => ['columnLineCombo', 'areaColumnCombo', 'customCombo'].includes(chartType);
        if (isCombo(oldChartType) && isCombo(newChartType)) {
            return true;
        }
        return false;
    }
    recreatePanels(dimensionCols, valueCols) {
        this.clearPanelComponents();
        const { chartType } = this;
        if (!chartType)
            return;
        const isCategorySeriesSwitched = this.chartController.isCategorySeriesSwitched();
        this.getDataPanelDef().groups?.forEach(({ type, isOpen }) => {
            if (type === (isCategorySeriesSwitched ? 'series' : 'categories')) {
                this.categoriesDataPanel = this.createBean(new categoriesDataPanel_1.CategoriesDataPanel(this.chartController, this.getCategoryGroupTitle(isCategorySeriesSwitched), this.getCategoryGroupMultipleSelect(chartType, isCategorySeriesSwitched), dimensionCols, isOpen));
                this.panels.push(this.categoriesDataPanel);
            }
            else if (type === (isCategorySeriesSwitched ? 'categories' : 'series')) {
                this.seriesDataPanel = this.createBean(new seriesDataPanel_1.SeriesDataPanel(this.chartController, this.chartMenuContext.chartOptionsService, this.getSeriesGroupTitle(isCategorySeriesSwitched), this.getSeriesGroupMultipleSelect(chartType, isCategorySeriesSwitched), this.getSeriesGroupMaxSelection(chartType, isCategorySeriesSwitched), valueCols, isOpen));
                this.panels.push(this.seriesDataPanel);
            }
            else if (type === 'seriesChartType') {
                if (this.chartController.isComboChart()) {
                    this.seriesChartTypePanel = this.createBean(new seriesChartTypePanel_1.SeriesChartTypePanel(this.chartController, valueCols, isOpen));
                    this.panels.push(this.seriesChartTypePanel);
                }
            }
            else if (type === 'chartSpecific') {
                this.chartSpecificPanel = this.createBean(new chartSpecificDataPanel_1.ChartSpecificDataPanel(this.chartMenuContext, isOpen));
                this.panels.push(this.chartSpecificPanel);
            }
            else {
                (0, ag_grid_community_1._warn)(144, { type });
            }
        });
        (isCategorySeriesSwitched ? this.categoriesDataPanel : this.seriesDataPanel)?.addItem(this.switchCategorySeriesToggle.getGui());
        this.addPanelComponents();
    }
    addPanelComponents() {
        if (!this.panels.length) {
            return;
        }
        const eDocument = (0, ag_grid_community_1._getDocument)(this.beans);
        const fragment = eDocument.createDocumentFragment();
        for (const panel of this.panels) {
            panel.addCssClass('ag-chart-data-section');
            fragment.appendChild(panel.getGui());
        }
        this.getGui().appendChild(fragment);
    }
    clearPanelComponents() {
        const eGui = this.getGui();
        this.panels.forEach((panel) => {
            eGui.removeChild(panel.getGui());
            this.destroyBean(panel);
        });
        this.panels = [];
    }
    getDataPanelDef() {
        return this.gos.get('chartToolPanelsDef')?.dataPanel ?? DefaultDataPanelDef;
    }
    getCategoryGroupTitle(isCategorySeriesSwitched) {
        if (isCategorySeriesSwitched)
            return this.chartTranslation.translate('seriesLabels');
        return this.chartTranslation.translate(this.chartController.isActiveXYChart() ? 'labels' : 'categories');
    }
    getCategoryGroupMultipleSelect(chartType, isCategorySeriesSwitched) {
        if (isCategorySeriesSwitched)
            return false;
        return (0, seriesTypeMapper_1.getMaxNumCategories)(chartType) !== 1;
    }
    getSeriesGroupTitle(isCategorySeriesSwitched) {
        if (isCategorySeriesSwitched)
            return this.chartTranslation.translate('categoryValues');
        return this.chartTranslation.translate(this.chartController.isActiveXYChart() ? 'xyValues' : 'series');
    }
    getSeriesGroupMultipleSelect(chartType, isCategorySeriesSwitched) {
        return this.getSeriesGroupMaxSelection(chartType, isCategorySeriesSwitched) !== 1;
    }
    getSeriesGroupMaxSelection(chartType, isCategorySeriesSwitched) {
        if (isCategorySeriesSwitched)
            return undefined;
        return (0, seriesTypeMapper_1.getMaxNumSeries)(chartType);
    }
    createSwitchCategorySeriesToggle() {
        this.switchCategorySeriesToggle = this.createManagedBean(new ag_grid_community_1.AgToggleButton({
            label: this.chartTranslation.translate('switchCategorySeries'),
            labelAlignment: 'left',
            labelWidth: 'flex',
            inputWidth: 'flex',
            value: this.chartController.isCategorySeriesSwitched(),
            onValueChange: (value) => {
                this.restoreSwitchCategorySeriesToggleFocus = true;
                this.chartController.switchCategorySeries(value);
            },
        }));
    }
}
exports.ChartDataPanel = ChartDataPanel;


/***/ }),

/***/ 5524:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartSpecificDataPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartMenuParamsFactory_1 = __webpack_require__(3786);
class ChartSpecificDataPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
        this.chartSvc = beans.chartSvc;
    }
    constructor(chartMenuContext, isOpen) {
        super();
        this.chartMenuContext = chartMenuContext;
        this.isOpen = isOpen;
        this.chartSpecificGroup = ag_grid_community_1.RefPlaceholder;
        this.hasContent = false;
    }
    postConstruct() {
        const title = this.getTitle();
        const chartSpecificGroupParams = {
            title,
            enabled: true,
            suppressEnabledCheckbox: true,
            suppressOpenCloseIcons: false,
            cssIdentifier: 'charts-data',
            expanded: this.isOpen,
            items: [...this.createDirectionSelect(), this.createReverseSelect(), this.createGroupTypeSelect()],
        };
        this.setTemplate(
        /* html */ `
            <div id="chartSpecificGroup">
                <ag-group-component data-ref="chartSpecificGroup"></ag-group-component>
            </div>`, [agGroupComponent_1.AgGroupComponentSelector], {
            chartSpecificGroup: chartSpecificGroupParams,
        });
        this.setDisplayed(this.hasContent);
    }
    refresh() {
        this.hasContent = false;
        this.chartSpecificGroup.setTitle(this.getTitle());
        this.updateDirectionSelect();
        this.updateReverseSelect();
        this.updateGroupTypeSelect();
        this.setDisplayed(this.hasContent);
    }
    getTitle() {
        const chartType = this.chartMenuContext.chartController.getChartType();
        return this.chartTranslation.translate((0, seriesTypeMapper_1.getFullChartNameTranslationKey)(chartType));
    }
    createDirectionSelect() {
        if (!this.chartSvc.isEnterprise()) {
            return [];
        }
        const { chartOptionsService, chartController } = this.chartMenuContext;
        const chartOptionsSeriesProxy = chartOptionsService.getSeriesOptionsProxy(() => (0, seriesTypeMapper_1.getSeriesType)(chartController.getChartType()));
        const chartSeriesMenuParamsFactory = this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(chartOptionsSeriesProxy));
        const options = ['horizontal', 'vertical'].map((value) => ({
            value,
            text: this.chartTranslation.translate(value),
        }));
        const params = chartSeriesMenuParamsFactory.getDefaultSelectParams('direction', 'direction', options);
        const onValueChange = params.onValueChange;
        params.onValueChange = (value) => {
            onValueChange(value);
            // series and axes configuration are based on direction
            chartController.raiseChartModelUpdateEvent();
        };
        this.directionSelect = this.createManagedBean(new ag_grid_community_1.AgSelect(params));
        this.updateDirectionSelect();
        return [this.directionSelect];
    }
    createReverseSelect() {
        const { chartMenuParamsFactory } = this.chartMenuContext;
        const params = chartMenuParamsFactory.getDefaultToggleParams('series.reverse', 'reverse');
        this.reverseToggle = this.createManagedBean(new ag_grid_community_1.AgToggleButton(params));
        this.updateReverseSelect();
        return this.reverseToggle;
    }
    updateReverseSelect() {
        const isDisplayed = this.chartMenuContext.chartController.getChartType() === 'pyramid';
        this.updateDisplayed(this.reverseToggle, isDisplayed);
    }
    updateDirectionSelect() {
        const isDisplayed = (0, seriesTypeMapper_1.canSwitchDirection)(this.chartMenuContext.chartController.getChartType());
        this.updateDisplayed(this.directionSelect, isDisplayed);
    }
    createGroupTypeSelect() {
        const { chartController, chartMenuParamsFactory } = this.chartMenuContext;
        this.groupTypeSelect = this.createManagedBean(new ag_grid_community_1.AgSelect(chartMenuParamsFactory.getDefaultSelectParamsWithoutValueParams('seriesGroupType', seriesTypeMapper_1.SERIES_GROUP_TYPES.map((value) => ({
            value,
            text: this.chartTranslation.translate(`${value}SeriesGroupType`),
        })), chartController.getSeriesGroupType(), (value) => chartController.setSeriesGroupType(value))));
        this.updateGroupTypeSelect();
        return this.groupTypeSelect;
    }
    updateGroupTypeSelect() {
        const isDisplayed = ['radialColumn', 'radialBar', 'nightingale'].includes(this.chartMenuContext.chartController.getChartType());
        this.updateDisplayed(this.groupTypeSelect, isDisplayed);
    }
    updateDisplayed(select, isDisplayed) {
        select?.setDisplayed(isDisplayed);
        if (select) {
            this.hasContent = this.hasContent || isDisplayed;
        }
    }
}
exports.ChartSpecificDataPanel = ChartSpecificDataPanel;


/***/ }),

/***/ 6532:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DragDataPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agPillSelect_1 = __webpack_require__(2406);
const chartDataModel_1 = __webpack_require__(8592);
class DragDataPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartController, allowMultipleSelection, maxSelection, template) {
        super(template);
        this.chartController = chartController;
        this.allowMultipleSelection = allowMultipleSelection;
        this.maxSelection = maxSelection;
    }
    addItem(eItem) {
        this.groupComp.addItem(eItem);
    }
    createGroup(columns, valueFormatter, selectLabelKey, dragSourceId, skipAnimation) {
        if (this.allowMultipleSelection) {
            const selectedValueList = columns.filter((col) => col.selected);
            this.valuePillSelect = this.groupComp.createManagedBean(new agPillSelect_1.AgPillSelect({
                valueList: columns,
                selectedValueList,
                valueFormatter,
                selectPlaceholder: this.chartTranslation.translate(selectLabelKey),
                dragSourceId,
                onValuesChange: (params) => this.onValueChange(params),
                maxSelection: this.maxSelection,
            }));
            this.groupComp.addItem(this.valuePillSelect);
        }
        else {
            const params = this.createValueSelectParams(columns);
            params.onValueChange = (updatedColState) => {
                columns.forEach((col) => {
                    col.selected = false;
                });
                updatedColState.selected = true;
                // Clear the category aggregation function if the default ordinal category is selected
                if (updatedColState.colId === chartDataModel_1.DEFAULT_CHART_CATEGORY) {
                    this.chartController.setAggFunc(undefined, true);
                }
                this.chartController.updateForPanelChange({ updatedColState, skipAnimation: skipAnimation?.() });
            };
            this.valueSelect = this.groupComp.createManagedBean(new ag_grid_community_1.AgSelect(params));
            this.groupComp.addItem(this.valueSelect);
        }
    }
    refreshValueSelect(columns) {
        if (!this.valueSelect) {
            return;
        }
        const { options, value } = this.createValueSelectParams(columns);
        this.valueSelect.clearOptions().addOptions(options).setValue(value, true);
    }
    createValueSelectParams(columns) {
        let selectedValue;
        const options = columns.map((value) => {
            const text = value.displayName ?? '';
            if (value.selected) {
                selectedValue = value;
            }
            return {
                value,
                text,
            };
        });
        return {
            options,
            value: selectedValue,
        };
    }
    onValueChange({ added, updated, removed, selected }) {
        let updatedColState;
        let resetOrder;
        const updateOrder = () => {
            selected.forEach((col, index) => {
                col.order = index;
            });
            resetOrder = true;
        };
        if (added.length) {
            updatedColState = added[0];
            updatedColState.selected = true;
            updateOrder();
        }
        else if (removed.length) {
            updatedColState = removed[0];
            updatedColState.selected = false;
        }
        else if (updated.length) {
            updateOrder();
            updatedColState = updated[0];
        }
        if (updatedColState) {
            this.chartController.updateForPanelChange({ updatedColState, resetOrder });
        }
    }
    destroy() {
        this.valuePillSelect = undefined;
        this.valueSelect = undefined;
        super.destroy();
    }
}
exports.DragDataPanel = DragDataPanel;


/***/ }),

/***/ 1625:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SeriesChartTypePanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const seriesTypeMapper_1 = __webpack_require__(4237);
class SeriesChartTypePanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartController, columns, isOpen) {
        super(/* html */ `<div id="seriesChartTypeGroup"></div>`);
        this.chartController = chartController;
        this.columns = columns;
        this.isOpen = isOpen;
        this.selectedColIds = [];
        this.chartTypeComps = new Map();
        this.secondaryAxisComps = new Map();
    }
    postConstruct() {
        this.createSeriesChartTypeGroup(this.columns);
    }
    refresh(columns) {
        if (!(0, ag_grid_community_1._areEqual)(this.getValidColIds(columns), this.selectedColIds)) {
            this.recreate(columns);
        }
        else {
            this.refreshComps();
        }
    }
    recreate(columns) {
        this.isOpen = this.seriesChartTypeGroupComp.isExpanded();
        (0, ag_grid_community_1._clearElement)(this.getGui());
        this.destroyBean(this.seriesChartTypeGroupComp);
        this.columns = columns;
        this.selectedColIds = [];
        this.clearComps();
        this.postConstruct();
    }
    getValidColIds(columns) {
        const seriesChartTypes = this.chartController.getSeriesChartTypes();
        return columns
            .filter((col) => col.selected && !!seriesChartTypes.filter((s) => s.colId === col.colId)[0])
            .map(({ colId }) => colId);
    }
    createSeriesChartTypeGroup(columns) {
        this.seriesChartTypeGroupComp = this.createBean(new agGroupComponent_1.AgGroupComponent({
            title: this.chartTranslation.translate('seriesChartType'),
            enabled: true,
            suppressEnabledCheckbox: true,
            suppressOpenCloseIcons: false,
            cssIdentifier: 'charts-data',
            expanded: this.isOpen,
        }));
        const seriesChartTypes = this.chartController.getSeriesChartTypes();
        columns.forEach((col) => {
            if (!col.selected) {
                return;
            }
            const seriesChartType = seriesChartTypes.filter((s) => s.colId === col.colId)[0];
            if (!seriesChartType) {
                return;
            }
            this.selectedColIds.push(col.colId);
            const seriesItemGroup = this.seriesChartTypeGroupComp.createManagedBean(new agGroupComponent_1.AgGroupComponent({
                title: col.displayName,
                enabled: true,
                suppressEnabledCheckbox: true,
                suppressOpenCloseIcons: true,
                cssIdentifier: 'charts-format-sub-level',
            }));
            const isSecondaryAxisDisabled = (chartType) => ['groupedColumn', 'stackedColumn', 'stackedArea'].includes(chartType);
            const secondaryAxisComp = this.seriesChartTypeGroupComp.createManagedBean(new ag_grid_community_1.AgCheckbox({
                label: this.chartTranslation.translate('secondaryAxis'),
                labelWidth: 'flex',
                disabled: isSecondaryAxisDisabled(seriesChartType.chartType),
                value: !!seriesChartType.secondaryAxis,
                onValueChange: (enabled) => this.chartController.updateSeriesChartType(col.colId, undefined, enabled),
            }));
            seriesItemGroup.addItem(secondaryAxisComp);
            const options = ['line', 'area', 'stackedArea', 'groupedColumn', 'stackedColumn'].map((value) => ({
                value,
                text: this.chartTranslation.translate((0, seriesTypeMapper_1.getFullChartNameTranslationKey)(value)),
            }));
            const chartTypeComp = seriesItemGroup.createManagedBean(new ag_grid_community_1.AgSelect({
                options,
                value: seriesChartType.chartType,
                onValueChange: (chartType) => this.chartController.updateSeriesChartType(col.colId, chartType),
            }));
            seriesItemGroup.addItem(chartTypeComp);
            this.seriesChartTypeGroupComp.addItem(seriesItemGroup);
            this.chartTypeComps.set(col.colId, chartTypeComp);
            this.secondaryAxisComps.set(col.colId, secondaryAxisComp);
        });
        this.getGui().appendChild(this.seriesChartTypeGroupComp.getGui());
    }
    refreshComps() {
        const seriesChartTypes = this.chartController.getSeriesChartTypes();
        this.selectedColIds.forEach((colId) => {
            const seriesChartType = seriesChartTypes.find((chartType) => chartType.colId === colId);
            if (!seriesChartType) {
                return;
            }
            const chartTypeComp = this.chartTypeComps.get(colId);
            const secondaryAxisComp = this.secondaryAxisComps.get(colId);
            chartTypeComp?.setValue(seriesChartType.chartType);
            secondaryAxisComp?.setValue(!!seriesChartType.secondaryAxis);
            secondaryAxisComp?.setDisabled(this.isSecondaryAxisDisabled(seriesChartType.chartType));
        });
    }
    clearComps() {
        this.chartTypeComps.clear();
        this.secondaryAxisComps.clear();
    }
    isSecondaryAxisDisabled(chartType) {
        return ['groupedColumn', 'stackedColumn', 'stackedArea'].includes(chartType);
    }
    destroy() {
        this.clearComps();
        this.seriesChartTypeGroupComp = this.destroyBean(this.seriesChartTypeGroupComp);
        super.destroy();
    }
}
exports.SeriesChartTypePanel = SeriesChartTypePanel;


/***/ }),

/***/ 3365:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SeriesDataPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const dragDataPanel_1 = __webpack_require__(6532);
class SeriesDataPanel extends dragDataPanel_1.DragDataPanel {
    constructor(chartController, chartOptionsService, title, allowMultipleSelect, maxSelection, valueCols, isOpen) {
        super(chartController, allowMultipleSelect, maxSelection, /* html */ `<div id="seriesGroup"></div>`);
        this.chartOptionsService = chartOptionsService;
        this.title = title;
        this.valueCols = valueCols;
        this.isOpen = isOpen;
    }
    postConstruct() {
        this.groupComp = this.createBean(new agGroupComponent_1.AgGroupComponent({
            title: this.title,
            enabled: true,
            suppressEnabledCheckbox: true,
            suppressOpenCloseIcons: false,
            cssIdentifier: 'charts-data',
            expanded: this.isOpen,
        }));
        if (this.chartController.isActiveXYChart()) {
            const pairedModeToggle = this.groupComp.createManagedBean(new ag_grid_community_1.AgToggleButton({
                label: this.chartTranslation.translate('paired'),
                labelAlignment: 'left',
                labelWidth: 'flex',
                inputWidth: 'flex',
                value: this.chartOptionsService.getPairedMode(),
                onValueChange: (newValue) => {
                    this.chartOptionsService.setPairedMode(!!newValue);
                    this.chartController.updateForGridChange({ maintainColState: true });
                },
            }));
            this.groupComp.addItem(pairedModeToggle);
        }
        this.createGroup(this.valueCols, this.generateGetSeriesLabel(this.valueCols), 'seriesAdd', 'seriesSelect');
        this.getGui().appendChild(this.groupComp.getGui());
    }
    refresh(valueCols) {
        this.valuePillSelect?.setValueFormatter(this.generateGetSeriesLabel(valueCols));
        this.valuePillSelect?.setValues(valueCols, valueCols.filter((col) => col.selected));
        this.refreshValueSelect(valueCols);
    }
    generateGetSeriesLabel(valueCols) {
        if (!this.chartController.isActiveXYChart()) {
            return (col) => col.displayName ?? '';
        }
        const selectedCols = valueCols.filter((col) => col.selected);
        const isBubble = this.chartController.getChartType() === 'bubble';
        const isInPairedMode = this.chartOptionsService.getPairedMode();
        const indexToAxisLabel = new Map();
        indexToAxisLabel.set(0, 'X');
        indexToAxisLabel.set(1, 'Y');
        indexToAxisLabel.set(2, 'size');
        return (col) => {
            const escapedLabel = col.displayName ?? '';
            if (!col.selected) {
                return escapedLabel;
            }
            const index = selectedCols.indexOf(col);
            if (index === -1) {
                return escapedLabel;
            }
            let axisLabel;
            if (isInPairedMode) {
                axisLabel = indexToAxisLabel.get(index % (isBubble ? 3 : 2));
            }
            else {
                if (index === 0) {
                    axisLabel = 'X';
                }
                else {
                    axisLabel = isBubble && index % 2 === 0 ? 'size' : 'Y';
                }
            }
            return `${escapedLabel} (${axisLabel})`;
        };
    }
    destroy() {
        this.groupComp = this.destroyBean(this.groupComp);
        super.destroy();
    }
}
exports.SeriesDataPanel = SeriesDataPanel;


/***/ }),

/***/ 5248:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AxisTicksPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
class AxisTicksPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
        this.axisTicksSizeSlider = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        const { chartMenuUtils } = this;
        const axisTicksGroupParams = chartMenuUtils.addEnableParams('tick.enabled', {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('ticks'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const axisTicksColorPickerParams = chartMenuUtils.getDefaultColorPickerParams('tick.stroke');
        const axisTicksWidthSliderParams = chartMenuUtils.getDefaultSliderParams('tick.width', 'width', 10);
        const axisTicksSizeSliderParams = chartMenuUtils.getDefaultSliderParams('tick.size', 'length', 30);
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="axisTicksGroup">
                <ag-color-picker data-ref="axisTicksColorPicker"></ag-color-picker>
                <ag-slider data-ref="axisTicksWidthSlider"></ag-slider>
                <ag-slider data-ref="axisTicksSizeSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            axisTicksGroup: axisTicksGroupParams,
            axisTicksColorPicker: axisTicksColorPickerParams,
            axisTicksWidthSlider: axisTicksWidthSliderParams,
            axisTicksSizeSlider: axisTicksSizeSliderParams,
        });
    }
    setTickSizeSliderDisplayed(displayed) {
        this.axisTicksSizeSlider.setDisplayed(displayed);
    }
}
exports.AxisTicksPanel = AxisTicksPanel;


/***/ }),

/***/ 5002:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CartesianAxisPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agAngleSelect_1 = __webpack_require__(1750);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
const chartMenuParamsFactory_1 = __webpack_require__(3786);
const fontPanel_1 = __webpack_require__(7730);
const axisTicksPanel_1 = __webpack_require__(5248);
const gridLinePanel_1 = __webpack_require__(4513);
const DEFAULT_TIME_AXIS_FORMAT = '%d %B %Y';
class CartesianAxisPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(axisType, options) {
        super();
        this.axisType = axisType;
        this.options = options;
        this.axisGroup = ag_grid_community_1.RefPlaceholder;
        this.axisTypeSelect = ag_grid_community_1.RefPlaceholder;
        this.axisPositionSelect = ag_grid_community_1.RefPlaceholder;
        this.axisTimeFormatSelect = ag_grid_community_1.RefPlaceholder;
        this.activePanels = [];
        this.updateFuncs = [];
        const { chartOptionsService, seriesType, chartController } = options;
        this.chartOptionsService = chartOptionsService;
        this.chartController = chartController;
        this.chartOptionsSeriesProxy = chartOptionsService.getSeriesOptionsProxy(() => seriesType);
    }
    postConstruct() {
        const { isExpandedOnInit: expanded, chartOptionsService, registerGroupComponent } = this.options;
        const labelKey = this.axisType;
        const axisGroupParams = {
            cssIdentifier: 'charts-format-top-level',
            direction: 'vertical',
            title: this.translate(labelKey),
            expanded,
            suppressEnabledCheckbox: true,
        };
        const chartAxisOptionsProxy = chartOptionsService.getCartesianAxisOptionsProxy(this.axisType);
        const chartAxisOptions = this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(chartAxisOptionsProxy));
        const chartAxisThemeOverrides = this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(chartOptionsService.getCartesianAxisThemeOverridesProxy(this.axisType)));
        const axisTypeSelectParams = this.getAxisTypeSelectParams(chartAxisOptions, chartOptionsService.getCartesianAxisAppliedThemeOverridesProxy(this.axisType));
        const axisPositionSelectParams = this.getAxisPositionSelectParams(chartAxisOptions);
        const axisTimeFormatSelectParams = this.getAxisTimeFormatSelectParams(chartAxisOptions);
        const axisColorInputParams = this.getAxisColorInputParams(chartAxisThemeOverrides);
        const axisLineWidthSliderParams = this.getAxisLineWidthSliderParams(chartAxisThemeOverrides);
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="axisGroup">
                <ag-select data-ref="axisTypeSelect"></ag-select>
                <ag-select data-ref="axisTimeFormatSelect"></ag-select>
                <ag-select data-ref="axisPositionSelect"></ag-select>
                <ag-color-picker data-ref="axisColorInput"></ag-color-picker>
                <ag-slider data-ref="axisLineWidthSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgSelectSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            axisGroup: axisGroupParams,
            axisTypeSelect: axisTypeSelectParams ?? undefined,
            axisPositionSelect: axisPositionSelectParams ?? undefined,
            axisTimeFormatSelect: axisTimeFormatSelectParams ?? undefined,
            axisColorInput: axisColorInputParams,
            axisLineWidthSlider: axisLineWidthSliderParams,
        });
        registerGroupComponent(this.axisGroup);
        this.axisTypeSelect.setDisplayed(!!axisTypeSelectParams.options?.length);
        if (!axisPositionSelectParams)
            this.removeTemplateComponent(this.axisPositionSelect);
        const updateTimeFormatVisibility = () => {
            const isTimeAxis = chartAxisOptionsProxy.getValue('type') === 'time';
            (0, ag_grid_community_1._setDisplayed)(this.axisTimeFormatSelect.getGui(), isTimeAxis);
        };
        if (!axisTimeFormatSelectParams) {
            this.removeTemplateComponent(this.axisTimeFormatSelect);
        }
        else {
            // Conditionally hide the time format input based on the currently selected axis type
            updateTimeFormatVisibility();
            // Update the visibility whenever the axis type changes
            this.addManagedEventListeners({
                chartOptionsChanged: () => {
                    updateTimeFormatVisibility();
                },
            });
        }
        this.initGridLines(chartAxisThemeOverrides);
        this.initAxisTicks(chartAxisThemeOverrides);
        this.initAxisLabels(chartAxisThemeOverrides);
        const updateFns = () => this.updateFuncs.forEach((func) => func());
        this.addManagedListeners(this.chartController, {
            chartUpdated: updateFns,
            chartModelUpdate: () => setTimeout(() => {
                if (!this.isAlive()) {
                    return;
                }
                // make sure this runs after the actual chart update has happened
                this.refreshAxisTypeSelect(chartAxisOptions);
                updateTimeFormatVisibility();
            }),
        });
    }
    getAxisTypeSelectParams(chartAxisOptions, chartAxisAppliedThemeOverrides) {
        const chartOptions = chartAxisOptions.getChartOptions();
        const axisTypeSelectOptions = this.getAxisTypeSelectOptions();
        const params = chartAxisOptions.getDefaultSelectParams('type', 'axisType', axisTypeSelectOptions);
        params.onValueChange = (value) => {
            const previousAxisType = chartOptions.getValue('type');
            if (value === previousAxisType)
                return;
            // If the axis type is changed, we need to carry over all the accumulated theme overrides
            // that have been applied to the existing axis type so far
            const previousAxisThemeOverrides = chartAxisAppliedThemeOverrides.getValue('*');
            // Optionally update the axis label format when switching between time and non-time axes
            const previousAxisIsTimeAxis = previousAxisType === 'time';
            const updatedAxisIsTimeAxis = value === 'time';
            const updatedLabelFormat = previousAxisIsTimeAxis !== updatedAxisIsTimeAxis
                ? updatedAxisIsTimeAxis
                    ? DEFAULT_TIME_AXIS_FORMAT
                    : undefined
                : null;
            // Update the axis type (and label format if necessary)
            this.chartOptionsService.setCartesianCategoryAxisType(this.axisType, value);
            if (updatedLabelFormat !== null) {
                const existingLabel = chartOptions.getValue('label') ?? {};
                chartOptions.setValue('label', {
                    ...existingLabel,
                    format: updatedLabelFormat,
                });
            }
            // Reapply the previous theme overrides to the new axis type
            chartAxisAppliedThemeOverrides.setValue('*', previousAxisThemeOverrides);
        };
        return params;
    }
    refreshAxisTypeSelect(chartAxisOptions) {
        const options = this.getAxisTypeSelectOptions();
        const hasOptions = !!options.length;
        this.axisTypeSelect.setDisplayed(hasOptions);
        if (!hasOptions) {
            return;
        }
        this.axisTypeSelect
            .clearOptions()
            .addOptions(options)
            .setValue(chartAxisOptions.getChartOptions().getValue('type'));
    }
    getAxisTypeSelectOptions() {
        const controller = this.chartController;
        const chartType = controller.getChartType();
        const supportsNumericalAxis = () => {
            const testDatum = controller.getChartData()[0];
            if (!testDatum) {
                return false;
            }
            return controller.getSelectedDimensions().every((col) => !isNaN(parseFloat(testDatum[col.colId])));
        };
        if (['heatmap', 'histogram', 'boxPlot', 'rangeBar', 'scatter', 'bubble'].includes(chartType) ||
            controller.isGrouping() ||
            !this.isCategoryAxis() ||
            controller.isCategorySeriesSwitched() ||
            !supportsNumericalAxis()) {
            return [];
        }
        return ['category', 'number', 'time'].map((value) => ({
            value,
            text: this.translate(value),
        }));
    }
    isCategoryAxis() {
        const isHorizontal = this.chartOptionsSeriesProxy.getValue('direction') === 'horizontal';
        return (isHorizontal && this.axisType === 'yAxis') || (!isHorizontal && this.axisType === 'xAxis');
    }
    getAxisPositionSelectParams(chartAxisOptions) {
        const axisPositionSelectOptions = ((chartType, axisType) => {
            switch (chartType) {
                // Some chart types do not support configuring the axis position
                case 'heatmap':
                    return null;
                default:
                    switch (axisType) {
                        // Horizontal axis position can be changed between top and bottom
                        case 'xAxis':
                            return [
                                { value: 'top', text: this.translate('top') },
                                { value: 'bottom', text: this.translate('bottom') },
                            ];
                        // Vertical axis position can be changed between left and right
                        case 'yAxis':
                            return [
                                { value: 'left', text: this.translate('left') },
                                { value: 'right', text: this.translate('right') },
                            ];
                    }
            }
        })(this.chartController.getChartType(), this.axisType);
        if (!axisPositionSelectOptions)
            return null;
        return chartAxisOptions.getDefaultSelectParams('position', 'position', axisPositionSelectOptions);
    }
    getAxisTimeFormatSelectParams(chartAxisOptions) {
        if (!this.isCategoryAxis()) {
            return null;
        }
        const axisTimeFormatSelectOptions = [
            { value: '%d/%m/%Y', text: this.translate('timeFormatSlashesDDMMYYYY') },
            { value: '%m/%d/%Y', text: this.translate('timeFormatSlashesMMDDYYYY') },
            { value: '%d/%m/%y', text: this.translate('timeFormatSlashesDDMMYY') },
            { value: '%m/%d/%y', text: this.translate('timeFormatSlashesMMDDYY') },
            { value: '%d.%e.%y', text: this.translate('timeFormatDotsDDMYY') },
            { value: '%e.%d.%y', text: this.translate('timeFormatDotsMDDYY') },
            { value: '%Y-%m-%d', text: this.translate('timeFormatDashesYYYYMMDD') },
            { value: '%d %B %Y', text: this.translate('timeFormatSpacesDDMMMMYYYY') },
            { value: '%H:%M:%S', text: this.translate('timeFormatHHMMSS') },
            { value: '%I:%M:%S %p', text: this.translate('timeFormatHHMMSSAmPm') },
        ];
        return chartAxisOptions.getDefaultSelectParams('label.format', 'timeFormat', axisTimeFormatSelectOptions);
    }
    getAxisColorInputParams(chartAxisThemeOverrides) {
        return chartAxisThemeOverrides.getDefaultColorPickerParams('line.stroke');
    }
    getAxisLineWidthSliderParams(chartAxisThemeOverrides) {
        const chartOptions = chartAxisThemeOverrides.getChartOptions();
        // Note that there is no separate checkbox for enabling/disabling the axis line. Whenever the line width is
        // changed, the value for `line.enabled` is inferred based on the whether the `line.width` value is non-zero.
        const getAxisLineWidth = () => {
            const isAxisLineEnabled = chartOptions.getValue('line.enabled');
            if (!isAxisLineEnabled)
                return null;
            return chartOptions.getValue('line.width');
        };
        const setAxisLineWidth = (value) => {
            chartOptions.setValues([
                { expression: 'line.enabled', value: value != null },
                { expression: 'line.width', value: value ?? 0 },
            ]);
        };
        const axisLineWidthSliderParams = chartAxisThemeOverrides.getDefaultSliderParamsWithoutValueParams(getAxisLineWidth() ?? 0, 'thickness', 10);
        axisLineWidthSliderParams.onValueChange = (newValue) => {
            setAxisLineWidth(newValue === 0 ? null : newValue);
        };
        return axisLineWidthSliderParams;
    }
    initGridLines(chartAxisThemeOverrides) {
        const chartType = this.chartController.getChartType();
        // Some chart types do not support configuring grid lines
        if (chartType === 'heatmap') {
            return;
        }
        const gridLineComp = this.createBean(new gridLinePanel_1.GridLinePanel(chartAxisThemeOverrides));
        this.axisGroup.addItem(gridLineComp);
        this.activePanels.push(gridLineComp);
    }
    initAxisTicks(chartAxisThemeOverrides) {
        if (!this.hasConfigurableAxisTicks())
            return;
        const axisTicksComp = this.createBean(new axisTicksPanel_1.AxisTicksPanel(chartAxisThemeOverrides));
        this.axisGroup.addItem(axisTicksComp);
        this.activePanels.push(axisTicksComp);
        const updateTickFn = () => axisTicksComp.setTickSizeSliderDisplayed(this.isGroupedCategoryAxis());
        this.updateFuncs.push(updateTickFn);
        updateTickFn();
    }
    hasConfigurableAxisTicks() {
        // Axis ticks are disabled for some chart types
        const chartType = this.chartController.getChartType();
        switch (chartType) {
            case 'radarLine':
            case 'radarArea':
            case 'rangeBar':
            case 'boxPlot':
            case 'waterfall':
                return false;
            default:
                return true;
        }
    }
    initAxisLabels(chartAxisThemeOverrides) {
        const params = {
            name: this.translate('labels'),
            enabled: true,
            suppressEnabledCheckbox: true,
            chartMenuParamsFactory: chartAxisThemeOverrides,
            keyMapper: (key) => `label.${key}`,
        };
        const labelPanelComp = this.createBean(new fontPanel_1.FontPanel(params));
        this.axisGroup.addItem(labelPanelComp);
        this.activePanels.push(labelPanelComp);
        this.addAdditionalLabelComps(labelPanelComp, chartAxisThemeOverrides);
    }
    addAdditionalLabelComps(labelPanelComp, chartAxisThemeOverrides) {
        this.addLabelPadding(labelPanelComp, chartAxisThemeOverrides);
        const rotationComp = this.createRotationWidget('labelRotation', chartAxisThemeOverrides);
        const autoRotateCb = this.initLabelRotation(rotationComp, chartAxisThemeOverrides);
        labelPanelComp.addItem(autoRotateCb);
        labelPanelComp.addItem(rotationComp);
    }
    initLabelRotation(rotationComp, chartAxisThemeOverrides) {
        const chartOptions = chartAxisThemeOverrides.getChartOptions();
        const getLabelRotationValue = () => {
            return chartOptions.getValue('label.rotation');
        };
        const getLabelAutoRotateValue = () => {
            return chartOptions.getValue('label.autoRotate');
        };
        const updateAutoRotate = (autoRotate) => {
            // Remember the existing rotation before we clear it from the options
            if (autoRotate)
                this.prevRotation = getLabelRotationValue();
            // For the autoRotate option to take effect, we need to additionally clear the rotation option value
            chartOptions.setValues([
                { expression: 'label.autoRotate', value: autoRotate },
                // Clear the rotation option when activating auto-rotate, reinstate the previous value when deactivating
                { expression: 'label.rotation', value: autoRotate ? undefined : this.prevRotation },
            ]);
            rotationComp.setDisplayed(!autoRotate);
        };
        const rotation = getLabelRotationValue();
        const autoRotate = typeof rotation === 'number' ? false : getLabelAutoRotateValue();
        const autoRotateCheckbox = this.createBean(new ag_grid_community_1.AgCheckbox({
            label: this.translate('autoRotate'),
            value: autoRotate,
            onValueChange: updateAutoRotate,
        }));
        // init rotation comp state
        rotationComp.setDisplayed(!autoRotate);
        const autoRotateUpdateFn = () => autoRotateCheckbox.setDisplayed(this.isGroupedCategoryAxis());
        this.updateFuncs.push(autoRotateUpdateFn);
        autoRotateUpdateFn();
        return autoRotateCheckbox;
    }
    createRotationWidget(labelKey, chartAxisThemeOverrides) {
        const chartOptions = chartAxisThemeOverrides.getChartOptions();
        const getLabelRotationValue = () => {
            return chartOptions.getValue('label.rotation');
        };
        const setLabelRotationValue = (value) => {
            return chartOptions.setValue('label.rotation', value);
        };
        const degreesSymbol = String.fromCharCode(176);
        const label = `${this.chartTranslation.translate(labelKey)} ${degreesSymbol}`;
        const angleSelect = new agAngleSelect_1.AgAngleSelect({
            label,
            labelWidth: 'flex',
            value: getLabelRotationValue() ?? 0,
            onValueChange: setLabelRotationValue,
        });
        // the axis label rotation needs to be updated when the default category changes in the data panel
        this.updateFuncs.push(() => {
            angleSelect.setValue(getLabelRotationValue() ?? 0);
        });
        return this.createBean(angleSelect);
    }
    isGroupedCategoryAxis() {
        const axisOptionsType = this.chartOptionsService.getCartesianAxisOptionsProxy(this.axisType).getValue('type');
        if (axisOptionsType === 'grouped-category') {
            return !this.isCategoryAxis();
        }
        return true;
    }
    addLabelPadding(labelPanelComp, chartAxisThemeOverrides) {
        const labelPaddingSlider = this.createBean(new agSlider_1.AgSlider(chartAxisThemeOverrides.getDefaultSliderParams('label.spacing', 'padding', 30)));
        labelPanelComp.addItem(labelPaddingSlider);
    }
    translate(key) {
        return this.chartTranslation.translate(key);
    }
    removeTemplateComponent(component) {
        (0, ag_grid_community_1._removeFromParent)(component.getGui());
        this.destroyBean(component);
    }
    destroyActivePanels() {
        this.activePanels.forEach((panel) => {
            (0, ag_grid_community_1._removeFromParent)(panel.getGui());
            this.destroyBean(panel);
        });
    }
    destroy() {
        this.destroyActivePanels();
        super.destroy();
    }
}
exports.CartesianAxisPanel = CartesianAxisPanel;


/***/ }),

/***/ 4513:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GridLinePanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
class GridLinePanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
        this.chartOptions = chartMenuUtils.getChartOptions();
    }
    postConstruct() {
        const gridLineGroupParams = this.chartMenuUtils.addEnableParams('gridLine.enabled', {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('gridLines'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const gridLineColorPickerParams = this.getGridLineColorPickerParams('color');
        const gridLineWidthSliderParams = this.getGridLineWidthSliderParams('thickness');
        const gridLineLineDashSliderParams = this.getGridLineDashSliderParams('lineDash');
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="gridLineGroup">
                <ag-color-picker data-ref="gridLineColorPicker"></ag-color-picker>
                <ag-slider data-ref="gridLineWidthSlider"></ag-slider>
                <ag-slider data-ref="gridLineLineDashSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            gridLineGroup: gridLineGroupParams,
            gridLineColorPicker: gridLineColorPickerParams,
            gridLineWidthSlider: gridLineWidthSliderParams,
            gridLineLineDashSlider: gridLineLineDashSliderParams,
        });
    }
    getGridLineColorPickerParams(labelKey) {
        return this.chartMenuUtils.getDefaultColorPickerParams('gridLine.style', labelKey, {
            formatInputValue: (value) => {
                return value?.[0]?.stroke;
            },
            parseInputValue: (value) => {
                const styles = this.chartOptions.getValue('gridLine.style') ?? [];
                if (styles.length === 0)
                    return [{ stroke: value, lineDash: [] }];
                return [{ ...styles[0], stroke: value }];
            },
        });
    }
    getGridLineWidthSliderParams(labelKey) {
        return this.chartMenuUtils.getDefaultSliderParams('gridLine.width', labelKey, 10);
    }
    getGridLineDashSliderParams(labelKey) {
        const initialStyles = this.chartOptions.getValue('gridLine.style');
        const initialValue = initialStyles?.[0]?.lineDash?.[0];
        const params = this.chartMenuUtils.getDefaultSliderParamsWithoutValueParams(initialValue ?? 0, labelKey, 30);
        params.onValueChange = (value) => {
            const stroke = this.chartOptions.getValue('gridLine.style.0.stroke');
            this.chartOptions.setValue('gridLine.style', [
                { lineDash: [value], stroke },
            ]);
        };
        return params;
    }
}
exports.GridLinePanel = GridLinePanel;


/***/ }),

/***/ 956:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PolarAxisPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
const seriesTypeMapper_1 = __webpack_require__(4237);
const fontPanel_1 = __webpack_require__(7730);
class PolarAxisPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(options) {
        super();
        this.options = options;
        this.axisGroup = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        const { isExpandedOnInit: expanded, chartAxisMenuParamsFactory, registerGroupComponent } = this.options;
        const axisGroupParams = {
            cssIdentifier: 'charts-format-top-level',
            direction: 'vertical',
            title: this.translate('polarAxis'),
            expanded,
            suppressEnabledCheckbox: true,
        };
        const axisColorInputParams = chartAxisMenuParamsFactory.getDefaultColorPickerParams('line.stroke');
        const axisLineWidthSliderParams = chartAxisMenuParamsFactory.getDefaultSliderParams('line.width', 'thickness', 10);
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="axisGroup">
                <ag-color-picker data-ref="axisColorInput"></ag-color-picker>
                <ag-slider data-ref="axisLineWidthSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            axisGroup: axisGroupParams,
            axisColorInput: axisColorInputParams,
            axisLineWidthSlider: axisLineWidthSliderParams,
        });
        registerGroupComponent(this.axisGroup);
        this.initAxis();
        this.initAxisLabels();
        this.initRadiusAxis();
    }
    initAxis() {
        const chartType = this.options.chartController.getChartType();
        const hasConfigurableAxisShape = ['radarLine', 'radarArea'].includes(chartType);
        if (hasConfigurableAxisShape) {
            const options = [
                { value: 'circle', text: this.translate('circle') },
                { value: 'polygon', text: this.translate('polygon') },
            ];
            this.axisGroup.addItem(this.createSelect({
                labelKey: 'shape',
                options: options,
                property: 'shape',
            }));
        }
        if (chartType !== 'pie') {
            this.axisGroup.addItem(this.createSlider({
                labelKey: 'innerRadius',
                defaultMaxValue: 1,
                property: 'innerRadiusRatio',
            }));
        }
    }
    initAxisLabels() {
        const params = {
            name: this.translate('labels'),
            enabled: true,
            suppressEnabledCheckbox: true,
            chartMenuParamsFactory: this.options.chartAxisMenuParamsFactory,
            keyMapper: (key) => `label.${key}`,
        };
        const labelPanelComp = this.createManagedBean(new fontPanel_1.FontPanel(params));
        const labelOrientationComp = this.createOrientationWidget();
        labelPanelComp.addItem(labelOrientationComp);
        this.axisGroup.addItem(labelPanelComp);
    }
    createOrientationWidget() {
        const options = [
            { value: 'fixed', text: this.translate('fixed') },
            { value: 'parallel', text: this.translate('parallel') },
            { value: 'perpendicular', text: this.translate('perpendicular') },
        ];
        return this.createSelect({
            labelKey: 'orientation',
            options,
            property: 'label.orientation',
        });
    }
    initRadiusAxis() {
        const chartSeriesType = (0, seriesTypeMapper_1.getSeriesType)(this.options.chartController.getChartType());
        if (!(0, seriesTypeMapper_1.isRadial)(chartSeriesType))
            return;
        const items = [
            this.createSlider({
                labelKey: 'groupPadding',
                defaultMaxValue: 1,
                property: 'paddingInner',
            }),
            this.createSlider({
                labelKey: 'seriesPadding',
                defaultMaxValue: 1,
                property: 'groupPaddingInner',
            }),
        ];
        const paddingPanelComp = this.createManagedBean(new agGroupComponent_1.AgGroupComponent({
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            enabled: true,
            suppressEnabledCheckbox: true,
            title: this.translate('padding'),
            items,
        }))
            .hideEnabledCheckbox(true)
            .hideOpenCloseIcons(true);
        this.axisGroup.addItem(paddingPanelComp);
    }
    createSlider(config) {
        const { labelKey, defaultMaxValue, step = 0.05, property } = config;
        const params = this.options.chartAxisMenuParamsFactory.getDefaultSliderParams(property, labelKey, defaultMaxValue);
        params.step = step;
        return this.createManagedBean(new agSlider_1.AgSlider(params));
    }
    createSelect(config) {
        const { labelKey, options, property } = config;
        return this.createManagedBean(new ag_grid_community_1.AgSelect(this.options.chartAxisMenuParamsFactory.getDefaultSelectParams(property, labelKey, options)));
    }
    translate(key) {
        return this.chartTranslation.translate(key);
    }
}
exports.PolarAxisPanel = PolarAxisPanel;


/***/ }),

/***/ 4742:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BackgroundPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
class BackgroundPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const chartBackgroundGroupParams = this.chartMenuUtils.addEnableParams('background.visible', {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('background'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const colorPickerParams = this.chartMenuUtils.getDefaultColorPickerParams('background.fill');
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="chartBackgroundGroup">
                <ag-color-picker data-ref="colorPicker"></ag-color-picker>
            </ag-group-component>
        <div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector], {
            chartBackgroundGroup: chartBackgroundGroupParams,
            colorPicker: colorPickerParams,
        });
    }
}
exports.BackgroundPanel = BackgroundPanel;


/***/ }),

/***/ 3628:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const backgroundPanel_1 = __webpack_require__(4742);
const paddingPanel_1 = __webpack_require__(2567);
class ChartPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(options) {
        super();
        this.options = options;
        this.chartGroup = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        const { chartController, chartMenuParamsFactory, isExpandedOnInit: expanded, registerGroupComponent, } = this.options;
        const chartGroupParams = {
            cssIdentifier: 'charts-format-top-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('chartStyle'),
            expanded,
            suppressEnabledCheckbox: true,
            items: [
                this.createManagedBean(new paddingPanel_1.PaddingPanel(chartMenuParamsFactory, chartController)),
                this.createManagedBean(new backgroundPanel_1.BackgroundPanel(chartMenuParamsFactory)),
            ],
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="chartGroup"></ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector], { chartGroup: chartGroupParams });
        registerGroupComponent(this.chartGroup);
    }
}
exports.ChartPanel = ChartPanel;


/***/ }),

/***/ 2567:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PaddingPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
class PaddingPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils, chartController) {
        super();
        this.chartMenuUtils = chartMenuUtils;
        this.chartController = chartController;
        this.paddingTopSlider = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        const chartPaddingGroupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('padding'),
            suppressEnabledCheckbox: true,
        };
        const getSliderParams = (property) => this.chartMenuUtils.getDefaultSliderParams('padding.' + property, property, 200);
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="chartPaddingGroup">
                <ag-slider data-ref="paddingTopSlider"></ag-slider>
                <ag-slider data-ref="paddingRightSlider"></ag-slider>
                <ag-slider data-ref="paddingBottomSlider"></ag-slider>
                <ag-slider data-ref="paddingLeftSlider"></ag-slider>
            </ag-group-component>
        <div>`, [agGroupComponent_1.AgGroupComponentSelector, agSlider_1.AgSliderSelector], {
            chartPaddingGroup: chartPaddingGroupParams,
            paddingTopSlider: getSliderParams('top'),
            paddingRightSlider: getSliderParams('right'),
            paddingBottomSlider: getSliderParams('bottom'),
            paddingLeftSlider: getSliderParams('left'),
        });
        this.addManagedEventListeners({
            chartOptionsChanged: (e) => {
                this.updateTopPadding(e.chartOptions);
            },
        });
    }
    updateTopPadding(chartOptions) {
        // keep 'top' padding in sync with chart as toggling chart title on / off change the 'top' padding
        const topPadding = [...this.chartController.getChartSeriesTypes(), 'common']
            .map((seriesType) => chartOptions[seriesType]?.padding?.top)
            .find((value) => value != null);
        if (topPadding != null) {
            this.paddingTopSlider.setValue(`${topPadding}`);
        }
    }
}
exports.PaddingPanel = PaddingPanel;


/***/ }),

/***/ 7730:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FontPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
function _capitalise(str) {
    return str[0].toUpperCase() + str.substring(1).toLowerCase();
}
class FontPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(params) {
        super();
        this.params = params;
        this.fontGroup = ag_grid_community_1.RefPlaceholder;
        this.activeComps = [];
        this.chartOptions = params.chartMenuParamsFactory.getChartOptions();
    }
    postConstruct() {
        const { cssIdentifier = 'charts-format-sub-level', name: title, enabled, onEnableChange, suppressEnabledCheckbox, chartMenuParamsFactory, keyMapper, } = this.params;
        const fontGroupParams = {
            cssIdentifier,
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title,
            enabled,
            suppressEnabledCheckbox: true,
            onEnableChange: (enabled) => {
                if (onEnableChange) {
                    onEnableChange(enabled);
                }
            },
            useToggle: !suppressEnabledCheckbox,
        };
        this.setTemplate(
        /* html */ `<div class="ag-font-panel">
        <ag-group-component data-ref="fontGroup">
            <ag-select data-ref="familySelect"></ag-select>
            <ag-select data-ref="weightStyleSelect"></ag-select>
            <div class="ag-charts-font-size-color">
                <ag-select data-ref="sizeSelect"></ag-select>
                <ag-color-picker data-ref="colorPicker"></ag-color-picker>
            </div>
        </ag-group-component>
    </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgSelectSelector, agColorPicker_1.AgColorPickerSelector], {
            fontGroup: fontGroupParams,
            familySelect: this.getFamilySelectParams(),
            weightStyleSelect: this.getWeightStyleSelectParams(),
            sizeSelect: this.getSizeSelectParams(),
            colorPicker: chartMenuParamsFactory.getDefaultColorPickerParams(keyMapper('color')),
        });
        this.addOrRemoveCssClass('ag-font-panel-no-header', !title);
    }
    addItem(comp, prepend) {
        if (prepend) {
            this.fontGroup.prependItem(comp);
        }
        else {
            this.fontGroup.addItem(comp);
        }
        this.activeComps.push(comp);
    }
    setEnabled(enabled) {
        this.fontGroup.setEnabled(enabled);
    }
    getFamilySelectParams() {
        const families = [
            'Arial, sans-serif',
            'Aria Black, sans-serif',
            'Book Antiqua,  serif',
            'Charcoal, sans-serif',
            'Comic Sans MS, cursive',
            'Courier, monospace',
            'Courier New, monospace',
            'Gadget, sans-serif',
            'Geneva, sans-serif',
            'Helvetica, sans-serif',
            'Impact, sans-serif',
            'Lucida Console, monospace',
            'Lucida Grande, sans-serif',
            'Lucida Sans Unicode,  sans-serif',
            'Monaco, monospace',
            'Palatino Linotype, serif',
            'Palatino, serif',
            'Times New Roman, serif',
            'Times, serif',
            'Verdana, sans-serif',
        ];
        const family = this.getInitialFontValue('fontFamily');
        let initialValue = families[0];
        if (family) {
            // check for known values using lowercase
            const lowerCaseValues = families.map((f) => f.toLowerCase());
            const valueIndex = lowerCaseValues.indexOf(family.toLowerCase());
            if (valueIndex >= 0) {
                initialValue = families[valueIndex];
            }
            else {
                // add user provided value to list
                const capitalisedFontValue = _capitalise(family);
                families.push(capitalisedFontValue);
                initialValue = capitalisedFontValue;
            }
        }
        const options = families.sort().map((value) => ({ value, text: value }));
        return this.params.chartMenuParamsFactory.getDefaultSelectParamsWithoutValueParams('font', options, `${initialValue}`, (newValue) => this.setFont({ fontFamily: newValue }));
    }
    getSizeSelectParams() {
        const sizes = [8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36];
        const size = this.getInitialFontValue('fontSize');
        if (!sizes.includes(size)) {
            sizes.push(size);
        }
        const options = sizes.sort((a, b) => a - b).map((value) => ({ value: `${value}`, text: `${value}` }));
        return this.params.chartMenuParamsFactory.getDefaultSelectParamsWithoutValueParams('size', options, `${size}`, (newValue) => this.setFont({ fontSize: parseInt(newValue, 10) }));
    }
    getWeightStyleSelectParams() {
        const weight = this.getInitialFontValue('fontWeight') ?? 'normal';
        const style = this.getInitialFontValue('fontStyle') ?? 'normal';
        const weightStyles = [
            { name: 'normal', weight: 'normal', style: 'normal' },
            { name: 'bold', weight: 'bold', style: 'normal' },
            { name: 'italic', weight: 'normal', style: 'italic' },
            { name: 'boldItalic', weight: 'bold', style: 'italic' },
        ];
        let selectedOption = weightStyles.find((x) => x.weight === weight && x.style === style);
        if (!selectedOption) {
            selectedOption = { name: 'predefined', weight, style };
            weightStyles.unshift(selectedOption);
        }
        const options = weightStyles.map((ws) => ({
            value: ws.name,
            text: this.chartTranslation.translate(ws.name),
        }));
        return this.params.chartMenuParamsFactory.getDefaultSelectParamsWithoutValueParams('weight', options, selectedOption.name, (newValue) => {
            const selectedWeightStyle = weightStyles.find((x) => x.name === newValue);
            this.setFont({ fontWeight: selectedWeightStyle.weight, fontStyle: selectedWeightStyle.style });
        });
    }
    destroyActiveComps() {
        this.activeComps.forEach((comp) => {
            (0, ag_grid_community_1._removeFromParent)(comp.getGui());
            this.destroyBean(comp);
        });
    }
    destroy() {
        this.destroyActiveComps();
        super.destroy();
    }
    setFont(font) {
        const { keyMapper } = this.params;
        for (const fontKey of Object.keys(font)) {
            const value = font[fontKey];
            if (value) {
                this.chartOptions.setValue(keyMapper(fontKey), value);
            }
        }
    }
    getInitialFontValue(fontKey) {
        const { keyMapper } = this.params;
        return this.chartOptions.getValue(keyMapper(fontKey));
    }
}
exports.FontPanel = FontPanel;


/***/ }),

/***/ 3160:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FormatPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartPanelFeature_1 = __webpack_require__(1299);
const cartesianAxisPanel_1 = __webpack_require__(5002);
const polarAxisPanel_1 = __webpack_require__(956);
const chartPanel_1 = __webpack_require__(3628);
const groupExpansionFeature_1 = __webpack_require__(8693);
const legendPanel_1 = __webpack_require__(3316);
const seriesPanel_1 = __webpack_require__(2496);
const titlesPanel_1 = __webpack_require__(5272);
const DefaultFormatPanelDef = {
    groups: [{ type: 'chart' }, { type: 'titles' }, { type: 'legend' }, { type: 'series' }, { type: 'axis' }],
};
const AXIS_KEYS = ['axis', 'horizontalAxis', 'verticalAxis'];
class FormatPanel extends ag_grid_community_1.Component {
    constructor(chartMenuContext) {
        super(/* html */ `<div class="ag-chart-format-wrapper"></div>`);
        this.chartMenuContext = chartMenuContext;
    }
    postConstruct() {
        this.groupExpansionFeature = this.createManagedBean(new groupExpansionFeature_1.GroupExpansionFeature(this.getGui()));
        this.chartPanelFeature = this.createManagedBean(new chartPanelFeature_1.ChartPanelFeature(this.chartMenuContext.chartController, this.getGui(), 'ag-chart-format-section', (_chartType, seriesType) => this.createPanels(seriesType)));
        this.chartPanelFeature.refreshPanels();
    }
    createPanels(seriesType) {
        let panelExpandedOnInit = false;
        this.getFormatPanelDef().groups?.forEach(({ type: group, isOpen: isExpandedOnInit = false }) => {
            // ensure the group should be displayed for the current series type
            if (!this.isGroupPanelShownInSeries(group, seriesType)) {
                return;
            }
            if (isExpandedOnInit) {
                if (panelExpandedOnInit) {
                    (0, ag_grid_community_1._warn)(145, { group });
                }
                panelExpandedOnInit = true;
            }
            const registerGroupComponent = (groupComponent) => this.groupExpansionFeature.addGroupComponent(groupComponent);
            const opts = {
                ...this.chartMenuContext,
                isExpandedOnInit,
                seriesType,
                registerGroupComponent,
            };
            switch (group) {
                case 'chart':
                    this.chartPanelFeature.addComponent(new chartPanel_1.ChartPanel(opts));
                    break;
                case 'titles':
                    this.chartPanelFeature.addComponent(new titlesPanel_1.TitlesPanel(opts));
                    break;
                case 'legend':
                    this.chartPanelFeature.addComponent(new legendPanel_1.LegendPanel(opts, this.chartMenuContext));
                    break;
                case 'axis':
                    // Polar charts have different axis options from cartesian charts, so choose the appropriate panels
                    if ((0, seriesTypeMapper_1.isPolar)(seriesType)) {
                        this.chartPanelFeature.addComponent(new polarAxisPanel_1.PolarAxisPanel(opts));
                    }
                    else if ((0, seriesTypeMapper_1.isCartesian)(seriesType)) {
                        this.chartPanelFeature.addComponent(new cartesianAxisPanel_1.CartesianAxisPanel('xAxis', opts));
                        this.chartPanelFeature.addComponent(new cartesianAxisPanel_1.CartesianAxisPanel('yAxis', opts));
                    }
                    break;
                case 'horizontalAxis':
                    this.chartPanelFeature.addComponent(new cartesianAxisPanel_1.CartesianAxisPanel('xAxis', opts));
                    break;
                case 'verticalAxis':
                    this.chartPanelFeature.addComponent(new cartesianAxisPanel_1.CartesianAxisPanel('yAxis', opts));
                    break;
                case 'series':
                    this.chartPanelFeature.addComponent(new seriesPanel_1.SeriesPanel(opts));
                    break;
                default:
                    (0, ag_grid_community_1._warn)(147, { group });
            }
        });
    }
    getFormatPanelDef() {
        const userProvidedFormatPanelDef = this.gos.get('chartToolPanelsDef')?.formatPanel;
        return userProvidedFormatPanelDef ? userProvidedFormatPanelDef : DefaultFormatPanelDef;
    }
    isGroupPanelShownInSeries(group, seriesType) {
        const enable = ['chart', 'titles', 'legend', 'series'].includes(group) ||
            ((0, seriesTypeMapper_1.isCartesian)(seriesType) && AXIS_KEYS.includes(group)) ||
            ((0, seriesTypeMapper_1.isPolar)(seriesType) && group === 'axis');
        const disable = ((0, seriesTypeMapper_1.isFunnel)(seriesType) && group === 'legend') || ((0, seriesTypeMapper_1.isFunnel)(seriesType) && AXIS_KEYS.includes(group));
        return enable && !disable;
    }
}
exports.FormatPanel = FormatPanel;


/***/ }),

/***/ 8693:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GroupExpansionFeature = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
// handles single group expansion
class GroupExpansionFeature extends ag_grid_community_1.BeanStub {
    constructor(groupContainer) {
        super();
        this.groupContainer = groupContainer;
        this.id = 0;
        this.groupComponents = new Map();
    }
    addGroupComponent(groupComponent) {
        const id = this.id++;
        this.groupComponents.set(id, groupComponent);
        if (groupComponent.isExpanded()) {
            this.expandedGroupComponent = id;
        }
        groupComponent.onExpandedChange((expanded) => {
            if (expanded) {
                const previouslyExpandedGroupComponent = this.expandedGroupComponent;
                this.expandedGroupComponent = id;
                if (previouslyExpandedGroupComponent != null) {
                    const groupComponentGui = groupComponent.getGui();
                    const groupPositionInViewport = groupComponentGui.offsetTop - this.groupContainer.parentElement.scrollTop;
                    this.groupComponents.get(previouslyExpandedGroupComponent)?.toggleGroupExpand(false, true);
                    // if the group above is collapsed, the expanded component will be in the wrong place, so scroll
                    let newScrollTop = groupComponentGui.offsetTop - groupPositionInViewport;
                    if (newScrollTop < 0) {
                        newScrollTop = 0;
                    }
                    if (newScrollTop !== this.groupContainer.parentElement.scrollTop) {
                        this.groupContainer.parentElement.scrollTop = newScrollTop;
                    }
                }
            }
            else {
                this.expandedGroupComponent = undefined;
            }
        });
    }
    destroy() {
        this.groupComponents.clear();
        super.destroy();
    }
}
exports.GroupExpansionFeature = GroupExpansionFeature;


/***/ }),

/***/ 3316:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LegendPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
const fontPanel_1 = __webpack_require__(7730);
class LegendPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(options, chartMenuContext) {
        super();
        this.options = options;
        this.chartMenuContext = chartMenuContext;
        this.legendGroup = ag_grid_community_1.RefPlaceholder;
        this.enabledGroup = ag_grid_community_1.RefPlaceholder;
        this.isGradient = ['treemap', 'sunburst', 'heatmap'].includes(options.seriesType);
        this.key = this.isGradient ? 'gradientLegend' : 'legend';
        this.chartController = chartMenuContext.chartController;
    }
    postConstruct() {
        const { chartMenuParamsFactory, isExpandedOnInit: expanded, registerGroupComponent } = this.options;
        const positionSelect = this.createManagedBean(new ag_grid_community_1.AgSelect(chartMenuParamsFactory.getDefaultSelectParams(`${this.key}.position`, 'position', ['top', 'right', 'bottom', 'left'].map((position) => ({
            value: position,
            text: this.chartTranslation.translate(position),
        })))));
        this.enabledGroup = this.createManagedBean(new agGroupComponent_1.AgGroupComponent(chartMenuParamsFactory.addEnableParams(`${this.key}.enabled`, {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('legendEnabled'),
            suppressEnabledCheckbox: true,
            useToggle: true,
            items: [
                this.createLabelPanel(chartMenuParamsFactory),
                positionSelect,
                ...this.getItems(chartMenuParamsFactory),
            ],
        })));
        const legendGroupParams = {
            cssIdentifier: 'charts-format-top-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('legend'),
            suppressEnabledCheckbox: true,
            expanded,
            items: [this.enabledGroup],
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="legendGroup">
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector], {
            legendGroup: legendGroupParams,
        });
        registerGroupComponent(this.legendGroup);
        const listener = this.updateLegendEnabledState.bind(this);
        this.addManagedListeners(this.chartController, {
            chartModelUpdate: listener,
            chartApiUpdate: listener,
        });
    }
    updateLegendEnabledState() {
        const { valueCols } = this.chartController.getColStateForMenu();
        this.enabledGroup.setEnabled(valueCols.filter((vc) => vc.selected).length > 1);
    }
    getItems(chartMenuParamsFactory) {
        const createSlider = (expression, labelKey, defaultMaxValue) => this.createManagedBean(new agSlider_1.AgSlider(chartMenuParamsFactory.getDefaultSliderParams(`${this.key}.${expression}`, labelKey, defaultMaxValue)));
        if (this.isGradient) {
            return [
                this.createManagedBean(new ag_grid_community_1.AgCheckbox(chartMenuParamsFactory.addValueParams('gradientLegend.reverseOrder', {
                    label: this.chartTranslation.translate('reverseDirection'),
                    labelWidth: 'flex',
                }))),
                createSlider('gradient.thickness', 'thickness', 40),
                createSlider('gradient.preferredLength', 'preferredLength', 300),
                createSlider('spacing', 'spacing', 200),
            ];
        }
        return [
            createSlider('spacing', 'spacing', 200),
            createSlider('item.marker.size', 'markerSize', 40),
            createSlider('item.marker.strokeWidth', 'markerStroke', 10),
            createSlider('item.marker.padding', 'itemSpacing', 20),
            createSlider('item.paddingX', 'layoutHorizontalSpacing', 50),
            createSlider('item.paddingY', 'layoutVerticalSpacing', 50),
        ];
    }
    createLabelPanel(chartMenuParamsFactory) {
        const rootKey = this.isGradient ? 'gradientLegend.scale.label' : 'legend.item.label';
        const params = {
            enabled: true,
            suppressEnabledCheckbox: true,
            chartMenuParamsFactory,
            keyMapper: (key) => `${rootKey}.${key}`,
            cssIdentifier: 'charts-format-sub-level-no-header',
        };
        return this.createManagedBean(new fontPanel_1.FontPanel(params));
    }
}
exports.LegendPanel = LegendPanel;


/***/ }),

/***/ 6279:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CalloutPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
class CalloutPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const calloutGroupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('callout'),
            enabled: true,
            suppressOpenCloseIcons: true,
            suppressEnabledCheckbox: true,
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="calloutGroup">
                <ag-slider data-ref="calloutLengthSlider"></ag-slider>
                <ag-slider data-ref="calloutStrokeWidthSlider"></ag-slider>
                <ag-slider data-ref="labelOffsetSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agSlider_1.AgSliderSelector], {
            calloutGroup: calloutGroupParams,
            calloutLengthSlider: this.chartMenuUtils.getDefaultSliderParams('calloutLine.length', 'length', 40),
            calloutStrokeWidthSlider: this.chartMenuUtils.getDefaultSliderParams('calloutLine.strokeWidth', 'strokeWidth', 10),
            labelOffsetSlider: this.chartMenuUtils.getDefaultSliderParams('calloutLabel.offset', 'offset', 30),
        });
    }
}
exports.CalloutPanel = CalloutPanel;


/***/ }),

/***/ 2948:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CapsPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
class CapsPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const capsGroupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('cap'),
            enabled: true,
            suppressOpenCloseIcons: true,
            suppressEnabledCheckbox: true,
        };
        const capLengthRatioSliderParams = this.chartMenuUtils.getDefaultSliderParams('cap.lengthRatio', 'capLengthRatio', 1);
        capLengthRatioSliderParams.step = 0.05;
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="capsGroup">
                <ag-slider data-ref="capLengthRatioSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agSlider_1.AgSliderSelector], {
            capsGroup: capsGroupParams,
            capLengthRatioSlider: capLengthRatioSliderParams,
        });
    }
}
exports.CapsPanel = CapsPanel;


/***/ }),

/***/ 1428:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorLinePanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
class ConnectorLinePanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const lineGroupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('connectorLine'),
            enabled: true,
            suppressOpenCloseIcons: true,
            suppressEnabledCheckbox: true,
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="lineGroup">
                <ag-color-picker data-ref="lineColorPicker"></ag-color-picker>
                <ag-slider data-ref="lineStrokeWidthSlider"></ag-slider>
                <ag-slider data-ref="lineOpacitySlider"></ag-slider>
                <ag-slider data-ref="lineDashSlider"></ag-slider>                
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            lineGroup: lineGroupParams,
            lineColorPicker: this.chartMenuUtils.getDefaultColorPickerParams('line.stroke'),
            lineStrokeWidthSlider: this.getSliderParams('strokeWidth', 10, 'line.strokeWidth'),
            lineDashSlider: this.getSliderParams('lineDash', 30, 'line.lineDash', 1, true),
            lineOpacitySlider: this.getSliderParams('strokeOpacity', 1, 'line.strokeOpacity', 0.05),
        });
    }
    getSliderParams(labelKey, maxValue, seriesOptionKey, step = 1, isArray = false) {
        const params = this.chartMenuUtils.getDefaultSliderParams(seriesOptionKey, labelKey, maxValue, isArray);
        params.step = step;
        return params;
    }
}
exports.ConnectorLinePanel = ConnectorLinePanel;


/***/ }),

/***/ 1902:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MarkersPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
const seriesUtils_1 = __webpack_require__(1307);
class MarkersPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const seriesMarkersGroupParams = this.chartMenuUtils.addEnableParams('marker.enabled', {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('markers'),
            suppressEnabledCheckbox: true,
            useToggle: true,
            suppressOpenCloseIcons: true,
        });
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="seriesMarkersGroup">
                <ag-select data-ref="seriesMarkerShapeSelect"></ag-select>
                <ag-slider data-ref="seriesMarkerSizeSlider"></ag-slider>
                <ag-slider data-ref="seriesMarkerStrokeWidthSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgSelectSelector, agSlider_1.AgSliderSelector], {
            seriesMarkersGroup: seriesMarkersGroupParams,
            seriesMarkerShapeSelect: this.chartMenuUtils.getDefaultSelectParams('marker.shape', 'shape', (0, seriesUtils_1.getShapeSelectOptions)(this.chartTranslation)),
            seriesMarkerSizeSlider: this.chartMenuUtils.getDefaultSliderParams('marker.size', 'size', 60),
            seriesMarkerStrokeWidthSlider: this.chartMenuUtils.getDefaultSliderParams('marker.strokeWidth', 'strokeWidth', 10),
        });
    }
}
exports.MarkersPanel = MarkersPanel;


/***/ }),

/***/ 1730:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SeriesItemsPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
const fontPanel_1 = __webpack_require__(7730);
class SeriesItemsPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
        this.seriesItemsGroup = ag_grid_community_1.RefPlaceholder;
        this.activePanels = [];
    }
    postConstruct() {
        const seriesItemsGroupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('seriesItems'),
            enabled: true,
            suppressOpenCloseIcons: true,
            suppressEnabledCheckbox: true,
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="seriesItemsGroup">
                <ag-select data-ref="seriesItemSelect"></ag-select>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, ag_grid_community_1.AgSelectSelector], {
            seriesItemsGroup: seriesItemsGroupParams,
            seriesItemSelect: this.getSeriesItemsParams(),
        });
        this.initSeriesControls();
    }
    getSeriesItemsParams() {
        const options = [
            { value: 'positive', text: this.chartTranslation.translate('seriesItemPositive') },
            { value: 'negative', text: this.chartTranslation.translate('seriesItemNegative') },
        ];
        const seriesItemChangedCallback = (newValue) => {
            this.destroyActivePanels();
            this.initSeriesControls(newValue);
        };
        return this.chartMenuUtils.getDefaultSelectParamsWithoutValueParams('seriesItemType', options, 'positive', seriesItemChangedCallback);
    }
    initSeriesControls(itemType = 'positive') {
        this.initSlider('strokeWidth', 10, `item.${itemType}.strokeWidth`);
        this.initSlider('lineDash', 30, `item.${itemType}.lineDash`, 1, true);
        this.initSlider('strokeOpacity', 1, `item.${itemType}.strokeOpacity`, 0.05, false);
        this.initSlider('fillOpacity', 1, `item.${itemType}.fillOpacity`, 0.05, false);
        this.initItemLabels(itemType);
    }
    initSlider(labelKey, maxValue, seriesOptionKey, step = 1, isArray = false) {
        const params = this.chartMenuUtils.getDefaultSliderParams(seriesOptionKey, labelKey, maxValue, isArray);
        params.step = step;
        const itemSlider = this.seriesItemsGroup.createManagedBean(new agSlider_1.AgSlider(params));
        this.seriesItemsGroup.addItem(itemSlider);
        this.activePanels.push(itemSlider);
    }
    initItemLabels(itemType) {
        const sectorParams = this.chartMenuUtils.getDefaultFontPanelParams(`item.${itemType}.label`, 'seriesItemLabels');
        const labelPanelComp = this.createBean(new fontPanel_1.FontPanel(sectorParams));
        this.seriesItemsGroup.addItem(labelPanelComp);
        this.activePanels.push(labelPanelComp);
    }
    destroyActivePanels() {
        this.activePanels.forEach((panel) => {
            (0, ag_grid_community_1._removeFromParent)(panel.getGui());
            this.destroyBean(panel);
        });
    }
    destroy() {
        this.destroyActivePanels();
        super.destroy();
    }
}
exports.SeriesItemsPanel = SeriesItemsPanel;


/***/ }),

/***/ 2496:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SeriesPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartMenuParamsFactory_1 = __webpack_require__(3786);
const fontPanel_1 = __webpack_require__(7730);
const toggleablePanel_1 = __webpack_require__(5277);
const calloutPanel_1 = __webpack_require__(6279);
const capsPanel_1 = __webpack_require__(2948);
const connectorLinePanel_1 = __webpack_require__(1428);
const markersPanel_1 = __webpack_require__(1902);
const seriesItemsPanel_1 = __webpack_require__(1730);
const seriesUtils_1 = __webpack_require__(1307);
const shadowPanel_1 = __webpack_require__(1919);
const tileSpacingPanel_1 = __webpack_require__(4880);
const whiskersPanel_1 = __webpack_require__(991);
const tooltips = 'tooltips';
const strokeWidth = 'strokeWidth';
const lineWidth = 'lineWidth';
const lineDash = 'lineDash';
const lineOpacity = 'lineOpacity';
const fillOpacity = 'fillOpacity';
const labels = 'labels';
const shadow = 'shadow';
const stageLabels = 'stageLabels';
const markers = 'markers';
class SeriesPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(options) {
        super();
        this.options = options;
        this.seriesGroup = ag_grid_community_1.RefPlaceholder;
        this.activePanels = [];
        this.widgetFuncs = {
            lineWidth: () => this.initStrokeWidth(lineWidth),
            [strokeWidth]: () => this.initStrokeWidth('strokeWidth'),
            lineColor: () => this.initLineColor(),
            [lineDash]: () => this.initLineDash(),
            [lineOpacity]: () => this.initOpacity('strokeOpacity'),
            [fillOpacity]: () => this.initOpacity('fillOpacity'),
            markers: () => new markersPanel_1.MarkersPanel(this.chartMenuUtils),
            [labels]: () => this.initLabels(),
            sectorLabels: () => this.initSectorLabels(),
            [shadow]: () => new shadowPanel_1.ShadowPanel(this.chartMenuUtils),
            [tooltips]: () => this.initTooltips(),
            bins: () => this.initBins(),
            whiskers: () => new whiskersPanel_1.WhiskersPanel(this.chartMenuUtils),
            caps: () => new capsPanel_1.CapsPanel(this.chartMenuUtils),
            connectorLine: () => new connectorLinePanel_1.ConnectorLinePanel(this.chartMenuUtils),
            seriesItems: () => new seriesItemsPanel_1.SeriesItemsPanel(this.chartMenuUtils),
            tileSpacing: () => new tileSpacingPanel_1.TileSpacingPanel(this.chartMenuUtils),
            shape: () => this.initShape(),
            size: () => this.initSize('size', 'size'),
            minSize: () => this.initSize('size', 'minSize'),
            maxSize: () => this.initSize('maxSize', 'maxSize'),
            dropoff: () => this.initDropOff(),
            stageLabels: () => this.initStageLabels(),
        };
        this.seriesWidgetMappings = {
            bar: [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels, shadow],
            pie: [tooltips, strokeWidth, lineOpacity, fillOpacity, labels, 'sectorLabels', shadow],
            donut: [tooltips, strokeWidth, lineOpacity, fillOpacity, labels, 'sectorLabels', shadow],
            line: [tooltips, lineWidth, lineDash, lineOpacity, markers, labels],
            scatter: [tooltips, 'shape', 'size', strokeWidth, labels],
            bubble: [tooltips, 'shape', 'minSize', 'maxSize', strokeWidth, labels],
            area: [tooltips, lineWidth, lineDash, lineOpacity, fillOpacity, markers, labels, shadow],
            histogram: [tooltips, 'bins', strokeWidth, lineDash, lineOpacity, fillOpacity, labels, shadow],
            'radial-column': [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels],
            'radial-bar': [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels],
            'radar-line': [tooltips, strokeWidth, lineDash, lineOpacity, markers, labels],
            'radar-area': [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, markers, labels],
            nightingale: [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels],
            'box-plot': [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, 'whiskers', 'caps'],
            'range-bar': [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels],
            'range-area': [tooltips, lineWidth, lineDash, lineOpacity, fillOpacity, markers, labels, shadow],
            treemap: [tooltips, 'tileSpacing'],
            sunburst: [tooltips],
            heatmap: [tooltips, labels, 'lineColor', lineWidth, lineOpacity],
            waterfall: [tooltips, 'connectorLine', 'seriesItems'],
            funnel: [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels, 'dropoff', stageLabels, shadow],
            'cone-funnel': [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels, stageLabels],
            pyramid: [tooltips, strokeWidth, lineDash, lineOpacity, fillOpacity, labels, stageLabels, shadow],
        };
        this.seriesType = options.seriesType;
    }
    postConstruct() {
        const { isExpandedOnInit: expanded, chartOptionsService, chartController, registerGroupComponent, } = this.options;
        const seriesGroupParams = {
            cssIdentifier: 'charts-format-top-level',
            direction: 'vertical',
            title: this.translate('series'),
            expanded,
            suppressEnabledCheckbox: true,
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="seriesGroup">
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector], { seriesGroup: seriesGroupParams });
        registerGroupComponent(this.seriesGroup);
        this.chartMenuUtils = this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(chartOptionsService.getSeriesOptionsProxy(() => this.seriesType)));
        this.addManagedListeners(chartController, { chartSeriesChartTypeChanged: this.refreshWidgets.bind(this) });
        this.refreshWidgets();
    }
    refreshWidgets() {
        const { chartController } = this.options;
        this.destroyActivePanels();
        const chart = chartController.getChartProxy().getChart();
        chart
            .waitForUpdate()
            .then(() => {
            const componentWasRemoved = !this.isAlive();
            if (componentWasRemoved) {
                // It's possible that the component was unmounted during the async delay in updating the chart.
                // If this is the case we want to bail out to avoid operating on stale UI components.
                return;
            }
            if (chartController.isComboChart()) {
                this.updateSeriesType();
                this.initSeriesSelect();
            }
            (this.seriesWidgetMappings[this.seriesType] ?? []).forEach((w) => {
                const widgetFuncResult = this.widgetFuncs[w]();
                let widget;
                if (Array.isArray(widgetFuncResult)) {
                    const comp = this.createBean(widgetFuncResult[0]);
                    widget = comp;
                    widgetFuncResult[1](comp);
                }
                else {
                    widget = this.createBean(widgetFuncResult);
                }
                this.seriesGroup.addItem(widget);
                this.activePanels.push(widget);
            });
        })
            .catch((e) => (0, ag_grid_community_1._error)(105, { e }));
    }
    initSeriesSelect() {
        const seriesSelect = this.createBean(new ag_grid_community_1.AgSelect(this.chartMenuUtils.getDefaultSelectParamsWithoutValueParams('seriesType', this.getSeriesSelectOptions(), `${this.seriesType}`, (newValue) => {
            this.seriesType = newValue;
            this.refreshWidgets();
        })));
        this.seriesGroup.addItem(seriesSelect);
        this.activePanels.push(seriesSelect);
    }
    initTooltips() {
        return new ag_grid_community_1.AgToggleButton(this.chartMenuUtils.addValueParams('tooltip.enabled', {
            label: this.translate('tooltips'),
            labelAlignment: 'left',
            labelWidth: 'flex',
            inputWidth: 'flex',
        }));
    }
    initLineColor() {
        return new agColorPicker_1.AgColorPicker(this.chartMenuUtils.getDefaultColorPickerParams('stroke', 'strokeColor'));
    }
    initStrokeWidth(labelKey, expression) {
        return new agSlider_1.AgSlider(this.chartMenuUtils.getDefaultSliderParams(expression ? `${expression}.${labelKey}` : 'strokeWidth', labelKey, 10));
    }
    initLineDash(expression) {
        return new agSlider_1.AgSlider(this.chartMenuUtils.getDefaultSliderParams(expression ? `${expression}.lineDash` : 'lineDash', 'lineDash', 30, true));
    }
    initOpacity(type, expression) {
        const params = this.chartMenuUtils.getDefaultSliderParams(expression ? `${expression}.${type}` : type, type, 1);
        params.step = 0.05;
        return new agSlider_1.AgSlider(params);
    }
    initDropOff() {
        const dropOffGroup = new toggleablePanel_1.ToggleablePanel({
            tag: 'dropOff',
            cssIdentifier: 'charts-format-sub-level',
            title: this.translate('dropOff'),
            suppressEnabledCheckbox: false,
            chartMenuParamsFactory: this.chartMenuUtils,
        });
        const addItems = (groupComponent) => {
            [
                this.initStrokeWidth('strokeWidth', 'dropOff'),
                this.initLineDash('dropOff'),
                this.initOpacity('strokeOpacity', 'dropOff'),
                this.initOpacity('fillOpacity', 'dropOff'),
            ].forEach((comp) => {
                const managed = groupComponent.createManagedBean(comp);
                groupComponent.addItem(managed);
                this.activePanels.push(managed);
            });
        };
        return [dropOffGroup, addItems];
    }
    initLabels() {
        const isPieChart = (0, seriesTypeMapper_1.isPieChartSeries)(this.seriesType);
        const seriesOptionLabelProperty = isPieChart ? 'calloutLabel' : 'label';
        const labelKey = isPieChart ? 'calloutLabels' : 'labels';
        const labelParams = this.chartMenuUtils.getDefaultFontPanelParams(seriesOptionLabelProperty, labelKey);
        const fontPanel = new fontPanel_1.FontPanel(labelParams);
        const addItems = (labelPanelComp) => {
            if (isPieChart) {
                const calloutPanelComp = labelPanelComp.createManagedBean(new calloutPanel_1.CalloutPanel(this.chartMenuUtils));
                labelPanelComp.addItem(calloutPanelComp);
                this.activePanels.push(calloutPanelComp);
            }
            if (this.seriesType === 'range-bar') {
                // Add label placement dropdown
                const options = [
                    { value: 'inside', text: this.translate('inside') },
                    { value: 'outside', text: this.translate('outside') },
                ];
                const placementSelect = labelPanelComp.createManagedBean(new ag_grid_community_1.AgSelect(this.chartMenuUtils.getDefaultSelectParams('label.placement', 'labelPlacement', options)));
                labelPanelComp.addItem(placementSelect);
                this.activePanels.push(placementSelect);
                // Add padding slider
                const paddingSlider = labelPanelComp.createManagedBean(new agSlider_1.AgSlider(this.chartMenuUtils.getDefaultSliderParams('label.padding', 'padding', 200)));
                labelPanelComp.addItem(paddingSlider);
                this.activePanels.push(paddingSlider);
            }
        };
        return [fontPanel, addItems];
    }
    initSectorLabels() {
        const sectorParams = this.chartMenuUtils.getDefaultFontPanelParams('sectorLabel', 'sectorLabels');
        const fontPanel = new fontPanel_1.FontPanel(sectorParams);
        const addItems = (sectorPanelComp) => {
            const positionRatioParams = this.chartMenuUtils.getDefaultSliderParams('sectorLabel.positionRatio', 'positionRatio', 1);
            positionRatioParams.step = 0.05;
            const positionRatioComp = sectorPanelComp.createManagedBean(new agSlider_1.AgSlider(positionRatioParams));
            sectorPanelComp.addItem(positionRatioComp);
        };
        return [fontPanel, addItems];
    }
    initStageLabels() {
        return new fontPanel_1.FontPanel(this.chartMenuUtils.getDefaultFontPanelParams('stageLabel', stageLabels));
    }
    initBins() {
        const params = this.chartMenuUtils.getDefaultSliderParams('binCount', 'histogramBinCount', 20);
        const chartOptions = this.chartMenuUtils.getChartOptions();
        // this needs fixing
        const value = (chartOptions.getValue('bins') ?? chartOptions.getValue('calculatedBins', true)).length;
        params.value = `${value}`;
        params.maxValue = Math.max(value, 20);
        return new agSlider_1.AgSlider(params);
    }
    initShape() {
        return new ag_grid_community_1.AgSelect(this.chartMenuUtils.getDefaultSelectParams('shape', 'shape', (0, seriesUtils_1.getShapeSelectOptions)(this.chartTranslation)));
    }
    initSize(expression, labelKey) {
        return new agSlider_1.AgSlider(this.chartMenuUtils.getDefaultSliderParams(expression, labelKey, 60));
    }
    getSeriesSelectOptions() {
        const activeSeriesTypes = this.getActiveSeriesTypes();
        return ['area', 'bar', 'line']
            .filter((seriesType) => activeSeriesTypes.includes(seriesType))
            .map((value) => ({ value, text: this.translate(value) }));
    }
    updateSeriesType() {
        const activeSeriesTypes = this.getActiveSeriesTypes();
        const invalidSeriesType = !activeSeriesTypes.includes(this.seriesType);
        if (invalidSeriesType && activeSeriesTypes.length > 0) {
            this.seriesType = activeSeriesTypes[0]; // default to first active series type
        }
    }
    getActiveSeriesTypes() {
        return this.options.chartController.getActiveSeriesChartTypes().map((s) => (0, seriesTypeMapper_1.getSeriesType)(s.chartType));
    }
    translate(key) {
        return this.chartTranslation.translate(key);
    }
    destroyActivePanels() {
        this.activePanels.forEach((panel) => {
            (0, ag_grid_community_1._removeFromParent)(panel.getGui());
            this.destroyBean(panel);
        });
    }
    destroy() {
        this.destroyActivePanels();
        super.destroy();
    }
}
exports.SeriesPanel = SeriesPanel;


/***/ }),

/***/ 1307:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getShapeSelectOptions = void 0;
function getShapeSelectOptions(chartTranslation) {
    return ['square', 'circle', 'cross', 'diamond', 'plus', 'triangle', 'heart'].map((value) => ({
        value,
        text: chartTranslation.translate(value),
    }));
}
exports.getShapeSelectOptions = getShapeSelectOptions;


/***/ }),

/***/ 1919:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShadowPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
class ShadowPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils, propertyKey = 'shadow') {
        super();
        this.chartMenuUtils = chartMenuUtils;
        this.propertyKey = propertyKey;
    }
    postConstruct() {
        // Determine the path within the series options object to get/set the individual shadow options
        const propertyNamespace = this.propertyKey;
        const shadowGroupParams = this.chartMenuUtils.addEnableParams(`${propertyNamespace}.enabled`, {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title: this.chartTranslation.translate('shadow'),
            suppressEnabledCheckbox: true,
            useToggle: true,
        });
        const shadowColorPickerParams = this.chartMenuUtils.getDefaultColorPickerParams(`${propertyNamespace}.color`);
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="shadowGroup">
                <ag-color-picker data-ref="shadowColorPicker"></ag-color-picker>
                <ag-slider data-ref="shadowBlurSlider"></ag-slider>
                <ag-slider data-ref="shadowXOffsetSlider"></ag-slider>
                <ag-slider data-ref="shadowYOffsetSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            shadowGroup: shadowGroupParams,
            shadowColorPicker: shadowColorPickerParams,
            shadowBlurSlider: this.getSliderParams('blur', 0, 20),
            shadowXOffsetSlider: this.getSliderParams('xOffset', -10, 10),
            shadowYOffsetSlider: this.getSliderParams('yOffset', -10, 10),
        });
    }
    getSliderParams(property, minValue, defaultMaxValue) {
        const expression = `${this.propertyKey}.${property}`;
        const params = this.chartMenuUtils.getDefaultSliderParams(expression, property, defaultMaxValue);
        params.minValue = minValue;
        return params;
    }
}
exports.ShadowPanel = ShadowPanel;


/***/ }),

/***/ 4880:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TileSpacingPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agSlider_1 = __webpack_require__(5000);
class TileSpacingPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const groupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            enabled: true,
            suppressOpenCloseIcons: true,
            suppressEnabledCheckbox: true,
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="groupSpacing">
                <ag-slider data-ref="groupPaddingSlider"></ag-slider>
                <ag-slider data-ref="groupSpacingSlider"></ag-slider>
            </ag-group-component>
            <ag-group-component data-ref="tileSpacing">
                <ag-slider data-ref="tilePaddingSlider"></ag-slider>
                <ag-slider data-ref="tileSpacingSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agSlider_1.AgSliderSelector], {
            groupSpacing: { ...groupParams, title: this.chartTranslation.translate('group') },
            tileSpacing: { ...groupParams, title: this.chartTranslation.translate('tile') },
            groupPaddingSlider: this.getSliderParams('padding', 'group.padding'),
            groupSpacingSlider: this.getSliderParams('spacing', 'group.gap'),
            tilePaddingSlider: this.getSliderParams('padding', 'tile.padding'),
            tileSpacingSlider: this.getSliderParams('spacing', 'tile.gap'),
        });
    }
    getSliderParams(labelKey, key) {
        return this.chartMenuUtils.getDefaultSliderParams(key, labelKey, 10);
    }
}
exports.TileSpacingPanel = TileSpacingPanel;


/***/ }),

/***/ 991:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WhiskersPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const agColorPicker_1 = __webpack_require__(1296);
const agSlider_1 = __webpack_require__(5000);
class WhiskersPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils) {
        super();
        this.chartMenuUtils = chartMenuUtils;
    }
    postConstruct() {
        const whiskersGroupParams = {
            cssIdentifier: 'charts-format-sub-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('whisker'),
            enabled: true,
            suppressOpenCloseIcons: true,
            suppressEnabledCheckbox: true,
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="whiskersGroup">
                <ag-color-picker data-ref="whiskerColorPicker"></ag-color-picker>
                <ag-slider data-ref="whiskerThicknessSlider"></ag-slider>
                <ag-slider data-ref="whiskerOpacitySlider"></ag-slider>
                <ag-slider data-ref="whiskerLineDashSlider"></ag-slider>
                <ag-slider data-ref="whiskerLineDashOffsetSlider"></ag-slider>
            </ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector, agColorPicker_1.AgColorPickerSelector, agSlider_1.AgSliderSelector], {
            whiskersGroup: whiskersGroupParams,
            whiskerColorPicker: this.chartMenuUtils.getDefaultColorPickerParams('whisker.stroke'),
            whiskerThicknessSlider: this.chartMenuUtils.getDefaultSliderParams('whisker.strokeWidth', 'strokeWidth', 10),
            whiskerOpacitySlider: this.chartMenuUtils.getDefaultSliderParams('whisker.strokeOpacity', 'strokeOpacity', 1),
            whiskerLineDashSlider: this.chartMenuUtils.getDefaultSliderParams('whisker.lineDash', 'lineDash', 30, true),
            whiskerLineDashOffsetSlider: this.chartMenuUtils.getDefaultSliderParams('whisker.lineDashOffset', 'lineDashOffset', 30),
        });
    }
}
exports.WhiskersPanel = WhiskersPanel;


/***/ }),

/***/ 3179:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartTitlePanel = void 0;
const titlePanel_1 = __webpack_require__(9375);
class ChartTitlePanel extends titlePanel_1.TitlePanel {
    wireBeans(beans) {
        super.wireBeans(beans);
        this.chartMenuSvc = beans.chartMenuSvc;
    }
    postConstruct() {
        this.titlePlaceholder = this.chartTranslation.translate('titlePlaceholder');
        super.postConstruct();
        // edits to the title can disable it, so keep the checkbox in sync:
        this.addManagedEventListeners({
            chartTitleEdit: () => {
                this.fontPanel.setEnabled(this.hasTitle());
            },
        });
    }
    getTextInputParams() {
        const params = super.getTextInputParams();
        if (this.shouldOverrideTextWithPlaceholder(params.value)) {
            params.value = this.titlePlaceholder;
        }
        return params;
    }
    getSpacingSliderParams() {
        const params = super.getSpacingSliderParams();
        // Default title spacing is 10, but this isn't reflected in the options - this should really be fixed there.
        params.value = '10';
        return params;
    }
    onEnableChange(enabled) {
        if (this.chartMenuSvc.doesChartToolbarExist()) {
            // extra padding is only included when the toolbar is present
            const topPadding = this.chartOptions.getValue('padding.top');
            this.chartOptions.setValue('padding.top', enabled ? topPadding - 20 : topPadding + 20);
        }
        this.chartOptions.setValue(`${this.key}.enabled`, enabled);
        const currentTitleText = this.chartOptions.getValue(`${this.key}.text`);
        if (enabled && this.shouldOverrideTextWithPlaceholder(currentTitleText)) {
            this.chartOptions.setValue(`${this.key}.text`, this.titlePlaceholder);
        }
    }
    shouldOverrideTextWithPlaceholder(currentTitleText) {
        return currentTitleText === 'Title' || currentTitleText?.trim().length === 0;
    }
}
exports.ChartTitlePanel = ChartTitlePanel;


/***/ }),

/***/ 9375:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TitlePanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agSlider_1 = __webpack_require__(5000);
const fontPanel_1 = __webpack_require__(7730);
class TitlePanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartMenuUtils, name, key) {
        super(/* html */ `<div></div>`);
        this.chartMenuUtils = chartMenuUtils;
        this.name = name;
        this.key = key;
        this.chartOptions = chartMenuUtils.getChartOptions();
    }
    postConstruct() {
        this.initFontPanel();
    }
    hasTitle() {
        const title = this.chartOptions.getValue(this.key);
        return title && title.enabled && title.text && title.text.length > 0;
    }
    initFontPanel() {
        const hasTitle = this.hasTitle();
        const fontPanelParams = {
            name: this.chartTranslation.translate(this.name),
            enabled: hasTitle,
            suppressEnabledCheckbox: false,
            chartMenuParamsFactory: this.chartMenuUtils,
            keyMapper: (key) => `${this.key}.${key}`,
            onEnableChange: (enabled) => this.onEnableChange(enabled),
        };
        this.fontPanel = this.createManagedBean(new fontPanel_1.FontPanel(fontPanelParams));
        this.fontPanel.addItem(this.createBean(new ag_grid_community_1.AgInputTextField(this.getTextInputParams())), true);
        this.fontPanel.addItem(this.createBean(new agSlider_1.AgSlider(this.getSpacingSliderParams())));
        this.getGui().appendChild(this.fontPanel.getGui());
    }
    getTextInputParams() {
        return this.chartMenuUtils.addValueParams(`${this.key}.text`, {
            label: this.chartTranslation.translate('title'),
            labelAlignment: 'top',
        });
    }
    getSpacingSliderParams() {
        return this.chartMenuUtils.getDefaultSliderParams(`${this.key}.spacing`, 'spacing', 100);
    }
    onEnableChange(enabled) {
        this.chartOptions.setValue(`${this.key}.enabled`, enabled);
    }
}
exports.TitlePanel = TitlePanel;


/***/ }),

/***/ 5272:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TitlesPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartMenuParamsFactory_1 = __webpack_require__(3786);
const chartTitlePanel_1 = __webpack_require__(3179);
const titlePanel_1 = __webpack_require__(9375);
class TitlesPanel extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(options) {
        super();
        this.options = options;
        this.titleGroup = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        const { chartMenuParamsFactory, chartAxisMenuParamsFactory, chartOptionsService, seriesType, isExpandedOnInit: expanded = false, registerGroupComponent, } = this.options;
        const axisTitlePanels = [];
        if ((0, seriesTypeMapper_1.isCartesian)(seriesType) && seriesType !== 'pyramid') {
            const createAxisParamsFactory = (axisType) => this.createManagedBean(new chartMenuParamsFactory_1.ChartMenuParamsFactory(chartOptionsService.getCartesianAxisThemeOverridesProxy(axisType)));
            axisTitlePanels.push(this.createManagedBean(new titlePanel_1.TitlePanel(createAxisParamsFactory('xAxis'), 'horizontalAxisTitle', 'title')));
            axisTitlePanels.push(this.createManagedBean(new titlePanel_1.TitlePanel(createAxisParamsFactory('yAxis'), 'verticalAxisTitle', 'title')));
        }
        else if ((0, seriesTypeMapper_1.isPolar)(seriesType)) {
            axisTitlePanels.push(this.createManagedBean(new titlePanel_1.TitlePanel(chartAxisMenuParamsFactory, 'polarAxisTitle', 'title')));
        }
        const titleGroupParams = {
            cssIdentifier: 'charts-format-top-level',
            direction: 'vertical',
            title: this.chartTranslation.translate('chartTitles'),
            expanded,
            suppressEnabledCheckbox: true,
            items: [
                this.createManagedBean(new chartTitlePanel_1.ChartTitlePanel(chartMenuParamsFactory, 'chartTitle', 'title')),
                this.createManagedBean(new titlePanel_1.TitlePanel(chartMenuParamsFactory, 'chartSubtitle', 'subtitle')),
                ...axisTitlePanels,
            ],
        };
        this.setTemplate(
        /* html */ `<div>
            <ag-group-component data-ref="titleGroup"></ag-group-component>
        </div>`, [agGroupComponent_1.AgGroupComponentSelector], { titleGroup: titleGroupParams });
        registerGroupComponent(this.titleGroup);
    }
}
exports.TitlesPanel = TitlesPanel;


/***/ }),

/***/ 5277:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleablePanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
class ToggleablePanel extends ag_grid_community_1.Component {
    constructor(params) {
        super();
        this.params = params;
        this.toggleableGroup = ag_grid_community_1.RefPlaceholder;
        this.activeComps = [];
        this.chartOptions = params.chartMenuParamsFactory.getChartOptions();
    }
    postConstruct() {
        const { tag, cssIdentifier = 'charts-format-sub-level', title, suppressEnabledCheckbox } = this.params;
        const groupParams = this.params.chartMenuParamsFactory.addEnableParams(`${tag}.enabled`, {
            cssIdentifier,
            direction: 'vertical',
            suppressOpenCloseIcons: true,
            title,
            suppressEnabledCheckbox: true,
            useToggle: !suppressEnabledCheckbox,
        });
        this.setTemplate(
        /* html */ `<div class="ag-toggleable-group-panel">
                <ag-group-component data-ref="toggleableGroup">
                </ag-group-component>
            </div>`, [agGroupComponent_1.AgGroupComponentSelector], {
            toggleableGroup: groupParams,
        });
        this.addOrRemoveCssClass(`ag-toggleable-group-panel-no-header`, !title);
    }
    addItem(comp, prepend) {
        if (prepend) {
            this.toggleableGroup.prependItem(comp);
        }
        else {
            this.toggleableGroup.addItem(comp);
        }
        this.activeComps.push(comp);
    }
    setEnabled(enabled) {
        this.toggleableGroup.setEnabled(enabled);
    }
    destroyActiveComps() {
        this.activeComps.forEach((comp) => {
            (0, ag_grid_community_1._removeFromParent)(comp.getGui());
            this.destroyBean(comp);
        });
    }
    destroy() {
        this.destroyActiveComps();
        super.destroy();
    }
}
exports.ToggleablePanel = ToggleablePanel;


/***/ }),

/***/ 6604:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartSettingsPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const chartTheme_1 = __webpack_require__(8987);
const miniChartsContainer_1 = __webpack_require__(6692);
class ChartSettingsPanel extends ag_grid_community_1.Component {
    constructor(chartController) {
        super(/* html */ `<div class="ag-chart-settings-wrapper">
            <div data-ref="eMiniChartsContainer" class="ag-chart-settings-mini-charts-container ag-scrollable-container"></div>
            <div data-ref="eNavBar" class="ag-chart-settings-nav-bar">
                <div data-ref="ePrevBtn" class="ag-chart-settings-prev">
                    <button type="button" class="ag-button ag-chart-settings-prev-button"></button>
                </div>
                <div data-ref="eCardSelector" class="ag-chart-settings-card-selector"></div>
                <div data-ref="eNextBtn" class="ag-chart-settings-next">
                    <button type="button" class="ag-button ag-chart-settings-next-button"></button>
                </div>
            </div>
        </div>`);
        this.chartController = chartController;
        this.eMiniChartsContainer = ag_grid_community_1.RefPlaceholder;
        this.eNavBar = ag_grid_community_1.RefPlaceholder;
        this.eCardSelector = ag_grid_community_1.RefPlaceholder;
        this.ePrevBtn = ag_grid_community_1.RefPlaceholder;
        this.eNextBtn = ag_grid_community_1.RefPlaceholder;
        this.miniChartsContainers = [];
        this.cardItems = [];
        this.activePaletteIndex = 0;
        this.palettes = [];
        this.themes = [];
    }
    postConstruct() {
        this.resetPalettes();
        this.ePrevBtn.insertAdjacentElement('afterbegin', (0, ag_grid_community_1._createIconNoSpan)('chartsThemePrevious', this.beans));
        this.eNextBtn.insertAdjacentElement('afterbegin', (0, ag_grid_community_1._createIconNoSpan)('chartsThemeNext', this.beans));
        this.addManagedElementListeners(this.ePrevBtn, { click: () => this.setActivePalette(this.getPrev(), 'left') });
        this.addManagedElementListeners(this.eNextBtn, { click: () => this.setActivePalette(this.getNext(), 'right') });
        // change the selected chart when a combo chart is modified via the data panel, i.e. the custom combo should be selected
        const reset = () => this.resetPalettes(true);
        this.addManagedListeners(this.chartController, {
            chartTypeChanged: reset,
            chartApiUpdate: reset,
        });
        this.scrollSelectedIntoView();
    }
    scrollSelectedIntoView() {
        // the panel is not immediately visible due to the slide animation, so we add a
        // setTimeout to wait until the panel animation is over and is able to scroll
        setTimeout(() => {
            const isMiniChartsContainerVisible = (miniChartsContainers) => {
                return !miniChartsContainers.getGui().classList.contains('ag-hidden');
            };
            const currentMiniChartContainer = this.miniChartsContainers.find(isMiniChartsContainerVisible);
            const currentChart = currentMiniChartContainer.getGui().querySelector('.ag-selected');
            if (currentChart) {
                const parent = currentChart.offsetParent;
                if (parent) {
                    this.eMiniChartsContainer.scrollTo(0, parent.offsetTop);
                }
            }
        }, 250);
    }
    resetPalettes(forceReset) {
        const palettes = this.chartController.getPalettes();
        const themeTemplateParameters = this.chartController.getThemeTemplateParameters();
        const chartGroups = this.gos.get('chartToolPanelsDef')?.settingsPanel?.chartGroupsDef;
        if (((0, ag_grid_community_1._areEqual)(palettes, this.palettes) && !forceReset) || this.isAnimating) {
            return;
        }
        this.palettes = palettes;
        this.themes = this.chartController.getThemeNames();
        this.activePaletteIndex = this.themes.findIndex((name) => name === this.chartController.getChartThemeName());
        this.cardItems = [];
        (0, ag_grid_community_1._clearElement)(this.eCardSelector);
        this.destroyMiniCharts();
        const { themes } = this;
        this.palettes.forEach((palette, index) => {
            const isActivePalette = this.activePaletteIndex === index;
            const { fills = [], strokes = [] } = palette;
            const themeName = themes[index];
            const isCustomTheme = !(0, chartTheme_1.isStockTheme)(themeName, this.beans.agChartsExports._Theme);
            const miniChartsContainer = this.createBean(new miniChartsContainer_1.MiniChartsContainer(this.chartController, fills, strokes, themeTemplateParameters[index], isCustomTheme, chartGroups));
            this.miniChartsContainers.push(miniChartsContainer);
            this.eMiniChartsContainer.appendChild(miniChartsContainer.getGui());
            this.addCardLink(index);
            if (isActivePalette) {
                miniChartsContainer.updateSelectedMiniChart();
            }
            else {
                miniChartsContainer.setDisplayed(false);
            }
        });
        (0, ag_grid_community_1._setDisplayed)(this.eNavBar, this.palettes.length > 1);
        (0, ag_grid_community_1._radioCssClass)(this.cardItems[this.activePaletteIndex], 'ag-selected', 'ag-not-selected');
    }
    addCardLink(index) {
        const link = document.createElement('div');
        link.classList.add('ag-chart-settings-card-item');
        this.addManagedElementListeners(link, {
            click: () => {
                this.setActivePalette(index, index < this.activePaletteIndex ? 'left' : 'right');
            },
        });
        this.eCardSelector.appendChild(link);
        this.cardItems.push(link);
    }
    getPrev() {
        let prev = this.activePaletteIndex - 1;
        if (prev < 0) {
            prev = this.palettes.length - 1;
        }
        return prev;
    }
    getNext() {
        let next = this.activePaletteIndex + 1;
        if (next >= this.palettes.length) {
            next = 0;
        }
        return next;
    }
    setActivePalette(index, animationDirection) {
        if (this.isAnimating || this.activePaletteIndex === index) {
            return;
        }
        (0, ag_grid_community_1._radioCssClass)(this.cardItems[index], 'ag-selected', 'ag-not-selected');
        const currentPalette = this.miniChartsContainers[this.activePaletteIndex];
        const currentGui = currentPalette.getGui();
        const futurePalette = this.miniChartsContainers[index];
        const nextGui = futurePalette.getGui();
        currentPalette.updateSelectedMiniChart();
        futurePalette.updateSelectedMiniChart();
        const multiplier = animationDirection === 'left' ? -1 : 1;
        const final = (nextGui.style.left = `${(0, ag_grid_community_1._getAbsoluteWidth)(this.getGui()) * multiplier}px`);
        this.activePaletteIndex = index;
        this.isAnimating = true;
        const animatingClass = 'ag-animating';
        futurePalette.setDisplayed(true);
        currentPalette.addCssClass(animatingClass);
        futurePalette.addCssClass(animatingClass);
        this.chartController.setChartThemeName(this.themes[index]);
        window.setTimeout(() => {
            currentGui.style.left = `${-parseFloat(final)}px`;
            nextGui.style.left = '0px';
        }, 0);
        window.setTimeout(() => {
            this.isAnimating = false;
            currentPalette.removeCssClass(animatingClass);
            futurePalette.removeCssClass(animatingClass);
            currentPalette.setDisplayed(false);
        }, 300);
    }
    destroyMiniCharts() {
        (0, ag_grid_community_1._clearElement)(this.eMiniChartsContainer);
        this.miniChartsContainers = this.destroyBeans(this.miniChartsContainers);
    }
    destroy() {
        this.destroyMiniCharts();
        super.destroy();
    }
}
exports.ChartSettingsPanel = ChartSettingsPanel;


/***/ }),

/***/ 3564:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniArea = exports.MiniAreaClass = exports.miniAreaData = void 0;
const miniLine_1 = __webpack_require__(7526);
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
exports.miniAreaData = miniLine_1.miniLineData;
class MiniAreaClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data = exports.miniAreaData, tooltipName = 'groupedAreaTooltip', stacked = false) {
        super(container, agChartsExports, tooltipName);
        this.areas = (0, miniChartHelpers_1.createAreaPaths)(agChartsExports._Scene, this.root, data, this.size, this.padding, stacked);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.areas.forEach((area, i) => {
            area.fill = fills[i];
            area.stroke = strokes[i];
            area.strokeWidth = 1;
            area.strokeOpacity = 0.75;
            area.fillOpacity = 0.7;
        });
    }
}
exports.MiniAreaClass = MiniAreaClass;
exports.MiniArea = {
    chartType: 'area',
    miniChart: MiniAreaClass,
};


/***/ }),

/***/ 6249:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniNormalizedArea = exports.MiniNormalizedAreaClass = exports.miniNormalizedAreaData = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniStackedArea_1 = __webpack_require__(5133);
exports.miniNormalizedAreaData = (0, miniChartHelpers_1.normalizeStackData)(miniStackedArea_1.miniStackedAreaData);
class MiniNormalizedAreaClass extends miniStackedArea_1.MiniStackedAreaClass {
    constructor(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, data = exports.miniNormalizedAreaData, tooltipName = 'normalizedAreaTooltip') {
        super(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, data, tooltipName);
    }
}
exports.MiniNormalizedAreaClass = MiniNormalizedAreaClass;
exports.MiniNormalizedArea = {
    chartType: 'normalizedArea',
    miniChart: MiniNormalizedAreaClass,
};


/***/ }),

/***/ 5133:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniStackedArea = exports.MiniStackedAreaClass = exports.miniStackedAreaData = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniArea_1 = __webpack_require__(3564);
exports.miniStackedAreaData = (0, miniChartHelpers_1.stackData)(miniArea_1.miniAreaData);
class MiniStackedAreaClass extends miniArea_1.MiniAreaClass {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data = exports.miniStackedAreaData, tooltipName = 'stackedAreaTooltip') {
        super(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data, tooltipName, true);
    }
    updateColors(fills, strokes) {
        this.areas.forEach((area, i) => {
            area.fill = fills[i];
            area.stroke = strokes[i];
        });
    }
}
exports.MiniStackedAreaClass = MiniStackedAreaClass;
exports.MiniStackedArea = {
    chartType: 'stackedArea',
    miniChart: MiniStackedAreaClass,
};


/***/ }),

/***/ 702:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniBar = exports.MiniBarClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniBarClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'groupedBarTooltip');
        const { _Scene } = agChartsExports;
        const padding = this.padding;
        const size = this.size;
        const data = [2, 3, 4];
        const yScale = new _Scene.CategoryScale();
        yScale.domain = [0, 1, 2];
        yScale.range = [padding, size - padding];
        yScale.paddingInner = 0.3;
        yScale.paddingOuter = 0.3;
        const xScale = new _Scene.LinearScale();
        xScale.domain = [0, 4];
        xScale.range = [size - padding, padding];
        const bottom = xScale.convert(0);
        const height = yScale.bandwidth;
        this.bars = data.map((datum, i) => {
            const rect = new _Scene.Rect();
            rect.x = padding;
            rect.y = yScale.convert(i);
            rect.width = bottom - xScale.convert(datum);
            rect.height = height;
            rect.strokeWidth = 0;
            rect.crisp = true;
            return rect;
        });
        this.updateColors(fills, strokes);
        this.root.append(this.bars);
    }
    updateColors(fills, strokes) {
        this.bars.forEach((bar, i) => {
            bar.fill = fills[i];
            bar.stroke = strokes[i];
        });
    }
}
exports.MiniBarClass = MiniBarClass;
exports.MiniBar = {
    chartType: 'groupedBar',
    miniChart: MiniBarClass,
};


/***/ }),

/***/ 3245:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniNormalizedBar = exports.MiniNormalizedBarClass = void 0;
const miniStackedBar_1 = __webpack_require__(4161);
const miniNormalizedBarData = [
    [10, 10, 10],
    [6, 7, 8],
    [2, 4, 6],
];
class MiniNormalizedBarClass extends miniStackedBar_1.MiniStackedBarClass {
    constructor(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme) {
        super(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, miniNormalizedBarData, [0, 10], 'normalizedBarTooltip');
    }
}
exports.MiniNormalizedBarClass = MiniNormalizedBarClass;
exports.MiniNormalizedBar = {
    chartType: 'normalizedBar',
    miniChart: MiniNormalizedBarClass,
};


/***/ }),

/***/ 4161:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniStackedBar = exports.MiniStackedBarClass = exports.miniStackedBarData = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
exports.miniStackedBarData = [
    [8, 12, 16],
    [6, 9, 12],
    [2, 3, 4],
];
class MiniStackedBarClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data = exports.miniStackedBarData, xScaleDomain = [0, 16], tooltipName = 'stackedBarTooltip') {
        super(container, agChartsExports, tooltipName);
        const { _Scene } = agChartsExports;
        const size = this.size;
        const padding = this.padding;
        const yScale = new _Scene.CategoryScale();
        yScale.domain = [0, 1, 2];
        yScale.range = [padding, size - padding];
        yScale.paddingInner = 0.3;
        yScale.paddingOuter = 0.3;
        const xScale = new _Scene.LinearScale();
        xScale.domain = xScaleDomain;
        xScale.range = [size - padding, padding];
        const bottom = xScale.convert(0);
        const height = yScale.bandwidth;
        this.bars = data.map((series) => series.map((datum, i) => {
            const rect = new _Scene.Rect();
            rect.x = padding;
            rect.y = yScale.convert(i);
            rect.width = bottom - xScale.convert(datum);
            rect.height = height;
            rect.strokeWidth = 0;
            rect.crisp = true;
            return rect;
        }));
        this.updateColors(fills, strokes);
        this.root.append([].concat.apply([], this.bars));
    }
    updateColors(fills, strokes) {
        this.bars.forEach((series, i) => series.forEach((bar) => {
            bar.fill = fills[i];
            bar.stroke = strokes[i];
        }));
    }
}
exports.MiniStackedBarClass = MiniStackedBarClass;
exports.MiniStackedBar = {
    chartType: 'stackedBar',
    miniChart: MiniStackedBarClass,
};


/***/ }),

/***/ 1990:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniColumn = exports.MiniColumnClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniColumnClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'groupedColumnTooltip');
        this.columnData = [2, 3, 4];
        const { root, columnData, size, padding } = this;
        this.columns = (0, miniChartHelpers_1.createColumnRects)({
            stacked: false,
            root,
            data: columnData,
            size,
            padding,
            xScaleDomain: [0, 1, 2],
            yScaleDomain: [0, 4],
            xScalePadding: 0.3,
            agChartsExports,
        });
        root.append(this.columns);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.columns.forEach((column, i) => {
            column.fill = fills[i];
            column.stroke = strokes[i];
        });
    }
}
exports.MiniColumnClass = MiniColumnClass;
exports.MiniColumn = {
    chartType: 'groupedColumn',
    miniChart: MiniColumnClass,
};


/***/ }),

/***/ 2115:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniNormalizedColumn = exports.MiniNormalizedColumnClass = exports.miniNormalizedColumnData = void 0;
const miniStackedColumn_1 = __webpack_require__(2397);
exports.miniNormalizedColumnData = [
    [10, 10, 10],
    [6, 7, 8],
    [2, 4, 6],
];
class MiniNormalizedColumnClass extends miniStackedColumn_1.MiniStackedColumnClass {
    constructor(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme) {
        super(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, exports.miniNormalizedColumnData, [0, 10], 'normalizedColumnTooltip');
    }
}
exports.MiniNormalizedColumnClass = MiniNormalizedColumnClass;
exports.MiniNormalizedColumn = {
    chartType: 'normalizedColumn',
    miniChart: MiniNormalizedColumnClass,
};


/***/ }),

/***/ 2397:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniStackedColumn = exports.MiniStackedColumnClass = exports.miniStackedColumnData = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
exports.miniStackedColumnData = [
    [8, 12, 16],
    [6, 9, 12],
    [2, 3, 4],
];
class MiniStackedColumnClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data = exports.miniStackedColumnData, yScaleDomain = [0, 16], tooltipName = 'stackedColumnTooltip') {
        super(container, agChartsExports, tooltipName);
        const { root, size, padding } = this;
        this.stackedColumns = (0, miniChartHelpers_1.createColumnRects)({
            stacked: true,
            root,
            data,
            size,
            padding,
            xScaleDomain: [0, 1, 2],
            yScaleDomain,
            xScalePadding: 0.3,
            agChartsExports,
        });
        root.append([].concat.apply([], this.stackedColumns));
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.stackedColumns.forEach((series, i) => series.forEach((column) => {
            column.fill = fills[i];
            column.stroke = strokes[i];
        }));
    }
}
exports.MiniStackedColumnClass = MiniStackedColumnClass;
exports.MiniStackedColumn = {
    chartType: 'stackedColumn',
    miniChart: MiniStackedColumnClass,
};


/***/ }),

/***/ 539:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniAreaColumnCombo = exports.MiniAreaColumnComboClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniAreaColumnComboClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'areaColumnComboTooltip');
        this.columnData = [3, 4.5];
        this.areaData = [[5, 4, 6, 5, 4]];
        const { root, columnData, areaData, size, padding, agChartsExports: { _Scene }, } = this;
        this.columns = (0, miniChartHelpers_1.createColumnRects)({
            stacked: false,
            root,
            data: columnData,
            size,
            padding,
            xScaleDomain: [0, 1],
            yScaleDomain: [0, 6],
            xScalePadding: 0.5,
            agChartsExports,
        });
        // scale for area series
        const xScale = new _Scene.CategoryScale();
        xScale.range = [padding, size - padding];
        xScale.domain = [0, 1, 2, 3, 4];
        xScale.paddingInner = 1;
        xScale.paddingOuter = 0;
        const yScale = new _Scene.LinearScale();
        yScale.range = [size - padding, padding];
        yScale.domain = [0, 6];
        const pathData = [];
        const yZero = yScale.convert(0);
        const firstX = xScale.convert(0);
        areaData.forEach((series, i) => {
            const points = pathData[i] || (pathData[i] = []);
            series.forEach((data, j) => {
                const yDatum = data;
                const xDatum = j;
                const x = xScale.convert(xDatum);
                const y = yScale.convert(yDatum);
                points[j] = { x, y };
            });
            const lastX = xScale.convert(series.length - 1);
            pathData[i].push({
                x: lastX,
                y: yZero,
            }, {
                x: firstX,
                y: yZero,
            });
        });
        this.areas = pathData.map((points) => {
            const area = new _Scene.Path();
            area.strokeWidth = 0;
            area.fillOpacity = 0.8;
            const path = area.path;
            points.forEach((point, i) => path[i > 0 ? 'lineTo' : 'moveTo'](point.x, point.y));
            return area;
        });
        const areaGroup = new _Scene.Group();
        areaGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
        const columnGroup = new _Scene.Group();
        columnGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
        areaGroup.append(this.areas);
        columnGroup.append(this.columns);
        root.append(areaGroup);
        root.append(columnGroup);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.areas.forEach((area, i) => {
            area.fill = fills[i];
            area.stroke = strokes[i];
        });
        this.columns.forEach((bar, i) => {
            bar.fill = fills[i + 1];
            bar.stroke = strokes[i + 1];
        });
    }
}
exports.MiniAreaColumnComboClass = MiniAreaColumnComboClass;
exports.MiniAreaColumnCombo = {
    chartType: 'areaColumnCombo',
    miniChart: MiniAreaColumnComboClass,
};


/***/ }),

/***/ 6042:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniColumnLineCombo = exports.MiniColumnLineComboClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniColumnLineComboClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'columnLineComboTooltip');
        this.columnData = [3, 4];
        this.lineData = [[5, 4, 6, 5, 4]];
        const { root, columnData, lineData, size, padding } = this;
        this.columns = (0, miniChartHelpers_1.createColumnRects)({
            stacked: false,
            root,
            data: columnData,
            size,
            padding,
            xScaleDomain: [0, 1],
            yScaleDomain: [0, 4],
            xScalePadding: 0.5,
            agChartsExports,
        });
        root.append(this.columns);
        this.lines = (0, miniChartHelpers_1.createLinePaths)(agChartsExports, root, lineData, size, padding);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.columns.forEach((bar, i) => {
            bar.fill = fills[i];
            bar.stroke = strokes[i];
        });
        this.lines.forEach((line, i) => {
            line.stroke = fills[i + 2];
        });
    }
}
exports.MiniColumnLineComboClass = MiniColumnLineComboClass;
exports.MiniColumnLineCombo = {
    chartType: 'columnLineCombo',
    miniChart: MiniColumnLineComboClass,
};


/***/ }),

/***/ 1655:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniCustomCombo = exports.MiniCustomComboClass = void 0;
const miniChart_1 = __webpack_require__(2893);
const miniChartHelpers_1 = __webpack_require__(9004);
class MiniCustomComboClass extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'customComboTooltip');
        this.columnData = [3, 4];
        this.lineData = [[5, 4, 6, 5, 4]];
        const { root, columnData, lineData, size, padding, agChartsExports: { _Scene }, } = this;
        this.columns = (0, miniChartHelpers_1.createColumnRects)({
            stacked: false,
            root,
            data: columnData,
            size,
            padding,
            xScaleDomain: [0, 1],
            yScaleDomain: [0, 4],
            xScalePadding: 0.5,
            agChartsExports,
        });
        root.append(this.columns);
        this.lines = (0, miniChartHelpers_1.createLinePaths)(this.agChartsExports, root, lineData, size, padding);
        const axisStroke = 'grey';
        const axisOvershoot = 3;
        const leftAxis = new _Scene.Line();
        leftAxis.x1 = padding;
        leftAxis.y1 = padding;
        leftAxis.x2 = padding;
        leftAxis.y2 = size - padding + axisOvershoot;
        leftAxis.stroke = axisStroke;
        const bottomAxis = new _Scene.Line();
        bottomAxis.x1 = padding - axisOvershoot + 1;
        bottomAxis.y1 = size - padding;
        bottomAxis.x2 = size - padding + 1;
        bottomAxis.y2 = size - padding;
        bottomAxis.stroke = axisStroke;
        const penIcon = new _Scene.Path();
        this.buildPenIconPath(penIcon);
        penIcon.fill = 'whitesmoke';
        penIcon.stroke = 'darkslategrey';
        penIcon.strokeWidth = 1;
        root.append([bottomAxis, leftAxis, penIcon]);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.columns.forEach((bar, i) => {
            bar.fill = fills[i];
            bar.stroke = strokes[i];
        });
        this.lines.forEach((line, i) => {
            line.stroke = fills[i + 2];
        });
    }
    buildPenIconPath(penIcon) {
        const { path } = penIcon;
        path.moveTo(25.76, 43.46);
        path.lineTo(31.27, 48.53);
        path.moveTo(49.86, 22);
        path.lineTo(49.86, 22);
        path.cubicCurveTo(49.01994659053345, 21.317514933510974, 47.89593834348529, 21.09645997825817, 46.86, 21.41);
        path.lineTo(46.86, 21.41);
        path.cubicCurveTo(45.55460035985361, 21.77260167850787, 44.38777081121966, 22.517979360321792, 43.51, 23.55);
        path.lineTo(25.51, 43.8);
        path.lineTo(25.43, 43.89);
        path.lineTo(23.01, 51.89);
        path.lineTo(22.83, 52.46);
        path.lineTo(31.02, 48.86);
        path.lineTo(49.02, 28.52);
        path.lineTo(49.02, 28.52);
        path.cubicCurveTo(49.940716461596224, 27.521914221246085, 50.54302631059587, 26.2720342455763, 50.75, 24.93);
        path.lineTo(50.75, 24.93);
        path.cubicCurveTo(50.95363374988308, 23.866379846512814, 50.62080640232334, 22.77066734274871, 49.86, 22.0);
        path.closePath();
        path.moveTo(41.76, 25.5);
        path.lineTo(47.34, 30.5);
        path.moveTo(40.74, 26.65);
        path.lineTo(46.25, 31.71);
    }
}
exports.MiniCustomComboClass = MiniCustomComboClass;
exports.MiniCustomCombo = {
    chartType: 'customCombo',
    miniChart: MiniCustomComboClass,
};


/***/ }),

/***/ 8049:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniConeFunnel = exports.MiniConeFunnelClass = void 0;
const miniFunnel_1 = __webpack_require__(8250);
const CONE_FUNNEL_SHAPES = [
    [
        [13, 16],
        [10.75, 11.5],
        [5.25, 11.5],
        [3, 16],
    ],
    [
        [10.75, 11.5],
        [8.875, 6],
        [7.125, 6],
        [5.25, 11.5],
    ],
    [
        [8.875, 6],
        [8.875, 1.5],
        [7.125, 1.5],
        [7.125, 6],
    ],
];
class MiniConeFunnelClass extends miniFunnel_1.MiniFunnelClass {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, tooltipName = 'coneFunnelTooltip') {
        super(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, tooltipName, CONE_FUNNEL_SHAPES);
    }
    updateColors(fills, strokes) {
        this.shapes.forEach((bar, i) => {
            bar.fill = fills[0];
            bar.fillOpacity = 1 - i * 0.2;
            bar.stroke = strokes[0];
            bar.strokeWidth = 0;
        });
    }
}
exports.MiniConeFunnelClass = MiniConeFunnelClass;
exports.MiniConeFunnel = {
    chartType: 'coneFunnel',
    miniChart: MiniConeFunnelClass,
};


/***/ }),

/***/ 8250:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniFunnel = exports.MiniFunnelClass = void 0;
const miniChart_1 = __webpack_require__(2893);
const miniChartHelpers_1 = __webpack_require__(9004);
const FUNNEL_SHAPES = [
    [
        [13, 16],
        [13, 12.0],
        [3, 12.0],
        [3, 16],
    ],
    [
        [12, 11],
        [12, 7],
        [4, 7],
        [4, 11],
    ],
    [
        [10.125, 6],
        [10.125, 1.5],
        [5.875, 1.5],
        [5.875, 6],
    ],
];
class MiniFunnelClass extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, tooltipName = 'funnelTooltip', data = FUNNEL_SHAPES) {
        super(container, agChartsExports, tooltipName);
        this.shapes = (0, miniChartHelpers_1.createShapePaths)(agChartsExports, this.root, data, this.size, this.padding);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.shapes.forEach((bar) => {
            bar.fill = fills[0];
            bar.stroke = strokes[0];
            bar.strokeWidth = 0;
        });
    }
}
exports.MiniFunnelClass = MiniFunnelClass;
exports.MiniFunnel = {
    chartType: 'funnel',
    miniChart: MiniFunnelClass,
};


/***/ }),

/***/ 1244:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniPyramid = exports.MiniPyramidClass = void 0;
const miniFunnel_1 = __webpack_require__(8250);
const PYRAMID_SHAPES = [
    [
        [8, 16],
        [10, 12],
        [6, 12],
    ],
    [
        [10.5, 11],
        [12.5, 7],
        [3.5, 7],
        [5.5, 11],
    ],
    [
        [13, 6],
        [15.5, 1.5],
        [0.5, 1.5],
        [3, 6],
    ],
];
class MiniPyramidClass extends miniFunnel_1.MiniFunnelClass {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, tooltipName = 'pyramidTooltip') {
        super(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, tooltipName, PYRAMID_SHAPES);
    }
    updateColors(fills, strokes) {
        this.shapes.forEach((bar, i) => {
            bar.fill = fills[i];
            bar.stroke = strokes[i];
            bar.strokeWidth = 0;
        });
    }
}
exports.MiniPyramidClass = MiniPyramidClass;
exports.MiniPyramid = {
    chartType: 'pyramid',
    miniChart: MiniPyramidClass,
};


/***/ }),

/***/ 5717:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniSunburst = exports.MiniSunburstClass = void 0;
const miniChartWithPolarAxes_1 = __webpack_require__(2220);
class MiniSunburstClass extends miniChartWithPolarAxes_1.MiniChartWithPolarAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'sunburstTooltip');
        // Hierarchical data using multidimensional array
        this.data = [
            [[], []],
            [[], []],
            [[], []],
        ];
        // Rotate the chart by the given angle (-90 degrees)
        this.angleOffset = -Math.PI / 2;
        this.innerRadiusRatio = 0;
        this.showRadiusAxisLine = false;
        this.showAngleAxisLines = false;
        const { data, size, padding, angleOffset, innerRadiusRatio, agChartsExports: { _Scene }, } = this;
        const radius = (size - padding * 2) / 2;
        const angleRange = [angleOffset + 0, angleOffset + 2 * Math.PI];
        const angleExtent = Math.abs(angleRange[1] - angleRange[0]);
        const radiusRange = [radius * innerRadiusRatio, radius];
        const radiusExtent = Math.abs(radiusRange[1] - radiusRange[0]);
        let maxDepth = 0;
        const findMaxDepth = (data, parentDepth) => {
            data.forEach((child) => {
                const depth = parentDepth + 1;
                maxDepth = Math.max(maxDepth, depth);
                findMaxDepth(child, depth);
            });
        };
        findMaxDepth(data, 0);
        const radiusRatio = radiusExtent / maxDepth;
        const center = this.size / 2;
        const startAngle = angleRange[0];
        this.series = [];
        const createSectors = (data, depth, startAngle, availableAngle, group) => {
            const isArray = Array.isArray(data);
            if (!isArray) {
                return;
            }
            const childDepth = depth + 1;
            let previousAngle = startAngle;
            data.forEach((child, childIndex, children) => {
                let childGroup = group;
                if (!childGroup) {
                    childGroup = new _Scene.Group();
                    this.series.push(childGroup);
                }
                const innerRadius = radiusRange[0] + depth * radiusRatio;
                const outerRadius = radiusRange[0] + childDepth * radiusRatio;
                const angleRatio = 1 / children.length;
                const start = previousAngle;
                const end = start + availableAngle * angleRatio;
                const sector = new _Scene.Sector();
                sector.centerX = center;
                sector.centerY = center;
                sector.innerRadius = innerRadius;
                sector.outerRadius = outerRadius;
                sector.startAngle = start;
                sector.endAngle = end;
                sector.stroke = undefined;
                sector.strokeWidth = 0;
                sector.inset = 0.75;
                previousAngle = end;
                childGroup.append(sector);
                createSectors(child, childDepth, start, Math.abs(end - start), childGroup);
            });
        };
        createSectors(data, 0, startAngle, angleExtent);
        this.root.append(this.series);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.series.forEach((group, i) => {
            for (const sector of group.children()) {
                sector.fill = fills[i % fills.length];
                sector.stroke = strokes[i % strokes.length];
            }
        });
    }
}
exports.MiniSunburstClass = MiniSunburstClass;
exports.MiniSunburst = {
    chartType: 'sunburst',
    miniChart: MiniSunburstClass,
};


/***/ }),

/***/ 7439:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniTreemap = exports.MiniTreemapClass = void 0;
const miniChart_1 = __webpack_require__(2893);
class MiniTreemapClass extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, fills, strokes, themeTemplate, isCustomTheme) {
        super(container, agChartsExports, 'treemapTooltip');
        const { size, padding, agChartsExports: { _Scene }, } = this;
        const data = [
            [1, 1],
            [3, 2, 1],
        ];
        const treeSize = data.length;
        const treePadding = treeSize % 2 === 0 ? 0.3 : 0.2;
        const range = [padding, size - padding];
        const columns = data.length;
        const columnParts = (columns * (columns + 1)) / 2;
        const columnPadding = treePadding / (columns - 1);
        const availableRange = range[1] - range[0];
        const availableWidth = availableRange - treePadding;
        let previousX = range[0];
        this.rects = data.reduce((rects, d, columnIndex) => {
            rects ?? (rects = []);
            const widthRatio = (columns - columnIndex) / columnParts;
            const width = availableWidth * widthRatio;
            const rows = d.length;
            const rowParts = d.reduce((parts, ratio) => (parts += ratio), 0);
            const rowPadding = treePadding / (rows - 1 || 1);
            const availableHeight = rows > 1 ? availableRange - treePadding : availableRange;
            let previousY = range[0];
            const xRects = d.map((ratio) => {
                const rect = new _Scene.Rect();
                const height = (availableHeight * ratio) / rowParts;
                rect.x = previousX;
                rect.y = previousY;
                rect.width = width;
                rect.height = height;
                rect.strokeWidth = 0.75;
                rect.crisp = true;
                previousY += height + rowPadding;
                return rect;
            });
            previousX += width + columnPadding;
            rects.push(...xRects);
            return rects;
        }, []);
        this.updateColors(fills, strokes, themeTemplate, isCustomTheme);
        const rectGroup = new _Scene.Group();
        rectGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding, size - padding));
        rectGroup.append(this.rects);
        this.root.append(rectGroup);
    }
    updateColors(fills, strokes, themeTemplate, isCustomTheme) {
        const defaultBackgroundColor = themeTemplate?.get(this.agChartsExports._Theme.themeSymbols.DEFAULT_BACKGROUND_COLOUR);
        const backgroundFill = (Array.isArray(defaultBackgroundColor) ? defaultBackgroundColor[0] : defaultBackgroundColor) ?? 'white';
        this.rects.forEach((rect, i) => {
            rect.fill = fills[i % strokes.length];
            rect.stroke = isCustomTheme ? strokes[i % strokes.length] : backgroundFill;
        });
    }
}
exports.MiniTreemapClass = MiniTreemapClass;
exports.MiniTreemap = {
    chartType: 'treemap',
    miniChart: MiniTreemapClass,
};


/***/ }),

/***/ 5626:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniHistogram = exports.MiniHistogramClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniHistogramClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'histogramTooltip');
        const { padding, size, agChartsExports: { _Scene }, } = this;
        // approx normal curve
        const data = [2, 5, 11, 13, 10, 6, 1];
        const xScale = new _Scene.LinearScale();
        xScale.domain = [0, data.length];
        xScale.range = [padding, size - padding];
        const yScale = new _Scene.LinearScale();
        yScale.domain = [0, data.reduce((a, b) => Math.max(a, b), 0)];
        yScale.range = [size - padding, padding];
        const bottom = yScale.convert(0);
        this.bars = data.map((datum, i) => {
            const top = yScale.convert(datum);
            const left = xScale.convert(i);
            const right = xScale.convert(i + 1);
            const rect = new _Scene.Rect();
            rect.x = left;
            rect.y = top;
            rect.width = right - left;
            rect.height = bottom - top;
            rect.strokeWidth = 1;
            rect.strokeOpacity = 0.75;
            rect.crisp = true;
            return rect;
        });
        this.updateColors(fills, strokes);
        this.root.append(this.bars);
    }
    updateColors([fill], [stroke]) {
        this.bars.forEach((bar) => {
            bar.fill = fill;
            bar.stroke = stroke;
        });
    }
}
exports.MiniHistogramClass = MiniHistogramClass;
exports.MiniHistogram = {
    chartType: 'histogram',
    miniChart: MiniHistogramClass,
};


/***/ }),

/***/ 6544:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(5608);
tslib_1.__exportStar(__webpack_require__(1990), exports);
tslib_1.__exportStar(__webpack_require__(2397), exports);
tslib_1.__exportStar(__webpack_require__(2115), exports);
tslib_1.__exportStar(__webpack_require__(702), exports);
tslib_1.__exportStar(__webpack_require__(4161), exports);
tslib_1.__exportStar(__webpack_require__(3245), exports);
tslib_1.__exportStar(__webpack_require__(210), exports);
tslib_1.__exportStar(__webpack_require__(7716), exports);
tslib_1.__exportStar(__webpack_require__(7526), exports);
tslib_1.__exportStar(__webpack_require__(9005), exports);
tslib_1.__exportStar(__webpack_require__(8051), exports);
tslib_1.__exportStar(__webpack_require__(434), exports);
tslib_1.__exportStar(__webpack_require__(3268), exports);
tslib_1.__exportStar(__webpack_require__(3564), exports);
tslib_1.__exportStar(__webpack_require__(5133), exports);
tslib_1.__exportStar(__webpack_require__(6249), exports);
tslib_1.__exportStar(__webpack_require__(5626), exports);
tslib_1.__exportStar(__webpack_require__(781), exports);
tslib_1.__exportStar(__webpack_require__(9702), exports);
tslib_1.__exportStar(__webpack_require__(5520), exports);
tslib_1.__exportStar(__webpack_require__(8660), exports);
tslib_1.__exportStar(__webpack_require__(2036), exports);
tslib_1.__exportStar(__webpack_require__(4823), exports);
tslib_1.__exportStar(__webpack_require__(7049), exports);
tslib_1.__exportStar(__webpack_require__(1819), exports);
tslib_1.__exportStar(__webpack_require__(7439), exports);
tslib_1.__exportStar(__webpack_require__(5717), exports);
tslib_1.__exportStar(__webpack_require__(795), exports);
tslib_1.__exportStar(__webpack_require__(3209), exports);
tslib_1.__exportStar(__webpack_require__(6042), exports);
tslib_1.__exportStar(__webpack_require__(539), exports);
tslib_1.__exportStar(__webpack_require__(1655), exports);


/***/ }),

/***/ 7526:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniLine = exports.MiniLineClass = exports.miniLineData = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
exports.miniLineData = [
    [1, 3, 5],
    [2, 6, 4],
    [5, 3, 1],
];
class MiniLineClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data = exports.miniLineData, tooltipName = 'lineTooltip') {
        super(container, agChartsExports, tooltipName);
        const { size, padding, root } = this;
        this.lines = (0, miniChartHelpers_1.createLinePaths)(agChartsExports, root, data, size, padding);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, _strokes) {
        this.lines.forEach((line, i) => {
            line.stroke = fills[i];
        });
    }
}
exports.MiniLineClass = MiniLineClass;
exports.MiniLine = {
    chartType: 'line',
    miniChart: MiniLineClass,
};


/***/ }),

/***/ 8051:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniNormalizedLine = exports.MiniNormalizedLineClass = exports.miniNormalizedLineData = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniLine_1 = __webpack_require__(7526);
const miniStackedLine_1 = __webpack_require__(9005);
exports.miniNormalizedLineData = (0, miniChartHelpers_1.normalizeStackData)(miniStackedLine_1.miniStackedLineData);
class MiniNormalizedLineClass extends miniLine_1.MiniLineClass {
    constructor(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, data = exports.miniNormalizedLineData, tooltipName = 'normalizedLineTooltip') {
        super(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, data, tooltipName);
    }
}
exports.MiniNormalizedLineClass = MiniNormalizedLineClass;
exports.MiniNormalizedLine = {
    chartType: 'normalizedLine',
    miniChart: MiniNormalizedLineClass,
};


/***/ }),

/***/ 9005:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniStackedLine = exports.MiniStackedLineClass = exports.miniStackedLineData = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniLine_1 = __webpack_require__(7526);
exports.miniStackedLineData = (0, miniChartHelpers_1.stackData)(miniLine_1.miniLineData);
class MiniStackedLineClass extends miniLine_1.MiniLineClass {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data = exports.miniStackedLineData, tooltipName = 'stackedLineTooltip') {
        super(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, data, tooltipName);
    }
}
exports.MiniStackedLineClass = MiniStackedLineClass;
exports.MiniStackedLine = {
    chartType: 'stackedLine',
    miniChart: MiniStackedLineClass,
};


/***/ }),

/***/ 2893:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniChart = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const CANVAS_CLASS = 'ag-chart-mini-thumbnail-canvas';
class MiniChart extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(container, agChartsExports, tooltipName) {
        super();
        this.agChartsExports = agChartsExports;
        this.tooltipName = tooltipName;
        this.size = 58;
        this.padding = 5;
        const { _Scene } = agChartsExports;
        this.root = new _Scene.Group();
        const scene = new _Scene.Scene({
            width: this.size,
            height: this.size,
        });
        scene.canvas.element.classList.add(CANVAS_CLASS);
        scene.setRoot(this.root);
        scene.setContainer(container);
        this.scene = scene;
    }
    postConstruct() {
        this.scene.canvas.element.title = this.chartTranslation.translate(this.tooltipName);
        // Necessary to force scene graph render as we are not using the standalone factory.
        try {
            this.scene.render();
        }
        catch (e) {
            (0, ag_grid_community_1._error)(108, { e });
        }
    }
}
exports.MiniChart = MiniChart;


/***/ }),

/***/ 9004:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.accumulateData = exports.createPolarPaths = exports.normalizeStackData = exports.stackData = exports.createAreaPaths = exports.createLinePaths = exports.createShapePaths = exports.commandsToPath = exports.closePathViaOrigin = exports.closePathViaPreviousSeries = exports.createAreaPathCommands = exports.createPath = exports.closePath = exports.createXYPathCommands = exports.createXPathCommands = exports.prepareLinearScene = exports.prepareXYScales = exports.createColumnRects = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
function createColumnRects(params) {
    const { stacked, size, padding, xScalePadding, xScaleDomain, yScaleDomain, agChartsExports: { _Scene }, } = params;
    const xScale = new _Scene.CategoryScale();
    xScale.domain = xScaleDomain;
    xScale.range = [padding, size - padding];
    xScale.paddingInner = xScalePadding;
    xScale.paddingOuter = xScalePadding;
    const yScale = new _Scene.LinearScale();
    yScale.domain = yScaleDomain;
    yScale.range = [size - padding, padding];
    const createBars = (series, xScale, yScale) => {
        return series.map((datum, i) => {
            const top = yScale.convert(datum);
            const rect = new _Scene.Rect();
            rect.x = xScale.convert(i);
            rect.y = top;
            rect.width = xScale.bandwidth;
            rect.height = yScale.convert(0) - top;
            rect.strokeWidth = 0;
            rect.crisp = true;
            return rect;
        });
    };
    if (stacked) {
        return params.data.map((d) => createBars(d, xScale, yScale));
    }
    return createBars(params.data, xScale, yScale);
}
exports.createColumnRects = createColumnRects;
function prepareXYScales(_Scene, data, size, padding) {
    const xDomain = [];
    const yDomain = [];
    data.forEach((item) => {
        item.forEach(([x, y]) => {
            xDomain.push(x);
            yDomain.push(y);
        });
    });
    const xScale = new _Scene.LinearScale();
    xScale.domain = [Math.min(...xDomain), Math.max(...xDomain)];
    xScale.range = [padding, size - padding];
    const yScale = new _Scene.LinearScale();
    yScale.domain = [Math.min(...yDomain), Math.max(...yDomain)];
    yScale.range = [size - padding, padding];
    return { xScale, yScale };
}
exports.prepareXYScales = prepareXYScales;
function prepareLinearScene(_Scene, data, size, padding) {
    const xDomain = [0, data[0].length - 1];
    const yDomain = data.reduce((acc, curr) => {
        curr.forEach((datum) => {
            if (datum < acc[0]) {
                acc[0] = datum;
            }
            if (datum > acc[1]) {
                acc[1] = datum;
            }
        });
        return acc;
    }, [Infinity, -Infinity]);
    yDomain[0]--;
    yDomain[yDomain.length - 1]++;
    const xScale = new _Scene.LinearScale();
    xScale.domain = xDomain;
    xScale.range = [padding, size - padding];
    const yScale = new _Scene.LinearScale();
    yScale.domain = yDomain;
    yScale.range = [size - padding, padding];
    return { xScale, yScale };
}
exports.prepareLinearScene = prepareLinearScene;
function createXPathCommands(data, xScale, yScale) {
    return data.map((series) => series.map((datum, i) => [
        i > 0 ? 'lineTo' : 'moveTo',
        xScale.convert(i),
        yScale.convert(datum),
    ]));
}
exports.createXPathCommands = createXPathCommands;
function createXYPathCommands(shape, xScale, yScale) {
    return shape.map(([x, y], i) => [i > 0 ? 'lineTo' : 'moveTo', xScale.convert(x), yScale.convert(y)]);
}
exports.createXYPathCommands = createXYPathCommands;
function closePath(commandSegments) {
    const closingCommand = commandSegments[0];
    const first = commandSegments[1];
    const last = (0, ag_grid_community_1._last)(commandSegments);
    if (first[1] !== last[1] || first[2] !== last[2]) {
        commandSegments.push([closingCommand[0], first[1], first[2]]);
    }
    return commandSegments;
}
exports.closePath = closePath;
function createPath(_Scene, commands) {
    const path = new _Scene.Path();
    commands.forEach(([command, x, y]) => path.path[command](x, y));
    return path;
}
exports.createPath = createPath;
function createAreaPathCommands(commands, yScale, stacked) {
    return commands.map((pathCommands, index, all) => {
        const closingPath = stacked
            ? closePathViaPreviousSeries(all, index, yScale)
            : closePathViaOrigin(pathCommands, yScale);
        // reverse path to maintain CW winding order
        const closingPathCommands = [...closingPath]
            .reverse()
            .map(([_, x, y]) => ['lineTo', x, y]);
        const first = pathCommands[0];
        const last = (0, ag_grid_community_1._last)(closingPathCommands);
        // close the path if needed
        if (first[1] !== last[1] || first[2] !== last[2]) {
            closingPathCommands.push(['lineTo', first[1], first[2]]);
        }
        return [...pathCommands, ...closingPathCommands];
    });
}
exports.createAreaPathCommands = createAreaPathCommands;
function closePathViaPreviousSeries(all, index, yScale) {
    if (index === 0) {
        return closePathViaOrigin(all[index], yScale);
    }
    return [...all[index - 1]];
}
exports.closePathViaPreviousSeries = closePathViaPreviousSeries;
function closePathViaOrigin(pathCommands, yScale) {
    return pathCommands.map(([c, x]) => [c, x, yScale.convert(0)]);
}
exports.closePathViaOrigin = closePathViaOrigin;
function commandsToPath(_Scene, commands) {
    const path = createPath(_Scene, commands);
    path.fill = undefined;
    path.lineCap = 'round';
    path.strokeWidth = 3;
    return path;
}
exports.commandsToPath = commandsToPath;
function createShapePaths({ _Scene }, root, shapes, size, padding) {
    const { xScale, yScale } = prepareXYScales(_Scene, shapes, size, padding);
    const openPathsCommands = shapes.map((shape) => createXYPathCommands(shape, xScale, yScale));
    const shapesCommands = openPathsCommands.map((path) => closePath(path));
    const shapePaths = shapesCommands.map((shapeCommands) => commandsToPath(_Scene, shapeCommands));
    const paths = shapePaths.reduce((acc, curr) => acc.concat(curr), []);
    const pathsGroup = new _Scene.Group();
    pathsGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
    pathsGroup.append(paths);
    root.append(pathsGroup);
    return paths;
}
exports.createShapePaths = createShapePaths;
function createLinePaths({ _Scene }, root, data, size, padding) {
    const { xScale, yScale } = prepareLinearScene(_Scene, data, size, padding);
    const pathCommands = createXPathCommands(data, xScale, yScale);
    const paths = pathCommands.map((commands) => commandsToPath(_Scene, commands));
    const pathsGroup = new _Scene.Group();
    pathsGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
    pathsGroup.append(paths);
    root.append(pathsGroup);
    return paths;
}
exports.createLinePaths = createLinePaths;
function createAreaPaths(_Scene, root, data, size, padding, stacked = false) {
    const { xScale, yScale } = prepareLinearScene(_Scene, data, size, padding);
    const pathCommands = createAreaPathCommands(createXPathCommands(data, xScale, yScale), yScale, stacked);
    const areasGroup = new _Scene.Group();
    areasGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
    const paths = pathCommands.map((commands) => createPath(_Scene, commands));
    areasGroup.append(paths);
    root.append(areasGroup);
    return paths;
}
exports.createAreaPaths = createAreaPaths;
function stackData(data) {
    return data.map((stack, sindex, array) => stack.map((_y, i) => array.slice(0, sindex + 1).reduce((p, c) => p + c[i], 0)));
}
exports.stackData = stackData;
function normalizeStackData(data) {
    const colSum = data.map((_, index) => data.reduce((acc, cur) => Math.max(acc, cur[index]), 0));
    return data.map((stack) => stack.map((y, index) => (y / colSum[index]) * 19));
}
exports.normalizeStackData = normalizeStackData;
function createPolarPaths(agChartsExports, root, data, size, radius, innerRadius, markerSize = 0) {
    const { _Scene } = agChartsExports;
    const angleScale = new _Scene.LinearScale();
    angleScale.domain = [0, 7];
    angleScale.range = [-Math.PI, Math.PI].map((angle) => angle + Math.PI / 2);
    const radiusScale = new _Scene.LinearScale();
    radiusScale.domain = [0, 10];
    radiusScale.range = [radius, innerRadius];
    const markers = [];
    const center = size / 2;
    const paths = data.map((series) => {
        const path = new _Scene.Path();
        path.strokeWidth = 1;
        path.strokeOpacity = 0.5;
        path.lineCap = 'round';
        path.fill = undefined;
        path.fillOpacity = 0.8;
        series.forEach((datum, i) => {
            const angle = angleScale.convert(i);
            const r = radius + innerRadius - radiusScale.convert(datum);
            const x = r * Math.cos(angle) + center;
            const y = r * Math.sin(angle) + center;
            path.path[i > 0 ? 'lineTo' : 'moveTo'](x, y);
            if (markerSize > 0) {
                const marker = new _Scene.Marker({ shape: 'circle' });
                marker.x = x;
                marker.y = y;
                marker.size = markerSize;
                markers.push(marker);
            }
        });
        path.path.closePath();
        return path;
    });
    const group = new _Scene.Group();
    group.append([...paths, ...markers]);
    root.append(group);
    return { paths, markers };
}
exports.createPolarPaths = createPolarPaths;
function accumulateData(data) {
    let [min, max] = [Infinity, -Infinity];
    const processedData = data.reduce((acc, curr, currIndex) => {
        const previous = currIndex > 0 ? acc[currIndex - 1] : undefined;
        acc[currIndex] ?? (acc[currIndex] = []);
        const current = acc[currIndex];
        curr.forEach((datum, datumIndex) => {
            if (previous) {
                datum += previous[datumIndex];
            }
            current[datumIndex] = datum;
            if (current[datumIndex] < min) {
                min = current[datumIndex];
            }
            if (current[datumIndex] > max) {
                max = current[datumIndex];
            }
        });
        return acc;
    }, []);
    return { processedData, min, max };
}
exports.accumulateData = accumulateData;


/***/ }),

/***/ 1408:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniChartWithAxes = void 0;
const miniChart_1 = __webpack_require__(2893);
class MiniChartWithAxes extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, tooltipName) {
        super(container, agChartsExports, tooltipName);
        this.stroke = 'gray';
        this.axisOvershoot = 3;
    }
    postConstruct() {
        const { _Scene } = this.agChartsExports;
        const size = this.size;
        const padding = this.padding;
        const leftAxis = new _Scene.Line();
        leftAxis.x1 = padding;
        leftAxis.y1 = padding;
        leftAxis.x2 = padding;
        leftAxis.y2 = size - padding + this.axisOvershoot;
        leftAxis.stroke = this.stroke;
        const bottomAxis = new _Scene.Line();
        bottomAxis.x1 = padding - this.axisOvershoot + 1;
        bottomAxis.y1 = size - padding;
        bottomAxis.x2 = size - padding + 1;
        bottomAxis.y2 = size - padding;
        bottomAxis.stroke = this.stroke;
        const root = this.root;
        root.append(leftAxis);
        root.append(bottomAxis);
        super.postConstruct();
    }
}
exports.MiniChartWithAxes = MiniChartWithAxes;


/***/ }),

/***/ 2220:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniChartWithPolarAxes = void 0;
const miniChart_1 = __webpack_require__(2893);
class MiniChartWithPolarAxes extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, tooltipName) {
        super(container, agChartsExports, tooltipName);
        this.stroke = 'gray';
        this.showRadiusAxisLine = true;
        this.showAngleAxisLines = true;
    }
    postConstruct() {
        const { _Scene } = this.agChartsExports;
        const size = this.size;
        const padding = this.padding;
        const combinedPadding = padding * 2;
        const axisLineRadius = (size - combinedPadding) / 2;
        const gridRadii = this.showAngleAxisLines
            ? [axisLineRadius, axisLineRadius * 0.8, axisLineRadius * 0.6, axisLineRadius * 0.4]
            : [];
        const radiusAxisLine = new _Scene.Line();
        radiusAxisLine.x1 = size / 2;
        radiusAxisLine.y1 = padding;
        radiusAxisLine.x2 = size / 2;
        radiusAxisLine.y2 = size - padding - axisLineRadius - gridRadii[gridRadii.length - 1];
        radiusAxisLine.stroke = this.stroke;
        radiusAxisLine.strokeOpacity = 0.5;
        radiusAxisLine.fill = undefined;
        radiusAxisLine.visible = this.showRadiusAxisLine;
        const x = padding + axisLineRadius;
        this.gridLines = gridRadii.map((radius, index) => {
            const gridLine = new _Scene.Path();
            gridLine.path.arc(x, x, radius, 0, 2 * Math.PI);
            gridLine.strokeWidth = 1;
            gridLine.stroke = this.stroke;
            gridLine.strokeOpacity = index === 0 ? 0.5 : 0.2;
            gridLine.fill = undefined;
            return gridLine;
        });
        const root = this.root;
        root.append(radiusAxisLine);
        if (this.gridLines.length > 0)
            root.append(this.gridLines);
        super.postConstruct();
    }
}
exports.MiniChartWithPolarAxes = MiniChartWithPolarAxes;


/***/ }),

/***/ 7716:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniDonut = exports.MiniDonutClass = void 0;
const miniChart_1 = __webpack_require__(2893);
class MiniDonutClass extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, fills, strokes, _themeTemplateParameters, _isCustomTheme, centerRadiusScaler = 0.6, tooltipName = 'donutTooltip') {
        super(container, agChartsExports, tooltipName);
        const { size, padding, agChartsExports: { _Scene }, } = this;
        const radius = (size - padding * 2) / 2;
        const center = radius + padding;
        const toRadians = _Scene.toRadians;
        const angles = [
            [toRadians(-90), toRadians(30)],
            [toRadians(30), toRadians(120)],
            [toRadians(120), toRadians(180)],
            [toRadians(180), toRadians(210)],
            [toRadians(210), toRadians(240)],
            [toRadians(240), toRadians(270)],
        ];
        this.sectors = angles.map(([startAngle, endAngle]) => {
            const sector = new _Scene.Sector();
            sector.centerX = center;
            sector.centerY = center;
            sector.innerRadius = radius * centerRadiusScaler;
            sector.outerRadius = radius;
            sector.startAngle = startAngle;
            sector.endAngle = endAngle;
            sector.stroke = undefined;
            sector.strokeWidth = 0;
            sector.inset = 0.75;
            return sector;
        });
        this.updateColors(fills, strokes);
        this.root.append(this.sectors);
    }
    updateColors(fills, strokes) {
        this.sectors.forEach((sector, i) => {
            sector.fill = fills[i % fills.length];
            sector.stroke = strokes[i % strokes.length];
        });
    }
}
exports.MiniDonutClass = MiniDonutClass;
exports.MiniDonut = {
    chartType: 'donut',
    miniChart: MiniDonutClass,
};


/***/ }),

/***/ 210:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniPie = exports.MiniPieClass = void 0;
const miniDonut_1 = __webpack_require__(7716);
class MiniPieClass extends miniDonut_1.MiniDonutClass {
    constructor(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme) {
        super(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme, 0, 'pieTooltip');
    }
}
exports.MiniPieClass = MiniPieClass;
exports.MiniPie = {
    chartType: 'pie',
    miniChart: MiniPieClass,
};


/***/ }),

/***/ 2036:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniNightingale = exports.MiniNightingaleClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithPolarAxes_1 = __webpack_require__(2220);
class MiniNightingaleClass extends miniChartWithPolarAxes_1.MiniChartWithPolarAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'nightingaleTooltip');
        this.data = [
            [6, 10, 9, 8, 7, 8],
            [4, 6, 5, 4, 5, 5],
            [3, 5, 4, 3, 4, 7],
        ];
        this.showRadiusAxisLine = false;
        const { size, padding, data, agChartsExports: { _Scene }, } = this;
        const radius = (size - padding * 2) / 2;
        const angleScale = new _Scene.CategoryScale();
        angleScale.domain = data[0].map((_, index) => index);
        angleScale.range = [-Math.PI, Math.PI];
        angleScale.paddingInner = 0;
        angleScale.paddingOuter = 0;
        const bandwidth = angleScale.bandwidth * 0.7;
        const { processedData, max } = (0, miniChartHelpers_1.accumulateData)(data);
        const radiusScale = new _Scene.LinearScale();
        radiusScale.domain = [0, max];
        radiusScale.range = [0, radius];
        const center = size / 2;
        this.series = processedData.map((series, index) => {
            const previousSeries = index < 0 ? undefined : processedData[index - 1];
            const seriesGroup = new _Scene.Group({ zIndex: 1000000 });
            const seriesSectors = series.map((datum, i) => {
                const previousDatum = previousSeries?.[i];
                const outerRadius = radiusScale.convert(datum);
                const innerRadius = radiusScale.convert(previousDatum ?? 0);
                const startAngle = angleScale.convert(i);
                const endAngle = startAngle + bandwidth;
                const sector = new _Scene.Sector();
                sector.centerX = center;
                sector.centerY = center;
                sector.innerRadius = innerRadius;
                sector.outerRadius = outerRadius;
                sector.startAngle = startAngle;
                sector.endAngle = endAngle;
                sector.stroke = undefined;
                sector.strokeWidth = 0;
                return sector;
            });
            seriesGroup.append(seriesSectors);
            return seriesGroup;
        });
        this.root.append(this.series);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.series.forEach((group, i) => {
            for (const sector of group.children()) {
                sector.fill = fills[i % fills.length];
                sector.stroke = strokes[i % strokes.length];
            }
        });
    }
}
exports.MiniNightingaleClass = MiniNightingaleClass;
exports.MiniNightingale = {
    chartType: 'nightingale',
    miniChart: MiniNightingaleClass,
};


/***/ }),

/***/ 8660:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniRadarArea = exports.MiniRadarAreaClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithPolarAxes_1 = __webpack_require__(2220);
class MiniRadarAreaClass extends miniChartWithPolarAxes_1.MiniChartWithPolarAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'radarAreaTooltip');
        this.data = [
            [8, 10, 5, 7, 4, 1, 5, 8],
            [1, 1, 2, 7, 7, 8, 10, 1],
            [4, 5, 9, 9, 4, 2, 3, 4],
        ];
        const { size, padding, root, data } = this;
        this.showRadiusAxisLine = false;
        const radius = (size - padding * 2) / 2;
        const innerRadius = radius - size * 0.3;
        this.areas = (0, miniChartHelpers_1.createPolarPaths)(agChartsExports, root, data, size, radius, innerRadius).paths;
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.areas.forEach((area, i) => {
            area.fill = fills[i];
            area.stroke = strokes[i];
        });
    }
}
exports.MiniRadarAreaClass = MiniRadarAreaClass;
exports.MiniRadarArea = {
    chartType: 'radarArea',
    miniChart: MiniRadarAreaClass,
};


/***/ }),

/***/ 5520:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniRadarLine = exports.MiniRadarLineClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithPolarAxes_1 = __webpack_require__(2220);
class MiniRadarLineClass extends miniChartWithPolarAxes_1.MiniChartWithPolarAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'radarLineTooltip');
        this.markerSize = 4;
        this.data = [
            [8, 7, 8, 7, 8, 8, 7, 8],
            [6, 8, 5, 10, 6, 7, 4, 6],
            [0, 3, 3, 5, 4, 4, 2, 0],
        ];
        this.showRadiusAxisLine = false;
        const { size, padding, root, data } = this;
        const radius = (size - padding * 2) / 2;
        const innerRadius = 0;
        const { paths, markers } = (0, miniChartHelpers_1.createPolarPaths)(agChartsExports, root, data, size, radius, innerRadius, this.markerSize);
        this.lines = paths;
        this.markers = markers;
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.lines.forEach((line, i) => {
            const n = this.data[i].length;
            line.stroke = fills[i];
            const startIdx = i * n;
            const endIdx = startIdx + n;
            const markers = this.markers.slice(startIdx, endIdx);
            markers.forEach((marker) => {
                marker.stroke = strokes[i];
                marker.fill = fills[i];
            });
        });
    }
}
exports.MiniRadarLineClass = MiniRadarLineClass;
exports.MiniRadarLine = {
    chartType: 'radarLine',
    miniChart: MiniRadarLineClass,
};


/***/ }),

/***/ 9702:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniRadialBar = exports.MiniRadialBarClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithPolarAxes_1 = __webpack_require__(2220);
class MiniRadialBarClass extends miniChartWithPolarAxes_1.MiniChartWithPolarAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'radialBarTooltip');
        this.data = [
            [6, 8, 10],
            [4, 4, 3],
            [5, 4, 2],
        ];
        this.showRadiusAxisLine = false;
        const { size, padding, data, agChartsExports: { _Scene }, } = this;
        const radius = (size - padding) / 2;
        const innerRadiusRatio = 0.4;
        const innerRadius = radius * innerRadiusRatio;
        const radiusScale = new _Scene.CategoryScale();
        radiusScale.domain = data[0].map((_, index) => index);
        radiusScale.range = [innerRadius, radius];
        radiusScale.paddingInner = 0.5;
        radiusScale.paddingOuter = 0;
        const bandwidth = radiusScale.bandwidth;
        const { processedData, max } = (0, miniChartHelpers_1.accumulateData)(data);
        const angleScale = new _Scene.LinearScale();
        angleScale.domain = [0, Math.ceil(max * 1.5)];
        const start = (3 / 2) * Math.PI;
        const end = start + 2 * Math.PI;
        angleScale.range = [start, end];
        const center = size / 2;
        this.series = processedData.map((series, index) => {
            const previousSeries = index < 0 ? undefined : processedData[index - 1];
            const seriesGroup = new _Scene.Group({ zIndex: 1000000 });
            const seriesSectors = series.map((datum, i) => {
                const previousDatum = previousSeries?.[i] ?? 0;
                const outerRadius = radiusScale.convert(i);
                const innerRadius = outerRadius - bandwidth;
                const startAngle = angleScale.convert(previousDatum);
                const endAngle = angleScale.convert(datum);
                const sector = new _Scene.Sector();
                sector.centerX = center;
                sector.centerY = center;
                sector.innerRadius = innerRadius;
                sector.outerRadius = outerRadius;
                sector.startAngle = startAngle;
                sector.endAngle = endAngle;
                sector.stroke = undefined;
                sector.strokeWidth = 0;
                return sector;
            });
            seriesGroup.append(seriesSectors);
            return seriesGroup;
        });
        this.root.append(this.series);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.series.forEach((group, i) => {
            for (const sector of group.children()) {
                sector.fill = fills[i % fills.length];
                sector.stroke = strokes[i % strokes.length];
            }
        });
    }
}
exports.MiniRadialBarClass = MiniRadialBarClass;
exports.MiniRadialBar = {
    chartType: 'radialBar',
    miniChart: MiniRadialBarClass,
};


/***/ }),

/***/ 781:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniRadialColumn = exports.MiniRadialColumnClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithPolarAxes_1 = __webpack_require__(2220);
class MiniRadialColumnClass extends miniChartWithPolarAxes_1.MiniChartWithPolarAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'radialColumnTooltip');
        this.data = [
            [6, 8, 10, 2, 6, 5],
            [4, 4, 3, 6, 4, 4],
            [5, 4, 2, 9, 8, 9],
        ];
        this.showRadiusAxisLine = false;
        const { padding, size, data, agChartsExports: { _Scene }, } = this;
        const radius = (size - padding * 2) / 2;
        const innerRadiusRatio = 0.4;
        const axisInnerRadius = radius * innerRadiusRatio;
        const angleScale = new _Scene.CategoryScale();
        angleScale.domain = data[0].map((_, index) => index);
        angleScale.range = [0, 2 * Math.PI];
        angleScale.paddingInner = 0;
        angleScale.paddingOuter = 0;
        const bandwidth = angleScale.bandwidth * 0.7;
        const { processedData, max } = (0, miniChartHelpers_1.accumulateData)(data);
        const radiusScale = new _Scene.LinearScale();
        radiusScale.domain = [0, max];
        radiusScale.range = [axisInnerRadius, radius];
        const center = this.size / 2;
        this.series = processedData.map((series, seriesIndex) => {
            const firstSeries = seriesIndex === 0;
            const previousSeries = firstSeries ? undefined : processedData[seriesIndex - 1];
            const seriesGroup = new _Scene.TranslatableGroup({ zIndex: 1000000 });
            const seriesColumns = series.map((datum, i) => {
                const previousDatum = previousSeries?.[i];
                const outerRadius = radiusScale.convert(datum);
                const innerRadius = radiusScale.convert(previousDatum ?? 0);
                const startAngle = angleScale.convert(i);
                const endAngle = startAngle + bandwidth;
                const columnWidth = _Scene.getRadialColumnWidth(startAngle, endAngle, radius, 0.5, 0.5);
                const column = new _Scene.RadialColumnShape();
                column.columnWidth = columnWidth;
                column.innerRadius = innerRadius;
                column.outerRadius = outerRadius;
                column.startAngle = startAngle;
                column.endAngle = endAngle;
                column.isBeveled = true;
                column.axisInnerRadius = axisInnerRadius;
                column.axisOuterRadius = radius;
                column.stroke = undefined;
                column.strokeWidth = 0;
                return column;
            });
            seriesGroup.append(seriesColumns);
            seriesGroup.translationX = center;
            seriesGroup.translationY = center;
            return seriesGroup;
        });
        this.root.append(this.series);
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.series.forEach((group, i) => {
            for (const sector of group.children()) {
                sector.fill = fills[i % fills.length];
                sector.stroke = strokes[i % strokes.length];
            }
        });
    }
}
exports.MiniRadialColumnClass = MiniRadialColumnClass;
exports.MiniRadialColumn = {
    chartType: 'radialColumn',
    miniChart: MiniRadialColumnClass,
};


/***/ }),

/***/ 3268:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniBubble = exports.MiniBubbleClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniBubbleClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'bubbleTooltip');
        const { size, padding, agChartsExports: { _Scene }, } = this;
        // [x, y, radius] triples
        const data = [
            [
                [0.1, 0.3, 5],
                [0.5, 0.4, 7],
                [0.2, 0.8, 7],
            ],
            [
                [0.8, 0.7, 5],
                [0.7, 0.3, 9],
            ],
        ];
        const xScale = new _Scene.LinearScale();
        xScale.domain = [0, 1];
        xScale.range = [padding * 2, size - padding];
        const yScale = new _Scene.LinearScale();
        yScale.domain = [0, 1];
        yScale.range = [size - padding, padding];
        const points = [];
        data.forEach((series) => {
            series.forEach(([x, y, radius]) => {
                const arc = new _Scene.Arc();
                arc.strokeWidth = 0;
                arc.centerX = xScale.convert(x);
                arc.centerY = yScale.convert(y);
                arc.radius = radius;
                arc.fillOpacity = 0.7;
                points.push(arc);
            });
        });
        this.points = points;
        this.updateColors(fills, strokes);
        const pointsGroup = new _Scene.Group();
        pointsGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
        pointsGroup.append(this.points);
        this.root.append(pointsGroup);
    }
    updateColors(fills, strokes) {
        this.points.forEach((line, i) => {
            line.stroke = strokes[i % strokes.length];
            line.fill = fills[i % fills.length];
        });
    }
}
exports.MiniBubbleClass = MiniBubbleClass;
exports.MiniBubble = {
    chartType: 'bubble',
    miniChart: MiniBubbleClass,
};


/***/ }),

/***/ 434:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniScatter = exports.MiniScatterClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniScatterClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'scatterTooltip');
        const { size, padding, agChartsExports: { _Scene }, } = this;
        // [x, y] pairs
        const data = [
            [
                [0.3, 3],
                [1.1, 0.9],
                [2, 0.4],
                [3.4, 2.4],
            ],
            [
                [0, 0.3],
                [1, 2],
                [2.4, 1.4],
                [3, 0],
            ],
        ];
        const xScale = new _Scene.LinearScale();
        xScale.domain = [-0.5, 4];
        xScale.range = [padding * 2, size - padding];
        const yScale = new _Scene.LinearScale();
        yScale.domain = [-0.5, 3.5];
        yScale.range = [size - padding, padding];
        const points = [];
        data.forEach((series) => {
            series.forEach(([x, y]) => {
                const arc = new _Scene.Arc();
                arc.strokeWidth = 0;
                arc.centerX = xScale.convert(x);
                arc.centerY = yScale.convert(y);
                arc.radius = 2.5;
                points.push(arc);
            });
        });
        this.points = points;
        this.updateColors(fills, strokes);
        const pointsGroup = new _Scene.Group();
        pointsGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding * 2, size - padding * 2));
        pointsGroup.append(this.points);
        this.root.append(pointsGroup);
    }
    updateColors(fills, strokes) {
        this.points.forEach((line, i) => {
            line.stroke = strokes[i % strokes.length];
            line.fill = fills[i % fills.length];
        });
    }
}
exports.MiniScatterClass = MiniScatterClass;
exports.MiniScatter = {
    chartType: 'scatter',
    miniChart: MiniScatterClass,
};


/***/ }),

/***/ 795:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniHeatmap = exports.MiniHeatmapClass = void 0;
const miniChart_1 = __webpack_require__(2893);
class MiniHeatmapClass extends miniChart_1.MiniChart {
    constructor(container, agChartsExports, fills, strokes, themeTemplate, isCustomTheme) {
        super(container, agChartsExports, 'heatmapTooltip');
        const { size, padding, agChartsExports: { _Scene }, } = this;
        const heatmapSize = 3;
        const data = Array.from({ length: heatmapSize }, (_, __) => Array.from({ length: heatmapSize }, (_, yIndex) => yIndex));
        const domain = data.map((_, index) => index);
        const xScale = new _Scene.CategoryScale();
        xScale.domain = domain;
        xScale.range = [padding, size - padding];
        xScale.paddingInner = 0.01;
        xScale.paddingOuter = 0.1;
        const yScale = new _Scene.CategoryScale();
        yScale.domain = domain;
        yScale.range = [padding, size - padding];
        yScale.paddingInner = 0.01;
        yScale.paddingOuter = 0.1;
        const width = xScale.bandwidth ?? 0;
        const height = yScale.bandwidth ?? 0;
        this.rects = data.reduce((rects, d, index) => {
            rects ?? (rects = []);
            const xRects = d.map((_, yIndex) => {
                const rect = new _Scene.Rect();
                rect.x = xScale.convert(index);
                rect.y = yScale.convert(yIndex);
                rect.width = width;
                rect.height = height;
                rect.strokeWidth = 0;
                rect.crisp = true;
                return rect;
            });
            rects.push(...xRects);
            return rects;
        }, []);
        this.updateColors(fills, strokes, themeTemplate, isCustomTheme);
        const rectGroup = new _Scene.Group();
        rectGroup.setClipRect(new _Scene.BBox(padding, padding, size - padding, size - padding));
        rectGroup.append(this.rects);
        this.root.append(rectGroup);
    }
    updateColors(fills, strokes, themeTemplate, isCustomTheme) {
        const { _Theme, _Util } = this.agChartsExports;
        const defaultColorRange = themeTemplate?.get(_Theme.themeSymbols.DEFAULT_DIVERGING_SERIES_COLOR_RANGE);
        const defaultBackgroundColor = themeTemplate?.get(_Theme.themeSymbols.DEFAULT_BACKGROUND_COLOUR);
        const backgroundFill = (Array.isArray(defaultBackgroundColor) ? defaultBackgroundColor[0] : defaultBackgroundColor) ?? 'white';
        const colorRange = isCustomTheme ? [fills[0], fills[1]] : defaultColorRange;
        const stroke = isCustomTheme ? strokes[0] : backgroundFill;
        const fillFn = _Util.interpolateColor(colorRange[0], colorRange[1]);
        this.rects.forEach((rect, i) => {
            rect.fill = fillFn(i * 0.2);
            rect.stroke = stroke;
        });
    }
}
exports.MiniHeatmapClass = MiniHeatmapClass;
exports.MiniHeatmap = {
    chartType: 'heatmap',
    miniChart: MiniHeatmapClass,
};


/***/ }),

/***/ 3209:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniWaterfall = exports.MiniWaterfallClass = void 0;
const miniChartHelpers_1 = __webpack_require__(9004);
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniWaterfallClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes, themeTemplate, isCustomTheme) {
        super(container, agChartsExports, 'waterfallTooltip');
        this.data = [4, 3, -3, 6, -3];
        this.bars = this.createWaterfall(this.root, this.data, this.size, this.padding, 'vertical').bars;
        this.updateColors(fills, strokes, themeTemplate, isCustomTheme);
    }
    updateColors(fills, strokes, themeTemplate, isCustomTheme) {
        const { data, agChartsExports: { _Theme: { themeSymbols }, }, } = this;
        const positive = {
            fill: isCustomTheme ? fills[0] : themeTemplate?.get(themeSymbols.PALETTE_ALT_UP_FILL),
            stroke: isCustomTheme ? strokes[0] : themeTemplate?.get(themeSymbols.PALETTE_ALT_UP_STROKE),
        };
        const negative = {
            fill: isCustomTheme ? fills[1] : themeTemplate?.get(themeSymbols.PALETTE_ALT_DOWN_FILL),
            stroke: isCustomTheme ? strokes[1] : themeTemplate?.get(themeSymbols.PALETTE_ALT_DOWN_STROKE),
        };
        this.bars.forEach((bar, i) => {
            const isPositive = data[i] >= 0;
            bar.fill = isPositive ? positive.fill : negative.fill;
            bar.stroke = isPositive ? positive.stroke : negative.stroke;
        });
    }
    createWaterfall(root, data, size, padding, direction) {
        const scalePadding = 2 * padding;
        const { processedData, min, max } = (0, miniChartHelpers_1.accumulateData)(data.map((d) => [d]));
        const flatData = processedData.reduce((flat, d) => flat.concat(d), []);
        const { _Scene } = this.agChartsExports;
        const yScale = new _Scene.LinearScale();
        yScale.domain = [Math.min(min, 0), max];
        yScale.range = [size - scalePadding, scalePadding];
        const xScale = new _Scene.CategoryScale();
        xScale.domain = data.map((_, index) => index);
        xScale.range = [padding, size - padding];
        xScale.paddingInner = 0.2;
        xScale.paddingOuter = 0.3;
        const width = xScale.bandwidth;
        const connectorLine = new _Scene.Path();
        connectorLine.stroke = '#575757';
        connectorLine.strokeWidth = 0;
        const pixelAlignmentOffset = (Math.floor(connectorLine.strokeWidth) % 2) / 2;
        const connectorPath = connectorLine.path;
        connectorPath.clear();
        const barAlongX = direction === 'horizontal';
        const bars = flatData.map((datum, i) => {
            const previousDatum = i > 0 ? flatData[i - 1] : 0;
            const rawValue = data[i];
            const isPositive = rawValue > 0;
            const currY = Math.round(yScale.convert(datum));
            const trailY = Math.round(yScale.convert(previousDatum));
            const y = (isPositive ? currY : trailY) - pixelAlignmentOffset;
            const bottomY = (isPositive ? trailY : currY) + pixelAlignmentOffset;
            const height = Math.abs(bottomY - y);
            const x = xScale.convert(i);
            const rect = new _Scene.Rect();
            rect.x = barAlongX ? y : x;
            rect.y = barAlongX ? x : y;
            rect.width = barAlongX ? height : width;
            rect.height = barAlongX ? width : height;
            rect.strokeWidth = 0;
            rect.crisp = true;
            const moveTo = currY + pixelAlignmentOffset;
            const lineTo = trailY + pixelAlignmentOffset;
            if (i > 0) {
                const lineToX = barAlongX ? lineTo : rect.x;
                const lineToY = barAlongX ? rect.y : lineTo;
                connectorPath.lineTo(lineToX, lineToY);
            }
            const moveToX = barAlongX ? moveTo : rect.x;
            const moveToY = barAlongX ? rect.y : moveTo;
            connectorPath.moveTo(moveToX, moveToY);
            return rect;
        });
        root.append([connectorLine, ...bars]);
        return { bars };
    }
}
exports.MiniWaterfallClass = MiniWaterfallClass;
exports.MiniWaterfall = {
    chartType: 'waterfall',
    miniChart: MiniWaterfallClass,
};


/***/ }),

/***/ 1819:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniBoxPlot = exports.MiniBoxPlotClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniBoxPlotClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes, themeTemplateParameters, isCustomTheme) {
        super(container, agChartsExports, 'boxPlotTooltip');
        const { size, padding, agChartsExports: { _Scene }, } = this;
        const data = [11, 11.5, 10.5];
        const maxRatio = 1.2;
        const q3Ratio = 1.1;
        const q1Ratio = 0.9;
        const minRatio = 0.8;
        const yScale = new _Scene.LinearScale();
        yScale.domain = [
            data.reduce((a, b) => Math.min(a, b), Infinity) * minRatio,
            data.reduce((a, b) => Math.max(a, b), 0) * maxRatio,
        ];
        yScale.range = [size - 1.5 * padding, padding];
        const xScale = new _Scene.CategoryScale();
        xScale.domain = data.map((_, index) => index);
        xScale.range = [padding, size - padding];
        xScale.paddingInner = 0.4;
        xScale.paddingOuter = 0.2;
        const bandwidth = Math.round(xScale.bandwidth);
        const halfBandWidth = Math.round(xScale.bandwidth / 2);
        this.boxPlotGroups = data.map((datum, i) => {
            const [minValue, q1Value, q3Value, maxValue] = [
                datum * minRatio,
                datum * q1Ratio,
                datum * q3Ratio,
                datum * maxRatio,
            ];
            const top = Math.round(yScale.convert(q3Value));
            const left = Math.round(xScale.convert(i));
            const right = Math.round(left + bandwidth);
            const bottom = Math.round(yScale.convert(q1Value));
            const min = Math.round(yScale.convert(minValue));
            const mid = Math.round(yScale.convert(datum));
            const max = Math.round(yScale.convert(maxValue));
            const whiskerX = left + halfBandWidth;
            const boxPlotGroup = new _Scene.Group();
            const box = new _Scene.Rect();
            const median = new _Scene.Line();
            const topWhisker = new _Scene.Line();
            const bottomWhisker = new _Scene.Line();
            const topCap = new _Scene.Line();
            const bottomCap = new _Scene.Line();
            box.x = left;
            box.y = top;
            box.width = bandwidth;
            box.height = bottom - top;
            box.strokeWidth = 1;
            box.strokeOpacity = 0.75;
            box.crisp = true;
            this.setLineProperties(median, left, right, mid, mid);
            this.setLineProperties(topWhisker, whiskerX, whiskerX, max, top);
            this.setLineProperties(bottomWhisker, whiskerX, whiskerX, min, bottom);
            this.setLineProperties(topCap, left, right, max, max);
            this.setLineProperties(bottomCap, left, right, min, min);
            boxPlotGroup.append([box, median, topWhisker, bottomWhisker, topCap, bottomCap]);
            return boxPlotGroup;
        });
        this.updateColors(fills, strokes, themeTemplateParameters, isCustomTheme);
        this.root.append(this.boxPlotGroups);
    }
    updateColors(fills, strokes, themeTemplateParameters, isCustomTheme) {
        const { agChartsExports: { _Util, _Theme }, } = this;
        const themeBackgroundColor = themeTemplateParameters?.get(_Theme.themeSymbols.DEFAULT_BACKGROUND_COLOUR);
        const backgroundFill = (Array.isArray(themeBackgroundColor) ? themeBackgroundColor[0] : themeBackgroundColor) ?? 'white';
        this.boxPlotGroups.forEach((group, i) => {
            for (const node of group.children()) {
                const fill = fills[i % fills.length];
                node.fill = isCustomTheme ? fill : _Util.interpolateColor(fill, backgroundFill)(0.7);
                node.stroke = strokes[i % strokes.length];
            }
        });
    }
    setLineProperties(line, x1, x2, y1, y2) {
        line.x1 = x1;
        line.x2 = x2;
        line.y1 = y1;
        line.y2 = y2;
        line.strokeOpacity = 0.75;
    }
}
exports.MiniBoxPlotClass = MiniBoxPlotClass;
exports.MiniBoxPlot = {
    chartType: 'boxPlot',
    miniChart: MiniBoxPlotClass,
};


/***/ }),

/***/ 7049:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniRangeArea = exports.MiniRangeAreaClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniRangeAreaClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'rangeAreaTooltip');
        // Create a set of repeating zigzag-shaped data series to use as the chart data
        const period = 4;
        const dataSeriesMidpoints = [
            zigzag({ offset: 0.375 * period, length: period, pattern: { low: 3, high: 5, period } }),
            zigzag({ offset: 0.375 * period, length: period, pattern: { low: 2.25, high: 4.25, period } }),
            zigzag({ offset: 0.75 * period, length: period, pattern: { low: 2.5, high: 4.5, period } }),
        ];
        const dataSeriesWidth = 1.75;
        const data = dataSeriesMidpoints.map((series) => series.map(([x, y]) => ({
            x,
            low: y - 0.5 * dataSeriesWidth,
            high: y + 0.5 * dataSeriesWidth,
        })));
        const { lines, areas } = this.createRangeArea(this.root, data, this.size, this.padding);
        this.lines = lines;
        this.areas = areas;
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        // Swap the secondary and tertiary colors to match the designs
        fills = swapArrayItems(fills, 1, 2);
        strokes = swapArrayItems(strokes, 1, 2);
        this.lines.forEach(([highLine, lowLine], i) => {
            highLine.fill = undefined;
            highLine.stroke = strokes[i];
            lowLine.fill = undefined;
            lowLine.stroke = strokes[i];
        });
        this.areas.forEach((area, i) => {
            area.fill = fills[i];
        });
    }
    createRangeArea(root, data, size, padding) {
        const xMin = data.reduce((acc, series) => series.reduce((acc, { x }) => Math.min(acc, x), acc), Infinity);
        const xMax = data.reduce((acc, series) => series.reduce((acc, { x }) => Math.max(acc, x), acc), -Infinity);
        const yMin = data.reduce((acc, series) => series.reduce((acc, { low }) => Math.min(acc, low), acc), Infinity);
        const yMax = data.reduce((acc, series) => series.reduce((acc, { high }) => Math.max(acc, high), acc), -Infinity);
        const { _Scene } = this.agChartsExports;
        const xScale = new _Scene.LinearScale();
        xScale.domain = [xMin, xMax];
        xScale.range = [padding, size - padding];
        const scalePadding = 2 * padding;
        const yScale = new _Scene.LinearScale();
        yScale.domain = [yMin, yMax];
        yScale.range = [size - scalePadding, scalePadding];
        const lines = [];
        const areas = [];
        const lowPoints = data.map((series) => {
            const highLine = new _Scene.Path();
            const lowLine = new _Scene.Path();
            const area = new _Scene.Path();
            lines.push([highLine, lowLine]);
            areas.push(area);
            highLine.strokeWidth = 0;
            lowLine.strokeWidth = 0;
            area.strokeWidth = 0;
            area.fillOpacity = 0.8;
            highLine.path.clear();
            lowLine.path.clear();
            area.path.clear();
            return series.map((datum, datumIndex) => {
                const { x, low, high } = datum;
                const scaledX = xScale.convert(x);
                const yLow = yScale.convert(low);
                const yHigh = yScale.convert(high);
                const command = datumIndex > 0 ? 'lineTo' : 'moveTo';
                highLine.path[command](scaledX, yHigh);
                lowLine.path[command](scaledX, yLow);
                area.path[command](scaledX, yHigh);
                return [scaledX, yLow];
            });
        });
        lowPoints.forEach((seriesLowPoints, seriesIndex) => {
            const n = seriesLowPoints.length - 1;
            const area = areas[seriesIndex];
            for (let datumIndex = n; datumIndex >= 0; datumIndex--) {
                const [x, y] = seriesLowPoints[datumIndex];
                area.path['lineTo'](x, y);
            }
        });
        root.append(areas.concat(...lines));
        return { lines, areas };
    }
}
exports.MiniRangeAreaClass = MiniRangeAreaClass;
function zigzag(options) {
    const { offset, length, pattern } = options;
    // Generate [x, y] points for all inflection points of the zigzag pattern that fall within the range
    const points = getZigzagInflectionPoints(offset, length, pattern);
    // Ensure the first and last points are clamped to the start and end of the range
    const xMin = 0;
    const xMax = length;
    if (points.length === 0 || points[0][0] !== xMin)
        points.unshift(getZigzagPoint(xMin, offset, pattern));
    if (points[points.length - 1][0] !== xMax)
        points.push(getZigzagPoint(xMax, offset, pattern));
    return points;
    function getZigzagInflectionPoints(offset, length, pattern) {
        const { period } = pattern;
        const scaledOffset = offset / period;
        const patternInflectionPoints = [0, 0.5];
        const inflectionPoints = patternInflectionPoints
            .map((x) => x - scaledOffset)
            // Clamp offset points to the unit range [0, 1)
            .map(getRemainderAbs)
            .sort((a, b) => a - b);
        const repeatedPoints = Array.from({ length: Math.floor(inflectionPoints.length * (period / length)) }, (_, i) => inflectionPoints[i % inflectionPoints.length] + Math.floor(i / inflectionPoints.length));
        return repeatedPoints.map((x) => x * period).map((x) => getZigzagPoint(x, offset, pattern));
    }
    function getZigzagPoint(x, offset, pattern) {
        return [x, getZigzagValue(offset + x, pattern)];
    }
    function getZigzagValue(x, pattern) {
        const { low, high, period } = pattern;
        const scaledX = getRemainderAbs(x / period);
        const y = scaledX > 0.5 ? 1 - 2 * (scaledX - 0.5) : 2 * scaledX;
        return low + (high - low) * y;
    }
}
function getRemainderAbs(value) {
    const remainder = value % 1;
    return remainder < 0 ? remainder + 1 : remainder;
}
function swapArrayItems(items, leftIndex, rightIndex) {
    const results = [...items];
    const temp = results[leftIndex];
    results[leftIndex] = results[rightIndex];
    results[rightIndex] = temp;
    return results;
}
exports.MiniRangeArea = {
    chartType: 'rangeArea',
    miniChart: MiniRangeAreaClass,
};


/***/ }),

/***/ 4823:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniRangeBar = exports.MiniRangeBarClass = void 0;
const miniChartWithAxes_1 = __webpack_require__(1408);
class MiniRangeBarClass extends miniChartWithAxes_1.MiniChartWithAxes {
    constructor(container, agChartsExports, fills, strokes) {
        super(container, agChartsExports, 'rangeBarTooltip');
        const data = [3, 3.5, 3];
        this.bars = this.createRangeBar(this.root, data, this.size, this.padding, 'vertical');
        this.updateColors(fills, strokes);
    }
    updateColors(fills, strokes) {
        this.bars.forEach((bar, i) => {
            bar.fill = fills[i];
            bar.stroke = strokes[i];
        });
    }
    createRangeBar(root, data, size, padding, direction) {
        const barAlongX = direction === 'horizontal';
        const scalePadding = 2 * padding;
        const { _Scene } = this.agChartsExports;
        const xScale = new _Scene.CategoryScale();
        xScale.domain = data.map((_, index) => index);
        xScale.range = [padding, size - padding];
        xScale.paddingInner = 0.3;
        xScale.paddingOuter = 0.3;
        const lowRatio = 0.7;
        const highRatio = 1.3;
        const yScale = new _Scene.LinearScale();
        yScale.domain = [
            data.reduce((a, b) => Math.min(a, b), Infinity) * lowRatio,
            data.reduce((a, b) => Math.max(a, b), 0) * highRatio,
        ];
        yScale.range = [scalePadding, size - scalePadding];
        const width = xScale.bandwidth;
        const bars = data.map((datum, i) => {
            const [low, high] = [datum * lowRatio, datum * highRatio];
            const x = xScale.convert(i);
            const y = yScale.convert(low);
            const height = yScale.convert(high) - y;
            const rect = new _Scene.Rect();
            rect.x = barAlongX ? y : x;
            rect.y = barAlongX ? x : y;
            rect.width = barAlongX ? height : width;
            rect.height = barAlongX ? width : height;
            rect.strokeWidth = 0;
            rect.crisp = true;
            return rect;
        });
        root.append(bars);
        return bars;
    }
}
exports.MiniRangeBarClass = MiniRangeBarClass;
exports.MiniRangeBar = {
    chartType: 'rangeBar',
    miniChart: MiniRangeBarClass,
};


/***/ }),

/***/ 6692:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MiniChartsContainer = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGroupComponent_1 = __webpack_require__(1421);
const seriesTypeMapper_1 = __webpack_require__(4237);
const miniConeFunnel_1 = __webpack_require__(8049);
const miniFunnel_1 = __webpack_require__(8250);
const miniPyramid_1 = __webpack_require__(1244);
const index_1 = __webpack_require__(6544);
const miniChartMapping = {
    columnGroup: {
        column: { range: true, pivot: true, enterprise: false, icon: index_1.MiniColumn },
        stackedColumn: { range: true, pivot: true, enterprise: false, icon: index_1.MiniStackedColumn },
        normalizedColumn: { range: true, pivot: true, enterprise: false, icon: index_1.MiniNormalizedColumn },
    },
    barGroup: {
        bar: { range: true, pivot: true, enterprise: false, icon: index_1.MiniBar },
        stackedBar: { range: true, pivot: true, enterprise: false, icon: index_1.MiniStackedBar },
        normalizedBar: { range: true, pivot: true, enterprise: false, icon: index_1.MiniNormalizedBar },
    },
    pieGroup: {
        pie: { range: true, pivot: true, enterprise: false, icon: index_1.MiniPie },
        donut: { range: true, pivot: true, enterprise: false, icon: index_1.MiniDonut },
        doughnut: { range: true, pivot: true, enterprise: false, icon: index_1.MiniDonut },
    },
    lineGroup: {
        line: { range: true, pivot: true, enterprise: false, icon: index_1.MiniLine },
        stackedLine: { range: true, pivot: true, enterprise: false, icon: index_1.MiniStackedLine },
        normalizedLine: { range: true, pivot: true, enterprise: false, icon: index_1.MiniNormalizedLine },
    },
    scatterGroup: {
        scatter: { range: true, pivot: true, enterprise: false, icon: index_1.MiniScatter },
        bubble: { range: true, pivot: true, enterprise: false, icon: index_1.MiniBubble },
    },
    areaGroup: {
        area: { range: true, pivot: true, enterprise: false, icon: index_1.MiniArea },
        stackedArea: { range: true, pivot: true, enterprise: false, icon: index_1.MiniStackedArea },
        normalizedArea: { range: true, pivot: true, enterprise: false, icon: index_1.MiniNormalizedArea },
    },
    polarGroup: {
        radarLine: { range: true, pivot: false, enterprise: true, icon: index_1.MiniRadarLine },
        radarArea: { range: true, pivot: false, enterprise: true, icon: index_1.MiniRadarArea },
        nightingale: { range: true, pivot: false, enterprise: true, icon: index_1.MiniNightingale },
        radialColumn: { range: true, pivot: false, enterprise: true, icon: index_1.MiniRadialColumn },
        radialBar: { range: true, pivot: false, enterprise: true, icon: index_1.MiniRadialBar },
    },
    statisticalGroup: {
        boxPlot: { range: true, pivot: false, enterprise: true, icon: index_1.MiniBoxPlot },
        histogram: { range: true, pivot: false, enterprise: false, icon: index_1.MiniHistogram },
        rangeBar: { range: true, pivot: false, enterprise: true, icon: index_1.MiniRangeBar },
        rangeArea: { range: true, pivot: false, enterprise: true, icon: index_1.MiniRangeArea },
    },
    hierarchicalGroup: {
        treemap: { range: true, pivot: true, enterprise: true, icon: index_1.MiniTreemap },
        sunburst: { range: true, pivot: true, enterprise: true, icon: index_1.MiniSunburst },
    },
    specializedGroup: {
        heatmap: { range: true, pivot: false, enterprise: true, icon: index_1.MiniHeatmap },
        waterfall: { range: true, pivot: false, enterprise: true, icon: index_1.MiniWaterfall },
    },
    combinationGroup: {
        columnLineCombo: { range: true, pivot: true, enterprise: false, icon: index_1.MiniColumnLineCombo },
        areaColumnCombo: { range: true, pivot: true, enterprise: false, icon: index_1.MiniAreaColumnCombo },
        customCombo: { range: true, pivot: true, enterprise: false, icon: index_1.MiniCustomCombo },
    },
    funnelGroup: {
        funnel: { range: true, pivot: false, enterprise: true, icon: miniFunnel_1.MiniFunnel },
        coneFunnel: { range: true, pivot: false, enterprise: true, icon: miniConeFunnel_1.MiniConeFunnel },
        pyramid: { range: true, pivot: false, enterprise: true, icon: miniPyramid_1.MiniPyramid },
    },
};
const DEFAULT_CHART_GROUPS = {
    columnGroup: ['column', 'stackedColumn', 'normalizedColumn'],
    barGroup: ['bar', 'stackedBar', 'normalizedBar'],
    pieGroup: ['pie', 'donut'],
    lineGroup: ['line', 'stackedLine', 'normalizedLine'],
    areaGroup: ['area', 'stackedArea', 'normalizedArea'],
    scatterGroup: ['scatter', 'bubble'],
    polarGroup: ['radarLine', 'radarArea', 'nightingale', 'radialColumn', 'radialBar'],
    statisticalGroup: ['boxPlot', 'histogram', 'rangeBar', 'rangeArea'],
    hierarchicalGroup: ['treemap', 'sunburst'],
    specializedGroup: ['heatmap', 'waterfall'],
    funnelGroup: ['funnel', 'coneFunnel', 'pyramid'],
    combinationGroup: ['columnLineCombo', 'areaColumnCombo', 'customCombo'],
};
class MiniChartsContainer extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(chartController, fills, strokes, themeTemplateParameters, isCustomTheme, chartGroups = DEFAULT_CHART_GROUPS) {
        super(/* html */ `<div class="ag-chart-settings-mini-wrapper"></div>`);
        this.wrappers = new Map();
        this.chartController = chartController;
        this.fills = fills;
        this.strokes = strokes;
        this.themeTemplateParameters = themeTemplateParameters;
        this.isCustomTheme = isCustomTheme;
        this.chartGroups = { ...chartGroups };
    }
    postConstruct() {
        // hide MiniCustomCombo if no custom combo exists
        if (!this.chartController.customComboExists() && this.chartGroups.combinationGroup) {
            this.chartGroups.combinationGroup = this.chartGroups.combinationGroup.filter((chartType) => chartType !== 'customCombo');
        }
        const eGui = this.getGui();
        const isEnterprise = this.chartController.isEnterprise();
        const isPivotChart = this.chartController.isPivotChart();
        const isRangeChart = !isPivotChart;
        // Determine the set of chart types that are specified by the chartGroupsDef config, filtering out any entries
        // that are invalid for the current chart configuration (pivot/range) and license type
        const displayedMenuGroups = Object.keys(this.chartGroups)
            .map((group) => {
            const menuGroup = group in miniChartMapping ? miniChartMapping[group] : undefined;
            if (!menuGroup) {
                // User has specified an invalid chart group in the chartGroupsDef config
                (0, ag_grid_community_1._warn)(148, { group });
                return null;
            }
            // Determine the valid chart types within this group, based on the chartGroupsDef config
            const chartGroupValues = this.chartGroups[group] ?? [];
            const menuItems = chartGroupValues
                .map((chartType) => {
                const menuItem = chartType in menuGroup
                    ? menuGroup[chartType]
                    : undefined;
                if (!menuItem) {
                    // User has specified an invalid chart type in the chartGroupsDef config
                    (0, ag_grid_community_1._warn)(149, { group, chartType });
                    return null;
                }
                if (!isEnterprise && menuItem.enterprise) {
                    return null; // skip enterprise charts if community
                }
                // Only show the chart if it is valid for the current chart configuration (pivot/range)
                if (isRangeChart && menuItem.range)
                    return menuItem;
                if (isPivotChart && menuItem.pivot)
                    return menuItem;
                return null;
            })
                .filter((menuItem) => menuItem != null);
            if (menuItems.length === 0)
                return null; // don't render empty chart groups
            return {
                label: this.chartTranslation.translate(group),
                items: menuItems,
            };
        })
            .filter((menuGroup) => menuGroup != null);
        // Render the filtered menu items
        for (const { label, items } of displayedMenuGroups) {
            const groupComponent = this.createBean(new agGroupComponent_1.AgGroupComponent({
                title: label,
                suppressEnabledCheckbox: true,
                enabled: true,
                suppressOpenCloseIcons: true,
                cssIdentifier: 'charts-settings',
                direction: 'horizontal',
                suppressKeyboardNavigation: true,
            }));
            for (const menuItem of items) {
                const { miniChart: MiniClass, chartType } = menuItem.icon;
                const miniWrapper = document.createElement('div');
                miniWrapper.classList.add('ag-chart-mini-thumbnail');
                miniWrapper.setAttribute('tabindex', '0');
                miniWrapper.setAttribute('role', 'button');
                const miniClassChartType = chartType;
                const listener = () => {
                    this.chartController.setChartType(miniClassChartType);
                    this.updateSelectedMiniChart();
                };
                this.addManagedListeners(miniWrapper, {
                    click: listener,
                    keydown: (event) => {
                        if (event.key == ag_grid_community_1.KeyCode.ENTER || event.key === ag_grid_community_1.KeyCode.SPACE) {
                            event.preventDefault();
                            listener();
                        }
                    },
                });
                this.wrappers.set(miniClassChartType, miniWrapper);
                this.createBean(new MiniClass(miniWrapper, this.beans.agChartsExports, this.fills, this.strokes, this.themeTemplateParameters, this.isCustomTheme));
                groupComponent.addItem(miniWrapper);
            }
            eGui.appendChild(groupComponent.getGui());
        }
        this.updateSelectedMiniChart();
    }
    updateSelectedMiniChart() {
        const selectedChartType = this.chartController.getChartType();
        this.wrappers.forEach((miniChart, miniChartType) => {
            const selected = miniChartType === selectedChartType;
            miniChart.classList.toggle('ag-selected', selected);
            const chartName = this.chartTranslation.translate((0, seriesTypeMapper_1.getFullChartNameTranslationKey)(miniChartType));
            const ariaLabel = selected
                ? `${chartName}. ${this.chartTranslation.translate('ariaChartSelected')}`
                : chartName;
            (0, ag_grid_community_1._setAriaLabel)(miniChart, ariaLabel);
        });
    }
    destroy() {
        this.wrappers.clear();
        super.destroy();
    }
}
exports.MiniChartsContainer = MiniChartsContainer;


/***/ }),

/***/ 5518:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TabbedChartMenu = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const tabbedLayout_1 = __webpack_require__(5875);
const chartDataPanel_1 = __webpack_require__(1504);
const formatPanel_1 = __webpack_require__(3160);
const chartSettingsPanel_1 = __webpack_require__(6604);
const TAB_DATA = 'data';
const TAB_FORMAT = 'format';
class TabbedChartMenu extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(panels, chartMenuContext) {
        super();
        this.panels = panels;
        this.chartMenuContext = chartMenuContext;
        this.tabs = [];
    }
    postConstruct() {
        this.panels.forEach((panel) => {
            const panelType = panel.replace('chart', '').toLowerCase();
            const panelComp = this.createPanel(panelType);
            const tabItem = this.createTab(panel, panelType, panelComp);
            this.tabs.push(tabItem);
            this.addDestroyFunc(() => this.destroyBean(panelComp));
        });
        this.tabbedLayout = new tabbedLayout_1.TabbedLayout({
            items: this.tabs,
            cssClass: 'ag-chart-tabbed-menu',
            keepScrollPosition: true,
            suppressFocusBodyOnOpen: true,
            suppressTrapFocus: true,
            enableCloseButton: true,
            closeButtonAriaLabel: this.chartTranslation.translate('ariaChartMenuClose'),
            onCloseClicked: () => {
                this.eventSource?.focus({ preventScroll: true });
                this.dispatchLocalEvent({ type: 'closed' });
            },
        });
        this.createBean(this.tabbedLayout);
    }
    createTab(name, title, panelComp) {
        const eWrapperDiv = document.createElement('div');
        eWrapperDiv.classList.add('ag-chart-tab', `ag-chart-${title}`);
        this.createBean(panelComp);
        eWrapperDiv.appendChild(panelComp.getGui());
        const titleEl = document.createElement('div');
        const translatedTitle = this.chartTranslation.translate(title);
        // eslint-disable-next-line no-restricted-properties -- Could swap to textContent, but could be a breaking change
        titleEl.innerText = translatedTitle;
        return {
            title: titleEl,
            titleLabel: translatedTitle,
            bodyPromise: ag_grid_community_1.AgPromise.resolve(eWrapperDiv),
            getScrollableContainer: () => {
                const scrollableContainer = eWrapperDiv.querySelector('.ag-scrollable-container');
                return (scrollableContainer || eWrapperDiv);
            },
            name,
        };
    }
    showTab(tab) {
        const tabItem = this.tabs[tab];
        this.tabbedLayout.showItem(tabItem);
    }
    getGui() {
        return this.tabbedLayout && this.tabbedLayout.getGui();
    }
    showMenu(eventSource, suppressFocus) {
        this.eventSource = eventSource;
        if (!suppressFocus) {
            this.tabbedLayout?.focusHeader(true);
        }
    }
    destroy() {
        if (this.parentComponent && this.parentComponent.isAlive()) {
            this.destroyBean(this.parentComponent);
        }
        super.destroy();
    }
    createPanel(panelType) {
        switch (panelType) {
            case TAB_DATA:
                return new chartDataPanel_1.ChartDataPanel(this.chartMenuContext);
            case TAB_FORMAT:
                return new formatPanel_1.FormatPanel(this.chartMenuContext);
            default:
                return new chartSettingsPanel_1.ChartSettingsPanel(this.chartMenuContext.chartController);
        }
    }
}
exports.TabbedChartMenu = TabbedChartMenu;


/***/ }),

/***/ 8592:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartDataModel = exports.DEFAULT_CHART_CATEGORY = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const chartDatasource_1 = __webpack_require__(9208);
const chartColumnService_1 = __webpack_require__(8919);
const seriesTypeMapper_1 = __webpack_require__(4237);
const comboChartModel_1 = __webpack_require__(2474);
exports.DEFAULT_CHART_CATEGORY = 'AG-GRID-DEFAULT-CATEGORY';
class ChartDataModel extends ag_grid_community_1.BeanStub {
    wireBeans(beans) {
        this.rangeSvc = beans.rangeSvc;
        this.chartTranslation = beans.chartTranslation;
    }
    constructor(params) {
        super();
        this.unlinked = false;
        this.chartData = [];
        this.valueColState = [];
        this.dimensionColState = [];
        this.colNames = {};
        this.crossFiltering = false;
        this.grouping = false;
        this.params = params;
        this.chartId = params.chartId;
        this.setParams(params);
    }
    setParams(params) {
        const { chartType, pivotChart, chartThemeName, switchCategorySeries, aggFunc, cellRange, suppressChartRanges, unlinkChart, crossFiltering, seriesGroupType, } = params;
        this.chartType = chartType;
        this.pivotChart = pivotChart ?? false;
        this.chartThemeName = chartThemeName;
        this.switchCategorySeries = !!switchCategorySeries;
        this.aggFunc = aggFunc;
        this.referenceCellRange = cellRange;
        this.suppliedCellRange = cellRange;
        this.suppressChartRanges = suppressChartRanges ?? false;
        this.unlinked = !!unlinkChart;
        this.crossFiltering = !!crossFiltering;
        this.seriesGroupType = seriesGroupType;
    }
    postConstruct() {
        this.datasource = this.createManagedBean(new chartDatasource_1.ChartDatasource());
        this.chartColSvc = this.createManagedBean(new chartColumnService_1.ChartColumnService());
        this.comboChartModel = this.createManagedBean(new comboChartModel_1.ComboChartModel(this));
        this.updateCellRanges({ setColsFromRange: true });
        this.updateData();
    }
    updateModel(params) {
        const { cellRange, seriesChartTypes } = params;
        if (cellRange !== this.suppliedCellRange) {
            this.dimensionCellRange = undefined;
            this.valueCellRange = undefined;
        }
        this.setParams(params);
        this.updateSelectedDimensions(cellRange?.columns);
        this.updateCellRanges({ setColsFromRange: true });
        const shouldUpdateComboModel = this.isComboChart() || seriesChartTypes;
        if (shouldUpdateComboModel) {
            this.comboChartModel.update(seriesChartTypes);
        }
        if (!this.unlinked) {
            this.updateData();
        }
    }
    updateCellRanges(params) {
        const { updatedColState, resetOrder, maintainColState, setColsFromRange } = params ?? {};
        if (this.valueCellRange) {
            this.referenceCellRange = this.valueCellRange;
        }
        const { dimensionCols, valueCols } = this.chartColSvc.getChartColumns();
        const allColsFromRanges = this.getAllColumnsFromRanges();
        if (updatedColState) {
            this.updateColumnState(updatedColState, resetOrder);
        }
        this.setDimensionCellRange(dimensionCols, allColsFromRanges, updatedColState);
        this.setValueCellRange(valueCols, allColsFromRanges, setColsFromRange);
        if (!updatedColState && !maintainColState) {
            this.resetColumnState();
            // dimension / category cell range could be out of sync after resetting column state when row grouping
            this.syncDimensionCellRange();
        }
        this.comboChartModel.updateSeriesChartTypes();
    }
    updateData() {
        const { startRow, endRow } = this.getRowIndexes();
        if (this.pivotChart) {
            this.resetColumnState();
        }
        this.grouping = this.isGrouping();
        const params = {
            aggFunc: this.aggFunc,
            dimensionCols: this.getSelectedDimensions(),
            grouping: this.grouping,
            pivoting: this.isPivotActive(),
            crossFiltering: this.crossFiltering,
            valueCols: this.getSelectedValueCols(),
            startRow,
            endRow,
            isScatter: ['scatter', 'bubble'].includes(this.chartType),
        };
        const { chartData, colNames, groupChartData } = this.datasource.getData(params);
        this.chartData = chartData;
        this.groupChartData = groupChartData;
        this.colNames = colNames;
        this.categoryAxisType = undefined;
    }
    isGrouping() {
        const usingTreeData = this.gos.get('treeData');
        const groupedCols = usingTreeData ? null : this.chartColSvc.getRowGroupColumns();
        const isGroupActive = usingTreeData || (groupedCols && groupedCols.length > 0);
        // charts only group when the selected category is a group column
        const colIds = this.getSelectedDimensions().map(({ colId }) => colId);
        const displayedGroupCols = this.chartColSvc.getGroupDisplayColumns();
        const groupDimensionSelected = displayedGroupCols
            .map((col) => col.getColId())
            .some((id) => colIds.includes(id));
        return !!isGroupActive && groupDimensionSelected;
    }
    getSelectedValueCols() {
        return this.valueColState.filter((cs) => cs.selected).map((cs) => cs.column);
    }
    getSelectedDimensions() {
        return this.dimensionColState.filter((cs) => cs.selected);
    }
    getColDisplayName(col, includePath) {
        return this.chartColSvc.getColDisplayName(col, includePath);
    }
    isPivotMode() {
        return this.chartColSvc.isPivotMode();
    }
    getChartDataType(colId) {
        const column = this.chartColSvc.getColumn(colId);
        return column ? column.getColDef().chartDataType : undefined;
    }
    isPivotActive() {
        return this.chartColSvc.isPivotActive();
    }
    createCellRange(type, ...columns) {
        return {
            id: this.chartId,
            startRow: this.referenceCellRange.startRow,
            endRow: this.referenceCellRange.endRow,
            columns,
            startColumn: type === ag_grid_community_1.CellRangeType.DIMENSION || this.referenceCellRange.startColumn == null
                ? columns[0]
                : this.referenceCellRange.startColumn,
            type,
        };
    }
    getAllColumnsFromRanges() {
        if (this.pivotChart) {
            return new Set(this.chartColSvc.getAllDisplayedColumns());
        }
        const columns = this.dimensionCellRange || this.valueCellRange ? [] : this.referenceCellRange.columns;
        if (this.dimensionCellRange) {
            columns.push(...this.dimensionCellRange.columns);
        }
        if (this.valueCellRange) {
            columns.push(...this.valueCellRange.columns);
        }
        return new Set(columns);
    }
    getRowIndexes() {
        let startRow = 0, endRow = 0;
        const { rangeSvc, valueCellRange, dimensionCellRange } = this;
        // Not all chart types require a value series (e.g. hierarchical charts),
        // so fall back to using the dimension cell range for inferring row indices
        const cellRange = valueCellRange || dimensionCellRange;
        if (rangeSvc && cellRange) {
            startRow = rangeSvc.getRangeStartRow(cellRange).rowIndex;
            // when the last row the cell range is a pinned 'bottom' row, the `endRow` index is set to -1 which results
            // in the ChartDatasource processing all non pinned rows from the `startRow` index.
            const endRowPosition = rangeSvc.getRangeEndRow(cellRange);
            endRow = endRowPosition.rowPinned === 'bottom' ? -1 : endRowPosition.rowIndex;
        }
        return { startRow, endRow };
    }
    resetColumnState() {
        const { dimensionCols, valueCols } = this.chartColSvc.getChartColumns();
        const allCols = this.getAllColumnsFromRanges();
        const isInitialising = this.valueColState.length < 1;
        this.dimensionColState = [];
        this.valueColState = [];
        const supportsMultipleDimensions = (0, seriesTypeMapper_1.isHierarchical)((0, seriesTypeMapper_1.getSeriesType)(this.chartType));
        let hasSelectedDimension = false;
        let order = 1;
        const aggFuncDimension = this.suppliedCellRange.columns[0]; //TODO
        dimensionCols.forEach((column) => {
            const isAutoGroupCol = column.getColId() === 'ag-Grid-AutoColumn';
            let selected = false;
            if (this.crossFiltering && this.aggFunc) {
                if (aggFuncDimension.getColId() === column.getColId()) {
                    selected = true;
                }
            }
            else {
                selected = isAutoGroupCol
                    ? true
                    : (!hasSelectedDimension || supportsMultipleDimensions) && allCols.has(column);
            }
            this.dimensionColState.push({
                column,
                colId: column.getColId(),
                displayName: this.getColDisplayName(column),
                selected,
                order: order++,
            });
            if (selected) {
                hasSelectedDimension = true;
            }
        });
        const defaultCategory = {
            colId: exports.DEFAULT_CHART_CATEGORY,
            displayName: this.chartTranslation.translate('defaultCategory'),
            selected: !hasSelectedDimension,
            order: 0,
        };
        this.dimensionColState.unshift(defaultCategory);
        const valueColumnsFromReferenceRange = this.referenceCellRange.columns.filter((c) => valueCols.has(c));
        valueCols.forEach((column) => {
            // first time the value cell range is set, preserve the column order from the supplied range
            if (isInitialising && this.referenceCellRange.columns.includes(column)) {
                column = valueColumnsFromReferenceRange.shift();
            }
            this.valueColState.push({
                column,
                colId: column.getColId(),
                displayName: this.getColDisplayName(column),
                selected: allCols.has(column),
                order: order++,
            });
        });
    }
    updateColumnState(updatedCol, resetOrder) {
        const idsMatch = (cs) => cs.colId === updatedCol.colId;
        const { dimensionColState, valueColState } = this;
        // Determine whether the specified column is a dimension or value column
        const matchedDimensionColState = dimensionColState.find(idsMatch);
        const matchedValueColState = valueColState.find(idsMatch);
        if (matchedDimensionColState) {
            // For non-hierarchical chart types, only one dimension can be selected
            const supportsMultipleDimensions = (0, seriesTypeMapper_1.isHierarchical)((0, seriesTypeMapper_1.getSeriesType)(this.chartType));
            if (!supportsMultipleDimensions) {
                // Determine which column should end up selected, if any
                const selectedColumnState = updatedCol.selected
                    ? matchedDimensionColState
                    : dimensionColState
                        .filter((cs) => cs !== matchedDimensionColState)
                        .find(({ selected }) => selected);
                // Update the selection state of all dimension columns
                dimensionColState.forEach((cs) => (cs.selected = cs === selectedColumnState));
            }
            else {
                // Update the selection state of the specified dimension column
                matchedDimensionColState.selected = updatedCol.selected;
            }
        }
        else if (matchedValueColState) {
            // Update the selection state of the specified value column
            matchedValueColState.selected = updatedCol.selected;
        }
        const allColumns = [...dimensionColState, ...valueColState];
        const orderedColIds = [];
        if (!resetOrder) {
            // calculate new order
            allColumns.forEach((col, i) => {
                if (i === updatedCol.order) {
                    orderedColIds.push(updatedCol.colId);
                }
                if (col.colId !== updatedCol.colId) {
                    orderedColIds.push(col.colId);
                }
            });
            // update col state with new order
            allColumns.forEach((col) => {
                const order = orderedColIds.indexOf(col.colId);
                col.order = order >= 0 ? orderedColIds.indexOf(col.colId) : allColumns.length - 1;
            });
        }
        this.reorderColState();
    }
    reorderColState() {
        const ascColStateOrder = (a, b) => a.order - b.order;
        this.dimensionColState.sort(ascColStateOrder);
        this.valueColState.sort(ascColStateOrder);
    }
    setDimensionCellRange(dimensionCols, colsInRange, updatedColState) {
        this.dimensionCellRange = undefined;
        const supportsMultipleDimensions = (0, seriesTypeMapper_1.isHierarchical)((0, seriesTypeMapper_1.getSeriesType)(this.chartType));
        if (!updatedColState && !this.dimensionColState.length) {
            const selectedCols = new Array();
            // use first dimension column in range by default, or all dimension columns for hierarchical charts
            dimensionCols.forEach((col) => {
                if ((selectedCols.length > 0 && !supportsMultipleDimensions) || !colsInRange.has(col)) {
                    return;
                }
                selectedCols.push(col);
            });
            if (selectedCols.length > 0) {
                this.dimensionCellRange = this.createCellRange(ag_grid_community_1.CellRangeType.DIMENSION, ...selectedCols);
            }
            return;
        }
        let selectedDimensionColStates = updatedColState ? [updatedColState] : [];
        if (this.crossFiltering && this.aggFunc) {
            const aggFuncDimension = this.suppliedCellRange.columns[0]; //TODO
            selectedDimensionColStates = this.dimensionColState.filter((cs) => cs.colId === aggFuncDimension.getColId());
        }
        else if (supportsMultipleDimensions ||
            selectedDimensionColStates.length === 0 ||
            selectedDimensionColStates.some(({ column }) => !column || !dimensionCols.has(column))) {
            selectedDimensionColStates = this.dimensionColState.filter((cs) => cs.selected);
        }
        const isDefaultCategory = selectedDimensionColStates.length === 1
            ? selectedDimensionColStates[0].colId === exports.DEFAULT_CHART_CATEGORY
            : false;
        const selectedColumns = selectedDimensionColStates
            .map(({ column }) => column)
            .filter((value) => value != null);
        if (selectedColumns.length > 0 && !isDefaultCategory) {
            this.dimensionCellRange = this.createCellRange(ag_grid_community_1.CellRangeType.DIMENSION, ...selectedColumns);
        }
    }
    setValueCellRange(valueCols, colsInRange, setColsFromRange) {
        this.valueCellRange = undefined;
        const selectedValueCols = [];
        const maxSelection = (0, seriesTypeMapper_1.getMaxNumSeries)(this.chartType);
        let numSelected = 0;
        valueCols.forEach((col) => {
            if (setColsFromRange) {
                if ((maxSelection == null || numSelected < maxSelection) && colsInRange.has(col)) {
                    selectedValueCols.push(col);
                    numSelected++;
                }
            }
            else {
                if (this.valueColState.some((colState) => colState.selected && colState.colId === col.getColId())) {
                    selectedValueCols.push(col);
                }
            }
        });
        if (selectedValueCols.length > 0) {
            let orderedColIds = [];
            if (this.valueColState.length > 0) {
                orderedColIds = this.valueColState.map((c) => c.colId);
            }
            else {
                colsInRange.forEach((c) => orderedColIds.push(c.getColId()));
            }
            selectedValueCols.sort((a, b) => orderedColIds.indexOf(a.getColId()) - orderedColIds.indexOf(b.getColId()));
            this.valueCellRange = this.createCellRange(ag_grid_community_1.CellRangeType.VALUE, ...selectedValueCols);
        }
    }
    resetCellRanges(dimension, value) {
        if (!dimension && !value) {
            return;
        }
        const { dimensionCols, valueCols } = this.chartColSvc.getChartColumns();
        const allColsFromRanges = this.getAllColumnsFromRanges();
        if (dimension) {
            this.setDimensionCellRange(dimensionCols, allColsFromRanges);
        }
        if (value) {
            this.setValueCellRange(valueCols, allColsFromRanges);
        }
    }
    updateSelectedDimensions(columns) {
        const colIdSet = new Set(columns.map((column) => column.getColId()));
        // For non-hierarchical chart types, only one dimension can be selected
        const supportsMultipleDimensions = (0, seriesTypeMapper_1.isHierarchical)((0, seriesTypeMapper_1.getSeriesType)(this.chartType));
        if (!supportsMultipleDimensions) {
            // Determine which column should end up selected, if any
            // if no dimension found in supplied columns use the default category (always index = 0)
            const foundColState = this.dimensionColState.find((colState) => colIdSet.has(colState.colId)) || this.dimensionColState[0];
            const selectedColumnId = foundColState.colId;
            // Update the selection state of all dimension columns
            this.dimensionColState = this.dimensionColState.map((colState) => ({
                ...colState,
                selected: colState.colId === selectedColumnId,
            }));
        }
        else {
            // Update the selection state of all dimension columns, selecting only the provided columns from the chart model
            const foundColStates = this.dimensionColState.filter((colState) => colIdSet.has(colState.colId));
            const selectedColumnIds = new Set(foundColStates.map((colState) => colState.colId));
            this.dimensionColState = this.dimensionColState.map((colState) => ({
                ...colState,
                selected: selectedColumnIds.has(colState.colId),
            }));
        }
    }
    syncDimensionCellRange() {
        const selectedDimensions = this.getSelectedDimensions();
        if (selectedDimensions.length === 0)
            return;
        const selectedCols = selectedDimensions
            .map(({ column }) => column)
            .filter((value) => value != null);
        if (selectedCols.length > 0) {
            this.dimensionCellRange = this.createCellRange(ag_grid_community_1.CellRangeType.DIMENSION, ...selectedCols);
        }
    }
    isComboChart(chartType) {
        return (0, seriesTypeMapper_1.isComboChart)(chartType ?? this.chartType);
    }
}
exports.ChartDataModel = ChartDataModel;


/***/ }),

/***/ 2474:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComboChartModel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const SUPPORTED_COMBO_CHART_TYPES = new Set(['line', 'groupedColumn', 'stackedColumn', 'area', 'stackedArea']);
class ComboChartModel extends ag_grid_community_1.BeanStub {
    constructor(chartDataModel) {
        super();
        // this control flag is used to only log warning for the initial user config
        this.suppressComboChartWarnings = false;
        this.chartDataModel = chartDataModel;
        this.seriesChartTypes = chartDataModel.params.seriesChartTypes ?? [];
    }
    postConstruct() {
        this.initComboCharts();
    }
    update(seriesChartTypes) {
        this.seriesChartTypes = seriesChartTypes ?? this.seriesChartTypes;
        this.initComboCharts();
        this.updateSeriesChartTypes();
    }
    initComboCharts() {
        const seriesChartTypesExist = this.seriesChartTypes && this.seriesChartTypes.length > 0;
        const customCombo = this.chartDataModel.chartType === 'customCombo' || seriesChartTypesExist;
        if (customCombo) {
            // it is not necessary to supply a chart type for combo charts when `seriesChartTypes` is supplied
            this.chartDataModel.chartType = 'customCombo';
            // cache supplied `seriesChartTypes` to allow switching between different chart types in the settings panel
            this.savedCustomSeriesChartTypes = this.seriesChartTypes || [];
        }
    }
    updateSeriesChartTypes() {
        if (!this.chartDataModel.isComboChart()) {
            return;
        }
        // ensure primary only chart types are not placed on secondary axis
        this.seriesChartTypes = this.seriesChartTypes.map((seriesChartType) => {
            const primaryOnly = ['groupedColumn', 'stackedColumn', 'stackedArea'].includes(seriesChartType.chartType);
            seriesChartType.secondaryAxis = primaryOnly ? false : seriesChartType.secondaryAxis;
            return seriesChartType;
        });
        // note that when seriesChartTypes are supplied the chart type is also changed to 'customCombo'
        if (this.chartDataModel.chartType === 'customCombo') {
            this.updateSeriesChartTypesForCustomCombo();
            return;
        }
        this.updateChartSeriesTypesForBuiltInCombos();
    }
    updateSeriesChartTypesForCustomCombo() {
        const seriesChartTypesSupplied = this.seriesChartTypes && this.seriesChartTypes.length > 0;
        if (!seriesChartTypesSupplied && !this.suppressComboChartWarnings) {
            (0, ag_grid_community_1._warn)(150);
        }
        // ensure correct chartTypes are supplied
        this.seriesChartTypes = this.seriesChartTypes.map((s) => {
            if (!SUPPORTED_COMBO_CHART_TYPES.has(s.chartType)) {
                (0, ag_grid_community_1._warn)(151, { chartType: s.chartType });
                s.chartType = 'line';
            }
            return s;
        });
        const getSeriesChartType = (valueCol) => {
            if (!this.savedCustomSeriesChartTypes || this.savedCustomSeriesChartTypes.length === 0) {
                this.savedCustomSeriesChartTypes = this.seriesChartTypes;
            }
            const providedSeriesChartType = this.savedCustomSeriesChartTypes.find((s) => s.colId === valueCol.colId);
            if (!providedSeriesChartType) {
                if (valueCol.selected && !this.suppressComboChartWarnings) {
                    (0, ag_grid_community_1._warn)(152, { colId: valueCol.colId });
                }
                return {
                    colId: valueCol.colId,
                    chartType: 'line',
                    secondaryAxis: false,
                };
            }
            return providedSeriesChartType;
        };
        const updatedSeriesChartTypes = this.chartDataModel.valueColState.map(getSeriesChartType);
        this.seriesChartTypes = updatedSeriesChartTypes;
        // also cache custom `seriesChartTypes` to allow for switching between different chart types
        this.savedCustomSeriesChartTypes = updatedSeriesChartTypes;
        // turn off warnings as first combo chart attempt has completed
        this.suppressComboChartWarnings = true;
    }
    updateChartSeriesTypesForBuiltInCombos() {
        const { chartType, valueColState } = this.chartDataModel;
        const primaryChartType = chartType === 'columnLineCombo' ? 'groupedColumn' : 'stackedArea';
        const secondaryChartType = chartType === 'columnLineCombo' ? 'line' : 'groupedColumn';
        const selectedCols = valueColState.filter((cs) => cs.selected);
        const lineIndex = Math.ceil(selectedCols.length / 2);
        this.seriesChartTypes = selectedCols.map((valueCol, i) => {
            const seriesType = i >= lineIndex ? secondaryChartType : primaryChartType;
            return { colId: valueCol.colId, chartType: seriesType, secondaryAxis: false };
        });
    }
}
exports.ComboChartModel = ComboChartModel;


/***/ }),

/***/ 8919:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartColumnService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ChartColumnService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'chartColSvc';
        this.valueColsWithoutSeriesType = new Set();
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.colNames = beans.colNames;
        this.valueSvc = beans.valueSvc;
    }
    postConstruct() {
        const clearValueCols = () => this.valueColsWithoutSeriesType.clear();
        this.addManagedEventListeners({
            newColumnsLoaded: clearValueCols,
            rowDataUpdated: clearValueCols,
        });
    }
    getColumn(colId) {
        return this.colModel.getColDefCol(colId);
    }
    getAllDisplayedColumns() {
        return this.beans.visibleCols.allCols;
    }
    getColDisplayName(col, includePath) {
        const headerLocation = 'chart';
        const columnDisplayName = this.colNames.getDisplayNameForColumn(col, headerLocation);
        if (includePath) {
            const displayNames = [columnDisplayName];
            const getDisplayName = (colGroup) => {
                if (!colGroup) {
                    return;
                }
                const colGroupName = this.colNames.getDisplayNameForColumnGroup(colGroup, headerLocation);
                if (colGroupName?.length) {
                    displayNames.unshift(colGroupName);
                    getDisplayName(colGroup.getParent());
                }
            };
            getDisplayName(col.getParent());
            return displayNames.join(' - ');
        }
        return columnDisplayName;
    }
    getRowGroupColumns() {
        return this.beans.rowGroupColsSvc?.columns ?? [];
    }
    getGroupDisplayColumns() {
        return this.beans.showRowGroupCols?.getShowRowGroupCols() ?? [];
    }
    isPivotMode() {
        return this.colModel.isPivotMode();
    }
    isPivotActive() {
        return this.colModel.isPivotActive();
    }
    getChartColumns() {
        const gridCols = this.colModel.getCols();
        const dimensionCols = new Set();
        const valueCols = new Set();
        gridCols.forEach((col) => {
            const colDef = col.getColDef();
            const chartDataType = colDef.chartDataType;
            if (chartDataType) {
                // chart data type was specified explicitly
                switch (chartDataType) {
                    case 'category':
                    case 'time':
                        dimensionCols.add(col);
                        return;
                    case 'series':
                        valueCols.add(col);
                        return;
                    case 'excluded':
                        return;
                    default:
                        (0, ag_grid_community_1._warn)(153, { chartDataType });
                        break;
                }
            }
            if (colDef.colId === 'ag-Grid-AutoColumn') {
                dimensionCols.add(col);
                return;
            }
            if (!col.isPrimary()) {
                valueCols.add(col);
                return;
            }
            // if 'chartDataType' is not provided then infer type based data contained in first row
            (this.isInferredValueCol(col) ? valueCols : dimensionCols).add(col);
        });
        return { dimensionCols, valueCols };
    }
    isInferredValueCol(col) {
        const colId = col.getColId();
        if (colId === 'ag-Grid-AutoColumn') {
            return false;
        }
        const row = (0, ag_grid_community_1._getRowNode)(this.beans, { rowIndex: 0, rowPinned: null });
        if (!row) {
            return this.valueColsWithoutSeriesType.has(colId);
        }
        let cellValue = this.valueSvc.getValue(col, row);
        if (cellValue == null) {
            cellValue = this.extractLeafData(row, col);
        }
        if (cellValue != null && typeof cellValue.toNumber === 'function') {
            cellValue = cellValue.toNumber();
        }
        const isNumber = typeof cellValue === 'number' ||
            col.colDef.cellDataType === 'number' ||
            ['series', 'time'].includes(col.colDef.chartDataType);
        if (isNumber) {
            this.valueColsWithoutSeriesType.add(colId);
        }
        else if (cellValue == null && col.colDef.cellDataType !== 'number') {
            (0, ag_grid_community_1._warn)(265, { colId });
        }
        return isNumber;
    }
    extractLeafData(row, col) {
        if (!row.allLeafChildren) {
            return null;
        }
        for (let i = 0; i < row.allLeafChildren.length; i++) {
            const childRow = row.allLeafChildren[i];
            const value = this.valueSvc.getValue(col, childRow);
            if (value != null) {
                return value;
            }
        }
        return null;
    }
    destroy() {
        this.valueColsWithoutSeriesType.clear();
        super.destroy();
    }
}
exports.ChartColumnService = ChartColumnService;


/***/ }),

/***/ 8769:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartCrossFilterService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ChartCrossFilterService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'chartCrossFilterSvc';
    }
    wireBeans(beans) {
        this.colModel = beans.colModel;
        this.valueSvc = beans.valueSvc;
        this.filterManager = beans.filterManager;
        if ((0, ag_grid_community_1._isClientSideRowModel)(this.gos, beans.rowModel)) {
            this.clientSideRowModel = beans.rowModel;
        }
    }
    filter(event, reset = false) {
        const filterModel = this.filterManager?.getFilterModel() ?? {};
        // filters should be reset when user clicks on canvas background
        if (reset) {
            this.resetFilters(filterModel);
            return;
        }
        const colId = this.extractFilterColId(event);
        if (this.isValidColumnFilter(colId)) {
            // update filters based on current chart selections
            this.updateFilters(filterModel, event, colId);
        }
        else {
            (0, ag_grid_community_1._warn)(154, { colId });
        }
    }
    resetFilters(filterModel) {
        const filtersExist = Object.keys(filterModel).length > 0;
        if (filtersExist) {
            // only reset filters / charts when necessary to prevent undesirable flickering effect
            this.filterManager?.setFilterModel(null);
            this.filterManager?.onFilterChanged({ source: 'api' });
        }
    }
    updateFilters(filterModel, event, colId) {
        const dataKey = this.extractFilterColId(event);
        const rawValue = event.datum[dataKey];
        if (rawValue === undefined) {
            return;
        }
        const selectedValue = rawValue.toString();
        if (event.event.metaKey || event.event.ctrlKey) {
            const existingGridValues = this.getCurrentGridValuesForCategory(colId);
            const valueAlreadyExists = existingGridValues.includes(selectedValue);
            let updatedValues;
            if (valueAlreadyExists) {
                updatedValues = existingGridValues.filter((v) => v !== selectedValue);
            }
            else {
                updatedValues = existingGridValues;
                updatedValues.push(selectedValue);
            }
            filterModel[colId] = this.getUpdatedFilterModel(colId, updatedValues);
        }
        else {
            const updatedValues = [selectedValue];
            filterModel = { [colId]: this.getUpdatedFilterModel(colId, updatedValues) };
        }
        this.filterManager?.setFilterModel(filterModel);
    }
    getUpdatedFilterModel(colId, updatedValues) {
        const columnFilterType = this.getColumnFilterType(colId);
        if (columnFilterType === 'agMultiColumnFilter') {
            return { filterType: 'multi', filterModels: [null, { filterType: 'set', values: updatedValues }] };
        }
        return { filterType: 'set', values: updatedValues };
    }
    getCurrentGridValuesForCategory(colId) {
        const filteredValues = [];
        const column = this.getColumnById(colId);
        this.clientSideRowModel?.forEachNodeAfterFilter((rowNode) => {
            if (column && !rowNode.group) {
                const value = this.valueSvc.getValue(column, rowNode) + '';
                if (!filteredValues.includes(value)) {
                    filteredValues.push(value);
                }
            }
        });
        return filteredValues;
    }
    extractFilterColId(event) {
        return event.xKey || event.calloutLabelKey;
    }
    isValidColumnFilter(colId) {
        if (colId.indexOf('-filtered-out')) {
            colId = colId.replace('-filtered-out', '');
        }
        const filterType = this.getColumnFilterType(colId);
        if (typeof filterType === 'boolean') {
            return filterType;
        }
        return ['agSetColumnFilter', 'agMultiColumnFilter'].includes(filterType);
    }
    getColumnFilterType(colId) {
        const gridColumn = this.getColumnById(colId);
        if (gridColumn) {
            const colDef = gridColumn.getColDef();
            return colDef.filter;
        }
    }
    getColumnById(colId) {
        return this.colModel.getCol(colId);
    }
}
exports.ChartCrossFilterService = ChartCrossFilterService;


/***/ }),

/***/ 7492:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartMenuService = exports.CHART_TOOL_PANEL_MENU_OPTIONS = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const CHART_TOOLBAR_ALLOW_LIST = [
    'chartUnlink',
    'chartLink',
    'chartDownload',
    'chartMenu',
];
exports.CHART_TOOL_PANEL_MENU_OPTIONS = {
    settings: 'chartSettings',
    data: 'chartData',
    format: 'chartFormat',
};
class ChartMenuService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'chartMenuSvc';
    }
    wireBeans(beans) {
        this.advSettingsMenuFactory = beans.advSettingsMenuFactory;
    }
    downloadChart(chartMenuContext, dimensions, fileName, fileFormat) {
        chartMenuContext.chartController.getChartProxy().downloadChart(dimensions, fileName, fileFormat);
    }
    toggleLinked(chartMenuContext) {
        chartMenuContext.chartController.detachChartRange();
    }
    openAdvancedSettings(chartMenuContext, eventSource) {
        this.advSettingsMenuFactory?.showMenu(chartMenuContext, eventSource);
    }
    hideAdvancedSettings() {
        this.advSettingsMenuFactory?.hideMenu();
    }
    getChartToolbarOptions() {
        const defaultChartToolbarOptions = ['chartMenu'];
        const toolbarItemsFunc = this.gos.getCallback('getChartToolbarItems');
        const params = {
            defaultItems: defaultChartToolbarOptions,
        };
        return toolbarItemsFunc
            ? toolbarItemsFunc(params).filter((option) => {
                if (!CHART_TOOLBAR_ALLOW_LIST.includes(option)) {
                    (0, ag_grid_community_1._warn)(155, { option });
                    return false;
                }
                return true;
            })
            : defaultChartToolbarOptions;
    }
    getChartToolPanels(chartController) {
        const chartToolPanelsDef = this.gos.get('chartToolPanelsDef');
        const panelsOverride = chartToolPanelsDef?.panels
            ?.map((panel) => {
            const menuOption = exports.CHART_TOOL_PANEL_MENU_OPTIONS[panel];
            if (!menuOption) {
                (0, ag_grid_community_1._warn)(156, { panel });
            }
            return menuOption;
        })
            .filter((panel) => Boolean(panel));
        let panels = panelsOverride ?? Object.values(exports.CHART_TOOL_PANEL_MENU_OPTIONS);
        // pivot charts use the column tool panel instead of the data panel
        if (chartController.isPivotChart()) {
            panels = panels.filter((panel) => panel !== 'chartData');
        }
        const defaultToolPanel = chartToolPanelsDef?.defaultToolPanel;
        const defaultPanel = (defaultToolPanel && exports.CHART_TOOL_PANEL_MENU_OPTIONS[defaultToolPanel]) || panels[0];
        return {
            panels,
            defaultPanel,
        };
    }
    doesChartToolbarExist() {
        const chartToolbarOptions = this.getChartToolbarOptions();
        return chartToolbarOptions.length > 0;
    }
    doChartToolPanelsExist(chartController) {
        const { panels } = this.getChartToolPanels(chartController);
        return panels.length > 0;
    }
}
exports.ChartMenuService = ChartMenuService;


/***/ }),

/***/ 6297:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartOptionsService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const object_1 = __webpack_require__(2210);
const seriesTypeMapper_1 = __webpack_require__(4237);
const CARTESIAN_AXIS_TYPES = ['number', 'category', 'time', 'grouped-category'];
const POLAR_AXIS_TYPES = ['angle-category', 'angle-number', 'radius-category', 'radius-number'];
const VALID_AXIS_TYPES = [...CARTESIAN_AXIS_TYPES, ...POLAR_AXIS_TYPES];
class ChartOptionsService extends ag_grid_community_1.BeanStub {
    constructor(chartController) {
        super();
        this.chartController = chartController;
    }
    getChartThemeOverridesProxy() {
        return {
            getValue: (expression) => this.getChartOption(expression),
            setValue: (expression, value) => this.setChartThemeOverrides([{ expression, value }]),
            setValues: (properties) => this.setChartThemeOverrides(properties),
        };
    }
    getAxisThemeOverridesProxy() {
        return {
            getValue: (expression) => this.getAxisProperty(expression),
            setValue: (expression, value) => this.setAxisThemeOverrides([{ expression, value }]),
            setValues: (properties) => this.setAxisThemeOverrides(properties),
        };
    }
    getCartesianAxisOptionsProxy(axisType) {
        return {
            getValue: (expression) => this.getCartesianAxisProperty(axisType, expression),
            setValue: (expression, value) => this.setCartesianAxisOptions(axisType, [{ expression, value }]),
            setValues: (properties) => this.setCartesianAxisOptions(axisType, properties),
        };
    }
    getCartesianAxisThemeOverridesProxy(axisType) {
        return {
            getValue: (expression) => this.getCartesianAxisProperty(axisType, expression),
            setValue: (expression, value) => this.setCartesianAxisThemeOverrides(axisType, [{ expression, value }]),
            setValues: (properties) => this.setCartesianAxisThemeOverrides(axisType, properties),
        };
    }
    getCartesianAxisAppliedThemeOverridesProxy(axisType) {
        return {
            getValue: (expression) => this.getCartesianAxisThemeOverride(axisType, 
            // Allow the caller to specify a wildcard expression to retrieve the whole set of overrides
            expression === '*' ? null : expression),
            setValue: (expression, value) => this.setCartesianAxisThemeOverrides(axisType, 
            // Allow the caller to specify a wildcard expression to set the whole set of overrides
            [{ expression: expression === '*' ? null : expression, value }]),
            setValues: (properties) => this.setCartesianAxisThemeOverrides(axisType, properties),
        };
    }
    getSeriesOptionsProxy(getSelectedSeries) {
        return {
            getValue: (expression, calculated) => this.getSeriesOption(getSelectedSeries(), expression, calculated),
            setValue: (expression, value) => this.setSeriesOptions(getSelectedSeries(), [{ expression, value }]),
            setValues: (properties) => this.setSeriesOptions(getSelectedSeries(), properties),
        };
    }
    /**
     * Determine the set of theme overrides that should be retained when transitioning from one chart type to another.
     */
    getPersistedChartThemeOverrides(existingChartOptions, existingAxes, existingChartType, targetChartType) {
        // Determine the set of theme override keys that should be retained when transitioning from one chart type to another
        const retainedThemeOverrideKeys = this.getRetainedChartThemeOverrideKeys(existingChartType, targetChartType);
        const retainedChartAxisThemeOverrideKeys = this.getRetainedChartAxisThemeOverrideKeys(null, existingChartType, targetChartType);
        // combine the options into a single merged object
        const targetChartOptions = this.createChartOptions();
        // copy the retained theme overrides from the existing chart options to the target chart options
        for (const expression of retainedThemeOverrideKeys) {
            // Locate the value in the existing chart series theme overrides
            const value = this.retrieveChartOptionsThemeOverride(existingChartOptions, existingChartType, expression);
            if (value !== undefined) {
                // Update the value in the target chart series theme overrides
                this.assignChartOptionsThemeOverride(targetChartOptions, targetChartType, expression, value);
            }
        }
        // axis theme overrides are copied to all potential target axis types
        // (this is necessary because certain chart types auto-instantiate different axis types given the same data)
        if (existingAxes) {
            this.assignPersistedAxisOverrides({
                existingAxes,
                retainedChartAxisThemeOverrideKeys,
                existingChartOptions,
                targetChartOptions,
                existingChartType,
                targetChartType,
            });
        }
        return targetChartOptions.theme.overrides;
    }
    assignPersistedAxisOverrides(params) {
        const { existingAxes, retainedChartAxisThemeOverrideKeys, existingChartOptions, targetChartOptions, existingChartType, targetChartType, } = params;
        for (const { expression, targetAxisTypes } of retainedChartAxisThemeOverrideKeys) {
            // Locate the value in the existing chart series theme overrides
            for (const existingAxisType of existingAxes.map((axis) => axis.type)) {
                const value = this.retrieveChartOptionsThemeOverride(existingChartOptions, existingChartType, ['axes', existingAxisType, expression].join('.'));
                if (value !== undefined) {
                    // Copy the value to all potential target chart axis theme overrides
                    // (axis theme overrides are currently only persisted across cartesian chart types)
                    for (const targetAxisType of targetAxisTypes) {
                        this.assignChartOptionsThemeOverride(targetChartOptions, targetChartType, ['axes', targetAxisType, expression].join('.'), value);
                    }
                }
            }
        }
    }
    getRetainedChartThemeOverrideKeys(existingChartType, targetChartType) {
        // these theme overrides are persisted across all chart types
        const UNIVERSAL_PERSISTED_THEME_OVERRIDES = ['animation'];
        // these theme overrides are persisted across all cartesian chart types
        const PERSISTED_CARTESIAN_CHART_THEME_OVERRIDES = ['zoom', 'navigator'];
        // other chart options will be retained depending on the specifics of the chart type from/to transition
        const chartSpecificThemeOverrideKeys = ((previousChartType, updatedChartType) => {
            const expressions = new Array();
            if ((0, seriesTypeMapper_1.isCartesian)((0, seriesTypeMapper_1.getSeriesType)(previousChartType)) && (0, seriesTypeMapper_1.isCartesian)((0, seriesTypeMapper_1.getSeriesType)(updatedChartType))) {
                expressions.push(...PERSISTED_CARTESIAN_CHART_THEME_OVERRIDES);
            }
            return expressions;
        })(existingChartType, targetChartType);
        return [...UNIVERSAL_PERSISTED_THEME_OVERRIDES, ...chartSpecificThemeOverrideKeys];
    }
    getRetainedChartAxisThemeOverrideKeys(axisType, existingChartType, targetChartType) {
        // different axis types have different theme overrides
        if ((0, seriesTypeMapper_1.isCartesian)((0, seriesTypeMapper_1.getSeriesType)(existingChartType)) && (0, seriesTypeMapper_1.isCartesian)((0, seriesTypeMapper_1.getSeriesType)(targetChartType))) {
            const retainedKeys = this.getRetainedCartesianAxisThemeOverrideKeys(axisType);
            return retainedKeys.map((expression) => ({ expression, targetAxisTypes: CARTESIAN_AXIS_TYPES }));
        }
        return [];
    }
    getRetainedCartesianAxisThemeOverrideKeys(axisType) {
        const axisPositionSuffixes = axisType === 'xAxis'
            ? ['', '.top', '.bottom']
            : axisType === 'yAxis'
                ? ['', '.left', '.right']
                : ['', '.left', '.right', '.top', '.bottom'];
        // these axis theme overrides are persisted across all cartesian chart axis types
        const PERSISTED_CARTESIAN_AXIS_THEME_OVERRIDES = ['crosshair'];
        const expressions = new Array();
        for (const expression of PERSISTED_CARTESIAN_AXIS_THEME_OVERRIDES) {
            for (const axisPositionSuffix of axisPositionSuffixes) {
                expressions.push(`${expression}${axisPositionSuffix}`);
            }
        }
        return expressions;
    }
    getChartOption(expression) {
        return (0, object_1.get)(this.getChart(), expression, undefined);
    }
    setChartThemeOverrides(properties) {
        const chartType = this.getChartType();
        // combine the options into a single merged object
        const chartOptions = this.createChartOptions();
        for (const { expression, value } of properties) {
            this.assignChartOptionsThemeOverride(chartOptions, chartType, expression, value);
        }
        this.applyChartOptions(chartOptions);
    }
    applyChartOptions(chartOptions, options) {
        if (Object.keys(chartOptions).length === 0)
            return;
        this.updateChart(chartOptions);
        const shouldRaiseEvent = !options?.silent;
        if (shouldRaiseEvent)
            this.raiseChartOptionsChangedEvent();
    }
    awaitChartOptionUpdate(func) {
        const chart = this.chartController.getChartProxy().getChart();
        chart
            .waitForUpdate()
            .then(() => func())
            .catch((e) => (0, ag_grid_community_1._error)(108, { e }));
    }
    getAxisProperty(expression) {
        // Assume the property exists on the first axis
        return (0, object_1.get)(this.getChart().axes?.[0], expression, undefined);
    }
    setAxisThemeOverrides(properties) {
        const chart = this.getChart();
        const chartType = this.getChartType();
        // combine the options into a single merged object
        const chartOptions = this.createChartOptions();
        for (const { expression, value } of properties) {
            // Only apply the property to axes that declare the property on their prototype chain
            const relevantAxes = chart.axes?.filter((axis) => {
                const parts = expression.split('.');
                let current = axis;
                for (const part of parts) {
                    if (!(part in current)) {
                        return false;
                    }
                    current = current[part];
                }
                return true;
            });
            if (!relevantAxes)
                continue;
            for (const axis of relevantAxes) {
                if (!this.isValidAxisType(axis))
                    continue;
                this.assignChartAxisThemeOverride(chartOptions, chartType, axis.type, null, expression, value);
            }
        }
        this.applyChartOptions(chartOptions);
    }
    getCartesianAxisProperty(axisType, expression) {
        const axes = this.getChartAxes();
        const axis = this.getCartesianAxis(axes, axisType);
        return (0, object_1.get)(axis, expression, undefined);
    }
    getCartesianAxisThemeOverride(axisType, expression) {
        const axes = this.getChartAxes();
        const chartAxis = this.getCartesianAxis(axes, axisType);
        if (!chartAxis || !this.isValidAxisType(chartAxis))
            return undefined;
        const chartType = this.getChartType();
        const chartOptions = this.getChart().getOptions();
        return this.retrieveChartAxisThemeOverride(chartOptions, chartType, chartAxis.type, axisType === 'yAxis' ? ['left', 'right'] : ['bottom', 'top'], expression);
    }
    setCartesianAxisThemeOverrides(axisType, properties) {
        const axes = this.getChartAxes();
        const chartAxis = this.getCartesianAxis(axes, axisType);
        if (!chartAxis || !this.isValidAxisType(chartAxis))
            return;
        const chartType = this.getChartType();
        // combine the axis options into a single merged object
        const chartOptions = this.createChartOptions();
        for (const { expression, value } of properties) {
            this.assignChartAxisThemeOverride(chartOptions, chartType, chartAxis.type, axisType === 'yAxis' ? ['left', 'right'] : ['bottom', 'top'], expression, value);
        }
        this.applyChartOptions(chartOptions);
    }
    setCartesianAxisOptions(axisType, properties) {
        this.updateCartesianAxisOptions(axisType, (chartOptions, axes, chartAxis) => {
            // assign the provided axis options onto the combined chart options object
            const axisIndex = axes.indexOf(chartAxis);
            for (const { expression, value } of properties) {
                this.assignChartOption(chartOptions, `axes.${axisIndex}.${expression}`, value);
            }
        });
    }
    updateCartesianAxisOptions(axisType, updateFunc) {
        // get a snapshot of all existing axis options from the chart instance
        const existingChartOptions = this.getChart().getOptions();
        const axisOptions = 'axes' in existingChartOptions ? existingChartOptions.axes : undefined;
        if (!existingChartOptions || !axisOptions)
            return;
        const axes = this.getChartAxes();
        const chartAxis = this.getCartesianAxis(axes, axisType);
        if (!chartAxis)
            return;
        // combine the axis options into a single merged object
        const chartOptions = this.createChartOptions();
        chartOptions.axes = axisOptions;
        updateFunc(chartOptions, axes, chartAxis, existingChartOptions);
        this.applyChartOptions(chartOptions);
    }
    setCartesianCategoryAxisType(axisType, value) {
        this.updateCartesianAxisOptions(axisType, (chartOptions, _axes, chartAxis, existingChartOptions) => {
            const chartType = this.getChartType();
            this.assignPersistedAxisOverrides({
                existingAxes: [chartAxis],
                retainedChartAxisThemeOverrideKeys: this.getRetainedChartAxisThemeOverrideKeys(axisType, chartType, chartType),
                existingChartOptions,
                targetChartOptions: chartOptions,
                existingChartType: chartType,
                targetChartType: chartType,
            });
            this.assignChartOption(chartOptions, `axes.0.type`, value);
            this.chartController.setCategoryAxisType(value);
        });
    }
    getCartesianAxis(axes, axisType) {
        if (axes.length < 2) {
            return undefined;
        }
        switch (axisType) {
            case 'xAxis':
                return axes[0].direction === 'x' ? axes[0] : axes[1];
            case 'yAxis':
                return axes[1].direction === 'y' ? axes[1] : axes[0];
        }
    }
    getSeriesOption(seriesType, expression, calculated) {
        // N.B. 'calculated' here refers to the fact that the property exists on the internal series object itself,
        // rather than the properties object. This is due to us needing to reach inside the chart itself to retrieve
        // the value, and will likely be cleaned up in a future release
        const series = this.getChart().series.find((s) => isMatchingSeries(seriesType, s));
        return (0, object_1.get)(calculated ? series : series?.properties.toJson(), expression, undefined);
    }
    setSeriesOptions(seriesType, properties) {
        // combine the series options into a single merged object
        const chartOptions = this.createChartOptions();
        for (const { expression, value } of properties) {
            this.assignChartOptionsSeriesThemeOverride(chartOptions, seriesType, `series.${expression}`, value);
        }
        this.applyChartOptions(chartOptions);
    }
    getPairedMode() {
        return this.chartController.getChartProxy().isPaired();
    }
    setPairedMode(paired) {
        this.chartController.getChartProxy().setPaired(paired);
    }
    getChartAxes() {
        const chart = this.getChart();
        return chart.axes ?? [];
    }
    retrieveChartAxisThemeOverride(chartOptions, chartType, axisType, axisPositions, expression) {
        // Theme overrides can be applied either to all axes simultaneously, or only to axes in a certain orientation
        // (this allows more fine-grained control for e.g. styling horizontal / vertical axes separately)
        if (axisPositions) {
            for (const axisPosition of axisPositions) {
                const value = this.retrieveChartOptionsThemeOverride(chartOptions, chartType, ['axes', axisType, axisPosition, ...(expression ? [expression] : [])].join('.'));
                if (value === undefined)
                    continue;
                return value;
            }
        }
        else {
            return this.retrieveChartOptionsThemeOverride(chartOptions, chartType, ['axes', axisType, ...(expression ? [expression] : [])].join('.'));
        }
    }
    assignChartAxisThemeOverride(chartOptions, chartType, axisType, axisPositions, expression, value) {
        // Theme overrides can be applied either to all axes simultaneously, or only to axes in a certain orientation
        // (this allows more fine-grained control for e.g. styling horizontal / vertical axes separately)
        if (axisPositions) {
            for (const axisPosition of axisPositions) {
                this.assignChartOptionsThemeOverride(chartOptions, chartType, ['axes', axisType, axisPosition, ...(expression ? [expression] : [])].join('.'), value);
            }
        }
        else {
            this.assignChartOptionsThemeOverride(chartOptions, chartType, ['axes', axisType, ...(expression ? [expression] : [])].join('.'), value);
        }
    }
    isValidAxisType(chartAxis) {
        return VALID_AXIS_TYPES.includes(chartAxis.type);
    }
    getChartType() {
        return this.chartController.getChartType();
    }
    getChart() {
        return this.chartController.getChartProxy().getChart();
    }
    updateChart(chartOptions) {
        const chartRef = this.chartController.getChartProxy().getChartRef();
        chartRef.skipAnimations();
        chartRef.updateDelta(chartOptions);
    }
    createChartOptions() {
        const chartOptions = {
            theme: {
                overrides: {},
            },
        };
        return chartOptions;
    }
    retrieveChartOptionsThemeOverride(chartOptions, chartType, expression) {
        // Determine the relevant series type theme override series keys for the current chart
        const chartSeriesTypes = this.getChartThemeOverridesSeriesTypeKeys(chartType);
        // Retrieve the first matching value
        for (const seriesType of chartSeriesTypes) {
            const value = this.retrieveChartOptionsSeriesThemeOverride(chartOptions, seriesType, expression);
            if (value === undefined)
                continue;
            return value;
        }
        return undefined;
    }
    assignChartOptionsThemeOverride(chartOptions, chartType, expression, value) {
        // Determine the relevant series type theme override series keys for the current chart
        const chartSeriesTypes = this.getChartThemeOverridesSeriesTypeKeys(chartType);
        // assign the relevant theme overrides for each series type
        for (const seriesType of chartSeriesTypes) {
            this.assignChartOptionsSeriesThemeOverride(chartOptions, seriesType, expression, value);
        }
    }
    retrieveChartOptionsSeriesThemeOverride(chartOptions, seriesType, expression) {
        return this.retrieveChartOption(chartOptions, ['theme', 'overrides', seriesType, ...(expression ? [expression] : [])].join('.'));
    }
    assignChartOptionsSeriesThemeOverride(chartOptions, seriesType, expression, value) {
        this.assignChartOption(chartOptions, ['theme', 'overrides', seriesType, ...(expression ? [expression] : [])].join('.'), value);
    }
    getChartThemeOverridesSeriesTypeKeys(chartType) {
        // In the chart options API, theme overrides are categorized according to series type.
        // Depending on the chart type, theme overrides may need to be applied to multiple series types.
        const chartSeriesTypes = this.chartController.getChartSeriesTypes(chartType);
        if (this.chartController.isComboChart()) {
            chartSeriesTypes.push('common');
        }
        return chartSeriesTypes;
    }
    retrieveChartOption(chartOptions, expression) {
        return (0, object_1.get)(chartOptions, expression, undefined);
    }
    assignChartOption(chartOptions, expression, value) {
        (0, object_1.set)(chartOptions, expression, value);
    }
    raiseChartOptionsChangedEvent() {
        const chartModel = this.chartController.getChartModel();
        this.eventSvc.dispatchEvent({
            type: 'chartOptionsChanged',
            chartId: chartModel.chartId,
            chartType: chartModel.chartType,
            chartThemeName: this.chartController.getChartThemeName(),
            chartOptions: chartModel.chartOptions,
        });
    }
}
exports.ChartOptionsService = ChartOptionsService;
function isMatchingSeries(seriesType, series) {
    return (0, seriesTypeMapper_1.isSeriesType)(seriesType) && series.type === seriesType;
}


/***/ }),

/***/ 93:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartTranslationService = exports.DEFAULT_CHART_TRANSLATIONS = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
exports.DEFAULT_CHART_TRANSLATIONS = {
    pivotChartTitle: 'Pivot Chart',
    rangeChartTitle: 'Range Chart',
    settings: 'Chart',
    data: 'Set Up',
    format: 'Customize',
    categories: 'Categories',
    defaultCategory: '(None)',
    series: 'Series',
    switchCategorySeries: 'Switch Category / Series',
    categoryValues: 'Category Values',
    seriesLabels: 'Series Labels',
    aggregate: 'Aggregate',
    xyValues: 'X Y Values',
    paired: 'Paired Mode',
    axis: 'Axis',
    xAxis: 'Horizontal Axis',
    yAxis: 'Vertical Axis',
    polarAxis: 'Polar Axis',
    radiusAxis: 'Radius Axis',
    navigator: 'Navigator',
    zoom: 'Zoom',
    animation: 'Animation',
    crosshair: 'Crosshair',
    color: 'Color',
    thickness: 'Thickness',
    preferredLength: 'Preferred Length',
    xType: 'X Type',
    axisType: 'Axis Type',
    automatic: 'Automatic',
    category: 'Category',
    number: 'Number',
    time: 'Time',
    timeFormat: 'Time Format',
    autoRotate: 'Auto Rotate',
    labelRotation: 'Rotation',
    circle: 'Circle',
    polygon: 'Polygon',
    square: 'Square',
    cross: 'Cross',
    diamond: 'Diamond',
    plus: 'Plus',
    triangle: 'Triangle',
    heart: 'Heart',
    orientation: 'Orientation',
    fixed: 'Fixed',
    parallel: 'Parallel',
    perpendicular: 'Perpendicular',
    radiusAxisPosition: 'Position',
    ticks: 'Ticks',
    gridLines: 'Grid Lines',
    width: 'Width',
    height: 'Height',
    length: 'Length',
    padding: 'Padding',
    spacing: 'Spacing',
    chartStyle: 'Chart Style',
    title: 'Title',
    chartTitles: 'Titles',
    chartTitle: 'Chart Title',
    chartSubtitle: 'Subtitle',
    horizontalAxisTitle: 'Horizontal Axis Title',
    verticalAxisTitle: 'Vertical Axis Title',
    polarAxisTitle: 'Polar Axis Title',
    titlePlaceholder: 'Chart Title',
    background: 'Background',
    font: 'Font',
    weight: 'Weight',
    top: 'Top',
    right: 'Right',
    bottom: 'Bottom',
    left: 'Left',
    labels: 'Labels',
    calloutLabels: 'Callout Labels',
    sectorLabels: 'Sector Labels',
    positionRatio: 'Position Ratio',
    size: 'Size',
    shape: 'Shape',
    minSize: 'Minimum Size',
    maxSize: 'Maximum Size',
    legend: 'Legend',
    position: 'Position',
    markerSize: 'Marker Size',
    markerStroke: 'Marker Stroke',
    markerPadding: 'Marker Padding',
    itemSpacing: 'Item Spacing',
    itemPaddingX: 'Item Padding X',
    itemPaddingY: 'Item Padding Y',
    layoutHorizontalSpacing: 'Horizontal Spacing',
    layoutVerticalSpacing: 'Vertical Spacing',
    strokeWidth: 'Stroke Width',
    offset: 'Offset',
    offsets: 'Offsets',
    tooltips: 'Tooltips',
    callout: 'Callout',
    markers: 'Markers',
    shadow: 'Shadow',
    blur: 'Blur',
    xOffset: 'X Offset',
    yOffset: 'Y Offset',
    lineWidth: 'Line Width',
    lineDash: 'Line Dash',
    lineDashOffset: 'Dash Offset',
    scrollingZoom: 'Scrolling',
    scrollingStep: 'Scrolling Step',
    selectingZoom: 'Selecting',
    durationMillis: 'Duration (ms)',
    crosshairLabel: 'Label',
    crosshairSnap: 'Snap to Node',
    normal: 'Normal',
    bold: 'Bold',
    italic: 'Italic',
    boldItalic: 'Bold Italic',
    predefined: 'Predefined',
    fillOpacity: 'Fill Opacity',
    strokeColor: 'Line Color',
    strokeOpacity: 'Line Opacity',
    miniChart: 'Mini-Chart',
    histogramBinCount: 'Bin count',
    connectorLine: 'Connector Line',
    seriesItems: 'Series Items',
    seriesItemType: 'Item Type',
    seriesItemPositive: 'Positive',
    seriesItemNegative: 'Negative',
    seriesItemLabels: 'Item Labels',
    columnGroup: 'Column',
    barGroup: 'Bar',
    pieGroup: 'Pie',
    lineGroup: 'Line',
    scatterGroup: 'X Y (Scatter)',
    areaGroup: 'Area',
    polarGroup: 'Polar',
    statisticalGroup: 'Statistical',
    hierarchicalGroup: 'Hierarchical',
    specializedGroup: 'Specialized',
    combinationGroup: 'Combination',
    groupedColumnTooltip: 'Grouped',
    stackedColumnTooltip: 'Stacked',
    normalizedColumnTooltip: '100% Stacked',
    groupedBarTooltip: 'Grouped',
    stackedBarTooltip: 'Stacked',
    normalizedBarTooltip: '100% Stacked',
    pieTooltip: 'Pie',
    donutTooltip: 'Donut',
    lineTooltip: 'Line',
    stackedLineTooltip: 'Stacked',
    normalizedLineTooltip: '100% Stacked',
    groupedAreaTooltip: 'Area',
    stackedAreaTooltip: 'Stacked',
    normalizedAreaTooltip: '100% Stacked',
    scatterTooltip: 'Scatter',
    bubbleTooltip: 'Bubble',
    histogramTooltip: 'Histogram',
    radialColumnTooltip: 'Radial Column',
    radialBarTooltip: 'Radial Bar',
    radarLineTooltip: 'Radar Line',
    radarAreaTooltip: 'Radar Area',
    nightingaleTooltip: 'Nightingale',
    rangeBarTooltip: 'Range Bar',
    rangeAreaTooltip: 'Range Area',
    boxPlotTooltip: 'Box Plot',
    treemapTooltip: 'Treemap',
    sunburstTooltip: 'Sunburst',
    waterfallTooltip: 'Waterfall',
    heatmapTooltip: 'Heatmap',
    columnLineComboTooltip: 'Column & Line',
    areaColumnComboTooltip: 'Area & Column',
    customComboTooltip: 'Custom Combination',
    innerRadius: 'Inner Radius',
    startAngle: 'Start Angle',
    endAngle: 'End Angle',
    reverseDirection: 'Reverse Direction',
    groupPadding: 'Group Padding',
    seriesPadding: 'Series Padding',
    tile: 'Tile',
    whisker: 'Whisker',
    cap: 'Cap',
    capLengthRatio: 'Length Ratio',
    labelPlacement: 'Placement',
    inside: 'Inside',
    outside: 'Outside',
    noDataToChart: 'No data available to be charted.',
    pivotChartRequiresPivotMode: 'Pivot Chart requires Pivot Mode enabled.',
    chartSettingsToolbarTooltip: 'Menu',
    chartLinkToolbarTooltip: 'Linked to Grid',
    chartUnlinkToolbarTooltip: 'Unlinked from Grid',
    chartDownloadToolbarTooltip: 'Download Chart',
    chartMenuToolbarTooltip: 'Menu',
    chartEdit: 'Edit Chart',
    chartAdvancedSettings: 'Advanced Settings',
    chartLink: 'Link to Grid',
    chartUnlink: 'Unlink from Grid',
    chartDownload: 'Download Chart',
    histogramFrequency: 'Frequency',
    seriesChartType: 'Series Chart Type',
    seriesType: 'Series Type',
    secondaryAxis: 'Secondary Axis',
    seriesAdd: 'Add a series',
    categoryAdd: 'Add a category',
    bar: 'Bar',
    column: 'Column',
    histogram: 'Histogram',
    advancedSettings: 'Advanced Settings',
    direction: 'Direction',
    horizontal: 'Horizontal',
    vertical: 'Vertical',
    seriesGroupType: 'Group Type',
    groupedSeriesGroupType: 'Grouped',
    stackedSeriesGroupType: 'Stacked',
    normalizedSeriesGroupType: '100% Stacked',
    legendEnabled: 'Enabled',
    invalidColor: 'Color value is invalid',
    groupedColumnFull: 'Grouped Column',
    stackedColumnFull: 'Stacked Column',
    normalizedColumnFull: '100% Stacked Column',
    groupedBarFull: 'Grouped Bar',
    stackedBarFull: 'Stacked Bar',
    normalizedBarFull: '100% Stacked Bar',
    stackedAreaFull: 'Stacked Area',
    normalizedAreaFull: '100% Stacked Area',
    stackedLineFull: 'Stacked Line',
    normalizedLineFull: '100% Stacked Line',
    customCombo: 'Custom Combination',
    funnel: 'Funnel',
    coneFunnel: 'Cone Funnel',
    pyramid: 'Pyramid',
    funnelGroup: 'Funnel',
    funnelTooltip: 'Funnel',
    coneFunnelTooltip: 'Cone Funnel',
    pyramidTooltip: 'Pyramid',
    dropOff: 'Drop-Off',
    stageLabels: 'Stage Labels',
    reverse: 'Reverse',
    // menu items
    groupedColumn: 'Grouped',
    stackedColumn: 'Stacked',
    pie: 'Pie',
    donut: 'Donut',
    line: 'Line',
    scatter: 'Scatter',
    bubble: 'Bubble',
    area: 'Area',
    stackedArea: 'Stacked',
    radarLine: 'Radar Line',
    radarArea: 'Radar Area',
    nightingale: 'Nightingale',
    radialColumn: 'Radial Column',
    radialBar: 'Radial Bar',
    boxPlot: 'Box Plot',
    rangeBar: 'Range Bar',
    rangeArea: 'Range Area',
    treemap: 'Treemap',
    sunburst: 'Sunburst',
    waterfall: 'Waterfall',
    heatmap: 'Heatmap',
    columnLineCombo: 'Column & Line',
    AreaColumnCombo: 'Area & Column',
    // aria
    ariaChartMenuClose: 'Close Chart Edit Menu',
    ariaChartSelected: 'Selected',
    // group
    group: 'Group',
    // time formats
    timeFormatSlashesDDMMYYYY: 'DD/MM/YYYY',
    timeFormatSlashesMMDDYYYY: 'MM/DD/YYYY',
    timeFormatSlashesDDMMYY: 'DD/MM/YY',
    timeFormatSlashesMMDDYY: 'MM/DD/YY',
    timeFormatDotsDDMYY: 'DD.M.YY',
    timeFormatDotsMDDYY: 'M.DD.YY',
    timeFormatDashesYYYYMMDD: 'YYYY-MM-DD',
    timeFormatSpacesDDMMMMYYYY: 'DD MMMM YYYY',
    timeFormatHHMMSS: 'HH:MM:SS',
    timeFormatHHMMSSAmPm: 'HH:MM:SS AM/PM',
    // agg funcs
    sum: 'Sum',
    first: 'First',
    last: 'Last',
    min: 'Min',
    max: 'Max',
    count: 'Count',
    avg: 'Average',
};
class ChartTranslationService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'chartTranslation';
    }
    translate(toTranslate) {
        const translate = this.getLocaleTextFunc();
        const defaultTranslation = exports.DEFAULT_CHART_TRANSLATIONS[toTranslate];
        return translate(toTranslate, defaultTranslation);
    }
}
exports.ChartTranslationService = ChartTranslationService;


/***/ }),

/***/ 1480:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.flatMap = exports.partition = void 0;
function partition(items, selector) {
    return items.reduce((groupedItems, item) => {
        const key = selector(item);
        const existingItems = groupedItems.get(key);
        return groupedItems.set(key, existingItems ? [...existingItems, item] : [item]);
    }, new Map());
}
exports.partition = partition;
function flatMap(items, iteratee) {
    return items.reduce((acc, item, index, array) => acc.concat(iteratee(item, index, array)), new Array());
}
exports.flatMap = flatMap;


/***/ }),

/***/ 2753:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getLegacyAxisType = exports.ALL_AXIS_TYPES = void 0;
exports.ALL_AXIS_TYPES = ['number', 'category', 'grouped-category', 'log', 'time'];
function getLegacyAxisType(chartType) {
    switch (chartType) {
        case 'bar':
        case 'stackedBar':
        case 'normalizedBar':
            return ['number', 'category'];
        case 'groupedBar':
            return ['number', 'grouped-category'];
        case 'column':
        case 'stackedColumn':
        case 'normalizedColumn':
        case 'line':
        case 'stackedLine':
        case 'normalizedLine':
        case 'area':
        case 'stackedArea':
        case 'normalizedArea':
        case 'histogram':
            return ['category', 'number'];
        case 'groupedColumn':
            return ['grouped-category', 'number'];
        case 'scatter':
        case 'bubble':
            return ['number', 'number'];
        default:
            return undefined;
    }
}
exports.getLegacyAxisType = getLegacyAxisType;


/***/ }),

/***/ 8889:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateCreateParams = exports.validateUpdateParams = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const seriesTypeMapper_1 = __webpack_require__(4237);
const validateIfDefined = (validationFn) => {
    return (value) => {
        if (value == undefined)
            return true;
        return validationFn(value);
    };
};
const isString = (value) => typeof value === 'string';
const isBoolean = (value) => typeof value === 'boolean';
const isValidSeriesChartType = (value) => typeof value === 'object';
const createWarnMessage = (property, expectedType) => (value) => `AG Grid - unable to update chart as invalid params supplied:  \`${property}: ${value}\`, expected ${expectedType}.`;
const createEnterpriseMessage = (feature) => {
    const url = 'https://www.ag-grid.com/javascript-data-grid/integrated-charts-installation/';
    return `${feature} is not supported in AG Charts Community ('ag-charts-enterprise' hasn't been loaded). See ${url} for more details.`;
};
const legacyChartTypes = ['doughnut'];
const baseUpdateChartParams = [
    'type',
    'chartId',
    'chartType',
    'chartThemeName',
    'chartThemeOverrides',
    'unlinkChart',
];
function isValidChartType(value) {
    return !!(0, seriesTypeMapper_1.getSeriesTypeIfExists)(value) || (0, seriesTypeMapper_1.isComboChart)(value);
}
function isLegacyChartType(value) {
    return legacyChartTypes.includes(value);
}
const validateChartType = validateIfDefined((chartType) => {
    if (isValidChartType(chartType))
        return true;
    if (isLegacyChartType(chartType)) {
        const renamedChartType = (0, seriesTypeMapper_1.getCanonicalChartType)(chartType);
        (0, ag_grid_community_1._warnOnce)(`The chart type '${chartType}' has been deprecated. Please use '${renamedChartType}' instead.`);
        return renamedChartType;
    }
    return false;
});
const validateAgChartThemeOverrides = validateIfDefined((themeOverrides) => {
    // ensure supplied AgChartThemeOverrides is an object - can be improved if necessary?
    return typeof themeOverrides === 'object';
});
const validateChartParamsCellRange = validateIfDefined((cellRange) => {
    // ensure supplied ChartParamsCellRange is an object - can be improved if necessary?
    return typeof cellRange === 'object';
});
const validateAggFunc = validateIfDefined((aggFunc) => {
    // ensure supplied aggFunc is a `string` or `function` - can be improved if necessary?
    return typeof aggFunc === 'string' || typeof aggFunc === 'function';
});
const enterpriseChartTypeValidation = (isEnterprise) => ({
    property: 'chartType',
    validationFn: validateIfDefined((chartType) => isEnterprise || !chartType || !(0, seriesTypeMapper_1.isEnterpriseChartType)(chartType)),
    warnMessage: (chartType) => createEnterpriseMessage(`The '${chartType}' chart type`),
});
const switchCategorySeriesValidation = (isEnterprise) => ({
    property: 'switchCategorySeries',
    validationFn: validateIfDefined((switchCategorySeries) => {
        if (!switchCategorySeries || isEnterprise) {
            return true;
        }
        return undefined;
    }),
    warnMessage: () => createEnterpriseMessage(`'switchCategorySeries' has been ignored as it`),
    warnIfFixed: true,
});
const commonUpdateValidations = () => [
    { property: 'chartId', validationFn: isString, warnMessage: createWarnMessage('chartId', 'string') },
    {
        property: 'chartType',
        validationFn: validateChartType,
        warnMessage: createWarnMessage('chartType', 'ChartType'),
    },
    {
        property: 'chartThemeName',
        validationFn: isString,
        warnMessage: createWarnMessage('chartThemeName', 'string'),
    },
    {
        property: 'chartThemeOverrides',
        validationFn: validateAgChartThemeOverrides,
        warnMessage: createWarnMessage('chartThemeOverrides', 'AgChartThemeOverrides'),
    },
    { property: 'unlinkChart', validationFn: isBoolean, warnMessage: createWarnMessage('unlinkChart', 'boolean') },
];
const cellRangeValidations = (isEnterprise) => [
    {
        property: 'cellRange',
        validationFn: validateChartParamsCellRange,
        warnMessage: createWarnMessage('cellRange', 'ChartParamsCellRange'),
    },
    {
        property: 'suppressChartRanges',
        validationFn: isBoolean,
        warnMessage: createWarnMessage('suppressChartRanges', 'boolean'),
    },
    {
        property: 'aggFunc',
        validationFn: validateAggFunc,
        warnMessage: createWarnMessage('aggFunc', 'string or IAggFunc'),
    },
    switchCategorySeriesValidation(isEnterprise),
];
function validateUpdateParams(params, isEnterprise) {
    const paramsToValidate = params;
    switch (paramsToValidate.type) {
        case 'rangeChartUpdate':
            return validateUpdateRangeChartParams(params, isEnterprise);
        case 'pivotChartUpdate':
            return validateUpdatePivotChartParams(params);
        case 'crossFilterChartUpdate':
            return validateUpdateCrossFilterChartParams(params, isEnterprise);
        default:
            (0, ag_grid_community_1._warnOnce)(`Invalid value supplied for 'type': ${params.type}. It must be either 'rangeChartUpdate', 'pivotChartUpdate', or 'crossFilterChartUpdate'.`);
            return false;
    }
}
exports.validateUpdateParams = validateUpdateParams;
function validateCreateParams(params, isEnterprise) {
    return validateProperties(params, [
        enterpriseChartTypeValidation(isEnterprise),
        switchCategorySeriesValidation(isEnterprise),
    ]);
}
exports.validateCreateParams = validateCreateParams;
function validateUpdateRangeChartParams(params, isEnterprise) {
    const validations = [
        ...commonUpdateValidations(),
        enterpriseChartTypeValidation(isEnterprise),
        ...cellRangeValidations(isEnterprise),
        {
            property: 'seriesChartTypes',
            validationFn: (value) => value === undefined || (Array.isArray(value) && value.every(isValidSeriesChartType)),
            warnMessage: createWarnMessage('seriesChartTypes', 'Array of SeriesChartType'),
        },
    ];
    return validateProperties(params, validations, [
        ...baseUpdateChartParams,
        'cellRange',
        'suppressChartRanges',
        'switchCategorySeries',
        'aggFunc',
        'seriesChartTypes',
        'seriesGroupType',
    ], 'UpdateRangeChartParams');
}
function validateUpdatePivotChartParams(params) {
    const validations = [...commonUpdateValidations()];
    return validateProperties(params, validations, [...baseUpdateChartParams], 'UpdatePivotChartParams');
}
function validateUpdateCrossFilterChartParams(params, isEnterprise) {
    const validations = [
        ...commonUpdateValidations(),
        ...cellRangeValidations(isEnterprise),
    ];
    return validateProperties(params, validations, [...baseUpdateChartParams, 'cellRange', 'suppressChartRanges', 'aggFunc'], 'UpdateCrossFilterChartParams');
}
function validateProperties(params, validations, validPropertyNames, paramsType) {
    let validatedProperties = undefined;
    for (const validation of validations) {
        const { property, validationFn, warnMessage, warnIfFixed } = validation;
        if (property in params) {
            const value = params[property];
            const validationResult = validationFn(value);
            if (validationResult === true)
                continue;
            if (validationResult === false) {
                (0, ag_grid_community_1._warnOnce)(warnMessage(value));
                return false;
            }
            // If the validation function returned a 'fix' value, we need to return an updated property set.
            // First we clone the input set if there has not been a 'fix' encountered in a previous iteration:
            validatedProperties = validatedProperties || { ...params };
            /// Then we update the cloned object with the 'fixed' value
            validatedProperties[property] = validationResult;
            if (warnIfFixed) {
                (0, ag_grid_community_1._warnOnce)(warnMessage(value));
            }
        }
    }
    if (validPropertyNames) {
        // Check for unexpected properties
        for (const property of Object.keys(params)) {
            if (!validPropertyNames.includes(property)) {
                (0, ag_grid_community_1._warnOnce)(`Unexpected property supplied. ${paramsType} does not contain: \`${property}\`.`);
                return false;
            }
        }
    }
    // If one or more 'fixed' values were encountered, return the updated property set
    if (validatedProperties)
        return validatedProperties;
    return true;
}


/***/ }),

/***/ 3610:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.hexToRGBA = void 0;
function hexToRGBA(hex, alpha) {
    const r = parseInt(hex.slice(1, 3), 16);
    const g = parseInt(hex.slice(3, 5), 16);
    const b = parseInt(hex.slice(5, 7), 16);
    return alpha ? `rgba(${r}, ${g}, ${b}, ${alpha})` : `rgba(${r}, ${g}, ${b})`;
}
exports.hexToRGBA = hexToRGBA;


/***/ }),

/***/ 9687:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.deproxy = void 0;
function deproxy(chartOrProxy) {
    if (chartOrProxy.chart != null) {
        return chartOrProxy.chart;
    }
    return chartOrProxy;
}
exports.deproxy = deproxy;


/***/ }),

/***/ 2210:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.set = exports.get = void 0;
function get(source, expression, defaultValue) {
    if (source == null) {
        return defaultValue;
    }
    const keys = expression.split('.');
    let objectToRead = source;
    while (keys.length > 1) {
        objectToRead = objectToRead[keys.shift()];
        if (objectToRead == null) {
            return defaultValue;
        }
    }
    const value = objectToRead[keys[0]];
    return value != null ? value : defaultValue;
}
exports.get = get;
function set(target, expression, value) {
    if (target == null) {
        return;
    }
    const keys = expression.split('.');
    let objectToUpdate = target;
    // Create empty objects
    keys.forEach((key, i) => {
        if (!objectToUpdate[key]) {
            objectToUpdate[key] = {};
        }
        if (i < keys.length - 1) {
            objectToUpdate = objectToUpdate[key];
        }
    });
    objectToUpdate[keys[keys.length - 1]] = value;
}
exports.set = set;


/***/ }),

/***/ 4237:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getFullChartNameTranslationKey = exports.canSwitchDirection = exports.supportsInvertedCategorySeries = exports.getMaxNumSeries = exports.getMaxNumCategories = exports.isPieChartSeries = exports.getSeriesType = exports.getSeriesTypeIfExists = exports.getCanonicalChartType = exports.isHierarchical = exports.isRadial = exports.isPolar = exports.isFunnel = exports.isCartesian = exports.isStacked = exports.isEnterpriseChartType = exports.isComboChart = exports.isSeriesType = exports.SERIES_GROUP_TYPES = void 0;
const CHART_TYPE_TO_SERIES_TYPE = {
    column: 'bar',
    groupedColumn: 'bar',
    stackedColumn: 'bar',
    normalizedColumn: 'bar',
    bar: 'bar',
    groupedBar: 'bar',
    stackedBar: 'bar',
    normalizedBar: 'bar',
    line: 'line',
    stackedLine: 'line',
    normalizedLine: 'line',
    scatter: 'scatter',
    bubble: 'bubble',
    pie: 'pie',
    donut: 'donut',
    doughnut: 'donut',
    area: 'area',
    stackedArea: 'area',
    normalizedArea: 'area',
    histogram: 'histogram',
    radarLine: 'radar-line',
    radarArea: 'radar-area',
    nightingale: 'nightingale',
    radialColumn: 'radial-column',
    radialBar: 'radial-bar',
    sunburst: 'sunburst',
    rangeBar: 'range-bar',
    rangeArea: 'range-area',
    boxPlot: 'box-plot',
    treemap: 'treemap',
    heatmap: 'heatmap',
    waterfall: 'waterfall',
    funnel: 'funnel',
    coneFunnel: 'cone-funnel',
    pyramid: 'pyramid',
};
const COMBO_CHART_TYPES = new Set(['columnLineCombo', 'areaColumnCombo', 'customCombo']);
exports.SERIES_GROUP_TYPES = ['grouped', 'stacked', 'normalized'];
const SERIES_TYPES = {
    area: {
        isCartesian: true,
        canInvert: true,
    },
    bar: {
        isCartesian: true,
        canInvert: true,
    },
    histogram: {
        isCartesian: true,
    },
    line: {
        isCartesian: true,
        canInvert: true,
    },
    pie: {
        isPie: true,
    },
    donut: {
        isPie: true,
        canInvert: true,
    },
    scatter: {
        isCartesian: true,
    },
    bubble: {
        isCartesian: true,
    },
    'radial-column': {
        isPolar: true,
        isEnterprise: true,
        isRadial: true,
        canInvert: true,
    },
    'radial-bar': {
        isPolar: true,
        isEnterprise: true,
        isRadial: true,
        canInvert: true,
    },
    'radar-line': {
        isPolar: true,
        isEnterprise: true,
        canInvert: true,
    },
    'radar-area': {
        isPolar: true,
        isEnterprise: true,
        canInvert: true,
    },
    nightingale: {
        isPolar: true,
        isEnterprise: true,
        canInvert: true,
    },
    'range-bar': {
        isCartesian: true,
        isEnterprise: true,
        canSwitchDirection: true,
    },
    'range-area': {
        isCartesian: true,
        isEnterprise: true,
    },
    'box-plot': {
        isCartesian: true,
        isEnterprise: true,
        canSwitchDirection: true,
    },
    treemap: {
        isEnterprise: true,
        isHierarchical: true,
    },
    sunburst: {
        isEnterprise: true,
        isHierarchical: true,
    },
    heatmap: {
        isCartesian: true,
        isEnterprise: true,
    },
    waterfall: {
        isCartesian: true,
        isEnterprise: true,
        canSwitchDirection: true,
    },
    funnel: {
        isCartesian: true,
        isEnterprise: true,
        canSwitchDirection: true,
    },
    'cone-funnel': {
        isCartesian: true,
        isEnterprise: true,
        canSwitchDirection: true,
    },
    pyramid: {
        isCartesian: true,
        isEnterprise: true,
        canSwitchDirection: true,
    },
};
function isSeriesType(seriesType) {
    return !!SERIES_TYPES[seriesType];
}
exports.isSeriesType = isSeriesType;
function isComboChart(chartType) {
    return COMBO_CHART_TYPES.has(chartType);
}
exports.isComboChart = isComboChart;
function doesSeriesHaveProperty(seriesType, prop) {
    return !!SERIES_TYPES[seriesType]?.[prop];
}
function isEnterpriseChartType(chartType) {
    return doesSeriesHaveProperty(getSeriesType(chartType), 'isEnterprise');
}
exports.isEnterpriseChartType = isEnterpriseChartType;
const stackedChartTypes = new Set(['stackedColumn', 'normalizedColumn', 'stackedBar', 'normalizedBar']);
function isStacked(chartType) {
    return stackedChartTypes.has(chartType);
}
exports.isStacked = isStacked;
function isCartesian(seriesType) {
    return doesSeriesHaveProperty(seriesType, 'isCartesian');
}
exports.isCartesian = isCartesian;
function isFunnel(seriesType) {
    return seriesType === 'funnel' || seriesType === 'cone-funnel' || seriesType === 'pyramid';
}
exports.isFunnel = isFunnel;
function isPolar(seriesType) {
    return doesSeriesHaveProperty(seriesType, 'isPolar');
}
exports.isPolar = isPolar;
function isRadial(seriesType) {
    return doesSeriesHaveProperty(seriesType, 'isRadial');
}
exports.isRadial = isRadial;
function isHierarchical(seriesType) {
    return doesSeriesHaveProperty(seriesType, 'isHierarchical');
}
exports.isHierarchical = isHierarchical;
function getCanonicalChartType(chartType) {
    return chartType === 'doughnut' ? 'donut' : chartType;
}
exports.getCanonicalChartType = getCanonicalChartType;
function getSeriesTypeIfExists(chartType) {
    return CHART_TYPE_TO_SERIES_TYPE[chartType];
}
exports.getSeriesTypeIfExists = getSeriesTypeIfExists;
function getSeriesType(chartType) {
    return getSeriesTypeIfExists(chartType) ?? 'line';
}
exports.getSeriesType = getSeriesType;
function isPieChartSeries(seriesType) {
    return doesSeriesHaveProperty(seriesType, 'isPie');
}
exports.isPieChartSeries = isPieChartSeries;
function canOnlyHaveSingleSeries(chartType) {
    return (chartType === 'pie' ||
        chartType === 'waterfall' ||
        chartType === 'histogram' ||
        chartType === 'funnel' ||
        chartType === 'coneFunnel' ||
        chartType === 'pyramid');
}
function getMaxNumCategories(chartType) {
    return isHierarchical(getSeriesType(chartType)) ? undefined : 1;
}
exports.getMaxNumCategories = getMaxNumCategories;
function getMaxNumSeries(chartType) {
    if (isHierarchical(getSeriesType(chartType))) {
        return 2;
    }
    else if (canOnlyHaveSingleSeries(chartType)) {
        return 1;
    }
    else {
        return undefined;
    }
}
exports.getMaxNumSeries = getMaxNumSeries;
function supportsInvertedCategorySeries(chartType) {
    return !isComboChart(chartType) && doesSeriesHaveProperty(getSeriesType(chartType), 'canInvert');
}
exports.supportsInvertedCategorySeries = supportsInvertedCategorySeries;
function canSwitchDirection(chartType) {
    return doesSeriesHaveProperty(getSeriesType(chartType), 'canSwitchDirection');
}
exports.canSwitchDirection = canSwitchDirection;
function getFullChartNameTranslationKey(chartType) {
    switch (chartType) {
        case 'groupedColumn':
        case 'stackedColumn':
        case 'normalizedColumn':
        case 'groupedBar':
        case 'stackedBar':
        case 'normalizedBar':
        case 'stackedLine':
        case 'normalizedLine':
        case 'stackedArea':
        case 'normalizedArea':
            return `${chartType}Full`;
        case 'doughnut':
            return 'donut';
        case 'areaColumnCombo':
            return 'AreaColumnCombo';
        default:
            return chartType;
    }
}
exports.getFullChartNameTranslationKey = getFullChartNameTranslationKey;


/***/ }),

/***/ 6476:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.heuristicVersionDetection = exports.upgradeChartModel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const version_1 = __webpack_require__(7205);
const axisTypeMapper_1 = __webpack_require__(2753);
const seriesTypeMapper_1 = __webpack_require__(4237);
const DEBUG = false;
function upgradeChartModel(model) {
    const originalVersion = model.version;
    if (model.version == null) {
        // Try to guess the version so we can apply the right subset of migrations.
        model.version = heuristicVersionDetection(model);
    }
    model = migrateIfBefore('23.0.0', model, migrateV23);
    model = migrateIfBefore('24.0.0', model, migrateV24);
    model = migrateIfBefore('25.1.0', model, migrateV25_1);
    model = migrateIfBefore('26.0.0', model, migrateV26);
    model = migrateIfBefore('26.1.0', model, migrateV26_1);
    // Switch from iChartOptions to iAgChartOptions....
    model = migrateIfBefore('26.2.0', model, migrateV26_2);
    model = migrateIfBefore('28.0.0', model, migrateV28);
    model = migrateIfBefore('28.2.0', model, migrateV28_2);
    model = migrateIfBefore('29.0.0', model, migrateV29);
    model = migrateIfBefore('29.1.0', model, migrateV29_1);
    model = migrateIfBefore('29.2.0', model, migrateV29_2);
    model = migrateIfBefore('30.0.0', model, migrateV30);
    model = migrateIfBefore('31.0.0', model, migrateV31);
    model = migrateIfBefore('32.0.0', model, migrateV32);
    model = migrateIfBefore('33.0.0', model, migrateV33);
    model = cleanup(model);
    // Bump version to latest.
    model = migrateIfBefore(version_1.VERSION, model, (m) => m);
    if (DEBUG && originalVersion !== model.version) {
        // eslint-disable-next-line no-console
        console.log('AG Grid: ChartModel migration complete', { model });
    }
    return model;
}
exports.upgradeChartModel = upgradeChartModel;
function migrateV23(model) {
    // https://github.com/ag-grid/ag-grid/commit/76c6744ff2b732d298d1ade73c122188854b5bac
    model = jsonRename('chartOptions.legend.item.marker.type', 'shape', model);
    model = jsonRename('chartOptions.seriesDefaults.marker.type', 'shape', model);
    // https://github.com/ag-grid/ag-grid/commit/7bdf2cfd666acda758a818733a9f9cb35ac1d7a7
    model = jsonRename('chartOptions.legend.padding', 'spacing', model);
    return model;
}
function migrateV24(model) {
    // https://github.com/ag-grid/ag-grid/commit/f4e854e3dc459400fa00e6da2873cb8e9cfff6fe#
    model = jsonDelete('chartOptions.seriesDefaults.marker.minSize', model);
    const { chartType, chartPalette, // Migrate.
    chartOptions: { xAxis, yAxis, ...chartOptions }, ...chartModel } = model;
    const axesTypes = (0, axisTypeMapper_1.getLegacyAxisType)(chartType);
    const axes = axesTypes?.map((type, i) => ({
        type,
        ...(i === 0 ? xAxis : yAxis),
    }));
    // Precise legacy palette fills/strokes can be found here for future reference:
    // https://github.com/ag-grid/ag-grid/blob/b22.1.0/grid-enterprise-modules/charts/src/charts/chart/palettes.ts
    const LEGACY_PALETTES = {
        borneo: 'ag-default',
        material: 'ag-material',
        bright: 'ag-vivid',
    };
    return {
        chartType,
        chartThemeName: LEGACY_PALETTES[chartPalette] ?? 'ag-default',
        chartOptions: {
            ...chartOptions,
            axes,
            xAxis,
            yAxis,
        },
        ...chartModel,
    };
}
function migrateV25_1(model) {
    // https://github.com/ag-grid/ag-grid/commit/61943f9fecbfb5ac1b9a1fd93788f9fdd8687181
    model = jsonRename('chartOptions.seriesDefaults.label.minRequiredAngle', 'minAngle', model);
    return model;
}
function migrateV26(model) {
    // https://github.com/ag-grid/ag-grid/commit/df2445d88e64cb4e831d6163104a0fa60ccde3b5
    const highlightOptUpdate = ({ dimOpacity, ...opts }) => ({
        ...opts,
        ...(dimOpacity != null ? { series: { dimOpacity } } : {}),
    });
    model = jsonMutate('chartOptions.seriesDefaults.highlightStyle', model, highlightOptUpdate);
    // https://github.com/ag-grid/ag-grid/commit/f4e854e3dc459400fa00e6da2873cb8e9cfff6fe#
    model = jsonDelete('chart', model);
    model = jsonDelete('chartOptions.seriesDefaults.tooltipClass', model);
    model = jsonDelete('chartOptions.seriesDefaults.tooltipTracking', model);
    // Cleanup label.rotation === 0, which was treated as 'use the default' on reload prior to 26.
    model = jsonDeleteDefault('chartOptions.axes[].label.rotation', 0, model);
    model = jsonDeleteDefault('chartOptions.axes[].label.rotation', 335, model);
    return model;
}
function migrateV26_1(model) {
    // https://github.com/ag-grid/ag-grid/commit/df2445d88e64cb4e831d6163104a0fa60ccde3b5
    const highlightOptUpdate = ({ item, series, ...opts }) => ({
        item: { ...opts, ...item },
        ...(series ? { series } : {}),
    });
    model = jsonMutate('chartOptions.seriesDefaults.highlightStyle', model, highlightOptUpdate);
    model = jsonMutate('chartOptions.series[].highlightStyle', model, highlightOptUpdate);
    return model;
}
function migrateV26_2(model) {
    // https://github.com/ag-grid/ag-grid/commit/8b2e223cb1a687cb6c1d70b9f75f52fa29d00341
    model = jsonMove('chartOptions.seriesDefaults.fill.opacity', 'chartOptions.seriesDefaults.fillOpacity', model);
    model = jsonMove('chartOptions.seriesDefaults.stroke.opacity', 'chartOptions.seriesDefaults.strokeOpacity', model);
    model = jsonMove('chartOptions.seriesDefaults.stroke.width', 'chartOptions.seriesDefaults.strokeWidth', model);
    model = jsonDelete('chartOptions.seriesDefaults.fill', model);
    model = jsonDelete('chartOptions.seriesDefaults.stroke', model);
    model = jsonDelete('chartOptions.seriesDefaults.callout.colors', model);
    model = jsonDelete('chartOptions.xAxis', model);
    model = jsonDelete('chartOptions.yAxis', model);
    const { chartType: providedChartType, 
    // disable no-unused-vars because `series` is required here, even though
    // unused, because it serves to take the `series` key out of otherChartOptions
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    chartOptions: { axes, series, seriesDefaults, ...otherChartOptions }, ...otherModelProps } = model;
    // At 26.2.0 combination charts weren't supported, so we can safely assume a single series type.
    // We can't rely on the `series.type` field as it was incorrect (in v25.0.0 line chart has an
    // `area` series).
    // Note that in v31.1.0, the canonical name for the 'doughnut' chart type changed to 'donut'.
    const chartType = (0, seriesTypeMapper_1.getCanonicalChartType)(providedChartType);
    const seriesType = (0, seriesTypeMapper_1.getSeriesType)(chartType);
    const seriesTypes = [seriesType];
    const chartTypeMixin = {};
    if (!(0, seriesTypeMapper_1.isPieChartSeries)(seriesType)) {
        const minimalAxis = { top: {}, bottom: {}, left: {}, right: {} };
        const updatedAxes = axes
            .map(({ type, ...axisProps }) => ({
            [type]: { ...minimalAxis, ...axisProps },
        }))
            .reduce(merge, {});
        axisTypeMapper_1.ALL_AXIS_TYPES.filter((v) => updatedAxes[v] == null).forEach((v) => {
            updatedAxes[v] = { ...minimalAxis };
        });
        chartTypeMixin.axes = updatedAxes;
    }
    const updatedChartOptions = seriesTypes
        .map((t) => ({
        [t]: {
            ...chartTypeMixin,
            series: seriesDefaults,
            ...otherChartOptions,
        },
    }))
        .reduce(merge, {});
    model = {
        ...otherModelProps,
        chartType,
        chartOptions: updatedChartOptions,
    };
    return model;
}
function migrateV28(model) {
    model = jsonDelete('chartOptions.*.title.padding', model);
    model = jsonDelete('chartOptions.*.subtitle.padding', model);
    model = jsonDelete('chartOptions.*.axes.*.title.padding', model);
    model = jsonBackfill('chartOptions.*.axes.*.title.enabled', false, model);
    return model;
}
function migrateV28_2(model) {
    model = jsonRename('chartOptions.pie.series.callout', 'calloutLine', model);
    model = jsonRename('chartOptions.pie.series.label', 'calloutLabel', model);
    model = jsonRename('chartOptions.pie.series.labelKey', 'sectorLabelKey', model);
    model = jsonRename('chartOptions.pie.series.labelName', 'sectorLabelName', model);
    model = jsonRename('chartOptions.donut.series.callout', 'calloutLine', model);
    model = jsonRename('chartOptions.donut.series.label', 'calloutLabel', model);
    model = jsonRename('chartOptions.donut.series.labelKey', 'sectorLabelKey', model);
    model = jsonRename('chartOptions.donut.series.labelName', 'sectorLabelName', model);
    // series.yKeys => yKey ?
    // series.yNames => yName ?
    return model;
}
function migrateV29(model) {
    model = jsonMoveIfMissing('chartOptions.scatter.series.fill', 'chartOptions.scatter.series.marker.fill', model);
    model = jsonMoveIfMissing('chartOptions.scatter.series.fillOpacity', 'chartOptions.scatter.series.marker.fillOpacity', model);
    model = jsonMoveIfMissing('chartOptions.scatter.series.stroke', 'chartOptions.scatter.series.marker.stroke', model);
    model = jsonMoveIfMissing('chartOptions.scatter.series.strokeOpacity', 'chartOptions.scatter.series.marker.strokeOpacity', model);
    model = jsonMoveIfMissing('chartOptions.scatter.series.strokeWidth', 'chartOptions.scatter.series.marker.strokeWidth', model);
    model = jsonMove('chartOptions.scatter.series.paired', 'chartOptions.scatter.paired', model);
    return model;
}
function migrateV29_1(model) {
    model = jsonDelete('chartOptions.axes[].tick.count', model);
    return model;
}
function migrateV29_2(model) {
    // https://github.com/ag-grid/ag-grid/commit/ce11956492e42e845932edb4e05d7b0b21db5c61
    const tooltipOptUpdate = ({ tracking, ...opts }) => {
        const output = { ...opts };
        if (tracking === false) {
            output.position ?? (output.position = { type: 'pointer' });
            output.range ?? (output.range = 'nearest');
        }
        else if (tracking === true) {
            output.position ?? (output.position = { type: 'node' });
            output.range ?? (output.range = 'nearest');
        }
        return output;
    };
    model = jsonMutate('chartOptions.*.tooltip', model, tooltipOptUpdate);
    return model;
}
function migrateV30(model) {
    // Repeated from migrateV28_2() as they were applied retrospectively for the v30 release.
    model = jsonRename('chartOptions.pie.series.labelKey', 'sectorLabelKey', model);
    model = jsonRename('chartOptions.pie.series.labelName', 'sectorLabelName', model);
    // Late-applied migrations for deprecations in the 29.x.y range.
    model = migrateV29_1(model);
    model = migrateV29_2(model);
    // Actual v30 changes.
    model = jsonDelete('chartOptions.*.series.flipXY', model);
    model = jsonAdd('chartOptions.common.legend.enabled', true, model);
    model = jsonBackfill('chartOptions.common.legend.position', 'right', model);
    return model;
}
function migrateV31(model) {
    const V30_LEGACY_PALETTES = {
        'ag-pastel': 'ag-sheets',
        'ag-solar': 'ag-polychroma',
    };
    const updatedModel = jsonRename('chartOptions.column', 'bar', model);
    const chartThemeName = V30_LEGACY_PALETTES[updatedModel.chartThemeName] || updatedModel.chartThemeName;
    return {
        ...updatedModel,
        chartThemeName,
    };
}
function migrateV32(model) {
    model = jsonMutateProperty('chartOptions.*.autoSize', true, model, (parent, targetProp) => {
        if (parent[targetProp] === true) {
            // autoSize: true was the OOB default, so just use the new OOB default baked-in.
        }
        else if (parent[targetProp] === false) {
            // Fallback to legacy Charts defaults for autoSize: false.
            parent['minHeight'] = 600;
            parent['minWidth'] = 300;
        }
        delete parent[targetProp];
    });
    return model;
}
function migrateV33(model) {
    model = jsonDelete('chartOptions.*.axes.category.label.format', model);
    model = jsonDelete('chartOptions.*.axes.category.crosshair.label.format', model);
    model = jsonDelete('chartOptions.*.axes.angle-category.label.format', model);
    model = jsonDelete('chartOptions.*.axes.radius-category.label.format', model);
    model = jsonRename('chartOptions.*.axes.*.label.padding', 'spacing', model);
    model = jsonRename('chartOptions.*.navigator.miniChart.label.padding', 'spacing', model);
    model = jsonDelete('chartOptions.*.axes.*.crossLines.label.className', model);
    model = jsonMutateProperty('chartOptions.*.axes.*.crossLines.label.position', true, model, (parent, targetProp) => {
        if (typeof parent[targetProp] === 'string') {
            parent[targetProp] = parent[targetProp].replace(/([A-Z])/, '-$1').toLowerCase();
        }
    });
    model = jsonDelete('chartOptions.bullet', model);
    model = jsonRenameEnumValues('chartOptions.bar.series.label.placement', model, {
        inside: 'inside-center',
        outside: 'inside-end',
    });
    model = jsonRenameEnumValues('chartOptions.waterfall.series.item.*.label.placement', model, {
        inside: 'inside-center',
        start: 'outside-start',
        end: 'outside-end',
    });
    model = jsonDelete('chartOptions.*.navigator.min', model);
    model = jsonDelete('chartOptions.*.navigator.max', model);
    model = jsonDelete('chartOptions.*.zoom.ratioX', model);
    model = jsonDelete('chartOptions.*.zoom.ratioY', model);
    model = jsonDelete('chartOptions.*.zoom.rangeX', model);
    model = jsonDelete('chartOptions.*.zoom.rangeY', model);
    return model;
}
function cleanup(model) {
    // Remove fixed width/height - this has never been supported via UI configuration.
    model = jsonDelete('chartOptions.*.width', model);
    model = jsonDelete('chartOptions.*.height', model);
    model = jsonBackfill('chartOptions.*.axes.category.label.autoRotate', true, model);
    return model;
}
function heuristicVersionDetection(model) {
    const modelAny = model;
    if (model.version != null) {
        return model.version;
    }
    const hasKey = (obj, ...keys) => {
        return Object.keys(obj || {}).some((k) => keys.includes(k));
    };
    const chartOptions = modelAny.chartOptions;
    const seriesOptions = hasKey(chartOptions, 'seriesDefaults')
        ? chartOptions?.seriesDefaults
        : chartOptions?.[Object.keys(chartOptions)[0]];
    const hints = {
        '27.0.0': hasKey(modelAny, 'seriesChartTypes'),
        '26.2.0': !hasKey(chartOptions, 'seriesDefaults'),
        '26.1.0': hasKey(seriesOptions?.highlightStyle, 'item'),
        '26.0.0': hasKey(seriesOptions?.highlightStyle, 'series'),
        // '26.0.0': modelAny.chart === undefined,
        '25.1.0': hasKey(seriesOptions?.label, 'minAngle'),
        '25.0.0': hasKey(modelAny, 'modelType', 'aggFunc', 'unlinkChart', 'suppressChartRanges') ||
            hasKey(seriesOptions, 'lineDash', 'lineDashOffset'),
        '24.0.0': hasKey(modelAny, 'chartThemeName', 'chart') || hasKey(chartOptions, 'series'),
        '23.2.0': hasKey(chartOptions, 'navigator'),
        '23.0.0': hasKey(chartOptions?.legend?.item?.marker, 'shape'),
        '22.1.0': hasKey(modelAny, 'chartPalette', 'chartType'),
    };
    // Default to 27.1.0, the last version before we added `version`.
    const defaultVersion = '27.1.0';
    // eslint-disable-next-line no-restricted-properties
    const matchingHints = Object.entries(hints).filter(([_, match]) => match);
    // eslint-disable-next-line no-console
    if (DEBUG)
        console.log('AG Grid: ChartModel migration', { heuristicVersionCandidates: matchingHints });
    const [heuristicVersion = defaultVersion] = matchingHints[0];
    // eslint-disable-next-line no-console
    if (DEBUG)
        console.log('AG Grid: ChartModel migration', { heuristicVersion });
    return heuristicVersion;
}
exports.heuristicVersionDetection = heuristicVersionDetection;
function migrateIfBefore(maxVersion, model, migration) {
    if (versionNumber(maxVersion) > versionNumber(model.version)) {
        // eslint-disable-next-line no-console
        if (DEBUG)
            console.log('AG Grid: ChartModel migration', { migratingTo: maxVersion });
        const result = migration(model);
        result.version = maxVersion;
        // eslint-disable-next-line no-console
        if (DEBUG)
            console.log('AG Grid: ChartModel migration', { migratedTo: maxVersion, result });
        return result;
    }
    return model;
}
function versionParts(versionRaw) {
    const version = versionRaw.includes('-beta') ? versionRaw.replace(/-beta.*/, '') : versionRaw;
    const split = typeof version === 'string' ? version.split('.').map((v) => Number(v)) : [];
    if (split.length !== 3 || split.some((v) => isNaN(v))) {
        throw new Error((0, ag_grid_community_1._errMsg)(253, { version }));
    }
    return {
        major: split[0],
        minor: split[1],
        patch: split[2],
    };
}
function versionNumber(version) {
    const { major, minor, patch } = versionParts(version);
    // Return a number of the form MMmmPP.
    return major * 10000 + minor * 100 + patch;
}
function jsonDeleteDefault(path, defaultValue, json) {
    return jsonMutateProperty(path, true, json, (parent, prop) => {
        if (parent[prop] === defaultValue) {
            delete parent[prop];
        }
    });
}
function jsonBackfill(path, defaultValue, json) {
    return jsonMutateProperty(path, false, json, (parent, prop) => {
        if (parent[prop] == null) {
            parent[prop] = defaultValue;
        }
    });
}
function jsonAdd(path, value, json) {
    if (typeof path === 'string') {
        path = path.split('.');
    }
    const nextPath = path[0];
    if (path.length > 1) {
        json[nextPath] = jsonAdd(path.slice(1), value, json[nextPath] ?? {});
    }
    const hasProperty = Object.keys(json).includes(nextPath);
    if (!hasProperty) {
        json[nextPath] = value;
    }
    return json;
}
function jsonMove(from, to, json) {
    let valueToMove = undefined;
    let valueFound = false;
    json = jsonMutateProperty(from, true, json, (parent, prop) => {
        valueFound = true;
        valueToMove = parent[prop];
        delete parent[prop];
    });
    if (!valueFound) {
        return json;
    }
    return jsonMutateProperty(to, false, json, (parent, prop) => {
        parent[prop] = valueToMove;
    });
}
function jsonMoveIfMissing(from, to, json) {
    let valueToMove = undefined;
    let valueFound = false;
    json = jsonMutateProperty(from, true, json, (parent, prop) => {
        valueFound = true;
        valueToMove = parent[prop];
        delete parent[prop];
    });
    if (!valueFound) {
        return json;
    }
    return jsonMutateProperty(to, false, json, (parent, prop) => {
        if (parent[prop] === undefined) {
            parent[prop] = valueToMove;
        }
    });
}
function jsonRename(path, renameTo, json) {
    return jsonMutateProperty(path, true, json, (parent, prop) => {
        parent[renameTo] = parent[prop];
        delete parent[prop];
    });
}
function jsonDelete(path, json) {
    return jsonMutateProperty(path, true, json, (parent, prop) => delete parent[prop]);
}
function jsonMutateProperty(path, skipMissing, json, mutator) {
    const pathElements = path instanceof Array ? path : path.split('.');
    const parentPathElements = pathElements.slice(0, pathElements.length - 1);
    const targetName = pathElements[pathElements.length - 1];
    return jsonMutate(parentPathElements, json, (parent) => {
        const hasProperty = Object.keys(parent).includes(targetName);
        if (skipMissing && !hasProperty) {
            return parent;
        }
        const result = { ...parent };
        mutator(result, targetName);
        return result;
    });
}
function jsonMutate(path, json, mutator) {
    const pathElements = path instanceof Array ? path : path.split('.');
    // Clone to avoid mutating original input.
    json = { ...json };
    if (pathElements.length === 0) {
        return mutator(json);
    }
    else if (pathElements[0].startsWith('{')) {
        const pathOptions = pathElements[0].substring(1, pathElements[0].lastIndexOf('}')).split(',');
        for (const pathOption of pathOptions) {
            if (json[pathOption] != null) {
                json[pathOption] = jsonMutate(pathElements.slice(1), json[pathOption], mutator);
            }
        }
    }
    else if (pathElements[0].endsWith('[]')) {
        const arrayName = pathElements[0].substring(0, path[0].indexOf('['));
        if (json[arrayName] instanceof Array) {
            json[arrayName] = json[arrayName].map((v) => jsonMutate(pathElements.slice(1), v, mutator));
        }
    }
    else if (pathElements[0] === '*') {
        for (const jsonProp of Object.keys(json)) {
            json[jsonProp] = jsonMutate(pathElements.slice(1), json[jsonProp], mutator);
        }
    }
    else if (json[pathElements[0]] != null) {
        json[pathElements[0]] = jsonMutate(pathElements.slice(1), json[pathElements[0]], mutator);
    }
    return json;
}
function jsonRenameEnumValues(path, json, values) {
    return jsonMutateProperty(path, true, json, (parent, targetProp) => {
        if (typeof parent[targetProp] === 'string') {
            parent[targetProp] = values[targetProp] ?? targetProp;
        }
    });
}
const merge = (r, n) => ({ ...r, ...n });


/***/ }),

/***/ 100:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChartService = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const version_1 = __webpack_require__(7205);
const gridChartComp_1 = __webpack_require__(7760);
const chartParamsValidator_1 = __webpack_require__(8889);
const seriesTypeMapper_1 = __webpack_require__(4237);
const chartModelMigration_1 = __webpack_require__(6476);
class ChartService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'chartSvc';
        // we destroy all charts bound to this grid when grid is destroyed. activeCharts contains all charts, including
        // those in developer provided containers.
        this.activeCharts = new Set();
        this.activeChartComps = new Set();
        // this shared (singleton) context is used by cross filtering in line and area charts
        this.crossFilteringContext = {
            lastSelectedChartId: '',
        };
        this.isEnterprise = () => this.agChartsExports.isEnterprise;
    }
    wireBeans(beans) {
        this.visibleCols = beans.visibleCols;
        this.rangeSvc = beans.rangeSvc;
        this.agChartsExports = beans.agChartsExports;
    }
    updateChart(params) {
        if (this.activeChartComps.size === 0) {
            (0, ag_grid_community_1._warn)(124);
            return;
        }
        const chartComp = [...this.activeChartComps].find((chartComp) => chartComp.getChartId() === params.chartId);
        if (!chartComp) {
            (0, ag_grid_community_1._warn)(125, { chartId: params.chartId });
            return;
        }
        chartComp.update(params);
    }
    getChartModels() {
        const models = [];
        const versionedModel = (c) => {
            return { ...c, version: version_1.VERSION };
        };
        this.activeChartComps.forEach((c) => models.push(versionedModel(c.getChartModel())));
        return models;
    }
    getChartRef(chartId) {
        let chartRef;
        this.activeCharts.forEach((cr) => {
            if (cr.chartId === chartId) {
                chartRef = cr;
            }
        });
        return chartRef;
    }
    getChartComp(chartId) {
        let chartComp;
        this.activeChartComps.forEach((comp) => {
            if (comp.getChartId() === chartId) {
                chartComp = comp;
            }
        });
        return chartComp;
    }
    getChartImageDataURL(params) {
        let url;
        this.activeChartComps.forEach((c) => {
            if (c.getChartId() === params.chartId) {
                url = c.getChartImageDataURL(params.fileFormat);
            }
        });
        return url;
    }
    downloadChart(params) {
        const chartComp = Array.from(this.activeChartComps).find((c) => c.getChartId() === params.chartId);
        chartComp?.downloadChart(params.dimensions, params.fileName, params.fileFormat);
    }
    openChartToolPanel(params) {
        const chartComp = Array.from(this.activeChartComps).find((c) => c.getChartId() === params.chartId);
        chartComp?.openChartToolPanel(params.panel);
    }
    closeChartToolPanel(chartId) {
        const chartComp = Array.from(this.activeChartComps).find((c) => c.getChartId() === chartId);
        chartComp?.closeChartToolPanel();
    }
    createChartFromCurrentRange(chartType = 'groupedColumn', fromApi) {
        const cellRange = this.getSelectedRange();
        return this.createChart({ cellRange, chartType, focusDialogOnOpen: !fromApi });
    }
    restoreChart(model, chartContainer) {
        if (!model) {
            (0, ag_grid_community_1._warn)(126);
            return;
        }
        if (model.version !== version_1.VERSION) {
            model = (0, chartModelMigration_1.upgradeChartModel)(model);
        }
        let cellRange;
        let pivotChart;
        let suppressChartRanges;
        let chartPaletteToRestore;
        if (model.modelType === 'pivot') {
            // if required enter pivot mode
            this.gos.updateGridOptions({ options: { pivotMode: true }, source: 'pivotChart' });
            cellRange = this.createCellRange(undefined, true);
            pivotChart = true;
            suppressChartRanges = true;
        }
        else {
            cellRange = this.createCellRange(model.cellRange);
            chartPaletteToRestore = model.chartPalette;
            suppressChartRanges = model.suppressChartRanges;
        }
        if (!cellRange) {
            return;
        }
        return this.createChart({
            ...model,
            cellRange,
            pivotChart,
            suppressChartRanges,
            chartContainer,
            chartOptionsToRestore: model.chartOptions,
            chartPaletteToRestore,
        });
    }
    createRangeChart(params, fromApi) {
        const cellRange = this.createCellRange(params.cellRange);
        if (!cellRange) {
            return;
        }
        return this.createChart({
            ...params,
            cellRange,
            focusDialogOnOpen: !fromApi,
        });
    }
    createPivotChart(params, fromApi) {
        // if required enter pivot mode
        this.gos.updateGridOptions({ options: { pivotMode: true }, source: 'pivotChart' });
        const cellRange = this.createCellRange(undefined, true);
        if (!cellRange) {
            return;
        }
        return this.createChart({
            ...params,
            cellRange,
            pivotChart: true,
            suppressChartRanges: true,
            focusDialogOnOpen: !fromApi,
        });
    }
    createCrossFilterChart(params, fromApi) {
        const cellRange = this.createCellRange(params.cellRange);
        if (!cellRange) {
            return;
        }
        const suppressChartRangesSupplied = typeof params.suppressChartRanges !== 'undefined' && params.suppressChartRanges !== null;
        const suppressChartRanges = suppressChartRangesSupplied ? params.suppressChartRanges : true;
        return this.createChart({
            ...params,
            cellRange,
            suppressChartRanges,
            crossFiltering: true,
            focusDialogOnOpen: !fromApi,
        });
    }
    createChart(params) {
        const validationResult = (0, chartParamsValidator_1.validateCreateParams)(params, this.agChartsExports.isEnterprise);
        if (!validationResult) {
            return undefined;
        }
        params = validationResult === true ? params : validationResult;
        const { chartType, chartContainer } = params;
        const createChartContainerFunc = this.gos.getCallback('createChartContainer');
        const gridChartParams = {
            ...params,
            chartId: this.generateId(),
            chartType: (0, seriesTypeMapper_1.getCanonicalChartType)(chartType),
            insideDialog: !(chartContainer || createChartContainerFunc),
            crossFilteringContext: this.crossFilteringContext,
            crossFilteringResetCallback: () => this.activeChartComps.forEach((c) => c.crossFilteringReset()),
        };
        const chartComp = new gridChartComp_1.GridChartComp(gridChartParams);
        this.createBean(chartComp);
        const chartRef = this.createChartRef(chartComp);
        if (chartContainer) {
            // if container exists, means developer initiated chart create via API, so place in provided container
            chartContainer.appendChild(chartRef.chartElement);
        }
        else if (createChartContainerFunc) {
            // otherwise, user created chart via grid UI, check if developer provides containers (e.g. if the application
            // is using its own dialogs rather than the grid provided dialogs)
            createChartContainerFunc(chartRef);
        }
        else {
            // add listener to remove from active charts list when charts are destroyed, e.g. closing chart dialog
            chartComp.addEventListener('destroyed', () => {
                this.activeChartComps.delete(chartComp);
                this.activeCharts.delete(chartRef);
            });
        }
        return chartRef;
    }
    createChartRef(chartComp) {
        const chartRef = {
            destroyChart: () => {
                if (this.activeCharts.has(chartRef)) {
                    this.destroyBean(chartComp);
                    this.activeChartComps.delete(chartComp);
                    this.activeCharts.delete(chartRef);
                }
            },
            focusChart: () => {
                (0, ag_grid_community_1._focusInto)(chartComp.getGui());
            },
            chartElement: chartComp.getGui(),
            chart: chartComp.getUnderlyingChart(),
            chartId: chartComp.getChartModel().chartId,
        };
        this.activeCharts.add(chartRef);
        this.activeChartComps.add(chartComp);
        return chartRef;
    }
    getSelectedRange() {
        const ranges = this.rangeSvc?.getCellRanges() ?? [];
        return ranges.length > 0 ? ranges[0] : { columns: [] };
    }
    generateId() {
        return `id-${Math.random().toString(36).substring(2, 18)}`;
    }
    createCellRange(cellRangeParams, allRange) {
        const rangeParams = allRange
            ? {
                rowStartIndex: null,
                rowStartPinned: undefined,
                rowEndIndex: null,
                rowEndPinned: undefined,
                columns: this.visibleCols.allCols.map((col) => col.getColId()),
            }
            : cellRangeParams;
        const cellRange = rangeParams && this.rangeSvc?.createPartialCellRangeFromRangeParams(rangeParams, true);
        if (!cellRange) {
            (0, ag_grid_community_1._warn)(127, { allRange });
        }
        return cellRange;
    }
    destroy() {
        this.activeCharts.forEach((chart) => chart.destroyChart());
        super.destroy();
    }
}
exports.ChartService = ChartService;


/***/ }),

/***/ 4604:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.restoreChart = exports.updateChart = exports.createCrossFilterChart = exports.createPivotChart = exports.createRangeChart = exports.closeChartToolPanel = exports.openChartToolPanel = exports.downloadChart = exports.getChartImageDataURL = exports.getChartRef = exports.getChartModels = void 0;
function getChartModels(beans) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.getChartModels());
}
exports.getChartModels = getChartModels;
function getChartRef(beans, chartId) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.getChartRef(chartId));
}
exports.getChartRef = getChartRef;
function getChartImageDataURL(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.getChartImageDataURL(params));
}
exports.getChartImageDataURL = getChartImageDataURL;
function downloadChart(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.downloadChart(params));
}
exports.downloadChart = downloadChart;
function openChartToolPanel(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.openChartToolPanel(params));
}
exports.openChartToolPanel = openChartToolPanel;
function closeChartToolPanel(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.closeChartToolPanel(params.chartId));
}
exports.closeChartToolPanel = closeChartToolPanel;
function createRangeChart(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.createRangeChart(params, true));
}
exports.createRangeChart = createRangeChart;
function createPivotChart(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.createPivotChart(params, true));
}
exports.createPivotChart = createPivotChart;
function createCrossFilterChart(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.createCrossFilterChart(params, true));
}
exports.createCrossFilterChart = createCrossFilterChart;
function updateChart(beans, params) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.updateChart(params));
}
exports.updateChart = updateChart;
function restoreChart(beans, chartModel, chartContainer) {
    return beans.frameworkOverrides.wrapIncoming(() => beans.chartSvc?.restoreChart(chartModel, chartContainer));
}
exports.restoreChart = restoreChart;


/***/ }),

/***/ 4806:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.integratedChartsModuleCSS = void 0;
exports.integratedChartsModuleCSS = `.ag-chart{display:flex;height:100%;position:relative;width:100%}.ag-chart-components-wrapper{display:flex}.ag-chart-canvas-wrapper,.ag-chart-components-wrapper{flex:1 1 auto;position:relative}.ag-chart-menu{background:var(--ag-background-color);background-color:color-mix(in srgb,transparent,var(--ag-background-color) 30%);border-radius:var(--ag-border-radius);display:flex;flex-direction:row;gap:20px;padding:4px 2px;position:absolute;top:8px;width:auto;--ag-icon-size:20px}:where(.ag-ltr) .ag-chart-menu{justify-content:right;right:calc(var(--ag-cell-horizontal-padding) + var(--ag-spacing) - 4px)}:where(.ag-rtl) .ag-chart-menu{justify-content:left;left:calc(var(--ag-cell-horizontal-padding) + var(--ag-spacing) - 4px)}.ag-chart-docked-container{min-width:var(--ag-chart-menu-panel-width);position:relative}:where(.ag-chart-menu-hidden)~.ag-chart-docked-container{display:none}.ag-chart-tabbed-menu{display:flex;flex-direction:column;height:100%;overflow:hidden;width:100%}.ag-chart-tabbed-menu-header{cursor:default;flex:none;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-chart-tabbed-menu-body{align-items:stretch;display:flex;flex:1 1 auto;overflow:hidden;position:relative;&:after{background:linear-gradient(var(--ag-background-color),transparent);content:"";display:block;height:16px;left:0;position:absolute;right:0;top:0}}.ag-chart-tab{overflow:hidden;overflow-y:auto;width:100%}.ag-chart-settings{overflow-x:hidden}.ag-chart-settings-wrapper{display:flex;flex-direction:column;height:100%;overflow:hidden;position:relative;width:100%}.ag-chart-settings-nav-bar{align-items:center;border-top:1px solid var(--ag-border-color);display:flex;height:30px;padding:0 10px;-webkit-user-select:none;-moz-user-select:none;user-select:none;width:100%}.ag-chart-settings-card-selector{align-items:center;display:flex;flex:1 1 auto;height:100%;justify-content:space-around;padding:0 10px}.ag-chart-settings-card-item{background-color:var(--ag-foreground-color);border-radius:4px;cursor:pointer;height:8px;position:relative;width:8px;&.ag-not-selected{opacity:.2}&:before{background-color:transparent;content:" ";display:block;height:20px;left:50%;margin-left:-10px;margin-top:-10px;position:absolute;top:50%;width:20px}&.ag-selected{background-color:var(--ag-accent-color)}}.ag-chart-settings-next,.ag-chart-settings-prev{flex:none;position:relative;&:focus-within{border-radius:1px;box-shadow:var(--ag-focus-shadow)}}.ag-chart-settings-next-button,.ag-chart-settings-prev-button{cursor:pointer;height:100%;left:0;opacity:0;position:absolute;top:0;width:100%}.ag-chart-settings-mini-charts-container{flex:1 1 auto;overflow:hidden auto;position:relative}.ag-chart-settings-mini-wrapper{display:flex;flex-direction:column;left:0;min-height:100%;overflow:hidden;padding-bottom:var(--ag-widget-container-vertical-padding);position:absolute;top:0;width:100%;&.ag-animating{transition:left .3s;transition-timing-function:ease-in-out}}.ag-chart-mini-thumbnail{border:1px solid var(--ag-border-color);border-radius:5px;cursor:pointer;padding:1px;&.ag-selected{border-color:var(--ag-accent-color);border-width:2px;padding:unset}&:focus-visible{border-color:var(--ag-accent-color);box-shadow:var(--ag-focus-shadow)}}.ag-chart-mini-thumbnail-canvas{display:block}.ag-chart-advanced-settings-wrapper,.ag-chart-data-wrapper,.ag-chart-format-wrapper{display:flex;flex-direction:column;padding-bottom:16px;position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none}.ag-chart-advanced-settings-wrapper,.ag-chart-data-wrapper{height:100%;overflow-y:auto}.ag-chart-advanced-settings{background-color:var(--ag-chrome-background-color)}.ag-chart-advanced-settings,.ag-chart-advanced-settings-wrapper{width:100%}.ag-chart-advanced-settings-wrapper{padding-bottom:0}.ag-chart-advanced-settings-section{border-bottom:1px solid var(--ag-border-color);display:flex;margin:0;padding-bottom:var(--ag-widget-container-vertical-padding);padding-top:var(--ag-widget-container-vertical-padding)}.ag-chart-empty-text{align-items:center;background-color:var(--ag-background-color);display:flex;height:100%;justify-content:center;top:0;width:100%}.ag-charts-font-size-color{align-self:stretch;display:flex;justify-content:space-between}.ag-charts-data-group-item{padding-bottom:var(--ag-widget-container-vertical-padding);position:relative}.ag-charts-data-group-item:where(:not(:last-child)){margin-bottom:var(--ag-spacing)}.ag-chart-menu-icon{border-radius:var(--ag-border-radius);cursor:pointer;margin:2px 0;opacity:.8;&:hover{opacity:1}}.ag-chart-menu-toolbar-button{background-color:unset;border:0;border-radius:1px;padding:0 2px}.ag-chart-data-column-drag-handle{margin-left:var(--ag-spacing)}.ag-charts-advanced-settings-top-level-group-title-bar{background-color:unset;position:relative}.ag-charts-data-group-container{padding:calc(var(--ag-widget-container-vertical-padding)*.5) var(--ag-widget-container-horizontal-padding)}.ag-charts-data-group-item:where(:not(.ag-charts-format-sub-level-group,.ag-pill-select,.ag-select)){height:var(--ag-list-item-height)}.ag-charts-data-group-item:where(.ag-picker-field){margin-top:var(--ag-spacing)}.ag-charts-advanced-settings-top-level-group-container,.ag-charts-format-top-level-group-container{margin-left:calc(var(--ag-spacing)*2);padding:var(--ag-spacing)}.ag-charts-advanced-settings-top-level-group-item,.ag-charts-format-top-level-group-item{margin:var(--ag-spacing) 0}.ag-charts-format-sub-level-group-container{display:flex;flex-direction:column;padding:var(--ag-widget-vertical-spacing) 0}.ag-charts-settings-group-container{display:grid;grid-template-columns:60px 1fr 60px 1fr 60px;padding:var(--ag-spacing);row-gap:8px;:where(.ag-chart-mini-thumbnail:nth-child(3n+1)){grid-column:1}:where(.ag-chart-mini-thumbnail:nth-child(3n+2)){grid-column:3}:where(.ag-chart-mini-thumbnail:nth-child(3n+3)){grid-column:5}}.ag-chart-data-section,.ag-chart-format-section{display:flex;margin:0;:where(.ag-label:not(.ag-group-title-bar)){color:var(--ag-chart-menu-label-color)}:where(.ag-label-align-top .ag-label){margin-bottom:var(--ag-widget-vertical-spacing);margin-top:calc(var(--ag-widget-vertical-spacing)*.5)}:where(.ag-slider.ag-label-align-top .ag-label){margin-bottom:0}:where(label){display:inline-block}}.ag-chart-menu-panel{--ag-panel-background-color:var(--ag-chrome-background-color)}:where(.ag-ltr) .ag-chart-menu-panel{border-left:1px solid var(--ag-border-color)}:where(.ag-rtl) .ag-chart-menu-panel{border-right:1px solid var(--ag-border-color)}.ag-charts-data-group-title-bar,.ag-charts-format-top-level-group-title-bar,.ag-charts-settings-group-container,.ag-charts-settings-group-title-bar{border-top:none;font-weight:500;padding:0 calc(var(--ag-spacing)*1.5)}.ag-charts-format-sub-level-group-title-bar{background:none;font-weight:500;padding:var(--ag-widget-vertical-spacing) 0}.ag-chart-data-wrapper,.ag-chart-format-wrapper,.ag-charts-data-group-container,.ag-charts-data-group-title-bar,.ag-charts-format-sub-level-group,.ag-charts-format-sub-level-group-container>*,.ag-charts-format-sub-level-group-item:last-child,.ag-charts-format-top-level-group,.ag-charts-format-top-level-group-item,.ag-charts-format-top-level-group-title-bar,.ag-charts-settings-group-container,.ag-charts-settings-group-title-bar,:where(.ag-charts-format-top-level-group) .ag-charts-format-top-level-group-container{margin:0;padding:0}.ag-charts-data-group-title-bar,.ag-charts-format-top-level-group-title-bar,.ag-charts-settings-group-title-bar{padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);position:relative}.ag-charts-data-group,.ag-charts-format-top-level-group{border-top:1px solid var(--ag-border-color)}:where(.ag-charts-data-group) .ag-charts-data-group-container,:where(.ag-charts-format-top-level-group) .ag-charts-format-top-level-group-container,:where(.ag-charts-settings-group) .ag-charts-settings-group-container{padding:0 var(--ag-widget-container-horizontal-padding)}.ag-charts-format-sub-level-group-container>*,.ag-charts-format-sub-level-no-header-group-container>*,.ag-charts-format-top-level-group-container>*{margin-bottom:var(--ag-widget-vertical-spacing)}.ag-charts-advanced-settings-top-level-group-container{margin:0}:where(.ag-charts-advanced-settings-top-level-group){.ag-charts-advanced-settings-top-level-group-container,.ag-charts-advanced-settings-top-level-group-title-bar{padding:0 var(--ag-widget-container-horizontal-padding)}}.ag-charts-advanced-settings-top-level-group-item{margin-bottom:0;margin-top:calc(var(--ag-widget-vertical-spacing)*2)}.ag-chart-settings-card-item.ag-not-selected:hover{opacity:.35}.ag-angle-select{align-items:center;display:flex}.ag-angle-select-wrapper{display:flex}.ag-angle-select-parent-circle{background-color:var(--ag-background-color);border:1px solid;border-color:var(--ag-border-color);border-radius:12px;display:block;height:24px;position:relative;width:24px}.ag-angle-select-child-circle{background-color:var(--ag-foreground-color);border-radius:3px;height:6px;left:12px;margin-left:-3px;margin-top:-4px;position:absolute;top:4px;width:6px}.ag-slider-wrapper{display:flex;:where(.ag-input-field){flex:1 1 auto}}.ag-color-panel{display:flex;flex-direction:column;padding:var(--ag-spacing);text-align:center;width:100%}.ag-spectrum-color{cursor:default;flex:1 1 auto;overflow:visible;position:relative}.ag-spectrum-fill{inset:0;position:absolute}.ag-spectrum-val{background-image:linear-gradient(0deg,#000,hsla(20,42%,65%,0));cursor:pointer}.ag-spectrum-dragger{background:#000;border:3px solid #fff;border-radius:18px;box-shadow:0 0 2px 0 rgba(0,0,0,.24);cursor:pointer;height:18px;pointer-events:none;position:absolute;width:18px}.ag-spectrum-alpha,.ag-spectrum-hue{cursor:default}.ag-spectrum-hue-background{background:linear-gradient(270deg,red 3%,#ff0 17%,#0f0 33%,#0ff 50%,#00f 67%,#f0f 83%,red);height:100%;width:100%}.ag-spectrum-alpha-background{background:linear-gradient(to right,var(--ag-internal-spectrum-alpha-color-from),var(--ag-internal-spectrum-alpha-color-to)),url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="4" height="4"><rect x="0" y="0" width="4" height="4" fill="%23fff"/><path d="M0 0H2V4H4V2H0Z" fill="%23b2b2b2"/></svg>') 0 0 /4px 4px;height:100%;width:100%}.ag-spectrum-tool{border-radius:2px;cursor:pointer;height:11px;margin-bottom:10px;position:relative}.ag-spectrum-slider{border:2px solid #fff;border-radius:13px;box-shadow:0 1px 4px 0 rgba(0,0,0,.37);height:13px;margin-top:-12px;pointer-events:none;position:absolute;width:13px}:where(.ag-spectrum-alpha) .ag-spectrum-slider{background:linear-gradient(to bottom,var(--ag-internal-spectrum-alpha-color),var(--ag-internal-spectrum-alpha-color)) var(--ag-background-color)}.ag-recent-colors{display:flex;gap:6px;margin-bottom:2px;margin-left:var(--ag-spacing);margin-right:var(--ag-spacing)}.ag-recent-color{border:1px solid var(--ag-border-color);cursor:pointer}.ag-angle-select[disabled]{opacity:.5;pointer-events:none}:where(.ag-ltr) .ag-angle-select-field,:where(.ag-ltr) .ag-slider-field{margin-right:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-angle-select-field,:where(.ag-rtl) .ag-slider-field{margin-left:calc(var(--ag-spacing)*2)}.ag-color-dialog{border-radius:5px}:where(.ag-color-picker){.ag-picker-field-wrapper{padding-left:var(--ag-spacing);padding-right:var(--ag-spacing)}.ag-picker-field-display{align-items:center;display:flex;flex-direction:row;min-height:var(--ag-list-item-height)}}:where(.ag-ltr) .ag-color-picker-color,:where(.ag-ltr) .ag-color-picker-value{margin-right:var(--ag-spacing)}:where(.ag-rtl) .ag-color-picker-color,:where(.ag-rtl) .ag-color-picker-value{margin-left:var(--ag-spacing)}.ag-spectrum-tools{padding-bottom:0;padding-left:0;padding-right:0}.ag-spectrum-alpha-background,.ag-spectrum-hue-background{border-radius:2px}.ag-color-input-color,.ag-color-picker-color,.ag-recent-color{border-radius:4px}.ag-spectrum-sat{background-image:linear-gradient(90deg,#fff,hsla(20,42%,65%,0))}.ag-recent-color,.ag-spectrum-color,.ag-spectrum-slider{&:where(:not(:disabled,[readonly])):focus-visible{box-shadow:var(--ag-focus-shadow)}}.ag-color-input-color,.ag-color-picker-color{border:1px solid var(--ag-border-color);border-radius:2px;height:var(--ag-icon-size);width:var(--ag-icon-size)}:where(.ag-color-input){.ag-color-input-color{position:absolute}}:where(.ag-ltr) :where(.ag-color-input){.ag-input-field-input{padding-left:calc(var(--ag-icon-size) + var(--ag-spacing)*2)}.ag-color-input-color{margin-left:var(--ag-spacing)}}:where(.ag-rtl) :where(.ag-color-input){.ag-input-field-input{padding-right:calc(var(--ag-icon-size) + var(--ag-spacing)*2)}.ag-color-input-color{margin-right:var(--ag-spacing)}}.ag-range-field{align-items:center;display:flex;:where(.ag-input-wrapper){height:100%}}.ag-range-field-input{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:none;height:100%;overflow:visible;padding:0;width:100%;&:disabled{opacity:.5}}.ag-range-field-input{&::-webkit-slider-runnable-track{background-color:var(--ag-border-color);border-radius:1.5px;height:3px;margin:0;padding:0;width:100%}&::-webkit-slider-thumb{-webkit-appearance:none;appearance:none;background-color:var(--ag-background-color);border:1px solid var(--ag-border-color);border-radius:100%;height:var(--ag-icon-size);margin:0;padding:0;transform:translateY(calc(var(--ag-icon-size)*-.5 + 1.5px));width:var(--ag-icon-size)}&:focus::-webkit-slider-thumb{border-color:var(--ag-accent-color);box-shadow:var(--ag-focus-shadow)}&:active::-webkit-slider-runnable-track{background-color:var(--ag-accent-color)}}.ag-range-field-input{&::-moz-range-track{background-color:var(--ag-border-color);border-radius:1.5px;height:3px;margin:0;padding:0;width:100%}&::-moz-ag-range-thumb{-moz-appearance:none;appearance:none;background-color:var(--ag-background-color);border:1px solid var(--ag-border-color);border-radius:100%;height:var(--ag-icon-size);margin:0;padding:0;transform:translateY(calc(var(--ag-icon-size)*-.5 + 1.5px));width:var(--ag-icon-size)}&:focus::-moz-ag-range-thumb{border-color:var(--ag-accent-color);box-shadow:var(--ag-focus-shadow)}&:active::-moz-ag-range-track{background-color:var(--ag-accent-color)}}`;


/***/ }),

/***/ 1527:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IntegratedChartsModule = exports.GridChartsModule = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGridEnterpriseModule_1 = __webpack_require__(9206);
const licenseManager_1 = __webpack_require__(6565);
const rangeSelectionModule_1 = __webpack_require__(266);
const version_1 = __webpack_require__(7205);
const menuItemModule_1 = __webpack_require__(3375);
const agChartsExports_1 = __webpack_require__(2459);
const enterpriseChartProxyFactory_1 = __webpack_require__(7879);
const advancedSettingsMenuFactory_1 = __webpack_require__(6353);
const chartMenuList_1 = __webpack_require__(6292);
const chartCrossFilterService_1 = __webpack_require__(8769);
const chartMenuService_1 = __webpack_require__(7492);
const chartTranslationService_1 = __webpack_require__(93);
const chartService_1 = __webpack_require__(100);
const chartsApi_1 = __webpack_require__(4604);
const integratedChartsModule_css_GENERATED_1 = __webpack_require__(4806);
const validGridChartsVersion_1 = __webpack_require__(3504);
const icons = {
    // shown on top right of chart when chart is linked to range data (click to unlink)
    linked: 'linked',
    // shown on top right of chart when chart is not linked to range data (click to link)
    unlinked: 'unlinked',
    // icon to open charts menu
    chartsMenu: 'menu-alt',
    // download chart
    chartsDownload: 'save',
    // Edit Chart menu item shown in Integrated Charts menu
    chartsMenuEdit: 'chart',
    // Advanced Settings menu item shown in Integrated Charts menu
    chartsMenuAdvancedSettings: 'settings',
    // shown in Integrated Charts menu add fields
    chartsMenuAdd: 'plus',
    // shown in Integrated Charts tool panel color picker
    chartsColorPicker: 'small-down',
    // previous in Integrated Charts settings tool panel theme switcher
    chartsThemePrevious: 'previous',
    // next in Integrated Charts settings tool panel theme switcher
    chartsThemeNext: 'next',
};
const apiFunctions = {
    getChartModels: chartsApi_1.getChartModels,
    getChartRef: chartsApi_1.getChartRef,
    getChartImageDataURL: chartsApi_1.getChartImageDataURL,
    downloadChart: chartsApi_1.downloadChart,
    openChartToolPanel: chartsApi_1.openChartToolPanel,
    closeChartToolPanel: chartsApi_1.closeChartToolPanel,
    createRangeChart: chartsApi_1.createRangeChart,
    createPivotChart: chartsApi_1.createPivotChart,
    createCrossFilterChart: chartsApi_1.createCrossFilterChart,
    updateChart: chartsApi_1.updateChart,
    restoreChart: chartsApi_1.restoreChart,
};
const dependsOn = [
    rangeSelectionModule_1.CellSelectionModule,
    agGridEnterpriseModule_1.EnterpriseCoreModule,
    ag_grid_community_1._SharedDragAndDropModule,
    ag_grid_community_1._PopupModule,
    menuItemModule_1.MenuItemModule,
];
const moduleName = 'IntegratedCharts';
/**
 * @deprecated v33 Deprecated as of v33, please use `IntegratedChartsModule` instead.
 */
exports.GridChartsModule = {
    moduleName: 'GridCharts',
    version: version_1.VERSION,
    dependsOn,
    validate: () => {
        return {
            isValid: false,
            message: `AG Grid: As of v33, the "GridChartsModule" has been deprecated. Please use "IntegratedChartsModule.with(...)" instead.\n ${(0, ag_grid_community_1._preInitErrMsg)(257)}`,
        };
    },
};
/**
 * @feature Integrated Charts
 * Requires the AG Charts library to be provided to this module via the `with` method.
 * The AG Charts module can be imported from either `ag-charts-community` or `ag-charts-enterprise`.
 * @example
 * import { AgChartsEnterpriseModule } from 'ag-charts-enterprise';
 * import { ModuleRegistry } from 'ag-grid-community';
 * import { IntegratedChartsModule } from 'ag-grid-enterprise';
 *
 * ModuleRegistry.registerModules([ IntegratedChartsModule.with(AgChartsEnterpriseModule) ]);
 */
exports.IntegratedChartsModule = {
    moduleName,
    version: version_1.VERSION,
    dependsOn,
    validate: () => {
        return {
            isValid: false,
            message: (0, ag_grid_community_1._preInitErrMsg)(257),
        };
    },
    with: (params) => {
        params.setup();
        params.setGridContext?.(true);
        if (params.isEnterprise && params.setLicenseKey) {
            const chartsManager = {
                setLicenseKey: params.setLicenseKey,
            };
            licenseManager_1.LicenseManager.setChartsLicenseManager(chartsManager);
        }
        return {
            moduleName,
            version: version_1.VERSION,
            icons,
            apiFunctions,
            dependsOn,
            css: [integratedChartsModule_css_GENERATED_1.integratedChartsModuleCSS],
            validate: () => {
                return (0, validGridChartsVersion_1.validGridChartsVersion)({
                    gridVersion: version_1.VERSION,
                    chartsVersion: params.VERSION,
                });
            },
            beans: [
                // bind the params to the constructor to avoid the need for static properties
                agChartsExports_1.AgChartsExports.bind(null, params),
                chartService_1.ChartService,
                chartTranslationService_1.ChartTranslationService,
                chartCrossFilterService_1.ChartCrossFilterService,
                chartMenuList_1.ChartMenuListFactory,
                chartMenuService_1.ChartMenuService,
                // Include enterprise beans for now for all users as tiny compared to charts bundle size
                enterpriseChartProxyFactory_1.EnterpriseChartProxyFactory,
                advancedSettingsMenuFactory_1.AdvancedSettingsMenuFactory,
            ],
        };
    },
};


/***/ }),

/***/ 3504:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validGridChartsVersion = exports.validGridChartsVersionErrorMessage = exports.gridChartVersion = void 0;
const VERSION_CHECKING_FIRST_GRID_MAJOR_VERSION = 28;
const VERSION_CHECKING_FIRST_CHARTS_MAJOR_VERSION = 6;
function isValidVersion(version) {
    return version && version.match(/\d+\.\d+\.\d+/);
}
function isValidMajorVersion({ gridMajorVersion, chartsMajorVersion, }) {
    const gridMajor = parseInt(gridMajorVersion, 10);
    const chartsMajor = parseInt(chartsMajorVersion, 10);
    const gridMajorDifference = gridMajor - VERSION_CHECKING_FIRST_GRID_MAJOR_VERSION;
    const chartsMajorDifference = chartsMajor - VERSION_CHECKING_FIRST_CHARTS_MAJOR_VERSION;
    const isFirstOrAfterVersion = gridMajorDifference >= 0;
    return gridMajorDifference === chartsMajorDifference && isFirstOrAfterVersion;
}
function gridChartVersion(gridVersion) {
    if (!gridVersion || !isValidVersion(gridVersion)) {
        return undefined;
    }
    const [gridMajor, gridMinor] = gridVersion.split('.') || [];
    const gridMajorMinor = `${gridMajor}.${gridMinor}.x`;
    const gridMajorNumber = parseInt(gridMajor, 10);
    const chartsMajor = gridMajorNumber - VERSION_CHECKING_FIRST_GRID_MAJOR_VERSION + VERSION_CHECKING_FIRST_CHARTS_MAJOR_VERSION;
    if (chartsMajor < 0) {
        return undefined;
    }
    const chartsMinor = gridMinor;
    const chartsMajorMinor = `${chartsMajor}.${chartsMinor}.x`;
    return {
        gridMajorMinor,
        chartsMajorMinor,
    };
}
exports.gridChartVersion = gridChartVersion;
function validGridChartsVersionErrorMessage({ type, gridVersion, chartsVersion, }) {
    const invalidMessage = 'AG Grid: AG Grid version is incompatible. Please see https://www.ag-grid.com/javascript-data-grid/modules/ for more information.';
    if (!gridVersion) {
        return invalidMessage;
    }
    const version = gridChartVersion(gridVersion);
    if (!version) {
        return invalidMessage;
    }
    const { gridMajorMinor, chartsMajorMinor } = version;
    if (type === 'incompatible') {
        return `AG Grid version ${gridVersion} and AG Charts version ${chartsVersion} is not supported. AG Grid version ${gridMajorMinor} should be used with AG Chart ${chartsMajorMinor}. Please see https://www.ag-grid.com/javascript-data-grid/modules/ for more information.`;
    }
    else if (type === 'invalidCharts') {
        return `AG Grid version ${gridMajorMinor} should be used with AG Chart ${chartsMajorMinor} not ${chartsVersion}. Please see https://www.ag-grid.com/javascript-data-grid/modules/ for more information.`;
    }
    return invalidMessage;
}
exports.validGridChartsVersionErrorMessage = validGridChartsVersionErrorMessage;
function validGridChartsVersion({ gridVersion, chartsVersion, }) {
    if (!isValidVersion(chartsVersion)) {
        return {
            isValid: false,
            message: validGridChartsVersionErrorMessage({ type: 'invalidCharts', gridVersion, chartsVersion }),
        };
    }
    if (!isValidVersion(gridVersion)) {
        return {
            isValid: false,
            message: validGridChartsVersionErrorMessage({ type: 'invalidGrid', gridVersion, chartsVersion }),
        };
    }
    const [gridMajor, gridMinor] = gridVersion.split('.') || [];
    const [chartsMajor, chartsMinor, chartsPatch] = chartsVersion.split('.') || [];
    const isValidMajor = isValidMajorVersion({
        gridMajorVersion: gridMajor,
        chartsMajorVersion: chartsMajor,
    });
    if ((isValidMajor && gridMinor === chartsMinor) || chartsPatch.includes('beta')) {
        return {
            isValid: true,
        };
    }
    else if (!isValidMajor || gridMinor !== chartsMinor) {
        return {
            isValid: false,
            message: validGridChartsVersionErrorMessage({ type: 'incompatible', gridVersion, chartsVersion }),
        };
    }
    return {
        isValid: false,
        message: validGridChartsVersionErrorMessage({ type: 'invalid', gridVersion, chartsVersion }),
    };
}
exports.validGridChartsVersion = validGridChartsVersion;


/***/ }),

/***/ 1750:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgAngleSelect = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AgAngleSelect extends ag_grid_community_1.AgAbstractLabel {
    wireBeans(beans) {
        this.dragSvc = beans.dragSvc;
    }
    constructor(config) {
        super(config, 
        /* html */ `<div class="ag-angle-select">
            <div data-ref="eLabel"></div>
            <div class="ag-wrapper ag-angle-select-wrapper">
                <div class="ag-angle-select-field">
                    <div data-ref="eParentCircle" class="ag-angle-select-parent-circle">
                        <div data-ref="eChildCircle" class="ag-angle-select-child-circle"></div>
                    </div>
                </div>
                <ag-input-number-field data-ref="eAngleValue"></ag-input-number-field>
            </div>
        </div>`, [ag_grid_community_1.AgInputNumberFieldSelector]);
        this.eLabel = ag_grid_community_1.RefPlaceholder;
        this.eParentCircle = ag_grid_community_1.RefPlaceholder;
        this.eChildCircle = ag_grid_community_1.RefPlaceholder;
        this.eAngleValue = ag_grid_community_1.RefPlaceholder;
        this.radius = 0;
        this.offsetX = 0;
        this.offsetY = 0;
    }
    postConstruct() {
        super.postConstruct();
        const { value, onValueChange } = this.config;
        if (value != null) {
            this.setValue(value, undefined, true);
        }
        if (onValueChange != null) {
            this.onValueChange(onValueChange);
        }
        this.dragListener = {
            eElement: this.eParentCircle,
            dragStartPixels: 0,
            onDragStart: () => {
                this.parentCircleRect = this.eParentCircle.getBoundingClientRect();
            },
            onDragging: (e) => this.calculateAngleDrag(e),
            onDragStop: () => { },
        };
        this.dragSvc?.addDragSource(this.dragListener);
        this.eAngleValue
            .setLabel('')
            .setLabelWidth(5)
            .setInputWidth(45)
            .setMin(0)
            .setMax(360)
            .setValue(`${this.degrees}`)
            .onValueChange((value) => {
            if (value == null || value === '') {
                value = '0';
            }
            value = this.eAngleValue.normalizeValue(value);
            let floatValue = parseFloat(value);
            if (floatValue > 180) {
                floatValue = floatValue - 360;
            }
            this.setValue(floatValue);
        });
        this.updateNumberInput();
        if ((0, ag_grid_community_1._exists)(this.getValue())) {
            this.eAngleValue.setValue(this.normalizeNegativeValue(this.getValue()).toString());
        }
        this.addManagedListeners(this, {
            fieldValueChanged: () => {
                if (this.eAngleValue.getInputElement().contains((0, ag_grid_community_1._getActiveDomElement)(this.beans))) {
                    return;
                }
                this.updateNumberInput();
            },
        });
    }
    updateNumberInput() {
        const normalizedValue = this.normalizeNegativeValue(this.getValue());
        this.eAngleValue.setValue(normalizedValue.toString());
    }
    positionChildCircle(radians) {
        const rect = this.parentCircleRect || { width: 24, height: 24 };
        const eChildCircle = this.eChildCircle;
        const centerX = rect.width / 2;
        const centerY = rect.height / 2;
        eChildCircle.style.left = `${centerX + Math.cos(radians) * 8}px`;
        eChildCircle.style.top = `${centerY + Math.sin(radians) * 8}px`;
    }
    calculatePolar() {
        const x = this.offsetX;
        const y = this.offsetY;
        const radians = Math.atan2(y, x);
        this.degrees = this.toDegrees(radians);
        this.radius = Math.sqrt(x * x + y * y);
        this.positionChildCircle(radians);
    }
    calculateCartesian() {
        const radians = this.toRadians(this.getValue());
        const radius = this.getRadius();
        this.setOffsetX(Math.cos(radians) * radius).setOffsetY(Math.sin(radians) * radius);
    }
    setOffsetX(offset) {
        if (this.offsetX !== offset) {
            this.offsetX = offset;
            this.calculatePolar();
        }
        return this;
    }
    setOffsetY(offset) {
        if (this.offsetY !== offset) {
            this.offsetY = offset;
            this.calculatePolar();
        }
        return this;
    }
    calculateAngleDrag(e) {
        const rect = this.parentCircleRect;
        const centerX = rect.width / 2;
        const centerY = rect.height / 2;
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        const dx = x - centerX;
        const dy = y - centerY;
        const radians = Math.atan2(dy, dx);
        this.setValue(radians, true);
    }
    toDegrees(radians) {
        return (radians / Math.PI) * 180;
    }
    toRadians(degrees) {
        return (degrees / 180) * Math.PI;
    }
    normalizeNegativeValue(degrees) {
        return degrees < 0 ? 360 + degrees : degrees;
    }
    normalizeAngle180(radians) {
        radians %= Math.PI * 2;
        if (radians < -Math.PI) {
            radians += Math.PI * 2;
        }
        else if (radians >= Math.PI) {
            radians -= Math.PI * 2;
        }
        return radians;
    }
    getRadius() {
        return this.radius;
    }
    setRadius(r) {
        if (this.radius === r) {
            return this;
        }
        this.radius = r;
        this.calculateCartesian();
        return this;
    }
    onValueChange(callbackFn) {
        this.addManagedListeners(this, {
            fieldValueChanged: () => {
                callbackFn(this.degrees);
            },
        });
        return this;
    }
    getValue(radians) {
        return radians ? this.toRadians(this.degrees) : this.degrees;
    }
    setValue(degrees, radians, silent) {
        let radiansValue;
        if (!radians) {
            radiansValue = this.normalizeAngle180(this.toRadians(degrees));
        }
        else {
            radiansValue = degrees;
        }
        degrees = this.toDegrees(radiansValue);
        if (this.degrees !== degrees) {
            this.degrees = Math.floor(degrees);
            this.calculateCartesian();
            this.positionChildCircle(radiansValue);
            if (!silent) {
                this.dispatchLocalEvent({ type: 'fieldValueChanged' });
            }
        }
        return this;
    }
    setWidth(width) {
        (0, ag_grid_community_1._setFixedWidth)(this.getGui(), width);
        return this;
    }
    setDisabled(disabled) {
        super.setDisabled(disabled);
        this.eAngleValue.setDisabled(disabled);
        return this;
    }
    destroy() {
        this.dragSvc?.removeDragSource(this.dragListener);
        super.destroy();
    }
}
exports.AgAngleSelect = AgAngleSelect;


/***/ }),

/***/ 7699:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColorInputSelector = exports.AgColorInput = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AgColorInput extends ag_grid_community_1.AgInputTextField {
    wireBeans(beans) {
        this.chartTranslation = beans.chartTranslation;
        this.color = beans.agChartsExports._Util.Color;
    }
    constructor() {
        super({
            template: /* html */ `
            <div role="presentation" class="ag-color-input">
                <div data-ref="eLabel" class="ag-input-field-label"></div>
                <div data-ref="eWrapper" class="ag-wrapper ag-input-wrapper" role="presentation">
                    <input data-ref="eInput" class="ag-input-field-input">
                    <div data-ref="eColor" class="ag-color-input-color"></div>
                </div>
            </div>`,
        });
        this.eColor = ag_grid_community_1.RefPlaceholder;
    }
    setColor(color) {
        const rgbaColor = color.toRgbaString();
        this.setValue(this.color.fromString(rgbaColor).toHexString().toUpperCase(), true);
        this.eColor.style.backgroundColor = rgbaColor;
    }
    setValue(value, silent) {
        const isValid = this.color.validColorString(value ?? '');
        this.eInput.setCustomValidity(isValid ? '' : this.chartTranslation.translate('invalidColor'));
        super.setValue(value, silent);
        if (isValid && !silent) {
            this.dispatchLocalEvent({ type: 'colorChanged' });
        }
        return this;
    }
    onColorChanged(callback) {
        this.addManagedListeners(this, { colorChanged: () => callback(this.color.fromString(this.value)) });
    }
}
exports.AgColorInput = AgColorInput;
exports.AgColorInputSelector = {
    selector: 'AG-COLOR-INPUT',
    component: AgColorInput,
};


/***/ }),

/***/ 7434:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColorPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agColorInput_1 = __webpack_require__(7699);
const maxRecentColors = 8;
let sharedRecentColors = [];
class AgColorPanel extends ag_grid_community_1.Component {
    constructor(config) {
        super(
        /* html */ `<div class="ag-color-panel" tabindex="-1">
            <div data-ref="spectrumColor" class="ag-spectrum-color">
                <div class="ag-spectrum-sat ag-spectrum-fill">
                    <div data-ref="spectrumVal" class="ag-spectrum-val ag-spectrum-fill">
                        <div data-ref="spectrumDragger" class="ag-spectrum-dragger"></div>
                    </div>
                </div>
            </div>
            <div class="ag-spectrum-tools">
                <div data-ref="spectrumHue" class="ag-spectrum-hue ag-spectrum-tool">
                    <div class="ag-spectrum-hue-background"></div>
                    <div data-ref="spectrumHueSlider" class="ag-spectrum-slider"></div>
                </div>
                <div data-ref="spectrumAlpha" class="ag-spectrum-alpha ag-spectrum-tool">
                    <div class="ag-spectrum-alpha-background"></div>
                    <div data-ref="spectrumAlphaSlider" class="ag-spectrum-slider"></div>
                </div>
                <ag-color-input data-ref="colorInput"></ag-color-input>
                <div data-ref="recentColors" class="ag-recent-colors"></div>
            </div>
        </div>`, [agColorInput_1.AgColorInputSelector]);
        this.H = 1; // in the [0, 1] range
        this.S = 1; // in the [0, 1] range
        this.B = 1; // in the [0, 1] range
        this.A = 1; // in the [0, 1] range
        this.isSpectrumDragging = false;
        this.isSpectrumHueDragging = false;
        this.isSpectrumAlphaDragging = false;
        this.colorChanged = false;
        this.spectrumColor = ag_grid_community_1.RefPlaceholder;
        this.spectrumVal = ag_grid_community_1.RefPlaceholder;
        this.spectrumDragger = ag_grid_community_1.RefPlaceholder;
        this.spectrumHue = ag_grid_community_1.RefPlaceholder;
        this.spectrumHueSlider = ag_grid_community_1.RefPlaceholder;
        this.spectrumAlpha = ag_grid_community_1.RefPlaceholder;
        this.spectrumAlphaSlider = ag_grid_community_1.RefPlaceholder;
        this.colorInput = ag_grid_community_1.RefPlaceholder;
        this.recentColors = ag_grid_community_1.RefPlaceholder;
        this.picker = config.picker;
    }
    wireBeans(beans) {
        this._Color = beans.agChartsExports._Util.Color;
    }
    postConstruct() {
        this.initTabIndex();
        this.initRecentColors();
        this.addGuiEventListener('focus', () => this.spectrumColor.focus());
        this.addGuiEventListener('keydown', (e) => {
            if (e.key === ag_grid_community_1.KeyCode.ENTER && !e.defaultPrevented) {
                this.destroy();
            }
        });
        this.addManagedListeners(this.spectrumColor, { keydown: (e) => this.moveDragger(e) });
        this.addManagedListeners(this.spectrumAlphaSlider, { keydown: (e) => this.moveAlphaSlider(e) });
        this.addManagedListeners(this.spectrumHueSlider, { keydown: (e) => this.moveHueSlider(e) });
        this.addManagedListeners(this.spectrumVal, { mousedown: this.onSpectrumDraggerDown.bind(this) });
        this.addManagedListeners(this.spectrumHue, { mousedown: this.onSpectrumHueDown.bind(this) });
        this.addManagedListeners(this.spectrumAlpha, { mousedown: this.onSpectrumAlphaDown.bind(this) });
        this.addGuiEventListener('mousemove', (e) => {
            this.onSpectrumDraggerMove(e);
            this.onSpectrumHueMove(e);
            this.onSpectrumAlphaMove(e);
        });
        // Listening to `mouseup` on the document on purpose. The user might release the mouse button
        // outside the UI control. When the mouse returns back to the control's area, the dragging
        // of the thumb is not expected and seen as a bug.
        this.addManagedListeners(document, { mouseup: this.onMouseUp.bind(this) });
        this.colorInput.onColorChanged(this.setColor.bind(this));
        this.addManagedListeners(this.recentColors, {
            click: this.onRecentColorClick.bind(this),
            keydown: (e) => {
                if (e.key === ag_grid_community_1.KeyCode.ENTER || e.key === ag_grid_community_1.KeyCode.SPACE) {
                    e.preventDefault();
                    this.onRecentColorClick(e);
                }
            },
        });
    }
    initTabIndex() {
        const tabIndex = (this.tabIndex = this.gos.get('tabIndex').toString());
        this.spectrumColor.setAttribute('tabindex', tabIndex);
        this.spectrumHueSlider.setAttribute('tabindex', tabIndex);
        this.spectrumAlphaSlider.setAttribute('tabindex', tabIndex);
    }
    refreshSpectrumRect() {
        return (this.spectrumValRect = this.spectrumVal.getBoundingClientRect());
    }
    refreshHueRect() {
        return (this.spectrumHueRect = this.spectrumHue.getBoundingClientRect());
    }
    refreshAlphaRect() {
        return (this.spectrumAlphaRect = this.spectrumAlpha.getBoundingClientRect());
    }
    onSpectrumDraggerDown(e) {
        e.preventDefault();
        this.refreshSpectrumRect();
        this.isSpectrumDragging = true;
        this.moveDragger(e);
    }
    onSpectrumDraggerMove(e) {
        if (this.isSpectrumDragging) {
            this.moveDragger(e);
        }
    }
    onSpectrumHueDown(e) {
        this.refreshHueRect();
        this.isSpectrumHueDragging = true;
        this.moveHueSlider(e);
    }
    onSpectrumHueMove(e) {
        if (this.isSpectrumHueDragging) {
            this.moveHueSlider(e);
        }
    }
    onSpectrumAlphaDown(e) {
        this.refreshAlphaRect();
        this.isSpectrumAlphaDragging = true;
        this.moveAlphaSlider(e);
    }
    onSpectrumAlphaMove(e) {
        if (this.isSpectrumAlphaDragging) {
            this.moveAlphaSlider(e);
        }
    }
    onMouseUp() {
        this.isSpectrumDragging = false;
        this.isSpectrumHueDragging = false;
        this.isSpectrumAlphaDragging = false;
    }
    moveDragger(e) {
        const valRect = this.spectrumValRect;
        if (!valRect) {
            return;
        }
        let x;
        let y;
        if (e instanceof MouseEvent) {
            x = e.clientX - valRect.left;
            y = e.clientY - valRect.top;
        }
        else {
            const isLeft = e.key === ag_grid_community_1.KeyCode.LEFT;
            const isRight = e.key === ag_grid_community_1.KeyCode.RIGHT;
            const isUp = e.key === ag_grid_community_1.KeyCode.UP;
            const isDown = e.key === ag_grid_community_1.KeyCode.DOWN;
            const isVertical = isUp || isDown;
            const isHorizontal = isLeft || isRight;
            if (!isVertical && !isHorizontal) {
                return;
            }
            e.preventDefault();
            const { x: currentX, y: currentY } = this.getSpectrumValue();
            x = currentX + (isHorizontal ? (isLeft ? -5 : 5) : 0);
            y = currentY + (isVertical ? (isUp ? -5 : 5) : 0);
        }
        x = Math.max(x, 0);
        x = Math.min(x, valRect.width);
        y = Math.max(y, 0);
        y = Math.min(y, valRect.height);
        this.setSpectrumValue(x / valRect.width, 1 - y / valRect.height);
    }
    moveHueSlider(e) {
        const rect = this.spectrumHueRect;
        if (!rect) {
            return;
        }
        const x = this.moveSlider(this.spectrumHueSlider, e);
        if (x == null) {
            return;
        }
        this.H = 1 - x / rect.width;
        this.update();
    }
    moveAlphaSlider(e) {
        const rect = this.spectrumAlphaRect;
        if (!rect) {
            return;
        }
        const x = this.moveSlider(this.spectrumAlphaSlider, e);
        if (x == null) {
            return;
        }
        this.A = x / rect.width;
        this.update();
    }
    moveSlider(slider, e) {
        const sliderRect = slider.getBoundingClientRect();
        const parentRect = slider.parentElement?.getBoundingClientRect();
        if (!slider || !parentRect) {
            return null;
        }
        const offset = sliderRect.width / 2;
        let x;
        if (e instanceof MouseEvent) {
            x = Math.floor(e.clientX - parentRect.left);
        }
        else {
            const isLeft = e.key === ag_grid_community_1.KeyCode.LEFT;
            const isRight = e.key === ag_grid_community_1.KeyCode.RIGHT;
            if (!isLeft && !isRight) {
                return null;
            }
            e.preventDefault();
            const diff = isLeft ? -5 : 5;
            x = parseFloat(slider.style.left) + offset + diff;
        }
        x = Math.max(x, 0);
        x = Math.min(x, parentRect.width);
        slider.style.left = x - offset + 'px';
        return x;
    }
    update(suppressColorInputUpdate) {
        const { A, S, B, H, _Color } = this;
        const hue = H * 360;
        const color = _Color.fromHSB(hue, S, B, A);
        const rgbaColor = color.toRgbaString();
        const colorWithoutAlpha = _Color.fromHSB(hue, S, B);
        const rgbaColorWithoutAlpha = colorWithoutAlpha.toRgbaString();
        const spectrumColor = _Color.fromHSB(hue, 1, 1);
        const spectrumRgbaColor = spectrumColor.toRgbaString();
        // the recent color list needs to know color has actually changed
        const colorPicker = this.picker;
        const existingColor = _Color.fromString(colorPicker.getValue());
        if (existingColor.toRgbaString() !== rgbaColor) {
            this.colorChanged = true;
        }
        colorPicker.setValue(rgbaColor);
        this.spectrumColor.style.backgroundColor = spectrumRgbaColor;
        this.spectrumDragger.style.backgroundColor = rgbaColorWithoutAlpha;
        this.spectrumHueSlider.style.backgroundColor = spectrumRgbaColor;
        this.spectrumAlpha.style.setProperty('--ag-internal-spectrum-alpha-color-from', _Color.fromHSB(hue, S, B, 0).toRgbaString());
        this.spectrumAlpha.style.setProperty('--ag-internal-spectrum-alpha-color-to', rgbaColorWithoutAlpha);
        this.spectrumAlpha.style.setProperty('--ag-internal-spectrum-alpha-color', rgbaColor);
        if (!suppressColorInputUpdate) {
            this.colorInput.setColor(color);
        }
    }
    /**
     * @param saturation In the [0, 1] interval.
     * @param brightness In the [0, 1] interval.
     */
    setSpectrumValue(saturation, brightness, suppressColorInputUpdate) {
        const valRect = this.spectrumValRect || this.refreshSpectrumRect();
        if (valRect == null) {
            return;
        }
        const dragger = this.spectrumDragger;
        const draggerRect = dragger.getBoundingClientRect();
        saturation = Math.max(0, saturation);
        saturation = Math.min(1, saturation);
        brightness = Math.max(0, brightness);
        brightness = Math.min(1, brightness);
        this.S = saturation;
        this.B = brightness;
        dragger.style.left = saturation * valRect.width - draggerRect.width / 2 + 'px';
        dragger.style.top = (1 - brightness) * valRect.height - draggerRect.height / 2 + 'px';
        this.update(suppressColorInputUpdate);
    }
    getSpectrumValue() {
        const dragger = this.spectrumDragger;
        const draggerRect = dragger.getBoundingClientRect();
        const x = parseFloat(dragger.style.left) + draggerRect.width / 2;
        const y = parseFloat(dragger.style.top) + draggerRect.height / 2;
        return { x, y };
    }
    initRecentColors() {
        const recentColors = sharedRecentColors;
        const innerHtml = recentColors.map((color, index) => {
            return /* html */ `<div class="ag-recent-color" id=${index} style="background-color: ${color}; width: 15px; height: 15px;" recent-color="${color}" tabIndex="${this.tabIndex}"></div>`;
        });
        this.recentColors.innerHTML = innerHtml.join('');
        (0, ag_grid_community_1._setDisplayed)(this.recentColors, !!recentColors.length);
    }
    setValue(val) {
        const color = this._Color.fromString(val);
        this.setColor(color, true);
    }
    setColor(color, updateColorInput) {
        const [h, s, b] = color.toHSB();
        this.H = (isNaN(h) ? 0 : h) / 360;
        this.A = color.a;
        const spectrumHueRect = this.spectrumHueRect || this.refreshHueRect();
        const spectrumAlphaRect = this.spectrumAlphaRect || this.refreshAlphaRect();
        this.spectrumHueSlider.style.left = `${(this.H - 1) * -spectrumHueRect.width - this.spectrumHueSlider.getBoundingClientRect().width / 2}px`;
        this.spectrumAlphaSlider.style.left = `${this.A * spectrumAlphaRect.width - this.spectrumAlphaSlider.getBoundingClientRect().width / 2}px`;
        this.setSpectrumValue(s, b, !updateColorInput);
    }
    onRecentColorClick(e) {
        const target = e.target;
        if (!(0, ag_grid_community_1._exists)(target.id)) {
            return;
        }
        const id = parseInt(target.id, 10);
        this.setValue(sharedRecentColors[id]);
        this.destroy();
    }
    addRecentColor() {
        const color = this._Color.fromHSB(this.H * 360, this.S, this.B, this.A);
        const rgbaColor = color.toRgbaString();
        let recentColors = sharedRecentColors;
        if (!this.colorChanged || recentColors[0] === rgbaColor) {
            return;
        }
        // remove duplicate color
        recentColors = recentColors.filter((currentColor) => currentColor != rgbaColor);
        // add color to head
        recentColors = [rgbaColor].concat(recentColors);
        // ensure we don't exceed max number of recent colors
        if (recentColors.length > maxRecentColors) {
            recentColors = recentColors.slice(0, maxRecentColors);
        }
        sharedRecentColors = recentColors;
    }
    destroy() {
        this.addRecentColor();
        super.destroy();
    }
}
exports.AgColorPanel = AgColorPanel;


/***/ }),

/***/ 1296:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgColorPickerSelector = exports.AgColorPicker = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agDialog_1 = __webpack_require__(8775);
const agColorPanel_1 = __webpack_require__(7434);
class AgColorPicker extends ag_grid_community_1.AgPickerField {
    constructor(config) {
        super({
            pickerAriaLabelKey: 'ariaLabelColorPicker',
            pickerAriaLabelValue: 'Color Picker',
            pickerType: 'ag-list',
            className: 'ag-color-picker',
            pickerIcon: 'chartsColorPicker',
            ...config,
        });
    }
    postConstruct() {
        const eDocument = (0, ag_grid_community_1._getDocument)(this.beans);
        this.eDisplayFieldColor = eDocument.createElement('span');
        this.eDisplayFieldColor.classList.add('ag-color-picker-color');
        this.eDisplayFieldText = eDocument.createElement('span');
        this.eDisplayFieldText.classList.add('ag-color-picker-value');
        this.eDisplayField.appendChild(this.eDisplayFieldColor);
        this.eDisplayField.appendChild(this.eDisplayFieldText);
        super.postConstruct();
        if (this.value) {
            this.setValue(this.value);
        }
    }
    createPickerComponent() {
        const eGuiRect = this.eWrapper.getBoundingClientRect();
        const parentRect = this.beans.popupSvc.getParentRect();
        const colorDialog = this.createBean(new agDialog_1.AgDialog({
            closable: false,
            modal: true,
            hideTitleBar: true,
            minWidth: 190,
            width: 190,
            height: 250,
            x: eGuiRect.right - parentRect.left - 190,
            y: eGuiRect.top - parentRect.top - 250 - (this.config.pickerGap ?? 0),
            postProcessPopupParams: {
                type: 'colorPicker',
                eventSource: this.eWrapper,
            },
        }));
        return colorDialog;
    }
    renderAndPositionPicker() {
        const pickerComponent = this.pickerComponent;
        const colorPanel = this.createBean(new agColorPanel_1.AgColorPanel({ picker: this }));
        pickerComponent.addCssClass('ag-color-dialog');
        colorPanel.addDestroyFunc(() => {
            if (pickerComponent.isAlive()) {
                this.destroyBean(pickerComponent);
            }
        });
        pickerComponent.setParentComponent(this);
        pickerComponent.setBodyComponent(colorPanel);
        colorPanel.setValue(this.getValue());
        colorPanel.getGui().focus();
        pickerComponent.addDestroyFunc(() => {
            // here we check if the picker was already being
            // destroyed to avoid a stack overflow
            if (!this.isDestroyingPicker) {
                this.beforeHidePicker();
                this.isDestroyingPicker = true;
                if (colorPanel.isAlive()) {
                    this.destroyBean(colorPanel);
                }
                if (this.isAlive()) {
                    this.getFocusableElement().focus();
                }
            }
            else {
                this.isDestroyingPicker = false;
            }
        });
        return () => this.pickerComponent?.close();
    }
    setValue(color) {
        if (this.value === color) {
            return this;
        }
        this.eDisplayFieldColor.style.backgroundColor = color;
        this.eDisplayFieldText.textContent = this.beans.agChartsExports._Util.Color.fromString(color)
            .toHexString()
            .toUpperCase();
        return super.setValue(color);
    }
    getValue() {
        return this.value;
    }
}
exports.AgColorPicker = AgColorPicker;
exports.AgColorPickerSelector = {
    selector: 'AG-COLOR-PICKER',
    component: AgColorPicker,
};


/***/ }),

/***/ 5748:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgInputRangeSelector = exports.AgInputRange = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class AgInputRange extends ag_grid_community_1.AgAbstractInputField {
    constructor(config) {
        super(config, 'ag-range-field', 'range');
    }
    postConstruct() {
        super.postConstruct();
        const { min, max, step } = this.config;
        if (min != null) {
            this.setMinValue(min);
        }
        if (max != null) {
            this.setMaxValue(max);
        }
        this.setStep(step || 1);
    }
    addInputListeners() {
        this.addManagedElementListeners(this.eInput, {
            input: (e) => {
                const value = e.target.value;
                this.setValue(value);
            },
        });
    }
    setMinValue(value) {
        this.min = value;
        this.eInput.setAttribute('min', value.toString());
        return this;
    }
    setMaxValue(value) {
        this.max = value;
        this.eInput.setAttribute('max', value.toString());
        return this;
    }
    setStep(value) {
        this.eInput.setAttribute('step', value.toString());
        return this;
    }
    setValue(value, silent) {
        if (this.min != null) {
            value = Math.max(parseFloat(value), this.min).toString();
        }
        if (this.max != null) {
            value = Math.min(parseFloat(value), this.max).toString();
        }
        const ret = super.setValue(value, silent);
        this.eInput.value = value;
        return ret;
    }
}
exports.AgInputRange = AgInputRange;
exports.AgInputRangeSelector = {
    selector: 'AG-INPUT-RANGE',
    component: AgInputRange,
};


/***/ }),

/***/ 8239:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agPillSelectCSS = void 0;
exports.agPillSelectCSS = `.ag-pill-select{display:flex;flex-direction:column}:where(.ag-pill-select){.ag-column-drop-list{padding:0}.ag-select{padding-top:var(--ag-spacing)}.ag-picker-field-wrapper{background-color:transparent;border:0}.ag-picker-field-display{cursor:pointer;font-weight:500}.ag-picker-field-display,.ag-picker-field-icon{color:var(--ag-chart-menu-label-color)}}`;


/***/ }),

/***/ 2406:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPillSelect = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const pillDragComp_1 = __webpack_require__(3173);
const pillDropZonePanel_1 = __webpack_require__(9733);
const agPillSelect_css_GENERATED_1 = __webpack_require__(8239);
class AgPillSelect extends ag_grid_community_1.Component {
    constructor(config) {
        super(/* html */ `<div class="ag-pill-select" role="presentation"></div>`);
        this.config = config ?? {};
        const { selectedValueList, valueFormatter, valueList } = this.config;
        this.selectedValues = selectedValueList ?? [];
        this.valueList = valueList ?? [];
        this.valueFormatter = valueFormatter ?? ((value) => (0, ag_grid_community_1._escapeString)(value));
        this.registerCSS(agPillSelect_css_GENERATED_1.agPillSelectCSS);
    }
    postConstruct() {
        const { ariaLabel, onValuesChange, dragSourceId } = this.config;
        this.dropZonePanel = this.createManagedBean(new PillSelectDropZonePanel({
            getValues: () => this.selectedValues,
            setValues: (values) => this.updateValues(values),
            isDraggable: () => this.selectedValues.length > 1,
        }, (value) => this.valueFormatter(value), ariaLabel, dragSourceId));
        const eGui = this.getGui();
        eGui.appendChild(this.dropZonePanel.getGui());
        this.initSelect();
        if (onValuesChange != null) {
            this.onValuesChange = onValuesChange;
        }
    }
    setValues(valueList, selectedValues) {
        const { added, removed, updated } = this.getChanges(this.valueList, valueList);
        let refreshSelect = false;
        if (added.length || removed.length || updated.length) {
            refreshSelect = true;
        }
        this.valueList = valueList;
        this.updateValues(selectedValues, refreshSelect, true);
        return this;
    }
    setValueFormatter(valueFormatter) {
        this.valueFormatter = valueFormatter;
        return this;
    }
    initSelect() {
        const options = this.createSelectOptions();
        if (!options.length) {
            return false;
        }
        const { selectPlaceholder: placeholder } = this.config;
        this.eSelect = this.createBean(new ag_grid_community_1.AgSelect({
            options,
            placeholder,
            onValueChange: (value) => this.addValue(value),
            pickerIcon: 'chartsMenuAdd',
        }));
        this.getGui().appendChild(this.eSelect.getGui());
        return true;
    }
    createSelectOptions() {
        const options = [];
        const { maxSelection } = this.config;
        if (maxSelection && this.selectedValues.length >= maxSelection) {
            return options;
        }
        this.valueList.forEach((value) => {
            if (!this.selectedValues.includes(value)) {
                options.push({ value, text: this.valueFormatter(value) });
            }
        });
        return options;
    }
    addValue(value) {
        this.dropZonePanel.addItem(value);
    }
    updateValues(values, forceRefreshSelect, silent) {
        const previousSelectedValues = this.selectedValues;
        this.selectedValues = values;
        const changes = this.getChanges(previousSelectedValues, values);
        const refreshSelect = forceRefreshSelect || changes.added.length || changes.removed.length;
        const activeElement = (0, ag_grid_community_1._getActiveDomElement)(this.beans);
        const selectHasFocus = this.eSelect?.getGui().contains(activeElement);
        const dropZoneHasFocus = this.dropZonePanel?.getGui().contains(activeElement);
        if (!silent) {
            this.onValuesChange?.(changes);
        }
        const emptyRefreshedSelect = refreshSelect ? !this.refreshSelect() : false;
        this.dropZonePanel.refreshGui();
        if (refreshSelect && selectHasFocus) {
            if (emptyRefreshedSelect) {
                this.dropZonePanel.focusList(true);
            }
            else {
                this.eSelect?.getFocusableElement().focus();
            }
        }
        if (dropZoneHasFocus && !values.length) {
            this.eSelect?.getFocusableElement().focus();
        }
    }
    getChanges(previousSelectedValues, newSelectedValues) {
        const added = newSelectedValues.filter((value) => !previousSelectedValues.includes(value));
        const removed = previousSelectedValues.filter((value) => !newSelectedValues.includes(value));
        const updated = newSelectedValues.filter((value, index) => previousSelectedValues[index] !== value);
        return { added, removed, updated, selected: newSelectedValues };
    }
    refreshSelect() {
        if (!this.eSelect) {
            return this.initSelect();
        }
        const options = this.createSelectOptions();
        if (!options.length) {
            (0, ag_grid_community_1._removeFromParent)(this.eSelect.getGui());
            this.eSelect = this.destroyBean(this.eSelect);
            return false;
        }
        this.eSelect.clearOptions().addOptions(options).setValue(undefined, true);
        return true;
    }
    destroy() {
        this.destroyBean(this.eSelect);
        super.destroy();
    }
}
exports.AgPillSelect = AgPillSelect;
class PillSelectDragComp extends pillDragComp_1.PillDragComp {
    constructor(value, dragSourceDropTarget, ghost, valueFormatter, draggable, sourceId) {
        super(dragSourceDropTarget, ghost, false);
        this.value = value;
        this.valueFormatter = valueFormatter;
        this.draggable = draggable;
        this.sourceId = sourceId;
    }
    getItem() {
        return this.value;
    }
    getDisplayName() {
        return this.valueFormatter(this.value);
    }
    getAriaDisplayName() {
        return this.getDisplayName();
    }
    getTooltip() {
        return undefined;
    }
    createGetDragItem() {
        return () => ({
            value: this.value,
        });
    }
    getDragSourceType() {
        return ag_grid_community_1.DragSourceType.ChartPanel;
    }
    getDragSourceId() {
        return this.sourceId;
    }
    isDraggable() {
        return this.draggable;
    }
}
class PillSelectDropZonePanel extends pillDropZonePanel_1.PillDropZonePanel {
    constructor(model, valueFormatter, ariaLabel, sourceId) {
        super(false);
        this.model = model;
        this.valueFormatter = valueFormatter;
        this.ariaLabel = ariaLabel;
        this.sourceId = sourceId;
    }
    postConstruct() {
        super.init();
    }
    isItemDroppable(item, draggingEvent) {
        return (this.isSourceEventFromTarget(draggingEvent) ||
            (this.sourceId != null && this.sourceId === draggingEvent.dragSource.sourceId));
    }
    updateItems(items) {
        this.model.setValues(items);
    }
    getExistingItems() {
        return this.model.getValues();
    }
    getIconName() {
        return this.isPotentialDndItems() ? 'move' : 'notAllowed';
    }
    getAriaLabel() {
        return this.ariaLabel;
    }
    createPillComponent(item, dropTarget, ghost) {
        return new PillSelectDragComp(item, dropTarget, ghost, this.valueFormatter, this.model.isDraggable(), this.sourceId);
    }
    getItems(dragItem) {
        return [dragItem.value];
    }
    isInterestedIn(type) {
        return type === ag_grid_community_1.DragSourceType.ChartPanel;
    }
}


/***/ }),

/***/ 5000:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgSliderSelector = exports.AgSlider = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agInputRange_1 = __webpack_require__(5748);
class AgSlider extends ag_grid_community_1.AgAbstractLabel {
    constructor(config) {
        super(config, 
        /* html */ `<div class="ag-slider">
            <label data-ref="eLabel"></label>
            <div class="ag-wrapper ag-slider-wrapper">
                <ag-input-range data-ref="eSlider"></ag-input-range>
                <ag-input-number-field data-ref="eText"></ag-input-number-field>
            </div>
        </div>`, [agInputRange_1.AgInputRangeSelector, ag_grid_community_1.AgInputNumberFieldSelector]);
        this.eLabel = ag_grid_community_1.RefPlaceholder;
        this.eSlider = ag_grid_community_1.RefPlaceholder;
        this.eText = ag_grid_community_1.RefPlaceholder;
        this.labelAlignment = 'top';
    }
    postConstruct() {
        super.postConstruct();
        this.eSlider.addCssClass('ag-slider-field');
        const { minValue, maxValue, textFieldWidth, step, value, onValueChange } = this.config;
        if (minValue != null) {
            this.setMinValue(minValue);
        }
        if (maxValue != null) {
            this.setMaxValue(maxValue);
        }
        if (textFieldWidth != null) {
            this.setTextFieldWidth(textFieldWidth);
        }
        if (step != null) {
            this.setStep(step);
        }
        if (value != null) {
            this.setValue(value);
        }
        if (onValueChange != null) {
            this.onValueChange(onValueChange);
        }
    }
    onValueChange(callbackFn) {
        this.addManagedListeners(this.eText, {
            fieldValueChanged: () => {
                const textValue = parseFloat(this.eText.getValue());
                this.eSlider.setValue(textValue.toString(), true);
                callbackFn(textValue || 0);
            },
        });
        this.addManagedListeners(this.eSlider, {
            fieldValueChanged: () => {
                const sliderValue = this.eSlider.getValue();
                this.eText.setValue(sliderValue, true);
                callbackFn(parseFloat(sliderValue));
            },
        });
        return this;
    }
    setSliderWidth(width) {
        this.eSlider.setWidth(width);
        return this;
    }
    setTextFieldWidth(width) {
        this.eText.setWidth(width);
        return this;
    }
    setMinValue(minValue) {
        this.eSlider.setMinValue(minValue);
        this.eText.setMin(minValue);
        return this;
    }
    setMaxValue(maxValue) {
        this.eSlider.setMaxValue(maxValue);
        this.eText.setMax(maxValue);
        return this;
    }
    getValue() {
        return this.eText.getValue();
    }
    setValue(value, silent) {
        if (this.getValue() === value) {
            return this;
        }
        this.eText.setValue(value, true);
        this.eSlider.setValue(value, true);
        if (!silent) {
            this.dispatchLocalEvent({ type: 'fieldValueChanged' });
        }
        return this;
    }
    setStep(step) {
        this.eSlider.setStep(step);
        this.eText.setStep(step);
        return this;
    }
}
exports.AgSlider = AgSlider;
exports.AgSliderSelector = {
    selector: 'AG-SLIDER',
    component: AgSlider,
};


/***/ }),

/***/ 9112:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.pasteFromClipboard = exports.copySelectedRangeDown = exports.copySelectedRangeToClipboard = exports.copySelectedRowsToClipboard = exports.cutToClipboard = exports.copyToClipboard = void 0;
function copyToClipboard(beans, params) {
    beans.clipboardSvc?.copyToClipboard(params);
}
exports.copyToClipboard = copyToClipboard;
function cutToClipboard(beans, params) {
    beans.clipboardSvc?.cutToClipboard(params);
}
exports.cutToClipboard = cutToClipboard;
function copySelectedRowsToClipboard(beans, params) {
    beans.clipboardSvc?.copySelectedRowsToClipboard(params);
}
exports.copySelectedRowsToClipboard = copySelectedRowsToClipboard;
function copySelectedRangeToClipboard(beans, params) {
    beans.clipboardSvc?.copySelectedRangeToClipboard(params);
}
exports.copySelectedRangeToClipboard = copySelectedRangeToClipboard;
function copySelectedRangeDown(beans) {
    beans.clipboardSvc?.copyRangeDown();
}
exports.copySelectedRangeDown = copySelectedRangeDown;
function pasteFromClipboard(beans) {
    beans.clipboardSvc?.pasteFromClipboard();
}
exports.pasteFromClipboard = pasteFromClipboard;


/***/ }),

/***/ 3766:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClipboardModule = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGridEnterpriseModule_1 = __webpack_require__(9206);
const version_1 = __webpack_require__(7205);
const clipboardApi_1 = __webpack_require__(9112);
const clipboardService_1 = __webpack_require__(5519);
/**
 * @feature Import & Export -> Clipboard
 */
exports.ClipboardModule = {
    moduleName: 'Clipboard',
    version: version_1.VERSION,
    beans: [clipboardService_1.ClipboardService],
    apiFunctions: {
        copyToClipboard: clipboardApi_1.copyToClipboard,
        cutToClipboard: clipboardApi_1.cutToClipboard,
        copySelectedRowsToClipboard: clipboardApi_1.copySelectedRowsToClipboard,
        copySelectedRangeToClipboard: clipboardApi_1.copySelectedRangeToClipboard,
        copySelectedRangeDown: clipboardApi_1.copySelectedRangeDown,
        pasteFromClipboard: clipboardApi_1.pasteFromClipboard,
    },
    dependsOn: [agGridEnterpriseModule_1.EnterpriseCoreModule, ag_grid_community_1.CsvExportModule, ag_grid_community_1._KeyboardNavigationModule, ag_grid_community_1.HighlightChangesModule],
};


/***/ }),

/***/ 5519:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClipboardService = exports.stringToArray = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
// Matches value in changeDetectionService
const SOURCE_PASTE = 'paste';
const EXPORT_TYPE_DRAG_COPY = 'dragCopy';
const EXPORT_TYPE_CLIPBOARD = 'clipboard';
var CellClearType;
(function (CellClearType) {
    CellClearType[CellClearType["CellRange"] = 0] = "CellRange";
    CellClearType[CellClearType["SelectedRows"] = 1] = "SelectedRows";
    CellClearType[CellClearType["FocusedCell"] = 2] = "FocusedCell";
})(CellClearType || (CellClearType = {}));
// This will parse a delimited string into an array of arrays.
function stringToArray(strData, delimiter = ',') {
    const data = [];
    const isNewline = (char) => char === '\r' || char === '\n';
    let insideQuotedField = false;
    if (strData === '') {
        return [['']];
    }
    // iterate over each character, keep track of current row and column (of the returned array)
    for (let row = 0, column = 0, position = 0; position < strData.length; position++) {
        const previousChar = strData[position - 1];
        const currentChar = strData[position];
        const nextChar = strData[position + 1];
        const ensureDataExists = () => {
            if (!data[row]) {
                // create row if it doesn't exist
                data[row] = [];
            }
            if (!data[row][column]) {
                // create column if it doesn't exist
                data[row][column] = '';
            }
        };
        ensureDataExists();
        if (currentChar === '"') {
            if (insideQuotedField) {
                if (nextChar === '"') {
                    // unescape double quote
                    data[row][column] += '"';
                    position++;
                }
                else {
                    // exit quoted field
                    insideQuotedField = false;
                }
                // continue;
            }
            else if (previousChar === undefined || previousChar === delimiter || isNewline(previousChar)) {
                // enter quoted field
                insideQuotedField = true;
                // continue;
            }
        }
        if (!insideQuotedField && currentChar !== '"') {
            if (currentChar === delimiter) {
                // move to next column
                column++;
                ensureDataExists();
                continue;
            }
            else if (isNewline(currentChar)) {
                // move to next row
                column = 0;
                row++;
                ensureDataExists();
                if (currentChar === '\r' && nextChar === '\n') {
                    // skip over second newline character if it exists
                    position++;
                }
                continue;
            }
        }
        // add current character to current column
        data[row][column] += currentChar;
    }
    return data;
}
exports.stringToArray = stringToArray;
class ClipboardService extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'clipboardSvc';
        this.clientSideRowModel = null;
        this.gridCtrl = null;
        this.lastPasteOperationTime = 0;
        this.navigatorApiFailed = false;
    }
    postConstruct() {
        const { gos, rowModel, ctrlsSvc } = this.beans;
        if ((0, ag_grid_community_1._isClientSideRowModel)(gos, rowModel)) {
            this.clientSideRowModel = rowModel;
        }
        ctrlsSvc.whenReady(this, (p) => {
            this.gridCtrl = p.gridCtrl;
        });
    }
    destroy() {
        super.destroy();
        this.clientSideRowModel = null;
        this.gridCtrl = null;
    }
    pasteFromClipboard() {
        // Method 1 - native clipboard API, available in modern chrome browsers
        const allowNavigator = !this.gos.get('suppressClipboardApi');
        // Some browsers (Firefox) do not allow Web Applications to read from
        // the clipboard so verify if not only the ClipboardAPI is available,
        // but also if the `readText` method is public.
        if (allowNavigator && !this.navigatorApiFailed && navigator.clipboard && navigator.clipboard.readText) {
            navigator.clipboard
                .readText()
                .then(this.processClipboardData.bind(this))
                .catch((e) => {
                (0, ag_grid_community_1._warn)(40, { e, method: 'readText' });
                this.navigatorApiFailed = true;
                this.pasteFromClipboardLegacy();
            });
        }
        else {
            this.pasteFromClipboardLegacy();
        }
    }
    pasteFromClipboardLegacy() {
        // Method 2 - if modern API fails, the old school hack
        let defaultPrevented = false;
        const handlePasteEvent = (e) => {
            const currentPastOperationTime = new Date().getTime();
            if (currentPastOperationTime - this.lastPasteOperationTime < 50) {
                defaultPrevented = true;
                e.preventDefault();
            }
            this.lastPasteOperationTime = currentPastOperationTime;
        };
        this.executeOnTempElement((textArea) => {
            textArea.addEventListener('paste', handlePasteEvent);
            textArea.focus({ preventScroll: true });
        }, (element) => {
            const data = element.value;
            if (!defaultPrevented) {
                this.processClipboardData(data);
            }
            else {
                this.refocusLastFocusedCell();
            }
            element.removeEventListener('paste', handlePasteEvent);
        });
    }
    refocusLastFocusedCell() {
        const { focusSvc } = this.beans;
        const focusedCell = focusSvc.getFocusedCell();
        if (focusedCell) {
            focusSvc.setFocusedCell({
                rowIndex: focusedCell.rowIndex,
                column: focusedCell.column,
                rowPinned: focusedCell.rowPinned,
                forceBrowserFocus: true,
            });
        }
    }
    getClipboardDelimiter() {
        const delimiter = this.gos.get('clipboardDelimiter');
        return (0, ag_grid_community_1._exists)(delimiter) ? delimiter : '\t';
    }
    processClipboardData(data) {
        if (data == null) {
            return;
        }
        let parsedData = stringToArray(data, this.getClipboardDelimiter());
        const userFunc = this.gos.getCallback('processDataFromClipboard');
        if (userFunc) {
            parsedData = userFunc({ data: parsedData });
        }
        if (parsedData == null) {
            return;
        }
        if (this.gos.get('suppressLastEmptyLineOnPaste')) {
            this.removeLastLineIfBlank(parsedData);
        }
        const { rangeSvc } = this.beans;
        const pasteOperation = (cellsToFlash, updatedRowNodes, focusedCell, changedPath) => {
            const rangeActive = rangeSvc?.isMoreThanOneCell();
            const pasteIntoRange = rangeActive && !this.hasOnlyOneValueToPaste(parsedData);
            if (pasteIntoRange) {
                this.pasteIntoActiveRange(rangeSvc, parsedData, cellsToFlash, updatedRowNodes, changedPath);
            }
            else {
                this.pasteStartingFromFocusedCell(parsedData, cellsToFlash, updatedRowNodes, focusedCell, changedPath);
            }
        };
        this.doPasteOperation(pasteOperation);
    }
    // common code to paste operations, e.g. paste to cell, paste to range, and copy range down
    doPasteOperation(pasteOperationFunc) {
        const source = 'clipboard';
        const { eventSvc, focusSvc, rowRenderer, gos } = this.beans;
        eventSvc.dispatchEvent({
            type: 'pasteStart',
            source,
        });
        const { clientSideRowModel } = this;
        const rootNode = clientSideRowModel?.rootNode;
        const changedPath = rootNode && new ag_grid_community_1.ChangedPath(gos.get('aggregateOnlyChangedColumns'), rootNode);
        const cellsToFlash = {};
        const updatedRowNodes = [];
        const focusedCell = focusSvc.getFocusedCell();
        pasteOperationFunc(cellsToFlash, updatedRowNodes, focusedCell, changedPath);
        const nodesToRefresh = [...updatedRowNodes];
        if (changedPath) {
            clientSideRowModel.doAggregate(changedPath);
            // add all nodes impacted by aggregation, as they need refreshed also.
            changedPath.forEachChangedNodeDepthFirst((rowNode) => {
                nodesToRefresh.push(rowNode);
            });
        }
        // clipboardSvc has to do changeDetection itself, to prevent repeat logic in favour of batching.
        // changeDetectionSvc is disabled for this action.
        rowRenderer.refreshCells({ rowNodes: nodesToRefresh });
        this.dispatchFlashCells(cellsToFlash);
        this.fireRowChanged(updatedRowNodes);
        // if using the clipboard hack with a temp element, then the focus has been lost,
        // so need to put it back. otherwise paste operation loosed focus on cell and keyboard
        // navigation stops.
        this.refocusLastFocusedCell();
        eventSvc.dispatchEvent({
            type: 'pasteEnd',
            source,
        });
    }
    pasteIntoActiveRange(rangeSvc, clipboardData, cellsToFlash, updatedRowNodes, changedPath) {
        // true if clipboard data can be evenly pasted into range, otherwise false
        const abortRepeatingPasteIntoRows = this.getRangeSize(rangeSvc) % clipboardData.length != 0;
        let indexOffset = 0;
        let dataRowIndex = 0;
        const rowCallback = (currentRow, rowNode, columns, index) => {
            const atEndOfClipboardData = index - indexOffset >= clipboardData.length;
            if (atEndOfClipboardData) {
                if (abortRepeatingPasteIntoRows) {
                    return;
                }
                // increment offset and reset data index to repeat paste of data
                indexOffset += dataRowIndex;
                dataRowIndex = 0;
            }
            const currentRowData = clipboardData[index - indexOffset];
            // otherwise we are not the first row, so copy
            updatedRowNodes.push(rowNode);
            const processCellFromClipboardFunc = this.gos.getCallback('processCellFromClipboard');
            columns.forEach((column, idx) => {
                if (!column.isCellEditable(rowNode) || column.isSuppressPaste(rowNode)) {
                    return;
                }
                // repeat data for columns we don't have data for - happens when to range is bigger than copied data range
                if (idx >= currentRowData.length) {
                    idx = idx % currentRowData.length;
                }
                const newValue = this.processCell(rowNode, column, currentRowData[idx], EXPORT_TYPE_DRAG_COPY, processCellFromClipboardFunc, true);
                rowNode.setDataValue(column, newValue, SOURCE_PASTE);
                if (changedPath) {
                    changedPath.addParentNode(rowNode.parent, [column]);
                }
                const { rowIndex, rowPinned } = currentRow;
                const cellId = (0, ag_grid_community_1._createCellId)({ rowIndex, column, rowPinned });
                cellsToFlash[cellId] = true;
            });
            dataRowIndex++;
        };
        this.iterateActiveRanges(false, rowCallback);
    }
    getDisplayedColumnsStartingAt(column) {
        let currentColumn = column;
        const columns = [];
        const visibleCols = this.beans.visibleCols;
        while (currentColumn != null) {
            columns.push(currentColumn);
            currentColumn = visibleCols.getColAfter(currentColumn);
        }
        return columns;
    }
    pasteStartingFromFocusedCell(parsedData, cellsToFlash, updatedRowNodes, focusedCell, changedPath) {
        if (!focusedCell) {
            return;
        }
        const currentRow = { rowIndex: focusedCell.rowIndex, rowPinned: focusedCell.rowPinned };
        const columnsToPasteInto = this.getDisplayedColumnsStartingAt(focusedCell.column);
        if (this.isPasteSingleValueIntoRange(parsedData)) {
            this.pasteSingleValueIntoRange(parsedData, updatedRowNodes, cellsToFlash, changedPath);
        }
        else {
            this.pasteMultipleValues(parsedData, currentRow, updatedRowNodes, columnsToPasteInto, cellsToFlash, EXPORT_TYPE_CLIPBOARD, changedPath);
        }
    }
    // if range is active, and only one cell, then we paste this cell into all cells in the active range.
    isPasteSingleValueIntoRange(parsedData) {
        const rangeSvc = this.beans.rangeSvc;
        return this.hasOnlyOneValueToPaste(parsedData) && !!rangeSvc && !rangeSvc.isEmpty();
    }
    pasteSingleValueIntoRange(parsedData, updatedRowNodes, cellsToFlash, changedPath) {
        const value = parsedData[0][0];
        const rowCallback = (currentRow, rowNode, columns) => {
            updatedRowNodes.push(rowNode);
            columns.forEach((column) => this.updateCellValue(rowNode, column, value, cellsToFlash, EXPORT_TYPE_CLIPBOARD, changedPath));
        };
        this.iterateActiveRanges(false, rowCallback);
    }
    hasOnlyOneValueToPaste(parsedData) {
        return parsedData.length === 1 && parsedData[0].length === 1;
    }
    copyRangeDown() {
        const { rangeSvc, gos, valueSvc } = this.beans;
        if (!rangeSvc || rangeSvc.isEmpty()) {
            return;
        }
        const firstRowValues = [];
        const pasteOperation = (cellsToFlash, updatedRowNodes, focusedCell, changedPath) => {
            const processCellForClipboardFunc = gos.getCallback('processCellForClipboard');
            const processCellFromClipboardFunc = gos.getCallback('processCellFromClipboard');
            const rowCallback = (currentRow, rowNode, columns) => {
                // take reference of first row, this is the one we will be using to copy from
                if (!firstRowValues.length) {
                    // two reasons for looping through columns
                    columns.forEach((column) => {
                        // get the initial values to copy down
                        const value = this.processCell(rowNode, column, valueSvc.getValue(column, rowNode), EXPORT_TYPE_DRAG_COPY, processCellForClipboardFunc, false, true);
                        firstRowValues.push(value);
                    });
                }
                else {
                    // otherwise we are not the first row, so copy
                    updatedRowNodes.push(rowNode);
                    columns.forEach((column, index) => {
                        if (!column.isCellEditable(rowNode) || column.isSuppressPaste(rowNode)) {
                            return;
                        }
                        const firstRowValue = this.processCell(rowNode, column, firstRowValues[index], EXPORT_TYPE_DRAG_COPY, processCellFromClipboardFunc, true);
                        rowNode.setDataValue(column, firstRowValue, SOURCE_PASTE);
                        if (changedPath) {
                            changedPath.addParentNode(rowNode.parent, [column]);
                        }
                        const { rowIndex, rowPinned } = currentRow;
                        const cellId = (0, ag_grid_community_1._createCellId)({ rowIndex, column, rowPinned });
                        cellsToFlash[cellId] = true;
                    });
                }
            };
            this.iterateActiveRanges(true, rowCallback);
        };
        this.doPasteOperation(pasteOperation);
    }
    removeLastLineIfBlank(parsedData) {
        // remove last row if empty, excel puts empty last row in
        const lastLine = (0, ag_grid_community_1._last)(parsedData);
        const lastLineIsBlank = lastLine && lastLine.length === 1 && lastLine[0] === '';
        if (lastLineIsBlank) {
            // do not remove the last empty line when that is the only line pasted
            if (parsedData.length === 1) {
                return;
            }
            (0, ag_grid_community_1._removeFromArray)(parsedData, lastLine);
        }
    }
    fireRowChanged(rowNodes) {
        if (this.gos.get('editType') !== 'fullRow') {
            return;
        }
        rowNodes.forEach((rowNode) => {
            this.eventSvc.dispatchEvent({
                type: 'rowValueChanged',
                node: rowNode,
                data: rowNode.data,
                rowIndex: rowNode.rowIndex,
                rowPinned: rowNode.rowPinned,
            });
        });
    }
    pasteMultipleValues(clipboardGridData, currentRow, updatedRowNodes, columnsToPasteInto, cellsToFlash, type, changedPath) {
        let rowPointer = currentRow;
        const beans = this.beans;
        const { gos, cellNavigation } = beans;
        // if doing CSRM and NOT tree data, then it means groups are aggregates, which are read only,
        // so we should skip them when doing paste operations.
        const skipGroupRows = this.clientSideRowModel != null && !gos.get('enableGroupEdit') && !gos.get('treeData');
        const getNextGoodRowNode = () => {
            while (true) {
                if (!rowPointer) {
                    return null;
                }
                const res = (0, ag_grid_community_1._getRowNode)(beans, rowPointer);
                // move to next row down for next set of values
                rowPointer = cellNavigation.getRowBelow({
                    rowPinned: rowPointer.rowPinned,
                    rowIndex: rowPointer.rowIndex,
                });
                // if no more rows, return null
                if (res == null) {
                    return null;
                }
                // skip details rows and footer rows, never paste into them as they don't hold data
                const skipRow = res.detail || res.footer || (skipGroupRows && res.group);
                // skipping row means we go into the next iteration of the while loop
                if (!skipRow) {
                    return res;
                }
            }
        };
        clipboardGridData.forEach((clipboardRowData) => {
            const rowNode = getNextGoodRowNode();
            // if we have come to end of rows in grid, then skip
            if (!rowNode) {
                return;
            }
            clipboardRowData.forEach((value, index) => this.updateCellValue(rowNode, columnsToPasteInto[index], value, cellsToFlash, type, changedPath));
            updatedRowNodes.push(rowNode);
        });
    }
    updateCellValue(rowNode, column, value, cellsToFlash, type, changedPath) {
        if (!rowNode || !column || !column.isCellEditable(rowNode) || column.isSuppressPaste(rowNode)) {
            return;
        }
        const processedValue = this.processCell(rowNode, column, value, type, this.gos.getCallback('processCellFromClipboard'), true);
        rowNode.setDataValue(column, processedValue, SOURCE_PASTE);
        const { rowIndex, rowPinned } = rowNode;
        const cellId = (0, ag_grid_community_1._createCellId)({ rowIndex: rowIndex, column, rowPinned });
        cellsToFlash[cellId] = true;
        if (changedPath) {
            changedPath.addParentNode(rowNode.parent, [column]);
        }
    }
    copyToClipboard(params = {}) {
        this.copyOrCutToClipboard(params);
    }
    cutToClipboard(params = {}, source = 'api') {
        if (this.gos.get('suppressCutToClipboard')) {
            return;
        }
        this.eventSvc.dispatchEvent({
            type: 'cutStart',
            source,
        });
        this.copyOrCutToClipboard(params, true);
        this.eventSvc.dispatchEvent({
            type: 'cutEnd',
            source,
        });
    }
    copyOrCutToClipboard(params, cut) {
        let { includeHeaders, includeGroupHeaders } = params;
        const { gos, focusSvc } = this.beans;
        // don't override 'includeHeaders' if it has been explicitly set to 'false'
        if (includeHeaders == null) {
            includeHeaders = gos.get('copyHeadersToClipboard');
        }
        if (includeGroupHeaders == null) {
            includeGroupHeaders = gos.get('copyGroupHeadersToClipboard');
        }
        const copyParams = { includeHeaders, includeGroupHeaders };
        const rowSelection = gos.get('rowSelection');
        const cellSelection = gos.get('cellSelection');
        let cellClearType = null;
        // Copy priority is Range > Row > Focus
        if (this.shouldCopyCells(cellSelection, rowSelection)) {
            this.copySelectedRangeToClipboard(copyParams);
            cellClearType = CellClearType.CellRange;
        }
        else if (this.shouldCopyRows(rowSelection)) {
            this.copySelectedRowsToClipboard(copyParams);
            cellClearType = CellClearType.SelectedRows;
        }
        else if (focusSvc.isAnyCellFocused()) {
            this.copyFocusedCellToClipboard(copyParams);
            cellClearType = CellClearType.FocusedCell;
        }
        if (cut && cellClearType !== null) {
            this.clearCellsAfterCopy(cellClearType);
        }
    }
    shouldCopyCells(cellSelection, rowSelection) {
        const { rangeSvc, selectionSvc, gos } = this.beans;
        if (!rangeSvc || rangeSvc.isEmpty()) {
            return false;
        }
        if (cellSelection) {
            // If `cellSelection` is defined, user is using the new cell selection API, so we only copy
            // cells by default.
            const shouldCopyRowsInstead = typeof rowSelection === 'object' && rowSelection.copySelectedRows && !selectionSvc?.isEmpty();
            return !shouldCopyRowsInstead;
        }
        else {
            // If user is using the deprecated API, we preserve the previous behaviour
            const suppressCopySingleCellRanges = gos.get('suppressCopySingleCellRanges');
            const shouldSkip = !rangeSvc.isMoreThanOneCell() && suppressCopySingleCellRanges;
            return !shouldSkip;
        }
    }
    shouldCopyRows(rowSelection) {
        const { selectionSvc, gos } = this.beans;
        if (selectionSvc?.isEmpty() ?? true) {
            return false;
        }
        if (rowSelection && typeof rowSelection !== 'string') {
            // If `rowSelection` is defined as an object, user is using the new selection API, so we determine
            // behaviour based on `copySelectedRows`
            return rowSelection.copySelectedRows ?? false;
        }
        else {
            // If user is using the deprecated API, we preserve the previous behaviour
            return !gos.get('suppressCopyRowsToClipboard');
        }
    }
    clearCellsAfterCopy(type) {
        const beans = this.beans;
        const { rangeSvc, focusSvc, eventSvc } = beans;
        eventSvc.dispatchEvent({ type: 'keyShortcutChangedCellStart' });
        if (type === CellClearType.CellRange) {
            rangeSvc.clearCellRangeCellValues({ cellEventSource: 'clipboardSvc' });
        }
        else if (type === CellClearType.SelectedRows) {
            this.clearSelectedRows();
        }
        else {
            const focusedCell = focusSvc.getFocusedCell();
            if (focusedCell == null) {
                return;
            }
            const rowNode = (0, ag_grid_community_1._getRowNode)(beans, focusedCell);
            if (rowNode) {
                this.clearCellValue(rowNode, focusedCell.column);
            }
        }
        eventSvc.dispatchEvent({ type: 'keyShortcutChangedCellEnd' });
    }
    clearSelectedRows() {
        const { selectionSvc, visibleCols } = this.beans;
        const selected = selectionSvc?.getSelectedNodes() ?? [];
        const columns = visibleCols.allCols;
        for (const row of selected) {
            for (const col of columns) {
                this.clearCellValue(row, col);
            }
        }
    }
    clearCellValue(rowNode, column) {
        if (!column.isCellEditable(rowNode)) {
            return;
        }
        const emptyValue = this.beans.valueSvc.getDeleteValue(column, rowNode);
        rowNode.setDataValue(column, emptyValue, 'clipboardSvc');
    }
    iterateActiveRanges(onlyFirst, rowCallback, columnCallback) {
        const rangeSvc = this.beans.rangeSvc;
        if (!rangeSvc || rangeSvc.isEmpty()) {
            return;
        }
        const cellRanges = rangeSvc.getCellRanges();
        if (onlyFirst) {
            this.iterateActiveRange(cellRanges[0], rowCallback, columnCallback, true);
        }
        else {
            cellRanges.forEach((range, idx) => this.iterateActiveRange(range, rowCallback, columnCallback, idx === cellRanges.length - 1));
        }
    }
    iterateActiveRange(range, rowCallback, columnCallback, isLastRange) {
        const { rangeSvc, cellNavigation } = this.beans;
        if (!rangeSvc) {
            return;
        }
        let currentRow = rangeSvc.getRangeStartRow(range);
        const lastRow = rangeSvc.getRangeEndRow(range);
        if (columnCallback && range.columns) {
            columnCallback(range.columns);
        }
        let rangeIndex = 0;
        let isLastRow = false;
        // the currentRow could be missing if the user sets the active range manually, and sets a range
        // that is outside of the grid (eg. sets range rows 0 to 100, but grid has only 20 rows).
        while (!isLastRow && currentRow != null) {
            const rowNode = (0, ag_grid_community_1._getRowNode)(this.beans, currentRow);
            isLastRow = (0, ag_grid_community_1._isSameRow)(currentRow, lastRow);
            rowCallback(currentRow, rowNode, range.columns, rangeIndex++, isLastRow && isLastRange);
            currentRow = cellNavigation.getRowBelow(currentRow);
        }
    }
    copySelectedRangeToClipboard(params = {}) {
        const rangeSvc = this.beans.rangeSvc;
        if (!rangeSvc || rangeSvc.isEmpty()) {
            return;
        }
        const allRangesMerge = rangeSvc.areAllRangesAbleToMerge();
        const { data, cellsToFlash } = allRangesMerge
            ? this.buildDataFromMergedRanges(rangeSvc, params)
            : this.buildDataFromRanges(rangeSvc, params);
        this.copyDataToClipboard(data);
        this.dispatchFlashCells(cellsToFlash);
    }
    buildDataFromMergedRanges(rangeSvc, params) {
        const columnsSet = new Set();
        const ranges = rangeSvc.getCellRanges();
        const rowPositionsMap = new Map();
        const allRowPositions = [];
        const allCellsToFlash = {};
        ranges.forEach((range) => {
            range.columns.forEach((col) => columnsSet.add(col));
            const { rowPositions, cellsToFlash } = this.getRangeRowPositionsAndCellsToFlash(rangeSvc, range);
            rowPositions.forEach((rowPosition) => {
                const rowPositionAsString = `${rowPosition.rowIndex}-${rowPosition.rowPinned || 'null'}`;
                if (!rowPositionsMap.get(rowPositionAsString)) {
                    rowPositionsMap.set(rowPositionAsString, true);
                    allRowPositions.push(rowPosition);
                }
            });
            Object.assign(allCellsToFlash, cellsToFlash);
        });
        const allColumns = this.beans.visibleCols.allCols;
        const exportedColumns = Array.from(columnsSet);
        exportedColumns.sort((a, b) => {
            const posA = allColumns.indexOf(a);
            const posB = allColumns.indexOf(b);
            return posA - posB;
        });
        const data = this.buildExportParams({
            columns: exportedColumns,
            rowPositions: allRowPositions,
            includeHeaders: params.includeHeaders,
            includeGroupHeaders: params.includeGroupHeaders,
        });
        return { data, cellsToFlash: allCellsToFlash };
    }
    buildDataFromRanges(rangeSvc, params) {
        const ranges = rangeSvc.getCellRanges();
        const data = [];
        const allCellsToFlash = {};
        ranges.forEach((range) => {
            const { rowPositions, cellsToFlash } = this.getRangeRowPositionsAndCellsToFlash(rangeSvc, range);
            Object.assign(allCellsToFlash, cellsToFlash);
            data.push(this.buildExportParams({
                columns: range.columns,
                rowPositions: rowPositions,
                includeHeaders: params.includeHeaders,
                includeGroupHeaders: params.includeGroupHeaders,
            }));
        });
        return { data: data.join('\n'), cellsToFlash: allCellsToFlash };
    }
    getRangeRowPositionsAndCellsToFlash(rangeSvc, range) {
        const rowPositions = [];
        const cellsToFlash = {};
        const startRow = rangeSvc.getRangeStartRow(range);
        const lastRow = rangeSvc.getRangeEndRow(range);
        let node = startRow;
        while (node) {
            rowPositions.push(node);
            range.columns.forEach((column) => {
                const { rowIndex, rowPinned } = node;
                const cellId = (0, ag_grid_community_1._createCellId)({ rowIndex, column, rowPinned });
                cellsToFlash[cellId] = true;
            });
            if ((0, ag_grid_community_1._isSameRow)(node, lastRow)) {
                break;
            }
            node = this.beans.cellNavigation.getRowBelow(node);
        }
        return { rowPositions, cellsToFlash };
    }
    getCellsToFlashFromRowNodes(rowNodes) {
        const allDisplayedColumns = this.beans.visibleCols.allCols;
        const cellsToFlash = {};
        for (let i = 0; i < rowNodes.length; i++) {
            const { level, rowIndex: index, rowPinned, sibling } = rowNodes[i];
            // Account for the grand total row (sibling of root node)
            const rowIndex = level === -1 ? sibling.rowIndex : index;
            if (rowIndex == null) {
                continue;
            }
            for (let j = 0; j < allDisplayedColumns.length; j++) {
                const column = allDisplayedColumns[j];
                const cellId = (0, ag_grid_community_1._createCellId)({ rowIndex, column, rowPinned });
                cellsToFlash[cellId] = true;
            }
        }
        return cellsToFlash;
    }
    copyFocusedCellToClipboard(params = {}) {
        let focusedCell = this.beans.focusSvc.getFocusedCell();
        if (focusedCell == null) {
            return;
        }
        focusedCell = this.beans.rowSpanSvc?.getCellStart(focusedCell) ?? focusedCell;
        const cellId = (0, ag_grid_community_1._createCellId)(focusedCell);
        const currentRow = { rowPinned: focusedCell.rowPinned, rowIndex: focusedCell.rowIndex };
        const column = focusedCell.column;
        const data = this.buildExportParams({
            columns: [column],
            rowPositions: [currentRow],
            includeHeaders: params.includeHeaders,
            includeGroupHeaders: params.includeGroupHeaders,
        });
        this.copyDataToClipboard(data);
        this.dispatchFlashCells({ [cellId]: true });
    }
    copySelectedRowsToClipboard(params = {}) {
        const { columnKeys, includeHeaders, includeGroupHeaders } = params;
        const data = this.buildExportParams({
            columns: columnKeys,
            includeHeaders,
            includeGroupHeaders,
        });
        this.copyDataToClipboard(data);
        const rowNodes = this.beans.selectionSvc?.getSelectedNodes() || [];
        this.dispatchFlashCells(this.getCellsToFlashFromRowNodes(rowNodes));
    }
    buildExportParams(params) {
        const { columns, rowPositions, includeHeaders = false, includeGroupHeaders = false } = params;
        const { gos, csvCreator } = this.beans;
        const exportParams = {
            columnKeys: columns,
            rowPositions,
            skipColumnHeaders: !includeHeaders,
            skipColumnGroupHeaders: !includeGroupHeaders,
            suppressQuotes: true,
            columnSeparator: this.getClipboardDelimiter(),
            onlySelected: !rowPositions,
            processCellCallback: gos.getCallback('processCellForClipboard'),
            processRowGroupCallback: (params) => this.processRowGroupCallback(params),
            processHeaderCallback: gos.getCallback('processHeaderForClipboard'),
            processGroupHeaderCallback: gos.getCallback('processGroupHeaderForClipboard'),
        };
        return csvCreator.getDataAsCsv(exportParams, true);
    }
    getValueFromNode(node, column) {
        const { gos, valueSvc } = this.beans;
        const isTreeData = gos.get('treeData');
        const isGroupRows = gos.get('groupDisplayType') === 'groupRows';
        // if not tree data then we get the value from the group data
        if (isTreeData || isGroupRows || !column) {
            return node.key;
        }
        const value = node.groupData?.[column.getId()];
        if (!value || !node.rowGroupColumn || node.rowGroupColumn.getColDef().useValueFormatterForExport === false) {
            return value;
        }
        return valueSvc.formatValue(node.rowGroupColumn, node, value) ?? value;
    }
    processRowGroupCallback({ node, column }) {
        let value = this.getValueFromNode(node, column);
        const translate = this.getLocaleTextFunc();
        if (node.footer) {
            let suffix = '';
            if (value && value.length) {
                suffix = ` ${value}`;
            }
            value = `${translate('footerTotal', 'Total')}${suffix}`;
        }
        return value || '';
    }
    // eslint-disable-next-line @typescript-eslint/ban-types
    dispatchFlashCells(cellsToFlash) {
        window.setTimeout(() => {
            this.eventSvc.dispatchEvent({
                type: 'flashCells',
                cells: cellsToFlash,
            });
        }, 0);
    }
    processCell(rowNode, column, value, type, func, canParse, canFormat) {
        const valueSvc = this.beans.valueSvc;
        if (func) {
            const params = {
                column,
                node: rowNode,
                value,
                type,
                formatValue: (valueToFormat) => valueSvc.formatValue(column, rowNode ?? null, valueToFormat) ?? valueToFormat,
                parseValue: (valueToParse) => valueSvc.parseValue(column, rowNode ?? null, valueToParse, valueSvc.getValue(column, rowNode)),
            };
            return func(params);
        }
        if (canParse && column.getColDef().useValueParserForImport !== false) {
            return valueSvc.parseValue(column, rowNode ?? null, value, valueSvc.getValue(column, rowNode));
        }
        if (canFormat && column.getColDef().useValueFormatterForExport !== false) {
            return valueSvc.formatValue(column, rowNode ?? null, value) ?? value;
        }
        return value;
    }
    copyDataToClipboard(data) {
        const userProvidedFunc = this.gos.getCallback('sendToClipboard');
        // method 1 - user provided func
        if (userProvidedFunc) {
            userProvidedFunc({ data });
            return;
        }
        // method 2 - native clipboard API, available in modern chrome browsers
        const allowNavigator = !this.gos.get('suppressClipboardApi');
        if (allowNavigator && navigator.clipboard) {
            navigator.clipboard.writeText(data).catch((e) => {
                (0, ag_grid_community_1._warn)(40, { e, method: 'writeText' });
                this.copyDataToClipboardLegacy(data);
            });
            return;
        }
        this.copyDataToClipboardLegacy(data);
    }
    copyDataToClipboardLegacy(data) {
        // method 3 - if all else fails, the old school hack
        this.executeOnTempElement((element) => {
            const eDocument = (0, ag_grid_community_1._getDocument)(this.beans);
            const focusedElementBefore = (0, ag_grid_community_1._getActiveDomElement)(this.beans);
            element.value = data || ' '; // has to be non-empty value or execCommand will not do anything
            element.select();
            element.focus({ preventScroll: true });
            const result = eDocument.execCommand('copy');
            if (!result) {
                (0, ag_grid_community_1._warn)(41);
            }
            if (focusedElementBefore != null && focusedElementBefore.focus != null) {
                focusedElementBefore.focus({ preventScroll: true });
            }
        });
    }
    executeOnTempElement(callbackNow, callbackAfter) {
        if (!this.gridCtrl) {
            return;
        }
        const eDoc = (0, ag_grid_community_1._getDocument)(this.beans);
        const eTempInput = eDoc.createElement('textarea');
        const style = eTempInput.style;
        style.width = '1px';
        style.height = '1px';
        // removing items from the DOM causes the document element to scroll to the
        // position where the element was positioned. Here we set scrollTop / scrollLeft
        // to prevent the document element from scrolling when we remove it from the DOM.
        const documentElement = eDoc.documentElement;
        style.top = documentElement.scrollTop + 'px';
        style.left = documentElement.scrollLeft + 'px';
        style.position = 'absolute';
        style.opacity = '0';
        const guiRoot = this.gridCtrl.getGui();
        guiRoot.appendChild(eTempInput);
        try {
            callbackNow(eTempInput);
        }
        catch (err) {
            (0, ag_grid_community_1._warn)(42);
        }
        //It needs 100 otherwise OS X seemed to not always be able to paste... Go figure...
        if (callbackAfter) {
            window.setTimeout(() => {
                callbackAfter(eTempInput);
                guiRoot.removeChild(eTempInput);
            }, 100);
        }
        else {
            guiRoot.removeChild(eTempInput);
        }
    }
    getRangeSize(rangeSvc) {
        const ranges = rangeSvc.getCellRanges();
        let startRangeIndex = 0;
        let endRangeIndex = 0;
        if (ranges.length > 0) {
            startRangeIndex = rangeSvc.getRangeStartRow(ranges[0]).rowIndex;
            endRangeIndex = rangeSvc.getRangeEndRow(ranges[0]).rowIndex;
        }
        return startRangeIndex - endRangeIndex + 1;
    }
}
exports.ClipboardService = ClipboardService;


/***/ }),

/***/ 2664:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.agPrimaryColsCSS = void 0;
exports.agPrimaryColsCSS = `.ag-column-select{display:flex;flex:3 1 0px;flex-direction:column;overflow:hidden;position:relative}.ag-column-select-header{align-items:center;display:flex;flex:none;gap:var(--ag-widget-horizontal-spacing);height:var(--ag-header-height);padding-left:var(--ag-widget-container-horizontal-padding);padding-right:var(--ag-widget-container-horizontal-padding);position:relative}.ag-column-select-column,.ag-column-select-column-group{align-items:center;display:flex;gap:var(--ag-widget-horizontal-spacing);height:100%;position:relative;&:where(:not(:last-child)){margin-bottom:var(--ag-widget-vertical-spacing)}}:where(.ag-ltr) .ag-column-select-column,:where(.ag-ltr) .ag-column-select-column-group{padding-left:calc(var(--ag-indentation-level)*var(--ag-column-select-indent-size))}:where(.ag-rtl) .ag-column-select-column,:where(.ag-rtl) .ag-column-select-column-group{padding-right:calc(var(--ag-indentation-level)*var(--ag-column-select-indent-size))}.ag-column-select-header-icon{border-radius:var(--ag-border-radius);cursor:pointer;height:var(--ag-icon-size);position:relative;width:var(--ag-icon-size);&:focus-visible{box-shadow:var(--ag-focus-shadow)}}.ag-column-select-header-filter-wrapper{flex:1 1 auto}.ag-column-select-header-filter{width:100%}.ag-column-select-list{flex:1 1 0px;overflow:hidden}:where(.ag-ltr) .ag-column-select-add-group-indent{margin-left:calc(var(--ag-icon-size) + var(--ag-spacing)*1.5)}:where(.ag-rtl) .ag-column-select-add-group-indent{margin-right:calc(var(--ag-icon-size) + var(--ag-spacing)*1.5)}.ag-column-select-column-group-readonly,.ag-column-select-column-readonly{opacity:.5;pointer-events:none}.ag-column-select-virtual-list-viewport{padding:calc(var(--ag-widget-container-vertical-padding)*.5) 0}.ag-column-select-virtual-list-item{padding:0 var(--ag-widget-container-horizontal-padding)}.ag-column-select-column-label{flex:1 1 auto;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.ag-column-select-checkbox{display:flex}`;


/***/ }),

/***/ 1269:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPrimaryColsSelector = exports.AgPrimaryCols = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agPrimaryCols_css_GENERATED_1 = __webpack_require__(2664);
const agPrimaryColsHeader_1 = __webpack_require__(4312);
const agPrimaryColsList_1 = __webpack_require__(5853);
class AgPrimaryCols extends ag_grid_community_1.Component {
    constructor() {
        super(
        /* html */ `<div class="ag-column-select">
            <ag-primary-cols-header data-ref="primaryColsHeaderPanel"></ag-primary-cols-header>
            <ag-primary-cols-list data-ref="primaryColsListPanel"></ag-primary-cols-list>
        </div>`, [agPrimaryColsHeader_1.AgPrimaryColsHeaderSelector, agPrimaryColsList_1.AgPrimaryColsListSelector]);
        this.primaryColsHeaderPanel = ag_grid_community_1.RefPlaceholder;
        this.primaryColsListPanel = ag_grid_community_1.RefPlaceholder;
        this.registerCSS(agPrimaryCols_css_GENERATED_1.agPrimaryColsCSS);
    }
    // we allow dragging in the toolPanel, but not when this component appears in the column menu
    init(allowDragging, params, eventType) {
        const { primaryColsHeaderPanel, primaryColsListPanel } = this;
        primaryColsHeaderPanel.init(params);
        const hideFilter = params.suppressColumnFilter;
        const hideSelect = params.suppressColumnSelectAll;
        const hideExpand = params.suppressColumnExpandAll;
        if (hideExpand && hideFilter && hideSelect) {
            primaryColsHeaderPanel.setDisplayed(false);
        }
        this.addManagedListeners(primaryColsListPanel, {
            groupExpanded: (event) => {
                primaryColsHeaderPanel.setExpandState(event.state);
                params.onStateUpdated();
            },
            selectionChanged: (event) => primaryColsHeaderPanel.setSelectionState(event.state),
        });
        primaryColsListPanel.init(params, allowDragging, eventType);
        this.addManagedListeners(primaryColsHeaderPanel, {
            expandAll: primaryColsListPanel.doSetExpandedAll.bind(primaryColsListPanel, true),
            collapseAll: primaryColsListPanel.doSetExpandedAll.bind(primaryColsListPanel, false),
            selectAll: primaryColsListPanel.doSetSelectedAll.bind(primaryColsListPanel, true),
            unselectAll: primaryColsListPanel.doSetSelectedAll.bind(primaryColsListPanel, false),
            filterChanged: (event) => primaryColsListPanel.setFilterText(event.filterText),
        });
        this.positionableFeature = this.createManagedBean(new ag_grid_community_1.PositionableFeature(this.getGui(), { minHeight: 100 }));
    }
    toggleResizable(resizable) {
        this.positionableFeature.setResizable(resizable ? { bottom: true } : false);
    }
    expandGroups(groupIds) {
        this.primaryColsListPanel.setGroupsExpanded(true, groupIds);
    }
    collapseGroups(groupIds) {
        this.primaryColsListPanel.setGroupsExpanded(false, groupIds);
    }
    setColumnLayout(colDefs) {
        this.primaryColsListPanel.setColumnLayout(colDefs);
    }
    syncLayoutWithGrid() {
        this.primaryColsListPanel.onColumnsChanged();
    }
    getExpandedGroups() {
        return this.primaryColsListPanel.getExpandedGroups();
    }
}
exports.AgPrimaryCols = AgPrimaryCols;
exports.AgPrimaryColsSelector = {
    selector: 'AG-PRIMARY-COLS',
    component: AgPrimaryCols,
};


/***/ }),

/***/ 4312:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPrimaryColsHeaderSelector = exports.AgPrimaryColsHeader = exports.ExpandState = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
var ExpandState;
(function (ExpandState) {
    ExpandState[ExpandState["EXPANDED"] = 0] = "EXPANDED";
    ExpandState[ExpandState["COLLAPSED"] = 1] = "COLLAPSED";
    ExpandState[ExpandState["INDETERMINATE"] = 2] = "INDETERMINATE";
})(ExpandState || (exports.ExpandState = ExpandState = {}));
const DEBOUNCE_DELAY = 300;
class AgPrimaryColsHeader extends ag_grid_community_1.Component {
    constructor() {
        super(
        /* html */ `<div class="ag-column-select-header" role="presentation">
            <div data-ref="eExpand" class="ag-column-select-header-icon"></div>
            <ag-checkbox data-ref="eSelect" class="ag-column-select-header-checkbox"></ag-checkbox>
            <ag-input-text-field class="ag-column-select-header-filter-wrapper" data-ref="eFilterTextField"></ag-input-text-field>
        </div>`, [ag_grid_community_1.AgCheckboxSelector, ag_grid_community_1.AgInputTextFieldSelector]);
        this.eExpand = ag_grid_community_1.RefPlaceholder;
        this.eSelect = ag_grid_community_1.RefPlaceholder;
        this.eFilterTextField = ag_grid_community_1.RefPlaceholder;
    }
    postConstruct() {
        this.createExpandIcons();
        this.addManagedListeners(this.eExpand, {
            click: this.onExpandClicked.bind(this),
            keydown: (e) => {
                if (e.key === ag_grid_community_1.KeyCode.SPACE) {
                    e.preventDefault();
                    this.onExpandClicked();
                }
            },
        });
        this.addManagedElementListeners(this.eSelect.getInputElement(), { click: this.onSelectClicked.bind(this) });
        this.addManagedPropertyListener('functionsReadOnly', () => this.onFunctionsReadOnlyPropChanged());
        this.eFilterTextField.setAutoComplete(false).onValueChange(() => this.onFilterTextChanged());
        this.addManagedEventListeners({ newColumnsLoaded: this.showOrHideOptions.bind(this) });
        const translate = this.getLocaleTextFunc();
        this.eSelect.setInputAriaLabel(translate('ariaColumnSelectAll', 'Toggle All Columns Visibility'));
        this.eFilterTextField.setInputAriaLabel(translate('ariaFilterColumnsInput', 'Filter Columns Input'));
        this.activateTabIndex([this.eExpand]);
    }
    onFunctionsReadOnlyPropChanged() {
        const readOnly = this.gos.get('functionsReadOnly');
        this.eSelect.setReadOnly(readOnly);
        this.eSelect.addOrRemoveCssClass('ag-column-select-column-readonly', readOnly);
    }
    init(params) {
        this.params = params;
        const readOnly = this.gos.get('functionsReadOnly');
        this.eSelect.setReadOnly(readOnly);
        this.eSelect.addOrRemoveCssClass('ag-column-select-column-readonly', readOnly);
        if (this.beans.colModel.ready) {
            this.showOrHideOptions();
        }
    }
    createExpandIcons() {
        const beans = this.beans;
        this.eExpand.appendChild((this.eExpandChecked = (0, ag_grid_community_1._createIconNoSpan)('columnSelectOpen', beans)));
        this.eExpand.appendChild((this.eExpandUnchecked = (0, ag_grid_community_1._createIconNoSpan)('columnSelectClosed', beans)));
        this.eExpand.appendChild((this.eExpandIndeterminate = (0, ag_grid_community_1._createIconNoSpan)('columnSelectIndeterminate', beans)));
        this.setExpandState(ExpandState.EXPANDED);
    }
    // we only show expand / collapse if we are showing columns
    showOrHideOptions() {
        const params = this.params;
        const showFilter = !params.suppressColumnFilter;
        const showSelect = !params.suppressColumnSelectAll;
        const showExpand = !params.suppressColumnExpandAll;
        const groupsPresent = !!this.beans.colModel.colDefCols?.treeDepth;
        const translate = this.getLocaleTextFunc();
        this.eFilterTextField.setInputPlaceholder(translate('searchOoo', 'Search...'));
        (0, ag_grid_community_1._setDisplayed)(this.eFilterTextField.getGui(), showFilter);
        (0, ag_grid_community_1._setDisplayed)(this.eSelect.getGui(), showSelect);
        (0, ag_grid_community_1._setDisplayed)(this.eExpand, showExpand && groupsPresent);
    }
    onFilterTextChanged() {
        if (!this.onFilterTextChangedDebounced) {
            this.onFilterTextChangedDebounced = (0, ag_grid_community_1._debounce)(this, () => {
                const filterText = this.eFilterTextField.getValue();
                this.dispatchLocalEvent({ type: 'filterChanged', filterText: filterText });
            }, DEBOUNCE_DELAY);
        }
        this.onFilterTextChangedDebounced();
    }
    onSelectClicked() {
        this.dispatchLocalEvent({ type: this.selectState ? 'unselectAll' : 'selectAll' });
    }
    onExpandClicked() {
        this.dispatchLocalEvent({ type: this.expandState === ExpandState.EXPANDED ? 'collapseAll' : 'expandAll' });
    }
    setExpandState(state) {
        this.expandState = state;
        (0, ag_grid_community_1._setDisplayed)(this.eExpandChecked, state === ExpandState.EXPANDED);
        (0, ag_grid_community_1._setDisplayed)(this.eExpandUnchecked, state === ExpandState.COLLAPSED);
        (0, ag_grid_community_1._setDisplayed)(this.eExpandIndeterminate, state === ExpandState.INDETERMINATE);
    }
    setSelectionState(state) {
        this.selectState = state;
        this.eSelect.setValue(this.selectState);
    }
}
exports.AgPrimaryColsHeader = AgPrimaryColsHeader;
exports.AgPrimaryColsHeaderSelector = {
    selector: 'AG-PRIMARY-COLS-HEADER',
    component: AgPrimaryColsHeader,
};


/***/ }),

/***/ 5853:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AgPrimaryColsListSelector = exports.AgPrimaryColsList = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const toolPanelColDefService_1 = __webpack_require__(6092);
const virtualList_1 = __webpack_require__(7904);
const agPrimaryColsHeader_1 = __webpack_require__(4312);
const columnModelItem_1 = __webpack_require__(2176);
const modelItemUtils_1 = __webpack_require__(4781);
const primaryColsListPanelItemDragFeature_1 = __webpack_require__(3234);
const toolPanelColumnComp_1 = __webpack_require__(4545);
const toolPanelColumnGroupComp_1 = __webpack_require__(4224);
class UIColumnModel {
    constructor(items) {
        this.items = items;
    }
    getRowCount() {
        return this.items.length;
    }
    getRow(index) {
        return this.items[index];
    }
}
const PRIMARY_COLS_LIST_PANEL_CLASS = 'ag-column-select-list';
class AgPrimaryColsList extends ag_grid_community_1.Component {
    wireBeans(beans) {
        this.colModel = beans.colModel;
    }
    constructor() {
        super(/* html */ `<div class="${PRIMARY_COLS_LIST_PANEL_CLASS}" role="presentation"></div>`);
        this.destroyColumnItemFuncs = [];
        this.hasLoadedInitialState = false;
        this.isInitialState = false;
    }
    destroy() {
        this.destroyColumnTree();
        super.destroy();
    }
    destroyColumnTree() {
        this.allColsTree = [];
        this.destroyColumnItemFuncs.forEach((f) => f());
        this.destroyColumnItemFuncs = [];
    }
    init(params, allowDragging, eventType) {
        this.params = params;
        this.allowDragging = allowDragging;
        this.eventType = eventType;
        if (!params.suppressSyncLayoutWithGrid) {
            this.addManagedEventListeners({ columnMoved: this.onColumnsChanged.bind(this) });
        }
        this.addManagedEventListeners({
            newColumnsLoaded: this.onColumnsChanged.bind(this),
        });
        const listener = this.fireSelectionChangedEvent.bind(this);
        this.addManagedEventListeners({
            columnPivotChanged: listener,
            columnPivotModeChanged: listener,
            columnRowGroupChanged: listener,
            columnValueChanged: listener,
            columnVisible: listener,
            newColumnsLoaded: listener,
        });
        this.expandGroupsByDefault = !params.contractColumnSelection;
        const virtualList = this.createManagedBean(new virtualList_1.VirtualList({
            cssIdentifier: 'column-select',
            ariaRole: 'tree',
        }));
        this.virtualList = virtualList;
        this.appendChild(virtualList.getGui());
        virtualList.setComponentCreator((item, listItemElement) => {
            (0, ag_grid_community_1._setAriaLevel)(listItemElement, item.depth + 1);
            return this.createComponentFromItem(item, listItemElement);
        });
        if (this.colModel.ready) {
            this.onColumnsChanged();
        }
        if (params.suppressColumnMove) {
            return;
        }
        this.createManagedBean(new primaryColsListPanelItemDragFeature_1.PrimaryColsListPanelItemDragFeature(this, virtualList));
    }
    createComponentFromItem(item, listItemElement) {
        const allowDragging = this.allowDragging;
        if (item.group) {
            const renderedGroup = new toolPanelColumnGroupComp_1.ToolPanelColumnGroupComp(item, allowDragging, this.eventType, listItemElement);
            this.createBean(renderedGroup);
            return renderedGroup;
        }
        const columnComp = new toolPanelColumnComp_1.ToolPanelColumnComp(item, allowDragging, this.groupsExist, listItemElement);
        this.createBean(columnComp);
        return columnComp;
    }
    onColumnsChanged() {
        const params = this.params;
        if (!this.hasLoadedInitialState) {
            this.hasLoadedInitialState = true;
            this.isInitialState = !!params.initialState;
        }
        const expandedStates = this.getExpandedStates();
        const pivotModeActive = this.colModel.isPivotMode();
        const shouldSyncColumnLayoutWithGrid = !params.suppressSyncLayoutWithGrid && !pivotModeActive;
        if (shouldSyncColumnLayoutWithGrid) {
            this.buildTreeFromWhatGridIsDisplaying();
        }
        else {
            this.buildTreeFromProvidedColumnDefs();
        }
        this.setExpandedStates(expandedStates);
        this.markFilteredColumns();
        this.flattenAndFilterModel();
        this.isInitialState = false;
    }
    getDisplayedColsList() {
        return this.displayedColsList;
    }
    getExpandedStates() {
        const res = {};
        if (this.isInitialState) {
            const { expandedGroupIds } = this.params.initialState;
            expandedGroupIds.forEach((id) => {
                res[id] = true;
            });
            return res;
        }
        if (!this.allColsTree) {
            return {};
        }
        this.forEachItem((item) => {
            if (!item.group) {
                return;
            }
            const colGroup = item.columnGroup;
            if (colGroup) {
                // group should always exist, this is defensive
                res[colGroup.getId()] = item.expanded;
            }
        });
        return res;
    }
    setExpandedStates(states) {
        if (!this.allColsTree) {
            return;
        }
        const { isInitialState } = this;
        this.forEachItem((item) => {
            if (!item.group) {
                return;
            }
            const colGroup = item.columnGroup;
            if (colGroup) {
                // group should always exist, this is defensive
                const expanded = states[colGroup.getId()];
                const groupExistedLastTime = expanded != null;
                if (groupExistedLastTime || isInitialState) {
                    item.expanded = !!expanded;
                }
            }
        });
    }
    buildTreeFromWhatGridIsDisplaying() {
        (0, toolPanelColDefService_1.syncLayoutWithGrid)(this.colModel, this.setColumnLayout.bind(this));
    }
    setColumnLayout(colDefs) {
        const columnTree = (0, toolPanelColDefService_1.toolPanelCreateColumnTree)(this.colModel, colDefs);
        this.buildListModel(columnTree);
        // using col defs to check if groups exist as it could be a custom layout
        this.groupsExist = colDefs.some((colDef) => {
            return colDef && typeof colDef.children !== 'undefined';
        });
        this.markFilteredColumns();
        this.flattenAndFilterModel();
    }
    buildTreeFromProvidedColumnDefs() {
        const colModel = this.colModel;
        // add column / group comps to tool panel
        this.buildListModel(colModel.getColDefColTree());
        this.groupsExist = !!colModel.colDefCols?.treeDepth;
    }
    buildListModel(columnTree) {
        const columnExpandedListener = this.onColumnExpanded.bind(this);
        const addListeners = (item) => {
            item.addEventListener('expandedChanged', columnExpandedListener);
            const removeFunc = item.removeEventListener.bind(item, 'expandedChanged', columnExpandedListener);
            this.destroyColumnItemFuncs.push(removeFunc);
        };
        const colNames = this.beans.colNames;
        const recursivelyBuild = (tree, dept, parentList) => {
            tree.forEach((child) => {
                if ((0, ag_grid_community_1.isProvidedColumnGroup)(child)) {
                    createGroupItem(child, dept, parentList);
                }
                else {
                    createColumnItem(child, dept, parentList);
                }
            });
        };
        const createGroupItem = (columnGroup, dept, parentList) => {
            const columnGroupDef = columnGroup.getColGroupDef();
            const skipThisGroup = columnGroupDef && columnGroupDef.suppressColumnsToolPanel;
            if (skipThisGroup) {
                return;
            }
            if (columnGroup.isPadding()) {
                recursivelyBuild(columnGroup.getChildren(), dept, parentList);
                return;
            }
            const displayName = colNames.getDisplayNameForProvidedColumnGroup(null, columnGroup, 'columnToolPanel');
            const item = new columnModelItem_1.ColumnModelItem(displayName, columnGroup, dept, true, this.expandGroupsByDefault);
            parentList.push(item);
            addListeners(item);
            recursivelyBuild(columnGroup.getChildren(), dept + 1, item.children);
        };
        const createColumnItem = (column, dept, parentList) => {
            const skipThisColumn = column.getColDef() && column.getColDef().suppressColumnsToolPanel;
            if (skipThisColumn) {
                return;
            }
            const displayName = colNames.getDisplayNameForColumn(column, 'columnToolPanel');
            parentList.push(new columnModelItem_1.ColumnModelItem(displayName, column, dept));
        };
        this.destroyColumnTree();
        recursivelyBuild(columnTree, 0, this.allColsTree);
    }
    onColumnExpanded() {
        this.flattenAndFilterModel();
    }
    flattenAndFilterModel() {
        this.displayedColsList = [];
        const recursiveFunc = (item) => {
            if (!item.passesFilter) {
                return;
            }
            this.displayedColsList.push(item);
            if (item.group && item.expanded) {
                item.children.forEach(recursiveFunc);
            }
        };
        const virtualList = this.virtualList;
        this.allColsTree.forEach(recursiveFunc);
        virtualList.setModel(new UIColumnModel(this.displayedColsList));
        const focusedRow = virtualList.getLastFocusedRow();
        virtualList.refresh();
        if (focusedRow != null) {
            this.focusRowIfAlive(focusedRow);
        }
        this.notifyListeners();
        this.refreshAriaLabel();
    }
    refreshAriaLabel() {
        const translate = this.getLocaleTextFunc();
        const columnListName = translate('ariaColumnPanelList', 'Column List');
        const localeColumns = translate('columns', 'Columns');
        const items = this.displayedColsList.length;
        (0, ag_grid_community_1._setAriaLabel)(this.virtualList.getAriaElement(), `${columnListName} ${items} ${localeColumns}`);
    }
    focusRowIfAlive(rowIndex) {
        window.setTimeout(() => {
            if (this.isAlive()) {
                this.virtualList.focusRow(rowIndex);
            }
        }, 0);
    }
    forEachItem(callback) {
        const recursiveFunc = (items) => {
            items.forEach((item) => {
                callback(item);
                if (item.group) {
                    recursiveFunc(item.children);
                }
            });
        };
        const allColsTree = this.allColsTree;
        if (!allColsTree) {
            return;
        }
        recursiveFunc(allColsTree);
    }
    doSetExpandedAll(value) {
        this.forEachItem((item) => {
            if (item.group) {
                item.expanded = value;
            }
        });
    }
    setGroupsExpanded(expand, groupIds) {
        if (!groupIds) {
            this.doSetExpandedAll(expand);
            return;
        }
        const expandedGroupIds = [];
        this.forEachItem((item) => {
            if (!item.group) {
                return;
            }
            const groupId = item.columnGroup.getId();
            if (groupIds.indexOf(groupId) >= 0) {
                item.expanded = expand;
                expandedGroupIds.push(groupId);
            }
        });
        const unrecognisedGroupIds = groupIds.filter((groupId) => !expandedGroupIds.includes(groupId));
        if (unrecognisedGroupIds.length > 0) {
            (0, ag_grid_community_1._warn)(157, { unrecognisedGroupIds });
        }
    }
    getExpandState() {
        let expandedCount = 0;
        let notExpandedCount = 0;
        this.forEachItem((item) => {
            if (!item.group) {
                return;
            }
            if (item.expanded) {
                expandedCount++;
            }
            else {
                notExpandedCount++;
            }
        });
        if (expandedCount > 0 && notExpandedCount > 0) {
            return agPrimaryColsHeader_1.ExpandState.INDETERMINATE;
        }
        if (notExpandedCount > 0) {
            return agPrimaryColsHeader_1.ExpandState.COLLAPSED;
        }
        return agPrimaryColsHeader_1.ExpandState.EXPANDED;
    }
    doSetSelectedAll(selectAllChecked) {
        (0, modelItemUtils_1.selectAllChildren)(this.beans, this.allColsTree, selectAllChecked, this.eventType);
    }
    getSelectionState() {
        let checkedCount = 0;
        let uncheckedCount = 0;
        const pivotMode = this.colModel.isPivotMode();
        this.forEachItem((item) => {
            if (item.group) {
                return;
            }
            if (!item.passesFilter) {
                return;
            }
            const column = item.column;
            const colDef = column.getColDef();
            let checked;
            if (pivotMode) {
                const noPivotModeOptionsAllowed = !column.isAllowPivot() && !column.isAllowRowGroup() && !column.isAllowValue();
                if (noPivotModeOptionsAllowed) {
                    return;
                }
                checked = column.isValueActive() || column.isPivotActive() || column.isRowGroupActive();
            }
            else {
                if (colDef.lockVisible) {
                    return;
                }
                checked = column.isVisible();
            }
            checked ? checkedCount++ : uncheckedCount++;
        });
        if (checkedCount > 0 && uncheckedCount > 0) {
            return undefined;
        }
        return !(checkedCount === 0 || uncheckedCount > 0);
    }
    setFilterText(filterText) {
        this.filterText = (0, ag_grid_community_1._exists)(filterText) ? filterText.toLowerCase() : null;
        this.markFilteredColumns();
        this.flattenAndFilterModel();
    }
    markFilteredColumns() {
        const passesFilter = (item) => {
            if (!(0, ag_grid_community_1._exists)(this.filterText)) {
                return true;
            }
            const displayName = item.displayName;
            return displayName == null || displayName.toLowerCase().indexOf(this.filterText) !== -1;
        };
        const recursivelyCheckFilter = (item, parentPasses) => {
            let atLeastOneChildPassed = false;
            if (item.group) {
                const groupPasses = passesFilter(item);
                item.children.forEach((child) => {
                    const childPasses = recursivelyCheckFilter(child, groupPasses || parentPasses);
                    if (childPasses) {
                        atLeastOneChildPassed = childPasses;
                    }
                });
            }
            const filterPasses = parentPasses || atLeastOneChildPassed ? true : passesFilter(item);
            item.passesFilter = filterPasses;
            return filterPasses;
        };
        this.allColsTree.forEach((item) => recursivelyCheckFilter(item, false));
    }
    notifyListeners() {
        this.fireGroupExpandedEvent();
        this.fireSelectionChangedEvent();
    }
    fireGroupExpandedEvent() {
        const expandState = this.getExpandState();
        this.dispatchLocalEvent({ type: 'groupExpanded', state: expandState });
    }
    fireSelectionChangedEvent() {
        if (!this.allColsTree) {
            return;
        }
        const selectionState = this.getSelectionState();
        this.dispatchLocalEvent({ type: 'selectionChanged', state: selectionState });
    }
    getExpandedGroups() {
        const expandedGroupIds = [];
        if (!this.allColsTree) {
            return expandedGroupIds;
        }
        this.forEachItem((item) => {
            if (item.group && item.expanded) {
                expandedGroupIds.push(item.columnGroup.getId());
            }
        });
        return expandedGroupIds;
    }
}
exports.AgPrimaryColsList = AgPrimaryColsList;
exports.AgPrimaryColsListSelector = {
    selector: 'AG-PRIMARY-COLS-LIST',
    component: AgPrimaryColsList,
};


/***/ }),

/***/ 2176:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnModelItem = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class ColumnModelItem {
    constructor(displayName, columnOrGroup, depth, group = false, expanded) {
        this.displayName = displayName;
        this.depth = depth;
        this.group = group;
        this.localEventService = new ag_grid_community_1.LocalEventService();
        if (group) {
            this.columnGroup = columnOrGroup;
            this._expanded = expanded;
            this.children = [];
        }
        else {
            this.column = columnOrGroup;
        }
    }
    get expanded() {
        return !!this._expanded;
    }
    set expanded(expanded) {
        if (expanded === this._expanded) {
            return;
        }
        this._expanded = expanded;
        this.localEventService.dispatchEvent({ type: 'expandedChanged' });
    }
    addEventListener(eventType, listener) {
        this.localEventService.addEventListener(eventType, listener);
    }
    removeEventListener(eventType, listener) {
        this.localEventService.removeEventListener(eventType, listener);
    }
}
exports.ColumnModelItem = ColumnModelItem;


/***/ }),

/***/ 7367:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.columnToolPanelCSS = void 0;
exports.columnToolPanelCSS = `.ag-column-panel{display:flex;flex:1 1 auto;flex-direction:column;overflow:hidden}.ag-pivot-mode-panel{display:flex;height:var(--ag-header-height)}.ag-pivot-mode-select{align-items:center;display:flex}:where(.ag-ltr) .ag-pivot-mode-select{margin-left:var(--ag-widget-container-horizontal-padding)}:where(.ag-rtl) .ag-pivot-mode-select{margin-right:var(--ag-widget-container-horizontal-padding)}.ag-column-panel-column-select{border-bottom:var(--ag-tool-panel-separator-border)}.ag-column-panel-column-select:where(:nth-child(n+2 of :not(.ag-hidden))){border-top:var(--ag-tool-panel-separator-border)}:where(.ag-column-panel) .ag-column-drop-vertical{flex:1 1 0px;min-height:50px;&:where(:not(.ag-last-column-drop)){border-bottom:var(--ag-tool-panel-separator-border)}}`;


/***/ }),

/***/ 4142:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnToolPanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agPrimaryCols_1 = __webpack_require__(1269);
const columnToolPanel_css_GENERATED_1 = __webpack_require__(7367);
class ColumnToolPanel extends ag_grid_community_1.Component {
    constructor() {
        super(/* html */ `<div class="ag-column-panel"></div>`);
        this.initialised = false;
        this.childDestroyFuncs = [];
        this.registerCSS(columnToolPanel_css_GENERATED_1.columnToolPanelCSS);
    }
    wireBeans(beans) {
        this.colToolPanelFactory = beans.colToolPanelFactory;
    }
    // lazy initialise the panel
    setVisible(visible) {
        super.setDisplayed(visible);
        if (visible && !this.initialised) {
            this.init(this.params);
        }
    }
    init(params) {
        const defaultParams = (0, ag_grid_community_1._addGridCommonParams)(this.gos, {
            suppressColumnMove: false,
            suppressColumnSelectAll: false,
            suppressColumnFilter: false,
            suppressColumnExpandAll: false,
            contractColumnSelection: false,
            suppressPivotMode: false,
            suppressRowGroups: false,
            suppressValues: false,
            suppressPivots: false,
            suppressSyncLayoutWithGrid: false,
        });
        const mergedParams = {
            ...defaultParams,
            ...params,
        };
        this.params = mergedParams;
        const { childDestroyFuncs, colToolPanelFactory, gos } = this;
        const hasPivotModule = gos.isModuleRegistered('SharedPivot');
        const hasRowGroupingModule = hasPivotModule || gos.isModuleRegistered('SharedRowGrouping');
        if (!mergedParams.suppressPivotMode && colToolPanelFactory && hasPivotModule) {
            this.pivotModePanel = colToolPanelFactory.createPivotModePanel(this, childDestroyFuncs);
        }
        // DO NOT CHANGE TO createManagedBean
        const primaryColsPanel = this.createBean(new agPrimaryCols_1.AgPrimaryCols());
        this.primaryColsPanel = primaryColsPanel;
        childDestroyFuncs.push(() => this.destroyBean(this.primaryColsPanel));
        primaryColsPanel.init(true, mergedParams, 'toolPanelUi');
        primaryColsPanel.addCssClass('ag-column-panel-column-select');
        this.appendChild(primaryColsPanel);
        if (colToolPanelFactory) {
            if (!mergedParams.suppressRowGroups && hasRowGroupingModule) {
                this.rowGroupDropZonePanel = colToolPanelFactory.createRowGroupPanel(this, childDestroyFuncs);
            }
            if (!mergedParams.suppressValues && hasRowGroupingModule) {
                this.valuesDropZonePanel = colToolPanelFactory.createValuesPanel(this, childDestroyFuncs);
            }
            if (!mergedParams.suppressPivots && hasPivotModule) {
                this.pivotDropZonePanel = colToolPanelFactory.createPivotPanel(this, childDestroyFuncs);
            }
            this.setLastVisible();
            const [pivotModeListener] = this.addManagedEventListeners({
                columnPivotModeChanged: () => {
                    this.resetChildrenHeight();
                    this.setLastVisible();
                },
            });
            childDestroyFuncs.push(() => pivotModeListener());
        }
        this.initialised = true;
    }
    setPivotModeSectionVisible(visible) {
        const colToolPanelFactory = this.colToolPanelFactory;
        if (!colToolPanelFactory) {
            return;
        }
        this.pivotModePanel = colToolPanelFactory.setPanelVisible(this.pivotModePanel, visible, colToolPanelFactory.createPivotModePanel.bind(colToolPanelFactory, this, this.childDestroyFuncs, true));
        this.setLastVisible();
    }
    setRowGroupsSectionVisible(visible) {
        const colToolPanelFactory = this.colToolPanelFactory;
        if (!colToolPanelFactory) {
            return;
        }
        this.rowGroupDropZonePanel = colToolPanelFactory.setPanelVisible(this.rowGroupDropZonePanel, visible, colToolPanelFactory.createRowGroupPanel.bind(colToolPanelFactory, this, this.childDestroyFuncs));
        this.setLastVisible();
    }
    setValuesSectionVisible(visible) {
        const colToolPanelFactory = this.colToolPanelFactory;
        if (!colToolPanelFactory) {
            return;
        }
        this.valuesDropZonePanel = colToolPanelFactory.setPanelVisible(this.valuesDropZonePanel, visible, colToolPanelFactory.createValuesPanel.bind(colToolPanelFactory, this, this.childDestroyFuncs));
        this.setLastVisible();
    }
    setPivotSectionVisible(visible) {
        const colToolPanelFactory = this.colToolPanelFactory;
        if (!colToolPanelFactory) {
            return;
        }
        this.pivotDropZonePanel = colToolPanelFactory.setPanelVisible(this.pivotDropZonePanel, visible, colToolPanelFactory.createPivotPanel.bind(colToolPanelFactory, this, this.childDestroyFuncs));
        this.pivotDropZonePanel?.setDisplayed(visible);
        this.setLastVisible();
    }
    setResizers() {
        [this.primaryColsPanel, this.rowGroupDropZonePanel, this.valuesDropZonePanel, this.pivotDropZonePanel].forEach((panel) => {
            if (!panel) {
                return;
            }
            const eGui = panel.getGui();
            panel.toggleResizable(!eGui.classList.contains('ag-last-column-drop') && !eGui.classList.contains('ag-hidden'));
        });
    }
    setLastVisible() {
        const eGui = this.getGui();
        const columnDrops = Array.prototype.slice.call(eGui.querySelectorAll('.ag-column-drop'));
        columnDrops.forEach((columnDrop) => columnDrop.classList.remove('ag-last-column-drop'));
        const columnDropEls = eGui.querySelectorAll('.ag-column-drop:not(.ag-hidden)');
        const lastVisible = (0, ag_grid_community_1._last)(columnDropEls);
        if (lastVisible) {
            lastVisible.classList.add('ag-last-column-drop');
        }
        this.setResizers();
    }
    resetChildrenHeight() {
        const eGui = this.getGui();
        const children = eGui.children;
        for (let i = 0; i < children.length; i++) {
            const { style } = children[i];
            style.removeProperty('height');
            style.removeProperty('flex');
        }
    }
    expandColumnGroups(groupIds) {
        this.primaryColsPanel.expandGroups(groupIds);
    }
    collapseColumnGroups(groupIds) {
        this.primaryColsPanel.collapseGroups(groupIds);
    }
    setColumnLayout(colDefs) {
        this.primaryColsPanel.setColumnLayout(colDefs);
    }
    syncLayoutWithGrid() {
        this.primaryColsPanel.syncLayoutWithGrid();
    }
    destroyChildren() {
        const childDestroyFuncs = this.childDestroyFuncs;
        childDestroyFuncs.forEach((func) => func());
        childDestroyFuncs.length = 0;
        (0, ag_grid_community_1._clearElement)(this.getGui());
    }
    refresh(params) {
        this.destroyChildren();
        this.init(params);
        return true;
    }
    getState() {
        return {
            expandedGroupIds: this.primaryColsPanel.getExpandedGroups(),
        };
    }
    destroy() {
        this.destroyChildren();
        super.destroy();
    }
}
exports.ColumnToolPanel = ColumnToolPanel;


/***/ }),

/***/ 8698:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnToolPanelFactory = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const pivotDropZonePanel_1 = __webpack_require__(6491);
const rowGroupDropZonePanel_1 = __webpack_require__(4552);
const valueDropZonePanel_1 = __webpack_require__(3392);
const pivotModePanel_1 = __webpack_require__(4465);
class ColumnToolPanelFactory extends ag_grid_community_1.BeanStub {
    constructor() {
        super(...arguments);
        this.beanName = 'colToolPanelFactory';
    }
    setPanelVisible(existingPanel, visible, createFunc) {
        if (existingPanel) {
            existingPanel.setDisplayed(visible);
        }
        else if (visible) {
            existingPanel = createFunc();
        }
        return existingPanel;
    }
    createRowGroupPanel(parent, destroyFuncs) {
        return this.createPanel(parent, destroyFuncs, new rowGroupDropZonePanel_1.RowGroupDropZonePanel(false));
    }
    createValuesPanel(parent, destroyFuncs) {
        return this.createPanel(parent, destroyFuncs, new valueDropZonePanel_1.ValuesDropZonePanel(false));
    }
    createPivotPanel(parent, destroyFuncs) {
        return this.createPanel(parent, destroyFuncs, new pivotDropZonePanel_1.PivotDropZonePanel(false));
    }
    createPivotModePanel(parent, destroyFuncs, prepend) {
        return this.createPanel(parent, destroyFuncs, new pivotModePanel_1.PivotModePanel(), prepend);
    }
    createPanel(parent, destroyFuncs, panel, prepend) {
        panel = parent.createBean(panel);
        destroyFuncs.push(() => parent.destroyBean(panel));
        if (prepend) {
            parent.prependChild(panel);
        }
        else {
            parent.appendChild(panel);
        }
        return panel;
    }
}
exports.ColumnToolPanelFactory = ColumnToolPanelFactory;


/***/ }),

/***/ 6455:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ColumnsToolPanelModule = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const agGridEnterpriseModule_1 = __webpack_require__(9206);
const sideBarModule_1 = __webpack_require__(6358);
const version_1 = __webpack_require__(7205);
const menuItemModule_1 = __webpack_require__(3375);
const columnToolPanel_1 = __webpack_require__(4142);
const columnToolPanelFactory_1 = __webpack_require__(8698);
/**
 * @feature Accessories -> Columns Tool Panel
 */
exports.ColumnsToolPanelModule = {
    moduleName: 'ColumnsToolPanel',
    version: version_1.VERSION,
    beans: [columnToolPanelFactory_1.ColumnToolPanelFactory],
    userComponents: { agColumnsToolPanel: columnToolPanel_1.ColumnToolPanel },
    icons: {
        // column tool panel tab
        columnsToolPanel: 'columns',
        // "Group by {column-name}" item in column header menu
        menuAddRowGroup: 'group',
        // "Un-Group by {column-name}" item in column header menu
        menuRemoveRowGroup: 'group',
        // identifies the pivot drop zone
        pivotPanel: 'pivot',
        // "Row groups" drop zone in column tool panel
        rowGroupPanel: 'group',
        // columns tool panel Values drop zone
        valuePanel: 'aggregation',
        // column tool panel column group contracted (click to expand)
        columnSelectClosed: 'tree-closed',
        // column tool panel column group expanded (click to contract)
        columnSelectOpen: 'tree-open',
        // column tool panel header expand/collapse all button, shown when some children are expanded and
        //     others are collapsed
        columnSelectIndeterminate: 'tree-indeterminate',
    },
    dependsOn: [
        agGridEnterpriseModule_1.EnterpriseCoreModule,
        sideBarModule_1.SideBarModule,
        ag_grid_community_1._ColumnMoveModule,
        ag_grid_community_1._SharedDragAndDropModule,
        ag_grid_community_1._PopupModule,
        menuItemModule_1.MenuItemModule,
    ],
};


/***/ }),

/***/ 4781:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createPivotState = exports.updateColumns = exports.setAllColumns = exports.selectAllChildren = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
function selectAllChildren(beans, colTree, selectAllChecked, eventType) {
    const cols = extractAllLeafColumns(colTree);
    setAllColumns(beans, cols, selectAllChecked, eventType);
}
exports.selectAllChildren = selectAllChildren;
function setAllColumns(beans, cols, selectAllChecked, eventType) {
    if (beans.colModel.isPivotMode()) {
        setAllPivot(beans, cols, selectAllChecked, eventType);
    }
    else {
        setAllVisible(beans, cols, selectAllChecked, eventType);
    }
}
exports.setAllColumns = setAllColumns;
function extractAllLeafColumns(allItems) {
    const res = [];
    const recursiveFunc = (items) => {
        items.forEach((item) => {
            if (!item.passesFilter) {
                return;
            }
            if (item.group) {
                recursiveFunc(item.children);
            }
            else {
                res.push(item.column);
            }
        });
    };
    recursiveFunc(allItems);
    return res;
}
function setAllVisible(beans, columns, visible, eventType) {
    const colStateItems = [];
    columns.forEach((col) => {
        if (col.getColDef().lockVisible) {
            return;
        }
        if (col.isVisible() != visible) {
            colStateItems.push({
                colId: col.getId(),
                hide: !visible,
            });
        }
    });
    if (colStateItems.length > 0) {
        (0, ag_grid_community_1._applyColumnState)(beans, { state: colStateItems }, eventType);
    }
    beans.selectionColSvc?.refreshVisibility(eventType);
}
function setAllPivot(beans, columns, value, eventType) {
    setAllPivotActive(beans, columns, value, eventType);
}
function setAllPivotActive(beans, columns, value, eventType) {
    const colStateItems = [];
    const turnOnAction = (col) => {
        // don't change any column that's already got a function active
        if (col.isAnyFunctionActive()) {
            return;
        }
        if (col.isAllowValue()) {
            const aggFunc = typeof col.getAggFunc() === 'string' ? col.getAggFunc() : beans.aggFuncSvc?.getDefaultAggFunc(col);
            colStateItems.push({
                colId: col.getId(),
                aggFunc: aggFunc,
            });
        }
        else if (col.isAllowRowGroup()) {
            colStateItems.push({
                colId: col.getId(),
                rowGroup: true,
            });
        }
        else if (col.isAllowPivot()) {
            colStateItems.push({
                colId: col.getId(),
                pivot: true,
            });
        }
    };
    const turnOffAction = (col) => {
        const isActive = col.isPivotActive() || col.isRowGroupActive() || col.isValueActive();
        if (isActive) {
            colStateItems.push({
                colId: col.getId(),
                pivot: false,
                rowGroup: false,
                aggFunc: null,
            });
        }
    };
    const action = value ? turnOnAction : turnOffAction;
    columns.forEach(action);
    if (colStateItems.length > 0) {
        (0, ag_grid_community_1._applyColumnState)(beans, { state: colStateItems }, eventType);
    }
}
function updateColumns(beans, params) {
    const { columns, visibleState, pivotState, eventType } = params;
    const state = columns.map((column) => {
        const colId = column.getColId();
        if (beans.colModel.isPivotMode()) {
            const pivotStateForColumn = pivotState?.[colId];
            return {
                colId,
                pivot: pivotStateForColumn?.pivot,
                rowGroup: pivotStateForColumn?.rowGroup,
                aggFunc: pivotStateForColumn?.aggFunc,
            };
        }
        else {
            return {
                colId,
                hide: !visibleState?.[colId],
            };
        }
    });
    (0, ag_grid_community_1._applyColumnState)(beans, { state }, eventType);
}
exports.updateColumns = updateColumns;
function createPivotState(column) {
    return {
        pivot: column.isPivotActive(),
        rowGroup: column.isRowGroupActive(),
        aggFunc: column.isValueActive() ? column.getAggFunc() : undefined,
    };
}
exports.createPivotState = createPivotState;


/***/ }),

/***/ 4465:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PivotModePanel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
class PivotModePanel extends ag_grid_community_1.Component {
    constructor() {
        super(...arguments);
        this.cbPivotMode = ag_grid_community_1.RefPlaceholder;
    }
    createTemplate() {
        return /* html */ `<div class="ag-pivot-mode-panel">
                <ag-toggle-button data-ref="cbPivotMode" class="ag-pivot-mode-select"></ag-toggle-button>
            </div>`;
    }
    postConstruct() {
        this.setTemplate(this.createTemplate(), [ag_grid_community_1.AgToggleButtonSelector]);
        const cbPivotMode = this.cbPivotMode;
        const { colModel, ctrlsSvc, gos } = this.beans;
        cbPivotMode.setValue(colModel.isPivotMode());
        const localeTextFunc = this.getLocaleTextFunc();
        cbPivotMode.setLabel(localeTextFunc('pivotMode', 'Pivot Mode'));
        const onBtPivotMode = () => {
            const newValue = !!cbPivotMode.getValue();
            if (newValue !== colModel.isPivotMode()) {
                gos.updateGridOptions({ options: { pivotMode: newValue }, source: 'toolPanelUi' });
                ctrlsSvc.getHeaderRowContainerCtrls().forEach((c) => c.refresh());
            }
        };
        const onPivotModeChanged = () => {
            const pivotModeActive = colModel.isPivotMode();
            cbPivotMode.setValue(pivotModeActive);
        };
        this.addManagedListeners(cbPivotMode, { fieldValueChanged: onBtPivotMode });
        this.addManagedEventListeners({
            newColumnsLoaded: onPivotModeChanged,
            columnPivotModeChanged: onPivotModeChanged,
        });
    }
}
exports.PivotModePanel = PivotModePanel;


/***/ }),

/***/ 3234:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PrimaryColsListPanelItemDragFeature = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const virtualListDragFeature_1 = __webpack_require__(5760);
const toolPanelColumnGroupComp_1 = __webpack_require__(4224);
class PrimaryColsListPanelItemDragFeature extends ag_grid_community_1.BeanStub {
    constructor(comp, virtualList) {
        super();
        this.comp = comp;
        this.virtualList = virtualList;
    }
    postConstruct() {
        this.createManagedBean(new virtualListDragFeature_1.VirtualListDragFeature(this.comp, this.virtualList, {
            dragSourceType: ag_grid_community_1.DragSourceType.ToolPanel,
            listItemDragStartEvent: 'columnPanelItemDragStart',
            listItemDragEndEvent: 'columnPanelItemDragEnd',
            eventSource: this.eventSvc,
            getCurrentDragValue: (listItemDragStartEvent) => this.getCurrentDragValue(listItemDragStartEvent),
            isMoveBlocked: (currentDragValue) => this.isMoveBlocked(currentDragValue),
            getNumRows: (comp) => comp.getDisplayedColsList().length,
            moveItem: (currentDragValue, lastHoveredListItem) => this.moveItem(this.getCurrentColumnsBeingMoved(currentDragValue), lastHoveredListItem),
        }));
    }
    getCurrentDragValue(listItemDragStartEvent) {
        return listItemDragStartEvent.column;
    }
    getCurrentColumnsBeingMoved(column) {
        if ((0, ag_grid_community_1.isProvidedColumnGroup)(column)) {
            return column.getLeafColumns();
        }
        return column ? [column] : [];
    }
    isMoveBlocked(currentDragValue) {
        const preventMoving = this.gos.get('suppressMovableColumns');
        if (preventMoving) {
            return true;
        }
        const currentColumns = this.getCurrentColumnsBeingMoved(currentDragValue);
        const hasNotMovable = currentColumns.find((col) => {
            const colDef = col.getColDef();
            return !!colDef.suppressMovable || !!colDef.lockPosition;
        });
        return !!hasNotMovable;
    }
    moveItem(currentColumns, lastHoveredListItem) {
        if (!lastHoveredListItem) {
            return;
        }
        const { component } = lastHoveredListItem;
        let lastHoveredColumn = null;
        let isBefore = lastHoveredListItem.position === 'top';
        if (component instanceof toolPanelColumnGroupComp_1.ToolPanelColumnGroupComp) {
            const columns = component.getColumns();
            lastHoveredColumn = columns[0];
            isBefore = true;
        }
        else if (component) {
            lastHoveredColumn = component.column;
        }
        if (!lastHoveredColumn) {
            return;
        }
        const targetIndex = this.getMoveTargetIndex({
            currentColumns,
            lastHoveredColumn,
            isBefore,
        });
        if (targetIndex != null) {
            this.beans.colMoves?.moveColumns(currentColumns, targetIndex, 'toolPanelUi');
        }
    }
    getMoveTargetIndex(params) {
        const { currentColumns, lastHoveredColumn, isBefore } = params;
        if (!lastHoveredColumn || !currentColumns) {
            return null;
        }
        const allColumns = this.beans.colModel.getCols();
        const targetColumnIndex = allColumns.indexOf(lastHoveredColumn);
        const adjustedTarget = isBefore ? targetColumnIndex : targetColumnIndex + 1;
        const diff = this.getMoveDiff(allColumns, currentColumns, adjustedTarget);
        return adjustedTarget - diff;
    }
    getMoveDiff(allColumns, currentColumns, end) {
        if (!currentColumns) {
            return 0;
        }
        const targetColumn = currentColumns[0];
        const span = currentColumns.length;
        const currentIndex = allColumns.indexOf(targetColumn);
        if (currentIndex < end) {
            return span;
        }
        return 0;
    }
}
exports.PrimaryColsListPanelItemDragFeature = PrimaryColsListPanelItemDragFeature;


/***/ }),

/***/ 4545:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolPanelColumnComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const modelItemUtils_1 = __webpack_require__(4781);
const toolPanelContextMenu_1 = __webpack_require__(334);
class ToolPanelColumnComp extends ag_grid_community_1.Component {
    constructor(modelItem, allowDragging, groupsExist, focusWrapper) {
        super();
        this.allowDragging = allowDragging;
        this.groupsExist = groupsExist;
        this.focusWrapper = focusWrapper;
        this.eLabel = ag_grid_community_1.RefPlaceholder;
        this.cbSelect = ag_grid_community_1.RefPlaceholder;
        this.processingColumnStateChange = false;
        const { column, depth, displayName } = modelItem;
        this.column = column;
        this.columnDept = depth;
        this.displayName = displayName;
    }
    postConstruct() {
        this.setTemplate(
        /* html */
        `<div class="ag-column-select-column">
                <ag-checkbox data-ref="cbSelect" class="ag-column-select-checkbox"></ag-checkbox>
                <span class="ag-column-select-column-label" data-ref="eLabel"></span>
            </div>`, [ag_grid_community_1.AgCheckboxSelector]);
        const { beans, cbSelect, displayName, eLabel, columnDept: indent, groupsExist, column, gos, focusWrapper, } = this;
        const eDragHandle = (0, ag_grid_community_1._createIconNoSpan)('columnDrag', beans);
        this.eDragHandle = eDragHandle;
        eDragHandle.classList.add('ag-drag-handle', 'ag-column-select-column-drag-handle');
        const checkboxGui = cbSelect.getGui();
        const checkboxInput = cbSelect.getInputElement();
        checkboxGui.insertAdjacentElement('afterend', eDragHandle);
        checkboxInput.setAttribute('tabindex', '-1');
        const displayNameSanitised = (0, ag_grid_community_1._escapeString)(displayName);
        eLabel.innerHTML = displayNameSanitised;
        // if grouping, we add an extra level of indent, to cater for expand/contract icons we need to indent for
        if (groupsExist) {
            this.addCssClass('ag-column-select-add-group-indent');
        }
        this.addCssClass(`ag-column-select-indent-${indent}`);
        this.getGui().style.setProperty('--ag-indentation-level', String(indent));
        this.tooltipFeature = this.createOptionalManagedBean(beans.registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.getGui(),
            getLocation: () => 'columnToolPanelColumn',
            getColDef: () => column.getColDef(),
            shouldDisplayTooltip: (0, ag_grid_community_1._getShouldDisplayTooltip)(gos, () => eLabel),
        }));
        this.setupDragging();
        const onColStateChanged = this.onColumnStateChanged.bind(this);
        this.addManagedEventListeners({ columnPivotModeChanged: onColStateChanged });
        this.addManagedListeners(column, {
            columnValueChanged: onColStateChanged,
            columnPivotChanged: onColStateChanged,
            columnRowGroupChanged: onColStateChanged,
            visibleChanged: onColStateChanged,
        });
        this.addManagedListeners(focusWrapper, {
            keydown: this.handleKeyDown.bind(this),
            contextmenu: this.onContextMenu.bind(this),
        });
        this.addManagedPropertyListener('functionsReadOnly', this.onColumnStateChanged.bind(this));
        this.addManagedListeners(cbSelect, { fieldValueChanged: this.onCheckboxChanged.bind(this) });
        this.addManagedElementListeners(eLabel, { click: this.onLabelClicked.bind(this) });
        this.onColumnStateChanged();
        this.refreshAriaLabel();
        this.setupTooltip();
        const classes = (0, ag_grid_community_1._getToolPanelClassesFromColDef)(column.getColDef(), gos, column, null);
        classes.forEach((c) => this.addOrRemoveCssClass(c, true));
    }
    getColumn() {
        return this.column;
    }
    setupTooltip() {
        const refresh = () => this.tooltipFeature?.setTooltipAndRefresh(this.column.getColDef().headerTooltip);
        refresh();
        this.addManagedEventListeners({ newColumnsLoaded: refresh });
    }
    onContextMenu(e) {
        const { column, gos } = this;
        if (gos.get('functionsReadOnly')) {
            return;
        }
        const contextMenu = this.createBean(new toolPanelContextMenu_1.ToolPanelContextMenu(column, e, this.focusWrapper));
        this.addDestroyFunc(() => {
            if (contextMenu.isAlive()) {
                this.destroyBean(contextMenu);
            }
        });
    }
    handleKeyDown(e) {
        if (e.key === ag_grid_community_1.KeyCode.SPACE) {
            e.preventDefault();
            if (this.isSelectable()) {
                this.onSelectAllChanged(!this.isSelected());
            }
        }
    }
    onLabelClicked() {
        if (this.gos.get('functionsReadOnly')) {
            return;
        }
        const nextState = !this.cbSelect.getValue();
        this.onChangeCommon(nextState);
    }
    onCheckboxChanged(event) {
        this.onChangeCommon(event.selected);
    }
    onChangeCommon(nextState) {
        // ignore lock visible columns
        if (this.cbSelect.isReadOnly()) {
            return;
        }
        this.refreshAriaLabel();
        // only want to action if the user clicked the checkbox, not if we are setting the checkbox because
        // of a change in the model
        if (this.processingColumnStateChange) {
            return;
        }
        (0, modelItemUtils_1.setAllColumns)(this.beans, [this.column], nextState, 'toolPanelUi');
    }
    refreshAriaLabel() {
        const { cbSelect, focusWrapper, displayName } = this;
        const translate = this.getLocaleTextFunc();
        const columnLabel = translate('ariaColumn', 'Column');
        const state = cbSelect.getValue() ? translate('ariaVisible', 'visible') : translate('ariaHidden', 'hidden');
        const visibilityLabel = translate('ariaToggleVisibility', 'Press SPACE to toggle visibility');
        (0, ag_grid_community_1._setAriaLabel)(focusWrapper, `${displayName} ${columnLabel}`);
        this.cbSelect.setInputAriaLabel(`${visibilityLabel} (${state})`);
        (0, ag_grid_community_1._setAriaDescribedBy)(focusWrapper, cbSelect.getInputElement().id);
    }
    setupDragging() {
        const eDragHandle = this.eDragHandle;
        if (!this.allowDragging) {
            (0, ag_grid_community_1._setDisplayed)(eDragHandle, false);
            return;
        }
        const beans = this.beans;
        const { gos, eventSvc, dragAndDrop } = beans;
        let hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
        const dragSource = {
            type: ag_grid_community_1.DragSourceType.ToolPanel,
            eElement: eDragHandle,
            dragItemName: this.displayName,
            getDefaultIconName: () => (hideColumnOnExit ? 'hide' : 'notAllowed'),
            getDragItem: () => this.createDragItem(),
            onDragStarted: () => {
                hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
                eventSvc.dispatchEvent({
                    type: 'columnPanelItemDragStart',
                    column: this.column,
                });
            },
            onDragStopped: () => {
                eventSvc.dispatchEvent({
                    type: 'columnPanelItemDragEnd',
                });
            },
            onGridEnter: (dragItem) => {
                if (hideColumnOnExit) {
                    // when dragged into the grid, restore the state that was active pre-drag
                    (0, modelItemUtils_1.updateColumns)(beans, {
                        columns: [this.column],
                        visibleState: dragItem?.visibleState,
                        pivotState: dragItem?.pivotState,
                        eventType: 'toolPanelUi',
                    });
                }
            },
            onGridExit: () => {
                if (hideColumnOnExit) {
                    // when dragged outside of the grid, mimic what happens when checkbox is disabled
                    // this handles the behaviour for pivot which is different to just hiding a column.
                    this.onChangeCommon(false);
                }
            },
        };
        dragAndDrop.addDragSource(dragSource, true);
        this.addDestroyFunc(() => dragAndDrop.removeDragSource(dragSource));
    }
    createDragItem() {
        const colId = this.column.getColId();
        const visibleState = { [colId]: this.column.isVisible() };
        const pivotState = { [colId]: (0, modelItemUtils_1.createPivotState)(this.column) };
        return {
            columns: [this.column],
            visibleState,
            pivotState,
        };
    }
    onColumnStateChanged() {
        this.processingColumnStateChange = true;
        const isPivotMode = this.beans.colModel.isPivotMode();
        if (isPivotMode) {
            // if reducing, checkbox means column is one of pivot, value or group
            const anyFunctionActive = this.column.isAnyFunctionActive();
            this.cbSelect.setValue(anyFunctionActive);
        }
        else {
            // if not reducing, the checkbox tells us if column is visible or not
            this.cbSelect.setValue(this.column.isVisible());
        }
        let canBeToggled = true;
        let canBeDragged = true;
        if (isPivotMode) {
            // when in pivot mode, the item should be read only if:
            //  a) gui is not allowed make any changes
            const functionsReadOnly = this.gos.get('functionsReadOnly');
            //  b) column is not allow any functions on it
            const noFunctionsAllowed = !this.column.isAnyFunctionAllowed();
            canBeToggled = !functionsReadOnly && !noFunctionsAllowed;
            canBeDragged = canBeToggled;
        }
        else {
            const { enableRowGroup, enableValue, lockPosition, suppressMovable, lockVisible } = this.column.getColDef();
            const forceDraggable = !!enableRowGroup || !!enableValue;
            const disableDraggable = !!lockPosition || !!suppressMovable;
            canBeToggled = !lockVisible;
            canBeDragged = forceDraggable || !disableDraggable;
        }
        this.cbSelect.setReadOnly(!canBeToggled);
        this.eDragHandle.classList.toggle('ag-column-select-column-readonly', !canBeDragged);
        this.addOrRemoveCssClass('ag-column-select-column-readonly', !canBeDragged && !canBeToggled);
        this.cbSelect.setPassive(false);
        this.processingColumnStateChange = false;
    }
    getDisplayName() {
        return this.displayName;
    }
    onSelectAllChanged(value) {
        const cbSelect = this.cbSelect;
        if (value !== cbSelect.getValue()) {
            if (!cbSelect.isReadOnly()) {
                cbSelect.toggle();
            }
        }
    }
    isSelected() {
        return this.cbSelect.getValue();
    }
    isSelectable() {
        return !this.cbSelect.isReadOnly();
    }
    isExpandable() {
        return false;
    }
    setExpanded(_value) {
        (0, ag_grid_community_1._warn)(158);
    }
}
exports.ToolPanelColumnComp = ToolPanelColumnComp;


/***/ }),

/***/ 4224:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolPanelColumnGroupComp = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const modelItemUtils_1 = __webpack_require__(4781);
const toolPanelContextMenu_1 = __webpack_require__(334);
class ToolPanelColumnGroupComp extends ag_grid_community_1.Component {
    constructor(modelItem, allowDragging, eventType, focusWrapper) {
        super();
        this.modelItem = modelItem;
        this.allowDragging = allowDragging;
        this.eventType = eventType;
        this.focusWrapper = focusWrapper;
        this.cbSelect = ag_grid_community_1.RefPlaceholder;
        this.eLabel = ag_grid_community_1.RefPlaceholder;
        this.eGroupOpenedIcon = ag_grid_community_1.RefPlaceholder;
        this.eGroupClosedIcon = ag_grid_community_1.RefPlaceholder;
        this.eColumnGroupIcons = ag_grid_community_1.RefPlaceholder;
        this.processingColumnStateChange = false;
        const { columnGroup, depth, displayName } = modelItem;
        this.columnGroup = columnGroup;
        this.columnDepth = depth;
        this.displayName = displayName;
    }
    postConstruct() {
        this.setTemplate(
        /* html */
        `<div class="ag-column-select-column-group">
                <span class="ag-column-group-icons" data-ref="eColumnGroupIcons" >
                    <span class="ag-column-group-closed-icon" data-ref="eGroupClosedIcon"></span>
                    <span class="ag-column-group-opened-icon" data-ref="eGroupOpenedIcon"></span>
                </span>
                <ag-checkbox data-ref="cbSelect" class="ag-column-select-checkbox"></ag-checkbox>
                <span class="ag-column-select-column-label" data-ref="eLabel"></span>
            </div>`, [ag_grid_community_1.AgCheckboxSelector]);
        const { beans, cbSelect, eLabel, displayName, columnDepth: columnDept, modelItem, focusWrapper, columnGroup, } = this;
        const { registry, gos } = beans;
        const eDragHandle = (0, ag_grid_community_1._createIconNoSpan)('columnDrag', beans);
        this.eDragHandle = eDragHandle;
        eDragHandle.classList.add('ag-drag-handle', 'ag-column-select-column-group-drag-handle');
        const checkboxGui = cbSelect.getGui();
        const checkboxInput = cbSelect.getInputElement();
        checkboxGui.insertAdjacentElement('afterend', eDragHandle);
        checkboxInput.setAttribute('tabindex', '-1');
        eLabel.innerHTML = displayName ?? '';
        this.setupExpandContract();
        this.addCssClass('ag-column-select-indent-' + columnDept);
        this.getGui().style.setProperty('--ag-indentation-level', String(columnDept));
        this.tooltipFeature = this.createOptionalManagedBean(registry.createDynamicBean('tooltipFeature', false, {
            getGui: () => this.getGui(),
            getLocation: () => 'columnToolPanelColumnGroup',
            shouldDisplayTooltip: (0, ag_grid_community_1._getShouldDisplayTooltip)(gos, () => eLabel),
        }));
        this.addManagedEventListeners({ columnPivotModeChanged: this.onColumnStateChanged.bind(this) });
        this.addManagedElementListeners(eLabel, { click: this.onLabelClicked.bind(this) });
        this.addManagedListeners(cbSelect, { fieldValueChanged: this.onCheckboxChanged.bind(this) });
        this.addManagedListeners(modelItem, { expandedChanged: this.onExpandChanged.bind(this) });
        this.addManagedListeners(focusWrapper, {
            keydown: this.handleKeyDown.bind(this),
            contextmenu: this.onContextMenu.bind(this),
        });
        this.setOpenClosedIcons();
        this.setupDragging();
        this.onColumnStateChanged();
        this.addVisibilityListenersToAllChildren();
        this.refreshAriaExpanded();
        this.refreshAriaLabel();
        this.setupTooltip();
        const classes = (0, ag_grid_community_1._getToolPanelClassesFromColDef)(columnGroup.getColGroupDef(), gos, null, columnGroup);
        classes.forEach((c) => this.addOrRemoveCssClass(c, true));
    }
    getColumns() {
        return this.columnGroup.getLeafColumns();
    }
    setupTooltip() {
        const colGroupDef = this.columnGroup.getColGroupDef();
        if (!colGroupDef) {
            return;
        }
        const refresh = () => this.tooltipFeature?.setTooltipAndRefresh(colGroupDef.headerTooltip);
        refresh();
        this.addManagedEventListeners({ newColumnsLoaded: refresh });
    }
    handleKeyDown(e) {
        switch (e.key) {
            case ag_grid_community_1.KeyCode.LEFT:
                e.preventDefault();
                this.modelItem.expanded = false;
                break;
            case ag_grid_community_1.KeyCode.RIGHT:
                e.preventDefault();
                this.modelItem.expanded = true;
                break;
            case ag_grid_community_1.KeyCode.SPACE:
                e.preventDefault();
                if (this.isSelectable()) {
                    this.onSelectAllChanged(!this.isSelected());
                }
                break;
        }
    }
    onContextMenu(e) {
        const { columnGroup, gos } = this;
        if (gos.get('functionsReadOnly')) {
            return;
        }
        const contextMenu = this.createBean(new toolPanelContextMenu_1.ToolPanelContextMenu(columnGroup, e, this.focusWrapper));
        this.addDestroyFunc(() => {
            if (contextMenu.isAlive()) {
                this.destroyBean(contextMenu);
            }
        });
    }
    addVisibilityListenersToAllChildren() {
        const listener = this.onColumnStateChanged.bind(this);
        this.columnGroup.getLeafColumns().forEach((column) => {
            this.addManagedListeners(column, {
                visibleChanged: listener,
                columnValueChanged: listener,
                columnPivotChanged: listener,
                columnRowGroupChanged: listener,
            });
        });
    }
    setupDragging() {
        if (!this.allowDragging) {
            (0, ag_grid_community_1._setDisplayed)(this.eDragHandle, false);
            return;
        }
        const beans = this.beans;
        const { gos, eventSvc, dragAndDrop } = beans;
        let hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
        const dragSource = {
            type: ag_grid_community_1.DragSourceType.ToolPanel,
            eElement: this.eDragHandle,
            dragItemName: this.displayName,
            getDefaultIconName: () => (hideColumnOnExit ? 'hide' : 'notAllowed'),
            getDragItem: () => this.createDragItem(),
            onDragStarted: () => {
                hideColumnOnExit = !gos.get('suppressDragLeaveHidesColumns');
                eventSvc.dispatchEvent({
                    type: 'columnPanelItemDragStart',
                    column: this.columnGroup,
                });
            },
            onDragStopped: () => {
                eventSvc.dispatchEvent({
                    type: 'columnPanelItemDragEnd',
                });
            },
            onGridEnter: (dragItem) => {
                if (hideColumnOnExit) {
                    // when dragged into the grid, restore the state that was active pre-drag
                    (0, modelItemUtils_1.updateColumns)(beans, {
                        columns: this.columnGroup.getLeafColumns(),
                        visibleState: dragItem?.visibleState,
                        pivotState: dragItem?.pivotState,
                        eventType: this.eventType,
                    });
                }
            },
            onGridExit: () => {
                if (hideColumnOnExit) {
                    // when dragged outside of the grid, mimic what happens when checkbox is disabled
                    // this handles the behaviour for pivot which is different to just hiding a column.
                    this.onChangeCommon(false);
                }
            },
        };
        dragAndDrop.addDragSource(dragSource, true);
        this.addDestroyFunc(() => dragAndDrop.removeDragSource(dragSource));
    }
    createDragItem() {
        const columns = this.columnGroup.getLeafColumns();
        const visibleState = {};
        const pivotState = {};
        columns.forEach((col) => {
            const colId = col.getId();
            visibleState[colId] = col.isVisible();
            pivotState[colId] = (0, modelItemUtils_1.createPivotState)(col);
        });
        return {
            columns,
            visibleState,
            pivotState,
        };
    }
    setupExpandContract() {
        const { beans, eGroupClosedIcon, eGroupOpenedIcon, eColumnGroupIcons } = this;
        eGroupClosedIcon.appendChild((0, ag_grid_community_1._createIcon)('columnSelectClosed', beans, null));
        eGroupOpenedIcon.appendChild((0, ag_grid_community_1._createIcon)('columnSelectOpen', beans, null));
        const listener = this.onExpandOrContractClicked.bind(this);
        this.addManagedElementListeners(eGroupClosedIcon, { click: listener });
        this.addManagedElementListeners(eGroupOpenedIcon, { click: listener });
        const touchListener = new ag_grid_community_1.TouchListener(eColumnGroupIcons, true);
        this.addManagedListeners(touchListener, { tap: listener });
        this.addDestroyFunc(touchListener.destroy.bind(touchListener));
    }
    onLabelClicked() {
        const nextState = !this.cbSelect.getValue();
        this.onChangeCommon(nextState);
    }
    onCheckboxChanged(event) {
        this.onChangeCommon(event.selected);
    }
    getVisibleLeafColumns() {
        const childColumns = [];
        const extractCols = (children) => {
            children.forEach((child) => {
                if (!child.passesFilter) {
                    return;
                }
                if (child.group) {
                    extractCols(child.children);
                }
                else {
                    childColumns.push(child.column);
                }
            });
        };
        extractCols(this.modelItem.children);
        return childColumns;
    }
    onChangeCommon(nextState) {
        this.refreshAriaLabel();
        if (this.processingColumnStateChange) {
            return;
        }
        (0, modelItemUtils_1.selectAllChildren)(this.beans, this.modelItem.children, nextState, this.eventType);
    }
    refreshAriaLabel() {
        const { cbSelect, focusWrapper, displayName } = this;
        const translate = this.getLocaleTextFunc();
        const columnLabel = translate('ariaColumnGroup', 'Column Group');
        const checkboxValue = cbSelect.getValue();
        const state = checkboxValue === undefined
            ? translate('ariaIndeterminate', 'indeterminate')
            : checkboxValue
                ? translate('ariaVisible', 'visible')
                : translate('ariaHidden', 'hidden');
        const visibilityLabel = translate('ariaToggleVisibility', 'Press SPACE to toggle visibility');
        (0, ag_grid_community_1._setAriaLabel)(focusWrapper, `${displayName} ${columnLabel}`);
        cbSelect.setInputAriaLabel(`${visibilityLabel} (${state})`);
        (0, ag_grid_community_1._setAriaDescribedBy)(focusWrapper, cbSelect.getInputElement().id);
    }
    onColumnStateChanged() {
        const selectedValue = this.workOutSelectedValue();
        const readOnlyValue = this.workOutReadOnlyValue();
        this.processingColumnStateChange = true;
        const cbSelect = this.cbSelect;
        cbSelect.setValue(selectedValue);
        cbSelect.setReadOnly(readOnlyValue);
        this.addOrRemoveCssClass('ag-column-select-column-group-readonly', readOnlyValue);
        this.processingColumnStateChange = false;
    }
    workOutSelectedValue() {
        const pivotMode = this.beans.colModel.isPivotMode();
        const visibleLeafColumns = this.getVisibleLeafColumns();
        let checkedCount = 0;
        let uncheckedCount = 0;
        visibleLeafColumns.forEach((column) => {
            if (!pivotMode && column.getColDef().lockVisible) {
                return;
            }
            if (this.isColumnChecked(column, pivotMode)) {
                checkedCount++;
            }
            else {
                uncheckedCount++;
            }
        });
        if (checkedCount > 0 && uncheckedCount > 0) {
            return undefined;
        }
        return checkedCount > 0;
    }
    workOutReadOnlyValue() {
        const pivotMode = this.beans.colModel.isPivotMode();
        let colsThatCanAction = 0;
        this.columnGroup.getLeafColumns().forEach((col) => {
            if (pivotMode) {
                if (col.isAnyFunctionAllowed()) {
                    colsThatCanAction++;
                }
            }
            else {
                if (!col.getColDef().lockVisible) {
                    colsThatCanAction++;
                }
            }
        });
        return colsThatCanAction === 0;
    }
    isColumnChecked(column, pivotMode) {
        if (pivotMode) {
            const pivoted = column.isPivotActive();
            const grouped = column.isRowGroupActive();
            const aggregated = column.isValueActive();
            return pivoted || grouped || aggregated;
        }
        return column.isVisible();
    }
    onExpandOrContractClicked() {
        const modelItem = this.modelItem;
        const oldState = modelItem.expanded;
        modelItem.expanded = !oldState;
    }
    onExpandChanged() {
        this.setOpenClosedIcons();
        this.refreshAriaExpanded();
    }
    setOpenClosedIcons() {
        const folderOpen = this.modelItem.expanded;
        (0, ag_grid_community_1._setDisplayed)(this.eGroupClosedIcon, !folderOpen);
        (0, ag_grid_community_1._setDisplayed)(this.eGroupOpenedIcon, folderOpen);
    }
    refreshAriaExpanded() {
        (0, ag_grid_community_1._setAriaExpanded)(this.focusWrapper, this.modelItem.expanded);
    }
    getDisplayName() {
        return this.displayName;
    }
    onSelectAllChanged(value) {
        const cbSelect = this.cbSelect;
        const cbValue = cbSelect.getValue();
        const readOnly = cbSelect.isReadOnly();
        if (!readOnly && ((value && !cbValue) || (!value && cbValue))) {
            cbSelect.toggle();
        }
    }
    isSelected() {
        return this.cbSelect.getValue();
    }
    isSelectable() {
        return !this.cbSelect.isReadOnly();
    }
    setSelected(selected) {
        this.cbSelect.setValue(selected, true);
    }
}
exports.ToolPanelColumnGroupComp = ToolPanelColumnGroupComp;


/***/ }),

/***/ 334:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolPanelContextMenu = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const rowGroupingUtils_1 = __webpack_require__(8105);
const agMenuList_1 = __webpack_require__(9476);
class ToolPanelContextMenu extends ag_grid_community_1.Component {
    constructor(column, mouseEvent, parentEl) {
        super(/* html */ `<div class="ag-menu"></div>`);
        this.column = column;
        this.mouseEvent = mouseEvent;
        this.parentEl = parentEl;
        this.displayName = null;
    }
    postConstruct() {
        const { column, beans: { colNames }, } = this;
        this.initializeProperties(column);
        let displayName;
        if ((0, ag_grid_community_1.isColumn)(column)) {
            displayName = colNames.getDisplayNameForColumn(column, 'columnToolPanel');
        }
        else {
            displayName = colNames.getDisplayNameForProvidedColumnGroup(null, column, 'columnToolPanel');
        }
        this.displayName = displayName;
        this.buildMenuItemMap();
        if (this.isActive()) {
            this.mouseEvent.preventDefault();
            const menuItemsMapped = this.getMappedMenuItems();
            if (menuItemsMapped.length === 0) {
                return;
            }
            this.displayContextMenu(menuItemsMapped);
        }
    }
    initializeProperties(column) {
        let columns;
        if ((0, ag_grid_community_1.isProvidedColumnGroup)(column)) {
            columns = column.getLeafColumns();
        }
        else {
            columns = [column];
        }
        this.columns = columns;
        this.allowGrouping = columns.some((col) => col.isPrimary() && col.isAllowRowGroup());
        this.allowValues = columns.some((col) => col.isPrimary() && col.isAllowValue());
        this.allowPivoting =
            this.beans.colModel.isPivotMode() && columns.some((col) => col.isPrimary() && col.isAllowPivot());
    }
    buildMenuItemMap() {
        const localeTextFunc = this.getLocaleTextFunc();
        const { beans, displayName } = this;
        const { rowGroupColsSvc, valueColsSvc, pivotColsSvc, colModel } = beans;
        const menuItemMap = new Map();
        this.menuItemMap = menuItemMap;
        menuItemMap.set('rowGroup', {
            allowedFunction: (col) => col.isPrimary() && col.isAllowRowGroup() && !(0, rowGroupingUtils_1.isRowGroupColLocked)(col, beans),
            activeFunction: (col) => col.isRowGroupActive(),
            activateLabel: () => `${localeTextFunc('groupBy', 'Group by')} ${displayName}`,
            deactivateLabel: () => `${localeTextFunc('ungroupBy', 'Un-Group by')} ${displayName}`,
            activateFunction: () => rowGroupColsSvc?.setColumns(this.addColumnsToList(rowGroupColsSvc.columns), 'toolPanelUi'),
            deActivateFunction: () => rowGroupColsSvc?.setColumns(this.removeColumnsFromList(rowGroupColsSvc.columns), 'toolPanelUi'),
            addIcon: 'menuAddRowGroup',
            removeIcon: 'menuRemoveRowGroup',
        });
        menuItemMap.set('value', {
            allowedFunction: (col) => col.isPrimary() && col.isAllowValue(),
            activeFunction: (col) => col.isValueActive(),
            activateLabel: () => localeTextFunc('addToValues', `Add ${displayName} to values`, [displayName]),
            deactivateLabel: () => localeTextFunc('removeFromValues', `Remove ${displayName} from values`, [displayName]),
            activateFunction: () => valueColsSvc?.setColumns(this.addColumnsToList(valueColsSvc.columns), 'toolPanelUi'),
            deActivateFunction: () => valueColsSvc?.setColumns(this.removeColumnsFromList(valueColsSvc.columns), 'toolPanelUi'),
            addIcon: 'valuePanel',
            removeIcon: 'valuePanel',
        });
        menuItemMap.set('pivot', {
            allowedFunction: (col) => colModel.isPivotMode() && col.isPrimary() && col.isAllowPivot(),
            activeFunction: (col) => col.isPivotActive(),
            activateLabel: () => localeTextFunc('addToLabels', `Add ${displayName} to labels`, [displayName]),
            deactivateLabel: () => localeTextFunc('removeFromLabels', `Remove ${displayName} from labels`, [displayName]),
            activateFunction: () => pivotColsSvc?.setColumns(this.addColumnsToList(pivotColsSvc.columns), 'toolPanelUi'),
            deActivateFunction: () => pivotColsSvc?.setColumns(this.removeColumnsFromList(pivotColsSvc.columns), 'toolPanelUi'),
            addIcon: 'pivotPanel',
            removeIcon: 'pivotPanel',
        });
    }
    addColumnsToList(columnList) {
        return [...columnList].concat(this.columns.filter((col) => columnList.indexOf(col) === -1));
    }
    removeColumnsFromList(columnList) {
        return columnList.filter((col) => this.columns.indexOf(col) === -1);
    }
    displayContextMenu(menuItemsMapped) {
        const eGui = this.getGui();
        const menuList = this.createBean(new agMenuList_1.AgMenuList());
        const localeTextFunc = this.getLocaleTextFunc();
        let hideFunc = () => { };
        eGui.appendChild(menuList.getGui());
        menuList.addMenuItems(menuItemsMapped);
        menuList.addManagedListeners(menuList, {
            closeMenu: () => {
                this.parentEl.focus();
                hideFunc();
            },
        });
        const popupSvc = this.beans.popupSvc;
        const addPopupRes = popupSvc.addPopup({
            modal: true,
            eChild: eGui,
            closeOnEsc: true,
            afterGuiAttached: () => (0, ag_grid_community_1._focusInto)(menuList.getGui()),
            ariaLabel: localeTextFunc('ariaLabelContextMenu', 'Context Menu'),
            closedCallback: (e) => {
                if (e instanceof KeyboardEvent) {
                    this.parentEl.focus();
                }
                this.destroyBean(menuList);
            },
        });
        if (addPopupRes) {
            hideFunc = addPopupRes.hideFunc;
        }
        popupSvc.positionPopupUnderMouseEvent({
            type: 'columnContextMenu',
            mouseEvent: this.mouseEvent,
            ePopup: eGui,
        });
    }
    isActive() {
        return this.allowGrouping || this.allowValues || this.allowPivoting;
    }
    getMappedMenuItems() {
        const ret = [];
        const { menuItemMap, columns, displayName, beans } = this;
        for (const val of menuItemMap.values()) {
            const isInactive = columns.some((col) => val.allowedFunction(col) && !val.activeFunction(col));
            const isActive = columns.some((col) => val.allowedFunction(col) && val.activeFunction(col));
            if (isInactive) {
                ret.push({
                    name: val.activateLabel(displayName),
                    icon: (0, ag_grid_community_1._createIconNoSpan)(val.addIcon, beans, null),
                    action: () => val.activateFunction(),
                });
            }
            if (isActive) {
                ret.push({
                    name: val.deactivateLabel(displayName),
                    icon: (0, ag_grid_community_1._createIconNoSpan)(val.removeIcon, beans, null),
                    action: () => val.deActivateFunction(),
                });
            }
        }
        return ret;
    }
}
exports.ToolPanelContextMenu = ToolPanelContextMenu;


/***/ }),

/***/ 2805:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.numberFormatMap = exports.INCH_TO_EMU = void 0;
exports.INCH_TO_EMU = 9525;
exports.numberFormatMap = {
    '0': 1,
    '0.00': 2,
    '#,##0': 3,
    '#,##0.00': 4,
    '0%': 9,
    '0.00%': 10,
    '0.00E+00': 11,
    '# ?/?': 12,
    '# ??/??': 13,
    'mm-dd-yy': 14,
    'd-mmm-yy': 15,
    'd-mmm': 16,
    'mmm-yy': 17,
    'h:mm AM/PM': 18,
    'h:mm:ss AM/PM': 19,
    'h:mm': 20,
    'h:mm:ss': 21,
    'm/d/yy h:mm': 22,
    '#,##0 ;(#,##0)': 37,
    '#,##0 ;[Red](#,##0)': 38,
    '#,##0.00;(#,##0.00)': 39,
    '#,##0.00;[Red](#,##0.00)': 40,
    'mm:ss': 45,
    '[h]:mm:ss': 46,
    'mmss.0': 47,
    '##0.0E+0': 48,
    '@': 49,
};


/***/ }),

/***/ 1842:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.convertLegacyVerticalAlignment = exports.convertLegacyHorizontalAlignment = exports.convertLegacyBorder = exports.convertLegacyColor = exports.convertLegacyPattern = void 0;
const getWeightName = (value) => {
    switch (value) {
        case 1:
            return 'thin';
        case 2:
            return 'medium';
        case 3:
            return 'thick';
        default:
            return 'hair';
    }
};
const mappedBorderNames = {
    None: 'None',
    Dot: 'Dotted',
    Dash: 'Dashed',
    Double: 'Double',
    DashDot: 'DashDot',
    DashDotDot: 'DashDotDot',
    SlantDashDot: 'SlantDashDot',
    Continuous: 'Continuous',
};
const mediumBorders = ['Dashed', 'DashDot', 'DashDotDot'];
const colorMap = {
    None: 'none',
    Solid: 'solid',
    Gray50: 'mediumGray',
    Gray75: 'darkGray',
    Gray25: 'lightGray',
    HorzStripe: 'darkHorizontal',
    VertStripe: 'darkVertical',
    ReverseDiagStripe: 'darkDown',
    DiagStripe: 'darkUp',
    DiagCross: 'darkGrid',
    ThickDiagCross: 'darkTrellis',
    ThinHorzStripe: 'lightHorizontal',
    ThinVertStripe: 'lightVertical',
    ThinReverseDiagStripe: 'lightDown',
    ThinDiagStripe: 'lightUp',
    ThinHorzCross: 'lightGrid',
    ThinDiagCross: 'lightTrellis',
    Gray125: 'gray125',
    Gray0625: 'gray0625',
};
const horizontalAlignmentMap = {
    Automatic: 'general',
    Left: 'left',
    Center: 'center',
    Right: 'right',
    Fill: 'fill',
    Justify: 'justify',
    CenterAcrossSelection: 'centerContinuous',
    Distributed: 'distributed',
    JustifyDistributed: 'justify',
};
const verticalAlignmentMap = {
    Automatic: undefined,
    Top: 'top',
    Bottom: 'bottom',
    Center: 'center',
    Justify: 'justify',
    Distributed: 'distributed',
    JustifyDistributed: 'justify',
};
const convertLegacyPattern = (name) => {
    if (!name) {
        return 'none';
    }
    return colorMap[name] || name;
};
exports.convertLegacyPattern = convertLegacyPattern;
const convertLegacyColor = (color) => {
    if (color == undefined) {
        return color;
    }
    if (color.charAt(0) === '#') {
        color = color.substring(1);
    }
    return color.length === 6 ? 'FF' + color : color;
};
exports.convertLegacyColor = convertLegacyColor;
const convertLegacyBorder = (type, weight) => {
    if (!type) {
        return 'thin';
    }
    // Legacy Types are: None, Continuous, Dash, Dot, DashDot, DashDotDot, SlantDashDot, and Double
    // Weight represents: 0—Hairline, 1—Thin , 2—Medium, 3—Thick
    // New types: none, thin, medium, dashed, dotted, thick, double, hair, mediumDashed, dashDot, mediumDashDot,
    // dashDotDot, mediumDashDotDot, slantDashDot
    const namedWeight = getWeightName(weight);
    if (type === 'Continuous') {
        return namedWeight;
    }
    const mappedName = mappedBorderNames[type];
    if (namedWeight === 'medium' && mediumBorders.some((type) => type === mappedName)) {
        return `medium${mappedName}`;
    }
    return `${mappedName.charAt(0).toLowerCase()}${mappedName.substring(1)}`;
};
exports.convertLegacyBorder = convertLegacyBorder;
const convertLegacyHorizontalAlignment = (alignment) => {
    return horizontalAlignmentMap[alignment] || 'general';
};
exports.convertLegacyHorizontalAlignment = convertLegacyHorizontalAlignment;
const convertLegacyVerticalAlignment = (alignment) => {
    return verticalAlignmentMap[alignment] || undefined;
};
exports.convertLegacyVerticalAlignment = convertLegacyVerticalAlignment;


/***/ }),

/***/ 3237:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.buildSharedString = exports.replaceInvisibleCharacters = exports.getExcelColumnName = exports.createXmlPart = exports.setExcelImageTotalHeight = exports.setExcelImageTotalWidth = exports.getHeightFromProperty = exports.getFontFamilyId = exports.pixelsToEMU = exports.pointsToPixel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const excelConstants_1 = __webpack_require__(2805);
const xmlFactory_1 = __webpack_require__(5048);
const pointsToPixel = (points) => {
    return Math.round((points * 96) / 72);
};
exports.pointsToPixel = pointsToPixel;
const pixelsToEMU = (value) => {
    return Math.ceil(value * excelConstants_1.INCH_TO_EMU);
};
exports.pixelsToEMU = pixelsToEMU;
const getFontFamilyId = (name) => {
    if (name === undefined) {
        return;
    }
    const families = ['Automatic', 'Roman', 'Swiss', 'Modern', 'Script', 'Decorative'];
    const pos = families.indexOf(name || 'Automatic');
    return Math.max(pos, 0);
};
exports.getFontFamilyId = getFontFamilyId;
const getHeightFromProperty = (rowIndex, height) => {
    if (!height) {
        return;
    }
    let finalHeight;
    if (typeof height === 'number') {
        finalHeight = height;
    }
    else {
        // eslint-disable-next-line @typescript-eslint/ban-types
        const heightFunc = height;
        finalHeight = heightFunc({ rowIndex });
    }
    return finalHeight;
};
exports.getHeightFromProperty = getHeightFromProperty;
const setExcelImageTotalWidth = (image, columnsToExport) => {
    const { colSpan, column } = image.position;
    if (!image.width) {
        return;
    }
    if (colSpan) {
        const columnsInSpan = columnsToExport.slice(column - 1, column + colSpan - 1);
        let totalWidth = 0;
        for (let i = 0; i < columnsInSpan.length; i++) {
            const colWidth = columnsInSpan[i].getActualWidth();
            if (image.width < totalWidth + colWidth) {
                image.position.colSpan = i + 1;
                image.totalWidth = image.width;
                image.width = image.totalWidth - totalWidth;
                break;
            }
            totalWidth += colWidth;
        }
    }
    else {
        image.totalWidth = image.width;
    }
};
exports.setExcelImageTotalWidth = setExcelImageTotalWidth;
const setExcelImageTotalHeight = (image, rowHeight) => {
    const { rowSpan, row } = image.position;
    if (!image.height) {
        return;
    }
    if (rowSpan) {
        let totalHeight = 0;
        let counter = 0;
        for (let i = row; i < row + rowSpan; i++) {
            const nextRowHeight = (0, exports.pointsToPixel)((0, exports.getHeightFromProperty)(i, rowHeight) || 20);
            if (image.height < totalHeight + nextRowHeight) {
                image.position.rowSpan = counter + 1;
                image.totalHeight = image.height;
                image.height = image.totalHeight - totalHeight;
                break;
            }
            totalHeight += nextRowHeight;
            counter++;
        }
    }
    else {
        image.totalHeight = image.height;
    }
};
exports.setExcelImageTotalHeight = setExcelImageTotalHeight;
const createXmlPart = (body, skipHeader) => {
    const header = (0, xmlFactory_1.createXmlHeader)({
        encoding: 'UTF-8',
        standalone: 'yes',
    });
    const xmlBody = (0, xmlFactory_1.createXml)(body);
    if (skipHeader) {
        return xmlBody;
    }
    return `${header}${xmlBody}`;
};
exports.createXmlPart = createXmlPart;
const getExcelColumnName = (colIdx) => {
    const startCode = 65;
    const tableWidth = 26;
    const fromCharCode = String.fromCharCode;
    const pos = Math.floor(colIdx / tableWidth);
    const tableIdx = colIdx % tableWidth;
    if (!pos || colIdx === tableWidth) {
        return fromCharCode(startCode + colIdx - 1);
    }
    if (!tableIdx) {
        return (0, exports.getExcelColumnName)(pos - 1) + 'Z';
    }
    if (pos < tableWidth) {
        return fromCharCode(startCode + pos - 1) + fromCharCode(startCode + tableIdx - 1);
    }
    return (0, exports.getExcelColumnName)(pos) + fromCharCode(startCode + tableIdx - 1);
};
exports.getExcelColumnName = getExcelColumnName;
const replaceInvisibleCharacters = (str) => {
    if (str == null) {
        return null;
    }
    // Excel breaks when characters with code below 30 are exported
    // we use the loop below to wrap these characters between _x(code)_
    let newString = '';
    for (let i = 0; i < str.length; i++) {
        const point = str.charCodeAt(i);
        if (point >= 0 && point <= 31 && point !== 10) {
            const convertedCode = point.toString(16).toUpperCase();
            const paddedCode = convertedCode.padStart(4, '0');
            const newValue = `_x${paddedCode}_`;
            newString += newValue;
        }
        else {
            newString += str[i];
        }
    }
    return newString;
};
exports.replaceInvisibleCharacters = replaceInvisibleCharacters;
const buildSharedString = (strMap) => {
    const ret = [];
    for (const key of strMap.keys()) {
        const textNode = key.toString();
        const child = {
            name: 't',
            textNode: (0, ag_grid_community_1._escapeString)((0, exports.replaceInvisibleCharacters)(textNode), false),
        };
        // if we have leading or trailing spaces, instruct Excel not to trim them
        const preserveSpaces = textNode.trim().length !== textNode.length;
        if (preserveSpaces) {
            child.properties = {
                rawMap: {
                    'xml:space': 'preserve',
                },
            };
        }
        ret.push({
            name: 'si',
            children: [child],
        });
    }
    return ret;
};
exports.buildSharedString = buildSharedString;


/***/ }),

/***/ 5048:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.createXml = exports.createXmlHeader = void 0;
const LINE_SEPARATOR = '\r\n';
function returnAttributeIfPopulated(key, value, booleanTransformer) {
    if (!value && value !== '' && value !== 0) {
        return '';
    }
    let xmlValue = value;
    if (typeof value === 'boolean') {
        if (booleanTransformer) {
            xmlValue = booleanTransformer(value);
        }
    }
    return ` ${key}="${xmlValue}"`;
}
function createXmlHeader(headerElement = {}) {
    const headerStart = '<?';
    const headerEnd = '?>';
    const keys = ['version'];
    if (!headerElement.version) {
        headerElement.version = '1.0';
    }
    if (headerElement.encoding) {
        keys.push('encoding');
    }
    if (headerElement.standalone) {
        keys.push('standalone');
    }
    const att = keys.map((key) => `${key}="${headerElement[key]}"`).join(' ');
    return `${headerStart}xml ${att} ${headerEnd}`;
}
exports.createXmlHeader = createXmlHeader;
function createXml(xmlElement, booleanTransformer) {
    let props = '';
    if (xmlElement.properties) {
        if (xmlElement.properties.prefixedAttributes) {
            xmlElement.properties.prefixedAttributes.forEach((prefixedSet) => {
                Object.keys(prefixedSet.map).forEach((key) => {
                    props += returnAttributeIfPopulated(prefixedSet.prefix + key, prefixedSet.map[key], booleanTransformer);
                });
            });
        }
        if (xmlElement.properties.rawMap) {
            Object.keys(xmlElement.properties.rawMap).forEach((key) => {
                props += returnAttributeIfPopulated(key, xmlElement.properties.rawMap[key], booleanTransformer);
            });
        }
    }
    let result = '<' + xmlElement.name + props;
    if (!xmlElement.children && xmlElement.textNode == null) {
        return result + '/>' + LINE_SEPARATOR;
    }
    if (xmlElement.textNode != null) {
        return result + '>' + xmlElement.textNode + '</' + xmlElement.name + '>' + LINE_SEPARATOR;
    }
    result += '>' + LINE_SEPARATOR;
    if (xmlElement.children) {
        xmlElement.children.forEach((it) => {
            result += createXml(it, booleanTransformer);
        });
    }
    return result + '</' + xmlElement.name + '>' + LINE_SEPARATOR;
}
exports.createXml = createXml;


/***/ }),

/***/ 1790:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExcelCreator = exports.exportMultipleSheetsAsExcel = exports.getMultipleSheetsAsExcel = void 0;
const ag_grid_community_1 = __webpack_require__(6624);
const excelSerializingSession_1 = __webpack_require__(5103);
const excelXlsxFactory_1 = __webpack_require__(7165);
const contentTypes_1 = __webpack_require__(541);
const zipContainer_1 = __webpack_require__(5950);
const createExcelXMLCoreFolderStructure = (zipContainer) => {
    zipContainer.addFolders(['_rels/', 'docProps/', 'xl/', 'xl/theme/', 'xl/_rels/', 'xl/worksheets/']);
    if (!excelXlsxFactory_1.XLSX_IMAGES.size) {
        return;
    }
    zipContainer.addFolders(['xl/worksheets/_rels', 'xl/drawings/', 'xl/drawings/_rels', 'xl/media/']);
    let imgCounter = 0;
    excelXlsxFactory_1.XLSX_IMAGES.forEach((value) => {
        const firstImage = value[0].image[0];
        const { base64, imageType } = firstImage;
        zipContainer.addFile(`xl/media/image${++imgCounter}.${(0, contentTypes_1._normaliseImageExtension)(imageType)}`, base64, true);
    });
};
const createExcelXmlWorksheets = (zipContainer, data) => {
    let imageRelationCounter = 0;
    let headerFooterImageCounter = 0;
    for (let i = 0; i < data.length; i++) {
        const value = data[i];
        zipContainer.addFile(`xl/worksheets/sheet${i + 1}.xml`, value, false);
        const hasImages = excelXlsxFactory_1.XLSX_IMAGES.size > 0 && excelXlsxFactory_1.XLSX_WORKSHEET_IMAGES.has(i);
        const tableData = excelXlsxFactory_1.XLSX_WORKSHEET_DATA_TABLES.size > 0 && excelXlsxFactory_1.XLSX_WORKSHEET_DATA_TABLES.get(i);
        const hasHeaderFooterImages = excelXlsxFactory_1.XLSX_IMAGES.size && excelXlsxFactory_1.XLSX_WORKSHEET_HEADER_FOOTER_IMAGES.has(i);
        if (!hasImages && !tableData && !hasHeaderFooterImages) {
            continue;
        }
        let tableName;
        let drawingIndex;
        let vmlDrawingIndex;
        if (hasImages) {
            createExcelXmlDrawings(zipContainer, i, imageRelationCounter);
            drawingIndex = imageRelationCounter;
            imageRelationCounter++;
        }
        if (hasHeaderFooterImages) {
            createExcelVmlDrawings(zipContainer, i, headerFooterImageCounter);
            vmlDrawingIndex = headerFooterImageCounter;
            headerFooterImageCounter++;
        }
        if (tableData) {
            tableName = tableData.name;
        }
        const worksheetRelFile = `xl/worksheets/_rels/sheet${i + 1}.xml.rels`;
        zipContainer.addFile(worksheetRelFile, (0, excelXlsxFactory_1.createXlsxRelationships)({
            tableName,
            drawingIndex,
            vmlDrawingIndex,
        }));
    }
};
const createExcelXmlDrawings = (zipContainer, sheetIndex, drawingIndex) => {
    const drawingFolder = 'xl/drawings';
    const drawingFileName = `${drawingFolder}/drawing${drawingIndex + 1}.xml`;
    const relFileName = `${drawingFolder}/_rels/drawing${drawingIndex + 1}.xml.rels`;
    zipContainer.addFile(relFileName, (0, excelXlsxFactory_1.createXlsxDrawingRel)(sheetIndex));
    zipContainer.addFile(drawingFileName, (0, excelXlsxFactory_1.createXlsxDrawing)(sheetIndex));
};
const createExcelVmlDrawings = (zipContainer, sheetIndex, drawingIndex) => {
    const drawingFolder = 'xl/drawings';
    const drawingFileName = `${drawingFolder}/vmlDrawing${drawingIndex + 1}.vml`;
    const relFileName = `${drawingFolder}/_rels/vmlDrawing${drawingIndex + 1}.vml.rels`;
    zipContainer.addFile(drawingFileName, (0, excelXlsxFactory_1.createXlsxVmlDrawing)(sheetIndex));
    zipContainer.addFile(relFileName, (0, excelXlsxFactory_1.createXlsxVmlDrawingRel)(sheetIndex));
};
const createExcelXmlTables = (zipContainer) => {
    const tablesDataByWorksheet = excelXlsxFactory_1.XLSX_WORKSHEET_DATA_TABLES;
    const worksheetKeys = Array.from(tablesDataByWorksheet.keys());
    for (let i = 0; i < worksheetKeys.length; i++) {
        const sheetIndex = worksheetKeys[i];
        const table = tablesDataByWorksheet.get(sheetIndex);
        if (!table) {
            continue;
        }
        zipContainer.addFile(`xl/tables/${table.name}.xml`, (0, excelXlsxFactory_1.createXlsxTable)(table, i));
    }
};
const createExcelXmlCoreSheets = (zipContainer, fontSize, author, sheetLen, activeTab) => {
    zipContainer.addFile('xl/workbook.xml', (0, excelXlsxFactory_1.createXlsxWorkbook)(activeTab));
    zipContainer.addFile('xl/styles.xml', (0, excelXlsxFactory_1.createXlsxStylesheet)(fontSize));
    zipContainer.addFile('xl/sharedStrings.xml', (0, excelXlsxFactory_1.createXlsxSharedStrings)());
    zipContainer.addFile('xl/theme/theme1.xml', (0, excelXlsxFactory_1.createXlsxTheme)());
    zipContainer.addFile('xl/_rels/workbook.xml.rels', (0, excelXlsxFactory_1.createXlsxWorkbookRels)(sheetLen));
    zipContainer.addFile('docProps/core.xml', (0, excelXlsxFactory_1.createXlsxCore)(author));
    zipContainer.addFile('[Content_Types].xml', (0, excelXlsxFactory_1.createXlsxContentTypes)(sheetLen));
    zipContainer.addFile('_rels/.rels', (0, excelXlsxFactory_1.createXlsxRels)());
};
const createExcelFileForExcel = (zipContainer, data, options = {}) => {
    if (!data || data.length === 0) {
        (0, ag_grid_community_1._warn)(159);
        (0, excelXlsxFactory_1.resetXlsxFactory)();
        return false;
    }
    const { fontSize = 11, author = 'AG Grid', activeTab = 0 } = options;
    const len = data.length;
    const activeTabWithinBounds = Math.max(Math.min(activeTab, len - 1), 0);
    createExcelXMLCoreFolderStructure(zipContainer);
    createExcelXmlTables(zipContainer);
    createExcelXmlWorksheets(zipContainer, data);
    createExcelXmlCoreSheets(zipContainer, fontSize, author, len, activeTabWithinBounds);
    (0, excelXlsxFactory_1.resetXlsxFactory)();
    return true;
};
const getMultipleSheetsAsExcelCompressed = (params) => {
    const { data, fontSize, author, activeSheetIndex } = params;
    const mimeType = params.mimeType || 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
    const zipContainer = new zipContainer_1.ZipContainer();
    if (!createExcelFileForExcel(zipContainer, data, {
        author,
        fontSize,
        activeTab: activeSheetIndex,
    })) {
        return Promise.resolve(undefined);
    }
    return zipContainer.getZipFile(mimeType);
};
const getMultipleSheetsAsExcel = (params) => {
    const { data, fontSize, author, activeSheetIndex } = params;
    const mimeType = params.mimeType || 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
    const zipContainer = new zipContainer_1.ZipContainer();
    if (!createExcelFileForExcel(zipContainer, data, {
        author,
        fontSize,
        activeTab: activeSheetIndex,
    })) {
        return;
    }
    return zipContainer.getUncompressedZipFile(mimeType);
};
exports.getMultipleSheetsAsExcel = getMultipleSheetsAsExcel;
const exportMultipleSheetsAsExcel = (params) => {
    const { fileName = 'export.xlsx' } = params;
    getMultipleSheetsAsExcelCompressed(params).then((contents) => {
        if (contents) {
            const downloadFileName = typeof fileName === 'function' ? fileName() : fileName;
            (0, ag_grid_community_1._downloadFile)(downloadFileName, contents);
        }
    });
};
exports.exportMultipleSheetsAsExcel = exportMultipleSheetsAsExcel;
class ExcelCreator extends ag_grid_community_1.BaseCreator {
    constructor() {
        super(...arguments);
        this.beanName = 'excelCreator';
    }
    getMergedParams(params) {
        const baseParams = this.gos.get('defaultExcelExportParams');
        return Object.assign({}, baseParams, params);
    }
    export(userParams) {
        if (this.isExportSuppressed()) {
            (0, ag_grid_community_1._warn)(160);
            return;
        }
        const mergedParams = this.getMergedParams(userParams);
        const data = this.getData(mergedParams);
        const exportParams = {
            data: [data],
            fontSize: mergedParams.fontSize,
            author: mergedParams.author,
            mimeType: mergedParams.mimeType,
        };
        this.packageCompressedFile(exportParams).then((packageFile) => {
            if (packageFile) {
                const { fileName } = mergedParams;
                const providedFileName = typeof fileName === 'function' ? fileName((0, ag_grid_community_1._addGridCommonParams)(this.gos, {})) : fileName;
                (0, ag_grid_community_1._downloadFile)(this.getFileName(providedFileName), packageFile);
            }
        });
    }
    exportDataAsExcel(params) {
        this.export(params);
    }
    getDataAsExcel(params) {
        const mergedParams = this.getMergedParams(params);
        const data = this.getData(mergedParams);
        const exportParams = {
            data: [data],
            fontSize: mergedParams.fontSize,
            author: mergedParams.author,
            mimeType: mergedParams.mimeType,
        };
        return this.packageFile(exportParams);
    }
    setFactoryMode(factoryMode) {
        (0, excelXlsxFactory_1.setXlsxFactoryMode)(factoryMode);
    }
    getFactoryMode() {
        return (0, excelXlsxFactory_1.getXlsxFactoryMode)();
    }
    getSheetDataForExcel(params) {
        const mergedParams = this.getMergedParams(params);
        return this.getData(mergedParams);
    }
    getMultipleSheetsAsExcel(params) {
        return (0, exports.getMultipleSheetsAsExcel)(params);
    }
    exportMultipleSheetsAsExcel(params) {
        (0, exports.exportMultipleSheetsAsExcel)(params);
    }
    getDefaultFileExtension() {
        return 'xlsx';
    }
    createSerializingSession(params) {
        const { colModel, colNames, rowGroupColsSvc, valueSvc, gos } = this.beans;
        const config = {
            ...params,
            colModel,
            colNames,
            rowGroupColsSvc,
            valueSvc,
            gos,
            suppressRowOutline: params.suppressRowOutline || params.skipRowGroups,
            headerRowHeight: params.headerRowHeight || params.rowHeight,
            baseExcelStyles: gos.get('excelStyles') || [],
            rightToLeft: params.rightToLeft ?? gos.get('enableRtl'),
            styleLinker: this.styleLinker.bind(this),
        };
        return new excelSerializingSession_1.ExcelSerializingSession(config);
    }
    styleLinker(params) {
        const { rowType, rowIndex, value, column, columnGroup, node } = params;
        const isHeader = rowType === 'HEADER';
        const isGroupHeader = rowType === 'HEADER_GROUPING';
        const col = (isHeader ? column : columnGroup);
        let headerClasses = [];
        const { gos, cellStyles } = this.beans;
        if (isHeader || isGroupHeader) {
            headerClasses.push('header');
            if (isGroupHeader) {
                headerClasses.push('headerGroup');
            }
            if (col) {
                headerClasses = headerClasses.concat((0, ag_grid_community_1._getHeaderClas