import type { AgInitialStateThemeableOptions } from '../api/initialStateOptions';
import type { AgLinearGaugeTarget, AgLinearGaugeThemeableOptions } from '../presets/gauge/linearGaugeOptions';
import type { AgRadialGaugeTarget, AgRadialGaugeThemeableOptions } from '../presets/gauge/radialGaugeOptions';
import type { AgAreaSeriesThemeableOptions } from '../series/cartesian/areaOptions';
import type { AgBarSeriesThemeableOptions } from '../series/cartesian/barOptions';
import type { AgBoxPlotSeriesThemeableOptions } from '../series/cartesian/boxPlotOptions';
import type { AgBubbleSeriesThemeableOptions } from '../series/cartesian/bubbleOptions';
import type { AgCandlestickSeriesThemeableOptions } from '../series/cartesian/candlestickOptions';
import type { AgBaseCartesianThemeOptions, AgCartesianAxesTheme } from '../series/cartesian/cartesianOptions';
import type { AgConeFunnelSeriesThemeableOptions } from '../series/cartesian/coneFunnelOptions';
import type { AgFunnelSeriesThemeableOptions } from '../series/cartesian/funnelOptions';
import type { AgHeatmapSeriesThemeableOptions } from '../series/cartesian/heatmapOptions';
import type { AgHistogramSeriesThemeableOptions } from '../series/cartesian/histogramOptions';
import type { AgLineSeriesThemeableOptions } from '../series/cartesian/lineOptions';
import type { AgOhlcSeriesThemeableOptions } from '../series/cartesian/ohlcOptions';
import type { AgRangeAreaSeriesThemeableOptions } from '../series/cartesian/rangeAreaOptions';
import type { AgRangeBarSeriesThemeableOptions } from '../series/cartesian/rangeBarOptions';
import type { AgScatterSeriesThemeableOptions } from '../series/cartesian/scatterOptions';
import type { AgWaterfallSeriesThemeableOptions } from '../series/cartesian/waterfallOptions';
import type { AgChordSeriesThemeableOptions } from '../series/flow-proportion/chordOptions';
import type { AgBaseFlowProportionThemeOptions } from '../series/flow-proportion/flowProportionOptions';
import type { AgSankeySeriesThemeableOptions } from '../series/flow-proportion/sankeyOptions';
import type { AgBaseHierarchyThemeOptions } from '../series/hierarchy/hierarchyOptions';
import type { AgSunburstSeriesThemeableOptions } from '../series/hierarchy/sunburstOptions';
import type { AgTreemapSeriesThemeableOptions } from '../series/hierarchy/treemapOptions';
import type { AgDonutSeriesThemeableOptions } from '../series/polar/donutOptions';
import type { AgNightingaleSeriesThemeableOptions } from '../series/polar/nightingaleOptions';
import type { AgPieSeriesThemeableOptions } from '../series/polar/pieOptions';
import type { AgBasePolarThemeOptions, AgPolarAxesTheme } from '../series/polar/polarOptions';
import type { AgRadarAreaSeriesThemeableOptions } from '../series/polar/radarAreaOptions';
import type { AgRadarSeriesThemeableOptions } from '../series/polar/radarOptions';
import type { AgRadialBarSeriesThemeableOptions } from '../series/polar/radialBarOptions';
import type { AgRadialColumnSeriesThemeableOptions } from '../series/polar/radialColumnOptions';
import type { AgPyramidSeriesThemeableOptions } from '../series/standalone/pyramidOptions';
import type { AgBaseStandaloneThemeOptions } from '../series/standalone/standaloneOptions';
import type { AgMapLineBackgroundThemeableOptions } from '../series/topology/mapLineBackgroundOptions';
import type { AgMapLineSeriesThemeableOptions } from '../series/topology/mapLineOptions';
import type { AgMapMarkerSeriesThemeableOptions } from '../series/topology/mapMarkerOptions';
import type { AgMapShapeBackgroundThemeableOptions } from '../series/topology/mapShapeBackgroundOptions';
import type { AgMapShapeSeriesThemeableOptions } from '../series/topology/mapShapeOptions';
import type { AgBaseTopologyThemeOptions } from '../series/topology/topologyOptions';
import type { AgAnnotationsThemeableOptions } from './annotationsOptions';
import type { AgBaseChartOptions, AgBaseThemeableChartOptions } from './chartOptions';
import type { AgChartToolbarThemeableOptions } from './chartToolbarOptions';
import type { AgLocaleThemeableOptions } from './localeOptions';
import type { CssColor, FontFamily, FontSize, FontWeight, PixelSize } from './types';
export type AgChartThemeName = 'ag-default' | 'ag-default-dark' | 'ag-sheets' | 'ag-sheets-dark' | 'ag-polychroma' | 'ag-polychroma-dark' | 'ag-vivid' | 'ag-vivid-dark' | 'ag-material' | 'ag-material-dark' | 'ag-financial' | 'ag-financial-dark';
export interface AgPaletteColors {
    fill?: CssColor;
    stroke?: CssColor;
}
/**
 * Palette used by the chart instance.
 */
export interface AgChartThemePalette {
    /** The array of fills to be used. */
    fills?: CssColor[];
    /** The array of strokes to be used. */
    strokes?: CssColor[];
    up?: AgPaletteColors;
    down?: AgPaletteColors;
    neutral?: AgPaletteColors;
}
export interface AgChartThemeParams {
    /**
     * The 'brand colour' for the chart, used wherever a non-neutral colour is required. Selections, focus outlines and
     * checkboxes use the accent colour by default.
     */
    accentColor?: CssColor;
    /** Default colour for axis lines and ticks. */
    axisColor?: CssColor;
    /**
     * Background colour of the chart. Most text, borders and backgrounds are defined as a blend between the background
     * and foreground colors.
     */
    backgroundColor?: CssColor;
    /** Default colour for borders. */
    borderColor?: CssColor;
    /**
     * Background colour of tooltips, menus, dialogs, toolbars and buttons.
     *
     * Default: `foregroundColor + backgroundColor`
     */
    chromeBackgroundColor?: CssColor;
    /**
     * Font family used for text in tooltips, menus, dialogs, toolbars, buttons and text inputs.
     *
     * Default: `fontFamily`
     */
    chromeFontFamily?: FontFamily;
    /**
     * Font size used for text in tooltips, menus, dialogs, toolbars, buttons and text inputs.
     *
     * Default: `fontSize`
     */
    chromeFontSize?: FontSize;
    /**
     * Font weight used for text in tooltips, menus, dialogs, toolbars, buttons and text inputs.
     *
     * Default: `fontWeight`
     */
    chromeFontWeight?: FontWeight;
    /**
     * Default colour for text in tooltips, menus, dialogs, toolbars, buttons and text inputs.
     *
     * Default: `textColor`
     */
    chromeTextColor?: CssColor;
    /**
     * Colour of text that should stand out less than the default in tooltips, menus, dialogs, toolbars and buttons.
     *
     * Default: `subtleTextColor`
     */
    chromeSubtleTextColor?: CssColor;
    /**
     * Background colour of crosshair labels.
     *
     * Default: `foregroundColor`
     */
    crosshairLabelBackgroundColor?: CssColor;
    /**
     * Colour for text in crosshair labels.
     *
     * Default: `backgroundColor`
     */
    crosshairLabelTextColor?: CssColor;
    /**
     * Default colour for neutral UI elements. Most text, borders and backgrounds are defined as a blend between the
     * background and foreground colors.
     */
    foregroundColor?: CssColor;
    /** Font family used for all text. */
    fontFamily?: FontFamily;
    /** Default font size used for all text. Titles and some other text are scaled to this font size. */
    fontSize?: FontSize;
    /** Default font weight used for all text. */
    fontWeight?: FontWeight;
    /** Default colour for grid lines. */
    gridLineColor?: CssColor;
    /**
     * Background colour for text inputs.
     *
     * Default: `backgroundColor`
     */
    inputBackgroundColor?: CssColor;
    /**
     * Colour of text within text inputs.
     *
     * Default: `textColor`
     */
    inputTextColor?: CssColor;
    /** The outer chart padding. */
    padding?: PixelSize;
    /**
     * Colour of text that should stand out less than the default.
     *
     * Default: `foregroundColor + backgroundColor`
     */
    subtleTextColor?: CssColor;
    /**
     * Default colour for all text.
     *
     * Default: `foregroundColor`
     */
    textColor?: CssColor;
}
type ExtendLiteralLeaves<T, V> = {
    [P in keyof T]: T[P] extends (infer U)[] ? ExtendLiteralLeaves<U, V>[] : T[P] extends string | symbol | number | undefined ? T[P] | V : ExtendLiteralLeaves<T[P], V>;
};
type ThemeParam = keyof AgChartThemeParams;
type ThemeParamsOperation = {
    $ref: ThemeParam;
} | {
    $path: string;
} | {
    $if: [ThemeParamsLeaf, ThemeParamsLeaf, ThemeParamsLeaf];
} | {
    $or: [ThemeParamsLeaf, ThemeParamsLeaf];
} | {
    $and: [ThemeParamsLeaf, ThemeParamsLeaf];
} | {
    $eq: [ThemeParamsLeaf, ThemeParamsLeaf];
} | {
    $mul: [ThemeParamsLeaf<number>, ThemeParamsLeaf<number>];
} | {
    $round: [ThemeParamsLeaf<number>];
} | {
    $rem: [ThemeParamsLeaf] | [ThemeParamsLeaf, ThemeParamsLeaf];
} | {
    $mix: [ThemeParamsLeaf, ThemeParamsLeaf, ThemeParamsLeaf<number>];
} | {
    $foregroundBackgroundMix: [ThemeParamsLeaf<number>];
} | {
    $foregroundBackgroundAccentMix: [ThemeParamsLeaf<number>, ThemeParamsLeaf<number>];
};
type ThemeParamsLeaf<T = boolean | string | number> = ThemeParamsOperation | T;
export type WithThemeParams<T> = ExtendLiteralLeaves<T, ThemeParamsOperation>;
export interface AgBaseChartThemeOptions {
    /** The palette to use. If specified, this replaces the palette from the base theme. */
    palette?: AgChartThemePalette;
    /** Global parameters to set styles across the whole chart. */
    params?: AgChartThemeParams;
    /** Configuration from this object is merged over the defaults specified in the base theme. */
    overrides?: AgThemeOverrides;
}
/** This object is used to define the configuration for a custom chart theme. */
export interface AgChartTheme extends AgBaseChartThemeOptions {
    /** The name of the theme to base your theme on. Your custom theme will inherit all the configuration from the base theme, allowing you to override just the settings you wish to change using the `overrides` config (see below). */
    baseTheme?: AgChartThemeName;
}
export interface AgLineSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgLineSeriesThemeableOptions;
}
export interface AgScatterSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgScatterSeriesThemeableOptions;
}
export interface AgBubbleSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgBubbleSeriesThemeableOptions;
}
export interface AgAreaSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgAreaSeriesThemeableOptions;
}
export interface AgBarSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgBarSeriesThemeableOptions;
}
export interface AgBoxPlotSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgBoxPlotSeriesThemeableOptions;
}
export interface AgCandlestickSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgCandlestickSeriesThemeableOptions;
}
export interface AgConeFunnelSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgConeFunnelSeriesThemeableOptions;
}
export interface AgFunnelSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgFunnelSeriesThemeableOptions;
}
export interface AgOhlcSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgOhlcSeriesThemeableOptions;
}
export interface AgHistogramSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgHistogramSeriesThemeableOptions;
}
export interface AgHeatmapSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgHeatmapSeriesThemeableOptions;
}
export interface AgWaterfallSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgWaterfallSeriesThemeableOptions;
}
export interface AgRangeBarSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgRangeBarSeriesThemeableOptions;
}
export interface AgRangeAreaSeriesThemeOverrides extends AgBaseCartesianThemeOptions {
    series?: AgRangeAreaSeriesThemeableOptions;
}
export interface AgDonutSeriesThemeOverrides extends AgBaseThemeableChartOptions {
    series?: AgDonutSeriesThemeableOptions;
}
export interface AgPieSeriesThemeOverrides extends AgBaseThemeableChartOptions {
    series?: AgPieSeriesThemeableOptions;
}
export interface AgRadarLineSeriesThemeOverrides extends AgBasePolarThemeOptions {
    series?: AgRadarSeriesThemeableOptions;
}
export interface AgRadarAreaSeriesThemeOverrides extends AgBasePolarThemeOptions {
    series?: AgRadarAreaSeriesThemeableOptions;
}
export interface AgRadialBarSeriesThemeOverrides extends AgBasePolarThemeOptions {
    series?: AgRadialBarSeriesThemeableOptions;
}
export interface AgRadialColumnSeriesThemeOverrides extends AgBasePolarThemeOptions {
    series?: AgRadialColumnSeriesThemeableOptions;
}
export interface AgNightingaleSeriesThemeOverrides extends AgBasePolarThemeOptions {
    series?: AgNightingaleSeriesThemeableOptions;
}
export interface AgSunburstSeriesThemeOverrides extends AgBaseHierarchyThemeOptions {
    series?: AgSunburstSeriesThemeableOptions;
}
export interface AgTreemapSeriesThemeOverrides extends AgBaseHierarchyThemeOptions {
    series?: AgTreemapSeriesThemeableOptions;
}
export interface AgMapShapeSeriesThemeOverrides extends AgBaseTopologyThemeOptions {
    series?: AgMapShapeSeriesThemeableOptions;
}
export interface AgMapLineSeriesThemeOverrides extends AgBaseTopologyThemeOptions {
    series?: AgMapLineSeriesThemeableOptions;
}
export interface AgMapMarkerSeriesThemeOverrides extends AgBaseTopologyThemeOptions {
    series?: AgMapMarkerSeriesThemeableOptions;
}
export interface AgMapShapeBackgroundThemeOverrides extends AgBaseTopologyThemeOptions {
    series?: AgMapShapeBackgroundThemeableOptions;
}
export interface AgMapLineBackgroundThemeOverrides extends AgBaseTopologyThemeOptions {
    series?: AgMapLineBackgroundThemeableOptions;
}
export interface AgSankeyThemeOverrides extends AgBaseFlowProportionThemeOptions {
    series?: AgSankeySeriesThemeableOptions;
}
export interface AgChordThemeOverrides extends AgBaseFlowProportionThemeOptions {
    series?: AgChordSeriesThemeableOptions;
}
export interface AgPyramidThemeOverrides extends AgBaseStandaloneThemeOptions {
    series?: AgPyramidSeriesThemeableOptions;
}
export type AgBaseGaugePresetThemeOptions = Pick<AgBaseChartOptions<any>, 'animation' | 'background' | 'container' | 'contextMenu' | 'footnote' | 'height' | 'listeners' | 'locale' | 'minHeight' | 'minWidth' | 'padding' | 'subtitle' | 'title' | 'tooltip' | 'width'>;
type AgRadialGaugeTheme = AgBaseGaugePresetThemeOptions & AgRadialGaugeThemeableOptions;
export interface AgRadialGaugeTargetTheme extends Omit<AgRadialGaugeTarget, 'value' | 'text'> {
}
export interface AgRadialGaugeThemeOverrides extends AgRadialGaugeTheme {
    targets?: AgRadialGaugeTargetTheme;
}
type AgLinearGaugeTheme = AgBaseGaugePresetThemeOptions & AgLinearGaugeThemeableOptions;
export interface AgLinearGaugeTargetTheme extends Omit<AgLinearGaugeTarget, 'value' | 'text'> {
}
export interface AgLinearGaugeThemeOverrides extends AgLinearGaugeTheme {
    targets?: AgLinearGaugeTargetTheme;
}
export interface AgCommonThemeableAxisOptions extends AgCartesianAxesTheme, AgPolarAxesTheme {
}
export interface AgCommonThemeableChartOptions extends AgBaseThemeableChartOptions {
    axes?: AgCommonThemeableAxisOptions;
    annotations?: AgAnnotationsThemeableOptions;
    chartToolbar?: AgChartToolbarThemeableOptions;
    initialState?: AgInitialStateThemeableOptions;
    locale?: AgLocaleThemeableOptions;
}
export type AgGaugeThemeOverrides = AgRadialGaugeThemeOverrides | AgLinearGaugeThemeOverrides;
export interface AgChartThemeOverrides {
    /** Common theme overrides for series. */
    common?: AgCommonThemeableChartOptions;
    /** Line series theme overrides. */
    line?: AgLineSeriesThemeOverrides;
    /** Scatter series theme overrides. */
    scatter?: AgScatterSeriesThemeOverrides;
    /** Bubble series theme overrides. */
    bubble?: AgBubbleSeriesThemeOverrides;
    /** Area series theme overrides. */
    area?: AgAreaSeriesThemeOverrides;
    /** Bar series theme overrides. */
    bar?: AgBarSeriesThemeOverrides;
    /** Box-plot series theme overrides. */
    'box-plot'?: AgBoxPlotSeriesThemeOverrides;
    /** Candlestick series theme overrides. */
    candlestick?: AgCandlestickSeriesThemeOverrides;
    /** Cone Funnel series theme overrides. */
    'cone-funnel'?: AgConeFunnelSeriesThemeOverrides;
    /** Funnel series theme overrides. */
    funnel?: AgFunnelSeriesThemeOverrides;
    /** ohlc series theme overrides. */
    ohlc?: AgOhlcSeriesThemeOverrides;
    /** Histogram series theme overrides. */
    histogram?: AgHistogramSeriesThemeOverrides;
    /** Heatmap series theme overrides. */
    heatmap?: AgHeatmapSeriesThemeOverrides;
    /** Waterfall series theme overrides. */
    waterfall?: AgWaterfallSeriesThemeOverrides;
    /** Range-bar series theme overrides. */
    'range-bar'?: AgRangeBarSeriesThemeOverrides;
    /** Range-area series theme overrides. */
    'range-area'?: AgRangeAreaSeriesThemeOverrides;
    /** Donut series theme overrides. */
    donut?: AgDonutSeriesThemeOverrides;
    /** Pie series theme overrides. */
    pie?: AgPieSeriesThemeOverrides;
    /** Radar-line series theme overrides. */
    'radar-line'?: AgRadarLineSeriesThemeOverrides;
    /** Radar-area series theme overrides. */
    'radar-area'?: AgRadarAreaSeriesThemeOverrides;
    /** Radial-bar series theme overrides. */
    'radial-bar'?: AgRadialBarSeriesThemeOverrides;
    /** Radial-column series theme overrides. */
    'radial-column'?: AgRadialColumnSeriesThemeOverrides;
    /** Nightingale series theme overrides. */
    nightingale?: AgNightingaleSeriesThemeOverrides;
    /** Sunburst series theme overrides. */
    sunburst?: AgSunburstSeriesThemeOverrides;
    /** Treemap series theme overrides. */
    treemap?: AgTreemapSeriesThemeOverrides;
    /** Map shape series theme overrides. */
    'map-shape'?: AgMapShapeSeriesThemeOverrides;
    /** Map line series theme overrides. */
    'map-line'?: AgMapLineSeriesThemeOverrides;
    /** Map marker series theme overrides. */
    'map-marker'?: AgMapMarkerSeriesThemeOverrides;
    /** Map shape background series theme overrides. */
    'map-shape-background'?: AgMapShapeBackgroundThemeOverrides;
    /** Map line background series theme overrides. */
    'map-line-background'?: AgMapLineBackgroundThemeOverrides;
    /** Sankey series theme overrides. */
    sankey?: AgSankeyThemeOverrides;
    /** Chord series theme overrides. */
    chord?: AgChordThemeOverrides;
    /** Pyramid series theme overrides. */
    pyramid?: AgPyramidThemeOverrides;
}
export interface AgPresetOverrides {
    /** Radial gauge theme overrides. */
    'radial-gauge'?: AgRadialGaugeThemeOverrides;
    /** Linear Gauge theme overrides. */
    'linear-gauge'?: AgLinearGaugeThemeOverrides;
}
export interface AgThemeOverrides extends AgChartThemeOverrides, AgPresetOverrides {
}
export {};
