import type { AgIconName } from './icons';
export interface ToolbarButton {
    /** Icon to display on the button. */
    icon?: AgIconName;
    /** Text label to display on the button. */
    label?: string;
    /** Text label to announce in screen readers. */
    ariaLabel?: string;
    /** Tooltip text to display on hover over the button. */
    tooltip?: string;
}
export interface ToolbarSwitch extends ToolbarButton {
    /** Overrides for the switch-button when checked. */
    checkedOverrides?: ToolbarButton;
}
