import { _ModuleSupport } from 'ag-charts-community';
import { DatumUnion } from '../gauge-util/datumUnion';
import { type UnknownGaugeNodeDatum } from '../gauge-util/properties';
import { type LinearGaugeLabelDatum, LinearGaugeLabelProperties, type LinearGaugeNodeDatum, type LinearGaugeNodeDatumIndex, LinearGaugeSeriesProperties, type LinearGaugeTargetDatum } from './linearGaugeSeriesProperties';
interface LinearGaugeNodeDataContext extends _ModuleSupport.SeriesNodeDataContext<LinearGaugeNodeDatumIndex, LinearGaugeNodeDatum, LinearGaugeLabelDatum> {
    targetData: LinearGaugeTargetDatum[];
    scaleData: LinearGaugeNodeDatum[];
}
export declare class LinearGaugeSeries extends _ModuleSupport.Series<LinearGaugeNodeDatumIndex, LinearGaugeNodeDatum, LinearGaugeSeriesProperties, LinearGaugeLabelDatum, LinearGaugeNodeDataContext> implements _ModuleSupport.LinearGaugeSeries {
    static readonly className = "LinearGaugeSeries";
    static readonly type: "linear-gauge";
    canHaveAxes: boolean;
    properties: LinearGaugeSeriesProperties;
    originX: number;
    originY: number;
    get horizontal(): boolean;
    get thickness(): number;
    computeInset(direction: _ModuleSupport.ChartAxisDirection, ticks: number[]): number;
    private readonly scaleGroup;
    private readonly itemGroup;
    private readonly itemTargetGroup;
    private readonly itemTargetLabelGroup;
    private readonly itemLabelGroup;
    private readonly highlightTargetGroup;
    private scaleSelection;
    private datumSelection;
    targetSelection: _ModuleSupport.Selection<_ModuleSupport.Marker, LinearGaugeTargetDatum>;
    private targetLabelSelection;
    private labelSelection;
    private highlightTargetSelection;
    datumUnion: DatumUnion<_ModuleSupport.Rect, LinearGaugeNodeDatum>;
    private readonly animationState;
    contextNodeData?: LinearGaugeNodeDataContext;
    constructor(moduleCtx: _ModuleSupport.ModuleContext);
    get hasData(): boolean;
    private nodeFactory;
    private markerFactory;
    processData(): void;
    private formatLabel;
    private createLinearGradient;
    private getTargets;
    private getTargetPoint;
    private getTargetLabel;
    labelDatum(label: LinearGaugeLabelProperties, value: number): LinearGaugeLabelDatum;
    createNodeData(): {
        itemId: string;
        nodeData: LinearGaugeNodeDatum[];
        targetData: LinearGaugeTargetDatum[];
        labelData: LinearGaugeLabelDatum[];
        scaleData: LinearGaugeNodeDatum[];
    } | undefined;
    updateSelections(resize: boolean): void;
    private highlightDatum;
    update({ seriesRect }: {
        seriesRect?: _ModuleSupport.BBox;
    }): void;
    private updateDatumSelection;
    private updateDatumNodes;
    private updateScaleSelection;
    private updateScaleNodes;
    private updateTargetSelection;
    private updateTargetNodes;
    private updateTargetLabelSelection;
    private updateTargetLabelNodes;
    private updateLabelSelection;
    private updateLabelNodes;
    labelsHaveExplicitText(): boolean;
    formatLabelText(datum?: {
        label: number;
    }): void;
    protected resetAllAnimation(): void;
    resetAnimation(phase: _ModuleSupport.ChartAnimationPhase): void;
    private animateLabelText;
    animateEmptyUpdateReady(): void;
    animateWaitingUpdateReady(): void;
    protected animateReadyResize(): void;
    getSeriesDomain(): number[];
    getSeriesRange(_direction: _ModuleSupport.ChartAxisDirection, _visibleRange: [any, any]): [number, number];
    getLegendData(): _ModuleSupport.ChartLegendDatum<_ModuleSupport.ChartLegendType>[];
    getTooltipContent(nodeDatum: UnknownGaugeNodeDatum): _ModuleSupport.TooltipContent | undefined;
    pickNodeClosestDatum(point: _ModuleSupport.Point): _ModuleSupport.SeriesNodePickMatch | undefined;
    pickFocus(opts: _ModuleSupport.PickFocusInputs): _ModuleSupport.PickFocusOutputs | undefined;
    getCaptionText(): string;
}
export {};
