import { type AgZoomAnchorPoint, _ModuleSupport } from 'ag-charts-community';
import { ZoomToolbar } from './zoomToolbar';
interface ZoomAutoScale {
    enabled: boolean;
    padding: number;
}
declare class ZoomAutoScaling extends _ModuleSupport.BaseProperties implements ZoomAutoScale {
    protected onChange: (opts: ZoomAutoScale) => void;
    constructor(onChange: (opts: ZoomAutoScale) => void);
    enabled: boolean;
    padding: number;
}
export declare class Zoom extends _ModuleSupport.BaseModuleInstance implements _ModuleSupport.ModuleInstance {
    private readonly ctx;
    enabled: boolean;
    enableAxisDragging: boolean;
    enableDoubleClickToReset: boolean;
    enableIndependentAxes?: boolean;
    enablePanning: boolean;
    enableScrolling: boolean;
    enableSelecting: boolean;
    enableTwoFingerZoom: boolean;
    panKey: 'alt' | 'ctrl' | 'meta' | 'shift';
    axes: 'x' | 'y' | 'xy';
    scrollingStep: number;
    keepAspectRatio: boolean;
    minVisibleItems: number;
    minVisibleItemsX?: number;
    minVisibleItemsY?: number;
    anchorPointX: AgZoomAnchorPoint;
    anchorPointY: AgZoomAnchorPoint;
    readonly autoScaling: ZoomAutoScaling;
    buttons: ZoomToolbar;
    private seriesRect?;
    private paddedRect?;
    private readonly axisDragger;
    private readonly contextMenu;
    private readonly panner;
    private readonly selector;
    private readonly scroller;
    private readonly scrollPanner;
    private readonly twoFingers;
    private readonly domProxy;
    deceleration: number | 'off' | 'short' | 'long';
    private dragState;
    private hoveredAxis?;
    private shouldFlipXY?;
    private readonly isState;
    private destroyContextMenuActions;
    private isFirstWheelEvent;
    private readonly debouncedWheelReset;
    constructor(ctx: _ModuleSupport.ModuleContext);
    private teardown;
    private onEnabledChange;
    private isIgnoredTouch;
    private onDoubleClick;
    private onDragStart;
    private onDragMove;
    private onDragEnd;
    private onNavZoom;
    private onWheel;
    private onWheelPanning;
    private onWheelScrolling;
    private onAxisDragStart;
    private onTouchStart;
    private onTouchMove;
    private onTouchEnd;
    private onProcessData;
    private onLayoutComplete;
    private onZoomChange;
    private onZoomPanStart;
    private onPanUpdate;
    private isPanningKeyPressed;
    private isScalingX;
    private isScalingY;
    private getAnchorPointX;
    private getAnchorPointY;
    private isMaxZoom;
    private isZoomValid;
    private isAxisZoomValid;
    private resetZoom;
    private updateZoom;
    private updateUnifiedZoom;
    private updatePrimaryAxisZooms;
    private updatePrimaryAxisZoom;
    private updateAxisZoom;
    private getZoom;
    private getResetZoom;
    private getModuleProperties;
}
export {};
