import type { AgCandlestickSeriesItemOptions, AgCandlestickSeriesItemStylerParams, AgCandlestickSeriesTooltipRendererParams, AgOhlcSeriesBaseOptions, AgOhlcSeriesItemOptions, AgOhlcSeriesItemStylerParams, AgOhlcSeriesOptions, AgOhlcSeriesTooltipRendererParams, FillOptions, LineDashOptions, StrokeOptions, Styler } from 'ag-charts-community';
import { _ModuleSupport } from 'ag-charts-community';
declare const BaseProperties: typeof _ModuleSupport.BaseProperties, AbstractBarSeriesProperties: typeof _ModuleSupport.AbstractBarSeriesProperties;
declare class OhlcSeriesItem extends BaseProperties {
    stroke: string;
    strokeWidth: number;
    strokeOpacity: number;
    lineDash: number[];
    lineDashOffset: number;
}
declare class OhlcSeriesItems extends BaseProperties {
    readonly up: OhlcSeriesItem;
    readonly down: OhlcSeriesItem;
}
export declare abstract class OhlcSeriesBaseProperties<T extends AgOhlcSeriesBaseOptions> extends AbstractBarSeriesProperties<T> {
    abstract item: Record<'up' | 'down', FillOptions & StrokeOptions & LineDashOptions>;
    xKey: string;
    openKey: string;
    closeKey: string;
    highKey: string;
    lowKey: string;
    xName?: string;
    yName?: string;
    openName?: string;
    closeName?: string;
    highName?: string;
    lowName?: string;
    abstract readonly tooltip: _ModuleSupport.SeriesTooltip<AgOhlcSeriesTooltipRendererParams<any> & AgCandlestickSeriesTooltipRendererParams<any>>;
    abstract itemStyler?: Styler<AgOhlcSeriesItemStylerParams<unknown>, AgOhlcSeriesItemOptions> & Styler<AgCandlestickSeriesItemStylerParams<unknown>, AgCandlestickSeriesItemOptions>;
}
export declare class OhlcSeriesProperties extends OhlcSeriesBaseProperties<AgOhlcSeriesOptions> {
    readonly tooltip: _ModuleSupport.SeriesTooltip<AgOhlcSeriesTooltipRendererParams<any>>;
    readonly item: OhlcSeriesItems;
    itemStyler?: Styler<AgOhlcSeriesItemStylerParams<unknown>, AgOhlcSeriesItemOptions>;
}
export {};
