"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// packages/ag-charts-enterprise/src/main-modules.ts
var main_modules_exports = {};
__export(main_modules_exports, {
  FlowProportionChartModule: () => FlowProportionChartModule,
  GaugeChartModule: () => GaugeChartModule,
  HierarchyChartModule: () => HierarchyChartModule,
  ModuleRegistry: () => ModuleRegistry,
  StandaloneChartModule: () => StandaloneChartModule,
  TopologyChartModule: () => TopologyChartModule
});
module.exports = __toCommonJS(main_modules_exports);
var import_ag_charts_community11 = require("ag-charts-community");

// packages/ag-charts-enterprise/src/charts/flowProportionChartModule.ts
var import_ag_charts_community2 = require("ag-charts-community");

// packages/ag-charts-enterprise/src/charts/flowProportionChart.ts
var import_ag_charts_community = require("ag-charts-community");
var { Chart } = import_ag_charts_community._ModuleSupport;
function isFlowProportion(series) {
  return series.type === "sankey" || series.type === "chord";
}
var FlowProportionChart = class extends Chart {
  getChartType() {
    return "flow-proportion";
  }
  async updateData() {
    await super.updateData();
    const { nodes } = this.getOptions();
    this.series.forEach((series) => {
      if (isFlowProportion(series)) {
        series.setChartNodes(nodes);
      }
    });
  }
  performLayout(ctx) {
    const { seriesRoot, annotationRoot } = this;
    const { layoutBox } = ctx;
    layoutBox.shrink(this.seriesArea.padding.toJson());
    const seriesRect = layoutBox.clone();
    this.seriesRect = seriesRect;
    this.animationRect = seriesRect;
    seriesRoot.visible = this.series.some((s) => s.visible);
    for (const group of [seriesRoot, annotationRoot]) {
      group.translationX = Math.floor(seriesRect.x);
      group.translationY = Math.floor(seriesRect.y);
    }
    this.ctx.layoutManager.emitLayoutComplete(ctx, {
      series: { visible: seriesRoot.visible, rect: seriesRect, paddedRect: seriesRect }
    });
  }
};
FlowProportionChart.className = "FlowProportionChart";
FlowProportionChart.type = "flow-proportion";

// packages/ag-charts-enterprise/src/charts/flowProportionChartModule.ts
var { isAgFlowProportionChartOptions } = import_ag_charts_community2._ModuleSupport;
var FlowProportionChartModule = {
  type: "chart",
  name: "flow-proportion",
  detect: isAgFlowProportionChartOptions,
  create(options, resources) {
    return new FlowProportionChart(options, resources);
  }
};

// packages/ag-charts-enterprise/src/charts/gaugeChartModule.ts
var import_ag_charts_community4 = require("ag-charts-community");

// packages/ag-charts-enterprise/src/charts/gaugeChart.ts
var import_ag_charts_community3 = require("ag-charts-community");

// packages/ag-charts-core/src/globals/logger.ts
var logger_exports = {};
__export(logger_exports, {
  error: () => error,
  errorOnce: () => errorOnce,
  log: () => log,
  logGroup: () => logGroup,
  reset: () => reset,
  table: () => table,
  warn: () => warn,
  warnOnce: () => warnOnce
});
var doOnceCache = /* @__PURE__ */ new Set();
function log(...logContent) {
  console.log(...logContent);
}
function warn(message, ...logContent) {
  console.warn(`AG Charts - ${message}`, ...logContent);
}
function error(message, ...logContent) {
  if (typeof message === "object") {
    console.error(`AG Charts error`, message, ...logContent);
  } else {
    console.error(`AG Charts - ${message}`, ...logContent);
  }
}
function table(...logContent) {
  console.table(...logContent);
}
function warnOnce(message, ...logContent) {
  const cacheKey = `Logger.warn: ${message}`;
  if (doOnceCache.has(cacheKey))
    return;
  warn(message, ...logContent);
  doOnceCache.add(cacheKey);
}
function errorOnce(message, ...logContent) {
  const cacheKey = `Logger.error: ${message}`;
  if (doOnceCache.has(cacheKey))
    return;
  error(message, ...logContent);
  doOnceCache.add(cacheKey);
}
function reset() {
  doOnceCache.clear();
}
function logGroup(name, cb) {
  console.groupCollapsed(name);
  try {
    return cb();
  } finally {
    console.groupEnd();
  }
}

// packages/ag-charts-enterprise/src/charts/gaugeChart.ts
var {
  CartesianAxis,
  Chart: Chart2,
  ChartAxisDirection,
  LinearScale,
  PolarAxis,
  isBetweenAngles,
  normalizeAngle360Inclusive,
  sectorBox
} = import_ag_charts_community3._ModuleSupport;
function isRadialGaugeSeries(series) {
  return series.type === "radial-gauge";
}
function isLinearGaugeSeries(series) {
  return series.type === "linear-gauge";
}
var GaugeChart = class extends Chart2 {
  getChartType() {
    return "gauge";
  }
  updateRadialGauge(seriesRect, series) {
    const angleAxis = this.axes.find((axis) => axis.direction === ChartAxisDirection.X);
    if (!(angleAxis instanceof PolarAxis))
      return;
    angleAxis.computeRange();
    const seriesRectX0 = seriesRect.x;
    const seriesRectX1 = seriesRectX0 + seriesRect.width;
    const seriesRectY0 = seriesRect.y;
    const seriesRectY1 = seriesRectY0 + seriesRect.height;
    const [startAngle, endAngle] = angleAxis.range;
    const sweepAngle = normalizeAngle360Inclusive(endAngle - startAngle);
    const largerThanHalf = sweepAngle > Math.PI;
    const containsTop = largerThanHalf || isBetweenAngles(1.5 * Math.PI, startAngle, endAngle);
    const containsRight = largerThanHalf || isBetweenAngles(0 * Math.PI, startAngle, endAngle);
    const containsBottom = largerThanHalf || isBetweenAngles(0.5 * Math.PI, startAngle, endAngle);
    const containsLeft = largerThanHalf || isBetweenAngles(1 * Math.PI, startAngle, endAngle);
    let textAlign;
    if (containsLeft && !containsRight) {
      textAlign = "right";
    } else if (!containsLeft && containsRight) {
      textAlign = "left";
    } else {
      textAlign = "center";
    }
    let verticalAlign;
    if (containsTop && !containsBottom) {
      verticalAlign = "bottom";
    } else if (!containsTop && containsBottom) {
      verticalAlign = "top";
    } else {
      verticalAlign = "middle";
    }
    const unitBox = sectorBox({
      startAngle,
      endAngle,
      innerRadius: 0,
      outerRadius: 0.5
    });
    const centerXOffset = -(unitBox.x + unitBox.width / 2) * 2;
    const centerYOffset = -(unitBox.y + unitBox.height / 2) * 2;
    const { minimumRadius = 0, maximumRadius } = series;
    const radiusBounds = Math.max(
      0.5 * Math.min(seriesRect.width / unitBox.width, seriesRect.height / unitBox.height),
      // seriesRect may have negative size
      0
    );
    let radius = Math.min(maximumRadius ?? Infinity, Math.max(radiusBounds, minimumRadius ?? 0));
    const MAX_ITERATIONS = 8;
    for (let i = 0; i < MAX_ITERATIONS; i += 1) {
      const isFinalIteration = radius <= minimumRadius || i === MAX_ITERATIONS - 1;
      const centerX = seriesRect.x + seriesRect.width / 2 + centerXOffset * radius;
      const centerY = seriesRect.y + seriesRect.height / 2 + centerYOffset * radius;
      angleAxis.translation.x = centerX;
      angleAxis.translation.y = centerY;
      angleAxis.gridLength = radius;
      angleAxis.calculateLayout();
      const bbox = angleAxis.computeLabelsBBox({ hideWhenNecessary: isFinalIteration }, seriesRect);
      if (isFinalIteration)
        break;
      let shrinkDelta = 0;
      if (bbox != null) {
        const bboxX0 = bbox.x + centerX;
        const bboxX1 = bboxX0 + bbox.width;
        const bboxY0 = bbox.y + centerY;
        const bboxY1 = bboxY0 + bbox.height;
        shrinkDelta = Math.max(
          seriesRectY0 - bboxY0,
          seriesRectX0 - bboxX0,
          bboxY1 - seriesRectY1,
          bboxX1 - seriesRectX1,
          0
        );
      }
      if (shrinkDelta > 0) {
        radius = Math.max(radius - shrinkDelta, minimumRadius);
      } else {
        break;
      }
    }
    angleAxis.translation.x = seriesRect.x + seriesRect.width / 2 + centerXOffset * radius;
    angleAxis.translation.y = seriesRect.y + seriesRect.height / 2 + centerYOffset * radius;
    series.centerX = seriesRect.width / 2 + centerXOffset * radius;
    series.centerY = seriesRect.height / 2 + centerYOffset * radius;
    series.radius = radius;
    series.textAlign = textAlign;
    series.verticalAlign = verticalAlign;
    if (radius === 0 || radius > radiusBounds) {
      logger_exports.warnOnce("There was insufficient space to display the Radial Gauge.");
    }
  }
  updateLinearGauge(seriesRect, series) {
    const xAxis = this.axes.find((axis) => axis.direction === ChartAxisDirection.X);
    const yAxis = this.axes.find((axis) => axis.direction === ChartAxisDirection.Y);
    if (!(xAxis instanceof CartesianAxis))
      return seriesRect;
    if (!(yAxis instanceof CartesianAxis))
      return seriesRect;
    const { horizontal, thickness } = series;
    let horizontalInset = 0;
    let verticalInset = 0;
    const scale = new LinearScale();
    const scaleAxis = horizontal ? xAxis : yAxis;
    scale.domain = [0, 100];
    scale.range = scaleAxis.range;
    const ticks = scale.ticks({
      nice: scaleAxis.nice,
      interval: void 0,
      tickCount: void 0,
      minTickCount: 0,
      maxTickCount: Infinity
    });
    if (horizontal) {
      horizontalInset = series.computeInset(ChartAxisDirection.X, ticks);
    } else {
      verticalInset = series.computeInset(ChartAxisDirection.Y, ticks);
    }
    const seriesWidth = seriesRect.width - Math.abs(horizontalInset);
    const seriesHeight = seriesRect.height - Math.abs(verticalInset);
    const { width, height } = horizontal ? {
      width: Math.max(seriesWidth, 0),
      height: Math.max(Math.min(seriesHeight, thickness), 0)
    } : {
      width: Math.max(Math.min(seriesWidth, thickness), 0),
      height: Math.max(seriesHeight, 0)
    };
    const x0 = seriesRect.x + (seriesWidth - width) / 2 + Math.max(horizontalInset, 0);
    const y0 = seriesRect.y + (seriesHeight - height) / 2 - Math.min(verticalInset, 0);
    xAxis.range = [0, width];
    xAxis.gridLength = width;
    xAxis.calculateLayout();
    xAxis.translation.x = x0;
    xAxis.translation.y = y0 + (xAxis.position === "bottom" ? thickness : 0);
    yAxis.range = [0, height];
    yAxis.gridLength = height;
    yAxis.calculateLayout();
    yAxis.translation.x = x0 + (yAxis.position === "right" ? thickness : 0);
    yAxis.translation.y = y0;
    series.originX = x0 - seriesRect.x;
    series.originY = y0 - seriesRect.y;
    if (width === 0 || height === 0) {
      logger_exports.warnOnce("There was insufficient space to display the Linear Gauge.");
    }
  }
  performLayout(ctx) {
    const { seriesRoot, annotationRoot, series, seriesArea } = this;
    const { layoutBox } = ctx;
    const seriesRect = layoutBox.clone();
    layoutBox.shrink(seriesArea.padding.toJson());
    const firstSeries = this.series[0];
    if (isRadialGaugeSeries(firstSeries)) {
      this.updateRadialGauge(layoutBox, firstSeries);
    } else if (isLinearGaugeSeries(firstSeries)) {
      this.updateLinearGauge(layoutBox, firstSeries);
    }
    this.axes.forEach((axis) => axis.update());
    this.seriesRect = seriesRect.clone().translate(seriesRect.x - layoutBox.x, seriesRect.y - layoutBox.y);
    this.animationRect = layoutBox;
    seriesRoot.visible = series.some((s) => s.visible);
    for (const group of [seriesRoot, annotationRoot]) {
      group.translationX = Math.floor(layoutBox.x);
      group.translationY = Math.floor(layoutBox.y);
    }
    this.ctx.layoutManager.emitLayoutComplete(ctx, {
      series: { visible: seriesRoot.visible, rect: seriesRect, paddedRect: layoutBox }
    });
  }
  getAriaLabel() {
    const captions = [];
    const chartCaption = this.getCaptionText();
    if (chartCaption.length !== 0) {
      captions.push(chartCaption);
    }
    for (const series of this.series) {
      captions.push(series.getCaptionText());
    }
    const caption = captions.join(". ");
    return this.ctx.localeManager.t("ariaAnnounceGaugeChart", { caption });
  }
};
GaugeChart.className = "GaugeChart";
GaugeChart.type = "gauge";

// packages/ag-charts-enterprise/src/charts/gaugeChartModule.ts
var { isAgGaugeChartOptions } = import_ag_charts_community4._ModuleSupport;
var GaugeChartModule = {
  type: "chart",
  name: "gauge",
  detect: isAgGaugeChartOptions,
  create(options, resources) {
    return new GaugeChart(options, resources);
  }
};

// packages/ag-charts-enterprise/src/charts/hierarchyChartModule.ts
var import_ag_charts_community6 = require("ag-charts-community");

// packages/ag-charts-enterprise/src/charts/hierarchyChart.ts
var import_ag_charts_community5 = require("ag-charts-community");
var { Chart: Chart3 } = import_ag_charts_community5._ModuleSupport;
var HierarchyChart = class extends Chart3 {
  getChartType() {
    return "hierarchy";
  }
  performLayout(ctx) {
    const { seriesRoot, annotationRoot } = this;
    const { layoutBox } = ctx;
    layoutBox.shrink(this.seriesArea.padding.toJson());
    const seriesRect = layoutBox.clone();
    this.seriesRect = seriesRect;
    this.animationRect = seriesRect;
    for (const group of [seriesRoot, annotationRoot]) {
      group.translationX = Math.floor(seriesRect.x);
      group.translationY = Math.floor(seriesRect.y);
    }
    seriesRoot.visible = this.series[0].visible;
    seriesRoot.setClipRect(seriesRect.clone());
    this.ctx.layoutManager.emitLayoutComplete(ctx, {
      series: { visible: true, rect: seriesRect, paddedRect: seriesRect }
    });
  }
  getAriaLabel() {
    const caption = this.getCaptionText();
    return this.ctx.localeManager.t("ariaAnnounceHierarchyChart", { caption });
  }
};
HierarchyChart.className = "HierarchyChart";
HierarchyChart.type = "hierarchy";

// packages/ag-charts-enterprise/src/charts/hierarchyChartModule.ts
var { isAgHierarchyChartOptions } = import_ag_charts_community6._ModuleSupport;
var HierarchyChartModule = {
  type: "chart",
  name: "hierarchy",
  detect: isAgHierarchyChartOptions,
  create(options, resources) {
    return new HierarchyChart(options, resources);
  }
};

// packages/ag-charts-enterprise/src/charts/standaloneChartModule.ts
var import_ag_charts_community8 = require("ag-charts-community");

// packages/ag-charts-enterprise/src/charts/standaloneChart.ts
var import_ag_charts_community7 = require("ag-charts-community");
var { Chart: Chart4 } = import_ag_charts_community7._ModuleSupport;
var StandaloneChart = class extends Chart4 {
  getChartType() {
    return "standalone";
  }
  performLayout(ctx) {
    const { seriesRoot, annotationRoot } = this;
    const { layoutBox } = ctx;
    layoutBox.shrink(this.seriesArea.padding.toJson());
    const seriesRect = layoutBox.clone();
    this.seriesRect = seriesRect;
    this.animationRect = seriesRect;
    for (const group of [seriesRoot, annotationRoot]) {
      group.translationX = Math.floor(layoutBox.x);
      group.translationY = Math.floor(layoutBox.y);
    }
    seriesRoot.visible = this.series[0].visible;
    this.ctx.layoutManager.emitLayoutComplete(ctx, {
      series: { visible: true, rect: seriesRect, paddedRect: layoutBox }
    });
  }
  getAriaLabel() {
    const caption = this.getCaptionText();
    return this.ctx.localeManager.t("ariaAnnounceHierarchyChart", { caption });
  }
};
StandaloneChart.className = "StandaloneChart";
StandaloneChart.type = "standalone";

// packages/ag-charts-enterprise/src/charts/standaloneChartModule.ts
var { isAgStandaloneChartOptions } = import_ag_charts_community8._ModuleSupport;
var StandaloneChartModule = {
  type: "chart",
  name: "standalone",
  detect: isAgStandaloneChartOptions,
  create(options, resources) {
    return new StandaloneChart(options, resources);
  }
};

// packages/ag-charts-enterprise/src/charts/topologyChartModule.ts
var import_ag_charts_community10 = require("ag-charts-community");

// packages/ag-charts-enterprise/src/charts/topologyChart.ts
var import_ag_charts_community9 = require("ag-charts-community");
var { Chart: Chart5, MercatorScale, NumberAxis } = import_ag_charts_community9._ModuleSupport;
function isTopologySeries(series) {
  return series.type === "map-shape" || series.type === "map-line" || series.type === "map-marker" || series.type === "map-shape-background" || series.type === "map-line-background";
}
var TopologyChart = class extends Chart5 {
  constructor(options, resources) {
    super(options, resources);
    this.xAxis = new NumberAxis(this.getModuleContext());
    this.xAxis.position = "bottom";
    this.yAxis = new NumberAxis(this.getModuleContext());
    this.yAxis.position = "left";
    this.ctx.zoomManager.updateAxes([this.xAxis, this.yAxis]);
  }
  getChartType() {
    return "topology";
  }
  async updateData() {
    await super.updateData();
    const { topology } = this.getOptions();
    this.series.forEach((series) => {
      if (isTopologySeries(series)) {
        series.setChartTopology(topology);
      }
    });
  }
  performLayout(ctx) {
    const { seriesRoot, annotationRoot } = this;
    const { layoutBox } = ctx;
    layoutBox.shrink(this.seriesArea.padding.toJson());
    const seriesRect = layoutBox.clone();
    this.seriesRect = seriesRect;
    this.animationRect = seriesRect;
    const mapSeries = this.series.filter(isTopologySeries);
    const combinedBbox = mapSeries.reduce((combined, series) => {
      if (!series.visible)
        return combined;
      const bbox = series.topologyBounds;
      if (bbox == null)
        return combined;
      if (combined == null)
        return bbox;
      combined.merge(bbox);
      return combined;
    }, void 0);
    let scale;
    if (combinedBbox != null) {
      const { lon0, lat0, lon1, lat1 } = combinedBbox;
      const domain = [
        [lon0, lat0],
        [lon1, lat1]
      ];
      const bounds = MercatorScale.bounds(domain);
      const { width, height } = seriesRect;
      const viewBoxScale = Math.min(width / bounds.width, height / bounds.height);
      const viewBoxWidth = bounds.width * viewBoxScale;
      const viewBoxHeight = bounds.height * viewBoxScale;
      const viewBoxOriginX = (width - viewBoxWidth) / 2;
      const viewBoxOriginY = (height - viewBoxHeight) / 2;
      const x0 = viewBoxOriginX;
      const y0 = viewBoxOriginY;
      const x1 = viewBoxOriginX + viewBoxWidth;
      const y1 = viewBoxOriginY + viewBoxHeight;
      const xZoom = this.ctx.zoomManager.getAxisZoom(this.xAxis.id);
      const yZoom = this.ctx.zoomManager.getAxisZoom(this.yAxis.id);
      const xSpan = (x1 - x0) / (xZoom.max - xZoom.min);
      const xStart = x0 - xSpan * xZoom.min;
      const ySpan = (y1 - y0) / (1 - yZoom.min - (1 - yZoom.max));
      const yStart = y0 - ySpan * (1 - yZoom.max);
      scale = new MercatorScale(domain, [
        [xStart, yStart],
        [xStart + xSpan, yStart + ySpan]
      ]);
    }
    mapSeries.forEach((series) => {
      series.scale = scale;
    });
    const seriesVisible = this.series.some((s) => s.visible);
    seriesRoot.visible = seriesVisible;
    for (const group of [seriesRoot, annotationRoot]) {
      group.translationX = Math.floor(seriesRect.x);
      group.translationY = Math.floor(seriesRect.y);
      group.setClipRect(seriesRect.clone());
    }
    this.ctx.layoutManager.emitLayoutComplete(ctx, {
      series: { visible: seriesVisible, rect: seriesRect, paddedRect: seriesRect }
    });
  }
};
TopologyChart.className = "TopologyChart";
TopologyChart.type = "topology";

// packages/ag-charts-enterprise/src/charts/topologyChartModule.ts
var { isAgTopologyChartOptions } = import_ag_charts_community10._ModuleSupport;
var TopologyChartModule = {
  type: "chart",
  name: "topology",
  detect: isAgTopologyChartOptions,
  create(options, resources) {
    return new TopologyChart(options, resources);
  }
};

// packages/ag-charts-enterprise/src/main-modules.ts
var ModuleRegistry = import_ag_charts_community11._ModuleSupport.ModuleRegistry;
