/**
 * Converts a value to an array. If the value is already an array, it is returned as-is.
 * @param value - The value to convert.
 * @returns The resulting array.
 */
export declare function toArray<T>(value: T | T[] | undefined): T[];
/**
 * Removes duplicate values from an array.
 * @param array - The array to process.
 * @returns A new array with unique values.
 */
export declare function unique<T>(array: T[]): T[];
/**
 * Groups items in an array by a key generated from the `iteratee` function.
 * @param array - The array to group.
 * @param iteratee - A function that generates the key for each item.
 * @returns An object where the keys are the group keys and the values are arrays of grouped items.
 */
export declare function groupBy<T, R extends string | number | symbol>(array: T[], iteratee: (item: T) => R): { [K in R]?: T[] | undefined; };
/**
 * Compares two arrays for deep equality, including nested arrays.
 * @param a - The first array.
 * @param b - The second array.
 * @returns `true` if the arrays are equal, otherwise `false`.
 */
export declare function arraysEqual(a: readonly any[], b: readonly any[]): boolean;
/**
 * Creates a circular slice of an array.
 * @param data - The source array.
 * @param size - The size of the slice.
 * @param offset - The starting index for the slice (default is 0).
 * @returns A circular slice of the array.
 */
export declare function circularSliceArray<T>(data: T[], size: number, offset?: number): T[];
/**
 * Sorts a base array according to the order defined in a reference array.
 * @param baseArray - The array to sort.
 * @param orderArray - The array defining the desired order.
 * @returns The sorted array.
 */
export declare function sortBasedOnArray<T>(baseArray: T[], orderArray: T[]): T[];
